# 知识库评估使用与开发指南

知识库评估功能用于测试 RAG 系统的检索和生成质量。通过预设的测试问题和标准答案（或自动生成评估），量化评估系统在不同场景下的表现。

**适用场景**：验证知识库上线前的效果、对比不同配置下的检索效果、定期监控知识库质量变化、调优检索参数。

**注意**：当前版本支持 Milvus 类型的知识库。

## 如何创建评估基准

### 1. 上传评估文件

准备 JSONL 格式的文件，每行一个测试样本：

```json
{"query": "什么是人工智能？", "gold_chunk_ids": ["chunk_001", "chunk_002"], "gold_answer": "人工智能是计算机科学的一个分支"}
{"query": "机器学习的主要类型有哪些？", "gold_chunk_ids": ["chunk_005"], "gold_answer": "主要包括监督学习、无监督学习和强化学习"}
{"query": "深度学习的应用领域", "gold_chunk_ids": ["chunk_010", "chunk_011"]}
```

**字段说明**：
- `query`（必需）：测试问题，用于触发 RAG 系统的检索
- `gold_chunk_ids`（可选）：相关文档块的 ID 列表，用于验证检索效果
- `gold_answer`（可选）：标准答案，用于验证生成效果

::: tip 数据集构建
可以使用 [EasyDataset](https://github.com/ConardLi/easy-dataset) 从文档批量生成问答对、可视化编辑、导出多种格式和数据质量检查。挺好用的，推荐。注意导出的时候的字段需要修改为 `query`、`gold_answer`。
:::


### 2. 自动生成评估基准

Yuxi 也实现了一个简易的、可以基于现有知识库自动生成测试数据。流程是：随机采样一个 chunk → 用嵌入模型找相似 chunk → 用 LLM 生成问题和答案。

**推荐参数设置**：
- 问题数量：10-50 个
- 相似文档数：每个问题 2-5 个

## 运行评估任务

1. 选择评估基准后在知识库页面点击"评估"标签

2. 配置参数：
   - **答案生成模型（可选）**：如果选择了，则会基于检索的 chunk 生成答案，然后用评判模型评估答案的准确性
   - **评判模型（可选）**：如果选择了，则会用评判模型评估答案的准确性，判断是否与标准答案一致，因此选择评判模型时，必须选择答案生成模型。

3. 点击"开始评估"：
系统会逐个处理测试问题，执行检索和生成，计算各项指标。评估在后台运行，可以继续其他操作。

**主要指标**：

| 指标 | 含义 | 如何看待 |
|------|------|----------|
| Recall@1 | 第一个结果包含正确文档的比例 | 最重要的指标，反映用户第一眼看到的准确率 |
| Recall@5 | 前5个结果包含正确文档的比例 | 综合检索效果，应该大于 0.8 |
| F1@K | 精确率和召回率的调和平均 | 平衡指标，用于对比不同配置 |
| 答案准确性 | 生成答案是否与标准答案一致 | 检查 LLM 理解和表达能力 |
