/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.meta;

import ExtraUtilities.worlds.blocks.turret.Cobweb;
import arc.struct.Seq;
import mindustry.gen.Unit;

public class TurretManager {
    private final Seq<Cobweb.CobwebBuild> turrets = new Seq();
    private final Seq<Unit> enemies = new Seq();

    public void addTurret(Cobweb.CobwebBuild turret) {
        this.turrets.addUnique((Object)turret);
    }

    public void addEnemy(Unit enemy) {
        this.enemies.addUnique((Object)enemy);
    }

    public void update() {
        this.turrets.removeAll(t -> t == null || t.dead() || !t.isAdded());
        this.turrets.sort(t -> -t.efficiency);
        this.enemies.removeAll(u -> u == null || u.dead() || !u.isAdded());
        this.enemies.sort(e -> -e.vel.len());
        this.updateTurrets();
    }

    public void updateTurrets() {
        Seq lockedEnemies = new Seq();
        for (Cobweb.CobwebBuild turret : this.turrets) {
            turret.updateTarget(this.enemies, (Seq<Unit>)lockedEnemies);
            if (turret.target == null) continue;
            lockedEnemies.add((Object)turret.target);
        }
    }
}

