/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.meta;

import ExtraUtilities.content.EUGet;
import ExtraUtilities.ui.ItemDisplay;
import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Styles;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.StatValues;

public class EUStatValues {
    public static StatValue stringBoosters(float reload, float maxUsed, float multiplier, boolean baseReload, Boolf<Liquid> filter, String key) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get((Object)liquid)) continue;
                    c.image(liquid.uiIcon).size(24.0f).scaling(Scaling.fit).padRight(4.0f).right().top();
                    c.add((CharSequence)liquid.localizedName).padRight(10.0f).left().top();
                    c.table(Tex.underline, bt -> {
                        bt.left().defaults().padRight(3.0f).left();
                        float reloadRate = (baseReload ? 1.0f : 0.0f) + maxUsed * multiplier * liquid.heatCapacity;
                        float standardReload = baseReload ? reload : reload / (maxUsed * multiplier * 0.4f);
                        float result = standardReload / (reload / reloadRate);
                        bt.add((CharSequence)Core.bundle.format(key, new Object[]{Strings.autoFixed((float)result, (int)2)}));
                    }).left().padTop(-9.0f);
                    c.row();
                }
            }).colspan(table.getColumns());
            table.row();
        };
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType[]> map, boolean all) {
        return EUStatValues.ammo(map, 0, false, all);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType[]> map, boolean showUnit, boolean all) {
        return EUStatValues.ammo(map, 0, showUnit, all);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType[]> map, int indent, boolean showUnit, boolean all) {
        return table -> {
            table.row();
            Seq orderedKeys = map.keys().toSeq();
            orderedKeys.sort();
            for (UnlockableContent t : orderedKeys) {
                boolean compact;
                boolean bl = compact = t instanceof UnitType && !showUnit || indent > 0;
                if (!compact && !(t instanceof Turret)) {
                    table.table(item -> {
                        item.image(EUStatValues.icon(t)).size(24.0f).padRight(4.0f).left().top().with(i -> StatValues.withTooltip((Element)i, (UnlockableContent)t, (boolean)false));
                        item.add((CharSequence)t.localizedName).padRight(10.0f).left().top();
                    }).left().pad(10.0f);
                }
                table.row();
                table.table(tip -> {
                    if (all) {
                        tip.add((CharSequence)Core.bundle.get("stat.eu-multi-all")).left();
                    } else {
                        tip.add((CharSequence)Core.bundle.get("stat.eu-multi-flow")).left();
                    }
                }).left().padBottom(5.0f);
                table.row();
                for (BulletType type : (BulletType[])map.get((Object)t)) {
                    if (type.spawnUnit != null && type.spawnUnit.weapons.size > 0) {
                        EUStatValues.ammo(ObjectMap.of((Object[])new Object[]{t, ((Weapon)type.spawnUnit.weapons.first()).bullet}), indent, false, all).display(table);
                        return;
                    }
                    ((Table)table.table(bt -> {
                        Collapser coll;
                        bt.left().defaults().padRight(3.0f).left();
                        if (type.damage > 0.0f && (type.collides || type.splashDamage <= 0.0f)) {
                            if (type.continuousDamage() > 0.0f) {
                                bt.add((CharSequence)(Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.continuousDamage())}) + StatUnit.perSecond.localized()));
                            } else {
                                bt.add((CharSequence)Core.bundle.format("bullet.damage", new Object[]{Float.valueOf(type.damage)}));
                            }
                        }
                        if (type.buildingDamageMultiplier != 1.0f) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.buildingdamage", new Object[]{(int)(type.buildingDamageMultiplier * 100.0f)}));
                        }
                        if (type.rangeChange != 0.0f && !compact) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.range", new Object[]{(type.rangeChange > 0.0f ? "+" : "-") + Strings.autoFixed((float)(type.rangeChange / 8.0f), (int)1)}));
                        }
                        if (type.splashDamage > 0.0f) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.splashdamage", new Object[]{(int)type.splashDamage, Strings.fixed((float)(type.splashDamageRadius / 8.0f), (int)1)}));
                        }
                        if (!(compact || Mathf.equal((float)type.ammoMultiplier, (float)1.0f) || !type.displayAmmoMultiplier || t instanceof Turret && !((Turret)t).displayAmmoMultiplier)) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.multiplier", new Object[]{(int)type.ammoMultiplier}));
                        }
                        if (!compact && !Mathf.equal((float)type.reloadMultiplier, (float)1.0f)) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.reload", new Object[]{Strings.autoFixed((float)(type.reloadMultiplier * 100.0f), (int)2)}));
                        }
                        if (type.knockback > 0.0f) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.knockback", new Object[]{Strings.autoFixed((float)type.knockback, (int)2)}));
                        }
                        if (type.healPercent > 0.0f) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.healpercent", new Object[]{Strings.autoFixed((float)type.healPercent, (int)2)}));
                        }
                        if (type.healAmount > 0.0f) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.healamount", new Object[]{Strings.autoFixed((float)type.healAmount, (int)2)}));
                        }
                        if (type.pierce || type.pierceCap != -1) {
                            EUStatValues.sep(bt, type.pierceCap == -1 ? "@bullet.infinitepierce" : Core.bundle.format("bullet.pierce", new Object[]{type.pierceCap}));
                        }
                        if (type.incendAmount > 0) {
                            EUStatValues.sep(bt, "@bullet.incendiary");
                        }
                        if (type.homingPower > 0.01f) {
                            EUStatValues.sep(bt, "@bullet.homing");
                        }
                        if (type.lightning > 0) {
                            EUStatValues.sep(bt, Core.bundle.format("bullet.lightning", new Object[]{type.lightning, Float.valueOf(type.lightningDamage < 0.0f ? type.damage : type.lightningDamage)}));
                        }
                        if (type.pierceArmor) {
                            EUStatValues.sep(bt, "@bullet.armorpierce");
                        }
                        if (type.status != StatusEffects.none) {
                            EUStatValues.sep(bt, (type.status.minfo.mod == null ? type.status.emoji() : "") + "[stat]" + type.status.localizedName + "[lightgray] ~ [stat]" + (int)(type.statusDuration / 60.0f) + "[lightgray] " + Core.bundle.get("unit.seconds"));
                        }
                        if (type.intervalBullet != null) {
                            bt.row();
                            Table ic = new Table();
                            StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{t, type.intervalBullet}), (boolean)true, (boolean)false).display(ic);
                            coll = new Collapser(ic, true);
                            coll.setDuration(0.1f);
                            bt.table(it -> {
                                it.left().defaults().left();
                                it.add((CharSequence)Core.bundle.format("bullet.interval", new Object[]{Strings.autoFixed((float)((float)type.intervalBullets / type.bulletInterval * 60.0f), (int)2)}));
                                it.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                    i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                                }).size(8.0f).padLeft(16.0f).expandX();
                            });
                            bt.row();
                            bt.add((Element)coll);
                        }
                        if (type.fragBullet != null) {
                            bt.row();
                            Table fc = new Table();
                            StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{t, type.fragBullet}), (boolean)true, (boolean)false).display(fc);
                            coll = new Collapser(fc, true);
                            coll.setDuration(0.1f);
                            bt.table(ft -> {
                                ft.left().defaults().left();
                                ft.add((CharSequence)Core.bundle.format("bullet.frags", new Object[]{type.fragBullets}));
                                ft.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                    i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                                }).size(8.0f).padLeft(16.0f).expandX();
                            });
                            bt.row();
                            bt.add((Element)coll);
                        }
                    }).padTop(compact ? 0.0f : -9.0f).padLeft((float)(indent * 8)).left().get()).background(compact ? null : Tex.underline);
                    table.row();
                }
            }
        };
    }

    private static void sep(Table table, String text) {
        table.row();
        table.add((CharSequence)text);
    }

    private static TextureRegion icon(UnlockableContent t) {
        return t.uiIcon;
    }

    public static StatValue colorString(Color color, CharSequence s) {
        return table -> {
            table.row();
            table.table(c -> {
                c.image(((TextureRegionDrawable)Tex.whiteui).tint(color)).size(32.0f).scaling(Scaling.fit).padRight(4.0f).left().top();
                c.add(s).padRight(10.0f).left().top();
            }).left();
            table.row();
        };
    }

    public static <T extends UnlockableContent> StatValue ammoString(ObjectMap<T, BulletType> map, String add) {
        return table -> {
            for (UnlockableContent i : map.keys()) {
                table.row();
                table.table(c -> {
                    c.image(EUStatValues.icon(i)).size(32.0f).scaling(Scaling.fit).padRight(4.0f).left().top();
                    c.add((CharSequence)Core.bundle.get("stat-" + add + "-" + i.name + ".ammo")).padRight(10.0f).left().top();
                    c.background(Tex.underline);
                }).left();
                table.row();
            }
        };
    }

    public static StatValue ammoString(Item i, String add) {
        return table -> {
            table.row();
            table.table(c -> {
                c.image(EUStatValues.icon((UnlockableContent)i)).size(32.0f).scaling(Scaling.fit).padRight(4.0f).left().top();
                c.add((CharSequence)Core.bundle.get("stat-" + add + "-" + i.name + ".ammo")).padRight(10.0f).left().top();
                c.background(Tex.underline);
            }).left();
            table.row();
        };
    }

    public static StatValue itemRangeBoosters(String unit, float timePeriod, StatusEffect[] status, float rangeBoost, ItemStack[] items, boolean replace, Boolf<Item> filter) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Item item : Vars.content.items()) {
                    if (!filter.get((Object)item)) continue;
                    c.table(Styles.grayPanel, b -> {
                        for (ItemStack stack : items) {
                            if (timePeriod < 0.0f) {
                                b.add((Element)new ItemDisplay(stack.item, stack.amount, true)).pad(20.0f).left();
                            } else {
                                b.add((Element)new ItemDisplay(stack.item, stack.amount, timePeriod, true)).pad(20.0f).left();
                            }
                            if (items.length <= 1) continue;
                            b.row();
                        }
                        b.table(bt -> {
                            bt.left().defaults().left();
                            if (status.length > 0) {
                                for (StatusEffect s : status) {
                                    if (s == StatusEffects.none) continue;
                                    bt.row();
                                    bt.add((Element)EUGet.selfStyleImageButton((Drawable)new TextureRegionDrawable(s.uiIcon), Styles.emptyi, () -> Vars.ui.content.show((UnlockableContent)s))).padTop(2.0f).padBottom(6.0f).size(42.0f);
                                    bt.add((CharSequence)s.localizedName).padLeft(5.0f);
                                }
                                if (replace) {
                                    bt.row();
                                    bt.add((CharSequence)Core.bundle.get("statValue.replace"));
                                }
                            }
                            bt.row();
                            if (rangeBoost != 0.0f) {
                                bt.add((CharSequence)("[lightgray]+[stat]" + Strings.autoFixed((float)(rangeBoost / 8.0f), (int)2) + "[lightgray] " + StatUnit.blocks.localized())).row();
                            }
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).padBottom(-5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue ability(String name, int abs) {
        return table -> {
            table.row();
            int i = 0;
            while (i < abs) {
                int finalI = i++;
                table.table(c -> c.add((CharSequence)(Core.bundle.format("stat-abi", new Object[]{finalI + 1}) + " " + Core.bundle.get("stat-" + name + ".abi-" + finalI + ".name"))).padRight(10.0f).left().top()).left();
                table.row();
                table.table(c -> {
                    c.add((CharSequence)Core.bundle.get("stat-" + name + ".abi-" + finalI + ".description")).padRight(10.0f).left().top();
                    c.row();
                    c.background(Tex.underline);
                }).left();
                table.row();
            }
        };
    }
}

