/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUBulletTypes;
import ExtraUtilities.content.EUGet;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Teamc;
import mindustry.graphics.Trail;

public class RainbowStorm
extends BulletType {
    public float size;
    public float laserDamage;
    public float laserLength = 24.0f;
    public int laserAmount = 24;
    public boolean inAmi = true;
    public float inTime = 30.0f;
    public boolean fadeOut = true;
    public float outTime = 30.0f;
    public float rotSpeed = 2.0f;
    public float sideTrailWidth = 5.0f;
    public Color sideTrailColor = Color.valueOf((String)"FFF8DB");

    public RainbowStorm(float size, float laserDamage) {
        this.size = size;
        this.laserDamage = laserDamage;
        this.collides = false;
        this.hittable = false;
        this.absorbable = false;
        this.trailLength = 41;
        this.trailWidth = size;
        this.trailColor = Color.valueOf((String)"FFF8DB").a(0.6f);
        this.hitEffect = this.despawnEffect = Fx.none;
    }

    public RainbowStorm() {
        this(18.0f, 20.0f);
    }

    public void updateBulletInterval(Bullet b) {
        if (!(b instanceof rbs)) {
            return;
        }
        rbs r = (rbs)b;
        float in = Math.min(b.time / this.inTime, 1.0f);
        float fin = this.inAmi ? Interp.fastSlow.apply(in) : 1.0f;
        float out = Math.min(1.0f, (b.lifetime - b.time) / this.outTime);
        float fout = this.fadeOut ? Interp.slowFast.apply(out) : 1.0f;
        float realSize = this.size * fin * fout;
        int index = (int)b.time;
        if (b.timer.get(2, 12.0f)) {
            for (int i = 0; i < this.laserAmount; ++i) {
                float a = 360.0f / (float)this.laserAmount * (float)i;
                float dx = EUGet.dx(b.x, realSize, a);
                float dy = EUGet.dy(b.y, realSize, a);
                Bullet rb = EUBulletTypes.rainbowLar[(index + i * 4) % 120].create((Entityc)b, b.team, dx, dy, a + 120.0f, this.laserDamage, 1.0f, 1.0f, null);
                rb.fdata = 0.0f;
                r.child.put((Object)Float.valueOf(a), (Object)rb);
            }
        }
        for (Float ag : r.child.keys().toSeq()) {
            Bullet ch = (Bullet)r.child.get((Object)ag);
            if (ch == null) continue;
            float a = ag.floatValue() + b.time * this.rotSpeed;
            float dx = EUGet.dx(b.x, realSize, a);
            float dy = EUGet.dy(b.y, realSize, a);
            ch.set(dx, dy);
            ch.rotation(a + 120.0f);
            ch.fdata = this.laserLength * fin * fout;
        }
    }

    public void updateTrail(Bullet b) {
        super.updateTrail(b);
        if (!(b instanceof rbs)) {
            return;
        }
        rbs r = (rbs)b;
        float in = Math.min(b.time / this.inTime, 1.0f);
        float fin = this.inAmi ? Interp.fastSlow.apply(in) : 1.0f;
        float out = Math.min(1.0f, (b.lifetime - b.time) / this.outTime);
        float fout = this.fadeOut ? Interp.slowFast.apply(out) : 1.0f;
        float realSize = this.size * 0.6f * fin * fout;
        if (!Vars.headless && this.trailLength > 0) {
            for (int i = 0; i < 2; ++i) {
                if (r.trails[i] == null) {
                    r.trails[i] = new Trail((int)((double)this.trailLength / 1.2));
                }
                r.trails[i].length = (int)((double)this.trailLength / 1.2);
                float dx = EUGet.dx(b.x, realSize, b.rotation() - 90.0f + (float)(i * 180));
                float dy = EUGet.dy(b.y, realSize, b.rotation() - 90.0f + (float)(i * 180));
                r.trails[i].update(dx, dy, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
            }
        }
    }

    public void drawTrail(Bullet b) {
        float fout;
        float in = Math.min(b.time / this.inTime, 1.0f);
        float fin = this.inAmi ? Interp.fastSlow.apply(in) : 1.0f;
        float out = Math.min(1.0f, (b.lifetime - b.time) / this.outTime);
        float f = fout = this.fadeOut ? Interp.slowFast.apply(out) : 1.0f;
        if (this.trailLength > 0 && b.trail != null) {
            float z = Draw.z();
            Draw.z((float)99.9999f);
            b.trail.draw(this.trailColor, this.trailWidth * fin * fout);
            Draw.z((float)z);
        }
        if (!(b instanceof rbs)) {
            return;
        }
        rbs r = (rbs)b;
        if (this.trailLength > 0) {
            for (int i = 0; i < 2; ++i) {
                if (r.trails[i] == null) continue;
                float z = Draw.z();
                Draw.z((float)(z - 1.0E-4f));
                r.trails[i].draw(this.sideTrailColor, this.sideTrailWidth * fin * fout);
                Draw.z((float)z);
            }
        }
    }

    public void draw(Bullet b) {
        if (!(b instanceof rbs)) {
            return;
        }
        float in = Math.min(b.time / this.inTime, 1.0f);
        float fin = this.inAmi ? Interp.fastSlow.apply(in) : 1.0f;
        float out = Math.min(1.0f, (b.lifetime - b.time) / this.outTime);
        float fout = this.fadeOut ? Interp.slowFast.apply(out) : 1.0f;
        float realSize = this.size * fin * fout;
        float z = Draw.z();
        Draw.z((float)(z + 1.0f));
        Draw.color((Color)this.sideTrailColor);
        Fill.circle((float)b.x, (float)b.y, (float)realSize);
        Draw.z((float)z);
        super.draw(b);
    }

    public void removed(Bullet b) {
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY, @Nullable Teamc target) {
        rbs bullet = rbs.create();
        for (int i = 0; i < 2; ++i) {
            if (bullet.trails[i] == null) continue;
            bullet.trails[i].clear();
        }
        if (bullet.child.size > 0) {
            bullet.child.clear();
        }
        return EUGet.anyOtherCreate(bullet, this, shooter, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY, target);
    }

    public static class rbs
    extends Bullet {
        @Nullable
        public Trail[] trails = new Trail[2];
        public ObjectMap<Float, Bullet> child = new ObjectMap();

        public static rbs create() {
            return (rbs)((Object)Pools.obtain(rbs.class, rbs::new));
        }
    }
}

