/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.worlds.blocks.turret.Prism;
import ExtraUtilities.worlds.entity.bullet.PrismCtr;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.Damage;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.graphics.Drawf;

public class PrismLaser
extends ContinuousLaserBulletType {
    public float[] strokes = new float[]{1.2f, 1.1f, 1.0f, 0.9f};
    public float[] tscales = new float[]{1.0f, 0.74f, 0.5f, 0.24f};
    public float[] lenscales = new float[]{0.96f, 1.0f, 1.017f, 1.025f};
    public int plan = 2;

    public PrismLaser(float damage, float width, float length) {
        this.damage = damage;
        this.width = width;
        this.length = length;
        this.hitEffect = EUFx.prismHit;
        this.lifetime = 30.0f;
        this.frontLength = 28.0f;
        this.incendChance = -1.0f;
        this.incendAmount = -1;
    }

    public void drawPlanA(Bullet b) {
        if (!(b.owner instanceof Prism.PrismBuild)) {
            return;
        }
        float realLength = Damage.findLaserLength((Bullet)b, (float)this.length);
        float bulletHeat = 1.0f - ((Prism.PrismBuild)b.owner).bulletHeat + 0.03f;
        float realWidth = this.width * bulletHeat * b.fout();
        float fout = Mathf.clamp((float)(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f));
        float baseLen = realLength * fout;
        float rot = b.rotation();
        Draw.blend((Blending)Blending.additive);
        Draw.color((Color)EUGet.EC3.set(EUGet.rainBowRed).shiftHue((float)((Integer)b.data).intValue()));
        for (int i = 0; i < 4; ++i) {
            float colorFin = (float)i / (float)(this.colors.length - 1);
            float baseStroke = Mathf.lerp((float)this.strokeFrom, (float)this.strokeTo, (float)colorFin);
            float stroke = (realWidth + Mathf.absin((float)Time.time, (float)this.oscScl, (float)this.oscMag)) * fout * baseStroke;
            float ellipseLenScl = Mathf.lerp((float)(1.0f - (float)i / (float)this.colors.length), (float)1.0f, (float)this.pointyScaling);
            Lines.stroke((float)stroke);
            Lines.lineAngle((float)b.x, (float)b.y, (float)rot, (float)(baseLen - this.frontLength), (boolean)false);
            Drawf.flameFront((float)b.x, (float)b.y, (int)this.divisions, (float)(rot + 180.0f), (float)this.backLength, (float)(stroke / 2.0f));
            Tmp.v1.trnsExact(rot, baseLen - this.frontLength);
            Drawf.flameFront((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (int)this.divisions, (float)rot, (float)(this.frontLength * ellipseLenScl), (float)(stroke / 2.0f));
        }
        Tmp.v1.trns(b.rotation(), baseLen * 1.1f);
        Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)this.lightStroke, (Color)this.lightColor, (float)0.7f);
        Draw.blend();
        Draw.reset();
    }

    public void drawPlanB(Bullet b) {
        if (!(b.owner instanceof Prism.PrismBuild)) {
            return;
        }
        float fout = Mathf.clamp((float)(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f));
        float realLength = Damage.findLaserLength((Bullet)b, (float)this.length);
        float baseLen = realLength * fout;
        float bulletHeat = 1.0f - ((Prism.PrismBuild)b.owner).bulletHeat;
        float wide = Mathf.clamp((float)(bulletHeat * bulletHeat + 0.03f)) * b.fout();
        Draw.z((float)99.0f);
        Draw.color((Color)Tmp.c1.set(EUGet.rainBowRed).mul(1.0f + Mathf.absin((float)Time.time, (float)1.0f, (float)0.1f)).shiftHue((float)((Integer)b.data).intValue()));
        Draw.alpha((float)0.04f);
        Draw.blend((Blending)Blending.additive);
        for (int s = 0; s < 4; ++s) {
            for (int i = 0; i < this.tscales.length; ++i) {
                Tmp.v1.trns(b.rotation() + 180.0f, (this.lenscales[i] - 1.0f) * this.frontLength);
                Lines.stroke((float)((this.width + Mathf.absin((float)Time.time, (float)this.oscScl, (float)this.oscMag)) * fout * wide * this.strokes[s] * this.tscales[i]));
                Lines.lineAngle((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)b.rotation(), (float)(baseLen * this.lenscales[i]), (boolean)false);
            }
        }
        Tmp.v1.trns(b.rotation(), baseLen * 1.1f);
        Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)this.lightStroke, (Color)this.lightColor, (float)0.7f);
        Draw.reset();
        Draw.blend();
    }

    public void drawPlanC(Bullet b) {
        Entityc entityc = b.owner;
        if (!(entityc instanceof PrismCtr.ctr)) {
            return;
        }
        PrismCtr.ctr c = (PrismCtr.ctr)entityc;
        float fout = Mathf.clamp((float)(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f));
        float realLength = Damage.findLaserLength((Bullet)b, (float)this.length);
        float baseLen = realLength * fout;
        float wide = Mathf.clamp((float)(c.fin() + 0.03f)) * b.fout();
        Draw.z((float)99.0f);
        Draw.color((Color)Tmp.c1.set(EUGet.rainBowRed).mul(1.0f + Mathf.absin((float)Time.time, (float)1.0f, (float)0.1f)).shiftHue((float)((Integer)b.data).intValue()));
        Draw.alpha((float)0.04f);
        Draw.blend((Blending)Blending.additive);
        for (int s = 0; s < 4; ++s) {
            for (int i = 0; i < this.tscales.length; ++i) {
                Tmp.v1.trns(b.rotation() + 180.0f, (this.lenscales[i] - 1.0f) * this.frontLength);
                Lines.stroke((float)((this.width + Mathf.absin((float)Time.time, (float)this.oscScl, (float)this.oscMag)) * fout * wide * this.strokes[s] * this.tscales[i]));
                Lines.lineAngle((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)b.rotation(), (float)(baseLen * this.lenscales[i]), (boolean)false);
            }
        }
        Tmp.v1.trns(b.rotation(), baseLen * 1.1f);
        Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)this.lightStroke, (Color)this.lightColor, (float)0.7f);
        Draw.reset();
        Draw.blend();
    }

    public void draw(Bullet b) {
        switch (this.plan) {
            case 1: {
                this.drawPlanA(b);
                break;
            }
            case 2: {
                this.drawPlanB(b);
                break;
            }
            case 3: {
                this.drawPlanC(b);
            }
        }
    }
}

