/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import ExtraUtilities.worlds.blocks.turret.MendTurret;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;

public class HealCone
extends BulletType {
    public float findRange;
    public float findAngle;
    public boolean percentHeal;
    public float healAmount = 200.0f;

    public HealCone(float findAngle, float findRange) {
        this(findAngle, findRange, true);
    }

    public HealCone(float findAngle, float findRange, boolean percentHeal) {
        this.findAngle = findAngle;
        this.findRange = findRange;
        this.percentHeal = percentHeal;
        this.speed = 0.0f;
        this.damage = 0.0f;
        this.collides = false;
        this.collidesAir = false;
        this.collidesGround = false;
        this.absorbable = false;
        this.hittable = false;
        this.keepVelocity = false;
        this.despawnEffect = Fx.none;
        this.shootEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.healPercent = 12.0f;
        this.drawSize = findRange;
        this.range = findRange;
    }

    public HealCone() {
        this(45.0f, 160.0f);
    }

    protected float calculateRange() {
        return this.findRange;
    }

    public void update(Bullet b) {
        float f;
        float f2;
        float ratio = 6000.0f;
        float in = b.time < b.lifetime - 10.0f ? Math.min(1.0f, b.time / 10.0f) : (b.lifetime - b.time) / 10.0f;
        in = Interp.fastSlow.apply(in);
        Entityc entityc = b.owner;
        if (entityc instanceof MendTurret.MendTurretBuild) {
            MendTurret.MendTurretBuild mt = (MendTurret.MendTurretBuild)entityc;
            f2 = mt.amountMti();
        } else {
            f2 = 1.0f;
        }
        float amountMt = f2;
        Entityc entityc2 = b.owner;
        if (entityc2 instanceof MendTurret.MendTurretBuild) {
            MendTurret.MendTurretBuild mt = (MendTurret.MendTurretBuild)entityc2;
            f = mt.angleMti();
        } else {
            f = 1.0f;
        }
        float angleMt = f * in;
        Units.nearby((Team)b.team, (float)b.x, (float)b.y, (float)(this.findRange * in), unit -> {
            if (unit.damaged() && Angles.within((float)b.rotation(), (float)b.angleTo((Position)unit), (float)(this.findAngle * angleMt / 2.0f)) && unit != b.owner) {
                if (this.percentHeal) {
                    unit.heal((unit.maxHealth < 1000.0f ? 1000.0f : unit.maxHealth) * (this.healPercent * amountMt / ratio) * Time.delta);
                } else {
                    unit.heal(this.healAmount * amountMt / 60.0f * Time.delta);
                }
            }
        });
        Vars.indexer.eachBlock((Teamc)b, this.findRange * in, other -> other.health < other.maxHealth - 0.001f && Angles.within((float)b.rotation(), (float)b.angleTo((Position)other), (float)(this.findAngle * angleMt / 2.0f)), other -> {
            if (this.percentHeal) {
                other.heal(this.healPercent / ratio * other.maxHealth * Time.delta);
            } else {
                other.heal(this.healAmount * amountMt / 60.0f * Time.delta);
            }
        });
        if (b.timer.get(30.0f)) {
            Vars.indexer.eachBlock((Teamc)b, this.findRange * in, other -> other.health < other.maxHealth - 0.001f && Angles.within((float)b.rotation(), (float)b.angleTo((Position)other), (float)(this.findAngle * angleMt / 2.0f)), other -> {
                if (other.block != null) {
                    Fx.healBlockFull.at(other.x, other.y, 0.0f, Pal.heal, (Object)other.block);
                }
            });
        }
    }

    public void draw(Bullet b) {
        float f;
        float in = b.time < b.lifetime - 10.0f ? Math.min(1.0f, b.time / 10.0f) : (b.lifetime - b.time) / 10.0f;
        in = Interp.fastSlow.apply(in);
        Object object = b.data;
        if (object instanceof Float) {
            Float f2 = (Float)object;
            f = f2.floatValue();
        } else {
            f = 1.0f;
        }
        float angleMt = f;
        float range = this.findRange * in;
        float angle = this.findAngle * angleMt * in;
        Draw.color((Color)Pal.heal);
        Draw.z((float)122.0f);
        Draw.alpha((float)0.8f);
        Fill.circle((float)b.x, (float)b.y, (float)(4.0f * in));
        Fill.arc((float)b.x, (float)b.y, (float)range, (float)(angle / 360.0f), (float)(b.rotation() - angle / 2.0f));
        Draw.alpha((float)1.0f);
    }
}

