/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.bullet;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.world.blocks.ControlBlock;

public class CtrlMissile
extends BasicBulletType {
    public boolean autoHoming = false;
    public boolean low = false;
    public Sound loopSound = Sounds.missileTrail;
    public float loopSoundVolume = 0.1f;

    public CtrlMissile(String sprite, float width, float height) {
        this.sprite = sprite;
        this.width = width;
        this.height = height;
        this.homingPower = 2.5f;
        this.homingRange = 64.0f;
        this.trailWidth = 3.0f;
        this.trailLength = 7;
        this.lifetime = 102.0f;
        this.buildingDamageMultiplier = 0.8f;
        this.hitSound = this.despawnSound = Sounds.bang;
        this.absorbable = false;
        this.keepVelocity = false;
        this.reflectable = false;
    }

    public void lookAt(float angle, Bullet b) {
        b.rotation(Angles.moveToward((float)b.rotation(), (float)angle, (float)(this.homingPower * Time.delta)));
    }

    public void lookAt(float x, float y, Bullet b) {
        this.lookAt(b.angleTo(x, y), b);
    }

    public void update(Bullet b) {
        super.update(b);
        if (!Vars.headless && this.loopSound != Sounds.none) {
            Vars.control.sound.loop(this.loopSound, (Position)b, this.loopSoundVolume);
        }
    }

    public void updateHoming(Bullet b) {
        if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay) {
            float realAimY;
            float realAimX;
            float f = b.aimX < 0.0f ? (b.data instanceof Position ? ((Position)b.data).getX() : b.x) : (realAimX = b.aimX);
            float f2 = b.aimY < 0.0f ? (b.data instanceof Position ? ((Position)b.data).getY() : b.y) : (realAimY = b.aimY);
            Object target = this.heals() ? Units.closestTarget(null, (float)realAimX, (float)realAimY, (float)this.homingRange, e -> e.checkTarget(this.collidesAir, this.collidesGround) && e.team != b.team && !b.hasCollided(e.id), t -> this.collidesGround && (t.team != b.team || t.damaged()) && !b.hasCollided(t.id)) : (b.aimTile != null && b.aimTile.build != null && b.aimTile.build.team != b.team && this.collidesGround && !b.hasCollided(b.aimTile.build.id) ? b.aimTile.build : Units.closestTarget((Team)b.team, (float)realAimX, (float)realAimY, (float)this.homingRange, e -> e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> this.collidesGround && !b.hasCollided(t.id)));
            if (this.reflectable) {
                return;
            }
            if (target != null && this.autoHoming) {
                b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)target), (float)(this.homingPower * Time.delta)));
            } else {
                Unit shooter = null;
                if (b.owner instanceof Unit) {
                    shooter = (Unit)b.owner;
                }
                if (b.owner instanceof ControlBlock) {
                    shooter = ((ControlBlock)b.owner).unit();
                }
                if (shooter != null) {
                    if (shooter.isPlayer()) {
                        this.lookAt(shooter.aimX, shooter.aimY, b);
                    } else {
                        Object object = b.data;
                        if (object instanceof Position) {
                            Position p = (Position)object;
                            this.lookAt(p.getX(), p.getY(), b);
                        } else {
                            this.lookAt(realAimX, realAimY, b);
                        }
                    }
                }
            }
        }
    }

    public void draw(Bullet b) {
        super.draw(b);
        Draw.z((float)(this.low ? 90.0f : 115.0f));
        if (this.width > 0.0f && this.height > 0.0f) {
            Draw.rect((TextureRegion)Core.atlas.find(this.sprite), (float)b.x, (float)b.y, (float)this.width, (float)this.height, (float)(b.rotation() - 90.0f));
        } else {
            Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)(b.rotation() - 90.0f));
        }
        Draw.reset();
    }
}

