/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.ability;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUStatusEffects;
import ExtraUtilities.content.EUUnitTypes;
import ExtraUtilities.worlds.drawer.DrawFunc;
import ExtraUtilities.worlds.entity.unit.bossEntity;
import ExtraUtilities.worlds.entity.unit.bossType;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.Wall;

public class bossUnitAbi
extends Ability {
    public Effect desUnit = EUFx.unitDesGone;
    public int maxPick = 20;
    public float pickRange = 480.0f;
    private boolean c1 = false;
    private boolean d1 = false;
    private boolean s1 = false;
    private float time = 0.0f;
    private float uee = 0.0f;
    private boolean outq = false;
    private float lastHealth = 0.0f;
    private float healTimer = 0.0f;
    public float maxPerSec = 800.0f;
    private final Effect espEffect = EUFx.edessp(20.0f);
    private final Object[] objects = new Object[4];

    public void reset() {
        this.outq = false;
        this.s1 = false;
        this.d1 = false;
        this.c1 = false;
    }

    public boolean isD1() {
        return this.d1;
    }

    public void setD1(boolean d1) {
        this.d1 = d1;
    }

    public boolean isS1() {
        return this.s1;
    }

    public void setS1(boolean s1) {
        this.s1 = s1;
    }

    public void update(Unit unit) {
        int i;
        if (!(unit instanceof bossEntity)) {
            return;
        }
        bossEntity bt = (bossEntity)unit;
        if (!this.outq && !Vars.net.client()) {
            unit.heal(unit.maxHealth);
            this.outq = true;
        }
        if (!Vars.state.isPaused()) {
            this.time += Time.delta;
            this.healTimer -= Time.delta;
        }
        if (unit.health < this.lastHealth - this.maxPerSec) {
            unit.health = this.lastHealth - this.maxPerSec;
        }
        if (this.healTimer <= 0.0f) {
            this.lastHealth = unit.health;
            this.healTimer = 60.0f;
        }
        if (unit.health < this.lastHealth - unit.maxHealth / 2.0f) {
            unit.health = this.lastHealth;
            unit.dead = false;
            this.s1 = false;
            this.d1 = false;
        }
        if (unit.health < unit.maxHealth / 1.5f && !this.c1) {
            Units.nearbyBuildings((float)unit.x, (float)unit.y, (float)this.pickRange, b -> {
                if (b.team != unit.team && b instanceof Wall.WallBuild) {
                    bt.bs.addUnique(b);
                }
            });
            bt.bs.sort(building -> building.dst((Position)unit));
            if (bt.bs.size > 0) {
                for (Building b2 : bt.bs) {
                    Block block;
                    if (b2 == null || !((block = b2.block) instanceof Wall)) continue;
                    Wall w = (Wall)block;
                    if (bt.pb.size > this.maxPick) continue;
                    bossType.pickedBlock p2 = new bossType.pickedBlock();
                    p2.set(w.health, w.size, w.name, unit.team);
                    p2.setPos(b2.x, b2.y);
                    bt.pb.addUnique((Object)p2);
                    if (Vars.net.client()) continue;
                    Call.removeTile((Tile)b2.tile);
                }
            }
            bt.bs.clear();
            this.c1 = true;
        }
        bt.pb.removeAll(p -> p == null || p.dead || p.health <= 0.0f);
        for (i = 0; i < bt.pb.size; ++i) {
            bossType.pickedBlock p3 = (bossType.pickedBlock)((Object)bt.pb.get(i));
            if (p3 == null) continue;
            p3.update();
            if (!p3.within((Position)unit, this.pickRange / 2.0f + 24.0f)) {
                p3.moveTo((Position)unit);
                continue;
            }
            float angle = (float)i * (120.0f / (float)this.maxPick) + this.time;
            p3.rotateTo((Position)unit, this.pickRange / 2.0f, angle);
        }
        if (this.d1) {
            unit.dead = false;
            unit.elevation = 1.0f;
            unit.heal(unit.maxHealth / 3600.0f * Time.delta);
            unit.apply(EUStatusEffects.EUUnmoving, 10.0f);
            unit.apply(EUStatusEffects.EUDisarmed, 10.0f);
            if (unit.health >= unit.maxHealth / 2.0f) {
                EUFx.gone(Color.valueOf((String)"87CEEB"), this.pickRange, 30.0f);
                Units.nearbyEnemies((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.pickRange, u -> {
                    if (!u.dead && !Vars.net.client() && u.type != null && u.type.killable && u.targetable(unit.team)) {
                        this.desUnit.at(u.x, u.y, u.hitSize * 4.0f, unit.team.color);
                        u.remove();
                        if (u != null) {
                            Groups.unit.remove((Entityc)u);
                        }
                        this.uee += 0.5f;
                    }
                });
                i = 0;
                while ((double)i < Math.ceil(this.uee) + 1.0) {
                    if (!Vars.net.client()) {
                        UnitType ut = EUUnitTypes.havoc;
                        Unit u2 = ut.create(unit.team);
                        u2.set(unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)Mathf.random((float)(-this.pickRange / 1.5f), (float)(this.pickRange / 1.5f))), unit.y + Angles.trnsx((float)(unit.rotation - 90.0f), (float)Mathf.random((float)(-this.pickRange / 2.0f))));
                        u2.rotation(unit.rotation);
                        EUFx.EUUtSp.at(u2.x, u2.y, u2.rotation - 90.0f, (Object)ut);
                        u2.add();
                    }
                    ++i;
                }
                this.s1 = true;
                this.c1 = false;
                this.d1 = false;
            }
        }
        if (this.s1 && !unit.dead) {
            unit.apply(EUStatusEffects.defenseUp, 10.0f);
            unit.apply(EUStatusEffects.fireDamageUp, 10.0f);
            unit.apply(EUStatusEffects.fireSpeedUp, 10.0f);
            unit.heal(3.3333333f * Time.delta);
        }
    }

    public boolean targetable() {
        return this.d1 && !this.s1;
    }

    public void draw(Unit unit) {
        super.draw(unit);
        if (!(unit instanceof bossEntity)) {
            return;
        }
        bossEntity bt = (bossEntity)unit;
        Draw.z((float)35.0f);
        if (bt.pb.size > 0) {
            for (bossType.pickedBlock p : bt.pb) {
                p.draw();
            }
        }
        Draw.z((float)110.0f);
        Lines.stroke((float)3.0f, (Color)Color.valueOf((String)"87CEEB"));
        Lines.circle((float)unit.x, (float)unit.y, (float)this.pickRange);
        Lines.stroke((float)2.0f, (Color)Color.valueOf((String)"6D90BC"));
        Lines.arc((float)unit.x, (float)unit.y, (float)(this.pickRange / 2.0f), (float)(unit.health / unit.maxHealth));
        if (this.d1 && !this.s1) {
            float angle;
            int i;
            float fin = unit.health / (unit.maxHealth / 2.0f);
            float fout = 1.0f - fin;
            if (unit.type != null && bt.timer.get(10.0f + 30.0f * fout) && unit.health < unit.maxHealth / 2.0f - 800.0f) {
                this.objects[0] = Core.atlas.find(unit.type.name);
                this.objects[1] = Float.valueOf(this.pickRange / 1.5f);
                this.objects[2] = Float.valueOf(unit.rotation - 90.0f);
                this.objects[3] = Float.valueOf(270.0f);
                this.espEffect.at(unit.x, unit.y, (float)Mathf.random((int)360), (Object)this.objects);
            }
            float lfin = Mathf.curve((float)fin, (float)0.0f, (float)0.1f);
            for (i = 0; i < 2; ++i) {
                angle = (float)i * 360.0f / 2.0f + 90.0f;
                Drawf.tri((float)(unit.x + Angles.trnsx((float)angle, (float)200.0f)), (float)(unit.y + Angles.trnsy((float)angle, (float)200.0f)), (float)15.0f, (float)(this.pickRange * lfin), (float)angle);
            }
            Lines.stroke((float)(5.0f * lfin));
            for (i = 0; i < 12; ++i) {
                angle = (float)i * 360.0f / 12.0f;
                float lx = unit.x + Angles.trnsx((float)angle, (float)this.pickRange);
                float ly = unit.y + Angles.trnsy((float)angle, (float)this.pickRange);
                Lines.lineAngle((float)lx, (float)ly, (float)(unit.angleTo(lx, ly) + 180.0f), (float)(this.pickRange / 8.0f));
            }
            Fill.circle((float)unit.x, (float)unit.y, (float)10.0f);
            Lines.stroke((float)7.0f, (Color)Color.valueOf((String)"87CEEB"));
            float aag = 360.0f * fout + 90.0f;
            Lines.lineAngle((float)unit.x, (float)unit.y, (float)aag, (float)this.pickRange);
            float ax = unit.x + Angles.trnsx((float)aag, (float)(this.pickRange - 24.0f));
            float ay = unit.y + Angles.trnsy((float)aag, (float)(this.pickRange - 24.0f));
            Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("aim-shoot")), (float)ax, (float)ay, (float)(80.0f * lfin), (float)90.0f, (float)(aag - 90.0f));
            DrawFunc.circlePercent(unit.x, unit.y, this.pickRange + 16.0f, fout, 90.0f);
            Units.nearbyEnemies((Team)unit.team, (float)unit.x, (float)unit.y, (float)this.pickRange, u -> {
                if (!u.dead && !Vars.net.client() && u.type != null && u.type.killable && u.targetable(unit.team)) {
                    Lines.stroke((float)4.0f, (Color)Pal.remove);
                    for (int i = 0; i < 3; ++i) {
                        float s = u.type.hitSize / 1.1f + Mathf.absin((float)(unit.health / 10.0f), (float)10.0f, (float)(u.type.hitSize / 3.0f));
                        float ang = 30 + 120 * i;
                        float cx = EUGet.dx(u.x, s, ang);
                        float cy = EUGet.dy(u.y, s, ang);
                        for (int a : Mathf.zeroOne) {
                            Lines.lineAngle((float)cx, (float)cy, (float)(ang - 90.0f + (float)(180 * a)), (float)(s / 1.3f));
                        }
                    }
                    Lines.square((float)u.x, (float)u.y, (float)(u.type.hitSize / 2.0f), (float)(unit.health / 10.0f));
                }
            });
        }
        Draw.reset();
    }

    public String localized() {
        return "[red]BOSS[]";
    }
}

