/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.entity.ability;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;

public class BoostAbility
extends Ability {
    public float boost = 3.0f;
    public float boostTime = 90.0f;
    public float slow = 0.5f;
    public float slowTime = 120.0f;
    public float range = 160.0f;
    public float reload = 300.0f;
    public float deepSeek = 0.7f;
    public Color color = Pal.heal;
    private float timer = 0.0f;
    private float scp = 0.0f;
    private final Seq<Building> builds = new Seq();
    private final Seq<Building> ems = new Seq();

    public void update(Unit unit) {
        if (this.scp >= this.range) {
            this.timer = 0.0f;
            this.scp = 0.0f;
            this.builds.clear();
            this.ems.clear();
        }
        if (this.timer >= this.reload) {
            this.scp += Time.delta * this.deepSeek;
            Vars.indexer.eachBlock((Teamc)unit, this.scp, b -> b.block != null && b.block.canOverdrive && !this.builds.contains(b), b -> {
                b.applyBoost(this.boost, this.boostTime);
                Fx.healBlockFull.at(b.x, b.y, 0.0f, Pal.heal, (Object)b.block);
                this.builds.add(b);
            });
            Vars.indexer.eachBlock(null, unit.x, unit.y, this.scp, e -> e.team != unit.team && e.block != null && !this.ems.contains(e), e -> {
                e.applySlowdown(this.slow, this.slowTime);
                Fx.healBlockFull.at(e.x, e.y, 0.0f, Pal.sap, (Object)e.block);
                this.ems.add(e);
            });
        } else {
            this.timer += Time.delta;
        }
    }

    public void draw(Unit unit) {
        float z = Draw.z();
        Draw.z((float)29.5f);
        Draw.color((Color)Tmp.c1.set(this.color).a(0.2f));
        float fin = Interp.smoother.apply(this.scp / this.range);
        float fout = 1.0f - fin;
        if (fin < 0.5f) {
            Lines.stroke((float)(this.range * fin * 1.3f));
        } else {
            Lines.stroke((float)(this.range * fout * 1.3f));
        }
        Lines.circle((float)unit.x, (float)unit.y, (float)(this.range * fin));
        Draw.z((float)z);
        Draw.reset();
    }

    public String localized() {
        return Core.bundle.format("ability.extra-utilities-boost-abi", new Object[0]);
    }

    public void addStats(Table t) {
        super.addStats(t);
        t.row();
        t.add((CharSequence)Core.bundle.format("stat.eu-boost-abi-reload", new Object[]{Strings.autoFixed((float)(this.reload / 60.0f), (int)2)}));
        t.row();
        t.add((CharSequence)Core.bundle.format("stat.eu-boost-abi-range", new Object[]{Strings.autoFixed((float)(this.range / 8.0f), (int)2)}));
        t.row();
        t.add((CharSequence)Core.bundle.format("stat.eu-boost-abi-boost", new Object[]{Strings.autoFixed((float)(this.boostTime / 60.0f), (int)2), Strings.autoFixed((float)((this.boost - 1.0f) * 100.0f), (int)2)}));
        t.row();
        t.add((CharSequence)Core.bundle.format("stat.eu-boost-abi-slow", new Object[]{Strings.autoFixed((float)(this.slowTime / 60.0f), (int)2), Strings.autoFixed((float)((1.0f - this.slow) * 100.0f), (int)2)}));
        t.row();
    }
}

