/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.worlds.blocks.turret.WitchService;
import ExtraUtilities.worlds.entity.bullet.ChainLightningFade;
import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.util.Eachable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawRust
extends DrawBlock {
    public TextureRegion rot;
    public TextureRegion base;
    protected ChainLightningFade chain = new ChainLightningFade(30.0f, 10.0f, 1.3f, Pal.techBlue, 0.0f, Fx.none){
        {
            this.layer = 29.5f;
            this.drawSize = 480.0f;
        }
    };

    public void draw(Building build) {
        Draw.rect((TextureRegion)this.base, (float)build.x, (float)build.y);
        Draw.rect((TextureRegion)this.rot, (float)build.x, (float)build.y, (float)(build.rotation * 90));
        if (!Vars.headless && Core.settings != null && Core.settings.getBool("eu-show-rust-range") && build instanceof WitchService.ServiceBuild) {
            WitchService.ServiceBuild s = (WitchService.ServiceBuild)build;
            Rect r = s.getR();
            float rx1 = r.x + r.width;
            float ry1 = r.y;
            float rx2 = r.x;
            float ry2 = r.y;
            float rx3 = r.x;
            float ry3 = r.y + r.height;
            float rx4 = r.x + r.width;
            float ry4 = r.y + r.height;
            float status = s.getDelta() / Time.delta;
            if (status < 1.0E-4f) {
                return;
            }
            if (build.timer.get(15.0f / (status + 1.0E-4f))) {
                float len = Mathf.dst((float)rx1, (float)ry1, (float)rx2, (float)ry2);
                float angle = Angles.angle((float)rx1, (float)ry1, (float)rx2, (float)ry2);
                this.chain.create((Entityc)build, build.team, rx1, ry1, angle, -1.0f, 1.0f, 1.0f, Float.valueOf(len));
                len = Mathf.dst((float)rx2, (float)ry2, (float)rx3, (float)ry3);
                angle = Angles.angle((float)rx2, (float)ry2, (float)rx3, (float)ry3);
                this.chain.create((Entityc)build, build.team, rx2, ry2, angle, -1.0f, 1.0f, 1.0f, Float.valueOf(len));
                len = Mathf.dst((float)rx3, (float)ry3, (float)rx4, (float)ry4);
                angle = Angles.angle((float)rx3, (float)ry3, (float)rx4, (float)ry4);
                this.chain.create((Entityc)build, build.team, rx3, ry3, angle, -1.0f, 1.0f, 1.0f, Float.valueOf(len));
                len = Mathf.dst((float)rx4, (float)ry4, (float)rx1, (float)ry1);
                angle = Angles.angle((float)rx4, (float)ry4, (float)rx1, (float)ry1);
                this.chain.create((Entityc)build, build.team, rx4, ry4, angle, -1.0f, 1.0f, 1.0f, Float.valueOf(len));
            }
        }
    }

    public void load(Block block) {
        this.rot = Core.atlas.find(block.name + "-rot");
        this.base = Core.atlas.find(block.name + "-base");
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.base, this.rot};
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.base, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.rot, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
    }
}

