/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.drawer;

import ExtraUtilities.content.EUGet;
import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.draw.DrawBlock;

public class DrawRainbow
extends DrawBlock {
    public float shiftSpeed = 2.0f;
    public int size = 6;
    public TextureRegion[] rainbowRegions = new TextureRegion[6];

    public DrawRainbow(float shiftSpeed, int size) {
        this.shiftSpeed = shiftSpeed;
        this.size = size;
        this.rainbowRegions = new TextureRegion[size];
    }

    public DrawRainbow() {
    }

    public void draw(Building build) {
        Turret.TurretBuild b = (Turret.TurretBuild)build;
        this.drawRainbow(b);
    }

    public void drawRainbow(Turret.TurretBuild build) {
        Draw.blend((Blending)Blending.additive);
        for (int h = 0; h < this.size; ++h) {
            Draw.color((Color)EUGet.EC5.set(EUGet.rainBowRed).shiftHue(Time.time * this.shiftSpeed + (float)h * (360.0f / (float)this.size)));
            Draw.rect((TextureRegion)this.rainbowRegions[h], (float)(build.x + build.recoilOffset.x), (float)(build.y + build.recoilOffset.y), (float)(build.rotation - 90.0f));
        }
        Draw.blend();
        Draw.color();
    }

    public void load(Block block) {
        for (int i = 0; i < this.size; ++i) {
            this.rainbowRegions[i] = Core.atlas.find(block.name + "-rainbow-" + (i + 1));
        }
    }
}

