/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.consumers;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeLiquidsDynamic;

public class BetterConsumeLiquidsDynamic
extends ConsumeLiquidsDynamic {
    public Liquid[] fit;

    public BetterConsumeLiquidsDynamic(Func<Building, LiquidStack[]> liquids, Liquid[] fit) {
        super(liquids);
        this.fit = fit;
    }

    public void apply(Block block) {
        block.hasLiquids = true;
        if (this.fit.length > 0) {
            for (Liquid l : this.fit) {
                block.liquidFilter[l.id] = true;
            }
        }
    }

    public void build(Building build, Table table) {
        LiquidStack[][] current = new LiquidStack[][]{(LiquidStack[])this.liquids.get((Object)build)};
        table.table(c -> c.table(c1 -> {
            c.update(() -> {
                if (current[0] != this.liquids.get((Object)build)) {
                    this.rebuild(build, (Table)c1);
                    current[0] = (LiquidStack[])this.liquids.get((Object)build);
                }
            });
            this.rebuild(build, (Table)c1);
        })).left();
    }

    void rebuild(Building build, Table table) {
        table.clear();
        int i = 0;
        LiquidStack[] stacks = (LiquidStack[])this.liquids.get((Object)build);
        if (stacks.length == 0) {
            return;
        }
        for (LiquidStack stack : stacks) {
            table.add((Element)new ReqImage(stack.liquid.uiIcon, () -> build.liquids.get(stack.liquid) > 0.0f)).size(32.0f).padRight(8.0f);
            if (++i % 4 != 0) continue;
            table.row();
        }
    }
}

