/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.unit;

import ExtraUtilities.content.EUGet;
import ExtraUtilities.worlds.meta.EUStatValues;
import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.StatusEffect;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.heat.HeatConsumer;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatUnit;

public class UnitBoost
extends Block {
    public StatusEffect[] status;
    public int range = 22;
    public int boostRange = 5;
    public StatusEffect[] boostStatus;
    public boolean boostReplace = false;
    public float consumeTime = 240.0f;
    public float heatRequirement = 10.0f;
    public float maxRangeBoost = 1.5f;
    public DrawBlock drawer = null;
    public boolean onlyDrawer = true;

    public UnitBoost(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.destructible = true;
        this.canOverdrive = false;
    }

    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar(() -> Core.bundle.format("bar.heatpercent", new Object[]{(int)(entity.heat + 0.01f), (int)(entity.efficiencyScale() * 100.0f + 0.01f)}), () -> Pal.lightOrange, () -> entity.heat / this.heatRequirement));
    }

    public void setStats() {
        Consume consume;
        this.stats.timePeriod = this.consumeTime;
        super.setStats();
        this.stats.add(Stat.input, this.heatRequirement, StatUnit.heatUnits);
        this.stats.add(Stat.range, (float)this.range, StatUnit.blocks);
        this.stats.add(new Stat("rangeboost", StatCat.crafting), (float)((int)(this.maxRangeBoost * 100.0f)), StatUnit.percent);
        if (this.status.length > 0) {
            this.stats.add(Stat.abilities, t -> {
                t.row();
                t.add((CharSequence)Core.bundle.get("statValue.showStatus")).left();
                t.row();
                t.table(Styles.grayPanel, inner -> {
                    inner.left().defaults().left();
                    for (StatusEffect s : this.status) {
                        if (s == StatusEffects.none) continue;
                        inner.row();
                        inner.add((Element)EUGet.selfStyleImageButton((Drawable)new TextureRegionDrawable(s.uiIcon), Styles.emptyi, () -> Vars.ui.content.show((UnlockableContent)s))).padTop(4.0f).padBottom(6.0f).size(42.0f);
                        inner.add((CharSequence)s.localizedName).padLeft(5.0f);
                    }
                }).left().growX().margin(6.0f).pad(5.0f).padBottom(-5.0f).row();
            });
        }
        if ((consume = this.findConsumer(c -> c instanceof ConsumeItems)) instanceof ConsumeItems) {
            ConsumeItems cons = (ConsumeItems)consume;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, EUStatValues.itemRangeBoosters("{0}" + StatUnit.timesSpeed.localized(), this.stats.timePeriod, this.boostStatus, this.boostRange * 8, cons.items, this.boostReplace, (Boolf<Item>)((Boolf)arg_0 -> ((UnitBoost)this).consumesItem(arg_0))));
        }
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        x *= 8;
        y *= 8;
        x = (int)((float)x + this.offset);
        y = (int)((float)y + this.offset);
        Drawf.dashSquare((Color)Vars.player.team().color, (float)x, (float)y, (float)(this.range * 8));
    }

    public void load() {
        super.load();
        if (this.drawer == null) {
            return;
        }
        this.drawer.load((Block)this);
    }

    public TextureRegion[] icons() {
        return this.drawer == null ? super.icons() : this.drawer.finalIcons((Block)this);
    }

    public class UnitBoostBuild
    extends Building
    implements HeatConsumer {
        public float[] sideHeat = new float[4];
        public float heat = 0.0f;
        public float realRange = 0.0f;
        public float phaseHeat = 0.0f;
        public float consumeTimer = 0.0f;
        private boolean can;
        private boolean show;
        private boolean change1_2 = false;
        private float rotation;
        private float ps;
        private float lp1 = 0.0f;
        private float lp2 = 1.0f;
        private final Seq<Float[]> pos = new Seq();
        private final Pool<EUGet.EPos> posPool = Pools.get(EUGet.EPos.class, EUGet.EPos::new);

        public boolean canShow() {
            return this.show;
        }

        public void updateTile() {
            this.heat = this.calculateHeat(this.sideHeat);
            if (UnitBoost.this.status.length <= 0) {
                return;
            }
            this.phaseHeat = Mathf.lerpDelta((float)this.phaseHeat, (float)this.optionalEfficiency, (float)0.1f);
            this.realRange = ((float)UnitBoost.this.range + this.phaseHeat * (float)UnitBoost.this.boostRange) * this.efficiency;
            if (this.efficiency < 0.01f) {
                return;
            }
            this.can = false;
            Units.nearby((Rect)Tmp.r1.setCentered(this.x, this.y, this.realRange * 8.0f), u -> {
                if (u.team == this.team) {
                    boolean phase;
                    boolean bl = phase = this.phaseHeat > 0.5f;
                    if (phase && UnitBoost.this.boostStatus.length > 0) {
                        for (StatusEffect s : UnitBoost.this.boostStatus) {
                            if (s == StatusEffects.none) continue;
                            u.apply(s, 10.0f);
                        }
                    }
                    if (!UnitBoost.this.boostReplace || !phase) {
                        for (StatusEffect s : UnitBoost.this.status) {
                            if (s == StatusEffects.none) continue;
                            u.apply(s, 10.0f);
                        }
                    }
                    this.can = true;
                }
            });
            if (this.optionalEfficiency > 0.0f && this.can) {
                float f;
                this.consumeTimer += Time.delta;
                if (f > UnitBoost.this.consumeTime) {
                    this.consumeTimer -= UnitBoost.this.consumeTime;
                    this.consume();
                }
            }
            this.show = this.can;
        }

        public void draw() {
            int i;
            super.draw();
            if (UnitBoost.this.drawer != null) {
                UnitBoost.this.drawer.draw((Building)this);
                if (UnitBoost.this.onlyDrawer) {
                    return;
                }
            }
            if (!Vars.state.isPaused()) {
                if (this.show && this.efficiency > 0.01f) {
                    this.ps = Mathf.lerpDelta((float)this.ps, (float)1.0f, (float)0.04f);
                    this.rotation += this.edelta();
                } else {
                    this.ps = Mathf.lerpDelta((float)this.ps, (float)0.0f, (float)0.08f);
                }
            }
            if (this.ps < 0.01f) {
                return;
            }
            float dz = Draw.z();
            Draw.z((float)110.0f);
            Draw.color((Color)this.team.color, (Color)this.team.color.cpy().mul(Items.phaseFabric.color), (float)this.phaseHeat);
            Fill.square((float)this.x, (float)this.y, (float)((float)UnitBoost.this.size * this.ps), (float)this.rotation);
            Draw.z((float)29.5f);
            Lines.stroke((float)(1.4f * this.ps));
            float rd = (float)(UnitBoost.this.size * 8) * this.ps;
            this.pos.clear();
            for (i = 0; i < 3; ++i) {
                float rt = 120.0f * (float)i - this.rotation;
                if (this.phaseHeat < 0.99f) {
                    Lines.arc((float)this.x, (float)this.y, (float)rd, (float)(0.33333334f * (1.0f - this.phaseHeat + 0.05f)), (float)rt);
                }
                float ex = this.x + Angles.trnsx((float)rt, (float)rd);
                float ey = this.y + Angles.trnsy((float)rt, (float)rd);
                Float[] p = new Float[]{Float.valueOf(ex), Float.valueOf(ey)};
                this.pos.add((Object)p);
            }
            for (i = 0; i < this.pos.size; ++i) {
                float ox = ((Float[])this.pos.get(i))[0].floatValue();
                float oy = ((Float[])this.pos.get(i))[1].floatValue();
                float ex = ((Float[])this.pos.get((i + 2) % this.pos.size))[0].floatValue();
                float ey = ((Float[])this.pos.get((i + 2) % this.pos.size))[1].floatValue();
                EUGet.EPos og = ((EUGet.EPos)this.posPool.obtain()).set(ox, oy);
                float dst = og.dst(ex, ey);
                float angle = og.angleTo(ex, ey);
                Lines.lineAngle((float)ox, (float)oy, (float)angle, (float)(dst * this.phaseHeat * this.ps));
                this.posPool.free((Object)og);
            }
            Draw.z((float)dz);
            Draw.reset();
        }

        public void drawSelect() {
            super.drawSelect();
            if (!this.change1_2) {
                this.lp1 = Mathf.lerpDelta((float)this.lp1, (float)1.0f, (float)0.06f);
            }
            if (this.change1_2) {
                this.lp2 = Mathf.lerpDelta((float)this.lp2, (float)0.0f, (float)0.06f);
            }
            if (this.lp1 > 0.99f) {
                this.change1_2 = true;
                this.lp1 = 0.0f;
            }
            if (this.lp2 < 0.01f) {
                this.change1_2 = false;
                this.lp2 = 1.0f;
            }
            Lines.stroke((float)2.4f, (Color)this.team.color);
            this.pos.clear();
            for (Point2 q : Geometry.d8edge) {
                float lx = this.x + this.realRange / 2.0f * 8.0f * (float)q.x;
                float ly = this.y + this.realRange / 2.0f * 8.0f * (float)q.y;
                Float[] p = new Float[]{Float.valueOf(lx), Float.valueOf(ly)};
                this.pos.add((Object)p);
            }
            for (int i = 0; i < this.pos.size; ++i) {
                float ox = ((Float[])this.pos.get(i))[0].floatValue();
                float oy = ((Float[])this.pos.get(i))[1].floatValue();
                float ex = ((Float[])this.pos.get((i + 1) % this.pos.size))[0].floatValue();
                float ey = ((Float[])this.pos.get((i + 1) % this.pos.size))[1].floatValue();
                EUGet.EPos og = ((EUGet.EPos)this.posPool.obtain()).set(ox, oy);
                float dst = og.dst(ex, ey);
                float angle = og.angleTo(ex, ey);
                if (!this.change1_2) {
                    Lines.lineAngle((float)ox, (float)oy, (float)angle, (float)(dst * this.lp1));
                } else {
                    Lines.lineAngle((float)ex, (float)ey, (float)(angle - 180.0f), (float)(dst * this.lp2));
                }
                this.posPool.free((Object)og);
            }
        }

        public float[] sideHeat() {
            return this.sideHeat;
        }

        public float heatRequirement() {
            return UnitBoost.this.heatRequirement;
        }

        public float efficiencyScale() {
            return Math.min(UnitBoost.this.maxRangeBoost, this.heat / UnitBoost.this.heatRequirement);
        }

        public void updateEfficiencyMultiplier() {
            float scale = this.efficiencyScale();
            this.efficiency *= scale;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.consumeTimer);
            write.f(this.phaseHeat);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.consumeTimer = read.f();
            this.phaseHeat = read.f();
        }
    }
}

