/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret.wall;

import ExtraUtilities.content.EUFx;
import ExtraUtilities.net.EUCall;
import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Domain
extends Block {
    public Effect abEffect = EUFx.shieldDefense;
    public Effect fullEffect = Fx.absorb;
    public Effect removeEffect = new Effect(20.0f, e -> {
        Draw.color((Color)e.color, (float)e.fout());
        if (Vars.renderer.animateShields) {
            Fill.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fout()));
        } else {
            Lines.stroke((float)1.5f);
            Draw.alpha((float)0.09f);
            Fill.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fout()));
            Draw.alpha((float)1.0f);
            Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fout()));
        }
    }).layer(125.0f);
    public float range = 200.0f;
    public int bulletAmount = 50;
    public float coolDown = 8.0f;
    public float coolDownBk = 5.0f;
    public float shieldHealth = 3500.0f;
    public boolean canBroken = true;
    public Effect shieldBkEffect = new Effect(40.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(3.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation + e.fin()));
    });
    public float upSpeed = 1.2f;
    public float upSpeedAfter = 2.0f;
    public float reloadS = 60.0f;
    public float reloadH = 240.0f;
    public float reloadHAfter = 150.0f;
    public float healPercent = 25.0f;
    public boolean healByPercent = false;
    public float healPercentUnit = 10.0f;
    public float healAmountUnit = 300.0f;
    public float reloadHU = 180.0f;
    public float reloadHUAfter = 120.0f;
    public float unitDamage = 12.0f;
    protected static DomainBuild db;
    protected static Effect e;
    protected static Effect ef;
    protected static int amount;
    protected static boolean canBK;
    protected static float ud;
    protected static final Cons<Bullet> bulletConsumer;
    protected static final Cons<Unit> unitShield;
    protected static final Cons<Unit> unitConsumer;

    public Domain(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
        this.emitLight = true;
        this.envEnabled |= 2;
        this.ambientSound = Sounds.shield;
        this.ambientSoundVolume = 0.08f;
    }

    public void init() {
        this.updateClipRadius(this.range + 4.0f);
        super.init();
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.repairTime, (float)((int)(100.0f / this.healPercent * this.reloadH / 60.0f)), StatUnit.seconds);
        if (this.healByPercent) {
            this.stats.add(Stat.repairTime, Core.bundle.format("stat-heal-unit-by-per", new Object[]{(int)(100.0f / this.healPercentUnit * this.reloadHU / 60.0f)}), new Object[0]);
        } else {
            this.stats.add(Stat.repairTime, Core.bundle.format("stat-heal-unit", new Object[]{Float.valueOf(this.reloadHU / 60.0f), Float.valueOf(this.healAmountUnit)}), new Object[0]);
        }
        this.stats.add(Stat.speedIncrease, "+" + (int)(this.upSpeed * 100.0f - 100.0f) + "%", new Object[0]);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        if (this.canBroken) {
            this.stats.add(Stat.shieldHealth, this.shieldHealth, StatUnit.none);
            this.stats.add(Stat.cooldownTime, (float)((int)(this.shieldHealth / this.coolDownBk / 60.0f)), StatUnit.seconds);
        }
    }

    public void setBars() {
        super.setBars();
        this.addBar("boost", entity -> new Bar(() -> Core.bundle.format("bar.boost", new Object[]{Mathf.round((float)Math.max(entity.updateSpeeder() * 100.0f - 100.0f, 0.0f))}), () -> Pal.accent, () -> 1.0f));
        this.addBar("shield", entity -> new Bar(() -> Core.bundle.get("stat.shieldhealth"), () -> entity.bk ? Pal.redLight : Pal.accent, entity::showBar));
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Vars.player.team().color);
    }

    public static void broken(Tile tile) {
        if (tile == null || !(tile.build instanceof DomainBuild)) {
            return;
        }
        ((DomainBuild)tile.build).broken();
    }

    static {
        bulletConsumer = bullet -> {
            if (bullet.team != Domain.db.team && bullet.type != null && bullet.type.absorbable && bullet.within((Position)db, db.range())) {
                if (canBK && Domain.db.absorbed < amount && bullet.type.reflectable && bullet.type.collides && bullet.type.collidesAir && bullet.type.collidesGround && bullet.type.collidesTiles && bullet.type.damage > 0.0f) {
                    e.at(bullet.getX(), bullet.getY(), Domain.db.team.color);
                    Domain.db.reBullet.put((Object)bullet.type.copy(), (Object)new float[]{bullet.x, bullet.y, bullet.rotation() - 180.0f, bullet.fout()});
                    ++Domain.db.absorbed;
                } else {
                    ef.at((Position)bullet);
                }
                bullet.absorb();
                if (canBK) {
                    Domain.db.hit = 1.0f;
                    Domain.db.buildup += bullet.damage;
                }
            }
        };
        unitShield = unit -> {
            float overlapDst;
            if (db != null && unit.targetable(Domain.db.team) && (overlapDst = unit.hitSize / 2.0f + db.range() - unit.dst((Position)db)) > 0.0f) {
                Domain.db.buildup += unit.hitSize * ud;
                Domain.db.hit = 1.0f;
            }
        };
        unitConsumer = unit -> {
            float overlapDst;
            if (db != null && unit.targetable(Domain.db.team) && (overlapDst = unit.hitSize / 2.0f + db.range() - unit.dst((Position)db)) > 0.0f) {
                unit.vel.setZero();
                unit.move(Tmp.v1.set((Position)unit).sub((Position)db).setLength(overlapDst + 0.01f));
                if (Mathf.chanceDelta((double)(0.12f * Time.delta))) {
                    Fx.circleColorSpark.at(unit.x, unit.y, Domain.db.team.color);
                }
            }
        };
    }

    public class DomainBuild
    extends Building
    implements Ranged {
        public float hit;
        public float buildup;
        public float radscl;
        public float timerH;
        public float timerHU;
        public ObjectMap<BulletType, float[]> reBullet = new ObjectMap();
        public int absorbed = 0;
        public boolean bk = false;

        public float showBar() {
            return Math.max(1.0f - this.buildup / Domain.this.shieldHealth, 0.0f);
        }

        public float range() {
            return Domain.this.range * this.radscl;
        }

        public void onRemoved() {
            float radius = this.range();
            if (!this.bk && radius > 1.0f) {
                Domain.this.removeEffect.at(this.x, this.y, radius, this.team.color);
            }
            super.onRemoved();
        }

        public void pickedUp() {
            super.pickedUp();
            this.radscl = 0.0f;
        }

        public void updateTile() {
            this.updateShield();
            this.updateSpeeder();
            this.updateHeal();
        }

        public void updateShield() {
            this.radscl = Mathf.lerpDelta((float)this.radscl, (float)(this.bk ? 0.0f : this.efficiency), (float)0.05f);
            if (this.buildup > 0.0f) {
                float scale = !this.bk ? Domain.this.coolDown : Domain.this.coolDownBk;
                this.buildup -= this.delta() * scale;
            }
            if (this.bk && this.buildup <= 0.0f) {
                this.bk = false;
            }
            if (this.buildup >= Domain.this.shieldHealth && !this.bk && !Vars.net.client()) {
                EUCall.DomainBroken(this.tile);
            }
            if (this.hit > 0.0f) {
                this.hit -= 0.2f * Time.delta;
            }
            this.deflect();
        }

        public void broken() {
            this.bk = true;
            this.buildup = Domain.this.shieldHealth;
            Domain.this.shieldBkEffect.at(this.x, this.y, this.range(), this.team.color);
            Seq keys = this.reBullet.keys().toSeq();
            for (int i = 0; i < keys.size; ++i) {
                BulletType b = (BulletType)keys.get(i);
                if (b == null || !this.reBullet.containsKey((Object)b) || this.reBullet.get((Object)b) == null) continue;
                float[] f = (float[])this.reBullet.get((Object)b);
                b.create((Entityc)this, this.team, f[0], f[1], f[2], 1.0f, f[3]);
            }
            this.absorbed = 0;
            this.reBullet.clear();
            if (this.team != Vars.state.rules.defaultTeam) {
                Events.fire((Enum)EventType.Trigger.forceProjectorBreak);
            }
        }

        public float updateSpeeder() {
            float realSpeed = (this.bk ? Domain.this.upSpeedAfter : Domain.this.upSpeed) * this.efficiency;
            Vars.indexer.eachBlock((Teamc)this, Domain.this.range * this.efficiency, other -> other != this && other.block != null && other.block.canOverdrive, other -> other.applyBoost(realSpeed, Domain.this.reloadS + 1.0f));
            return realSpeed;
        }

        public void updateHeal() {
            float f;
            float f2;
            if (this.efficiency < 0.001f) {
                return;
            }
            float realReloadH = this.bk ? Domain.this.reloadHAfter : Domain.this.reloadH;
            this.timerH += this.delta();
            if (f2 >= realReloadH && !this.checkSuppression()) {
                float realRange = Domain.this.range * this.efficiency;
                this.timerH -= realReloadH;
                Vars.indexer.eachBlock((Teamc)this, realRange, b -> b.damaged() && !b.isHealSuppressed(), other -> {
                    other.heal(other.maxHealth() * Domain.this.healPercent / 100.0f * this.efficiency);
                    other.recentlyHealed();
                    Fx.healBlockFull.at(other.x, other.y, (float)other.block.size, Pal.heal, (Object)other.block);
                });
            }
            float realReloadHU = this.bk ? Domain.this.reloadHUAfter : Domain.this.reloadHU;
            this.timerHU += this.delta();
            if (f >= realReloadH) {
                float realRange = Domain.this.range;
                this.timerHU -= realReloadHU;
                Units.nearby((Team)this.team, (float)this.x, (float)this.y, (float)realRange, unit -> {
                    if (unit != null && !unit.dead && unit.damaged()) {
                        float am = Domain.this.healByPercent ? unit.maxHealth * Domain.this.healPercentUnit : Domain.this.healAmountUnit;
                        unit.heal(am * this.efficiency * Time.delta);
                    }
                });
            }
        }

        public void deflect() {
            if (this.range() > 0.0f && !this.bk) {
                db = this;
                e = Domain.this.abEffect;
                ef = Domain.this.fullEffect;
                amount = Domain.this.bulletAmount;
                canBK = Domain.this.canBroken;
                ud = Domain.this.unitDamage;
                float r = this.range() + 10.0f;
                Groups.bullet.intersect(this.x - r, this.y - r, r * 2.0f, r * 2.0f, bulletConsumer);
                if (canBK && this.timer.get(30.0f)) {
                    Units.nearbyEnemies((Team)this.team, (float)this.x, (float)this.y, (float)r, unitShield);
                }
                Units.nearbyEnemies((Team)this.team, (float)this.x, (float)this.y, (float)r, unitConsumer);
            }
        }

        public float edelta() {
            return super.edelta();
        }

        public void draw() {
            super.draw();
            if (this.buildup > 0.0f) {
                Draw.color((Color)Color.valueOf((String)"bf92f9").a(this.buildup / Domain.this.shieldHealth * 0.8f));
                Draw.z((float)31.0f);
                Draw.blend((Blending)Blending.additive);
                Draw.rect((TextureRegion)Core.atlas.find(Domain.this.name + "-top"), (float)this.x, (float)this.y);
                Draw.blend();
                Draw.z((float)30.0f);
                Draw.reset();
            }
            this.drawShield();
        }

        public void drawShield() {
            if (!this.bk) {
                float radius = this.range();
                Draw.z((float)125.0f);
                Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
                if (Vars.renderer.animateShields) {
                    Fill.poly((float)this.x, (float)this.y, (int)36, (float)radius);
                } else {
                    Lines.stroke((float)1.5f);
                    Draw.alpha((float)(0.09f + Mathf.clamp((float)(0.08f * this.hit))));
                    Fill.poly((float)this.x, (float)this.y, (int)36, (float)radius);
                    Draw.alpha((float)1.0f);
                    Lines.poly((float)this.x, (float)this.y, (int)36, (float)radius);
                    Draw.reset();
                }
            }
            Draw.reset();
        }

        public void drawSelect() {
            float realRange = Domain.this.range * this.efficiency;
            Vars.indexer.eachBlock((Teamc)this, realRange, other -> true, other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(other.block != null && other.block.canOverdrive ? Color.valueOf((String)"bf92f9") : Pal.heal).a(Mathf.absin((float)4.0f, (float)1.0f))));
            Drawf.dashCircle((float)this.x, (float)this.y, (float)realRange, (Color)this.team.color);
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.bk);
            write.f(this.buildup);
            write.f(this.radscl);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.bk = read.bool();
            this.buildup = read.f();
            this.radscl = read.f();
        }
    }
}

