/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret.wall;

import arc.graphics.Color;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.graphics.Pal;
import mindustry.world.blocks.defense.Wall;

public class Aparajito
extends Wall {
    public float hitHealAmount = 0.05f;
    public float hitHealReload = 30.0f;
    public float healTimer = 180.0f;
    public float healRadio = 0.03f;
    public Color healColor = Pal.heal;

    public Aparajito(String name) {
        super(name);
        this.update = true;
    }

    public class AparajitoBuild
    extends Wall.WallBuild {
        public boolean wasInReload;
        public float timerHit;
        public float timerHeal;

        public AparajitoBuild() {
            super((Wall)Aparajito.this);
            this.wasInReload = false;
            this.timerHit = 0.0f;
            this.timerHeal = 0.0f;
        }

        public boolean damaged() {
            return false;
        }

        public void updateTile() {
            if (this.wasInReload) {
                this.timerHit -= Time.delta;
            }
            if (this.timerHit <= 0.0f) {
                this.wasInReload = false;
            }
            this.timerHeal = Math.max(0.0f, this.timerHeal - Time.delta);
            if (this.timerHeal <= 0.0f && this.health < this.maxHealth - 1.0E-5f) {
                if (!Vars.net.client()) {
                    this.heal(this.maxHealth() * Aparajito.this.healRadio / 60.0f * Time.delta);
                }
                if (this.timer.get(60.0f)) {
                    Fx.healBlockFull.at(this.x, this.y, 0.0f, Aparajito.this.healColor, (Object)this.block);
                }
            }
        }

        public void damage(float damage) {
            this.timerHeal = Aparajito.this.healTimer;
            if (!this.wasInReload) {
                if (!Vars.net.client()) {
                    this.heal(this.maxHealth() * Aparajito.this.hitHealAmount);
                }
                Fx.healBlockFull.at(this.x, this.y, 0.0f, Aparajito.this.healColor, (Object)this.block);
                this.timerHit = Aparajito.this.hitHealReload;
                this.wasInReload = true;
            }
            super.damage(damage);
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.wasInReload);
            write.f(this.timerHit);
            write.f(this.timerHeal);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.wasInReload = read.bool();
            this.timerHit = read.f();
            this.timerHeal = read.f();
        }
    }
}

