/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.ExtraUtilitiesMod;
import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.turrets.PointDefenseTurret;
import mindustry.world.meta.Stat;

public class dissipation
extends PointDefenseTurret {
    public float maxShot = 3000.0f;
    public float baseReload = 4.0f;
    public float overReload = 3.0f;

    public dissipation(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.reload);
    }

    public void setBars() {
        super.setBars();
        this.addBar("amount", entity -> new Bar(() -> Core.bundle.get("bar.extra-utilities-shotAmount"), () -> entity.cooldown ? Pal.gray : Pal.accent, entity::getShot));
    }

    public class dissipationBuild
    extends PointDefenseTurret.PointDefenseBuild {
        float shot;
        boolean cooldown;

        public dissipationBuild() {
            super((PointDefenseTurret)dissipation.this);
            this.shot = 0.0f;
            this.cooldown = true;
        }

        public float getShot() {
            return this.shot / dissipation.this.maxShot;
        }

        public void updateTile() {
            if (dissipation.this.coolant == null) {
                return;
            }
            float e = this.power.status;
            if (this.shot <= 0.0f && !this.cooldown) {
                this.cooldown = true;
            }
            if (this.shot >= dissipation.this.maxShot && this.cooldown) {
                this.cooldown = false;
            }
            if (this.cooldown) {
                float maxUsed = dissipation.this.coolant.amount;
                Liquid liquid = this.liquids.current();
                float used = Math.min(this.liquids.get(liquid), maxUsed * Time.delta) * e * this.timeScale;
                this.shot = this.liquids.get(liquid) > 1.0f ? Math.min(dissipation.this.maxShot, this.shot + dissipation.this.overReload * (1.0f + (liquid.heatCapacity - 0.4f) * 0.9f) * dissipation.this.coolantMultiplier * e * 0.28f * this.timeScale * Time.delta) : Math.min(dissipation.this.maxShot, this.shot + dissipation.this.overReload * e * this.timeScale * Time.delta);
                this.liquids.remove(liquid, used);
                if (Mathf.chance((double)(0.06 * (double)used))) {
                    dissipation.this.coolEffect.at(this.x + (float)Mathf.range((int)(this.block.size * 8 / 2)), this.y + (float)Mathf.range((int)(this.block.size * 8 / 2)));
                }
            } else {
                float maxUsed = dissipation.this.coolant.amount;
                Liquid liquid = this.liquids.current();
                float used = Math.min(this.liquids.get(liquid), maxUsed * Time.delta) * e * this.timeScale;
                this.shot = this.liquids.get(liquid) > 1.0f ? Math.min(dissipation.this.maxShot, this.shot + dissipation.this.baseReload * (1.0f + (liquid.heatCapacity - 0.4f) * 0.9f) * dissipation.this.coolantMultiplier * 0.28f * this.timeScale * Time.delta * e) : Math.min(dissipation.this.maxShot, this.shot + dissipation.this.baseReload * this.timeScale * Time.delta * e);
                this.target = (Bullet)Groups.bullet.intersect(this.x - dissipation.this.range, this.y - dissipation.this.range, dissipation.this.range * 2.0f, dissipation.this.range * 2.0f).min(b -> b.team != this.team && b.type.hittable, b -> b.dst2((Position)this));
                if (this.target != null && !this.target.isAdded()) {
                    this.target = null;
                }
                if (dissipation.this.coolant != null && this.target != null) {
                    this.liquids.remove(liquid, used);
                    if (Mathf.chance((double)(0.06 * (double)used))) {
                        dissipation.this.coolEffect.at(this.x + (float)Mathf.range((int)(this.block.size * 8 / 2)), this.y + (float)Mathf.range((int)(this.block.size * 8 / 2)));
                    }
                }
                if (e < 0.01f) {
                    return;
                }
                if (this.target != null && this.target.within((Position)this, dissipation.this.range) && this.target.team != this.team && this.target.type != null && this.target.type.hittable) {
                    float dest = this.angleTo((Position)this.target);
                    this.rotation = Angles.moveToward((float)this.rotation, (float)dest, (float)(dissipation.this.rotateSpeed * this.edelta()));
                    if (Angles.within((float)this.rotation, (float)dest, (float)dissipation.this.shootCone)) {
                        this.target.remove();
                        this.shot = Math.max(0.0f, this.shot - 60.0f);
                        Tmp.v1.trns(this.rotation, dissipation.this.shootLength);
                        dissipation.this.beamEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation, dissipation.this.color, (Object)new Vec2().set((Position)this.target));
                        dissipation.this.shootEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation, dissipation.this.color);
                        dissipation.this.hitEffect.at(this.target.x, this.target.y, dissipation.this.color);
                        dissipation.this.shootSound.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, Mathf.random((float)0.9f, (float)1.0f));
                    }
                }
            }
        }

        public void draw() {
            super.draw();
            Draw.color();
            Draw.alpha((float)(this.cooldown ? 1.0f : 0.0f));
            Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("dissipation-low")), (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
        }

        public boolean shouldConsume() {
            return super.shouldConsume() && (this.target != null || this.cooldown);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.shot);
            write.bool(this.cooldown);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.shot = read.f();
            this.cooldown = read.bool();
        }
    }
}

