/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret.TowerDefence;

import ExtraUtilities.ui.ItemImage;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.ItemStack;
import mindustry.ui.Bar;
import mindustry.ui.ReqImage;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class MineCell
extends Block {
    public Seq<String> floors = new Seq();
    public float mineInter = 120.0f;
    public float range = 80.0f;
    public BulletType mine;
    public int mines = 4;
    public float mineSpread = 4.0f;
    public float mineRotationSpread = 120.0f;
    public float moveTime = 30.0f;
    public ItemStack[] mineConsumes = new ItemStack[0];
    public int fms = 5;

    public MineCell(String name) {
        super(name);
        this.update = true;
        this.solid = true;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.accent);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, this.mine})));
        this.stats.add(Stat.reload, 60.0f / this.mineInter, StatUnit.perSecond);
        this.stats.add(Stat.input, t -> {
            t.defaults().left();
            t.row();
            t.table(tx -> tx.add((CharSequence)"[accent]\u81ea\u52a8\u4ece\u6838\u5fc3\u83b7\u53d6[]"));
            t.row();
            t.table(Styles.grayPanel, i -> {
                int r = 0;
                for (ItemStack is : this.mineConsumes) {
                    if (r % 3 == 0) {
                        i.row();
                    }
                    i.add((Element)new ItemImage(is)).pad(4.0f);
                    ++r;
                }
            });
        });
        if (this.floors.size > 0) {
            this.stats.add(Stat.tiles, t -> {
                t.row();
                t.table(i -> {
                    int r = 0;
                    for (String s : this.floors) {
                        Block f = Vars.content.block(s);
                        if (f == null) continue;
                        if (r % 4 == 0) {
                            i.row();
                        }
                        i.image(f.uiIcon).pad(3.0f);
                        ++r;
                    }
                });
            });
        }
    }

    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar(() -> "reload", () -> Pal.lightOrange, () -> entity.timeMine / this.mineInter));
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-bottom"), Core.atlas.find(this.name + "-f0"), Core.atlas.find(this.name)};
    }

    public class MineCellBuild
    extends Building {
        public float timeMine = 0.0f;
        public Seq<Tile> fs = new Seq();
        public float fm = 0.0f;
        public boolean open = false;

        public void draw() {
            TextureAtlas.AtlasRegion r = Core.atlas.find(MineCell.this.name);
            TextureAtlas.AtlasRegion bt = Core.atlas.find(MineCell.this.name + "-bottom");
            Draw.rect((TextureRegion)bt, (float)this.x, (float)this.y);
            TextureAtlas.AtlasRegion f = Core.atlas.find(MineCell.this.name + "-f" + (int)Math.min(this.fm * (float)MineCell.this.fms, (float)(MineCell.this.fms - 1)));
            Draw.rect((TextureRegion)f, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)r, (float)this.x, (float)this.y);
        }

        public void updateTile() {
            super.updateTile();
            this.fm = this.open ? Mathf.lerpDelta((float)this.fm, (float)1.0f, (float)0.3f) : Mathf.lerpDelta((float)this.fm, (float)0.0f, (float)0.15f);
            if (this.fm >= 0.99f) {
                this.open = false;
            }
            if (this.coreCanConsume()) {
                this.timeMine += this.edelta();
            }
            if (this.timeMine >= MineCell.this.mineInter) {
                this.initFloor();
                this.creatMine();
                this.coreConsume();
                this.timeMine = 0.0f;
            }
        }

        public void creatMine() {
            block3: {
                block2: {
                    this.open = true;
                    if (this.fs.size <= 0) break block2;
                    int i = Mathf.random((int)0, (int)(this.fs.size - 1));
                    Tile f = (Tile)this.fs.get(i);
                    if (f == null) break block3;
                    float dst = this.dst((Position)f);
                    float ang = this.angleTo((Position)f);
                    for (int m = 0; m < MineCell.this.mines; ++m) {
                        float rg = Mathf.random((float)MineCell.this.mineRotationSpread);
                        MineCell.this.mine.create((Entityc)this, this.team, this.x + Mathf.random((float)(-MineCell.this.mineSpread), (float)MineCell.this.mineSpread), this.y + Mathf.random((float)(-MineCell.this.mineSpread), (float)MineCell.this.mineSpread), ang, -1.0f, 1.0f, 1.0f, (Object)Float.valueOf(rg), b -> b.initVel(b.rotation(), dst / MineCell.this.moveTime * 2.0f * Math.max(0.0f, 1.0f - b.time / MineCell.this.moveTime)));
                    }
                    break block3;
                }
                float dst = Mathf.random((float)((float)MineCell.this.size / 2.0f * 8.0f), (float)MineCell.this.range);
                float ang = Mathf.random((int)360);
                for (int m = 0; m < MineCell.this.mines; ++m) {
                    float rg = Mathf.random((float)MineCell.this.mineRotationSpread);
                    MineCell.this.mine.create((Entityc)this, this.team, this.x + Mathf.random((float)(-MineCell.this.mineSpread), (float)MineCell.this.mineSpread), this.y + Mathf.random((float)(-MineCell.this.mineSpread), (float)MineCell.this.mineSpread), ang, -1.0f, 1.0f, 1.0f, (Object)Float.valueOf(rg), b -> b.initVel(b.rotation(), dst / MineCell.this.moveTime * 2.0f * Math.max(0.0f, 1.0f - b.time / MineCell.this.moveTime)));
                }
            }
        }

        public void initFloor() {
            this.fs.clear();
            int tx = World.toTile((float)this.x);
            int ty = World.toTile((float)this.y);
            int tr = (int)(MineCell.this.range / 8.0f);
            for (int x = -tr; x <= tr; ++x) {
                for (int y = -tr; y <= tr; ++y) {
                    Tile f = Vars.world.tile(x + tx, y + ty);
                    if (f == null || !this.within((Position)f, MineCell.this.range) || !f.block().isAir() || !MineCell.this.floors.contains((Object)f.floor().name)) continue;
                    this.fs.add((Object)f);
                }
            }
        }

        public boolean coreCanConsume() {
            if (this.core() == null) {
                return false;
            }
            if (Vars.state.rules.infiniteResources || this.cheating()) {
                return true;
            }
            for (ItemStack is : MineCell.this.mineConsumes) {
                if (this.core().items.get(is.item) >= is.amount) continue;
                return false;
            }
            return true;
        }

        public void coreConsume() {
            if (this.core() == null || Vars.state.rules.infiniteResources || this.cheating()) {
                return;
            }
            if (this.coreCanConsume()) {
                for (ItemStack is : MineCell.this.mineConsumes) {
                    this.core().items.remove(is);
                }
            }
        }

        public void drawSelect() {
            super.drawSelect();
            if (this.fs.size > 0) {
                for (Tile f : this.fs) {
                    float sin = Mathf.absin((float)Time.time, (float)5.0f, (float)1.0f);
                    Draw.color((Color)Tmp.c1.set(this.team.color).a(sin * 0.6f));
                    Fill.square((float)f.worldx(), (float)f.worldy(), (float)2.0f);
                    Draw.reset();
                }
            }
            Drawf.dashCircle((float)this.x, (float)this.y, (float)MineCell.this.range, (Color)this.team.color);
        }

        public void displayConsumption(Table table) {
            super.displayConsumption(table);
            table.table(c -> {
                int i = 0;
                for (ItemStack stack : MineCell.this.mineConsumes) {
                    c.add((Element)new ReqImage((Element)new ItemImage(stack.item.uiIcon, Math.round(stack.amount)), () -> Vars.state.rules.infiniteResources || this.cheating() || this.core() != null && this.core().items.has(stack.item, Math.round(stack.amount)))).padRight(8.0f);
                    if (++i % 4 != 0) continue;
                    c.row();
                }
            }).left();
        }

        public BlockStatus status() {
            if (!this.enabled) {
                return BlockStatus.logicDisable;
            }
            if (!this.shouldConsume()) {
                return BlockStatus.noOutput;
            }
            if (!(this.efficiency <= 0.0f) && this.productionValid() && this.coreCanConsume()) {
                return Vars.state.tick / 30.0 % 1.0 < (double)this.efficiency ? BlockStatus.active : BlockStatus.noInput;
            }
            return BlockStatus.noInput;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.timeMine);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.timeMine = read.f();
        }
    }
}

