/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Prism_old
extends PowerTurret {
    public float angleShiftStrength = 5.0f;
    public float shiftAngel = 30.0f;
    public float sideOffsetFirst = 4.0f;
    public float sideOffset = 2.5f;
    public float fade = 0.001f;
    public int upTime = 3;
    public float shootDuration = 600.0f;
    public float firingMoveFract = 0.25f;
    public float reloadTime = 240.0f;

    public Prism_old(String name) {
        super(name);
        this.canOverdrive = false;
        this.coolantMultiplier = 1.0f;
        this.shootSound = Sounds.laser;
        this.loopSound = Sounds.pulse;
        this.loopSoundVolume = 2.0f;
    }

    public void init() {
        super.init();
        if (this.coolant == null) {
            this.coolant = (ConsumeLiquidBase)this.findConsumer(c -> c instanceof ConsumeLiquidBase);
        }
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.reload);
        this.stats.add(Stat.reload, 60.0f / this.reloadTime + " * 6", new Object[]{StatUnit.perSecond});
        this.stats.remove(Stat.booster);
        this.stats.add(Stat.input, StatValues.boosters((float)this.reloadTime, (float)this.coolant.amount, (float)this.coolantMultiplier, (boolean)false, arg_0 -> ((Prism_old)this).consumesLiquid(arg_0)));
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public class PrismOldBuild
    extends PowerTurret.PowerTurretBuild {
        public Bullet[] bullets;
        public float bulletLife;
        public float bulletTime;
        public float bulletHeat;
        public float faded;
        public float _reloadTime;
        public Vec2 tr;

        public PrismOldBuild() {
            super((PowerTurret)Prism_old.this);
            this.bullets = new Bullet[]{null, null, null, null, null, null};
            this.bulletLife = 0.0f;
            this.bulletTime = 0.0f;
            this.bulletHeat = 0.0f;
            this.faded = Prism_old.this.fade;
            this._reloadTime = Prism_old.this.reloadTime;
            this.tr = new Vec2();
        }

        protected void updateCooling() {
        }

        public boolean shouldConsume() {
            return this.bulletLife > 0.0f || this.isActive() || this.isShooting();
        }

        public boolean checkBullet(Bullet[] bs) {
            if (bs.length == 0) {
                return false;
            }
            for (Bullet b : bs) {
                if (b != null) continue;
                return false;
            }
            return true;
        }

        public void updateTile() {
            super.updateTile();
            if (this.bulletLife > 0.0f && this.checkBullet(this.bullets)) {
                this.wasShooting = true;
                this.faded = Math.min(this.faded + Prism_old.this.fade * Time.delta, 1.0f);
                for (int n = 0; n < this.bullets.length; ++n) {
                    int data = n * (360 / this.bullets.length);
                    float sine = Mathf.sinDeg((float)((float)data + this.bulletTime * (Prism_old.this.angleShiftStrength * (1.6f - this.bulletHeat))));
                    this.tr.trns(this.rotation, (float)(this.block.size * 8) / 2.0f - Prism_old.this.recoil + Prism_old.this.shootX, sine * (Prism_old.this.sideOffsetFirst * this.bulletHeat + Prism_old.this.sideOffset));
                    this.bullets[n].rotation(this.rotation + sine * Prism_old.this.shiftAngel * this.bulletHeat);
                    this.bullets[n].set(this.x + this.tr.x, this.y + this.tr.y);
                    this.bullets[n].time = 0.0f;
                }
                this.curRecoil = 1.0f;
                this.heat = 1.0f;
                this.bulletTime += Time.delta;
                this.bulletLife -= Time.delta / Math.max(this.power.status, 1.0E-5f);
                if (this.bulletLife <= 0.0f) {
                    Arrays.fill(this.bullets, null);
                    this.bulletTime = 0.0f;
                    this.bulletHeat = 0.0f;
                    this.faded = Prism_old.this.fade;
                }
            } else if (this._reloadTime > 0.0f) {
                this.wasShooting = true;
                if (Prism_old.this.coolant != null) {
                    Liquid liquid = this.liquids.current();
                    float maxUsed = Prism_old.this.coolant.amount;
                    float used = (this.cheating() ? maxUsed : Math.min(this.liquids.get(liquid), maxUsed)) * this.delta();
                    this._reloadTime -= used * liquid.heatCapacity * Prism_old.this.coolantMultiplier;
                    this.liquids.remove(liquid, used);
                    if (Mathf.chance((double)(0.06 * (double)used))) {
                        Prism_old.this.coolEffect.at(this.x + Mathf.range((float)((float)(Prism_old.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(Prism_old.this.size * 8) / 2.0f)));
                    }
                } else {
                    this._reloadTime -= this.edelta();
                }
            }
            this.bulletHeat = Mathf.lerpDelta((float)this.bulletHeat, (float)0.0f, (float)((float)Math.pow(this.faded, Prism_old.this.upTime)));
        }

        protected void updateReload() {
        }

        protected void updateShooting() {
            if (this.bulletLife > 0.0f || this.bullets[0] != null) {
                return;
            }
            if (this._reloadTime <= 0.0f && (this.power.status > 0.0f || this.cheating())) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this._reloadTime = Prism_old.this.reloadTime;
            }
        }

        protected void shoot(BulletType type) {
            this.tr.trns(this.rotation, Prism_old.this.shootX, 0.0f);
            this.bullet(type, this.rotation);
        }

        protected void bullet(BulletType type, float angle) {
            this.bulletTime = 0.0f;
            this.bulletLife = Prism_old.this.shootDuration;
            for (int s = 0; s < 6; ++s) {
                int data = s * 60;
                float sine = Mathf.sinDeg((float)((float)data + this.bulletTime * Prism_old.this.angleShiftStrength));
                this.tr.trns(angle, (float)(this.block.size * 8) / 2.0f, sine * Prism_old.this.sideOffset);
                this.bullets[s] = type.create((Entityc)this.tile.build, this.team, this.x + this.tr.x, this.y + this.tr.y, angle + sine * Prism_old.this.shiftAngel);
                this.bullets[s].data = data;
            }
            this.bulletHeat = 1.0f;
        }

        public float progress() {
            return 1.0f - Mathf.clamp((float)(this._reloadTime / Prism_old.this.reloadTime));
        }

        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward((float)this.rotation, (float)targetRot, (float)(this.power.status * Prism_old.this.rotateSpeed * this.delta() * (this.bulletLife > 0.0f ? Prism_old.this.firingMoveFract : 1.0f)));
        }

        public float activeSoundVolume() {
            return 1.0f;
        }

        public boolean shouldActiveSound() {
            return this.bullets[0] != null;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this._reloadTime);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this._reloadTime = read.f();
        }
    }
}

