/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.worlds.entity.bullet.PrismLaser;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.util.Time;
import java.util.Arrays;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.type.StatusEffect;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class Prism
extends Turret {
    public float angleShiftStrength = 5.0f;
    public float shiftAngel = 30.0f;
    public float sideOffsetFirst = 4.0f;
    public float sideOffset = 3.0f;
    public float fade = 0.001f;
    public int upTime = 3;
    public float firingMoveFract = 0.4f;
    public float maxShootDr = 3600.0f;
    public StatusEffect[] statuses = new StatusEffect[]{StatusEffects.blasted, StatusEffects.shocked, StatusEffects.electrified, StatusEffects.freezing, StatusEffects.wet, StatusEffects.sapped};
    public BulletType shootType;
    public BulletType[] shootTypes = new BulletType[0];
    public float rainbowDamage = 90.0f;
    public float rainbowWidth = 11.0f;

    public Prism(String name) {
        super(name);
        this.canOverdrive = false;
        this.coolantMultiplier = 1.0f;
        this.shootSound = Sounds.laser;
        this.loopSound = Sounds.pulse;
        this.loopSoundVolume = 2.0f;
        this.recoilTime = 30.0f;
        this.consumeLiquid(Liquids.cryofluid, 0.5f);
        this.liquidCapacity = 30.0f;
    }

    public void init() {
        super.init();
        if (this.statuses.length > 0) {
            this.shootTypes = new BulletType[this.statuses.length];
            for (int i = 0; i < this.statuses.length; ++i) {
                final int finalI = i;
                this.shootTypes[i] = new PrismLaser(this.rainbowDamage, this.rainbowWidth, this.range){
                    {
                        super(damage, width, length);
                        this.status = Prism.this.statuses[finalI];
                        this.statusDuration = 60.0f;
                        if (finalI < 3) {
                            this.pierceArmor = true;
                        }
                    }
                };
            }
            this.shootType = this.shootTypes[0];
        }
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.reload);
        this.stats.remove(Stat.inaccuracy);
        for (int i = 0; i < this.shootTypes.length; ++i) {
            this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this.statuses[i], this.shootTypes[i]})));
        }
    }

    public class PrismBuild
    extends Turret.TurretBuild {
        public Bullet[] bullets;
        public float bulletTime;
        public float bulletHeat;
        public float faded;
        public float bulletLife;
        public Vec2 tr;

        public PrismBuild() {
            super((Turret)Prism.this);
            this.bullets = new Bullet[Prism.this.statuses.length];
            this.bulletTime = 0.0f;
            this.bulletHeat = 0.0f;
            this.faded = Prism.this.fade;
            this.bulletLife = 0.0f;
            this.tr = new Vec2();
        }

        public BulletType useAmmo() {
            return Prism.this.shootType;
        }

        public boolean hasAmmo() {
            return this.canConsume();
        }

        private boolean liquidAcc() {
            return !Prism.this.hasLiquids || this.liquids.get(this.liquids.current()) > Prism.this.liquidCapacity / 6.0f;
        }

        public boolean canConsume() {
            return super.canConsume() && this.liquidAcc();
        }

        public BulletType peekAmmo() {
            return Prism.this.shootType;
        }

        public boolean shouldConsume() {
            return this.isActive() || this.isShooting() && this.liquidAcc();
        }

        public boolean checkBullet() {
            if (Prism.this.shootTypes.length == 0 || this.bullets.length == 0) {
                return false;
            }
            for (Bullet b : this.bullets) {
                if (b != null) continue;
                return false;
            }
            return true;
        }

        public void removeBullet() {
            for (int i = 0; i < this.bullets.length; ++i) {
                if (this.bullets[i] == null || this.bullets[i].isAdded() && this.bullets[i].type != null && this.bullets[i].owner == this) continue;
                this.bullets[i] = null;
            }
        }

        public void updateTile() {
            super.updateTile();
            float ammoFact = this.efficiency;
            Consume cs = Prism.this.findConsumer(f -> f instanceof ConsumeLiquidBase);
            if (cs instanceof ConsumeLiquid) {
                ConsumeLiquid cl = (ConsumeLiquid)cs;
                ammoFact = Math.min(ammoFact, this.liquids.get(cl.liquid) / Prism.this.liquidCapacity);
            }
            this.unit.ammo((float)this.unit.type().ammoCapacity * ammoFact);
            this.removeBullet();
            if (this.bulletLife < Prism.this.maxShootDr && this.checkBullet()) {
                this.wasShooting = true;
                this.faded = Math.min(this.faded + Prism.this.fade * Time.delta, 1.0f);
                for (int n = 0; n < this.bullets.length; ++n) {
                    int data = n * (360 / this.bullets.length);
                    float sin = Mathf.sinDeg((float)((float)data + this.bulletTime * (Prism.this.angleShiftStrength * (1.6f - this.bulletHeat))));
                    this.tr.trns(this.rotation, (float)(this.block.size * 8) / 2.0f - Prism.this.recoil + Prism.this.shootX, sin * (Prism.this.sideOffsetFirst * this.bulletHeat + Prism.this.sideOffset));
                    this.bullets[n].rotation(this.rotation + sin * Prism.this.shiftAngel * this.bulletHeat);
                    this.bullets[n].set(this.x + this.tr.x, this.y + this.tr.y);
                    this.bullets[n].damage = Prism.this.rainbowDamage * (1.0f - this.bulletLife / Prism.this.maxShootDr * 0.75f);
                    if (!this.isShooting() || !this.hasAmmo()) continue;
                    this.bullets[n].time = 0.0f;
                }
                if (this.isShooting() && this.hasAmmo()) {
                    this.bulletLife += Time.delta;
                }
                this.curRecoil = 1.0f;
                this.heat = 1.0f;
                this.bulletTime += Time.delta;
            }
            this.bulletHeat = Mathf.lerpDelta((float)this.bulletHeat, (float)0.0f, (float)((float)Math.pow(this.faded, Prism.this.upTime)));
        }

        protected void updateReload() {
        }

        protected void updateShooting() {
            if (!this.checkBullet() && this.canConsume() && !this.charging() && this.shootWarmup >= Prism.this.minWarmup) {
                this.shoot();
            }
        }

        protected void updateCooling() {
        }

        protected void shoot() {
            this.tr.trns(this.rotation, Prism.this.shootX, 0.0f);
            this.bullet(this.rotation);
        }

        protected void bullet(float angle) {
            Arrays.fill(this.bullets, null);
            this.bulletTime = 0.0f;
            this.bulletHeat = 0.0f;
            this.bulletLife = 0.0f;
            this.faded = Prism.this.fade;
            for (int s = 0; s < Prism.this.shootTypes.length; ++s) {
                if (Prism.this.shootTypes[s] == null) {
                    return;
                }
                int data = s * (360 / Prism.this.shootTypes.length);
                float sine = Mathf.sinDeg((float)((float)data + this.bulletTime * Prism.this.angleShiftStrength));
                this.tr.trns(angle, (float)(this.block.size * 8) / 2.0f, sine * Prism.this.sideOffset);
                this.bullets[s] = Prism.this.shootTypes[s].create((Entityc)this.tile.build, this.team, this.x + this.tr.x, this.y + this.tr.y, angle + sine * Prism.this.shiftAngel);
                this.bullets[s].data = data;
            }
            this.bulletHeat = 1.0f;
        }

        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward((float)this.rotation, (float)targetRot, (float)(this.power.status * Prism.this.rotateSpeed * this.delta() * (this.checkBullet() ? Prism.this.firingMoveFract : 1.0f)));
        }

        public boolean shouldActiveSound() {
            return this.bullets[0] != null;
        }
    }
}

