/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.turret;

import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUItems;
import ExtraUtilities.worlds.meta.EUStatValues;
import arc.Graphics;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Posc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.meta.Stat;

public class Fiammetta
extends ItemTurret {
    public Fiammetta(String name) {
        super(name);
        this.logicConfigurable = false;
        this.configurable = true;
        this.config(Point2.class, (build, point2) -> build.pos.set((float)point2.x, (float)point2.y));
    }

    public void setStats() {
        super.setStats();
        if (this.ammoTypes == null) {
            return;
        }
        this.stats.add(Stat.ammo, EUStatValues.ammoString(this.ammoTypes, "fa"));
    }

    public void setBars() {
        super.setBars();
        this.removeBar("items");
    }

    public class FiammettaBuild
    extends ItemTurret.ItemTurretBuild {
        public int link;
        public Vec2 pos;

        public FiammettaBuild() {
            super((ItemTurret)Fiammetta.this);
            this.link = -1;
            this.pos = new Vec2();
        }

        public void targetPosition(Posc p) {
            if (this.peekAmmo() == Fiammetta.this.ammoTypes.get((Object)EUItems.lightninAlloy)) {
                if (!this.hasAmmo() || this.pos == null) {
                    return;
                }
                this.targetPos.set(this.pos);
            } else {
                super.targetPosition(p);
            }
        }

        public void updateTile() {
            if (this.link == -1) {
                int rtx = (int)EUGet.dx(this.x, this.range(), this.rotation);
                int rty = (int)EUGet.dy(this.y, this.range(), this.rotation);
                this.pos.set((float)rtx, (float)rty);
            }
            this.link = Point2.pack((int)((int)this.pos.x), (int)((int)this.pos.y));
            if (!this.isControlled() && this.peekAmmo() == Fiammetta.this.ammoTypes.get((Object)EUItems.lightninAlloy) && this.pos != null) {
                this.targetPos = this.pos;
                if (this.shouldTurn()) {
                    this.turnToTarget(this.angleTo((Position)this.pos));
                }
                if (Angles.angleDist((float)this.rotation, (float)this.angleTo((Position)this.pos)) < Fiammetta.this.shootCone) {
                    this.wasShooting = true;
                    this.updateShooting();
                }
            }
            super.updateTile();
        }

        public Graphics.Cursor getCursor() {
            return this.peekAmmo() != Fiammetta.this.ammoTypes.get((Object)EUItems.lightninAlloy) ? Graphics.Cursor.SystemCursor.arrow : super.getCursor();
        }

        public void drawConfigure() {
            if (this.peekAmmo() != Fiammetta.this.ammoTypes.get((Object)EUItems.lightninAlloy)) {
                this.deselect();
                return;
            }
            super.drawConfigure();
            Drawf.dashCircle((float)this.x, (float)this.y, (float)this.range(), (Color)this.team.color);
            Drawf.dashCircle((float)this.x, (float)this.y, (float)Fiammetta.this.minRange, (Color)Pal.remove);
            Lines.stroke((float)2.0f, (Color)Pal.gray);
            Lines.line((float)this.x, (float)this.y, (float)this.pos.x, (float)this.pos.y);
            Lines.stroke((float)1.4f, (Color)Pal.place);
            Lines.line((float)this.x, (float)this.y, (float)this.pos.x, (float)this.pos.y);
            Fill.circle((float)this.pos.x, (float)this.pos.y, (float)5.0f);
            for (int i = 0; i < 4; ++i) {
                float angle = i * 90;
                Draw.color((Color)Pal.gray);
                Drawf.tri((float)(this.pos.x + Angles.trnsx((float)(angle + Time.time), (float)24.0f)), (float)(this.pos.y + Angles.trnsy((float)(angle + Time.time), (float)24.0f)), (float)12.0f, (float)-7.2f, (float)(angle + Time.time));
                Draw.color((Color)Pal.place);
                Drawf.tri((float)(this.pos.x + Angles.trnsx((float)(angle + Time.time), (float)24.0f)), (float)(this.pos.y + Angles.trnsy((float)(angle + Time.time), (float)24.0f)), (float)10.0f, (float)-6.0f, (float)(angle + Time.time));
            }
        }

        public boolean onConfigureTapped(float x, float y) {
            if (this.within(x, y, this.range()) && !this.within(x, y, Fiammetta.this.minRange)) {
                this.configure(Point2.unpack((int)Point2.pack((int)((int)x), (int)((int)y))));
                return true;
            }
            return false;
        }

        public Point2 config() {
            if (this.tile == null) {
                return null;
            }
            return Point2.unpack((int)this.link).sub((int)this.tile.x, (int)this.tile.y);
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.i((int)this.pos.x);
            write.i((int)this.pos.y);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.pos.set((float)read.i(), (float)read.i());
        }
    }
}

