/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.power;

import ExtraUtilities.worlds.meta.EUStatValues;
import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class SpaceGenerator
extends PowerGenerator {
    public int space = 3;
    private int edgeSpace;
    public Color validColor = Pal.accent;
    public Color invalidColor = Pal.remove;
    public boolean blockedOnlySolid = false;
    public boolean haveBasicPowerOutput = true;
    public Attribute attribute = null;
    public Color attributeColor = Pal.accent;
    public Color negativeAttributeColor = Pal.accent;
    public float efficiencyScale = 1.0f;
    public boolean display = true;
    public Effect outEffect = Fx.none;
    public float outTimer = 30.0f;
    public Effect tileEffect = Fx.none;
    public float tileTimer = 30.0f;

    public SpaceGenerator(String name) {
        super(name);
        this.flags = EnumSet.of((Enum[])new BlockFlag[0]);
        this.envEnabled = -1;
        this.powerProduction = 0.083333336f;
    }

    public void init() {
        super.init();
        this.edgeSpace = this.space;
        this.space += this.size / 2;
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(this.generationType);
        this.stats.add(this.generationType, this.powerProduction * 60.0f, StatUnit.powerSecond);
        if (this.haveBasicPowerOutput) {
            this.stats.add(Stat.tiles, EUStatValues.colorString(this.validColor, Core.bundle.get("stat.space-generator-valid")));
        }
        this.stats.add(Stat.tiles, EUStatValues.colorString(this.invalidColor, Core.bundle.get("stat.space-generator-invalid")));
        if (this.attribute != null) {
            this.stats.add(Stat.tiles, EUStatValues.colorString(this.attributeColor, Core.bundle.get("stat.space-generator-attribute")));
            if (this.negativeAttributeColor != this.attributeColor) {
                this.stats.add(Stat.tiles, EUStatValues.colorString(this.negativeAttributeColor, Core.bundle.get("stat.space-generator-negative-attribute")));
            }
            this.stats.add(this.haveBasicPowerOutput ? Stat.affinities : Stat.tiles, this.attribute, true, this.efficiencyScale, !this.display);
        }
        this.stats.add(Stat.range, (float)this.edgeSpace, StatUnit.blocks);
    }

    public void setBars() {
        super.setBars();
        if (this.hasPower && this.outputsPower) {
            this.addBar("power", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", new Object[]{Strings.fixed((float)(entity.getPowerProduction() * 60.0f * entity.timeScale()), (int)1)}), () -> Pal.powerBar, () -> entity.productionEfficiency));
        }
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashSquare((Color)(valid ? Pal.accent : Pal.remove), (float)(x *= 8), (float)(y *= 8), (float)(((float)this.space + (float)(this.size % 2) / 2.0f) * 8.0f * 2.0f));
    }

    public class SpaceGeneratorBuild
    extends PowerGenerator.GeneratorBuild {
        public Seq<Tile> tiles;
        public Seq<Tile> solids;
        public int tileNum;
        public transient Interval timer;
        private float totalProgress;

        public SpaceGeneratorBuild() {
            super((PowerGenerator)SpaceGenerator.this);
            this.tiles = new Seq();
            this.solids = new Seq();
            this.tileNum = 0;
            this.timer = new Interval(6);
        }

        public void updateTile() {
            this.totalProgress += this.warmup() * this.delta();
            if (this.timer.get(20.0f)) {
                this.tileNum = this.tileEmp();
            }
            this.productionEfficiency = this.tileNum > 0 ? Mathf.lerpDelta((float)this.productionEfficiency, (float)1.0f, (float)0.02f) : Mathf.lerpDelta((float)this.productionEfficiency, (float)0.0f, (float)0.02f);
            if (Mathf.equal((float)this.productionEfficiency, (float)1.0f, (float)0.001f)) {
                this.productionEfficiency = 1.0f;
            }
            if (this.productionEfficiency > 0.05f) {
                int i;
                Tile t;
                if (SpaceGenerator.this.outEffect != Fx.none && this.timer.get(2, SpaceGenerator.this.outTimer)) {
                    SpaceGenerator.this.outEffect.at((Position)this);
                }
                if (SpaceGenerator.this.tileEffect != Fx.none && this.tiles.size > 0 && this.timer.get(3, SpaceGenerator.this.tileTimer) && (t = (Tile)this.tiles.get(i = Mathf.random((int)(this.tiles.size - 1)))) != null) {
                    SpaceGenerator.this.tileEffect.at((Position)t);
                }
            }
        }

        public float getPowerProduction() {
            if (SpaceGenerator.this.attribute == null) {
                return this.productionEfficiency * SpaceGenerator.this.powerProduction * (float)this.tileNum;
            }
            float sum = 0.0f;
            for (int i = 0; i < this.tiles.size; ++i) {
                Tile t = (Tile)this.tiles.get(i);
                if (t == null) continue;
                sum += 1.0f + t.floor().attributes.get(SpaceGenerator.this.attribute) * SpaceGenerator.this.efficiencyScale + SpaceGenerator.this.attribute.env();
            }
            return this.productionEfficiency * SpaceGenerator.this.powerProduction * sum;
        }

        private int tileEmp() {
            this.solids.clear();
            int tr = SpaceGenerator.this.space;
            int tx = World.toTile((float)this.x);
            int ty = World.toTile((float)this.y);
            for (int x = -tr; x <= tr - (SpaceGenerator.this.size % 2 == 0 ? 1 : 0); ++x) {
                for (int y = -tr; y <= tr - (SpaceGenerator.this.size % 2 == 0 ? 1 : 0); ++y) {
                    Tile other = Vars.world.tile(x + tx, y + ty);
                    if (other == null) continue;
                    this.tiles.addUnique((Object)other);
                    if ((!SpaceGenerator.this.blockedOnlySolid || !other.block().solid) && (SpaceGenerator.this.blockedOnlySolid || other.block() == Blocks.air)) continue;
                    this.solids.addUnique((Object)other);
                }
            }
            this.tiles.removeAll(t -> this.solids.contains(t) || !SpaceGenerator.this.haveBasicPowerOutput && SpaceGenerator.this.attribute != null && t.floor().attributes.get(SpaceGenerator.this.attribute) == 0.0f);
            return this.tiles.size;
        }

        public void drawSelect() {
            Tile t;
            int i;
            super.drawSelect();
            Drawf.dashSquare((Color)Pal.accent, (float)this.x, (float)this.y, (float)(((float)SpaceGenerator.this.space + (float)(SpaceGenerator.this.size % 2) / 2.0f) * 8.0f * 2.0f));
            Draw.color((Color)SpaceGenerator.this.invalidColor);
            Draw.z((float)85.1f);
            Draw.alpha((float)0.4f);
            for (i = 0; i < this.solids.size; ++i) {
                t = (Tile)this.solids.get(i);
                if (t == null) continue;
                Fill.square((float)t.worldx(), (float)t.worldy(), (float)4.0f);
            }
            for (i = 0; i < this.tiles.size; ++i) {
                t = (Tile)this.tiles.get(i);
                if (t == null) continue;
                if (SpaceGenerator.this.attribute != null && t.floor().attributes.get(SpaceGenerator.this.attribute) != 0.0f) {
                    if (t.floor().attributes.get(SpaceGenerator.this.attribute) > 0.0f) {
                        Draw.color((Color)SpaceGenerator.this.attributeColor);
                    } else {
                        Draw.color((Color)SpaceGenerator.this.negativeAttributeColor);
                    }
                } else {
                    Draw.color((Color)SpaceGenerator.this.validColor);
                }
                Draw.z((float)85.1f);
                Draw.alpha((float)0.4f);
                Fill.square((float)t.worldx(), (float)t.worldy(), (float)4.0f);
            }
            Draw.reset();
        }

        public float warmup() {
            if (!SpaceGenerator.this.haveBasicPowerOutput) {
                return super.warmup();
            }
            int rad = SpaceGenerator.this.size + SpaceGenerator.this.edgeSpace * 2;
            int num = rad * rad - SpaceGenerator.this.size * SpaceGenerator.this.size;
            return this.productionEfficiency * (float)this.tileNum / (float)num;
        }

        public float totalProgress() {
            return this.totalProgress;
        }
    }
}

