/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.power;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUFx;
import ExtraUtilities.content.EUItems;
import ExtraUtilities.worlds.drawer.DrawFunc;
import ExtraUtilities.worlds.entity.unit.bossEntity;
import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.blocks.power.NuclearReactor;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class LightenGenerator
extends NuclearReactor {
    public float range = 36.0f;
    public float enemyRange = 120.0f;
    public float pullPower = 1320.0f;
    public BulletType effectBullet = new BulletType(){
        {
            this.collidesAir = true;
            this.hittable = false;
            this.absorbable = false;
            this.lifetime = 6.0f;
            this.speed = 1.0f;
            this.damage = 0.0f;
            this.splashDamageRadius = 56.0f;
            this.instantDisappear = true;
            this.splashDamage = 120.0f;
            this.hitShake = 3.0f;
            this.lightningColor = EUItems.lightninAlloy.color;
            this.lightningDamage = 30.0f;
            this.lightning = 5;
            this.lightningLength = 12;
            this.hitSound = Sounds.release;
            this.ammoMultiplier = 1.0f;
            this.hitEffect = new Effect(60.0f, e -> {
                int i;
                Draw.color((Color)EUItems.lightninAlloy.color);
                Lines.stroke((float)(e.fout() * 2.0f));
                Lines.circle((float)e.x, (float)e.y, (float)(4.0f + e.finpow() * this.splashDamageRadius));
                Draw.color((Color)EUItems.lightninAlloy.color);
                for (i = 0; i < 4; ++i) {
                    Drawf.tri((float)e.x, (float)e.y, (float)6.0f, (float)(36.0f * e.fout()), (float)(((float)i - e.fin()) * 90.0f));
                }
                Draw.color();
                for (i = 0; i < 4; ++i) {
                    Drawf.tri((float)e.x, (float)e.y, (float)3.0f, (float)(16.0f * e.fout()), (float)(((float)i - e.fin()) * 90.0f));
                }
            });
        }
    };
    public BulletType effectBullet2 = new BulletType(){
        {
            this.damage = 100.0f;
            this.speed = 4.0f;
            this.lifetime = 120.0f;
            this.hitEffect = Fx.none;
            this.despawnEffect = Fx.none;
            this.ammoMultiplier = 3.0f;
            this.trailEffect = new Effect(12.0f, e -> {
                Draw.color((Color)EUItems.lightninAlloy.color);
                Drawf.tri((float)e.x, (float)e.y, (float)(4.0f * e.fout()), (float)11.0f, (float)e.rotation);
                if (e.data instanceof Float) {
                    float time = ((Float)e.data).floatValue();
                    Drawf.tri((float)e.x, (float)e.y, (float)(4.0f * e.fout()), (float)(15.0f * Math.min(1.0f, time / 8.0f * 0.8f + 0.2f)), (float)(e.rotation - 180.0f));
                }
            });
            this.reflectable = false;
            this.hittable = false;
            this.absorbable = false;
        }

        public void update(Bullet b) {
            Entityc entityc = b.owner;
            if (entityc instanceof LightenGeneratorBuild) {
                LightenGeneratorBuild owner = (LightenGeneratorBuild)entityc;
                if (b.time > 18.0f) {
                    float homingPower;
                    Teamc target = Units.closestTarget((Team)b.team, (float)owner.x, (float)owner.y, (float)LightenGenerator.this.enemyRange, e -> e.isGrounded() && this.collidesGround || e.isFlying() && this.collidesAir, t -> this.collidesGround);
                    Teamc targetTo = target != null ? target : (Teamc)b.owner;
                    float f = homingPower = target == null ? 0.08f : 0.5f;
                    if (targetTo != null) {
                        b.vel.setAngle(Mathf.slerpDelta((float)(b.rotation() + 0.01f), (float)b.angleTo((Position)targetTo), (float)homingPower));
                    }
                }
                this.trailEffect.at(b.x, b.y, b.rotation(), (Object)Float.valueOf(b.time));
            }
        }

        public void hitEntity(Bullet b, Hitboxc entity, float health) {
            if (entity instanceof Unit) {
                Unit u = (Unit)entity;
                if (!(entity instanceof bossEntity)) {
                    u.health -= this.damage;
                }
            }
            super.hitEntity(b, entity, health);
        }

        public void draw(Bullet b) {
            Draw.color((Color)EUItems.lightninAlloy.color);
            Drawf.tri((float)b.x, (float)b.y, (float)4.0f, (float)8.0f, (float)b.rotation());
            Draw.reset();
        }
    };
    public boolean explosionProof = true;
    @Nullable
    public BulletType deathBullet;

    public LightenGenerator(String name) {
        super(name);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.enemyRange, (Color)Pal.accent);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, this.effectBullet})));
        this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, this.effectBullet2})));
        if (this.deathBullet != null) {
            this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, this.deathBullet})));
        }
    }

    public class LightenGeneratorBuild
    extends NuclearReactor.NuclearReactorBuild {
        public boolean working;
        public float consumeTimer;
        public float light;

        public LightenGeneratorBuild() {
            super((NuclearReactor)LightenGenerator.this);
            this.working = false;
            this.consumeTimer = 0.0f;
            this.light = 0.0f;
        }

        public void updateTile() {
            float smoke;
            float fullness;
            if (this.items.total() == this.block.itemCapacity && !this.working) {
                EUFx.Start.at(this.x, this.y, 0.0f, (Object)Float.valueOf(LightenGenerator.this.range));
                Sounds.lasercharge2.at(this.x, this.y, 1.5f);
                Units.nearby(null, (float)this.x, (float)this.y, (float)(LightenGenerator.this.range * 2.0f), unit -> unit.impulse(Tmp.v3.set((Position)unit).sub(this.x, this.y).nor().scl(-LightenGenerator.this.pullPower)));
                this.working = true;
            }
            if (this.items.total() < 1 && this.working) {
                this.working = false;
                this.consumeTimer = 0.0f;
            }
            int fuel = this.items.get(LightenGenerator.this.fuelItem);
            this.productionEfficiency = fullness = (float)fuel / (float)LightenGenerator.this.itemCapacity;
            if (fuel > 0 && this.enabled && this.working) {
                this.heat += fullness * LightenGenerator.this.heating * Math.min(this.delta(), 4.0f);
                this.consumeTimer += this.getProgressIncrease(LightenGenerator.this.itemDuration);
                if (this.consumeTimer >= 1.0f) {
                    this.consume();
                    LightenGenerator.this.effectBullet.create((Entityc)this, this.team, this.x + (float)Mathf.range((int)(LightenGenerator.this.size * 4)), this.y + (float)Mathf.range((int)(LightenGenerator.this.size * 4)), 0.0f);
                    float random = Mathf.random((int)0, (int)360);
                    for (int i = 0; i < 3; ++i) {
                        LightenGenerator.this.effectBullet2.create((Teamc)this, this.x, this.y, 120.0f * (float)i + random);
                    }
                    this.consumeTimer %= 1.0f;
                }
            } else {
                this.productionEfficiency = 0.0f;
            }
            if (this.heat > 0.0f) {
                float maxUsed = Math.min(this.liquids.currentAmount(), this.heat / LightenGenerator.this.coolantPower);
                this.heat -= maxUsed * LightenGenerator.this.coolantPower;
                this.liquids.remove(this.liquids.current(), maxUsed);
            }
            if (this.heat > LightenGenerator.this.smokeThreshold && Mathf.chance((double)((double)(smoke = 1.0f + (this.heat - LightenGenerator.this.smokeThreshold) / (1.0f - LightenGenerator.this.smokeThreshold)) / 20.0 * (double)this.delta()))) {
                Fx.reactorsmoke.at(this.x + Mathf.range((float)((float)(LightenGenerator.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(LightenGenerator.this.size * 8) / 2.0f)));
            }
            this.heat = Mathf.clamp((float)this.heat);
            if (this.heat >= 0.999f) {
                Events.fire((Enum)EventType.Trigger.thoriumReactorOverheat);
                if (LightenGenerator.this.deathBullet != null) {
                    Call.createBullet((BulletType)LightenGenerator.this.deathBullet, (Team)this.team, (float)this.x, (float)this.y, (float)0.0f, (float)-1.0f, (float)1.0f, (float)1.0f);
                }
                this.kill();
            }
            this.light = Mathf.lerpDelta((float)this.light, (float)(this.working ? 1.0f : 0.0f), (float)0.05f);
        }

        public void createExplosion() {
        }

        public void draw() {
            super.draw();
            Draw.color((Color)EUItems.lightninAlloy.color);
            Draw.alpha((float)(this.items.total() > 0 ? 1.0f : 0.0f));
            Draw.z((float)110.0f);
            Lines.stroke((float)3.0f);
            if (!this.working) {
                DrawFunc.circlePercent(this.x, this.y, LightenGenerator.this.range, (float)this.items.total() / (float)LightenGenerator.this.itemCapacity, 135.0f);
            }
            Draw.alpha((float)this.light);
            Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("lightnin-generator-lights")), (float)this.x, (float)this.y);
        }

        public void drawSelect() {
            super.drawSelect();
            Drawf.dashCircle((float)this.x, (float)this.y, (float)LightenGenerator.this.enemyRange, (Color)Pal.accent);
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.working);
            write.f(this.consumeTimer);
            write.f(this.light);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.working = read.bool();
            this.consumeTimer = read.f();
            this.light = read.f();
        }
    }
}

