/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.liquid;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.liquid.LiquidRouter;

public class SortLiquidRouter
extends LiquidRouter {
    public SortLiquidRouter(String name) {
        super(name);
        this.configurable = true;
        this.saveConfig = true;
        this.clearOnDoubleTap = true;
        this.rotate = true;
        this.rotateDraw = false;
        this.config(Liquid.class, (tile, l) -> {
            tile.sortLiquid = l;
        });
        this.configClear(tile -> {
            tile.sortLiquid = null;
        });
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        if (this.configurable) {
            this.drawPlanConfigCenter(plan, plan.config, this.name + "-config", false);
        }
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.bottomRegion, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(this.rotate ? (float)(plan.rotation * 90) : 0.0f));
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.region, this.topRegion};
    }

    public class SortLiquidBuild
    extends LiquidRouter.LiquidRouterBuild {
        public Liquid sortLiquid;

        public SortLiquidBuild() {
            super((LiquidRouter)SortLiquidRouter.this);
            this.sortLiquid = null;
        }

        public void updateTile() {
            super.updateTile();
            if (this.sortLiquid != null && this.liquids.current() != this.sortLiquid) {
                this.liquids.clear();
            }
        }

        public void draw() {
            super.draw();
            Draw.rect((TextureRegion)SortLiquidRouter.this.topRegion, (float)this.x, (float)this.y, (float)(SortLiquidRouter.this.rotate ? this.rotdeg() : 0.0f));
            if (this.sortLiquid != null) {
                Draw.color((Color)this.sortLiquid.color);
                Draw.rect((TextureRegion)Core.atlas.find(SortLiquidRouter.this.name + "-config"), (float)this.x, (float)this.y);
            }
            Draw.color();
        }

        public void buildConfiguration(Table table) {
            ItemSelection.buildTable((Block)SortLiquidRouter.this, (Table)table, (Seq)Vars.content.liquids(), () -> this.sortLiquid, arg_0 -> ((SortLiquidBuild)this).configure(arg_0));
        }

        public Liquid config() {
            return this.sortLiquid;
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return !(SortLiquidRouter.this.rotate && Edges.getFacingEdge((Tile)source.tile, (Tile)this.tile).relativeTo(this.tile) != this.rotation || !super.acceptLiquid(source, liquid) || this.sortLiquid != null && this.sortLiquid != liquid);
        }

        public byte version() {
            return 1;
        }

        public void write(Writes write) {
            super.write(write);
            write.s(this.sortLiquid == null ? -1 : (int)this.sortLiquid.id);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.sortLiquid = id == -1 ? null : Vars.content.liquid((int)id);
        }
    }
}

