/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.liquid;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;

public class LiquidUnloadingValve
extends Block {
    public String center;
    public String arrow;
    public float speed = 10.0f;

    public LiquidUnloadingValve(String name) {
        super(name);
        this.update = true;
        this.solid = false;
        this.configurable = true;
        this.outputsLiquid = true;
        this.saveConfig = true;
        this.noUpdateDisabled = true;
        this.displayFlow = false;
        this.group = BlockGroup.liquids;
        this.envEnabled = -1;
        this.clearOnDoubleTap = true;
        this.rotate = true;
        this.config(Liquid.class, (tile, l) -> {
            tile.sortLiquid = l;
        });
        this.configClear(tile -> {
            tile.sortLiquid = null;
        });
    }

    public void load() {
        super.load();
        this.center = this.name + "-center";
        this.arrow = this.name + "-arrow";
    }

    public void setBars() {
        super.setBars();
        this.removeBar("liquid");
        this.addBar("back", entity -> new Bar(() -> Core.bundle.get("bar.input"), () -> entity.sortLiquid == null ? Color.black : entity.sortLiquid.color, () -> {
            if (entity.sortLiquid != null && entity.back() != null && entity.back().block != null && entity.back().block.hasLiquids && entity.back().block.liquidCapacity > 0.0f) {
                return entity.back().liquids.get(entity.sortLiquid) / entity.back().block.liquidCapacity;
            }
            return 0.0f;
        }));
        this.addBar("front", entity -> new Bar(() -> Core.bundle.get("bar.output"), () -> entity.sortLiquid == null ? Color.black : entity.sortLiquid.color, () -> {
            if (entity.sortLiquid != null && entity.front() != null && entity.front().block != null && entity.front().block.hasLiquids && entity.front().block.liquidCapacity > 0.0f) {
                return entity.front().liquids.get(entity.sortLiquid) / entity.front().block.liquidCapacity;
            }
            return 0.0f;
        }));
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Draw.rect((TextureRegion)Core.atlas.find(this.name), (float)x, (float)y, (float)0.0f);
        Draw.rect((TextureRegion)Core.atlas.find(this.name + "-top"), (float)x, (float)y, (float)0.0f);
        Draw.rect((TextureRegion)Core.atlas.find(this.arrow), (float)x, (float)y, (float)rotation);
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-top"), Core.atlas.find(this.arrow)};
    }

    public class LiquidUnloadingValveBuild
    extends Building {
        public Liquid sortLiquid = null;

        public void updateTile() {
            Building front = this.front();
            Building back = this.back();
            if (front != null && back != null && front.block != null && back.block != null && back.liquids != null && front.team == this.team && back.team == this.team && this.sortLiquid != null && front.acceptLiquid((Building)this, this.sortLiquid)) {
                float fl = front.liquids.get(this.sortLiquid);
                float bl = back.liquids.get(this.sortLiquid);
                float fc = front.block.liquidCapacity;
                float bc = back.block.liquidCapacity;
                if (bl > 0.0f && bl / bc > fl / fc) {
                    float amount = Math.min(LiquidUnloadingValve.this.speed, back.liquids.get(this.sortLiquid));
                    float a = Math.min(amount, front.block.liquidCapacity - front.liquids.get(this.sortLiquid));
                    float balance = Math.min(a, (bl / bc - fl / fc) * bc);
                    front.handleLiquid((Building)this, this.sortLiquid, balance);
                    back.liquids.remove(this.sortLiquid, balance);
                }
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)Core.atlas.find(LiquidUnloadingValve.this.name), (float)this.x, (float)this.y);
            Draw.color((Color)(this.sortLiquid == null ? Color.clear : this.sortLiquid.color));
            Draw.rect((TextureRegion)Core.atlas.find(LiquidUnloadingValve.this.center), (float)this.x, (float)this.y);
            Draw.color();
            Draw.rect((TextureRegion)Core.atlas.find(LiquidUnloadingValve.this.name + "-top"), (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)Core.atlas.find(LiquidUnloadingValve.this.arrow), (float)this.x, (float)this.y, (float)this.rotdeg());
        }

        public void buildConfiguration(Table table) {
            ItemSelection.buildTable((Block)LiquidUnloadingValve.this, (Table)table, (Seq)Vars.content.liquids(), () -> this.sortLiquid, arg_0 -> ((LiquidUnloadingValveBuild)this).configure(arg_0));
        }

        public Liquid config() {
            return this.sortLiquid;
        }

        public byte version() {
            return 1;
        }

        public void write(Writes write) {
            super.write(write);
            write.s(this.sortLiquid == null ? -1 : (int)this.sortLiquid.id);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.sortLiquid = id == -1 ? null : Vars.content.liquid((int)id);
        }
    }
}

