/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.worlds.blocks.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Rect;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.meta.BlockGroup;

public class StackHelper
extends Block {
    public StackHelper(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.transportation;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        x *= 8;
        y *= 8;
        x = (int)((float)x + this.offset);
        y = (int)((float)y + this.offset);
        for (int i = 0; i < 4; ++i) {
            Rect rect = Tmp.r1;
            rect.setCentered((float)x, (float)y, (float)(this.size * 8));
            float len = 8 * this.size;
            rect.x += (float)Geometry.d4x((int)i) * len;
            rect.y += (float)Geometry.d4y((int)i) * len;
            Drawf.dashRect((Color)(valid ? Pal.accent : Pal.remove), (Rect)rect);
        }
    }

    public class StackHelperBuild
    extends Building {
        public void updateTile() {
            for (int i = 0; i < 4; ++i) {
                Building b = this.nearby(i);
                if (!(b instanceof StackConveyor.StackConveyorBuild) || !(b.block instanceof StackConveyor) || b.team != this.team || ((StackConveyor.StackConveyorBuild)b).state != 1) continue;
                ((StackConveyor.StackConveyorBuild)b).cooldown = 0.0f;
            }
        }

        public void drawSelect() {
            for (int i = 0; i < 4; ++i) {
                Building b = this.nearby(i);
                if (!(b instanceof StackConveyor.StackConveyorBuild) || !(b.block instanceof StackConveyor) || b.team != this.team || ((StackConveyor.StackConveyorBuild)b).state != 1) continue;
                float sin = Mathf.absin((float)Time.time, (float)5.0f, (float)1.0f);
                Lines.stroke((float)(sin * 1.3f), (Color)Pal.accent);
                Lines.square((float)b.x, (float)b.y, (float)(b.block.size * 5), (float)0.0f);
            }
        }
    }
}

