/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.ui;

import ExtraUtilities.ExtraUtilitiesMod;
import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import java.io.IOException;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.game.Gamemode;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.MapIO;
import mindustry.maps.Map;
import mindustry.type.Category;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class RogueLikeStart
extends BaseDialog {
    public Map map;
    public Weaves weaves = Weaves.limit;
    public Difficult difficult = Difficult.normal;
    public String[] mapNames = new String[]{"MitoKenos", "YayaSitken"};
    public ObjectMap<String, TextureRegion> regionMap = new ObjectMap();
    private Rules rules;

    public RogueLikeStart() {
        super("start");
    }

    public void toShow() {
        Map[] maps = new Map[this.mapNames.length];
        for (int i = 0; i < this.mapNames.length; ++i) {
            try {
                maps[i] = MapIO.createMap((Fi)ExtraUtilitiesMod.EU.root.child("roguelike").child(this.mapNames[i] + ".msav"), (boolean)false);
                TextureAtlas.AtlasRegion region = Core.atlas.find("extra-utilities-" + this.mapNames[i]);
                if (!region.found()) continue;
                this.regionMap.put((Object)maps[i].name(), (Object)region);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.map = maps[0];
        this.cont.clear();
        this.cont.add((CharSequence)"\u7531\u4e8e\u5730\u56fe\u6587\u4ef6\u8f83\u5927\uff0c\u90e8\u5206\u673a\u578b\u65e0\u6cd5\u6253\u5f00\u4e3a\u6b63\u5e38\u60c5\u51b5").center();
        this.cont.row();
        this.cont.add((CharSequence)"some models may not be able to open...").center();
        this.cont.row();
        this.cont.image(Tex.whiteui, Pal.accent).left().width(500.0f).height(3.0f).pad(4.0f).row();
        Table playMap = new Table();
        playMap.add((CharSequence)"map").colspan(2);
        playMap.row();
        playMap.table(Tex.button, diff -> {
            for (int i = 0; i < this.mapNames.length; ++i) {
                int finalI = i;
                diff.button(this.mapNames[i], Styles.flatToggleMenut, () -> {
                    this.map = maps[finalI];
                }).update(b -> b.setChecked(this.map == maps[finalI])).size(140.0f, Vars.mobile ? 44.0f : 54.0f);
                if ((i + 1) % 3 != 0) continue;
                diff.row();
            }
        });
        this.cont.add((Element)playMap).row();
        this.cont.table(img -> {
            img.add((CharSequence)this.map.name()).row();
            if (this.regionMap.containsKey((Object)this.map.name())) {
                img.image((TextureRegion)this.regionMap.get((Object)this.map.name())).size(192.0f);
            }
            playMap.changed(() -> this.rebuildImg((Table)img));
        }).row();
        Table selweave = new Table();
        selweave.add((CharSequence)"weave").colspan(2);
        selweave.row();
        selweave.table(Tex.button, diff -> {
            int i = 0;
            for (Weaves w : Weaves.values()) {
                diff.button(w.toString(), Styles.flatToggleMenut, () -> {
                    this.weaves = w;
                }).update(b -> b.setChecked(this.weaves == w)).size(140.0f, Vars.mobile ? 44.0f : 54.0f);
                if (++i % 2 != 0) continue;
                diff.row();
            }
        });
        this.cont.add((Element)selweave);
        this.cont.row();
        Table selmode = new Table();
        selmode.add((CharSequence)"difficult").colspan(2);
        selmode.row();
        this.rules = this.map.applyRules(Gamemode.survival);
        selmode.table(Tex.button, diff -> {
            int i = 0;
            for (Difficult d : Difficult.values()) {
                diff.button(d.toString(), Styles.flatToggleMenut, () -> {
                    this.difficult = d;
                }).update(b -> b.setChecked(this.difficult == d)).size(140.0f, Vars.mobile ? 44.0f : 54.0f);
                if (++i % 2 != 0) continue;
                diff.row();
            }
        });
        this.cont.add((Element)selmode);
        this.cont.row();
        this.cont.image(Tex.whiteui, Pal.accent).left().width(500.0f).height(3.0f).pad(4.0f).row();
        this.cont.pane(ds -> {
            Table dt = new Table();
            dt.add((CharSequence)this.difficult.description()).wrap().fillX().padLeft(10.0f).width(500.0f).padTop(10.0f).left();
            Table dw = new Table();
            if (this.weaves == Weaves.limit) {
                dw.add((CharSequence)Core.bundle.format("eu-rogue.endWeave", new Object[]{this.difficult.end})).wrap().fillX().padLeft(10.0f).width(500.0f).padTop(10.0f).left();
            }
            selmode.changed(() -> this.rebuildShow(dt, dw));
            selweave.changed(() -> this.rebuildShow(dt, dw));
            ds.add((Element)dt).row();
            ds.add((Element)dw).row();
            ds.add((CharSequence)Core.bundle.get("eu-rogue-like-tip")).wrap().fillX().padLeft(10.0f).width(500.0f).padTop(10.0f);
        });
        this.buttons.clearChildren();
        this.addCloseButton();
        this.addCloseListener();
        this.buttons.button("@play", (Drawable)Icon.play, () -> {
            if (this.rules == null) {
                return;
            }
            this.difficult.apply(this.rules, this.weaves == Weaves.endless);
            Vars.control.playMap(this.map, this.rules, false);
            this.hide();
            Vars.ui.custom.hide();
        }).size(210.0f, 64.0f).update(b -> {
            if (this.map == null) {
                b.setDisabled(true);
                b.setText("Coming soon...");
            } else {
                b.setDisabled(false);
                b.setText("@play");
            }
        });
        this.show();
    }

    private void rebuildImg(Table img) {
        img.clear();
        img.add((CharSequence)this.map.name()).row();
        if (this.regionMap.containsKey((Object)this.map.name())) {
            img.image((TextureRegion)this.regionMap.get((Object)this.map.name())).size(192.0f);
        }
    }

    private void rebuildShow(Table dt, Table dw) {
        dt.clear();
        dt.add((CharSequence)this.difficult.description()).wrap().fillX().padLeft(10.0f).width(500.0f).padTop(10.0f).left();
        dw.clear();
        if (this.weaves == Weaves.limit) {
            dw.add((CharSequence)Core.bundle.format("eu-rogue.endWeave", new Object[]{this.difficult.end})).wrap().fillX().padLeft(10.0f).width(500.0f).padTop(10.0f).left();
        }
    }

    public static enum Weaves {
        limit,
        endless;


        public String toString() {
            return Core.bundle.get("eu-rogue." + this.name() + ".name");
        }
    }

    public static enum Difficult {
        easy((Cons<Rules>)((Cons)rules -> {
            rules.blockHealthMultiplier = 2.0f;
            rules.blockDamageMultiplier = 1.5f;
            rules.buildCostMultiplier = 0.5f;
            Difficult.defRule(rules);
        }), 40),
        normal((Cons<Rules>)((Cons)Difficult::defRule), 60),
        hard((Cons<Rules>)((Cons)rules -> {
            rules.blockDamageMultiplier = 0.8f;
            rules.buildCostMultiplier = 1.1f;
            rules.bannedBlocks.addAll(Vars.content.blocks().copy().removeAll(b -> b.category != Category.turret || b.size < 5));
            Difficult.defRule(rules);
        }), 80),
        impossible((Cons<Rules>)((Cons)rules -> {
            rules.blockDamageMultiplier = 0.6f;
            rules.buildCostMultiplier = 1.2f;
            rules.deconstructRefundMultiplier = 0.0f;
            rules.bannedBlocks.addAll(Vars.content.blocks().copy().removeAll(b -> b.category != Category.turret || b.size < 5));
            Difficult.defRule(rules);
        }), 100);

        private final Cons<Rules> rules;
        private final int end;

        private Difficult(Cons<Rules> rules, int end) {
            this.rules = rules;
            this.end = end;
        }

        public Rules apply(Rules in, boolean endless) {
            this.rules.get((Object)in);
            if (!endless) {
                in.winWave = this.end;
            }
            return in;
        }

        public String toString() {
            return Core.bundle.get("eu-rogue." + this.name() + ".name");
        }

        public String description() {
            return Core.bundle.get("eu-rogue." + this.name() + ".description");
        }

        public static void defRule(Rules rules) {
            rules.bannedUnits.addAll(Vars.content.units());
            rules.bannedUnits.remove((Object)UnitTypes.mono);
            rules.bannedUnits.remove((Object)UnitTypes.poly);
            rules.teams.get((Team)Team.crux).blockHealthMultiplier = 9999.0f;
        }
    }
}

