/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.content;

import ExtraUtilities.content.EUBlocks;
import ExtraUtilities.content.EUGet;
import arc.graphics.Color;
import arc.util.noise.Noise;
import mindustry.content.Blocks;
import mindustry.content.Planets;
import mindustry.content.TechTree;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.graphics.Pal;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.HexMesh;
import mindustry.graphics.g3d.HexSkyMesh;
import mindustry.graphics.g3d.MultiMesh;
import mindustry.graphics.g3d.SunMesh;
import mindustry.maps.planet.ErekirPlanetGenerator;
import mindustry.maps.planet.SerpuloPlanetGenerator;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.Block;

public class TDPlanet {
    public static Planet TD;
    public static Planet supEX;

    public static void load() {
        TD = new Planet("TD", Planets.sun, 1.0f, 2){
            {
                this.generator = new ErekirPlanetGenerator();
                this.iconColor = EUGet.MIKU;
                this.meshLoader = () -> new SunMesh((Planet)this, 4, 5.0, 0.3, 1.7, 1.2, 1.0, 1.1f, new Color[]{Color.valueOf((String)"3587F2"), Color.valueOf((String)"00FF9F"), Color.valueOf((String)"C165F7"), Color.valueOf((String)"6F3C8D"), Color.valueOf((String)"BE47E5"), Color.valueOf((String)"6E2B84")});
                this.cloudMeshLoader = () -> new MultiMesh(new GenericMesh[]{new HexSkyMesh((Planet)this, 2, 0.15f, 0.14f, 5, Color.valueOf((String)"3587F2").a(0.75f), 2, 0.42f, 1.0f, 0.43f), new HexSkyMesh((Planet)this, 3, 0.6f, 0.15f, 5, Color.valueOf((String)"00FF9F").a(0.75f), 2, 0.42f, 1.2f, 0.45f)});
                this.landCloudColor = Color.valueOf((String)"3587F2");
                this.atmosphereColor = Color.valueOf((String)"00FF9F");
                this.alwaysUnlocked = true;
                this.atmosphereRadIn = 0.02f;
                this.atmosphereRadOut = 0.3f;
                this.startSector = 12;
                this.allowLaunchSchematics = true;
                this.enemyCoreSpawnReplace = true;
                this.allowLaunchLoadout = true;
                this.allowLaunchToNumbered = false;
                this.ruleSetter = r -> {
                    r.enemyCoreBuildRadius = 1.0f;
                    r.bannedBlocks.addAll((Object[])new Block[]{Blocks.launchPad, Blocks.smite, EUBlocks.breaker, EUBlocks.quantumDomain});
                };
            }

            public void init() {
                this.applyDefaultRules(this.campaignRules);
                this.loadRules();
                if (this.techTree == null) {
                    this.techTree = (TechTree.TechNode)TechTree.roots.find(n -> n.planet == this);
                }
                if (this.techTree != null && this.autoAssignPlanet) {
                    this.techTree.addDatabaseTab((UnlockableContent)this);
                }
                for (Sector sector : this.sectors) {
                    sector.loadInfo();
                }
                if (this.generator != null) {
                    Noise.setSeed((int)(this.sectorSeed < 0 ? this.id + 1 : this.sectorSeed));
                    for (Sector sector : this.sectors) {
                        this.generator.generateSector(sector);
                    }
                    this.updateBaseCoverage();
                }
                this.clipRadius = Math.max(this.clipRadius, this.radius + this.atmosphereRadOut + 0.5f);
            }
        };
        supEX = new Planet("serpuloEX", Planets.serpulo, 0.3f, 1){
            {
                this.generator = new SerpuloPlanetGenerator(){

                    public void generateSector(Sector sector) {
                    }
                };
                this.meshLoader = () -> new HexMesh((Planet)this, 8);
                this.cloudMeshLoader = () -> new MultiMesh(new GenericMesh[]{new HexSkyMesh((Planet)this, 11, 0.15f, 0.13f, 5, new Color().set(Pal.remove).mul(0.9f).a(0.75f), 2, 0.45f, 0.9f, 0.38f), new HexSkyMesh((Planet)this, 1, 0.6f, 0.16f, 5, Pal.spore.cpy().lerp(Pal.remove, 0.55f).a(0.75f), 2, 0.45f, 1.0f, 0.41f)});
                this.launchCapacityMultiplier = 0.5f;
                this.camRadius = 0.6f;
                this.orbitRadius = 3.0f;
                this.allowWaves = true;
                this.allowWaveSimulation = true;
                this.enemyCoreSpawnReplace = true;
                this.allowLaunchToNumbered = false;
                this.prebuildBase = false;
                this.ruleSetter = r -> {
                    r.waveTeam = Team.crux;
                    r.placeRangeCheck = false;
                    r.showSpawns = false;
                    r.coreDestroyClear = true;
                };
                this.allowCampaignRules = true;
                this.showRtsAIRule = true;
                this.atmosphereColor = Color.valueOf((String)"3c1b8f");
                this.atmosphereRadIn = 0.01f;
                this.atmosphereRadOut = 0.15f;
                this.startSector = 23;
                this.alwaysUnlocked = true;
                this.allowSelfSectorLaunch = true;
                this.landCloudColor = Pal.spore.cpy().a(0.5f);
            }
        };
        Planets.serpulo.children.add((Object)supEX);
    }
}

