/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.content;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUGet;
import ExtraUtilities.content.EUItems;
import ExtraUtilities.worlds.drawer.DrawFunc;
import ExtraUtilities.worlds.entity.ability.PcShieldArcAbility;
import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.entities.Effect;
import mindustry.entities.effect.MultiEffect;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Healthc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.type.UnitType;

public class EUFx {
    public static Effect absorbEffect = new Effect(38.0f, e -> {
        Draw.color((Color)Items.sand.color);
        Angles.randLenVectors((long)e.id, (int)2, (float)(1.0f + 20.0f * e.fout()), (float)e.rotation, (float)120.0f, (x, y) -> {
            Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.0f + 1.0f));
            Fill.circle((float)(e.x + x / 2.0f), (float)(e.y + y / 2.0f), (float)(e.fout() * 2.0f));
        });
    });
    public static Effect absorbEffect2 = new Effect(50.0f, e -> {
        Draw.color((Color)Items.pyratite.color.cpy().a(0.7f));
        Angles.randLenVectors((long)e.id, (int)2, (float)(1.0f + 5.0f * e.fout()), (float)e.rotation, (float)(e.rotation + 120.0f), (x, y) -> {
            Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.0f + 1.0f));
            Fill.circle((float)(e.x + x / 2.0f), (float)(e.y + y / 2.0f), (float)(e.fout() * 2.0f));
        });
    });
    public static Effect missileTrailSmokeSmall = new Effect(90.0f, 90.0f, b -> {
        float intensity = 1.1f;
        Draw.color((Color)b.color, (float)0.7f);
        int i = 0;
        while (i < 3) {
            Fx.rand.setSeed((long)b.id * 2L + (long)i);
            float lenScl = Fx.rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), (float)e.fin((Interp)Interp.pow10Out), (int)((int)(2.0f * intensity)), (float)(9.0f * intensity), (x, y, in, out) -> {
                float fout = e.fout((Interp)Interp.pow5Out) * Fx.rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 1.2f);
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)rad);
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(rad * 1.2f), (Color)b.color, (float)0.5f);
            }));
        }
    }).layer(99.0f);
    public static Effect unitDesGone = new Effect(12.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(2.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * e.fout()));
    });
    public static Effect rainbowShoot = new Effect(16.0f, e -> {
        Draw.blend((Blending)Blending.additive);
        Draw.color((Color)EUGet.EC6.set(EUGet.rainBowRed).shiftHue(Time.time * 2.0f));
        Lines.stroke((float)(e.fout() * 1.5f));
        Angles.randLenVectors((long)e.id, (int)1, (float)(e.finpow() * 70.0f), (float)e.rotation, (float)80.0f, (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 8.0f + 1.5f));
        });
        Draw.blend();
        Draw.reset();
    });
    public static Effect prismHit = new Effect(16.0f, e -> {
        Draw.blend((Blending)Blending.additive);
        Draw.color((Color)EUGet.EC7.set(EUGet.rainBowRed).shiftHue(Time.time * 2.0f));
        Lines.stroke((float)(e.fout() * 1.5f));
        Angles.randLenVectors((long)e.id, (int)1, (float)(e.finpow() * 70.0f), (float)e.rotation, (float)80.0f, (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 8.0f + 1.5f));
        });
        Draw.blend();
        Draw.reset();
    });
    public static Effect LACraft = new Effect(60.0f, e -> {
        Draw.color((Color)Pal.surge, (Color)EUItems.lightninAlloy.color, (float)e.fin());
        Lines.stroke((float)(e.fout() * 5.0f));
        Lines.circle((float)e.x, (float)e.y, (float)(20.0f * e.fin()));
    });
    public static Effect Start = new Effect(30.0f, e -> {
        Draw.color((Color)EUItems.lightninAlloy.color);
        Lines.stroke((float)(3.0f * e.fout()));
        if (e.data instanceof Float) {
            float range = ((Float)e.data).floatValue();
            Lines.circle((float)e.x, (float)e.y, (float)(range * e.fout()));
        }
    });
    public static Effect shieldDefense = new Effect(20.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.fslope() * 2.5f));
        Lines.poly((float)e.x, (float)e.y, (int)6, (float)(3.0f * e.fout() + 9.0f));
        Angles.randLenVectors((long)e.id, (int)2, (float)(32.0f * e.fin()), (float)0.0f, (float)360.0f, (x, y) -> Lines.poly((float)(e.x + x), (float)(e.y + y), (int)6, (float)(2.0f * e.fout() + 2.0f)));
    });
    public static Effect Mk2Shoot = new Effect(30.0f, e -> {
        Object patt10886$temp = e.data;
        if (!(patt10886$temp instanceof Float)) {
            return;
        }
        Float rotation = (Float)patt10886$temp;
        Draw.z((float)109.9f);
        Draw.color((Color)EUGet.EC8.set(EUGet.rainBowRed).shiftHue(Time.time * 2.0f));
        Angles.randLenVectors((long)e.id, (int)1, (float)(e.fin() * 20.0f), (float)(e.rotation + rotation.floatValue()), (float)0.0f, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(2.0f * e.fout())));
        Angles.randLenVectors((long)e.id, (int)1, (float)(e.fin() * 20.0f), (float)(e.rotation - rotation.floatValue()), (float)0.0f, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(2.0f * e.fout())));
        Draw.blend();
        Draw.reset();
    });
    public static Effect wind = new Effect(30.0f, e -> {
        Draw.z((float)20.0f);
        Draw.color((Color)e.color);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 6.0f + 0.3f));
    });
    public static Effect chainLightningFade = EUFx.chainLightningFade(45.0f, 2.5f);
    public static Effect chainLightning = new Effect(20.0f, 300.0f, e -> {
        float ty;
        float tx;
        Object patt18037$temp = e.data;
        if (patt18037$temp instanceof Position) {
            Position p = (Position)patt18037$temp;
            tx = p.getX();
            ty = p.getY();
        } else {
            Object patt18140$temp = e.data;
            if (patt18140$temp instanceof Float) {
                Float f = (Float)patt18140$temp;
                tx = EUGet.pointAngleX(e.x, e.rotation, f.floatValue());
                ty = EUGet.pointAngleY(e.y, e.rotation, f.floatValue());
            } else {
                return;
            }
        }
        float dst = Mathf.dst((float)e.x, (float)e.y, (float)tx, (float)ty);
        Tmp.v1.set(tx, ty).sub(e.x, e.y).nor();
        float normx = Tmp.v1.x;
        float normy = Tmp.v1.y;
        float range = 6.0f;
        int links = Mathf.ceil((float)(dst / range));
        float spacing = dst / (float)links;
        Lines.stroke((float)(2.5f * e.fout()));
        Draw.color((Color)Color.white, (Color)e.color, (float)e.fin());
        Lines.beginLine();
        Lines.linePoint((float)e.x, (float)e.y);
        Fx.rand.setSeed((long)e.id);
        for (int i = 0; i < links; ++i) {
            float ny;
            float nx;
            if (i == links - 1) {
                nx = tx;
                ny = ty;
            } else {
                float len = (float)(i + 1) * spacing;
                Tmp.v1.setToRandomDirection(Fx.rand).scl(range / 2.0f);
                nx = e.x + normx * len + Tmp.v1.x;
                ny = e.y + normy * len + Tmp.v1.y;
            }
            Lines.linePoint((float)nx, (float)ny);
        }
        Lines.endLine();
    }).followParent(false).rotWithParent(false);
    public static Effect waitChainHit18 = new Effect(27.0f, e -> {
        if (e.time > 9.0f) {
            Draw.color((Color)e.color);
            float out = (e.lifetime - e.time) / 18.0f;
            float in = 1.0f - out;
            Angles.randLenVectors((long)e.id, (int)5, (float)(21.0f * Interp.fastSlow.apply(in)), (float)e.rotation, (float)45.0f, (x, y) -> Fill.square((float)(e.x + x), (float)(e.y + y), (float)(5.0f * out), (float)Mathf.randomSeed((long)e.id, (float)180.0f)));
        }
    });
    public static Effect diffuse = new Effect(30.0f, e -> {
        if (!(e.data instanceof Integer)) {
            return;
        }
        int size = (Integer)e.data;
        float f = e.fout();
        float r = Math.max(0.0f, Mathf.clamp((float)(2.0f - f * 2.0f)) * (float)size * 8.0f / 2.0f - f - 0.2f);
        float w = Mathf.clamp((float)(0.5f - f)) * (float)size * 8.0f;
        Lines.stroke((float)(3.0f * f), (Color)e.color);
        Lines.beginLine();
        for (int i = 0; i < 4; ++i) {
            Lines.linePoint((float)(e.x + (float)Geometry.d4((int)i).x * r + (float)Geometry.d4((int)i).y * w), (float)(e.y + (float)Geometry.d4((int)i).y * r - (float)Geometry.d4((int)i).x * w));
            if (!(f < 0.5f)) continue;
            Lines.linePoint((float)(e.x + (float)Geometry.d4((int)i).x * r - (float)Geometry.d4((int)i).y * w), (float)(e.y + (float)Geometry.d4((int)i).y * r + (float)Geometry.d4((int)i).x * w));
        }
        Lines.endLine((boolean)true);
    });
    public static Effect normalTrail = new Effect(90.0f, e -> {
        Draw.color((Color)e.color);
        float r = e.rotation;
        Fill.circle((float)e.x, (float)e.y, (float)(r * e.foutpow()));
    }).layer(99.0f);
    public static Effect normalIceTrail = new Effect(90.0f, e -> DrawFunc.drawSnow(e.x, e.y, e.rotation * e.foutpow(), e.fin() * 180.0f, e.color));
    public static Effect diffHit = new Effect(30.0f, e -> {
        Object patt23703$temp;
        if (!(e.data instanceof Healthc)) {
            return;
        }
        Object patt23489$temp = e.data;
        if (patt23489$temp instanceof Building) {
            Building b = (Building)patt23489$temp;
            if (b.block == null) {
                return;
            }
            Draw.mixcol((Color)e.color, (float)1.0f);
            Draw.alpha((float)e.fout());
            Draw.rect((TextureRegion)b.block.fullIcon, (float)e.x, (float)e.y);
        }
        if ((patt23703$temp = e.data) instanceof Unit) {
            Unit u = (Unit)patt23703$temp;
            if (u.type == null) {
                return;
            }
            Draw.mixcol((Color)e.color, (float)1.0f);
            Draw.alpha((float)e.fout());
            Draw.rect((TextureRegion)u.type.fullIcon, (float)e.x, (float)e.y, (float)(u.rotation - 90.0f));
        }
    });
    public static Effect arcShieldBreak = new Effect(40.0f, e -> {
        Lines.stroke((float)(3.0f * e.fout()), (Color)e.color);
        Object patt24046$temp = e.data;
        if (patt24046$temp instanceof Unit) {
            Unit u = (Unit)patt24046$temp;
            PcShieldArcAbility ab = (PcShieldArcAbility)((Object)((Object)Structs.find((Object[])u.abilities, a -> a instanceof PcShieldArcAbility)));
            if (ab != null) {
                Vec2 pos = Tmp.v1.set(ab.x, ab.y).rotate(u.rotation - 90.0f).add((Position)u);
                Lines.arc((float)pos.x, (float)pos.y, (float)(ab.radius + ab.width / 2.0f), (float)(ab.angle / 360.0f), (float)(u.rotation + ab.angleOffset - ab.angle / 2.0f));
                Lines.arc((float)pos.x, (float)pos.y, (float)(ab.radius - ab.width / 2.0f), (float)(ab.angle / 360.0f), (float)(u.rotation + ab.angleOffset - ab.angle / 2.0f));
                for (int i : Mathf.signs) {
                    float px = pos.x + Angles.trnsx((float)(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i), (float)(ab.radius + ab.width / 2.0f));
                    float py = pos.y + Angles.trnsy((float)(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i), (float)(ab.radius + ab.width / 2.0f));
                    float px1 = pos.x + Angles.trnsx((float)(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i), (float)(ab.radius - ab.width / 2.0f));
                    float py1 = pos.y + Angles.trnsy((float)(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i), (float)(ab.radius - ab.width / 2.0f));
                    Lines.line((float)px, (float)py, (float)px1, (float)py1);
                }
            }
        }
    });
    public static Effect EUUtSp = new Effect(80.0f, e -> {
        Object patt26067$temp = e.data;
        if (!(patt26067$temp instanceof UnitType)) {
            return;
        }
        UnitType type = (UnitType)patt26067$temp;
        Draw.color((Color)Pal.accent);
        Drawf.tri((float)e.x, (float)e.y, (float)(16.0f * e.fout()), (float)(type.hitSize * 8.0f * e.fin()), (float)(e.rotation - 90.0f));
        Draw.alpha((float)e.fout());
        Draw.mixcol((Color)Pal.accent, (float)e.fout());
        Draw.rect((TextureRegion)type.fullIcon, (float)e.x, (float)e.y, (float)e.rotation);
    }).layer(120.0f);
    public static Effect easyExp = new Effect(20.0f, e -> {
        Fx.rand.setSeed((long)e.id);
        float baseRd = e.rotation;
        float randRd = baseRd / 6.0f;
        float pin = 1.0f - e.foutpow();
        Lines.stroke((float)(2.0f * e.foutpow()), (Color)e.color);
        Lines.circle((float)e.x, (float)e.y, (float)(baseRd * pin));
        for (int i = 0; i < 12; ++i) {
            float a = Fx.rand.random(360);
            float lx = EUGet.dx(e.x, baseRd * pin, a);
            float ly = EUGet.dy(e.y, baseRd * pin, a);
            Drawf.tri((float)lx, (float)ly, (float)(baseRd / 6.0f * e.foutpow()), (float)((baseRd / 2.0f + Fx.rand.random(-randRd, randRd)) * e.foutpow()), (float)(a + 180.0f));
        }
    });
    public static Effect AccretionDiskEffect = new Effect(60.0f, e -> {
        ateData data;
        block6: {
            block5: {
                Object patt29735$temp;
                if (Vars.headless || !((patt29735$temp = e.data) instanceof ateData)) break block5;
                data = (ateData)patt29735$temp;
                if (data.owner != null) break block6;
            }
            return;
        }
        float fin = data.out ? e.finpow() : e.foutpow();
        float fout = data.out ? e.foutpow() : e.finpow();
        float start = Mathf.randomSeed((long)e.id, (float)360.0f);
        Bullet b = data.owner;
        float ioRad = data.outRad - (data.outRad - data.inRad) * fin;
        float rad = data.speed * e.time * 6.0f;
        float dx = EUGet.dx(b.x, ioRad, start - rad);
        float dy = EUGet.dy(b.y, ioRad, start - rad);
        if (data.trail == null) {
            data.trail = new Trail(data.length);
        }
        float dzin = data.out && e.time > e.lifetime - 10.0f ? Interp.pow2Out.apply((e.lifetime - e.time) / 10.0f) : fin;
        data.trail.length = data.length;
        if (!Vars.state.isPaused()) {
            data.trail.update(dx, dy, 1.0f);
        }
        float z = Draw.z();
        Draw.z((float)(110.0f - 19.0f * fout));
        data.trail.draw(Tmp.c3.set(e.color).shiftValue(-e.color.value() * fout), data.width * dzin);
        Draw.z((float)z);
    });
    public static Effect hitOut = new Effect(60.0f, e -> {
        Object patt34979$temp;
        float z;
        float dy;
        float dx;
        float h;
        float w;
        TextureRegion rg;
        UnitType type;
        Object patt34258$temp = e.data;
        if (patt34258$temp instanceof Unit) {
            Unit u = (Unit)patt34258$temp;
            type = u.type;
            if (type != null) {
                rg = type.fullIcon;
                w = (float)rg.width * rg.scl() * Draw.xscl;
                h = (float)rg.height * rg.scl() * Draw.yscl;
                dx = EUGet.dx(e.x, Math.max(w, h) * 0.3f * e.finpow(), e.rotation);
                dy = EUGet.dy(e.y, Math.max(w, h) * 0.3f * e.finpow(), e.rotation);
                z = Draw.z();
                Draw.z((float)120.0f);
                Draw.alpha((float)e.foutpow());
                Draw.rect((TextureRegion)rg, (float)dx, (float)dy, (float)(w * 1.2f * e.finpow()), (float)(h * 1.2f * e.finpow()), (float)(u.rotation - 90.0f));
                Draw.z((float)z);
            }
        }
        if ((patt34979$temp = e.data) instanceof Building) {
            Building b = (Building)patt34979$temp;
            type = b.block;
            if (type != null) {
                rg = type.fullIcon;
                w = (float)rg.width * rg.scl() * Draw.xscl;
                h = (float)rg.height * rg.scl() * Draw.yscl;
                dx = EUGet.dx(e.x, h * 0.2f * e.finpow(), e.rotation);
                dy = EUGet.dy(e.y, h * 0.2f * e.finpow(), e.rotation);
                z = Draw.z();
                Draw.z((float)120.0f);
                Draw.alpha((float)e.foutpow());
                Draw.rect((TextureRegion)rg, (float)dx, (float)dy, (float)(w * 1.2f * e.finpow()), (float)(h * 1.2f * e.finpow()));
                Draw.z((float)z);
            }
        }
    });
    public static Effect audioEffect = new Effect(30.0f, e -> {
        Draw.color((Color)e.color);
        Draw.alpha((float)(2.0f * e.foutpow()));
        Angles.randLenVectors((long)e.id, (int)1, (float)(e.fin() * 20.0f), (float)Mathf.randomSeed((long)e.id, (float)360.0f), (float)0.0f, (x, y) -> Fill.poly((float)(e.x + x), (float)(e.y + y), (int)3, (float)(5.0f * e.fout()), (float)Mathf.randomSeed((long)e.id, (float)360.0f)));
    });
    public static Effect layerCircle = new Effect(90.0f, e -> {
        float r = e.rotation;
        float pin = 1.0f - e.foutpow();
        int i = 0;
        while ((float)i < r) {
            Lines.stroke((float)1.0f, (Color)Tmp.c1.set(e.color).a((float)i / r * 0.8f * e.foutpow()));
            Lines.circle((float)e.x, (float)e.y, (float)((float)i * pin));
            ++i;
        }
    });
    public static Effect casing4Double = new Effect(40.0f, e -> {
        Draw.color((Color)Pal.lightOrange, (Color)Pal.lightishGray, (Color)Pal.lightishGray, (float)e.fin());
        Draw.alpha((float)e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        for (int i : Mathf.signs) {
            float len = (7.0f + e.finpow() * 11.0f) * (float)i;
            float lr = rot + Mathf.randomSeedRange((long)(e.id + i + 6), (float)(20.0f * e.fin())) * (float)i;
            Draw.rect((TextureRegion)Core.atlas.find("casing"), (float)(e.x + Angles.trnsx((float)lr, (float)len) + Mathf.randomSeedRange((long)(e.id + i + 7), (float)(3.0f * e.fin()))), (float)(e.y + Angles.trnsy((float)lr, (float)len) + Mathf.randomSeedRange((long)(e.id + i + 8), (float)(3.0f * e.fin()))), (float)3.0f, (float)6.0f, (float)(rot + e.fin() * 50.0f * (float)i));
        }
    }).layer(100.0f);

    public static Effect StormExp(Color cor, Color liC) {
        return new Effect(72.0f, e -> {
            Draw.color((Color)liC, (Color)cor, (float)e.fin());
            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 40.0f));
            Lines.stroke((float)(e.fout() * 4.5f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 60.0f));
            Lines.stroke((float)(e.fout() * 2.75f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 30.0f));
            Angles.randLenVectors((long)e.id, (int)45, (float)(1.0f + 65.0f * e.fin()), (float)e.rotation, (float)360.0f, (x, y) -> {
                Lines.stroke((float)(e.fout() * 2.0f));
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 12.0f + 1.0f));
            });
            Angles.randLenVectors((long)e.id, (int)85, (float)(1.0f + 160.0f * e.fin()), (float)(Time.time * 4.0f), (float)360.0f, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 10.0f)));
        });
    }

    public static Effect flameShoot(Color colorBegin, Color colorTo, Color colorEnd, float length, float cone, int number, float lifetime) {
        return new Effect(lifetime, 80.0f, e -> {
            Draw.color((Color)colorBegin, (Color)colorTo, (Color)colorEnd, (float)e.fin());
            Angles.randLenVectors((long)e.id, (int)number, (float)(e.finpow() * length), (float)e.rotation, (float)cone, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(0.65f + e.fout() * 1.5f)));
        });
    }

    public static Effect elDsp(Color cor, Color cor2) {
        return new Effect(20.0f, e -> {
            Draw.color((Color)cor, (Color)cor2, (float)e.fin());
            Lines.stroke((float)(e.fout() * 3.0f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 60.0f));
            Lines.stroke((float)(e.fout() * 1.75f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 45.0f));
            Draw.color((Color)cor);
            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 20.0f));
            Draw.color((Color)cor, (Color)cor2, (float)e.fin());
            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * 14.0f));
        });
    }

    public static Effect gone(Color color, float r, float t) {
        return new Effect(12.0f, e -> {
            Draw.color((Color)color);
            Lines.stroke((float)(t * e.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(r * e.fout()));
        });
    }

    public static Effect gone(Color color) {
        return EUFx.gone(color, 5.0f, 2.0f);
    }

    public static Effect lancerLaserCharge(Color color) {
        return new Effect(38.0f, e -> {
            Draw.color((Color)color);
            Angles.randLenVectors((long)e.id, (int)14, (float)(1.0f + 20.0f * e.fout()), (float)e.rotation, (float)120.0f, (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 3.0f + 1.0f)));
        });
    }

    public static Effect chargeBeginEffect(float chargeTime, Color color) {
        return new Effect(chargeTime * 1.5f, e -> {
            Draw.color((Color)Color.white, (Color)color, (float)e.fin());
            Fill.circle((float)e.x, (float)e.y, (float)(e.fin() * 8.0f));
            Draw.color();
            Fill.circle((float)e.x, (float)e.y, (float)(e.fin() * 5.0f));
        });
    }

    public static Effect stingerShoot(Color color) {
        return new Effect(10.0f, e -> {
            Draw.color((Color)Color.white, (Color)color, (float)e.fin());
            Lines.stroke((float)(e.fout() * 2.0f + 0.2f));
            Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 28.0f));
        });
    }

    public static Effect trail(Color color, float width, float length) {
        return new Effect(12.0f, e -> {
            Draw.color((Color)color);
            Drawf.tri((float)e.x, (float)e.y, (float)(width * e.fout()), (float)length, (float)e.rotation);
        });
    }

    public static Effect casingContinue(float lifetime, int shots) {
        return new Effect(lifetime, e -> {
            Draw.z((float)100.0f);
            for (int a = 0; a < shots; ++a) {
                float time = lifetime / (float)shots;
                e.scaled(time * (float)a, b -> {
                    Draw.color((Color)Pal.lightOrange, (Color)Pal.lightishGray, (Color)Pal.lightishGray, (float)b.fin());
                    Draw.alpha((float)b.fout(0.5f));
                    float rot = Math.abs(e.rotation) + 90.0f;
                    int i = -Mathf.sign((float)e.rotation);
                    float len = (4.0f + b.finpow() * 9.0f) * (float)i;
                    float lr = rot + Mathf.randomSeedRange((long)(e.id + i + 6), (float)(20.0f * b.fin())) * (float)i;
                    Draw.rect((TextureRegion)Core.atlas.find("casing"), (float)(e.x + Angles.trnsx((float)lr, (float)len) + Mathf.randomSeedRange((long)(e.id + i + 7), (float)(3.0f * b.fin()))), (float)(e.y + Angles.trnsy((float)lr, (float)len) + Mathf.randomSeedRange((long)(e.id + i + 8), (float)(3.0f * b.fin()))), (float)3.0f, (float)6.0f, (float)(rot + e.fin() * 50.0f * (float)i));
                });
            }
        });
    }

    public static Effect ellipse(float startRad, int num, float lifetime, Color color) {
        return EUFx.ellipse(startRad, 2.0f, num, lifetime, color);
    }

    public static Effect ellipse(float startRad, float rad, int num, float lifetime, Color color) {
        return new Effect(lifetime, e -> {
            float rot;
            int i;
            float length = startRad * e.fin();
            float width = length / 2.0f;
            Draw.color((Color)color);
            for (i = 0; i <= num; ++i) {
                rot = -90.0f + 180.0f * (float)i / (float)num;
                Tmp.v1.trnsExact(rot, width);
                EUFx.point(Tmp.v1.x / width * length, Tmp.v1.y, e.x, e.y, e.rotation + 90.0f, rad * e.fout());
            }
            for (i = 0; i <= num; ++i) {
                rot = 90.0f + 180.0f * (float)i / (float)num;
                Tmp.v1.trnsExact(rot, width);
                EUFx.point(Tmp.v1.x / width * length, Tmp.v1.y, e.x, e.y, e.rotation + 90.0f, rad * e.fout());
            }
        });
    }

    private static void point(float x, float y, float baseX, float baseY, float rotation, float rad) {
        Tmp.v1.set(x, y).rotateRadExact(rotation * ((float)Math.PI / 180));
        Fill.circle((float)(Tmp.v1.x + baseX), (float)(Tmp.v1.y + baseY), (float)rad);
    }

    public static Effect Mk2Shoot(float r) {
        return new Effect(30.0f, e -> {
            Draw.z((float)109.9f);
            Draw.color((Color)EUGet.EC9.set(EUGet.rainBowRed).shiftHue(Time.time * 2.0f));
            Angles.randLenVectors((long)e.id, (int)1, (float)(e.fin() * 20.0f), (float)(e.rotation + r), (float)0.0f, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(2.0f * e.fout())));
            Angles.randLenVectors((long)e.id, (int)1, (float)(e.fin() * 20.0f), (float)(e.rotation - r), (float)0.0f, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(2.0f * e.fout())));
            Draw.blend();
            Draw.reset();
        });
    }

    public static Effect digTile(Color color) {
        return new Effect(30.0f, e -> {
            Draw.mixcol((Color)color, (float)1.0f);
            Draw.alpha((float)e.fout());
            Fill.square((float)e.x, (float)e.y, (float)4.0f);
        });
    }

    public static Effect expDillEffect(int size, Color color) {
        return new Effect(15.0f, e -> {
            Lines.stroke((float)(3.0f * e.fout()), (Color)color);
            Lines.square((float)e.x, (float)e.y, (float)((float)(size * 8) / 2.0f * e.fin()), (float)(180.0f * e.fout()));
        });
    }

    public static Effect colorBall(Color color, float range) {
        return new Effect(80.0f, e -> {
            Draw.color((Color)color.cpy().a(1.0f / range));
            int i = 0;
            while ((float)i < range) {
                Fill.circle((float)e.x, (float)e.y, (float)(range * (float)i / range * e.fout()));
                ++i;
            }
        });
    }

    public static Effect aimEffect(float lifetime, Color color, float width, float length, float spacing) {
        return new Effect(lifetime, length, e -> {
            Draw.color((Color)color);
            TextureAtlas.AtlasRegion region = Core.atlas.find(ExtraUtilitiesMod.name("aim-shoot"));
            float track = Mathf.curve((float)e.fin((Interp)Interp.pow2Out), (float)0.0f, (float)0.25f) * Mathf.curve((float)e.fout((Interp)Interp.pow4Out), (float)0.0f, (float)0.3f) * e.fin();
            int i = 0;
            while ((float)i <= length / spacing) {
                Tmp.v1.trns(e.rotation, (float)i * spacing);
                float f = Interp.pow3Out.apply(Mathf.clamp((float)((e.fin() * length - (float)i * spacing) / spacing))) * (0.6f + track * 0.4f);
                Draw.rect((TextureRegion)region, (float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(155.0f * Draw.scl * f), (float)(155.0f * Draw.scl * f), (float)(e.rotation - 90.0f));
                ++i;
            }
            Tmp.v1.trns(e.rotation, 0.0f, (2.0f - track) * 8.0f * width);
            Lines.stroke((float)(track * 2.0f));
            for (int i2 : Mathf.signs) {
                Lines.lineAngle((float)(e.x + Tmp.v1.x * (float)i2), (float)(e.y + Tmp.v1.y * (float)i2), (float)e.rotation, (float)(length * (0.75f + track / 4.0f) * Mathf.curve((float)e.fout((Interp)Interp.pow5Out), (float)0.0f, (float)0.1f)));
            }
        });
    }

    public static Effect expFtEffect(int amount, float size, float len, float lifetime, float startDelay) {
        return new Effect(lifetime, e -> {
            float length = len + e.finpow() * 20.0f;
            Fx.rand.setSeed((long)e.id);
            for (int i = 0; i < amount; ++i) {
                Fx.v.trns(Fx.rand.random(360.0f), Fx.rand.random(length));
                float sizer = Fx.rand.random(size / 2.0f, size);
                e.scaled(e.lifetime * Fx.rand.random(0.5f, 1.0f), b -> {
                    Draw.color((Color)Pal.darkerGray, (float)(b.fslope() * 0.93f));
                    Fill.circle((float)(e.x + Fx.v.x), (float)(e.y + Fx.v.y), (float)(sizer + b.fslope() * 1.2f));
                });
            }
        }).startDelay(startDelay);
    }

    public static Effect coneFade(float findRange, float findAngle) {
        return new Effect(15.0f, e -> {
            float range = findRange * e.fout();
            Draw.color((Color)Pal.heal);
            Draw.z((float)122.0f);
            Draw.alpha((float)0.8f);
            for (float i = e.rotation - findAngle / 2.0f; i < e.rotation + findAngle / 2.0f; i += 2.0f) {
                float px1 = EUGet.posx(e.x, range, i);
                float py1 = EUGet.posy(e.y, range, i);
                float px2 = EUGet.posx(e.x, range, i + 2.0f);
                float py2 = EUGet.posy(e.y, range, i + 2.0f);
                Fill.tri((float)e.x, (float)e.y, (float)px1, (float)py1, (float)px2, (float)py2);
            }
        });
    }

    public static Effect chainLightningFade(float lifetime) {
        return EUFx.chainLightningFade(lifetime, 2.5f);
    }

    public static Effect chainLightningFade(float lifetime, float stroke) {
        return EUFx.chainLightningFade(lifetime, stroke, -1.0f);
    }

    public static Effect chainLightningFadeOverride(float rangeOverride) {
        return EUFx.chainLightningFade(45.0f, 2.5f, rangeOverride);
    }

    public static Effect chainLightningFade(float lifetime, float stroke, float rangeOverride) {
        return new Effect(lifetime, 500.0f, e -> {
            float ty;
            float tx;
            Object patt15938$temp = e.data;
            if (patt15938$temp instanceof Position) {
                Position p = (Position)patt15938$temp;
                tx = p.getX();
                ty = p.getY();
            } else {
                Object patt16053$temp = e.data;
                if (patt16053$temp instanceof Float) {
                    Float f = (Float)patt16053$temp;
                    tx = EUGet.pointAngleX(e.x, e.rotation, f.floatValue());
                    ty = EUGet.pointAngleY(e.y, e.rotation, f.floatValue());
                } else {
                    return;
                }
            }
            float dst = Mathf.dst((float)e.x, (float)e.y, (float)tx, (float)ty);
            Tmp.v1.set(tx, ty).sub(e.x, e.y).nor();
            float normx = Tmp.v1.x;
            float normy = Tmp.v1.y;
            float range = rangeOverride > 0.0f ? rangeOverride : 6.0f;
            int links = Mathf.ceil((float)(dst / range));
            float spacing = dst / (float)links;
            Fx.rand.setSeed((long)e.id);
            FloatSeq seq = (FloatSeq)Pools.obtain(FloatSeq.class, FloatSeq::new);
            seq.add(e.x, e.y);
            for (int i = 0; i < links; ++i) {
                float ny;
                float nx;
                if (i == links - 1) {
                    nx = tx;
                    ny = ty;
                } else {
                    float len = (float)(i + 1) * spacing;
                    Tmp.v1.setToRandomDirection(Fx.rand).scl(range / 2.0f);
                    nx = e.x + normx * len + Tmp.v1.x;
                    ny = e.y + normy * len + Tmp.v1.y;
                }
                seq.add(nx, ny);
            }
            Lines.stroke((float)(stroke * Mathf.curve((float)e.fout(), (float)0.0f, (float)0.7f)));
            Draw.color((Color)Color.white, (Color)e.color, (float)e.fin());
            Fill.circle((float)e.x, (float)e.y, (float)(Lines.getStroke() / 2.0f));
            Fx.rand.setSeed((long)e.id);
            float fin = Mathf.curve((float)e.fin(), (float)0.0f, (float)0.5f);
            int j = 0;
            while ((float)j < (float)(seq.size - 2) * fin) {
                float ox = seq.get(j);
                float oy = seq.get(j + 1);
                float nx = seq.get(j + 2);
                float ny = seq.get(j + 3);
                Lines.line((float)ox, (float)oy, (float)nx, (float)ny);
                j += 2;
            }
            seq.clear();
            Pools.free((Object)seq);
            Draw.reset();
        }).followParent(false);
    }

    public static Effect ElectricExp(float lifetime, float sw, float r) {
        return new Effect(lifetime, e -> {
            if (e.time < sw) {
                float fin = e.time / sw;
                float fout = 1.0f - fin;
                Lines.stroke((float)(r / 12.0f * fout), (Color)Pal.heal);
                Lines.circle((float)e.x, (float)e.y, (float)(r * fout));
            } else {
                float fin = (e.time - sw) / (e.lifetime - sw);
                float fout = 1.0f - fin;
                float fbig = Math.min(fin * 10.0f, 1.0f);
                Lines.stroke((float)(r / 2.0f * fout), (Color)Pal.heal);
                Lines.circle((float)e.x, (float)e.y, (float)(r * fbig));
                for (int i = 0; i < 2; ++i) {
                    float angle = i * 180 + 60;
                    Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)(r * fbig))), (float)(e.y + Angles.trnsy((float)angle, (float)(r * fbig))), (float)(40.0f * fout), (float)(r / 1.5f), (float)angle);
                }
                Draw.z((float)110.001f);
                Lines.stroke((float)(r / 18.0f * fout), (Color)Pal.heal);
                Angles.randLenVectors((long)(e.id + 1), (float)(fin * fin + 0.001f), (int)20, (float)(r * 2.0f), (x, y, in, out) -> {
                    Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(1.0f + out * r / 4.0f));
                    Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(out * r), (Color)Draw.getColor(), (float)0.8f);
                });
                if (!Vars.state.isPaused()) {
                    Effect.shake((float)3.0f, (float)3.0f, (float)e.x, (float)e.y);
                }
            }
        });
    }

    public static Effect diffuse(int size, Color color, float life) {
        return new Effect(life, e -> {
            float f = e.fout();
            if (f < 1.0E-4f) {
                return;
            }
            float r = Math.max(0.0f, Mathf.clamp((float)(2.0f - f * 2.0f)) * (float)size * 8.0f / 2.0f - f - 0.2f);
            float w = Mathf.clamp((float)(0.5f - f)) * (float)size * 8.0f;
            Lines.stroke((float)(3.0f * f), (Color)color);
            Lines.beginLine();
            for (int i = 0; i < 4; ++i) {
                Lines.linePoint((float)(e.x + (float)Geometry.d4((int)i).x * r + (float)Geometry.d4((int)i).y * w), (float)(e.y + (float)Geometry.d4((int)i).y * r - (float)Geometry.d4((int)i).x * w));
                if (!(f < 0.5f)) continue;
                Lines.linePoint((float)(e.x + (float)Geometry.d4((int)i).x * r - (float)Geometry.d4((int)i).y * w), (float)(e.y + (float)Geometry.d4((int)i).y * r + (float)Geometry.d4((int)i).x * w));
            }
            Lines.endLine((boolean)true);
        });
    }

    public static Effect fiammettaExp(float r) {
        return new Effect(30.0f, e -> {
            float fin = Math.min(e.time / 10.0f, 1.0f);
            float fout = 1.0f - (e.time - 10.0f) / (e.lifetime - 10.0f);
            Draw.color((Color)EUItems.lightninAlloy.color.cpy().a(e.time > 10.0f ? 0.3f * fout : 0.3f));
            Fill.circle((float)e.x, (float)e.y, (float)(r * fin));
            float ww = r * 2.0f * fin;
            float hh = r * 2.0f * fin;
            Draw.color((Color)EUItems.lightninAlloy.color.cpy().a(e.time > 10.0f ? fout : 1.0f));
            Draw.rect((TextureRegion)Core.atlas.find(ExtraUtilitiesMod.name("firebird-light")), (float)e.x, (float)e.y, (float)ww, (float)hh);
        });
    }

    public static Effect edessp(float lifetime) {
        return new Effect(lifetime, e -> {
            Object[] objects;
            Object patt25360$temp = e.data;
            if (!(patt25360$temp instanceof Object[]) || (objects = (Object[])patt25360$temp).length < 4) {
                return;
            }
            Object patt25448$temp = objects[0];
            if (!(patt25448$temp instanceof TextureRegion)) {
                return;
            }
            TextureRegion region = (TextureRegion)patt25448$temp;
            Object patt25518$temp = objects[1];
            if (!(patt25518$temp instanceof Float)) {
                return;
            }
            Float range = (Float)patt25518$temp;
            Object patt25579$temp = objects[2];
            if (!(patt25579$temp instanceof Float)) {
                return;
            }
            Float rot = (Float)patt25579$temp;
            Object patt25638$temp = objects[3];
            if (!(patt25638$temp instanceof Float)) {
                return;
            }
            Float rRot = (Float)patt25638$temp;
            float ex = e.x + Angles.trnsx((float)(e.rotation + rRot.floatValue() * e.fin()), (float)(range.floatValue() * e.fout()));
            float ey = e.y + Angles.trnsy((float)(e.rotation + rRot.floatValue() * e.fin()), (float)(range.floatValue() * e.fout()));
            Draw.rect((TextureRegion)region, (float)ex, (float)ey, (float)((float)region.width / 3.0f * e.fin()), (float)((float)region.height / 3.0f * e.fin()), (float)rot.floatValue());
        }).followParent(true);
    }

    public static Effect PlanetaryArray(float lifetime, int sp, float spl, Color color, float cr, float st, float over) {
        return new Effect(lifetime, e -> {
            if (sp == 0) {
                return;
            }
            float fin = Mathf.curve((float)e.fin(), (float)0.0f, (float)over);
            float fout = Mathf.curve((float)e.fout(), (float)0.0f, (float)(1.0f - over));
            Float[] angles = (Float[])Pools.obtain(Float[].class, () -> new Float[sp]);
            Fx.rand.setSeed((long)e.id);
            for (int i = 0; i < sp; ++i) {
                angles[i] = Float.valueOf(Fx.rand.random(45.0f, 135.0f));
            }
            float nx = e.x;
            float ny = e.y;
            int i = 0;
            while ((float)i < (float)sp * fin) {
                float it = (float)i * (e.lifetime / (float)sp);
                float ef = Math.min(1.0f, (e.time - it) / (e.lifetime - it) * (1.0f / over));
                float angle = e.rotation + angles[i].floatValue() - 90.0f;
                Lines.stroke((float)(e.fin() < over ? st * ef : st * fout), (Color)color);
                if (cr > 0.0f) {
                    Fill.circle((float)nx, (float)ny, (float)(cr * (e.fin() < over ? ef : fout)));
                }
                if (i == sp - 1) break;
                Lines.lineAngle((float)nx, (float)ny, (float)angle, (float)(spl * Math.min(1.0f, Math.max(0.0f, ef) * 1.0f / (1.0f - over))));
                nx = EUGet.dx(nx, spl, angle);
                ny = EUGet.dy(ny, spl, angle);
                ++i;
            }
        }).followParent(true);
    }

    public static Effect diffEffect(float lifetime, float st, float r, int amt, float len, float rndLen, float width, Color color, float shake) {
        return new Effect(lifetime, e -> {
            float ly;
            float lx;
            float a;
            int i;
            Fx.rand.setSeed((long)e.id);
            float pin = 1.0f - e.foutpow();
            if (color != null) {
                Lines.stroke((float)(st * e.foutpow()), (Color)color);
            } else {
                Lines.stroke((float)(st * e.foutpow()), (Color)e.color);
            }
            Lines.circle((float)e.x, (float)e.y, (float)(r * pin));
            for (i = 0; i < amt / 2; ++i) {
                a = Fx.rand.random(180);
                lx = EUGet.dx(e.x, r * pin, a);
                ly = EUGet.dy(e.y, r * pin, a);
                Drawf.tri((float)lx, (float)ly, (float)(width * e.foutpow()), (float)((len + Fx.rand.random(-rndLen, rndLen)) * e.foutpow()), (float)(a + 180.0f));
            }
            for (i = 0; i < amt / 2; ++i) {
                a = 180 + Fx.rand.random(180);
                lx = EUGet.dx(e.x, r * pin, a);
                ly = EUGet.dy(e.y, r * pin, a);
                Drawf.tri((float)lx, (float)ly, (float)(width * e.foutpow()), (float)((len + Fx.rand.random(-rndLen, rndLen)) * e.foutpow()), (float)(a + 180.0f));
            }
            if (!Vars.state.isPaused() && shake > 0.0f) {
                Effect.shake((float)shake, (float)shake, (float)e.x, (float)e.y);
            }
        });
    }

    public static Effect airAsh(float lifetime, float range, float pin, Color color, float width, int amount) {
        return EUFx.airAsh(lifetime, range, 0.0f, pin, color, width, amount);
    }

    public static Effect airAsh(float lifetime, float range, float start, float pin, Color color, float width, int amount) {
        return new MultiEffect(new Effect[]{new Effect(lifetime, e -> {
            Color c = color == null ? e.color : color;
            float fee = e.time < e.lifetime / 2.0f ? e.fin() * 2.0f : e.fout() * 2.0f;
            for (int a : Mathf.signs) {
                for (int i = 0; i < amount; ++i) {
                    float dx = EUGet.dx(e.x, range * e.fin() + start, (e.time * 8.0f + (float)i) * (float)a + (float)Mathf.randomSeed((long)e.id, (int)-10, (int)10));
                    float dy = EUGet.dy(e.y, range * e.fin() + start, (e.time * 8.0f + (float)i) * (float)a + (float)Mathf.randomSeed((long)e.id, (int)-10, (int)10));
                    Draw.color((Color)c);
                    Fill.circle((float)dx, (float)dy, (float)((width * (float)i / (float)amount + 0.2f) * fee));
                }
            }
        }), new Effect(lifetime, e -> {
            Color c = color == null ? e.color : color;
            float fee = e.time < e.lifetime / 2.0f ? e.fin() * 2.0f : e.fout() * 2.0f;
            for (int a : Mathf.signs) {
                for (int i = 0; i < amount; ++i) {
                    float dx = EUGet.dx(e.x, (range - pin) * e.fin() + start, (e.time * 8.0f + (float)i) * (float)a + (float)Mathf.randomSeed((long)e.id, (int)-10, (int)10) + 120.0f);
                    float dy = EUGet.dy(e.y, (range - pin) * e.fin() + start, (e.time * 8.0f + (float)i) * (float)a + (float)Mathf.randomSeed((long)e.id, (int)-10, (int)10) + 120.0f);
                    Draw.color((Color)c);
                    Fill.circle((float)dx, (float)dy, (float)((width * (float)i / (float)amount + 0.2f) * fee));
                }
            }
        }), new Effect(lifetime, e -> {
            Color c = color == null ? e.color : color;
            float fee = e.time < e.lifetime / 2.0f ? e.fin() * 2.0f : e.fout() * 2.0f;
            for (int a : Mathf.signs) {
                for (int i = 0; i < amount; ++i) {
                    float dx = EUGet.dx(e.x, (range - pin * 2.0f) * e.fin() + start, (e.time * 8.0f + (float)i) * (float)a + (float)Mathf.randomSeed((long)e.id, (int)-10, (int)10) + 240.0f);
                    float dy = EUGet.dy(e.y, (range - pin * 2.0f) * e.fin() + start, (e.time * 8.0f + (float)i) * (float)a + (float)Mathf.randomSeed((long)e.id, (int)-10, (int)10) + 240.0f);
                    Draw.color((Color)c);
                    Fill.circle((float)dx, (float)dy, (float)((width * (float)i / (float)amount + 0.2f) * fee));
                }
            }
        })});
    }

    public static Effect layerCircle(float life, float r, Color color) {
        return new Effect(life, e -> {
            int i = 0;
            while ((float)i < r) {
                Lines.stroke((float)1.0f, (Color)Tmp.c1.set(color).a((float)i / r * 0.8f * e.foutpow()));
                Lines.circle((float)e.x, (float)e.y, (float)((float)i * e.finpow()));
                ++i;
            }
        });
    }

    public static Effect layerCircle(float life, float r) {
        return new Effect(life, e -> {
            int i = 0;
            while ((float)i < r) {
                Lines.stroke((float)1.0f, (Color)Tmp.c1.set(e.color).a((float)i / r * 0.8f * e.foutpow()));
                Lines.circle((float)e.x, (float)e.y, (float)((float)i * e.finpow()));
                ++i;
            }
        });
    }

    public static class ateData
    implements Pool.Poolable {
        public float width;
        public int length;
        public float inRad;
        public float outRad;
        public float speed;
        public transient Trail trail;
        public Bullet owner;
        public boolean out = false;

        public static ateData create() {
            return (ateData)Pools.obtain(ateData.class, ateData::new);
        }

        public void reset() {
            this.width = 0.0f;
            this.length = 0;
            this.speed = 0.0f;
            this.outRad = 0.0f;
            this.inRad = 0.0f;
            this.trail = null;
            this.owner = null;
            this.out = false;
        }
    }
}

