/*
 * Decompiled with CFR 0.152.
 */
package ExtraUtilities.content;

import ExtraUtilities.ExtraUtilitiesMod;
import ExtraUtilities.content.EUBlocks;
import ExtraUtilities.ui.ItemImage;
import ExtraUtilities.worlds.blocks.unit.DerivativeUnitFactory;
import arc.Core;
import arc.graphics.Color;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadStack;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ContinuousLiquidTurret;
import mindustry.world.blocks.defense.turrets.LiquidTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.power.ConsumeGenerator;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.HeatCrafter;
import mindustry.world.blocks.production.Separator;
import mindustry.world.blocks.production.SolidPump;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItemFilter;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.consumers.ConsumeLiquids;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;

public class EUFrom {
    public static final StatCat WTMF = new StatCat("eu-wtmf");
    public static final Stat fromStat = new Stat("eu-from", WTMF);
    public static final Stat toStat = new Stat("eu-to", WTMF);
    public static final Stat reqStat = new Stat("eu-req", WTMF);
    private static final ObjectMap<UnlockableContent, ObjectMap<Block, Table>> fromBlock = new ObjectMap();
    public static final ObjectMap<UnlockableContent, Table> fromTables = new ObjectMap();
    private static final ObjectMap<UnlockableContent, ObjectMap<Block, Table>> toBlock = new ObjectMap();
    public static final ObjectMap<UnlockableContent, Table> toTables = new ObjectMap();
    public static final ObjectMap<UnlockableContent, Table> requireTables = new ObjectMap();
    public static final ObjectMap<UnlockableContent, ObjectMap<Block, ObjectMap<UnlockableContent, Float>>> repMap_to = new ObjectMap();
    public static final ObjectMap<UnlockableContent, ObjectMap<Block, ObjectMap<Drawable, Float>>> repMap_need = new ObjectMap();
    public static final ObjectMap<UnlockableContent, ObjectMap<Block, ObjectMap<UnlockableContent, Float>>> repMap_back = new ObjectMap();
    private static final ObjectMap<UnlockableContent, Table> fromTables_pix = new ObjectMap();
    private static final ObjectMap<UnlockableContent, Table> toTables_ammo = new ObjectMap();
    private static final ObjectMap<UnlockableContent, Table> toTables_boost = new ObjectMap();

    public static void load() {
        if (Vars.ui == null || Vars.ui.settings == null) {
            return;
        }
        Core.settings.defaults(new Object[]{"eu-WTMF-open", Core.app == null || Core.app.isDesktop()});
        if (Core.settings.getBool("eu-WTMF-open")) {
            EUFrom.getProduce();
            EUFrom.getConsume();
            EUFrom.mixRep(repMap_to, fromBlock, (Drawable)Icon.leftSmall);
            EUFrom.mixPowerHeat();
            EUFrom.mixRep(repMap_back, toBlock, (Drawable)Icon.rightSmall);
            EUFrom.mixFromTo();
            EUFrom.mixToTable();
            EUFrom.showTable(fromTables, fromStat);
            EUFrom.showTable(toTables, toStat);
            EUFrom.showTable(requireTables, reqStat);
        }
    }

    public static void showTable(ObjectMap<UnlockableContent, Table> tables, Stat stat) {
        Seq keys = tables.keys().toSeq();
        if (keys.size > 0) {
            for (UnlockableContent c : keys) {
                if (tables.get((Object)c) == null) continue;
                c.stats.useCategories = true;
                c.stats.add(stat, t -> {
                    t.left().defaults().left();
                    Table ic = (Table)tables.get((Object)c);
                    Collapser coll = new Collapser(ic, true);
                    coll.setDuration(0.1f);
                    t.row();
                    t.table(st -> {
                        st.add((CharSequence)Core.bundle.get("eu-clickToShow")).center();
                        st.row();
                        st.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(true)).update(i -> {
                            i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                        }).pad(5.0f).size(8.0f).center();
                    }).left();
                    t.row();
                    t.add((Element)coll);
                    t.row();
                });
            }
        }
    }

    private static void getProduce() {
        for (Block b : Vars.content.blocks()) {
            Object ls;
            ConsumeGenerator c;
            int n;
            ItemStack[] iss;
            if (b.itemDrop != null) {
                EUFrom.setToTableSimple(fromTables_pix, (UnlockableContent)b.itemDrop, b, "  " + Core.bundle.get("eu-asOre"));
            }
            if (b instanceof Floor) {
                Floor f = (Floor)b;
                if (f.liquidDrop != null) {
                    EUFrom.setToTableSimple(fromTables_pix, (UnlockableContent)f.liquidDrop, (Block)f, "  " + Core.bundle.get("eu-asWater"));
                }
            }
            if (b instanceof GenericCrafter) {
                LiquidStack d;
                int n2;
                LiquidStack[] liquidStackArray;
                GenericCrafter g = (GenericCrafter)b;
                LiquidStack[] lss = g.outputLiquids;
                iss = g.outputItems;
                if (lss != null && lss.length > 0) {
                    liquidStackArray = lss;
                    n = liquidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        d = liquidStackArray[n2];
                        EUFrom.setToTable(fromBlock, (UnlockableContent)d.liquid, b);
                        EUFrom.checkPower(b, (UnlockableContent)d.liquid);
                    }
                }
                if (iss != null && iss.length > 0) {
                    liquidStackArray = iss;
                    n = liquidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        d = liquidStackArray[n2];
                        EUFrom.setToTable(fromBlock, (UnlockableContent)d.item, b);
                        EUFrom.checkPower(b, (UnlockableContent)d.item);
                    }
                }
            }
            if (b instanceof Separator) {
                Separator s = (Separator)b;
                if (s.results != null && s.results.length > 0) {
                    float all = 0.0f;
                    for (ItemStack is : s.results) {
                        all += (float)is.amount;
                    }
                    iss = s.results;
                    int n3 = iss.length;
                    for (n = 0; n < n3; ++n) {
                        ItemStack is = iss[n];
                        EUFrom.setToTableSimple(fromTables, (UnlockableContent)is.item, b, " " + Core.bundle.get("eu-separator-probability") + "[accent]" + Strings.autoFixed((float)((float)is.amount / all * 100.0f), (int)2) + "[]%" + (s.consPower != null ? "  \ue810[accent]" + Strings.autoFixed((float)(s.consPower.usage * 60.0f), (int)2) + "[]" : ""));
                    }
                }
            }
            if (b instanceof ConsumeGenerator) {
                c = (ConsumeGenerator)b;
                ls = c.outputLiquid;
                if (ls != null) {
                    EUFrom.setToTable(fromBlock, (UnlockableContent)((LiquidStack)ls).liquid, b);
                }
            }
            if (b instanceof ThermalGenerator) {
                c = (ThermalGenerator)b;
                ls = c.outputLiquid;
                if (ls != null) {
                    EUFrom.setToTable(fromBlock, (UnlockableContent)((LiquidStack)ls).liquid, b);
                }
            }
            if (b instanceof SolidPump) {
                SolidPump sp = (SolidPump)b;
                ls = sp.result;
                EUFrom.setToTable(fromBlock, (UnlockableContent)ls, (Block)sp, sp.consPower != null ? "  \ue810[accent]" + Strings.autoFixed((float)(sp.consPower.usage * 60.0f), (int)2) + "[]" : "");
            }
            if (b instanceof UnitFactory) {
                UnitFactory uf = (UnitFactory)b;
                if (uf.plans.size > 0) {
                    for (UnitFactory.UnitPlan p : uf.plans) {
                        EUFrom.setToTable(fromBlock, (UnlockableContent)p.unit, b);
                        if (p.requirements.length > 0) {
                            ItemStack[] itemStackArray = p.requirements;
                            n = itemStackArray.length;
                            for (int is = 0; is < n; ++is) {
                                ItemStack is2 = itemStackArray[is];
                                EUFrom.putOnRep(repMap_to, (UnlockableContent)p.unit, (UnlockableContent)is2.item, b, Float.valueOf(is2.amount));
                            }
                        }
                        EUFrom.checkPower(b, (UnlockableContent)p.unit);
                    }
                }
            }
            if (b instanceof Reconstructor) {
                Reconstructor rc = (Reconstructor)b;
                if (rc.upgrades.size > 0) {
                    for (UnitType[] ut : rc.upgrades) {
                        if (ut.length != 2) continue;
                        UnitType from = ut[0];
                        UnitType to = ut[1];
                        EUFrom.setToTable(fromBlock, (UnlockableContent)to, b);
                        EUFrom.putOnRep(repMap_to, (UnlockableContent)to, (UnlockableContent)from, b, Float.valueOf(-1.0f));
                        EUFrom.setToTable(toBlock, (UnlockableContent)from, b);
                        EUFrom.putOnRep(repMap_back, (UnlockableContent)from, (UnlockableContent)to, b, Float.valueOf(-1.0f));
                    }
                }
            }
            if (!(b instanceof UnitAssembler)) continue;
            UnitAssembler ua = (UnitAssembler)b;
            if (ua.plans.size <= 0) continue;
            for (UnitAssembler.AssemblerUnitPlan ap : ua.plans) {
                UnitType to = ap.unit;
                Seq req = ap.requirements;
                EUFrom.setToTable(fromBlock, (UnlockableContent)to, b);
                if (req.size <= 0) continue;
                for (PayloadStack q : req) {
                    EUFrom.putOnRep(repMap_to, (UnlockableContent)to, q.item, b, Float.valueOf(q.amount));
                    UnlockableContent unlockableContent = q.item;
                    if (unlockableContent instanceof UnitType) {
                        UnitType ut = (UnitType)unlockableContent;
                        EUFrom.setToTable(toBlock, (UnlockableContent)ut, b);
                        EUFrom.putOnRep(repMap_back, (UnlockableContent)ut, (UnlockableContent)ut, b, Float.valueOf(q.amount));
                        EUFrom.putOnRep(repMap_back, (UnlockableContent)ut, (UnlockableContent)to, b, Float.valueOf(-1.0f));
                    }
                    EUFrom.putOnRep(repMap_back, q.item, (UnlockableContent)to, b, Float.valueOf(q.amount));
                }
            }
        }
        if (ExtraUtilitiesMod.onlyPlugIn) {
            return;
        }
        Block GC = Vars.content.block(ExtraUtilitiesMod.name("GC"));
        if (GC != null) {
            EUFrom.setToTable(fromBlock, (UnlockableContent)Items.pyratite, GC);
        }
        for (UnitFactory.UnitPlan p : ((DerivativeUnitFactory)EUBlocks.finalF).plans) {
            if (!(p instanceof EUBlocks.LiquidUnitPlan)) continue;
            EUBlocks.LiquidUnitPlan lq = (EUBlocks.LiquidUnitPlan)p;
            if (lq.liquid.length <= 0) continue;
            for (LiquidStack l : lq.liquid) {
                EUFrom.putOnRep(repMap_to, (UnlockableContent)p.unit, (UnlockableContent)l.liquid, EUBlocks.finalF, Float.valueOf(l.amount * 60.0f));
            }
        }
    }

    public static void checkPower(Block b, UnlockableContent content) {
        ConsumePower c = b.consPower;
        if (c != null) {
            EUFrom.putOnRep_en(repMap_need, content, (Drawable)Icon.powerSmall, b, Float.valueOf(c.usage * 60.0f));
        }
        if (b instanceof HeatCrafter) {
            HeatCrafter hc = (HeatCrafter)b;
            EUFrom.putOnRep_en(repMap_need, content, (Drawable)Icon.wavesSmall, b, Float.valueOf(hc.heatRequirement));
        }
    }

    public static void checkBlock(Block b, UnlockableContent content, Float amount) {
        if (b instanceof GenericCrafter) {
            GenericCrafter g = (GenericCrafter)b;
            LiquidStack[] lss = g.outputLiquids;
            ItemStack[] iss = g.outputItems;
            if (lss != null && lss.length > 0) {
                for (LiquidStack liquidStack : lss) {
                    EUFrom.putOnRep(repMap_to, (UnlockableContent)liquidStack.liquid, content, b, amount);
                    EUFrom.putOnRep(repMap_back, content, (UnlockableContent)liquidStack.liquid, b, Float.valueOf(-1.0f));
                }
            }
            if (iss != null && iss.length > 0) {
                for (LiquidStack liquidStack : iss) {
                    EUFrom.putOnRep(repMap_to, (UnlockableContent)liquidStack.item, content, b, amount);
                    EUFrom.putOnRep(repMap_back, content, (UnlockableContent)liquidStack.item, b, Float.valueOf(-1.0f));
                }
            }
        }
        if (b instanceof Separator) {
            Separator s = (Separator)b;
            if (s.results != null && s.results.length > 0) {
                for (ItemStack is : s.results) {
                    EUFrom.putOnRep(repMap_back, content, (UnlockableContent)is.item, b, Float.valueOf(-1.0f));
                }
            }
        }
        if (b instanceof SolidPump) {
            SolidPump sp = (SolidPump)b;
            EUFrom.putOnRep(repMap_to, (UnlockableContent)sp.result, content, (Block)sp, amount);
            EUFrom.putOnRep(repMap_back, content, (UnlockableContent)sp.result, (Block)sp, Float.valueOf(-1.0f));
        }
        if (b instanceof ConsumeGenerator) {
            ConsumeGenerator cg = (ConsumeGenerator)b;
            if (cg.outputLiquid != null) {
                EUFrom.putOnRep(repMap_to, (UnlockableContent)cg.outputLiquid.liquid, content, (Block)cg, amount);
            }
        }
        if (b instanceof UnitFactory) {
            UnitFactory uf = (UnitFactory)b;
            if (uf.plans.size > 0) {
                for (UnitFactory.UnitPlan p : uf.plans) {
                    EUFrom.putOnRep(repMap_to, (UnlockableContent)p.unit, content, b, amount);
                }
            }
        }
        if (b instanceof Reconstructor) {
            Reconstructor rc = (Reconstructor)b;
            if (rc.upgrades.size > 0) {
                for (UnitType[] ut : rc.upgrades) {
                    if (ut.length != 2) continue;
                    UnitType from = ut[0];
                    UnitType to = ut[1];
                    EUFrom.putOnRep(repMap_to, (UnlockableContent)to, content, b, amount);
                    EUFrom.checkPower(b, (UnlockableContent)to);
                    EUFrom.putOnRep(repMap_back, (UnlockableContent)from, content, b, amount);
                }
            }
        }
        if (b instanceof UnitAssembler) {
            UnitAssembler ua = (UnitAssembler)b;
            if (ua.plans.size > 0) {
                for (UnitAssembler.AssemblerUnitPlan ap : ua.plans) {
                    UnitType to = ap.unit;
                    EUFrom.putOnRep(repMap_to, (UnlockableContent)to, content, b, amount);
                    EUFrom.checkPower(b, (UnlockableContent)to);
                    Seq req = ap.requirements;
                    if (req.size <= 0) continue;
                    for (PayloadStack payloadStack : req) {
                        UnlockableContent unlockableContent = payloadStack.item;
                        if (!(unlockableContent instanceof UnitType)) continue;
                        UnitType ut = (UnitType)unlockableContent;
                        for (PayloadStack qq : req) {
                            if (qq == payloadStack) continue;
                            EUFrom.putOnRep(repMap_back, (UnlockableContent)ut, qq.item, b, Float.valueOf(qq.amount));
                        }
                        EUFrom.putOnRep(repMap_back, (UnlockableContent)ut, (UnlockableContent)to, b, Float.valueOf(-1.0f));
                        EUFrom.putOnRep(repMap_back, (UnlockableContent)ut, content, b, amount);
                    }
                }
            }
        }
    }

    private static Stack ItemButtonImg(ItemStack subIs) {
        Stack sc = new Stack();
        sc.add((Element)new Table(c -> {
            c.left();
            c.button((Drawable)new TextureRegionDrawable(subIs.item.uiIcon), Styles.emptyi, 28.0f, () -> Vars.ui.content.show((UnlockableContent)subIs.item)).scaling(Scaling.fit);
        }));
        if (subIs.amount != 0) {
            sc.add((Element)new Table(c -> {
                c.left().bottom();
                c.add((CharSequence)(subIs.amount >= 1000 ? UI.formatAmount((long)subIs.amount) : subIs.amount + "")).style((Style)Styles.outlineLabel).touchable(Touchable.disabled);
                c.pack();
            }));
        }
        return sc;
    }

    private static void setRequire(Block b) {
        ItemStack[] iss = b.requirements;
        if (iss.length > 0) {
            for (ItemStack is : iss) {
                Table tb = new Table();
                tb.row();
                tb.table(Styles.grayPanel, t -> {
                    t.table(c -> {
                        c.button((Drawable)new TextureRegionDrawable(b.uiIcon), Styles.emptyi, 28.0f, () -> Vars.ui.content.show((UnlockableContent)b)).pad(2.0f).left();
                        c.add((CharSequence)b.localizedName).left();
                    }).left();
                    t.table(c -> {
                        c.right();
                        c.add((Element)new Image((Drawable)Icon.starSmall));
                        c.add((Element)new ItemImage(is)).pad(2.0f).right();
                        c.row();
                        if (iss.length > 1) {
                            c.table(icon -> icon.add((Element)new Image((Drawable)Icon.treeSmall)));
                            c.table(re -> {
                                for (int i = 0; i < iss.length; ++i) {
                                    ItemStack subIs = iss[i];
                                    if (subIs == is) continue;
                                    re.add((Element)EUFrom.ItemButtonImg(subIs)).left().pad(2.0f);
                                    if ((i + 1) % 5 != 0) continue;
                                    re.row();
                                }
                            });
                        }
                    }).right().grow().pad(5.0f);
                }).growX().pad(5.0f);
                tb.row();
                EUFrom.setToTableSimple(requireTables, (UnlockableContent)is.item, tb, true);
            }
        }
    }

    private static void getConsume() {
        block0: for (Block b : Vars.content.blocks()) {
            boolean has;
            if (b == null) continue;
            EUFrom.setRequire(b);
            if (b.consumers == null || b.consumers.length <= 0) continue;
            for (Consume c : b.consumers) {
                has = false;
                if (c instanceof ConsumeItems) {
                    ConsumeItems ci = (ConsumeItems)c;
                    ItemStack[] is = ci.items;
                    if (is.length > 0) {
                        for (ItemStack ik : is) {
                            EUFrom.witchToTable((Consume)ci, (UnlockableContent)ik.item, b);
                            if (!c.booster) {
                                EUFrom.checkBlock(b, (UnlockableContent)ik.item, Float.valueOf(ik.amount));
                            }
                            has = true;
                        }
                    }
                } else if (c instanceof ConsumeItemFilter) {
                    ConsumeItemFilter cf = (ConsumeItemFilter)c;
                    for (Item it : Vars.content.items()) {
                        if (!cf.filter.get((Object)it)) continue;
                        EUFrom.witchToTable((Consume)cf, (UnlockableContent)it, b);
                        if (!c.booster) {
                            EUFrom.checkBlock(b, (UnlockableContent)it, Float.valueOf(1.0f));
                        }
                        has = true;
                    }
                }
                if (has) break;
            }
            for (Consume c : b.consumers) {
                has = false;
                if (c instanceof ConsumeLiquid) {
                    ConsumeLiquid cl = (ConsumeLiquid)c;
                    EUFrom.witchToTable((Consume)cl, (UnlockableContent)cl.liquid, b);
                    if (c.booster) continue block0;
                    EUFrom.checkBlock(b, (UnlockableContent)cl.liquid, Float.valueOf(cl.amount * 60.0f));
                    continue block0;
                }
                if (c instanceof ConsumeLiquids) {
                    ConsumeLiquids cls = (ConsumeLiquids)c;
                    LiquidStack[] ls = cls.liquids;
                    if (ls.length > 0) {
                        for (LiquidStack lk : ls) {
                            EUFrom.witchToTable((Consume)cls, (UnlockableContent)lk.liquid, b);
                            if (!c.booster) {
                                EUFrom.checkBlock(b, (UnlockableContent)lk.liquid, Float.valueOf(lk.amount * 60.0f));
                            }
                            has = true;
                        }
                    }
                } else if (c instanceof ConsumeLiquidFilter) {
                    ConsumeLiquidFilter lf = (ConsumeLiquidFilter)c;
                    for (Liquid lq : Vars.content.liquids()) {
                        if (!lf.filter.get((Object)lq)) continue;
                        EUFrom.witchToTable((Consume)lf, (UnlockableContent)lq, b);
                        if (!c.booster) {
                            EUFrom.checkBlock(b, (UnlockableContent)lq, Float.valueOf(lf.amount * 60.0f));
                        }
                        has = true;
                    }
                }
                if (has) continue block0;
            }
        }
    }

    public static void setToTableSimple(ObjectMap<UnlockableContent, Table> table, UnlockableContent content, Table add, boolean override) {
        if (!table.containsKey((Object)content)) {
            table.put((Object)content, (Object)new Table());
        }
        Table t = (Table)table.get((Object)content);
        t.row();
        if (override) {
            t.defaults().growX();
        }
        t.add((Element)add).left();
    }

    public static void setToTableSimple(ObjectMap<UnlockableContent, Table> table, UnlockableContent content, Table add) {
        EUFrom.setToTableSimple(table, content, add, false);
    }

    public static void setToTableSimple(ObjectMap<UnlockableContent, Table> table, UnlockableContent content, Block b, String add) {
        if (!table.containsKey((Object)content)) {
            table.put((Object)content, (Object)new Table());
        }
        Table t = (Table)table.get((Object)content);
        t.row();
        t.table(tb -> {
            tb.table(Styles.grayPanel, ttb -> ttb.button((Drawable)new TextureRegionDrawable(b.uiIcon), Styles.emptyi, 28.0f, () -> Vars.ui.content.show((UnlockableContent)b)).left().pad(8.0f)).left();
            tb.add((CharSequence)b.localizedName);
            if (add != null) {
                tb.add((CharSequence)add);
            }
        }).padTop(10.0f).padBottom(5.0f).left();
    }

    public static void setToTableSimple(ObjectMap<UnlockableContent, Table> table, UnlockableContent content, Block b) {
        EUFrom.setToTableSimple(table, content, b, null);
    }

    public static void setToTable(ObjectMap<UnlockableContent, ObjectMap<Block, Table>> fb, UnlockableContent content, Block b, String add) {
        ObjectMap map;
        if (!fb.containsKey((Object)content)) {
            fb.put((Object)content, (Object)new ObjectMap());
        }
        if (!(map = (ObjectMap)fb.get((Object)content)).containsKey((Object)b)) {
            map.put((Object)b, (Object)new Table());
        }
        Table t = (Table)map.get((Object)b);
        t.row();
        t.table(tb -> {
            tb.table(Styles.grayPanel, ttb -> ttb.button((Drawable)new TextureRegionDrawable(b.uiIcon), Styles.emptyi, 28.0f, () -> Vars.ui.content.show((UnlockableContent)b)).left().pad(8.0f)).left();
            tb.add((CharSequence)b.localizedName);
            if (add != null) {
                tb.add((CharSequence)add);
            }
        }).padTop(10.0f).padBottom(5.0f).left();
    }

    public static void setToTable(ObjectMap<UnlockableContent, ObjectMap<Block, Table>> fb, UnlockableContent content, Block b) {
        EUFrom.setToTable(fb, content, b, null);
    }

    public static void witchToTable(Consume c, UnlockableContent content, Block b) {
        if (!EUFrom.isAmmo(content, b) && !EUFrom.isBoost(c)) {
            EUFrom.setToTable(toBlock, content, b);
        } else if (EUFrom.isAmmo(content, b)) {
            EUFrom.setToTableSimple(toTables_ammo, content, b);
        } else if (EUFrom.isBoost(c)) {
            EUFrom.setToTableSimple(toTables_boost, content, b);
        }
    }

    public static void mixFromTo() {
        Seq key_from = fromBlock.keys().toSeq();
        if (key_from.size > 0) {
            for (UnlockableContent c : key_from) {
                ObjectMap map = (ObjectMap)fromBlock.get((Object)c);
                Seq key_block = map.keys().toSeq();
                if (key_block.size <= 0) continue;
                for (Block b : key_block) {
                    EUFrom.setToTableSimple(fromTables, c, (Table)map.get((Object)b));
                }
            }
        }
        Seq key_to = toBlock.keys().toSeq();
        if (key_to.size > 0) {
            for (UnlockableContent c : key_to) {
                ObjectMap map = (ObjectMap)toBlock.get((Object)c);
                Seq key_block = map.keys().toSeq();
                if (key_block.size <= 0) continue;
                for (Block b : key_block) {
                    EUFrom.setToTableSimple(toTables, c, (Table)map.get((Object)b));
                }
            }
        }
    }

    private static void toMixTable(UnlockableContent c, ObjectMap<UnlockableContent, Table> tables, ObjectMap<UnlockableContent, Table> tables_any, String add) {
        if (!tables.containsKey((Object)c)) {
            tables.put((Object)c, (Object)new Table());
        }
        Table t = (Table)tables.get((Object)c);
        t.row();
        Table ic = (Table)tables_any.get((Object)c);
        Collapser coll = new Collapser(ic, true);
        coll.setDuration(0.1f);
        t.row();
        if (add != null) {
            t.add((CharSequence)add).center();
        }
        t.row();
        t.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(true)).update(i -> {
            i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
        }).pad(5.0f).size(8.0f).center();
        t.row();
        t.add((Element)coll).padBottom(40.0f);
        t.row();
        t.row();
    }

    private static void mixToTable() {
        Seq key_pix = fromTables_pix.keys().toSeq();
        if (key_pix.size > 0) {
            for (Object c : key_pix) {
                EUFrom.toMixTable((UnlockableContent)c, fromTables, fromTables_pix, Core.bundle.get("eu-from-needPick"));
            }
        }
        Seq key_ammo = toTables_ammo.keys().toSeq();
        if (key_ammo.size > 0) {
            for (UnlockableContent c : key_ammo) {
                EUFrom.toMixTable(c, toTables, toTables_ammo, Core.bundle.get("eu-to-stat-ammo"));
            }
        }
        Seq key_boost = toTables_boost.keys().toSeq();
        if (key_ammo.size > 0) {
            for (UnlockableContent c : key_boost) {
                EUFrom.toMixTable(c, toTables, toTables_boost, Core.bundle.get("eu-to-stat-boost"));
            }
        }
    }

    public static void putOnRep(ObjectMap<UnlockableContent, ObjectMap<Block, ObjectMap<UnlockableContent, Float>>> repMap, UnlockableContent to, UnlockableContent from, Block b, Float f) {
        if (!repMap.containsKey((Object)to)) {
            repMap.put((Object)to, (Object)new ObjectMap());
        }
        if (!((ObjectMap)repMap.get((Object)to)).containsKey((Object)b)) {
            ((ObjectMap)repMap.get((Object)to)).put((Object)b, (Object)new ObjectMap());
        }
        ((ObjectMap)((ObjectMap)repMap.get((Object)to)).get((Object)b)).put((Object)from, (Object)f);
    }

    public static void putOnRep_en(ObjectMap<UnlockableContent, ObjectMap<Block, ObjectMap<Drawable, Float>>> repMap, UnlockableContent to, Drawable name, Block b, Float f) {
        if (!repMap.containsKey((Object)to)) {
            repMap.put((Object)to, (Object)new ObjectMap());
        }
        if (!((ObjectMap)repMap.get((Object)to)).containsKey((Object)b)) {
            ((ObjectMap)repMap.get((Object)to)).put((Object)b, (Object)new ObjectMap());
        }
        ((ObjectMap)((ObjectMap)repMap.get((Object)to)).get((Object)b)).put((Object)name, (Object)f);
    }

    public static void mixRep(ObjectMap<UnlockableContent, ObjectMap<Block, ObjectMap<UnlockableContent, Float>>> rep, ObjectMap<UnlockableContent, ObjectMap<Block, Table>> blockTable, Drawable name) {
        Seq key_to = rep.keys().toSeq();
        if (key_to.size > 0) {
            for (UnlockableContent c : key_to) {
                if (!blockTable.containsKey((Object)c)) continue;
                ObjectMap map = (ObjectMap)blockTable.get((Object)c);
                Seq key_block = map.keys().toSeq();
                Seq rep_block = ((ObjectMap)rep.get((Object)c)).keys().toSeq();
                if (key_block.size <= 0 || rep_block.size <= 0) continue;
                for (Block b : rep_block) {
                    if (!map.containsKey((Object)b)) continue;
                    Table tb = (Table)map.get((Object)b);
                    ObjectMap map_block = (ObjectMap)((ObjectMap)rep.get((Object)c)).get((Object)b);
                    Seq block_key = map_block.keys().toSeq();
                    if (block_key.size <= 0) continue;
                    tb.table(t -> t.image(name).color(Pal.darkishGray).pad(8.0f)).left();
                    Seq<UnlockableContent> sort = EUFrom.sortContent((Seq<UnlockableContent>)block_key);
                    int i = 0;
                    while (i < sort.size) {
                        UnlockableContent cb = (UnlockableContent)sort.get(i);
                        int finalI = i++;
                        tb.table(t -> {
                            t.button((Drawable)new TextureRegionDrawable(cb.uiIcon), Styles.emptyi, 28.0f, () -> Vars.ui.content.show(cb)).left().pad(8.0f);
                            float amount = ((Float)map_block.get((Object)cb)).floatValue();
                            if (amount > 0.0f) {
                                t.add((CharSequence)("x[accent]" + Strings.autoFixed((float)amount, (int)2) + "[]"));
                            }
                            if (amount <= 0.0f && finalI < sort.size - 1) {
                                t.add((CharSequence)"/");
                            }
                            t.add((CharSequence)" ");
                        }).left();
                    }
                }
            }
        }
    }

    public static void mixPowerHeat() {
        Seq key = fromBlock.keys().toSeq();
        if (key.size > 0) {
            for (UnlockableContent c : key) {
                if (!repMap_need.containsKey((Object)c)) continue;
                ObjectMap bt = (ObjectMap)repMap_need.get((Object)c);
                Seq bs = bt.keys().toSeq();
                if (bs.size <= 0) continue;
                for (Block b : bs) {
                    if (!((ObjectMap)fromBlock.get((Object)c)).containsKey((Object)b)) {
                        ((ObjectMap)fromBlock.get((Object)c)).put((Object)b, (Object)new Table());
                    }
                    Table tb = (Table)((ObjectMap)fromBlock.get((Object)c)).get((Object)b);
                    ObjectMap dm = (ObjectMap)((ObjectMap)repMap_need.get((Object)c)).get((Object)b);
                    Seq ds = dm.keys().toSeq();
                    if (ds.size <= 0) continue;
                    for (Drawable d : ds) {
                        tb.table(t -> {
                            t.image(d).color(Color.white).pad(8.0f);
                            t.add((CharSequence)("[accent]" + Strings.autoFixed((float)((Float)dm.get((Object)d)).floatValue(), (int)2)));
                        }).left();
                    }
                }
            }
        }
    }

    private static Seq<UnlockableContent> sortContent(Seq<UnlockableContent> seq) {
        if (seq.size <= 0) {
            return seq;
        }
        Seq copy = new Seq();
        copy.addAll(seq.copy().removeAll(c -> !(c instanceof UnitType)).sort(c -> -((UnitType)c).health));
        copy.addAll(seq.copy().removeAll(c -> c instanceof UnitType || c instanceof Liquid).sort(c -> c.id));
        copy.addAll(seq.copy().removeAll(c -> !(c instanceof Liquid)).sort(c -> c.id));
        return copy;
    }

    private static boolean isBoost(Consume c) {
        return c.booster;
    }

    private static boolean isAmmo(UnlockableContent content, Block b) {
        return content instanceof Item && b instanceof Turret || content instanceof Liquid && (b instanceof LiquidTurret || b instanceof ContinuousLiquidTurret);
    }
}

