/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.utils.CommonUtils;

public class TableToolTip {
    private final Table table;

    public TableToolTip(Table table) {
        this.table = table;
        this.applyCustomTolTips();
    }

    public void applyCustomTolTips() {
        this.table.setToolTipText("");
        final Listener labelListener = new Listener(this){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Point eventPt = new Point(event.x, event.y);
                        TableItem item = TableToolTip.this.table.getItem(eventPt);
                        int selectedColumn = -1;
                        if (item != null) {
                            int columnCount = TableToolTip.this.table.getColumnCount();
                            for (int i = 0; i < columnCount; ++i) {
                                if (!item.getBounds(i).contains(eventPt)) continue;
                                selectedColumn = i;
                                break;
                            }
                        }
                        if (item == null || selectedColumn < 0) break;
                        String toolTip = TableToolTip.this.getItemToolTip(item, selectedColumn);
                        if (toolTip != null) {
                            toolTip = toolTip.trim();
                        }
                        if (CommonUtils.isEmpty((String)toolTip)) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(TableToolTip.this.table.getShell(), 540676);
                        this.tip.setForeground(TableToolTip.this.table.getDisplay().getSystemColor(28));
                        this.tip.setBackground(TableToolTip.this.table.getDisplay().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(TableToolTip.this.table.getDisplay().getSystemColor(28));
                        this.label.setBackground(TableToolTip.this.table.getDisplay().getSystemColor(29));
                        this.label.setText(toolTip);
                        this.label.addListener(7, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Point pt = TableToolTip.this.table.toDisplay(event.x, event.y);
                        this.tip.setBounds(pt.x, pt.y + item.getBounds().height, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        this.table.addListener(12, tableListener);
        this.table.addListener(1, tableListener);
        this.table.addListener(5, tableListener);
        this.table.addListener(32, tableListener);
    }

    public String getItemToolTip(TableItem item, int selectedColumn) {
        return item.getText(selectedColumn);
    }
}

