/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.sql.registry.SQLGeneratorDescriptor;

public class SQLGeneratorConfigurationRegistry {
    private static final Log log = Log.getLog(SQLGeneratorConfigurationRegistry.class);
    private static final String TAG_GENERATOR = "generator";
    private static SQLGeneratorConfigurationRegistry instance = null;
    private final List<SQLGeneratorDescriptor> generators = new ArrayList<SQLGeneratorDescriptor>();

    public static synchronized SQLGeneratorConfigurationRegistry getInstance() {
        if (instance == null) {
            instance = new SQLGeneratorConfigurationRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLGeneratorConfigurationRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        for (IConfigurationElement ext : extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlGenerator")) {
            if (!TAG_GENERATOR.equals(ext.getName())) continue;
            this.generators.add(new SQLGeneratorDescriptor(ext));
        }
    }

    public void dispose() {
        this.generators.clear();
    }

    public List<SQLGeneratorDescriptor> getAllGenerators() {
        return new ArrayList<SQLGeneratorDescriptor>(this.generators);
    }

    public List<SQLGeneratorDescriptor> getApplicableGenerators(Collection<?> objects, Object context) {
        ArrayList<SQLGeneratorDescriptor> result = new ArrayList<SQLGeneratorDescriptor>();
        block0: for (SQLGeneratorDescriptor gen : this.generators) {
            for (Object object : objects) {
                if (!(object instanceof DBPObject) || !gen.appliesTo((DBPObject)object, context) || gen.isMultiObject() && objects.size() < 2) continue;
                result.add(gen);
                continue block0;
            }
        }
        result.sort(Comparator.comparingInt(SQLGeneratorDescriptor::getOrder));
        return result;
    }

    public SQLGeneratorDescriptor getGenerator(String id) {
        for (SQLGeneratorDescriptor generator : this.generators) {
            if (!generator.getId().equalsIgnoreCase(id)) continue;
            return generator;
        }
        return null;
    }

    @Nullable
    public <T> SQLGenerator<T> createGenerator(DBPDataSource dataSource, List<T> objectsd) {
        return null;
    }

    public SQLGeneratorDescriptor getGeneratorDescriptor(SQLGenerator<?> generator) {
        for (SQLGeneratorDescriptor desc : this.generators) {
            if (desc.getGeneratorImplClass().getObjectClass() != ((Object)generator).getClass()) continue;
            return desc;
        }
        return null;
    }
}

