/*
 * MCreator (https://mcreator.net/)
 * Copyright (C) 2020 Pylo and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package net.mcreator.ui.dialogs.workspace;

import net.mcreator.generator.Generator;
import net.mcreator.generator.GeneratorFlavor;
import net.mcreator.preferences.PreferencesManager;
import net.mcreator.ui.MCreatorApplication;
import net.mcreator.ui.component.JEmptyBox;
import net.mcreator.ui.component.util.ComponentUtils;
import net.mcreator.ui.component.util.PanelUtils;
import net.mcreator.ui.dialogs.MCreatorDialog;
import net.mcreator.ui.init.L10N;
import net.mcreator.ui.init.UIRES;
import net.mcreator.ui.validation.AggregatedValidationResult;
import net.mcreator.util.DesktopUtils;
import net.mcreator.workspace.Workspace;
import net.mcreator.workspace.settings.WorkspaceSettings;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;

public class NewWorkspaceDialog extends MCreatorDialog {

	private File workspaceFile = null;

	private AbstractWorkspacePanel current = null;

	private final CardLayout cardLayout = new CardLayout();
	private final JPanel workspacePanels = new JPanel(cardLayout);

	public NewWorkspaceDialog(Window w) {
		super(w, L10N.t("dialog.new_workspace.title"), true);

		AbstractWorkspacePanel forgeWorkspacePanel = new ForgeWorkspacePanel(this);
		AbstractWorkspacePanel fabricWorkspacePanel = new FabricWorkspacePanel(this);
		AbstractWorkspacePanel spigotWorkspacePanel = new SpigotWorkspacePanel(this);
		AbstractWorkspacePanel datapackWorkspacePanel = new DatapackWorkspacePanel(this);
		AbstractWorkspacePanel addonWorkspacePanel = new AddonWorkspacePanel(this);

		JPanel buttons = new JPanel();

		JButton ok = L10N.button("dialog.new_workspace.button_new");
		buttons.add(ok);

		JButton cancel = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
		buttons.add(cancel);

		buttons.add(new JEmptyBox(2, 2));

		JButton help = L10N.button("common.help");
		buttons.add(help);

		buttons.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
		add("South", buttons);

		ok.addActionListener(e -> {
			WorkspaceSettings workspaceSettings = current.getWorkspaceSettings();
			if (workspaceSettings != null) {
				workspaceFile = new File(new File(current.getWorkspaceFolder()),
						workspaceSettings.getModID() + ".mcreator");
				Workspace.createWorkspace(workspaceFile, workspaceSettings);
				setVisible(false);
			} else {
				showErrorsMessage(w, current.getValidationResult());
			}
		});

		cancel.addActionListener(actionEvent -> {
			workspaceFile = null;
			setVisible(false);
		});

		help.addActionListener(actionEvent -> DesktopUtils.browseSafe(
				MCreatorApplication.SERVER_DOMAIN + "/wiki/create-new-workspace-window"));

		workspacePanels.add("forge", PanelUtils.pullElementUp(forgeWorkspacePanel));
		if (PreferencesManager.PREFERENCES.ui.onlyForge) {
			workspacePanels.add("fabric", PanelUtils.pullElementUp(fabricWorkspacePanel));
			workspacePanels.add("spigot", PanelUtils.pullElementUp(spigotWorkspacePanel));
			workspacePanels.add("datapack", PanelUtils.pullElementUp(datapackWorkspacePanel));
			workspacePanels.add("addon", PanelUtils.pullElementUp(addonWorkspacePanel));
		}

		JComponent center = PanelUtils.centerInPanel(workspacePanels);
		center.setBorder(
				BorderFactory.createMatteBorder(1, 0, 0, 0, (Color) UIManager.get("MCreatorLAF.LIGHT_ACCENT")));

		add("Center", center);

		JLabel label = new JLabel(UIRES.get("addwrk"));
		label.setText(L10N.t("dialog.new_workspace.main_title_html"));
		label.setHorizontalAlignment(SwingConstants.LEFT);
		label.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));

		add("North", label);

		JPanel workspaceType = new JPanel(new GridLayout(0, 1));

		ButtonGroup buttonGroup = new ButtonGroup();

		JToggleButton forge = new JToggleButton(L10N.t("dialog.new_workspace.forge.toogle"), UIRES.get("16px.forge"));
		forge.setHorizontalAlignment(SwingConstants.LEFT);
		forge.setBorder(BorderFactory.createCompoundBorder(
				BorderFactory.createMatteBorder(0, 0, 1, 0, (Color) UIManager.get("MCreatorLAF.LIGHT_ACCENT")),
				BorderFactory.createEmptyBorder(8, 8, 8, 30)));
		buttonGroup.add(forge);
		forge.addActionListener(e -> {
			current = forgeWorkspacePanel;
			cardLayout.show(workspacePanels, "forge");
		});

		JToggleButton fabric = new JToggleButton(L10N.t("dialog.new_workspace.fabric.toggle"), UIRES.get("16px.fabric"));
		fabric.setHorizontalAlignment(SwingConstants.LEFT);
		fabric.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color) UIManager.get("MCreatorLAF.LIGHT_ACCENT")),
				BorderFactory.createEmptyBorder(8, 8, 8, 30)));
		buttonGroup.add(fabric);
		fabric.addActionListener(e -> {
			current = fabricWorkspacePanel;
			cardLayout.show(workspacePanels, "fabric");
		});

		JToggleButton spigot = new JToggleButton(L10N.t("dialog.new_workspace.spigot.toggle"), UIRES.get("16px.spigot"));
		spigot.setHorizontalAlignment(SwingConstants.LEFT);
		spigot.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color) UIManager.get("MCreatorLAF.LIGHT_ACCENT")),
				BorderFactory.createEmptyBorder(8, 8, 8, 30)));
		buttonGroup.add(spigot);
		spigot.addActionListener(e -> {
			current = spigotWorkspacePanel;
			cardLayout.show(workspacePanels, "spigot");
		});

		JToggleButton datapack = new JToggleButton(L10N.t("dialog.new_workspace.datapack.toggle"), UIRES.get("16px.datapack"));
		datapack.setHorizontalAlignment(SwingConstants.LEFT);
		datapack.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color) UIManager.get("MCreatorLAF.LIGHT_ACCENT")),
				BorderFactory.createEmptyBorder(8, 8, 8, 30)));
		buttonGroup.add(datapack);
		datapack.addActionListener(e -> {
			current = datapackWorkspacePanel;
			cardLayout.show(workspacePanels, "datapack");
		});

		JToggleButton addon = new JToggleButton(L10N.t("dialog.new_workspace.addon.toggle"), UIRES.get("16px.bedrock"));
		addon.setHorizontalAlignment(SwingConstants.LEFT);
		addon.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color) UIManager.get("MCreatorLAF.LIGHT_ACCENT")),
				BorderFactory.createEmptyBorder(8, 8, 8, 30)));
		buttonGroup.add(addon);
		addon.addActionListener(e -> {
			current = addonWorkspacePanel;
			cardLayout.show(workspacePanels, "addon");
		});

		JLabel wt = L10N.label("dialog.new_workspace.type");
		ComponentUtils.deriveFont(wt, 10);
		wt.setForeground((Color) UIManager.get("MCreatorLAF.GRAY_COLOR"));
		wt.setBorder(BorderFactory.createEmptyBorder(8, 8, 3, 30));

		workspaceType.add(wt);
		workspaceType.add(forge);
		if (!PreferencesManager.PREFERENCES.ui.onlyForge) {
			workspaceType.add(fabric);
			workspaceType.add(spigot);
			workspaceType.add(addon);
			workspaceType.add(datapack);
		}

		if (Generator.GENERATOR_CACHE.values().stream()
				.noneMatch(gc -> gc.getGeneratorFlavor() == GeneratorFlavor.FORGE)) {
			disableType(forge);
		}

		if (Generator.GENERATOR_CACHE.values().stream()
				.noneMatch(gc -> gc.getGeneratorFlavor() == GeneratorFlavor.FABRIC)) {
			disableType(fabric);
		}

		if (Generator.GENERATOR_CACHE.values().stream()
				.noneMatch(gc -> gc.getGeneratorFlavor() == GeneratorFlavor.SPIGOT)) {
			disableType(spigot);
		}

		if (Generator.GENERATOR_CACHE.values().stream()
				.noneMatch(gc -> gc.getGeneratorFlavor() == GeneratorFlavor.ADDON)) {
			disableType(addon);
		}

		if (Generator.GENERATOR_CACHE.values().stream()
				.noneMatch(gc -> gc.getGeneratorFlavor() == GeneratorFlavor.DATAPACK)) {
			disableType(datapack);
		}

		JComponent wrapPan = PanelUtils.northAndCenterElement(workspaceType, new JEmptyBox());
		wrapPan.setBorder(
				BorderFactory.createMatteBorder(1, 0, 0, 1, (Color) UIManager.get("MCreatorLAF.LIGHT_ACCENT")));
		add("West", wrapPan);

		getRootPane().setDefaultButton(ok);
		pack();
		setLocationRelativeTo(w);

		forge.setSelected(true);
		forgeWorkspacePanel.focusMainField();
		this.current = forgeWorkspacePanel;

		setVisible(true);
	}

	private void disableType(JToggleButton button) {
		button.setEnabled(false);
		button.setToolTipText(L10N.t("dialog.new_workspace.disabled.tooltip"));
		button.addMouseListener(new MouseAdapter() {
			@Override public void mouseClicked(MouseEvent e) {
				super.mouseReleased(e);
				int option = JOptionPane.showConfirmDialog(null,
						L10N.t("dialog.new_workspace.dialog_plugin_needed.text"),
						L10N.t("dialog.new_workspace.dialog_plugin_needed.title"), JOptionPane.YES_NO_OPTION,
						JOptionPane.INFORMATION_MESSAGE, null);
				if (option == JOptionPane.YES_OPTION) {
					DesktopUtils.browseSafe(MCreatorApplication.SERVER_DOMAIN + "/plugins");
				}
			}
		});
	}

	private void showErrorsMessage(Window w, AggregatedValidationResult validationResult) {
		StringBuilder stringBuilder = new StringBuilder(L10N.t("dialog.new_workspace.error_list"));
		stringBuilder.append("<ul>");
		int count = 0;
		for (String error : validationResult.getValidationProblemMessages()) {
			stringBuilder.append("<li>").append(error).append("</li>");
			count++;
			if (count > 5) {
				stringBuilder.append("<li>").append("+ ")
						.append(validationResult.getValidationProblemMessages().size() - count).append(" more")
						.append("</li>");
				break;
			}

		}
		stringBuilder.append("</ul>");
		stringBuilder.append(L10N.t("dialog.workspace_settings.dialog.error"));
		JOptionPane.showMessageDialog(w, stringBuilder.toString(),
				L10N.t("dialog.workspace_settings.dialog.error.title"), JOptionPane.ERROR_MESSAGE);
	}

	public File getWorkspaceFile() {
		return workspaceFile;
	}

}
