/*
 * MCreator (https://mcreator.net/)
 * Copyright (C) 2020 Pylo and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package net.mcreator.ui.dialogs.tools;

import net.mcreator.element.ModElementType;
import net.mcreator.element.parts.MItemBlock;
import net.mcreator.element.parts.Material;
import net.mcreator.element.parts.StepSound;
import net.mcreator.element.parts.TabEntry;
import net.mcreator.element.types.Block;
import net.mcreator.element.types.Recipe;
import net.mcreator.element.types.Tag;
import net.mcreator.generator.GeneratorConfiguration;
import net.mcreator.generator.GeneratorStats;
import net.mcreator.io.FileIO;
import net.mcreator.io.ResourcePointer;
import net.mcreator.minecraft.RegistryNameFixer;
import net.mcreator.ui.MCreator;
import net.mcreator.ui.action.ActionRegistry;
import net.mcreator.ui.action.BasicAction;
import net.mcreator.ui.component.JColor;
import net.mcreator.ui.component.util.PanelUtils;
import net.mcreator.ui.dialogs.MCreatorDialog;
import net.mcreator.ui.init.ImageMakerTexturesCache;
import net.mcreator.ui.init.L10N;
import net.mcreator.ui.init.UIRES;
import net.mcreator.ui.validation.Validator;
import net.mcreator.ui.validation.component.VTextField;
import net.mcreator.ui.validation.validators.UniqueNameValidator;
import net.mcreator.ui.workspace.resources.TextureType;
import net.mcreator.util.ListUtils;
import net.mcreator.util.image.ImageUtils;
import net.mcreator.workspace.Workspace;
import net.mcreator.workspace.elements.FolderElement;
import net.mcreator.workspace.elements.ModElement;

import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class WoodPackMakerTool {

	private static void open(MCreator mcreator) {
		MCreatorDialog dialog = new MCreatorDialog(mcreator, L10N.t("dialog.tools.wood_pack_title"), true);
		dialog.setLayout(new BorderLayout(10, 10));

		dialog.setIconImage(UIRES.get("16px.woodpack").getImage());

		dialog.add("North", PanelUtils.centerInPanel(L10N.label("dialog.tools.wood_pack_info")));

		JPanel props = new JPanel(new GridLayout(4, 2, 5, 5));

		VTextField name = new VTextField(25);
		JColor color = new JColor(mcreator, false, false);
		JSpinner power = new JSpinner(new SpinnerNumberModel(1, 0.1, 10, 0.1));

		name.enableRealtimeValidation();

		props.add(L10N.label("dialog.tools.wood_pack_name"));
		props.add(name);

		props.add(L10N.label("dialog.tools.wood_pack_color_accent"));
		props.add(color);

		props.add(L10N.label("dialog.tools.wood_pack_power_factor"));
		props.add(power);

		name.setValidator(UniqueNameValidator.createModElementNameValidator(mcreator.getWorkspace(), name,
				L10N.t("dialog.tools.wood_pack_name_validator")));

		dialog.add("Center", PanelUtils.centerInPanel(props));
		JButton ok = L10N.button("dialog.tools.wood_pack_create");
		JButton canecel = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
		canecel.addActionListener(e -> dialog.setVisible(false));
		dialog.add("South", PanelUtils.join(ok, canecel));

		ok.addActionListener(e -> {
			if (name.getValidationStatus().getValidationResultType() != Validator.ValidationResultType.ERROR) {
				dialog.setCursor(new Cursor(Cursor.WAIT_CURSOR));
				addWoodPackToWorkspace(mcreator, mcreator.getWorkspace(), name.getText(), color.getColor(),
						(Double) power.getValue());
				mcreator.mv.updateMods();
				dialog.setCursor(Cursor.getDefaultCursor());
				dialog.setVisible(false);
			}
		});

		dialog.setSize(600, 250);
		dialog.setLocationRelativeTo(mcreator);
		dialog.setVisible(true);
	}

	private static void addWoodPackToWorkspace(MCreator mcreator, Workspace workspace, String name, Color color,
			double factor) {
		// select folder the mod pack should be in
		FolderElement folder = null;
		if (!mcreator.mv.currentFolder.equals(mcreator.getWorkspace().getFoldersRoot()))
			folder = mcreator.mv.currentFolder;

		// first we generate wood texture
		ImageIcon wood = ImageUtils.colorize(ImageMakerTexturesCache.CACHE.get(new ResourcePointer(
						"templates/textures/texturemaker/" + ListUtils.getRandomItem(
								Arrays.asList("log_side_1", "log_side_2", "log_side_3", "log_side_4", "log_side_5")) + ".png")),
				color, true);
		String woodTextureName = (name + "_log_side").toLowerCase(Locale.ENGLISH);
		FileIO.writeImageToPNGFile(ImageUtils.toBufferedImage(wood.getImage()),
				mcreator.getFolderManager().getTextureFile(RegistryNameFixer.fix(woodTextureName), TextureType.BLOCK));

		//then we generate the missing log texture
		ImageIcon log = ImageUtils.colorize(
				ImageMakerTexturesCache.CACHE.get(new ResourcePointer("templates/textures/texturemaker/log_top.png")),
				color, true);
		String logTextureName = (name + "_log_top").toLowerCase(Locale.ENGLISH);
		FileIO.writeImageToPNGFile(ImageUtils.toBufferedImage(log.getImage()),
				mcreator.getFolderManager().getTextureFile(RegistryNameFixer.fix(logTextureName), TextureType.BLOCK));

		//then we generate the planks texture
		ImageIcon planks = ImageUtils.colorize(ImageMakerTexturesCache.CACHE.get(new ResourcePointer(
				"templates/textures/texturemaker/" + ListUtils.getRandomItem(Arrays.asList("planks_0", "planks_1"))
						+ ".png")), color, true);
		String planksTextureName = (name + "_planks").toLowerCase(Locale.ENGLISH);
		FileIO.writeImageToPNGFile(ImageUtils.toBufferedImage(planks.getImage()), mcreator.getFolderManager()
				.getTextureFile(RegistryNameFixer.fix(planksTextureName), TextureType.BLOCK));

		//then we generate the leaves texture
		ImageIcon leaves = ImageUtils.colorize(ImageMakerTexturesCache.CACHE.get(new ResourcePointer(
				"templates/textures/texturemaker/" + ListUtils.getRandomItem(
						Arrays.asList("leaves_0", "leaves_1", "leaves_2", "leaves_3", "leaves_4", "leaves_5",
								"leaves_new1", "leaves_new2", "leaves2")) + ".png")), color, true);
		String leavesTextureName = (name + "_leaves").toLowerCase(Locale.ENGLISH);
		FileIO.writeImageToPNGFile(ImageUtils.toBufferedImage(leaves.getImage()), mcreator.getFolderManager()
				.getTextureFile(RegistryNameFixer.fix(leavesTextureName), TextureType.BLOCK));

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block woodBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Wood", ModElementType.BLOCK), false).getElementFromGUI();
		woodBlock.name = name + " Wood";
		woodBlock.material = new Material(workspace, "WOOD");
		woodBlock.texture = woodTextureName;
		woodBlock.renderType = 11; // single texture
		woodBlock.customModelName = "Single texture";
		woodBlock.soundOnStep = new StepSound(workspace, "WOOD");
		woodBlock.hardness = 2.0 * factor;
		woodBlock.resistance = 2.0 * Math.pow(factor, 0.8);
		woodBlock.destroyTool = "axe";
		woodBlock.breakHarvestLevel = 0;
		woodBlock.flammability = (int) Math.round(5 * factor);
		woodBlock.rotationMode = 5; // log rotation

		woodBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(woodBlock);
		mcreator.getWorkspace().addModElement(woodBlock.getModElement());
		mcreator.getGenerator().generateElement(woodBlock);
		mcreator.getModElementManager().storeModElement(woodBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block logBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Log", ModElementType.BLOCK), false).getElementFromGUI();
		logBlock.name = name + " Log";
		logBlock.material = new Material(workspace, "WOOD");
		logBlock.texture = logTextureName;
		logBlock.textureTop = logTextureName;
		logBlock.textureBack = woodTextureName;
		logBlock.textureFront = woodTextureName;
		logBlock.textureLeft = woodTextureName;
		logBlock.textureRight = woodTextureName;
		logBlock.renderType = 10; // normal
		logBlock.customModelName = "Normal";
		logBlock.soundOnStep = new StepSound(workspace, "WOOD");
		logBlock.hardness = 2.0 * factor;
		logBlock.resistance = 2.0 * Math.pow(factor, 0.8);
		logBlock.destroyTool = "axe";
		logBlock.breakHarvestLevel = 0;
		logBlock.flammability = (int) Math.round(5 * factor);
		logBlock.rotationMode = 5; // log rotation

		logBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(logBlock);
		mcreator.getWorkspace().addModElement(logBlock.getModElement());
		mcreator.getGenerator().generateElement(logBlock);
		mcreator.getModElementManager().storeModElement(logBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block planksBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Planks", ModElementType.BLOCK), false).getElementFromGUI();
		planksBlock.name = name + " Planks";
		planksBlock.material = new Material(workspace, "WOOD");
		planksBlock.texture = planksTextureName;
		planksBlock.renderType = 11; // single texture
		planksBlock.customModelName = "Single texture";
		planksBlock.soundOnStep = new StepSound(workspace, "WOOD");
		planksBlock.hardness = 2.0 * factor;
		planksBlock.resistance = 3.0 * Math.pow(factor, 0.8);
		planksBlock.destroyTool = "axe";
		planksBlock.breakHarvestLevel = 0;
		planksBlock.flammability = (int) Math.round(5 * factor);

		planksBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(planksBlock);
		mcreator.getWorkspace().addModElement(planksBlock.getModElement());
		mcreator.getGenerator().generateElement(planksBlock);
		mcreator.getModElementManager().storeModElement(planksBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block leavesBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Leaves", ModElementType.BLOCK), false).getElementFromGUI();
		leavesBlock.name = name + " Leaves";
		leavesBlock.blockBase = "Leaves";
		leavesBlock.material = new Material(workspace, "LEAVES");
		leavesBlock.texture = leavesTextureName;
		leavesBlock.soundOnStep = new StepSound(workspace, "PLANT");
		leavesBlock.hardness = 0.2 * factor;
		leavesBlock.resistance = 0.2 * factor;
		leavesBlock.breakHarvestLevel = 0;
		leavesBlock.flammability = (int) Math.round(30 * factor);
		leavesBlock.lightOpacity = 1;
		leavesBlock.creativeTab = new TabEntry(workspace, "DECORATIONS");

		leavesBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(leavesBlock);
		mcreator.getWorkspace().addModElement(leavesBlock.getModElement());
		mcreator.getGenerator().generateElement(leavesBlock);
		mcreator.getModElementManager().storeModElement(leavesBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block stairsBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Stairs", ModElementType.BLOCK), false).getElementFromGUI();
		stairsBlock.name = name + " Stairs";
		stairsBlock.blockBase = "Stairs";
		stairsBlock.material = new Material(workspace, "WOOD");
		stairsBlock.texture = planksTextureName;
		stairsBlock.textureTop = planksTextureName;
		stairsBlock.textureFront = planksTextureName;
		stairsBlock.soundOnStep = new StepSound(workspace, "WOOD");
		stairsBlock.hardness = 3 * factor;
		stairsBlock.resistance = 2 * factor;
		stairsBlock.breakHarvestLevel = 0;
		stairsBlock.flammability = (int) Math.round(5 * factor);
		stairsBlock.lightOpacity = 0;

		stairsBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(stairsBlock);
		mcreator.getWorkspace().addModElement(stairsBlock.getModElement());
		mcreator.getGenerator().generateElement(stairsBlock);
		mcreator.getModElementManager().storeModElement(stairsBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block slabBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Slab", ModElementType.BLOCK), false).getElementFromGUI();
		slabBlock.name = name + " Slab";
		slabBlock.blockBase = "Slab";
		slabBlock.material = new Material(workspace, "WOOD");
		slabBlock.texture = planksTextureName;
		slabBlock.textureTop = planksTextureName;
		slabBlock.textureFront = planksTextureName;
		slabBlock.soundOnStep = new StepSound(workspace, "WOOD");
		slabBlock.hardness = 2 * factor;
		slabBlock.resistance = 3 * factor;
		slabBlock.breakHarvestLevel = 0;
		slabBlock.flammability = (int) Math.round(5 * factor);
		slabBlock.lightOpacity = 0;

		slabBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(slabBlock);
		mcreator.getWorkspace().addModElement(slabBlock.getModElement());
		mcreator.getGenerator().generateElement(slabBlock);
		mcreator.getModElementManager().storeModElement(slabBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block fenceBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Fence", ModElementType.BLOCK), false).getElementFromGUI();
		fenceBlock.name = name + " Fence";
		fenceBlock.blockBase = "Fence";
		fenceBlock.material = new Material(workspace, "WOOD");
		fenceBlock.texture = planksTextureName;
		fenceBlock.soundOnStep = new StepSound(workspace, "WOOD");
		fenceBlock.hardness = 2 * factor;
		fenceBlock.resistance = 3 * factor;
		fenceBlock.breakHarvestLevel = 0;
		fenceBlock.flammability = (int) Math.round(5 * factor);
		fenceBlock.lightOpacity = 0;
		fenceBlock.creativeTab = new TabEntry(workspace, "DECORATIONS");

		fenceBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(fenceBlock);
		mcreator.getWorkspace().addModElement(fenceBlock.getModElement());
		mcreator.getGenerator().generateElement(fenceBlock);
		mcreator.getModElementManager().storeModElement(fenceBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block fenceGateBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "FenceGate", ModElementType.BLOCK), false).getElementFromGUI();
		fenceGateBlock.name = name + " Fence Gate";
		fenceGateBlock.blockBase = "FenceGate";
		fenceGateBlock.material = new Material(workspace, "WOOD");
		fenceGateBlock.texture = planksTextureName;
		fenceGateBlock.soundOnStep = new StepSound(workspace, "WOOD");
		fenceGateBlock.hardness = 2 * factor;
		fenceGateBlock.resistance = 3 * factor;
		fenceGateBlock.breakHarvestLevel = 0;
		fenceGateBlock.flammability = (int) Math.round(5 * factor);
		fenceGateBlock.lightOpacity = 0;
		fenceGateBlock.creativeTab = new TabEntry(workspace, "REDSTONE");

		fenceGateBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(fenceGateBlock);
		mcreator.getWorkspace().addModElement(fenceGateBlock.getModElement());
		mcreator.getGenerator().generateElement(fenceGateBlock);
		mcreator.getModElementManager().storeModElement(fenceGateBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block pressurePlateBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "PressurePlate", ModElementType.BLOCK), false).getElementFromGUI();
		pressurePlateBlock.name = name + " Pressure Plate";
		pressurePlateBlock.blockBase = "PressurePlate";
		pressurePlateBlock.material = new Material(workspace, "WOOD");
		pressurePlateBlock.texture = planksTextureName;
		pressurePlateBlock.soundOnStep = new StepSound(workspace, "WOOD");
		pressurePlateBlock.hardness = 2 * factor;
		pressurePlateBlock.resistance = 3 * factor;
		pressurePlateBlock.breakHarvestLevel = 0;
		pressurePlateBlock.flammability = (int) Math.round(5 * factor);
		pressurePlateBlock.lightOpacity = 0;
		pressurePlateBlock.creativeTab = new TabEntry(workspace, "REDSTONE");

		pressurePlateBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(pressurePlateBlock);
		mcreator.getWorkspace().addModElement(pressurePlateBlock.getModElement());
		mcreator.getGenerator().generateElement(pressurePlateBlock);
		mcreator.getModElementManager().storeModElement(pressurePlateBlock);

		// we use Block GUI to get default values for the block element (kinda hacky!)
		Block buttonBlock = (Block) ModElementType.BLOCK.getModElementGUI(mcreator,
				new ModElement(workspace, name + "Button", ModElementType.BLOCK), false).getElementFromGUI();
		buttonBlock.name = name + " Button";
		buttonBlock.blockBase = "Button";
		buttonBlock.material = new Material(workspace, "WOOD");
		buttonBlock.texture = planksTextureName;
		buttonBlock.soundOnStep = new StepSound(workspace, "WOOD");
		buttonBlock.hardness = 2 * factor;
		buttonBlock.resistance = 3 * factor;
		buttonBlock.breakHarvestLevel = 0;
		buttonBlock.lightOpacity = 0;
		buttonBlock.flammability = (int) Math.round(5 * factor);

		buttonBlock.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(buttonBlock);
		mcreator.getWorkspace().addModElement(buttonBlock.getModElement());
		mcreator.getGenerator().generateElement(buttonBlock);
		mcreator.getModElementManager().storeModElement(buttonBlock);

		//Tag - Items
		//Mainly used for recipes and loot tables
		Tag woodItemTag = (Tag) ModElementType.TAG.getModElementGUI(mcreator,
				new ModElement(workspace, name + "ItemsTag", ModElementType.TAG), false).getElementFromGUI();
		woodItemTag.namespace = "forge";
		woodItemTag.name = RegistryNameFixer.fix(name) + "_log";
		woodItemTag.type = "Items";
		woodItemTag.items = new ArrayList<>();
		woodItemTag.items.add(new MItemBlock(workspace, "CUSTOM:" + woodBlock.getModElement().getName()));
		woodItemTag.items.add(new MItemBlock(workspace, "CUSTOM:" + logBlock.getModElement().getName()));

		woodItemTag.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(woodItemTag);
		mcreator.getWorkspace().addModElement(woodItemTag.getModElement());
		mcreator.getGenerator().generateElement(woodItemTag);
		mcreator.getModElementManager().storeModElement(woodItemTag);

		//Recipes
		Recipe woodRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "WoodRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		woodRecipe.recipeSlots[0] = new MItemBlock(workspace, "CUSTOM:" + logBlock.getModElement().getName());
		woodRecipe.recipeSlots[1] = new MItemBlock(workspace, "CUSTOM:" + logBlock.getModElement().getName());
		woodRecipe.recipeSlots[3] = new MItemBlock(workspace, "CUSTOM:" + logBlock.getModElement().getName());
		woodRecipe.recipeSlots[4] = new MItemBlock(workspace, "CUSTOM:" + logBlock.getModElement().getName());
		woodRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "Wood");
		woodRecipe.recipeRetstackSize = 3;

		woodRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(woodRecipe);
		mcreator.getWorkspace().addModElement(woodRecipe.getModElement());
		mcreator.getGenerator().generateElement(woodRecipe);
		mcreator.getModElementManager().storeModElement(woodRecipe);

		Recipe planksRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "PlanksRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		planksRecipe.recipeSlots[4] = new MItemBlock(workspace,
				"TAG:" + woodItemTag.namespace + ":" + woodItemTag.name);
		planksRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "Planks");
		planksRecipe.recipeShapeless = true;
		planksRecipe.recipeRetstackSize = 4;

		planksRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(planksRecipe);
		mcreator.getWorkspace().addModElement(planksRecipe.getModElement());
		mcreator.getGenerator().generateElement(planksRecipe);
		mcreator.getModElementManager().storeModElement(planksRecipe);

		Recipe stairsRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "StairsRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		stairsRecipe.recipeSlots[0] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stairsRecipe.recipeSlots[3] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stairsRecipe.recipeSlots[4] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stairsRecipe.recipeSlots[6] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stairsRecipe.recipeSlots[7] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stairsRecipe.recipeSlots[8] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stairsRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "Stairs");
		stairsRecipe.recipeRetstackSize = 4;

		stairsRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(stairsRecipe);
		mcreator.getWorkspace().addModElement(stairsRecipe.getModElement());
		mcreator.getGenerator().generateElement(stairsRecipe);
		mcreator.getModElementManager().storeModElement(stairsRecipe);

		Recipe slabRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "SlabRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		slabRecipe.recipeSlots[6] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		slabRecipe.recipeSlots[7] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		slabRecipe.recipeSlots[8] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		slabRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "Slab");
		slabRecipe.recipeRetstackSize = 6;

		slabRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(slabRecipe);
		mcreator.getWorkspace().addModElement(slabRecipe.getModElement());
		mcreator.getGenerator().generateElement(slabRecipe);
		mcreator.getModElementManager().storeModElement(slabRecipe);

		Recipe fenceRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "FenceRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		fenceRecipe.recipeSlots[3] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		fenceRecipe.recipeSlots[4] = new MItemBlock(workspace, "Items.STICK");
		fenceRecipe.recipeSlots[5] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		fenceRecipe.recipeSlots[6] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		fenceRecipe.recipeSlots[7] = new MItemBlock(workspace, "Items.STICK");
		fenceRecipe.recipeSlots[8] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		fenceRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "Fence");
		fenceRecipe.recipeRetstackSize = 3;

		fenceRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(fenceRecipe);
		mcreator.getWorkspace().addModElement(fenceRecipe.getModElement());
		mcreator.getGenerator().generateElement(fenceRecipe);
		mcreator.getModElementManager().storeModElement(fenceRecipe);

		Recipe fenceGateRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "FenceGateRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		fenceGateRecipe.recipeSlots[3] = new MItemBlock(workspace, "Items.STICK");
		fenceGateRecipe.recipeSlots[4] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		fenceGateRecipe.recipeSlots[5] = new MItemBlock(workspace, "Items.STICK");
		fenceGateRecipe.recipeSlots[6] = new MItemBlock(workspace, "Items.STICK");
		fenceGateRecipe.recipeSlots[7] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		fenceGateRecipe.recipeSlots[8] = new MItemBlock(workspace, "Items.STICK");
		fenceGateRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "FenceGate");
		fenceGateRecipe.recipeRetstackSize = 1;

		fenceGateRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(fenceGateRecipe);
		mcreator.getWorkspace().addModElement(fenceGateRecipe.getModElement());
		mcreator.getGenerator().generateElement(fenceGateRecipe);
		mcreator.getModElementManager().storeModElement(fenceGateRecipe);

		Recipe pressurePlateRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
						new ModElement(workspace, name + "PressurePlateRecipe", ModElementType.RECIPE), false)
				.getElementFromGUI();
		pressurePlateRecipe.recipeSlots[6] = new MItemBlock(workspace,
				"CUSTOM:" + planksBlock.getModElement().getName());
		pressurePlateRecipe.recipeSlots[7] = new MItemBlock(workspace,
				"CUSTOM:" + planksBlock.getModElement().getName());
		pressurePlateRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "PressurePlate");
		pressurePlateRecipe.recipeRetstackSize = 1;

		pressurePlateRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(pressurePlateRecipe);
		mcreator.getWorkspace().addModElement(pressurePlateRecipe.getModElement());
		mcreator.getGenerator().generateElement(pressurePlateRecipe);
		mcreator.getModElementManager().storeModElement(pressurePlateRecipe);

		Recipe buttonRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "ButtonRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		buttonRecipe.recipeSlots[4] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		buttonRecipe.recipeShapeless = true;
		buttonRecipe.recipeReturnStack = new MItemBlock(workspace, "CUSTOM:" + name + "Button");
		buttonRecipe.recipeRetstackSize = 1;

		buttonRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(buttonRecipe);
		mcreator.getWorkspace().addModElement(buttonRecipe.getModElement());
		mcreator.getGenerator().generateElement(buttonRecipe);
		mcreator.getModElementManager().storeModElement(buttonRecipe);

		Recipe stickRecipe = (Recipe) ModElementType.RECIPE.getModElementGUI(mcreator,
				new ModElement(workspace, name + "StickRecipe", ModElementType.RECIPE), false).getElementFromGUI();
		stickRecipe.recipeSlots[0] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stickRecipe.recipeSlots[3] = new MItemBlock(workspace, "CUSTOM:" + planksBlock.getModElement().getName());
		stickRecipe.recipeReturnStack = new MItemBlock(workspace, "Items.STICK");
		stickRecipe.recipeRetstackSize = 4;

		stickRecipe.getModElement().setParentFolder(folder);
		mcreator.getModElementManager().storeModElementPicture(stickRecipe);
		mcreator.getWorkspace().addModElement(stickRecipe.getModElement());
		mcreator.getGenerator().generateElement(stickRecipe);
		mcreator.getModElementManager().storeModElement(stickRecipe);
	}

	public static BasicAction getAction(ActionRegistry actionRegistry) {
		return new BasicAction(actionRegistry, L10N.t("action.pack_tools.wood"),
				e -> open(actionRegistry.getMCreator())) {
			@Override public boolean isEnabled() {
				GeneratorConfiguration gc = actionRegistry.getMCreator().getGeneratorConfiguration();
				return gc.getGeneratorStats().getModElementTypeCoverageInfo().get(ModElementType.RECIPE)
						!= GeneratorStats.CoverageStatus.NONE
						&& gc.getGeneratorStats().getModElementTypeCoverageInfo().get(ModElementType.BLOCK)
						!= GeneratorStats.CoverageStatus.NONE
						&& gc.getGeneratorStats().getModElementTypeCoverageInfo().get(ModElementType.TAG)
						!= GeneratorStats.CoverageStatus.NONE;
			}
		}.setIcon(UIRES.get("16px.woodpack"));
	}

}
