/*
 * MCreator (https://mcreator.net/)
 * Copyright (C) 2020 Pylo and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package net.mcreator.element.types.interfaces;

import net.mcreator.io.FileIO;
import net.mcreator.workspace.resources.Model;

@SuppressWarnings("unused") public interface IEntityWithModel {

	Model getEntityModel();

	default String getModelCode() {
		Model model = getEntityModel();
		if (model != null && model.getType() == Model.Type.JAVA) {
			return FileIO.readFileToString(model.getFile());
		}
		return null;
	}

	default Model.Type getModelType() {
		if (getEntityModel() == null)
			return Model.Type.BUILTIN;
		return getEntityModel().getType();
	}

	default boolean isBuiltInModel() {
		return getModelType() == Model.Type.BUILTIN;
	}

	default boolean isCustomModel() {
		return !isBuiltInModel();
	}

}
