/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.sparseimage.ChunkHeader;
import ghidra.file.formats.sparseimage.SparseHeader;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class SparseImageDecompressor {
    private BinaryReader reader;
    private CRC32 crc;
    private int bufferSize = 0x100000;
    private OutputStream tempFos;
    private int blockSize;

    public SparseImageDecompressor(ByteProvider provider, OutputStream os) {
        this.reader = new BinaryReader(provider, true);
        this.crc = new CRC32();
        this.tempFos = os;
    }

    public void decompress(TaskMonitor monitor) throws CancelledException, IOException {
        SparseHeader sparseHeader = new SparseHeader(this.reader);
        if (sparseHeader.getMajor_version() != 1) {
            throw new IOException("Unsupported major version number.");
        }
        this.blockSize = sparseHeader.getBlk_sz();
        int totalBlocks = 0;
        monitor.setMaximum((long)sparseHeader.getTotal_chunks());
        monitor.setProgress(0L);
        for (int i = 0; i < sparseHeader.getTotal_chunks(); ++i) {
            monitor.checkCancelled();
            monitor.setMessage("Processing chunk " + i + " of " + sparseHeader.getTotal_chunks() + "...");
            ChunkHeader chunkHeader = new ChunkHeader(this.reader);
            short chunkType = chunkHeader.getChunk_type();
            int chunkSize = chunkHeader.getChunk_sz();
            if (chunkType == -13631) {
                this.processRawChunk(chunkSize, monitor);
                totalBlocks += chunkSize;
            } else if (chunkType == -13630) {
                this.processFillChunk(chunkSize, monitor);
                totalBlocks += chunkSize;
            } else if (chunkType == -13629) {
                this.processSkipChunk(chunkSize, monitor);
                totalBlocks += chunkSize;
            } else if (chunkType == -13628) {
                this.processCrcChunk();
                totalBlocks += chunkSize;
            } else {
                throw new IOException("Unkown chunk type: " + chunkType);
            }
            monitor.incrementProgress(1L);
        }
        long totalSize = (long)totalBlocks * (long)sparseHeader.getBlk_sz();
        monitor.setMessage("Total bytes: " + totalSize);
    }

    private void processCrcChunk() throws IOException {
        int value;
        int fileCrc = this.reader.readNextInt();
        if (fileCrc != (value = (int)this.crc.getValue())) {
            throw new IOException("Computed crc (0x" + Integer.toHexString(value) + ") did not match the expected crc (0x" + Integer.toHexString(fileCrc) + ").");
        }
    }

    private void processSkipChunk(int blocks, TaskMonitor monitor) throws IOException, CancelledException {
        long length = (long)blocks * (long)this.blockSize;
        if (length > (long)this.bufferSize) {
            byte[] bytes = new byte[this.bufferSize];
            int i = 0;
            while ((long)i < length / (long)this.bufferSize) {
                monitor.checkCancelled();
                this.tempFos.write(bytes);
                ++i;
            }
        }
        int size = (int)length % this.bufferSize;
        byte[] bytes = new byte[size];
        this.tempFos.write(bytes);
    }

    private static void fillArray(byte[] srcPattern, byte[] destArray) {
        int srcIndex = 0;
        for (int destIndex = 0; destIndex < destArray.length; ++destIndex) {
            if (srcIndex >= srcPattern.length) {
                srcIndex = 0;
            }
            destArray[destIndex] = srcPattern[srcIndex];
            ++srcIndex;
        }
    }

    private void processFillChunk(int blocks, TaskMonitor monitor) throws IOException, CancelledException {
        int bytesToWrite;
        long length;
        int fillInt = this.reader.readNextInt();
        int fillBufferSize = (int)Math.min(length, (long)this.bufferSize);
        byte[] fillBuffer = new byte[fillBufferSize];
        byte[] srcPattern = new byte[]{(byte)(fillInt >> 24), (byte)(fillInt >> 16), (byte)(fillInt >> 8), (byte)(fillInt & 0xFF)};
        SparseImageDecompressor.fillArray(srcPattern, fillBuffer);
        for (length = (long)blocks * (long)this.blockSize; length > 0L; length -= (long)bytesToWrite) {
            monitor.checkCancelled();
            bytesToWrite = (int)Math.min(length, (long)fillBufferSize);
            this.crc.update(fillBuffer, 0, bytesToWrite);
            this.tempFos.write(fillBuffer, 0, bytesToWrite);
        }
    }

    private void processRawChunk(int blocks, TaskMonitor monitor) throws IOException, CancelledException {
        int bytesToRead;
        for (long length = (long)blocks * (long)this.blockSize; length > 0L; length -= (long)bytesToRead) {
            monitor.checkCancelled();
            bytesToRead = (int)Math.min(length, (long)this.bufferSize);
            byte[] bytes = this.reader.readNextByteArray(bytesToRead);
            this.crc.update(bytes);
            this.tempFos.write(bytes);
        }
    }
}

