/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class VendorRamdiskTableEntryV4
implements StructConverter {
    private int ramdisk_size;
    private int ramdisk_offset;
    private int ramdisk_type;
    private String ramdisk_name;
    private int[] board_id;

    public VendorRamdiskTableEntryV4(BinaryReader reader) throws IOException {
        this.ramdisk_size = reader.readNextInt();
        this.ramdisk_offset = reader.readNextInt();
        this.ramdisk_type = reader.readNextInt();
        this.ramdisk_name = reader.readNextAsciiString(32);
        this.board_id = reader.readNextIntArray(16);
    }

    public int getRamdiskSize() {
        return this.ramdisk_size;
    }

    public int getRamdiskOffset() {
        return this.ramdisk_offset;
    }

    public int getRamdiskType() {
        return this.ramdisk_type;
    }

    public String getRamdiskName() {
        return this.ramdisk_name;
    }

    public int[] getBoardID() {
        return this.board_id;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("vendor_ramdisk_table_entry_v4", 0);
        structure.add(DWORD, "ramdisk_size", null);
        structure.add(DWORD, "ramdisk_offset", null);
        structure.add(DWORD, "ramdisk_type", null);
        structure.add(UTF8, 32, "ramdisk_name", null);
        for (int i = 0; i < 16; ++i) {
            structure.add(DWORD, "board_id_" + i, null);
        }
        return structure;
    }
}

