/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.decorators.EllipseShapeFunction;
import org.jungrapht.visualization.decorators.IconShapeFunction;
import org.jungrapht.visualization.renderers.BiModalRenderer;
import org.jungrapht.visualization.renderers.HeavyweightVertexLabelRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.renderers.VertexLabelAsShapeRenderer;

public class VertexStyleConfiguration<V, E> {
    private VisualizationServer<V, E> vv;
    private VertexLabelAsShapeRenderer<V, E> vlasr;
    private IconShapeFunction<V> vertexImageShapeFunction = new IconShapeFunction<Object>(v -> new Ellipse2D.Float(-20.0f, -20.0f, 40.0f, 40.0f));
    private Supplier<Boolean> showVertexIconSupplier;
    private Supplier<Boolean> showVertexLabelSupplier;
    private Supplier<Renderer.VertexLabel.Position> labelPositionSupplier;
    private Function<V, String> labelFunction;
    private Function<V, Icon> iconFunction;
    private Function<V, Shape> vertexShapeFunction;

    public static <V, E> Builder<V, E, ?, ?> builder(VisualizationServer<V, E> vv) {
        return new Builder(vv);
    }

    protected VertexStyleConfiguration(Builder<V, E, ?, ?> builder) {
        this.vv = builder.vv;
        this.vertexShapeFunction = builder.vertexShapeFunction;
        this.showVertexIconSupplier = builder.showVertexIconSupplier;
        this.showVertexLabelSupplier = builder.showVertexLabelSupplier;
        this.iconFunction = builder.iconFunction;
        this.labelPositionSupplier = builder.labelPositionSupplier;
        this.labelFunction = builder.labelFunction;
        this.vlasr = new VertexLabelAsShapeRenderer<V, E>(this.vv.getVisualizationModel().getLayoutModel(), this.vv.getRenderContext());
    }

    public void configure() {
        if (this.showVertexIconSupplier.get().booleanValue()) {
            this.vertexImageShapeFunction.setIconFunction(this.iconFunction);
            this.vv.getRenderContext().setVertexIconFunction(this.iconFunction);
            this.vv.getRenderContext().setVertexShapeFunction(this.vertexImageShapeFunction);
            if (this.showVertexLabelSupplier.get().booleanValue()) {
                this.vv.getRenderContext().setVertexLabelFunction(this.labelFunction);
                this.vv.getRenderContext().setVertexLabelPosition(this.labelPositionSupplier.get());
            } else {
                this.vv.getRenderContext().setVertexLabelFunction(v -> null);
            }
        } else {
            this.vv.getRenderContext().setVertexIconFunction(null);
            if (this.showVertexLabelSupplier.get().booleanValue()) {
                Renderer.VertexLabel.Position position = this.labelPositionSupplier.get();
                this.vv.getRenderContext().setVertexLabelPosition(position);
                this.vv.getRenderContext().setVertexLabelFunction(this.labelFunction);
                if (position == Renderer.VertexLabel.Position.CNTR) {
                    this.vv.getRenderContext().setVertexShapeFunction(this.vlasr);
                    this.vv.getRenderer().setVertexLabelRenderer(BiModalRenderer.HEAVYWEIGHT, this.vlasr);
                } else {
                    this.vv.getRenderer().setVertexLabelRenderer(BiModalRenderer.HEAVYWEIGHT, new HeavyweightVertexLabelRenderer());
                    this.vv.getRenderContext().setVertexShapeFunction(this.vertexShapeFunction);
                }
            } else {
                this.vv.getRenderContext().setVertexLabelFunction(vertex -> null);
            }
        }
        this.vv.repaint();
    }

    public static class Builder<V, E, T extends VertexStyleConfiguration<V, E>, B extends Builder<V, E, T, B>> {
        private VisualizationServer<V, E> vv;
        private Supplier<Boolean> showVertexIconSupplier = () -> false;
        private Supplier<Boolean> showVertexLabelSupplier = () -> false;
        private Supplier<Renderer.VertexLabel.Position> labelPositionSupplier = () -> Renderer.VertexLabel.Position.SE;
        private Function<V, String> labelFunction = v -> null;
        private Function<V, Icon> iconFunction = null;
        private Function<V, Shape> vertexShapeFunction = new EllipseShapeFunction<V>();

        public B self() {
            return (B)this;
        }

        public B showVertexIconSupplier(Supplier<Boolean> showVertexIconSupplier) {
            this.showVertexIconSupplier = showVertexIconSupplier;
            return this.self();
        }

        public B showVertexLabelSupplier(Supplier<Boolean> showVertexLabelSupplier) {
            this.showVertexLabelSupplier = showVertexLabelSupplier;
            return this.self();
        }

        public B labelPositionSupplier(Supplier<Renderer.VertexLabel.Position> labelPositionSupplier) {
            this.labelPositionSupplier = labelPositionSupplier;
            return this.self();
        }

        public B labelFunction(Function<V, String> labelFunction) {
            this.labelFunction = labelFunction;
            return this.self();
        }

        public B iconFunction(Function<V, Icon> iconFunction) {
            this.iconFunction = iconFunction;
            return this.self();
        }

        public B vertexShapeFunction(Function<V, Shape> vertexShapeFunction) {
            this.vertexShapeFunction = vertexShapeFunction;
            return this.self();
        }

        private Builder(VisualizationServer<V, E> vv) {
            this.vv = vv;
        }

        public T build() {
            return (T)new VertexStyleConfiguration(this);
        }
    }
}

