/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionFlags;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class SectionHeader
implements StructConverter,
ByteArrayConverter {
    public static final String NAME = "IMAGE_SECTION_HEADER";
    public static final int IMAGE_SIZEOF_SHORT_NAME = 8;
    public static final int IMAGE_SIZEOF_SECTION_HEADER = 40;
    public static final int IMAGE_SCN_CNT_CODE = 32;
    public static final int IMAGE_SCN_CNT_INITIALIZED_DATA = 64;
    public static final int IMAGE_SCN_CNT_UNINITIALIZED_DATA = 128;
    public static final int IMAGE_SCN_LNK_INFO = 512;
    public static final int IMAGE_SCN_LNK_REMOVE = 2048;
    public static final int IMAGE_SCN_LNK_COMDAT = 4096;
    public static final int IMAGE_SCN_NO_DEFER_SPEC_EXC = 16384;
    public static final int IMAGE_SCN_GPREL = 32768;
    public static final int IMAGE_SCN_ALIGN_1BYTES = 0x100000;
    public static final int IMAGE_SCN_ALIGN_2BYTES = 0x200000;
    public static final int IMAGE_SCN_ALIGN_4BYTES = 0x300000;
    public static final int IMAGE_SCN_ALIGN_8BYTES = 0x400000;
    public static final int IMAGE_SCN_ALIGN_16BYTES = 0x500000;
    public static final int IMAGE_SCN_ALIGN_32BYTES = 0x600000;
    public static final int IMAGE_SCN_ALIGN_64BYTES = 0x700000;
    public static final int IMAGE_SCN_ALIGN_128BYTES = 0x800000;
    public static final int IMAGE_SCN_ALIGN_256BYTES = 0x900000;
    public static final int IMAGE_SCN_ALIGN_512BYTES = 0xA00000;
    public static final int IMAGE_SCN_ALIGN_1024BYTES = 0xB00000;
    public static final int IMAGE_SCN_ALIGN_2048BYTES = 0xC00000;
    public static final int IMAGE_SCN_ALIGN_4096BYTES = 0xD00000;
    public static final int IMAGE_SCN_ALIGN_8192BYTES = 0xE00000;
    public static final int IMAGE_SCN_ALIGN_MASK = 0xF00000;
    public static final int IMAGE_SCN_LNK_NRELOC_OVFL = 0x1000000;
    public static final int IMAGE_SCN_MEM_DISCARDABLE = 0x2000000;
    public static final int IMAGE_SCN_MEM_NOT_CACHED = 0x4000000;
    public static final int IMAGE_SCN_MEM_NOT_PAGED = 0x8000000;
    public static final int IMAGE_SCN_MEM_SHARED = 0x10000000;
    public static final int IMAGE_SCN_MEM_EXECUTE = 0x20000000;
    public static final int IMAGE_SCN_MEM_READ = 0x40000000;
    public static final int IMAGE_SCN_MEM_WRITE = Integer.MIN_VALUE;
    public static final int NOT_SET = -1;
    private String name;
    private int physicalAddress;
    private int virtualSize;
    private int virtualAddress;
    private int sizeOfRawData;
    private int pointerToRawData;
    private int pointerToRelocations;
    private int pointerToLinenumbers;
    private short numberOfRelocations;
    private short numberOfLinenumbers;
    private int characteristics;
    private BinaryReader reader;

    public static SectionHeader readSectionHeader(BinaryReader reader, long index, long stringTableOffset) throws IOException {
        SectionHeader result = new SectionHeader();
        result.reader = reader;
        result.name = reader.readAsciiString(index, 8).trim();
        if (result.name.startsWith("/") && stringTableOffset != -1L) {
            try {
                int nameOffset = Integer.parseInt(result.name.substring(1));
                result.name = reader.readAsciiString(stringTableOffset + (long)nameOffset);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        reader.setPointerIndex(index + 8L);
        result.physicalAddress = result.virtualSize = reader.readNextInt();
        result.virtualAddress = reader.readNextInt();
        result.sizeOfRawData = reader.readNextInt();
        result.pointerToRawData = reader.readNextInt();
        result.pointerToRelocations = reader.readNextInt();
        result.pointerToLinenumbers = reader.readNextInt();
        result.numberOfRelocations = reader.readNextShort();
        result.numberOfLinenumbers = reader.readNextShort();
        result.characteristics = reader.readNextInt();
        return result;
    }

    private SectionHeader() {
    }

    SectionHeader(MemoryBlock block, OptionalHeader optHeader, int ptr) {
        this.name = block.getName();
        this.physicalAddress = this.virtualSize = (int)block.getSize();
        this.virtualAddress = (int)block.getStart().getOffset() - (int)optHeader.getImageBase();
        this.sizeOfRawData = PortableExecutable.computeAlignment(this.virtualSize, optHeader.getFileAlignment());
        this.pointerToRawData = ptr;
        this.pointerToLinenumbers = 0;
        this.pointerToRelocations = 0;
        this.numberOfLinenumbers = 0;
        this.numberOfRelocations = 0;
        this.characteristics = 0;
        if (block.isRead()) {
            this.characteristics |= SectionFlags.IMAGE_SCN_MEM_READ.getMask();
        }
        if (block.isWrite()) {
            this.characteristics |= SectionFlags.IMAGE_SCN_MEM_WRITE.getMask();
        }
        if (block.isExecute()) {
            this.characteristics |= SectionFlags.IMAGE_SCN_MEM_EXECUTE.getMask() | SectionFlags.IMAGE_SCN_CNT_CODE.getMask();
        }
        if (block.isExecute()) {
            this.characteristics |= 0x20000020;
        } else if (block.getType() == MemoryBlockType.DEFAULT) {
            this.characteristics = block.isInitialized() ? (this.characteristics |= SectionFlags.IMAGE_SCN_CNT_INITIALIZED_DATA.getMask()) : (this.characteristics |= SectionFlags.IMAGE_SCN_CNT_UNINITIALIZED_DATA.getMask());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getReadableName() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.name.length(); ++i) {
            char ch = this.name.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                buffer.append(ch);
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }

    public int getPhysicalAddress() {
        return this.physicalAddress;
    }

    public int getVirtualAddress() {
        return this.virtualAddress;
    }

    public int getVirtualSize() {
        if (this.virtualSize == 0) {
            return this.sizeOfRawData;
        }
        return this.virtualSize;
    }

    public int getSizeOfRawData() {
        return this.sizeOfRawData;
    }

    public int getPointerToRawData() {
        if (this.pointerToRawData < 512) {
            return 0;
        }
        return this.pointerToRawData;
    }

    public int getPointerToRelocations() {
        return this.pointerToRelocations;
    }

    public short getNumberOfRelocations() {
        return this.numberOfRelocations;
    }

    public int getPointerToLinenumbers() {
        return this.pointerToLinenumbers;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public short getNumberOfLinenumbers() {
        return this.numberOfLinenumbers;
    }

    @Override
    public byte[] toBytes(DataConverter dc) throws IOException {
        return this.reader.readByteArray(this.getPointerToRawData(), this.getSizeOfRawData());
    }

    public InputStream getDataStream() throws IOException {
        return this.reader.getByteProvider().getInputStream(this.getPointerToRawData());
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Section Header:\n");
        buff.append("\tname:                 " + this.name + "\n");
        buff.append("\tphysicalAddress:      " + Integer.toHexString(this.physicalAddress) + "\n");
        buff.append("\tvirtualSize:          " + Integer.toHexString(this.virtualSize) + "\n");
        buff.append("\tvirtualAddress:       " + Integer.toHexString(this.virtualAddress) + "\n");
        buff.append("\tsizeOfRawData:        " + Integer.toHexString(this.sizeOfRawData) + "\n");
        buff.append("\tpointerToRawData:     " + Integer.toHexString(this.pointerToRawData) + "\n");
        buff.append("\tpointerToRelocations: " + Integer.toHexString(this.pointerToRelocations) + "\n");
        buff.append("\tpointerToLinenumbers: " + Integer.toHexString(this.pointerToLinenumbers) + "\n");
        buff.append("\tnumberOfRelocations:  " + Integer.toHexString(this.numberOfRelocations) + "\n");
        buff.append("\tnumberOfLinenumbers:  " + Integer.toHexString(this.numberOfLinenumbers) + "\n");
        buff.append("\tcharacteristics:      " + Integer.toHexString(this.characteristics) + "\n");
        return buff.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        UnionDataType union = new UnionDataType("Misc");
        union.add(DWORD, "PhysicalAddress", null);
        union.add(DWORD, "VirtualSize", null);
        union.setCategoryPath(new CategoryPath("/PE"));
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new ArrayDataType(ASCII, 8, 1), "Name", null);
        struct.add((DataType)union, "Misc", null);
        struct.add(IBO32, "VirtualAddress", null);
        struct.add(DWORD, "SizeOfRawData", null);
        struct.add(DWORD, "PointerToRawData", null);
        struct.add(DWORD, "PointerToRelocations", null);
        struct.add(DWORD, "PointerToLinenumbers", null);
        struct.add(WORD, "NumberOfRelocations", null);
        struct.add(WORD, "NumberOfLinenumbers", null);
        EnumDataType characteristicsEnum = new EnumDataType("SectionFlags", 4);
        characteristicsEnum.setCategoryPath(new CategoryPath("/PE"));
        for (SectionFlags flag : SectionFlags.values()) {
            characteristicsEnum.add(flag.name(), Integer.toUnsignedLong(flag.getMask()));
        }
        struct.add((DataType)characteristicsEnum, "Characteristics", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public void writeHeader(RandomAccessFile raf, DataConverter dc) throws IOException {
        byte[] paddedName = new byte[8];
        byte[] nameBytes = this.name.getBytes();
        System.arraycopy(nameBytes, 0, paddedName, 0, Math.min(nameBytes.length, 8));
        raf.write(paddedName);
        raf.write(dc.getBytes(this.virtualSize));
        raf.write(dc.getBytes(this.virtualAddress));
        raf.write(dc.getBytes(this.sizeOfRawData));
        raf.write(dc.getBytes(this.pointerToRawData));
        raf.write(dc.getBytes(this.pointerToRelocations));
        raf.write(dc.getBytes(this.pointerToLinenumbers));
        raf.write(dc.getBytes(this.numberOfRelocations));
        raf.write(dc.getBytes(this.numberOfLinenumbers));
        raf.write(dc.getBytes(this.characteristics));
    }

    public void writeBytes(RandomAccessFile raf, int rafIndex, DataConverter dc, MemoryBlock block, boolean useBlockBytes) throws IOException, MemoryAccessException {
        if (this.getSizeOfRawData() == 0) {
            return;
        }
        raf.seek(rafIndex);
        if (useBlockBytes) {
            byte[] blockBytes = new byte[(int)block.getSize()];
            block.getBytes(block.getStart(), blockBytes);
            raf.write(blockBytes);
        } else {
            raf.write(this.toBytes(dc));
        }
        int padLength = this.getSizeOfRawData() - this.getVirtualSize();
        if (padLength > 0) {
            raf.write(new byte[padLength]);
        }
    }

    void updatePointers(int offset) {
        if (this.pointerToRawData > 0) {
            this.pointerToRawData += offset;
        }
        if (this.pointerToRelocations > 0) {
            this.pointerToRelocations += offset;
        }
        if (this.pointerToLinenumbers > 0) {
            this.pointerToLinenumbers += offset;
        }
    }

    public void setVirtualSize(int size) {
        this.virtualSize = size;
    }

    public void setSizeOfRawData(int size) {
        this.sizeOfRawData = size;
    }
}

