/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import db.DBHandle;
import db.DBListener;
import db.DBRecord;
import db.Table;
import db.TableStatistics;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.plugin.debug.dbtable.DbSmallTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

class DbViewerComponent
extends JPanel {
    private static Table[] NO_TABLES = new Table[0];
    private static Comparator<Table> TABLE_NAME_COMPARATOR = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private DBHandle dbh;
    private DBListener dbListener;
    private JPanel centerPanel;
    private JComponent southComponent;
    private JLabel dbLabel;
    private JComboBox<TableItem> combo;
    private Table[] tables = NO_TABLES;
    private Map<String, TableStatistics[]> tableStats = new HashMap<String, TableStatistics[]>();
    private SwingUpdateManager updateMgr;
    private PluginTool tool;
    private GTableFilterPanel<DBRecord> tableFilterPanel;

    DbViewerComponent(PluginTool tool) {
        super(new BorderLayout());
        this.tool = tool;
        JPanel northPanel = new JPanel(new FlowLayout(0));
        JPanel subNorthPanel = new JPanel((LayoutManager)new PairLayout(4, 10));
        subNorthPanel.add((Component)new GLabel("Database:"));
        this.dbLabel = new GDLabel();
        subNorthPanel.add(this.dbLabel);
        subNorthPanel.add((Component)new GLabel("Tables:"));
        this.combo = new GComboBox();
        this.combo.addActionListener(e -> this.refreshTable());
        subNorthPanel.add(this.combo);
        northPanel.add(subNorthPanel);
        this.add((Component)northPanel, "North");
        this.updateMgr = new SwingUpdateManager(100, 2000, () -> this.refresh());
    }

    synchronized void closeDatabase() {
        if (this.dbh != null) {
            this.combo.removeAllItems();
            this.dbLabel.setText("");
            this.removeWidgets();
            this.tables = NO_TABLES;
            this.tableStats.clear();
            this.dbh = null;
            this.dbListener = null;
            this.revalidate();
        }
    }

    private void removeWidgets() {
        if (this.centerPanel != null) {
            this.remove(this.centerPanel);
            this.remove(this.southComponent);
            this.centerPanel = null;
            this.southComponent = null;
        }
    }

    synchronized void openDatabase(String name, DBHandle handle) {
        this.closeDatabase();
        this.dbh = handle;
        this.dbLabel.setText(name);
        this.updateTableChoices(null);
        this.dbListener = new InternalDBListener();
        handle.addListener(this.dbListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refresh() {
        if (this.dbh == null) {
            return;
        }
        DBHandle dBHandle = this.dbh;
        synchronized (dBHandle) {
            this.updateTableChoices((TableItem)this.combo.getSelectedItem());
            this.updateTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refreshTable() {
        if (this.dbh == null) {
            this.removeWidgets();
            return;
        }
        DBHandle dBHandle = this.dbh;
        synchronized (dBHandle) {
            this.updateTable();
        }
    }

    synchronized void dispose() {
        this.updateMgr.dispose();
        this.tableFilterPanel.dispose();
        this.closeDatabase();
    }

    private TableStatistics[] getStats(Table table) {
        TableStatistics[] stats = this.tableStats.get(table.getName());
        if (stats == null) {
            try {
                stats = table.getAllStatistics();
                for (int i = 2; i < stats.length; ++i) {
                    stats[1].bufferCount += stats[i].bufferCount;
                    stats[1].chainedBufferCnt += stats[i].chainedBufferCnt;
                    stats[1].interiorNodeCnt += stats[i].interiorNodeCnt;
                    stats[1].recordNodeCnt += stats[i].recordNodeCnt;
                    stats[1].size += stats[i].size;
                }
                this.tableStats.put(table.getName(), stats);
            }
            catch (IOException e) {
                Msg.debug((Object)this, (Object)"Unexpected exception", (Throwable)e);
            }
        }
        return stats;
    }

    private void updateTableChoices(TableItem selectedTable) {
        this.tables = NO_TABLES;
        this.combo.removeAllItems();
        this.tableStats.clear();
        if (this.dbh != null) {
            this.tables = this.dbh.getTables();
            Arrays.sort(this.tables, TABLE_NAME_COMPARATOR);
        }
        int selIndex = -1;
        for (int i = 0; i < this.tables.length; ++i) {
            this.combo.addItem(new TableItem(this.tables[i]));
            if (selectedTable == null || !this.tables[i].getName().equals(selectedTable.name)) continue;
            selIndex = i;
        }
        if (selIndex >= 0) {
            this.combo.setSelectedIndex(selIndex);
        }
    }

    private void updateTable() {
        this.removeWidgets();
        TableItem t = (TableItem)this.combo.getSelectedItem();
        if (t != null) {
            this.centerPanel = this.createCenterPanel(t.table);
            this.add((Component)this.centerPanel, "Center");
            this.southComponent = this.createSouthComponent(t.table);
            this.add((Component)this.southComponent, "South");
        }
        this.revalidate();
    }

    private JComponent createSouthComponent(Table table) {
        TableStatistics[] stats = this.getStats(table);
        String recCnt = "Records: " + Integer.toString(table.getRecordCount());
        Object intNodeCnt = "";
        Object recNodeCnt = "";
        Object chainBufCnt = "";
        Object size = "";
        if (stats != null) {
            intNodeCnt = "Interior Nodes: " + Integer.toString(stats[0].interiorNodeCnt);
            recNodeCnt = "Record Nodes: " + Integer.toString(stats[0].recordNodeCnt);
            chainBufCnt = "Chained Buffers: " + Integer.toString(stats[0].chainedBufferCnt);
            size = "Size (KB): " + Integer.toString(stats[0].size / 1024);
            if (stats.length > 1) {
                intNodeCnt = (String)intNodeCnt + " / " + Integer.toString(stats[1].interiorNodeCnt);
                recNodeCnt = (String)recNodeCnt + " / " + Integer.toString(stats[1].recordNodeCnt);
                chainBufCnt = (String)chainBufCnt + " / " + Integer.toString(stats[1].chainedBufferCnt);
                size = (String)size + " / " + Integer.toString(stats[1].size / 1024);
            }
        }
        return new GLabel(recCnt + "   " + (String)intNodeCnt + "   " + (String)recNodeCnt + "   " + (String)chainBufCnt + "   " + (String)size);
    }

    private JPanel createCenterPanel(Table table) {
        JPanel panel = new JPanel(new BorderLayout());
        DbSmallTableModel model = new DbSmallTableModel((ServiceProvider)this.tool, table);
        GThreadedTablePanel threadedPanel = new GThreadedTablePanel((ThreadedTableModel)model);
        GTable gTable = threadedPanel.getTable();
        this.tableFilterPanel = new GTableFilterPanel((JTable)gTable, (RowObjectTableModel)model);
        panel.add((Component)threadedPanel, "Center");
        panel.add((Component)this.tableFilterPanel, "South");
        return panel;
    }

    private static class TableItem {
        String name;
        Table table;

        TableItem(Table table) {
            this.table = table;
            this.name = table.getName();
        }

        public String toString() {
            return this.name + " (" + this.table.getRecordCount() + ")";
        }
    }

    private class InternalDBListener
    implements DBListener {
        private InternalDBListener() {
        }

        public void dbClosed(DBHandle handle) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.closeDatabase();
            }
        }

        public void dbRestored(DBHandle handle) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.updateMgr.updateLater();
            }
        }

        public void tableAdded(DBHandle handle, Table table) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.updateMgr.updateLater();
            }
        }

        public void tableDeleted(DBHandle handle, Table table) {
            if (handle == DbViewerComponent.this.dbh) {
                DbViewerComponent.this.updateMgr.updateLater();
            }
        }
    }
}

