/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.Icons;

public class DeleteAction
extends SymbolTreeContextAction {
    private static final Icon DELETE_ICON = Icons.DELETE_ICON;
    private final SymbolTreePlugin plugin;

    public DeleteAction(SymbolTreePlugin plugin) {
        super("Delete Symbols", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Delete"}, DELETE_ICON, "xxx", -1, "2"));
        this.setKeyBindingData(new KeyBindingData(127, 0));
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath treePath : selectionPaths) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof SymbolNode) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        Program program = this.plugin.getProgram();
        int transactionID = program.startTransaction("Delete Symbol(s)");
        try {
            for (TreePath treePath : selectionPaths) {
                SymbolNode symbolNode = (SymbolNode)((Object)treePath.getLastPathComponent());
                Symbol symbol = symbolNode.getSymbol();
                symbol.delete();
                symbolNode.getParent().removeNode((GTreeNode)symbolNode);
            }
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }
}

