/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functionwindow;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.functionwindow.FunctionRowObject;
import ghidra.app.util.SymbolInspector;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.LongIterator;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.FunctionBodySizeTableColumn;
import ghidra.util.table.field.FunctionLocalStackSizeColumn;
import ghidra.util.table.field.FunctionParameterStackSizeColumn;
import ghidra.util.table.field.FunctionSignatureTableColumn;
import ghidra.util.table.field.FunctionTagTableColumn;
import ghidra.util.table.field.IsFunctionCustomStorageTableColumn;
import ghidra.util.table.field.IsFunctionInlineTableColumn;
import ghidra.util.table.field.IsFunctionNonReturningTableColumn;
import ghidra.util.table.field.IsFunctionVarargsTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;

public class FunctionTableModel
extends AddressBasedTableModel<FunctionRowObject> {
    static final int LOCATION_COL_WIDTH = 50;
    static final int NAME_COL = 0;
    static final int LOCATION_COL = 1;
    static final int PROTOTYPE_COL = 2;
    private FunctionManager functionMgr;

    public FunctionTableModel(PluginTool tool, Program program) {
        super("Functions", (ServiceProvider)tool, program, null);
        this.functionMgr = program != null ? program.getFunctionManager() : null;
    }

    @Override
    protected TableColumnDescriptor<FunctionRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new NameTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionSignatureTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionBodySizeTableColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionTagTableColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new IsFunctionInlineTableColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new IsFunctionNonReturningTableColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new IsFunctionVarargsTableColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new IsFunctionCustomStorageTableColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionLocalStackSizeColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionParameterStackSizeColumn()));
        return descriptor;
    }

    public void reload(Program newProgram) {
        this.setProgram(newProgram);
        this.functionMgr = this.program != null ? this.program.getFunctionManager() : null;
        this.reload();
    }

    public int getKeyCount() {
        if (this.functionMgr == null) {
            return 0;
        }
        return this.functionMgr.getFunctionCount();
    }

    protected void doLoad(Accumulator<FunctionRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        LongIterator it = LongIterator.EMPTY;
        if (this.functionMgr != null) {
            it = new FunctionKeyIterator(this, this.functionMgr);
        }
        monitor.initialize((long)this.getKeyCount());
        int progress = 0;
        while (it.hasNext()) {
            monitor.setProgress((long)progress++);
            monitor.checkCancelled();
            long key = it.next();
            Function f = this.functionMgr.getFunction(key);
            accumulator.add((Object)new FunctionRowObject(f));
        }
    }

    void functionAdded(Function f) {
        if (this.supportsFunction(f)) {
            this.addObject(new FunctionRowObject(f));
        }
    }

    void functionRemoved(Function f) {
        if (this.supportsFunction(f)) {
            this.removeObject(new FunctionRowObject(f));
        }
    }

    void update(Function f) {
        if (this.supportsFunction(f)) {
            this.updateObject(new FunctionRowObject(f));
        }
    }

    private boolean supportsFunction(Function f) {
        return !f.isExternal();
    }

    @Override
    public Address getAddress(int row) {
        FunctionRowObject rowObject = (FunctionRowObject)this.getRowObject(row);
        FunctionManager functionManager = this.program.getFunctionManager();
        Function function = functionManager.getFunction(rowObject.getKey());
        return function != null ? function.getEntryPoint() : null;
    }

    static /* synthetic */ ServiceProvider access$000(FunctionTableModel x0) {
        return x0.serviceProvider;
    }

    private class NameTableColumn
    extends AbstractProgramBasedDynamicTableColumn<FunctionRowObject, String> {
        private GColumnRenderer<String> renderer = new FunctionNameRenderer();
        private SymbolInspector inspector = new SymbolInspector(FunctionTableModel.access$000(FunctionTableModel.this), null);

        private NameTableColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(FunctionRowObject rowObject, Settings settings, Program data, ServiceProvider sp) throws IllegalArgumentException {
            Function function = rowObject.getFunction();
            if (function == null) {
                return null;
            }
            return function.getName();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }

        private class FunctionNameRenderer
        extends AbstractGhidraColumnRenderer<String> {
            private FunctionNameRenderer() {
            }

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Component cellRenderer = super.getTableCellRendererComponent(data);
                this.setBold();
                if (data.isSelected()) {
                    return cellRenderer;
                }
                FunctionRowObject rowObject = (FunctionRowObject)data.getRowObject();
                Function function = rowObject.getFunction();
                Symbol symbol = function.getSymbol();
                Color color = NameTableColumn.this.inspector.getColor(symbol);
                cellRenderer.setForeground(color);
                return cellRenderer;
            }

            public String getFilterString(String t, Settings settings) {
                return t;
            }
        }
    }

    private class FunctionKeyIterator
    implements LongIterator {
        private FunctionIterator itr;

        FunctionKeyIterator(FunctionTableModel functionTableModel, FunctionManager functionMgr) {
            this.itr = functionMgr.getFunctions(true);
        }

        public boolean hasNext() {
            if (this.itr == null) {
                return false;
            }
            return this.itr.hasNext();
        }

        public long next() {
            Function function = (Function)this.itr.next();
            return function.getID();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public long previous() {
            throw new UnsupportedOperationException();
        }
    }
}

