/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import java.util.NoSuchElementException;

public class PointerTypeSettingsDefinition
implements EnumSettingsDefinition,
TypeDefSettingsDefinition {
    private static final String POINTER_TYPE_SETTINGS_NAME = "ptr_type";
    private static final String DESCRIPTION = "Specifies the pointer type which affects interpretation of offset";
    private static final String DISPLAY_NAME = "Pointer Type";
    private static final String[] choices = new String[]{"default", "image-base-relative", "relative", "file-offset"};
    public static final PointerTypeSettingsDefinition DEF = new PointerTypeSettingsDefinition();

    private PointerTypeSettingsDefinition() {
    }

    public PointerType getType(Settings settings) {
        if (settings == null) {
            return PointerType.DEFAULT;
        }
        Long value = settings.getLong(POINTER_TYPE_SETTINGS_NAME);
        if (value == null) {
            return PointerType.DEFAULT;
        }
        int type = (int)value.longValue();
        try {
            return PointerType.valueOf(type);
        }
        catch (NoSuchElementException e) {
            return PointerType.DEFAULT;
        }
    }

    public int getChoice(Settings settings) {
        return this.getType((Settings)settings).value;
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setChoice(Settings settings, int value) {
        try {
            this.setType(settings, PointerType.valueOf(value));
        }
        catch (NoSuchElementException e) {
            settings.clearSetting(POINTER_TYPE_SETTINGS_NAME);
        }
    }

    public void setType(Settings settings, PointerType type) {
        if (type == PointerType.DEFAULT) {
            settings.clearSetting(POINTER_TYPE_SETTINGS_NAME);
        } else {
            settings.setLong(POINTER_TYPE_SETTINGS_NAME, (long)type.value);
        }
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public String getStorageKey() {
        return POINTER_TYPE_SETTINGS_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(POINTER_TYPE_SETTINGS_NAME);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(POINTER_TYPE_SETTINGS_NAME);
        if (l == null) {
            destSettings.clearSetting(POINTER_TYPE_SETTINGS_NAME);
        } else {
            destSettings.setLong(POINTER_TYPE_SETTINGS_NAME, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(POINTER_TYPE_SETTINGS_NAME) != null;
    }

    public String getDisplayChoice(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setDisplayChoice(Settings settings, String choice) {
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(choice)) continue;
            this.setChoice(settings, i);
            break;
        }
    }

    @Override
    public String getAttributeSpecification(Settings settings) {
        int choice = this.getChoice(settings);
        if (choice != 0) {
            return choices[choice];
        }
        return null;
    }
}

