/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class RenameUnionFieldTask
extends RenameTask {
    private Composite composite;
    private int ordinal;

    public RenameUnionFieldTask(PluginTool tool, Program program, DecompilerProvider provider, ClangToken token, Composite composite, int ordinal) {
        super(tool, program, provider, token, token.getText());
        this.composite = composite;
        this.ordinal = ordinal;
    }

    @Override
    public void commit() throws DuplicateNameException, InvalidInputException {
        DataTypeComponent dtc = this.composite.getComponent(this.ordinal);
        dtc.setFieldName(this.newName);
    }

    @Override
    public String getTransactionName() {
        return "Rename Union Field";
    }

    @Override
    public boolean isValid(String newNm) {
        DataTypeComponent[] comp;
        this.newName = newNm;
        for (DataTypeComponent element : comp = this.composite.getDefinedComponents()) {
            String fieldname = element.getFieldName();
            if (fieldname == null || !fieldname.equals(this.newName)) continue;
            this.errorMsg = "Duplicate Field Name";
            return false;
        }
        return true;
    }
}

