/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.hash.HashUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class MD5Utilities {
    public static final int SALT_LENGTH = 4;
    public static final int UNSALTED_HASH_LENGTH = 32;
    public static final int SALTED_HASH_LENGTH = 36;

    public static char[] getMD5Hash(char[] msg) {
        return HashUtilities.getSaltedHash((String)HashUtilities.MD5_ALGORITHM, (char[])new char[0], (char[])msg);
    }

    public static char[] getSaltedMD5Hash(char[] salt, char[] msg) {
        return HashUtilities.getSaltedHash((String)HashUtilities.MD5_ALGORITHM, (char[])salt, (char[])msg);
    }

    public static char[] getSaltedMD5Hash(char[] msg) {
        return HashUtilities.getSaltedHash((String)HashUtilities.MD5_ALGORITHM, (char[])msg);
    }

    public static String getMD5Hash(InputStream in) throws IOException {
        return HashUtilities.getHash((String)HashUtilities.MD5_ALGORITHM, (InputStream)in);
    }

    public static String getMD5Hash(File file) throws IOException {
        return HashUtilities.getHash((String)HashUtilities.MD5_ALGORITHM, (File)file);
    }

    public static String getMD5Hash(List<String> values) {
        return HashUtilities.getHash((String)HashUtilities.MD5_ALGORITHM, values);
    }

    public static char[] hexDump(byte[] data) {
        return HashUtilities.hexDump((byte[])data);
    }
}

