/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh.vector;

import generic.hash.SimpleCRC32;
import generic.lsh.vector.HashEntry;
import generic.lsh.vector.IDFLookup;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.VectorCompare;
import generic.lsh.vector.WeightFactory;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;

public class LSHCosineVector
implements LSHVector {
    private static final HashEntry[] EMPTY = new HashEntry[0];
    private HashEntry[] hash = EMPTY;
    private double length;
    private int hashcount;

    public LSHCosineVector() {
        this.length = 0.0;
        this.hashcount = 0;
    }

    public LSHCosineVector(int[] feature, WeightFactory wfactory, IDFLookup idflookup) {
        this.installFeatures(feature, wfactory, idflookup);
        this.calcLength();
    }

    public int hashCode() {
        return (int)this.calcUniqueHash();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LSHCosineVector)) {
            return false;
        }
        LSHCosineVector other = (LSHCosineVector)obj;
        return Arrays.equals(this.hash, other.hash);
    }

    public void setHashEntries(HashEntry[] entries) {
        this.hash = entries;
        this.calcLength();
    }

    private void calcLength() {
        this.length = 0.0;
        this.hashcount = 0;
        for (int i = 0; i < this.hash.length; ++i) {
            if (this.hash[i] == null) continue;
            double coeff = this.hash[i].getCoeff();
            this.length += coeff * coeff;
            this.hashcount += this.hash[i].getTF();
        }
        this.length = Math.sqrt(this.length);
    }

    private void installFeatures(int[] feature, WeightFactory wfactory, IDFLookup idflookup) {
        int idf;
        int i;
        if (feature.length == 0) {
            return;
        }
        int lasthash = feature[0];
        int count = 1;
        int sz = 1;
        for (i = 0; i < feature.length; ++i) {
            if (feature[i] == lasthash) continue;
            lasthash = feature[i];
            ++sz;
        }
        this.hash = new HashEntry[sz];
        lasthash = feature[0];
        sz = 0;
        if (!idflookup.empty()) {
            idf = idflookup.getCount(lasthash);
            for (i = 1; i < feature.length; ++i) {
                int featurei = feature[i];
                if (featurei != lasthash) {
                    this.hash[sz] = new HashEntry(lasthash, count, idf, wfactory);
                    ++sz;
                    lasthash = featurei;
                    count = 1;
                    idf = idflookup.getCount(lasthash);
                    continue;
                }
                ++count;
            }
        } else {
            idf = 0;
            for (i = 1; i < feature.length; ++i) {
                int featurei = feature[i];
                if (featurei != lasthash) {
                    this.hash[sz] = new HashEntry(lasthash, count, idf, wfactory);
                    ++sz;
                    lasthash = featurei;
                    count = 1;
                    continue;
                }
                ++count;
            }
        }
        this.hash[sz] = new HashEntry(lasthash, count, idf, wfactory);
    }

    @Override
    public int numEntries() {
        return this.hash.length;
    }

    @Override
    public HashEntry getEntry(int i) {
        return this.hash[i];
    }

    @Override
    public HashEntry[] getEntries() {
        return this.hash;
    }

    @Override
    public double compare(LSHVector op2, VectorCompare data) {
        LSHCosineVector op = (LSHCosineVector)op2;
        int iter = 0;
        int enditer = this.hash.length;
        int iter2 = 0;
        int enditer2 = op.hash.length;
        double res = 0.0;
        int intersectcount = 0;
        if (iter != enditer && iter2 != enditer2) {
            int hash1 = this.hash[iter].getHash();
            int hash2 = op.hash[iter2].getHash();
            while (true) {
                if (hash1 == hash2) {
                    short t2;
                    short t1 = this.hash[iter].getTF();
                    if (t1 < (t2 = op.hash[iter2].getTF())) {
                        double w1 = this.hash[iter].getCoeff();
                        res += w1 * w1;
                        intersectcount += t1;
                    } else {
                        double w2 = op.hash[iter2].getCoeff();
                        res += w2 * w2;
                        intersectcount += t2;
                    }
                    if (++iter == enditer || ++iter2 == enditer2) break;
                    hash1 = this.hash[iter].getHash();
                    hash2 = op.hash[iter2].getHash();
                    continue;
                }
                if (hash1 + Integer.MIN_VALUE < hash2 + Integer.MIN_VALUE) {
                    if (++iter == enditer) break;
                    hash1 = this.hash[iter].getHash();
                    continue;
                }
                if (++iter2 == enditer2) break;
                hash2 = op.hash[iter2].getHash();
            }
            data.dotproduct = res;
            res /= this.length * op.length;
        } else {
            data.dotproduct = res;
        }
        data.intersectcount = intersectcount;
        data.acount = this.hashcount;
        data.bcount = op.hashcount;
        return res;
    }

    @Override
    public void compareCounts(LSHVector op2, VectorCompare data) {
        LSHCosineVector op = (LSHCosineVector)op2;
        int iter = 0;
        int enditer = this.hash.length;
        int iter2 = 0;
        int enditer2 = op.hash.length;
        int intersectcount = 0;
        if (iter != enditer && iter2 != enditer2) {
            int hash1 = this.hash[iter].getHash();
            int hash2 = op.hash[iter2].getHash();
            while (true) {
                if (hash1 == hash2) {
                    short t2;
                    short t1 = this.hash[iter].getTF();
                    intersectcount += t1 < (t2 = op.hash[iter2].getTF()) ? t1 : t2;
                    if (++iter == enditer || ++iter2 == enditer2) break;
                    hash1 = this.hash[iter].getHash();
                    hash2 = op.hash[iter2].getHash();
                    continue;
                }
                if (hash1 + Integer.MIN_VALUE < hash2 + Integer.MIN_VALUE) {
                    if (++iter == enditer) break;
                    hash1 = this.hash[iter].getHash();
                    continue;
                }
                if (++iter2 == enditer2) break;
                hash2 = op.hash[iter2].getHash();
            }
        }
        data.intersectcount = intersectcount;
        data.acount = this.hashcount;
        data.bcount = op.hashcount;
    }

    private void writeOnlyList(ArrayList<HashEntry> only, StringBuilder buf) {
        for (int i = 0; i < only.size(); ++i) {
            HashEntry entry = only.get(i);
            buf.append(Integer.toHexString(entry.getHash()));
            buf.append(' ').append(entry.getTF());
            buf.append(' ').append(entry.getCoeff());
            buf.append('\n');
        }
    }

    private void writeBothList(ArrayList<HashEntry> both, StringBuilder buf) {
        for (int i = 0; i < both.size(); i += 2) {
            HashEntry entry1 = both.get(i);
            HashEntry entry2 = both.get(i + 1);
            buf.append(Integer.toHexString(entry1.getHash()));
            buf.append(" (").append(entry1.getTF()).append(',').append(entry2.getTF()).append(") (");
            buf.append(entry1.getCoeff()).append(',').append(entry2.getCoeff()).append(")\n");
        }
    }

    @Override
    public double compareDetail(LSHVector op2, StringBuilder buf) {
        LSHCosineVector op = (LSHCosineVector)op2;
        ArrayList<HashEntry> a_only = new ArrayList<HashEntry>();
        ArrayList<HashEntry> b_only = new ArrayList<HashEntry>();
        ArrayList<HashEntry> ab_both = new ArrayList<HashEntry>();
        buf.append("lena=").append(this.getLength()).append('\n');
        buf.append("lenb=").append(op2.getLength()).append('\n');
        int iter = 0;
        int enditer = this.hash.length;
        int iter2 = 0;
        int enditer2 = op.hash.length;
        double res = 0.0;
        int intersectcount = 0;
        if (iter != enditer && iter2 != enditer2) {
            int hash1 = this.hash[iter].getHash();
            int hash2 = op.hash[iter2].getHash();
            while (true) {
                if (hash1 == hash2) {
                    ab_both.add(this.hash[iter]);
                    ab_both.add(op.hash[iter2]);
                    short t1 = this.hash[iter].getTF();
                    short t2 = op.hash[iter2].getTF();
                    if (t1 < t2) {
                        double w1 = this.hash[iter].getCoeff();
                        res += w1 * w1;
                        intersectcount += t1;
                    } else {
                        double w2 = op.hash[iter2].getCoeff();
                        res += w2 * w2;
                        intersectcount += t2;
                    }
                    if (++iter == enditer || ++iter2 == enditer2) break;
                    hash1 = this.hash[iter].getHash();
                    hash2 = op.hash[iter2].getHash();
                    continue;
                }
                if (hash1 + Integer.MIN_VALUE < hash2 + Integer.MIN_VALUE) {
                    a_only.add(this.hash[iter]);
                    if (++iter == enditer) break;
                    hash1 = this.hash[iter].getHash();
                    continue;
                }
                b_only.add(op.hash[iter2]);
                if (++iter2 == enditer2) break;
                hash2 = op.hash[iter2].getHash();
            }
            buf.append("dotproduct=").append(res).append('\n');
            buf.append("intersect=").append(intersectcount).append('\n');
            res /= this.length * op.length;
        }
        while (iter != enditer) {
            a_only.add(this.hash[iter]);
            ++iter;
        }
        while (iter2 != enditer2) {
            b_only.add(op.hash[iter2]);
            ++iter2;
        }
        this.writeOnlyList(a_only, buf);
        buf.append('\n');
        this.writeBothList(ab_both, buf);
        buf.append('\n');
        this.writeOnlyList(b_only, buf);
        return res;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void restoreXml(XmlPullParser parser, WeightFactory wfactory, IDFLookup idflookup) {
        parser.start(new String[]{"lshcosine"});
        ArrayList<HashEntry> hashlist = new ArrayList<HashEntry>();
        if (idflookup.empty()) {
            while (parser.peek().isStart()) {
                HashEntry entry = new HashEntry();
                hashlist.add(entry);
                entry.restoreXml(parser, wfactory);
            }
        } else {
            while (parser.peek().isStart()) {
                HashEntry entry = new HashEntry();
                hashlist.add(entry);
                entry.restoreXml(parser, wfactory, idflookup);
            }
        }
        parser.end();
        this.hash = new HashEntry[hashlist.size()];
        hashlist.toArray(this.hash);
        this.calcLength();
    }

    @Override
    public void restoreSQL(String sql, WeightFactory wfactory, IDFLookup idflookup) throws IOException {
        ArrayList<HashEntry> hashlist = new ArrayList<HashEntry>();
        if (sql.length() < 2) {
            throw new IOException("Empty lshvector SQL");
        }
        if (sql.charAt(0) != '(') {
            throw new IOException("Missing '(' while parsing lshvector SQL");
        }
        int start = 1;
        char tok = sql.charAt(1);
        if (tok != ')') {
            do {
                HashEntry entry = new HashEntry();
                hashlist.add(entry);
                start = entry.restoreSQL(sql, start, wfactory, idflookup);
                tok = sql.charAt(start);
                ++start;
            } while (tok == ',');
        }
        if (tok != ')') {
            throw new IOException("Missing ')' while parsing lshvector SQL");
        }
        this.hash = new HashEntry[hashlist.size()];
        hashlist.toArray(this.hash);
        this.calcLength();
    }

    @Override
    public void restoreBase64(Reader input, char[] buffer, WeightFactory wfactory, IDFLookup idflookup, int[] decode) throws IOException {
        int returned;
        ArrayList<HashEntry> hashlist = new ArrayList<HashEntry>();
        do {
            returned = input.read(buffer, 0, 112);
            for (int i = 0; i < returned; i += 7) {
                HashEntry entry = new HashEntry();
                if (!entry.restoreBase64(buffer, i, decode, wfactory, idflookup)) {
                    throw new IOException("Bad base64 encoding of LSHCosine vector");
                }
                hashlist.add(entry);
            }
        } while (returned == 112);
        this.hash = new HashEntry[hashlist.size()];
        hashlist.toArray(this.hash);
        this.calcLength();
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<lshcosine>\n");
        fwrite.append(buf.toString());
        for (int i = 0; i < this.hash.length; ++i) {
            this.hash[i].saveXml(fwrite);
        }
        fwrite.append("</lshcosine>\n");
    }

    @Override
    public String saveSQL() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (this.hash.length == 0) {
            buf.append(')');
            return buf.toString();
        }
        this.hash[0].saveSQL(buf);
        for (int i = 1; i < this.hash.length; ++i) {
            buf.append(',');
            this.hash[i].saveSQL(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void saveBase64(StringBuilder buffer, char[] encoder) {
        if (this.hash.length == 0) {
            return;
        }
        char[] charBuf = new char[70];
        int i = 0;
        int charpos = 0;
        while (true) {
            this.hash[i].saveBase64(charBuf, charpos, encoder);
            charpos += 7;
            if (++i >= this.hash.length) break;
            if (charpos != 70) continue;
            buffer.append(charBuf);
            charpos = 0;
        }
        if (charpos != 0) {
            buffer.append(charBuf, 0, charpos);
        }
    }

    @Override
    public long calcUniqueHash() {
        int reg1 = 315593643;
        int reg2 = -298208554;
        for (int i = 0; i < this.hash.length; ++i) {
            HashEntry entry = this.hash[i];
            short curtf = entry.getTF();
            int curhash = entry.getHash();
            int oldreg1 = reg1;
            reg1 = SimpleCRC32.hashOneByte(reg1, curtf);
            reg1 = SimpleCRC32.hashOneByte(reg1, curhash);
            reg1 = SimpleCRC32.hashOneByte(reg1, reg2 >>> 24);
            reg2 = SimpleCRC32.hashOneByte(reg2, oldreg1 >>> 24);
            reg2 = SimpleCRC32.hashOneByte(reg2, curhash >>> 8);
            reg2 = SimpleCRC32.hashOneByte(reg2, curhash >>> 16);
            reg2 = SimpleCRC32.hashOneByte(reg2, curhash >>> 24);
        }
        long res = reg1;
        long res2 = reg2;
        res2 <<= 32;
        res <<= 32;
        return res |= (res2 >>>= 32);
    }
}

