/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.eval;

import ghidra.pcode.eval.AbstractVarnodeEvaluator;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.Map;

public abstract class ArithmeticVarnodeEvaluator<T>
extends AbstractVarnodeEvaluator<T> {
    private final PcodeArithmetic<T> arithmetic;

    public static <T> T catenate(PcodeArithmetic<T> arithmetic, int sizeTotal, T upper, T lower, int sizeLower) {
        Object zext = arithmetic.unaryOp(17, sizeTotal, sizeLower, lower);
        Object shift = arithmetic.binaryOp(29, sizeTotal, sizeTotal, upper, 4, arithmetic.fromConst(sizeLower * 8, 4));
        return (T)arithmetic.binaryOp(28, sizeTotal, sizeTotal, shift, sizeTotal, zext);
    }

    public ArithmeticVarnodeEvaluator(PcodeArithmetic<T> arithmetic) {
        this.arithmetic = arithmetic;
    }

    @Override
    protected T catenate(int sizeTotal, T upper, T lower, int sizeLower) {
        return ArithmeticVarnodeEvaluator.catenate(this.arithmetic, sizeTotal, upper, lower, sizeLower);
    }

    @Override
    public T evaluateStorage(Program program, VariableStorage storage) {
        return (T)this.evaluateStorage(program, storage, this.arithmetic.fromConst(0, storage.size()));
    }

    @Override
    protected T evaluateConstant(long value, int size) {
        return (T)this.arithmetic.fromConst(value, size);
    }

    @Override
    protected T evaluateAbstract(Program program, AddressSpace space, T offset, int size, Map<Varnode, T> already) {
        long concrete = this.arithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
        Address address = space.getAddress(concrete);
        return this.evaluateMemory(this.translateMemory(program, address), size);
    }

    @Override
    protected T evaluateUnaryOp(Program program, PcodeOp op, UnaryOpBehavior unOp, Map<Varnode, T> already) {
        Varnode in1Var = op.getInput(0);
        T in1 = this.evaluateVarnode(program, in1Var, already);
        return (T)this.arithmetic.unaryOp(op, in1);
    }

    @Override
    protected T evaluateBinaryOp(Program program, PcodeOp op, BinaryOpBehavior binOp, Map<Varnode, T> already) {
        Varnode in1Var = op.getInput(0);
        Varnode in2Var = op.getInput(1);
        T in1 = this.evaluateVarnode(program, in1Var, already);
        T in2 = this.evaluateVarnode(program, in2Var, already);
        return (T)this.arithmetic.binaryOp(op, in1, in2);
    }

    @Override
    protected T evaluatePtrAdd(Program program, PcodeOp op, Map<Varnode, T> already) {
        Varnode baseVar = op.getInput(0);
        Varnode indexVar = op.getInput(1);
        int size = this.getIntConst(op.getInput(2));
        Varnode outVar = op.getOutput();
        T base = this.evaluateVarnode(program, baseVar, already);
        T index = this.evaluateVarnode(program, indexVar, already);
        return (T)this.arithmetic.ptrAdd(outVar.getSize(), baseVar.getSize(), base, indexVar.getSize(), index, size);
    }

    @Override
    protected T evaluatePtrSub(Program program, PcodeOp op, Map<Varnode, T> already) {
        Varnode baseVar = op.getInput(0);
        Varnode offsetVar = op.getInput(1);
        Varnode outVar = op.getOutput();
        T base = this.evaluateVarnode(program, baseVar, already);
        T offset = this.evaluateVarnode(program, offsetVar, already);
        return (T)this.arithmetic.ptrSub(outVar.getSize(), baseVar.getSize(), base, offsetVar.getSize(), offset);
    }

    @Override
    protected T evaluateLoad(Program program, PcodeOp op, Map<Varnode, T> already) {
        int spaceID = this.getIntConst(op.getInput(0));
        AddressSpace space = program.getAddressFactory().getAddressSpace(spaceID);
        Varnode inOffset = op.getInput(1);
        T offset = this.evaluateVarnode(program, inOffset, already);
        Varnode outVar = op.getOutput();
        T out = this.evaluateAbstract(program, space, offset, outVar.getSize(), already);
        return (T)this.arithmetic.modAfterLoad(op, space, offset, out);
    }
}

