import { PluginMetadata } from '@/plugins/plugin'
import { playerAgent } from '@/components/video/player-agent'
import type { KeyBindingAction } from '../../../components/utils/keymap/bindings'

export const plugin: PluginMetadata = {
  name: 'keymap.actions.toggleSubtitle',
  displayName: '快捷键扩展 - 开关 CC 字幕',
  description: '在快捷键的动作列表里添加一个 "开关 CC 字幕".',
  setup: ({ addData }) => {
    addData('keymap.actions', (actions: Record<string, KeyBindingAction>) => {
      actions.toggleSubtitle = {
        displayName: '开关 CC 字幕',
        run: async () => {
          return playerAgent.toggleSubtitle()
        },
      }
    })
    addData(
      'keymap.presets',
      (
        presetBase: Record<string, string>,
        builtInPresets: Record<string, Record<string, string>>,
      ) => {
        presetBase.toggleSubtitle = 'shift c'
        builtInPresets.YouTube.toggleSubtitle = 'c'
        builtInPresets.YouTube.coin = ''
        builtInPresets.PotPlayer.toggleSubtitle = 'alt h'
      },
    )
  },
}
