// ==UserScript==
// @name         Bilibili Evolved (Offline)
// @version      1246.26
// @description  Bilibili Evolved 的离线版, 所有功能都已内置于脚本中.
// @author       Grant Howard, Coulomb-G
// @copyright    2021, Grant Howard (https://github.com/the1812) & Coulomb-G (https://github.com/Coulomb-G)
// @license      MIT
// @match        *://*.bilibili.com/*
// @exclude      *://*.bilibili.com/*/mobile.html
// @exclude      *://*.bilibili.com/api/*
// @exclude      *://api.bilibili.com/*
// @exclude      *://api.*.bilibili.com/*
// @exclude      *://live.bilibili.com/h5/*
// @exclude      *://live.bilibili.com/*/h5/*
// @exclude      *://m.bilibili.com/*
// @exclude      *://mall.bilibili.com/*
// @exclude      *://member.bilibili.com/studio/bs-editor/*
// @exclude      *://www.bilibili.com/h5/*
// @exclude      *://www.bilibili.com/*/h5/*
// @exclude      *://bbq.bilibili.com/*
// @run-at       document-start
// @updateURL    https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@master/bilibili-evolved.offline.user.js
// @downloadURL  https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@master/bilibili-evolved.offline.user.js
// @supportURL   https://github.com/the1812/Bilibili-Evolved/issues
// @homepage     https://github.com/the1812/Bilibili-Evolved
// @grant        unsafeWindow
// @grant        GM_getValue
// @grant        GM_setValue
// @grant        GM_setClipboard
// @grant        GM_info
// @grant        GM_xmlhttpRequest
// @grant        GM.getValue
// @grant        GM.setValue
// @grant        GM.setClipboard
// @grant        GM.info
// @grant        GM.xmlHttpRequest
// @connect      raw.githubusercontent.com
// @connect      cdn.jsdelivr.net
// @connect      cn.bing.com
// @connect      www.bing.com
// @connect      translate.google.cn
// @connect      translate.google.com
// @connect      *
// @require      https://cdn.jsdelivr.net/npm/jquery@3.4.0/dist/jquery.min.js
// @require      https://cdn.jsdelivr.net/npm/lodash@4.17.15/lodash.min.js
// @require      https://cdn.jsdelivr.net/npm/jszip@3.1.5/dist/jszip.min.js
// @require      https://cdn.jsdelivr.net/npm/vue@2.6.10/dist/vue.js
// @require      https://cdn.jsdelivr.net/npm/vuex@3.1.2/dist/vuex.js
// @icon         https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@master/images/logo-small.png
// @icon64       https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@master/images/logo.png
// ==/UserScript==
/* eslint-disable */ /* spell-checker: disable */
// @[ You can find all source codes in GitHub repo ]
Vue.config.productionTip=false;Vue.config.devtools=false;if(typeof GM=="undefined"){this.GM={}}Object.entries({log:console.log.bind(console),info:GM_info}).forEach((([e,t])=>{if(t&&typeof GM[e]=="undefined"){GM[e]=t}}));Object.entries({GM_getValue:"getValue",GM_setClipboard:"setClipboard",GM_setValue:"setValue",GM_xmlhttpRequest:"xmlHttpRequest"}).forEach((([e,t])=>{let i=this[e];if(i&&typeof GM[t]=="undefined"){GM[t]=function(...e){return new Promise(((t,o)=>{try{t(i.apply(this,e))}catch(e){o(e)}}))}}}));window.EventTarget=class e{constructor(){this.listeners={}}addEventListener(e,t){if(!(e in this.listeners)){this.listeners[e]=[]}this.listeners[e].push(t)}removeEventListener(e,t){if(!(e in this.listeners)){return}let i=this.listeners[e];for(let e=0,o=i.length;e<o;e++){if(i[e]===t){i.splice(e,1);return}}}dispatchEvent(e){if(!(e.type in this.listeners)){return true}let t=this.listeners[e.type].slice();for(let i=0,o=t.length;i<o;i++){t[i].call(this,e)}return!e.defaultPrevented}};const headLoaded=(e=(()=>{}))=>new Promise((t=>{if(document.head!==null){t(e())}else{const i=new MutationObserver((()=>{if(document.head!==null){i.disconnect();t(e())}}));i.observe(document.documentElement,{childList:true,subtree:false})}}));function logError(e,t){let i=e;if(typeof e==="object"&&"stack"in e){if(settings.toastInternalError){i=`${e.message}\n${e.stack}`}else{i=e.message}}Toast.error(i,"错误",t);console.error(e)}function raiseEvent(e,t){const i=document.createEvent("HTMLEvents");i.initEvent(t,true,true);e.dispatchEvent(i)}async function loadLazyPanel(e){await SpinQuery.unsafeJquery();const t=await SpinQuery.any((()=>unsafeWindow.$(e)));if(!t){throw new Error(`Panel not found: ${e}`)}t.mouseover();return new Promise((e=>{setTimeout((()=>{t.mouseout();e()}),310)}))}async function loadLazyPlayerSettingsPanel(e,t){const i=document.createElement("style");i.innerText=`${t} { display: none !important; }`;document.body.insertAdjacentElement("beforeend",i);await loadLazyPanel(e);setTimeout((()=>i.remove()),300);return dq(t)}async function loadDanmakuSettingsPanel(){return await loadLazyPlayerSettingsPanel(".bilibili-player-video-danmaku-setting",".bilibili-player-video-danmaku-setting-wrap")}async function loadSubtitleSettingsPanel(){return await loadLazyPlayerSettingsPanel(".bilibili-player-video-btn-subtitle",".bilibili-player-video-subtitle-setting-wrap")}function contentLoaded(e){if(/complete|interactive|loaded/.test(document.readyState)){e()}else{document.addEventListener("DOMContentLoaded",(()=>e()))}}function fullyLoaded(e){if(document.readyState==="complete"){e()}else{unsafeWindow.addEventListener("load",(()=>e()))}}function fixed(e,t=1){const i=e.toString();const o=i.indexOf(".");if(o!==-1){if(i.length-o>t+1){return i.substring(0,o+t+1)}else{return i}}else{return i+".0"}}function isEmbeddedPlayer(){return location.host==="player.bilibili.com"||document.URL.startsWith("https://www.bilibili.com/html/player.html")}function isIframe(){return document.body&&unsafeWindow.parent.window!==unsafeWindow}const languageNameToCode={"日本語":"ja-JP",English:"en-US",Deutsch:"de-DE"};const languageCodeToName={"ja-JP":"日本語","en-US":"English","de-DE":"Deutsch"};function getI18nKey(){return settings.i18n?languageNameToCode[settings.i18nLanguage]:"zh-CN"}const altVideoFilter=e=>{const t={video:", bwp-video",".bilibili-player-video video":", .bilibili-player-video bwp-video"};const i=t[e];if(i){return e+i}return e};const dq=(e,t)=>{if(!t){return document.querySelector(altVideoFilter(e))}return e.querySelector(t)};const dqa=(e,t)=>{if(!t){return[...document.querySelectorAll(altVideoFilter(e))]}return[...e.querySelectorAll(t)]};const UserAgent=`Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:78.0) Gecko/20100101 Firefox/78.0`;const EmptyImageUrl='data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1"></svg>';const ascendingSort=e=>(t,i)=>e(t)-e(i);const descendingSort=e=>(t,i)=>e(i)-e(t);const formatFileSize=(e,t=1)=>{const i=["B","KB","MB","GB","TB","PB","EB","ZB","YB"];let o=e;let a=0;while(o>=1024){o/=1024;a++}return`${Math.round(o*10**t)/10**t}${i[a]}`};const formatDuration=(e,t=0)=>{const i=(e%60).toFixed(t);const o=(Math.trunc(e/60)%60).toString();const a=Math.trunc(e/3600).toString();if(a==="0"){return`${o.padStart(2,"0")}:${i.padStart(2,"0")}`}return`${a}:${o.padStart(2,"0")}:${i.padStart(2,"0")}`};const getDpiSourceSet=(e,t,i="")=>{const o=[1,1.25,1.5,1.75,2,2.25,2.5,2.75,3,3.25,3.5,3.75,4];let a=i||e.substring(e.lastIndexOf(".")+1);if(a.startsWith(".")){a=a.substring(1)}return o.map((i=>{if(typeof t==="object"){if("width"in t&&"height"in t){return`${e}@${Math.trunc(t.width*i)}w_${Math.trunc(t.height*i)}h.${a} ${i}x`}else if("width"in t){return`${e}@${Math.trunc(t.width*i)}w.${a} ${i}x`}else if("height"in t){return`${e}@${Math.trunc(t.height*i)}h.${a} ${i}x`}}else{return`${e}@${Math.trunc(t*i)}w_${Math.trunc(t*i)}h.${a} ${i}x`}})).join(",")};const isOffline=()=>typeof offlineData!=="undefined";const getCookieValue=e=>document.cookie.replace(new RegExp(`(?:(?:^|.*;\\s*)${e}\\s*\\=\\s*([^;]*).*$)|^.*$`),"$1");const getUID=()=>getCookieValue("DedeUserID");const scriptVersion=(()=>{const e=GM.info.script.name.match(/Evolved \((.*)\)/);return e?e[1]:"Stable"})();const getCsrf=()=>getCookieValue("bili_jct");const formatCount=e=>{if(typeof e==="string"){e=parseInt(e)}if(e>1e8){return Math.round(e/1e7)/10+"亿"}if(e>1e4){return Math.round(e/1e3)/10+"万"}return e+""};const escapeFilename=(e,t="")=>e.replace(/[\/\\:\*\?"<>\|]/g,t);function html(e,...t){return[...e].reduce(((e,i,o)=>{const a=t[o];return e+i+(a===undefined?"":a)}),"")}const dashExtensions=[".mp4",".m4a"];const dashFragmentExtension="m4s";const videoCondition=async()=>{let e=await SpinQuery.select((()=>(unsafeWindow||window).cid));return Boolean(e)};const matchPattern=(e,t)=>{if(typeof t==="string"){return e.includes(t)}return t.test(e)};const playerReady=()=>Promise.reject("此函数已弃用, 请使用 src/utils/player-ready.ts");const formData=e=>Object.entries(e).map((([e,t])=>`${e}=${t}`)).join("&");const retrieveImageUrl=e=>{if(!(e instanceof HTMLElement)){return null}let t;if(e.hasAttribute("data-src")){t=e.getAttribute("data-src")}else if(e instanceof HTMLImageElement){t=e.src}else{const i=e.style.backgroundImage;if(!i){return null}const o=i.match(/url\("(.+)"\)/);if(!o){return null}t=o[1]}const i=t.match(/^(.+)(\..+?)(@.+)$/);if(!i){return null}return{url:i[1]+i[2],extension:i[2]}};const isTyping=()=>{const e=document.activeElement;if(!e){return false}if(e.hasAttribute("contenteditable")){return true}return["input","textarea"].includes(e.nodeName.toLowerCase())};const getAid=(e=unsafeWindow.aid)=>{if(!e){throw new Error("aid is unknown")}return e};const waitForForeground=e=>{const t=()=>{if(document.visibilityState==="visible"){e();document.removeEventListener("visibilitychange",t);return true}return false};const i=t();if(i){return}document.addEventListener("visibilitychange",t)};const customNavbarDefaultOrders={blank1:0,logo:1,category:2,rankingLink:3,drawingLink:4,bangumiLink:5,musicLink:6,gamesIframe:7,livesIframe:8,matchLink:9,shopLink:10,mangaIframe:11,blank2:12,search:13,blank3:14,userInfo:15,messages:16,activities:17,bangumi:18,watchlaterList:19,favoritesList:20,historyList:21,upload:22,darkMode:23};const simpleHomeCategoryDefaultOrders={anime:0,bangumi:1,china:2,music:3,dance:4,game:5,knowledge:6,tech:7,life:8,food:9,animal:10,kichiku:11,fashion:12,information:13,entertainment:14,movie:15,tv:16,film:17,documentary:18};const aria2RpcDefaultOption={secretKey:"",dir:"",host:"127.0.0.1",port:"6800",method:"get",other:""};const settings={useDarkStyle:false,hideBanner:false,expandDanmakuList:true,expandDanmakuListIgnoreMediaList:true,expandDescription:true,watchLaterRedirect:true,touchNavBar:false,touchVideoPlayer:false,customControlBackgroundOpacity:.64,customControlBackground:false,darkScheduleStart:"18:00",darkScheduleEnd:"6:00",darkSchedule:false,toast:true,fullTweetsTitle:true,fullPageTitle:false,removeVideoTopMask:false,removeLiveWatermark:true,harunaScale:true,removeAds:true,showBlockedAdsTip:false,hideTopSearch:false,touchVideoPlayerDoubleTapControl:false,customStyleColor:"#00A0D8",blurBackgroundOpacity:.382,useDefaultPlayerMode:false,applyPlayerModeOnPlay:true,defaultPlayerMode:"常规",defaultVideoQuality:"自动",defaultPlayerLayout:"新版",defaultBangumiLayout:"新版",skipChargeList:false,comboLike:false,autoLightOff:false,useCache:true,allowJumpContinue:false,airborne:true,deadVideoTitleProvider:"稍后再看",useBiliplusRedirect:false,biliplusRedirect:false,framePlayback:true,useCommentStyle:true,imageResolution:false,imageResolutionScale:"auto",toastInternalError:false,i18n:false,i18nLanguage:"日本語",playerFocus:false,playerFocusOffset:-10,simplifyLiveroom:false,simplifyLiveroomSettings:{vip:true,fansMedal:true,title:true,userLevel:true,guard:true,emoticons:true,systemMessage:true,welcomeMessage:true,giftMessage:true,guardPurchase:true,giftPanel:true,headerPanel:false,kanban:true,userEffect:true,eventsBanner:false,rankList:false,popup:false,pk:false,topRank:true,skin:false},customNavbar:true,customNavbarFill:false,customNavbarTransparent:true,customNavbarShadow:true,customNavbarBlur:false,customNavbarBlurOpacity:.7,customNavbarOrder:{...customNavbarDefaultOrders},customNavbarHidden:["blank1","drawingLink","musicLink","gamesIframe","match","darkMode"],customNavbarBoundsPadding:10,customNavbarGlobalFixed:false,customNavbarShowDeadVideos:false,playerShadow:false,narrowDanmaku:true,outerWatchlater:true,videoScreenshot:false,hideBangumiReviews:false,filenameFormat:"[title][ - ep]",batchFilenameFormat:"[n - ][ep]",sideBarOffset:0,noLiveAutoplay:false,hideHomeLive:false,noMiniVideoAutoplay:false,useDefaultVideoSpeed:false,defaultVideoSpeed:"1.0",foldComment:true,downloadVideoDefaultDanmaku:"无",downloadVideoDefaultSubtitle:"无",aria2RpcOption:{...aria2RpcDefaultOption},aria2RpcOptionSelectedProfile:"",aria2RpcOptionProfiles:[],searchHistory:[],autoDraw:false,keymap:false,keymapPreset:"Default",doubleClickFullscreen:false,doubleClickFullscreenPreventSingleClick:false,simplifyHome:false,simplifyHomeStyle:"清爽",simpleHomeCategoryOrders:{...simpleHomeCategoryDefaultOrders},simpleHomeBangumiLayout:"时间表",simpleHomeWheelScroll:true,simpleHomePersonalized:true,simpleHomeLayoutFill:true,minimalHomeSettings:{showSearch:true,backgroundImage:""},ajaxHook:false,scriptLoadingMode:"延后(自动)",scriptDownloadMode:"bundle",guiSettingsDockSide:"左侧",fullActivityContent:true,feedsFilter:false,feedsFilterPatterns:[],feedsFilterTypes:[],feedsSpecialFilterTypes:[],feedsFilterSideCards:[],activityImageSaver:false,scriptBlockPatterns:[],customNavbarSeasonLogo:false,selectableColumnText:true,downloadVideoFormat:"flv",downloadVideoDashCodec:"AVC/H.264",watchlaterExpireWarningDays:14,miniPlayerTouchMove:false,hideBangumiSponsors:false,hideRecommendLive:false,hideRelatedVideos:false,defaultMedalID:0,autoMatchMedal:false,customStyles:[],keymapJumpSeconds:85,urlParamsClean:true,collapseLiveSideBar:true,noDarkOnMember:true,feedsTranslateProvider:"Bing",feedsTranslateLanguage:"",downloadVideoQuality:120,defaultLiveQuality:"原画",foregroundColorMode:"自动",preserveEventBanner:false,bvidConvert:true,fixedSidebars:false,updateCdn:"jsDelivr",lastNewVersionCheck:0,newVersionCheckInterval:1e3*3600*6,useDarkStyleAsUserStyle:false,darkColorScheme:false,autoHideSideBar:false,livePip:true,extendFeedsLive:true,userImages:[],playerOnTop:false,restoreFloors:false,quickFavorite:false,quickFavoriteID:0,bilibiliSimpleNewHomeCompatible:false,disableFeedsDetails:true,elegantScrollbar:!navigator.platform.toLowerCase().includes("mac"),danmakuSendBar:false,watchLaterRedirectNavbar:true,watchLaterRedirectPage:true,showCoverBeforePlay:false,volumeOverdrive:false,seoJump:true,copyFeedsLink:false,copyCommentLink:false,unfoldFeeds:true,feedsImageExporter:false,columnImageExporter:false,downloadPackageEmitMode:"打包下载",preferAvUrl:false,homeHidden:false,homeHiddenItems:[],favoritesListCurrentSelect:"",rememberVideoSpeedList:{},rememberVideoSpeed:false,extendVideoSpeed:true,extendVideoSpeedList:[2.5,3],customKeyBindings:{},alwaysShowDuration:false,menuRepeatVideo:false,removeVideoPopup:true,removeGuidePopup:true,removeVotePopup:false,liveSpeedBoost:false,checkInCenter:false,fullscreenGiftBox:false,autoPlayControl:true,scrollOutPlayer:false,scrollOutPlayerTriggerPlace:"视频中间",scrollOutPlayerAutoPause:true,scrollOutPlayerAutoLightOn:true,disableDanmakuHighlights:false,disableUpDanmakuStyle:false,noNotifyV2:false,cache:{}};const fixedSettings={feedsTranslate:false,commentsTranslate:false,seedsToCoins:false,autoSeedsToCoins:false,lastSeedsToCoinsDate:0,useDefaultLiveQuality:false,recordLiveDanmaku:false,autoContinue:false,useDefaultVideoQuality:false,guiSettings:true,viewCover:true,notifyNewVersion:true,clearCache:true,downloadVideo:true,enableDashDownload:true,downloadDanmaku:true,downloadSubtitle:true,downloadAudio:true,downloadLiveRecords:true,medalHelper:true,customNavbarCompact:false,latestVersionLink:"https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@master/bilibili-evolved.offline.user.js",currentVersion:GM.info.script.version};const settingsChangeHandlers={};function addSettingsListener(e,t,i){if(!settingsChangeHandlers[e]){settingsChangeHandlers[e]=[t]}else{settingsChangeHandlers[e].push(t)}if(i){const i=settings[e];t(i,i)}}function removeSettingsListener(e,t){const i=settingsChangeHandlers[e];if(!i){return}i.splice(i.indexOf(t),1)}async function loadSettings(){for(const e in fixedSettings){settings[e]=fixedSettings[e];await GM.setValue(e,fixedSettings[e])}if(Object.keys(languageCodeToName).includes(navigator.language)){settings.i18n=true;settings.i18nLanguage=languageCodeToName[navigator.language]}for(const e in settings){let t=await GM.getValue(e);if(e==="batchFilenameFormat"&&t==="[n - ][title]"){t="[n - ][ep]";GM.setValue(e,t)}if(t===undefined){t=settings[e];GM.setValue(e,settings[e])}else if(settings[e]!==undefined&&t.constructor===Object){t=Object.assign(settings[e],t)}Object.defineProperty(settings,e,{get(){return t},set(i){t=i;GM.setValue(e,i);const o=settingsChangeHandlers[e];if(o){if(e==="useDarkStyle"){setTimeout((()=>o.forEach((e=>e(i,t)))),200)}else{o.forEach((e=>e(i,t)))}}const a=document.querySelector(`input[key=${e}]`);if(a!==null){if(a.type==="checkbox"){a.checked=i}else if(a.type==="text"&&!a.parentElement.classList.contains("gui-settings-dropdown")){a.value=i}}}})}}class Ajax{static send(e,t,i=true){return new Promise(((o,a)=>{e.addEventListener("load",(()=>{o(i?e.responseText:e.response)}));e.addEventListener("error",(()=>a(e.status)));e.send(t)}))}static getBlob(e){const t=new XMLHttpRequest;t.responseType="blob";t.open("GET",e);return this.send(t,undefined,false)}static getBlobWithCredentials(e){const t=new XMLHttpRequest;t.responseType="blob";t.open("GET",e);t.withCredentials=true;return this.send(t,undefined,false)}static async getJson(e){return JSON.parse(await this.getText(e))}static async getJsonWithCredentials(e){return JSON.parse(await this.getTextWithCredentials(e))}static getText(e){const t=new XMLHttpRequest;t.open("GET",e);return this.send(t)}static getTextWithCredentials(e){const t=new XMLHttpRequest;t.open("GET",e);t.withCredentials=true;return this.send(t)}static postText(e,t){const i=new XMLHttpRequest;i.open("POST",e);i.setRequestHeader("Content-Type","application/x-www-form-urlencoded");return this.send(i,t)}static postTextWithCredentials(e,t){const i=new XMLHttpRequest;i.open("POST",e);i.withCredentials=true;i.setRequestHeader("Content-Type","application/x-www-form-urlencoded");return this.send(i,t)}static postJson(e,t){const i=new XMLHttpRequest;i.open("POST",e);i.setRequestHeader("Content-Type","application/json");return this.send(i,JSON.stringify(t),false)}static postJsonWithCredentials(e,t){const i=new XMLHttpRequest;i.open("POST",e);i.withCredentials=true;i.setRequestHeader("Content-Type","application/json");return this.send(i,JSON.stringify(t),false)}static getHandlers(e){e=e.toLowerCase();let t=Ajax[e];if(t===undefined){t=Ajax[e]=[]}return t}static addEventListener(e,t){const i=Ajax.getHandlers(e);i.push(t)}static removeEventListener(e,t){const i=Ajax.getHandlers(e);i.splice(i.indexOf(t),1)}static monkey(e){return new Promise(((t,i)=>{const o={...e,onload:e=>t(e.response),onerror:e=>i(e)};if(!("method"in o)){o.method="GET"}GM.xmlHttpRequest(o)}))}static async getPages({api:e,getList:t,getTotal:i}){let o=1;let a=Infinity;const r=[];while(r.length<a){const n=await e(o);if(n.code!==0){console.warn(`api failed in Ajax.getPages. message = ${n.message}, page = ${o}, total = ${a}, api = `,e)}const l=t(n);r.push(...l);if(a===Infinity){a=i(n)}o++}return r}}let ajaxHooked=false;function setupAjaxHook(){if(ajaxHooked){return}ajaxHooked=true;const e={open:XMLHttpRequest.prototype.open,send:XMLHttpRequest.prototype.send};const t=(e,t,...i)=>Ajax.getHandlers(e).forEach((e=>e.call(t,...i)));const i=(i,o,...a)=>{t("before"+i,o,...a);const r=e[i].call(o,...a);t("after"+i,o,...a);return r};const o=(e,i)=>{if(i[e]){const o=i[e];i[e]=(...a)=>{t("before"+e,i,...a);o.apply(i,a);t("after"+e,i,...a)}}else{i[e]=(...o)=>{t("before"+e,i,...o);t("after"+e,i,...o)}}};XMLHttpRequest.prototype.open=function(...e){return i("open",this,...e)};XMLHttpRequest.prototype.send=function(...e){o("onreadystatechange",this);o("onload",this);return i("send",this,...e)}}async function loadResources(){Resource.root="https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/";switch(await GM.getValue("updateCdn")){case"jsDelivr":default:Resource.cdnRoot="https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@master/";break;case"GitHub":Resource.cdnRoot=Resource.root;break}Resource.all={};Resource.displayNames={};Resource.reloadables=[];for(let[e,t]of Object.entries(Resource.manifest)){if(typeof t==="string"){const i={displayNames:{[e]:t}};Resource.manifest[e]=i;t=i}if(!t.path){t.path=`${_.kebabCase(e)}.min.js`}const i=new Resource(t.path,{styles:t.styles,alwaysPreview:t.alwaysPreview});i.key=e;i.dropdown=t.dropdown;if(t.reloadable){Resource.reloadables.push(e)}if(t.displayNames){i.displayName=t.displayNames[e];Object.assign(Resource.displayNames,t.displayNames)}if(t.style){const o=e+"Style";const a=Resource.all[o]=new Resource(t.path.replace(".js",".css"),{alwaysPreview:t.alwaysPreview});a.key=o;switch(t.style){case"instant":{i.styles.push(o);break}case true:{i.dependencies.push(a);break}case"important":{i.styles.push({key:o,important:true});break}default:{if(typeof t.style==="object"){i.styles.push(Object.assign({key:o},t.style))}break}}}if(t.html===true){const o=e+"Html";const a=Resource.all[o]=new Resource(t.path.replace(".js",".html"),{alwaysPreview:t.alwaysPreview});a.key=o;i.dependencies.push(a)}Resource.all[e]=i}for(const[e,t]of Object.entries(Resource.manifest)){if(t.dependencies){Resource.all[e].dependencies.push(...t.dependencies.map((e=>Resource.all[e])))}}}class Toast{show(){}dismiss(){}static show(){}static info(){}static success(){}static error(){}}class DoubleClickEvent{constructor(e,t=null){this.handler=e;this.singleClickHandler=t;this.elements=[];this.clickedOnce=false;this.doubleClickHandler=e=>{if(!this.clickedOnce){this.clickedOnce=true;setTimeout((()=>{if(this.clickedOnce){this.clickedOnce=false;this.singleClickHandler&&this.singleClickHandler(e)}}),200)}else{this.clickedOnce=false;this.handler&&this.handler(e)}}}bind(e){if(this.elements.indexOf(e)===-1){this.elements.push(e);e.addEventListener("click",this.doubleClickHandler)}}unbind(e){const t=this.elements.indexOf(e);if(t===-1){return}this.elements.splice(t,1);e.removeEventListener("click",this.doubleClickHandler)}}let cidHooked=false;const videoChangeCallbacks=[];class Observer{constructor(e,t){this.elements=e||[];this.callback=t;this.observer=null;this.options=undefined}start(){this.elements.forEach((e=>{this.observer=new MutationObserver(this.callback);this.observer.observe(e,this.options)}));return this}add(e){this.elements.push(e);this.observer.observe(e,this.options);return this}stop(){this.observer&&this.observer.disconnect();return this}forEach(e){e(this)}static observe(e,t,i){t([]);let o=e;if(typeof e==="string"){o=[...document.querySelectorAll(e)]}else if(!Array.isArray(e)){o=[e]}const a=new Observer(o,t);a.options=i;return a.start()}static childList(e,t){return Observer.observe(e,t,{childList:true,subtree:false,attributes:false})}static childListSubtree(e,t){return Observer.observe(e,t,{childList:true,subtree:true,attributes:false})}static attributes(e,t){return Observer.observe(e,t,{childList:false,subtree:false,attributes:true})}static attributesSubtree(e,t){return Observer.observe(e,t,{childList:false,subtree:true,attributes:true})}static all(e,t){return Observer.observe(e,t,{childList:true,subtree:true,attributes:true})}static async videoChange(e){const t=await SpinQuery.select((()=>{if(unsafeWindow.cid){return unsafeWindow.cid}if(unsafeWindow.player&&unsafeWindow.player.getVideoMessage){const e=unsafeWindow.player.getVideoMessage();if(Number.isNaN(e.cid)){return null}if(!unsafeWindow.aid&&e.aid){unsafeWindow.aid=e.aid.toString()}return e.cid.toString()}}));if(t===null){return}if(!cidHooked){let e=t;Object.defineProperty(unsafeWindow,"cid",{get(){return e},set(t){e=t;if(!Array.isArray(t)){videoChangeCallbacks.forEach((e=>e()))}}});cidHooked=true}e();videoChangeCallbacks.push(e)}}class SpinQuery{constructor(e,t,i,o){this.maxRetry=15;this.retry=0;this.queryInterval=1e3;this.query=e;this.condition=t;this.action=i;this.failed=o}start(){this.tryQuery(this.query,this.condition,this.action,this.failed)}tryQuery(e,t,i,o){if(this.retry<this.maxRetry){const a=e();if(t(a)){i(a)}else{setTimeout((()=>waitForForeground((()=>{this.retry++;this.tryQuery(e,t,i,o)}))),this.queryInterval)}}else{typeof o==="function"&&o()}}static condition(e,t,i,o){if(i!==undefined){new SpinQuery(e,t,i,o).start()}else{return new Promise((i=>{new SpinQuery(e,t,(e=>i(e)),(()=>i(null))).start()}))}}static select(e,t,i){if(typeof e==="string"){const t=e;e=()=>document.querySelector(altVideoFilter(t))}return SpinQuery.condition(e,(e=>e!==null&&e!==undefined),t,i)}static any(e,t,i){if(typeof e==="string"){const t=e;e=()=>$(altVideoFilter(t))}return SpinQuery.condition(e,(e=>e.length>0),t,i)}static count(e,t,i,o){if(typeof e==="string"){const t=e;e=()=>document.querySelectorAll(altVideoFilter(t))}return SpinQuery.condition(e,(e=>e.length===t),i,o)}static unsafeJquery(e,t){return SpinQuery.condition((()=>unsafeWindow.$),(e=>e!==undefined),e,t)}}class ColorProcessor{constructor(e){this.hex=e}get rgb(){return this.hexToRgb(this.hex)}get rgba(){return this.hexToRgba(this.hex)}getHexRegex(e,t){const i=t?"":"{2}";const o=`([a-f\\d]${i})`;const a=e?4:3;const r=`#?${o.repeat(a)}`;return new RegExp(r,"ig")}hexToRgbOrRgba(e,t){const i=e.length<6;if(i){const i=this.getHexRegex(t,true);e=e.replace(i,(function(...e){let t="";let i=1;while(e[i]){t+=e[i].repeat(2);i++}return t}))}const o=this.getHexRegex(t,false);const a=o.exec(e);if(a){const e={r:parseInt(a[1],16),g:parseInt(a[2],16),b:parseInt(a[3],16)};if(a[4]){e.a=parseInt(a[4],16)/255}return e}else if(t){const t=this.hexToRgbOrRgba(e,false);if(t){t.a=1;return t}}return null}hexToRgb(e){return this.hexToRgbOrRgba(e,false)}hexToRgba(e){return this.hexToRgbOrRgba(e,true)}rgbToString(e){if(e.a){return`rgba(${e.r},${e.g},${e.b},${e.a})`}return`rgb(${e.r},${e.g},${e.b})`}rgbToHsb(e){const{r:t,g:i,b:o}=e;const a=Math.max(t,i,o);const r=Math.min(t,i,o);const n=a-r;const l=Math.round((a===0?0:n/a)*100);const c=Math.round(a/255*100);let s;if(n===0){s=0}else if(t===a){s=(i-o)/n%6}else if(i===a){s=(o-t)/n+2}else if(o===a){s=(t-i)/n+4}s=Math.round(s*60);if(s<0){s+=360}return{h:s,s:l,b:c}}get hsb(){return this.rgbToHsb(this.rgb)}get grey(){const e=this.rgb;return 1-(.299*e.r+.587*e.g+.114*e.b)/255}get foreground(){const e=this.rgb;const t=settings.foregroundColorMode;if(t==="自动"||t===undefined){if(e&&this.grey<.35){return"#000"}return"#fff"}else if(t==="黑色"){return"#000"}else if(t==="白色"){return"#fff"}}makeImageFilter(e){const{h:t,s:i}=this.rgbToHsb(e);const o=this.hsb;const a=o.h-t;const r=((o.s-i)/100+1)*100;const n=`hue-rotate(${a}deg) saturate(${r}%)`;return n}get blueImageFilter(){const e={r:0,g:160,b:213};return this.makeImageFilter(e)}get pinkImageFilter(){const e={r:251,g:113,b:152};return this.makeImageFilter(e)}get brightness(){return`${this.foreground==="#000"?"100":"0"}%`}get filterInvert(){return this.foreground==="#000"?"invert(0)":"invert(1)"}}const offlineData={};offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/about.min.css"]=`.bilibili-evolved-about{height:100%;width:450px;background:#fff;color:#000;position:fixed;top:0;left:0;z-index:100000;transform:translateX(-101%);transition:.3s cubic-bezier(0,.86,.58,1);display:flex;flex-direction:column;box-shadow:4px 0 16px 0 #0000;user-select:none}.gui-settings-dock-right .bilibili-evolved-about{right:0;left:unset;transform:translateX(101%)}body.dark .bilibili-evolved-about{background:#222;color:#eee}.bilibili-evolved-about.opened,.gui-settings-dock-right .bilibili-evolved-about.opened{transform:translateX(0);box-shadow:4px 0 16px 0 #0005}.about-header{padding:32px;display:flex;align-items:center;justify-content:flex-start}.about-header i{margin-right:8px;display:flex}.about-title{font-size:16pt}.about-content{padding:16px 36px 0;margin-bottom:36px;display:flex;flex-direction:column;overflow:auto}.about-content .name{font-size:24pt;display:none;align-items:center}.about-content .name svg{width:100%}body.dark .about-content .name.dark,body:not(.dark) .about-content .name.light{display:flex}.about-content .version{font-size:10pt;font-weight:700;opacity:.6;margin-top:6px;margin-bottom:6px;align-self:center}.about-content .love{font-size:10pt;margin-bottom:24px;align-self:center}.about-content .love a{color:inherit!important}.about-content section{font-size:10pt;margin-top:16px}.about-content section .title{display:flex;justify-content:center;text-transform:uppercase;font-weight:700;font-size:13pt;letter-spacing:3px;margin:8px 0 16px}.about-content section .supporter,.about-content section a{color:var(--theme-color)!important;margin-right:8px;display:inline-flex}.about-content section .supporter{user-select:none}.about-content section .supporter:not(:last-child)::after,.about-content section a:not(:last-child)::after{content:","}@keyframes spinner{to{transform:translate(-50%,-50%) rotate(360deg)}}.about-content section.participants .fetching{margin-right:8px;position:relative;display:inline-flex}.about-content section.participants .fetching::before{content:"Loading..."}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/about.min.html"]=`<div class=bilibili-evolved-about><div class=about-header><i class="mdi mdi-information-outline mdi-24px"></i><span class=about-title>关于</span></div><div class=about-content><p v-if=branch class="name light"v-html=logoImage></p><p v-if=branch class="name dark"v-html=logoImageDark></p><p class=version>v{{version}} · {{clientType}}</p><p class=love><a target=_blank href=https://github.com/the1812/Bilibili-Evolved/ >Made with ❤　　</a><a target=_blank href=https://github.com/the1812/Bilibili-Evolved/blob/preview/doc/donate.md>Buy me a coffee ☕</a></p><section class=authors><span class=title>Authors</span><a class=author target=_blank v-for="author of authors"v-bind:href=author.link>{{author.name}}</a></section><section class=contributors><span class=title>Contributors</span><a class=contributor target=_blank v-for="contributor of contributors"v-bind:href=contributor.link>{{contributor.name}}</a></section><section class=supporters><a class=title target=_blank href=https://github.com/the1812/Bilibili-Evolved/blob/preview/doc/donate.md#历史>View Supporters</a></section><section class=participants><span class=title>Community Power</span><span class=fetching v-if=fetching></span><a class=participant target=_blank v-for="participant of participants"v-bind:href=participant.link>{{participant.name}}</a></section><section class=websites><span class=title>Websites</span><a class=website target=_blank v-for="website of websites"v-bind:href=website.link>{{website.name}}</a></section><section class=components><span class=title>Components</span><a class=component target=_blank v-for="component of components"v-bind:href=component.link>{{component.name}}</a></section></div></div>`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/about.min.js"]=(()=>(e,t)=>{(async()=>{const i=await t.importAsync("aboutHtml");document.body.insertAdjacentHTML("beforeend",i);dq(".bilibili-evolved-about").addEventListener("be:about-load",(()=>{const t=(e,t)=>e.charCodeAt(0)-t.charCodeAt(0);const i=(e,i)=>t(e.name,i.name);const o=GM.info.script.name.match(/Bilibili Evolved \((.*)\)/);const a=o?o[1]:"Stable";new Vue({el:".bilibili-evolved-about",data:{version:e.currentVersion,clientType:a,logoImage:null,logoImageDark:null,branch:null,authors:[{name:"Grant Howard",link:"https://github.com/the1812"},{name:"Coulomb-G",link:"https://github.com/Coulomb-G"}],contributors:[{name:"PleiadeSubaru",link:"https://github.com/Etherrrr"},{name:"Lets-Halloween",link:"https://github.com/Lets-Halloween"},{name:"shugen002",link:"https://github.com/shugen002"},{name:"Joshuaふみひる",link:""},{name:"kdxcxs",link:"https://github.com/kdxcxs"},{name:"JLoeve",link:"https://github.com/LonelySteve"}].sort(i),fetching:true,participants:[],websites:[{name:"GitHub",link:"https://github.com/the1812/Bilibili-Evolved/"},{name:"Greasy Fork",link:"https://greasyfork.org/zh-CN/scripts/373563-bilibili-evolved"}],components:[{name:"Vue.js",link:"https://cn.vuejs.org/index.html"},{name:"Vuex",link:"https://vuex.vuejs.org/zh/"},{name:"JSZip",link:"https://stuk.github.io/jszip/"},{name:"jQuery",link:"http://jquery.com/"},{name:"debounce",link:"https://github.com/component/debounce/"},{name:"Slip.js",link:"https://github.com/kornelski/slip"},{name:"MDI",link:"https://materialdesignicons.com"},{name:"Lodash",link:"https://lodash.com/"}]},mounted(){dq(".bilibili-evolved-about").addEventListener("be:about-load-community",(()=>{this.init()}),{once:true})},methods:{async getLogos(){this.logoImage=await Ajax.getText(`https://raw.githubusercontent.com/the1812/Bilibili-Evolved/preview/images/bilibili-evolved-wide.svg`);this.logoImageDark=await Ajax.getText(`https://raw.githubusercontent.com/the1812/Bilibili-Evolved/preview/images/bilibili-evolved-wide-dark.svg`)},async init(){this.branch=/Preview|Local/.test(a)?"preview":"master";this.getLogos();const e=new Set;let t=[];let o=1;do{t=await Ajax.getJson(`https://api.github.com/repos/the1812/Bilibili-Evolved/issues?state=all&direction=asc&per_page=100&page=${o}`).catch((()=>{t=[{name:"电波无法到达(´･_･`)",link:null}]}));o++;for(const i of t){e.add(i.user.login)}}while(t.length>0);this.participants=[...e].map((e=>({name:e,link:`https://github.com/${e}`}))).filter((({link:e})=>!this.authors.some((t=>t.link===e))&&!this.contributors.some((t=>t.link===e)))).sort(i);this.fetching=false}}})}),{once:true})})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/activity-apis.min.js"]=(()=>(e,t)=>{class i extends EventTarget{constructor(){super(...arguments);this.cards=[]}addCard(e){if(e instanceof Element&&e.classList.contains("card")){if(e.querySelector(".skeleton")!==null){const t=Observer.childList(e,(()=>{if(e.querySelector(".skeleton")===null){t.forEach((e=>e.stop()));this.addCard(e)}}))}else{const t=this.parseCard(e);this.cards.push(t);const i=new CustomEvent("addCard",{detail:t});this.dispatchEvent(i)}}}removeCard(e){if(e instanceof Element&&e.classList.contains("card")){const t=this.parseCard(e).id;const i=this.cards.findIndex((e=>e.id===t));const o=this.cards[i];this.cards.splice(i,1);const a=new CustomEvent("removeCard",{detail:o});this.dispatchEvent(a)}}parseCard(e){const t=t=>{if(e.querySelector(t)===null){return""}return e.querySelector(t).innerText};const i=e=>{const i=parseInt(t(e));if(isNaN(i)){return 0}return i};const o={id:e.getAttribute("data-did"),username:t(".main-content .user-name"),text:t(".card-content .text.description"),reposts:i(".button-bar .single-button:nth-child(1) .text-offset"),comments:i(".button-bar .single-button:nth-child(2) .text-offset"),likes:i(".button-bar .single-button:nth-child(3) .text-offset")};return o}async startWatching(){const e=await SpinQuery.select(".card-list .content");if(!e){return false}const t=[...e.querySelectorAll(".content>.card")];t.forEach((e=>this.addCard(e)));Observer.childList(e,(e=>{e.forEach((e=>{e.addedNodes.forEach((e=>this.addCard(e)));e.removedNodes.forEach((e=>this.removeCard(e)))}))}));return true}}const o=new i;return{export:{activityCardsManager:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/activity-image-saver.min.js"]=(()=>(e,t)=>{(async()=>{if(!document.URL.startsWith("https://t.bilibili.com")&&!document.URL.startsWith("space.bilibili.com")){return}const e=e=>{const t=e.querySelector(".image-viewer");if(t===null){console.log(e)}else{t.addEventListener("contextmenu",(()=>{setTimeout((()=>{const e=dq(".pop-message .toast-text");if(e&&e.innerHTML.includes("作者设置了禁止保存")){Toast.success(`<img src="${t.src}" width="200">`,"解除动态存图限制")}}),200)}))}};[...document.body.children].filter((e=>e.classList.contains("photo-imager-container"))).forEach(e);Observer.childList(document.body,(t=>{t.forEach((t=>{const i=[...t.addedNodes].filter((e=>e instanceof Element&&e.classList.contains("photo-imager-container")));i.forEach(e)}))}))})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/airborne.min.css"]=`.bilibili-player-video-danmaku .b-danmaku.airborne{text-decoration:underline;cursor:pointer;pointer-events:initial}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/airborne.min.js"]=(()=>(e,t)=>{let i=true;const o="airborneStyle";(async()=>{if(!document.URL.match(/\/\/www\.bilibili\.com\/video\//)){return}const{forEachVideoDanmaku:e}=await t.importAsync("video-danmaku");t.applyStyle(o);const a=e=>{if(!e){return NaN}const t=e.match(/(\d+)[ ]*[:：时分][ ]*(\d+)([ ]*[:：分][ ]*(\d+))?/);if(!t){return NaN}if(t[3]){const[,i,o,,a]=t.map((e=>parseInt(e)));if([i,o,a].some((e=>Number.isNaN(e)))){return NaN}if(e.includes("分")&&!e.includes("时")){return NaN}return i*3600+o*60+a}const[,i,o]=t.map((e=>parseInt(e)));if([i,o].some((e=>Number.isNaN(e)))){return NaN}return i*60+o};const r=e=>{if(!i){return}const t=e.target;if(!t.classList.contains("b-danmaku")){return}const o=a(t.textContent);if(!Number.isNaN(o)){const e=dq("video");e.currentTime=o;e.play()}};const n=e=>{const t=!Number.isNaN(a(e.text));e.element.classList.toggle("airborne",t)};e({added:n});Observer.videoChange((async()=>{const e=await SpinQuery.select(".bilibili-player-video-wrap");if(e.classList.contains("airborne-enabled")){return}e.classList.add("airborne-enabled");e.addEventListener("click",r)}))})();return{reload:()=>{i=true;t.applyStyle(o)},unload:()=>{i=false;t.removeStyle(o)}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/airborne-old.min.js"]=(()=>(e,t)=>{if(typeof isEmbeddedPlayer!=="undefined"&&isEmbeddedPlayer()){return}function i(e){return e.innerText.search(/\d{1,}[:：]\d{2}/)!==-1&&e.childElementCount===0}function o(e){var t=e.offsetLeft;var i=e.offsetTop;var o=e.offsetParent;while(o!==null){t+=o.offsetLeft;i+=o.offsetTop+o.clientTop;o=o.offsetParent}styleTransform=e.style.transform;translateXReg=styleTransform.match(/translateX\(-?[0-9]{1,}([.][0-9]{1,})?px\)/);if(translateXReg!==null){t+=parseFloat(translateXReg[0].match(/-?[0-9]{1,}([.][0-9]{1,})?/)[0])}return{left:t,right:t+e.offsetWidth,top:i,bottom:i+e.offsetHeight}}function a(){const e=document.querySelector(".bilibili-player-video-danmaku").mousePosition;document.querySelector(".bilibili-player-video-danmaku").children.forEach((t=>{if(typeof t.airborneDestination==="undefined"){return true}const i=o(t);if(i.left<=e[0]&&e[0]<=i.right&&i.top<=e[1]&&e[1]<=i.bottom){document.querySelector(".bilibili-player-video video").currentTime=t.airborneDestination;document.querySelector(".bilibili-player-video video").play()}}))}function r(t){if(e.airborne){airborneDestination=t.innerText.match(/\d{1,}[:：]\d{2}/)[0];sep=airborneDestination.includes(":")?":":"：";airborneDestination=parseInt(airborneDestination.split(sep)[0])*60+parseInt(airborneDestination.split(sep)[1]);if(0<=airborneDestination&&airborneDestination<=document.querySelector(".bilibili-player-video video").duration){t.airborneDestination=airborneDestination;const e=t.offsetWidth;t.innerHTML="<u>"+t.innerText+"🚁</u>";if(t.style.marginLeft===""){t.style.marginLeft="-"+(t.offsetWidth-e).toString()+"px"}}}}(function e(){SpinQuery.select((()=>document.querySelector(".bilibili-player-video-danmaku"))).then((()=>{document.querySelector(".bilibili-player-video-danmaku").mousePosition=[0,0];document.addEventListener("mousemove",(e=>{document.querySelector(".bilibili-player-video-danmaku").mousePosition=[e.clientX,e.clientY]}),false);document.querySelector(".bilibili-player-video-wrap").addEventListener("click",(()=>{setTimeout((()=>{a()}),5)}));Observer.childList(".bilibili-player-video-danmaku",(e=>{e.forEach((e=>{e.addedNodes.forEach((e=>{if(i(e)){r(e)}Observer.childList(e,(e=>{e.forEach((e=>{if(i(e.target)){r(e.target)}}))}))}))}))}))}))})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/aria2-rpc.min.js"]=(()=>(e,t)=>{const i=()=>{const t=e.aria2RpcOption;const i=t.host.match(/^http[s]?:\/\//)?t.host:"http://"+t.host;const o="aria2.addUri";return{option:t,host:i,methodName:o}};const o=async(e,t=false)=>{try{let i=await e();if(typeof i==="string"){i=JSON.parse(i)}if(i.error!==undefined){if(i.error.code===1){logError(`请求遭到拒绝, 请检查您的密钥相关设置.`)}else{logError(`请求发生错误, code = ${i.error.code}, message = ${i.error.message}`)}return false}if(!t){Toast.success(`成功发送了请求, GID = ${i.result}`,"aria2 RPC",5e3)}return true}catch(e){logError(`无法连接到RPC主机.`);return false}};const a=async(e,t=false)=>{const{option:a,host:r,methodName:n}=i();return await o((async()=>{const t=window.btoa(unescape(encodeURIComponent(JSON.stringify(e.params))));const i=`${r}:${a.port}/jsonrpc?method=${n}&id=${e.id}&params=${t}`;console.log(`RPC request:`,i);if(i.startsWith("http:")){return await new Promise(((e,t)=>{GM.xmlHttpRequest({method:"GET",url:i,responseType:"json",onload:t=>e(t.response),onerror:e=>t(e)})}))}else{return await Ajax.getJson(i)}}),t)};const r=async(e,t=false)=>{const{option:a,host:r,methodName:n}=i();return await o((async()=>{const t=`${r}:${a.port}/jsonrpc`;const i={method:n,id:e.id,params:e.params};if(t.startsWith("http:")){return await new Promise(((e,o)=>{GM.xmlHttpRequest({method:"POST",url:t,responseType:"json",data:JSON.stringify(i),onload:t=>e(t.response),onerror:e=>o(e)})}))}else{return await Ajax.postJson(t,i)}}),t)};const n=async(t,i=false)=>{const o=e.aria2RpcOption;for(const e of t){let t;if(o.method==="get"){t=await a(e,i)}else{t=await r(e,i)}if(i===true&&t===false){logError(`${decodeURIComponent(e.id)} 导出失败`)}}};const l=e=>{if(!e){return{}}const t=e.split("\n").map((e=>{const[t,...i]=e.trim().split("=");return[t.trim(),i.join("=").trim()]})).filter((e=>Boolean(e[1])));return Object.fromEntries(t)};return{export:{sendRpc:n,parseRpcOptions:l}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/aria2-rpc-profile-item.vue.min.js"]=(()=>(e,t)=>{const i=`<div class=profile-item :class="{duplicate: duplicateName, selected}"><template v-if=!editing>{{profile.name}}</template><template v-else><input type=text v-model=name @keydown.enter=saveProfile()></template><icon v-if=!editing style="transform: scale(0.9)"type=mdi icon=pencil-outline title=重命名 @click.native="editing = true"></icon><icon v-if=editing type=mdi icon=check title=确定 @click.native=saveProfile()></icon></div>`;t.applyStyleFromText(`.profile-item{display:flex;align-items:center;padding:4px 8px;background-color:#8882;border-radius:4px;border:2px solid transparent;flex-shrink:0;cursor:pointer}.profile-item:not(:last-child){margin-right:8px}.profile-item.duplicate{border-color:red}.profile-item.selected:not(.duplicate){border-color:var(--theme-color)}.profile-item input[type=text]{width:5em;border:none!important;padding:0!important;margin:0!important;line-height:normal}`,"aria2-rpc-profile-item-style");return{export:Object.assign({template:i},{components:{Icon:()=>t.importAsync("icon.vue")},props:["profile","deletable","selected"],data(){return{name:this.profile.name,editing:false,duplicateName:false}},methods:{saveProfile(){if(this.name===this.profile.name){this.duplicateName=false;this.editing=false;return}if(this.name===""||e.aria2RpcOptionProfiles.some((e=>e.name===this.name))){this.duplicateName=true;return}else{this.duplicateName=false;if(e.aria2RpcOptionSelectedProfile===this.profile.name){e.aria2RpcOptionSelectedProfile=this.name}this.profile.name=this.name;this.editing=false;this.$emit("profile-update")}}}})}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/aria2-rpc-profiles.vue.min.js"]=(()=>(e,t)=>{const i=`<div class=aria2-rpc-profiles><div class=profiles-header><h2>预设</h2><div class=profile-operations><div v-if="profiles.length > 1"class="operation delete-profile"@click=deleteProfile() title=删除预设><icon type=mdi icon=trash-can-outline></icon></div><div class="operation new-profile"@click=addProfile() title=新增预设><icon type=mdi icon=plus></icon></div></div></div><div class=profiles-list><profile-item v-for="(profile, index) of profiles":key="profile.name + index"@profile-update=profileUpdate() @click.native=changeProfile(profile) :profile=profile :deletable="profiles.length > 1":selected="profile.name === selectedProfile"></profile-item></div></div>`;t.applyStyleFromText(`.aria2-rpc-profiles .profiles-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:8px}.aria2-rpc-profiles .profiles-header .profile-operations{display:flex;align-items:center}.aria2-rpc-profiles .profiles-header .profile-operations .operation{padding:4px;background-color:#8882;border-radius:50%;display:flex;align-items:center;justify-content:center;cursor:pointer}.aria2-rpc-profiles .profiles-header .profile-operations .operation:not(:last-child){margin-right:8px}.aria2-rpc-profiles .profiles-header .profile-operations .operation:hover{background-color:#8884}.aria2-rpc-profiles .profiles-header .profile-operations .operation .mdi{margin:0}.aria2-rpc-profiles .profiles-list{display:flex;overflow:auto;scrollbar-width:none!important}.aria2-rpc-profiles .profiles-list::-webkit-scrollbar{height:0!important}`,"aria2-rpc-profiles-style");const o={name:"未命名",...e.aria2RpcOption};const a=()=>{const t=["baseDir","maxDownloadLimit","skipByDefault"];if(t.some((t=>t in e.aria2RpcOption))){e.aria2RpcOption=_.omit(e.aria2RpcOption,...t)}const i=Object.getOwnPropertyNames(e.aria2RpcOption).filter((e=>!e.startsWith("_")));let o=false;e.aria2RpcOptionProfiles.forEach((t=>{i.filter((e=>!(e in t)&&e!=="name")).forEach((i=>{if(i==="name"){return}if(!(i in t)){t[i]=e.aria2RpcOption[i];console.log(`[Add] migrated profile property '${i}'`);o=true}}));Object.keys(t).forEach((e=>{if(e==="name"){return}if(!i.includes(e)){delete t[e];console.log(`[Delete] migrated profile property '${e}'`);o=true}}))}));if(o){e.aria2RpcOptionProfiles=e.aria2RpcOptionProfiles}};return{export:Object.assign({template:i},{components:{ProfileItem:()=>t.importAsync("aria2-rpc-profile-item.vue"),Icon:()=>t.importAsync("icon.vue")},data(){a();const t=[...e.aria2RpcOptionProfiles];if(t.length===0){t.push(o);e.aria2RpcOptionProfiles=t}return{profiles:t,selectedProfile:e.aria2RpcOptionSelectedProfile||o.name}},watch:{selectedProfile(t){if(e.aria2RpcOptionSelectedProfile!==t){e.aria2RpcOptionSelectedProfile=t}}},methods:{profileUpdate(){e.aria2RpcOptionProfiles=this.profiles;this.selectedProfile=e.aria2RpcOptionSelectedProfile},changeProfile(e){this.selectedProfile=e.name;this.$emit("profile-change",e)},addProfile(){const t={...this.profiles.find((e=>e.name===this.selectedProfile))};t.name=t.name.replace(/[\d]+$/,"");if(this.profiles.some((e=>e.name===t.name))){let e=1;while(this.profiles.some((i=>i.name===t.name+e.toString()))){e++}t.name=t.name+e.toString()}this.profiles.push(t);e.aria2RpcOptionProfiles=this.profiles;this.changeProfile(t)},deleteProfile(){const t=this.profiles.findIndex((e=>e.name===this.selectedProfile));const i=t===0?0:t-1;const o=this.profiles[i];this.profiles.splice(t,1);e.aria2RpcOptionProfiles=this.profiles;this.changeProfile(o)}}})}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/ass-utils.min.js"]=(()=>(e,t)=>{const i=e=>{if(e.startsWith("#")){e=e.substring(1)}const t=e.substring(0,2);const i=e.substring(2,4);const o=e.substring(4,6);return{red:t,green:i,blue:o}};const o=e=>{const{red:t,green:o,blue:a}=i(e);return`\\c&H${a}${o}${t}&`.toUpperCase()};const a=(e,t=1)=>{const{red:o,green:a,blue:r}=i(e);const n=Math.round(255*(1-t)).toString(16);return`&H${n}${r}${a}${o}`.toUpperCase()};const r=e=>{const[t,i="00"]=String(e).split(".");return`${t.padStart(2,"0")}.${i.substr(0,2).padEnd(2,"0")}`};const n=e=>{let t=0;let i=0;while(e>=60){e-=60;i++}while(i>=60){i-=60;t++}return`${t}:${String(i).padStart(2,"0")}:${r(e)}`};const l=(e,t)=>[n(e),n(e+t)];const c=(e,t)=>[n(e),n(t)];const s=e=>{const t={"{":"｛","}":"｝","&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&apos;":"'","\n":"\\N"};for(const[i,o]of Object.entries(t)){e=e.replace(new RegExp(i,"g"),o)}return e};return{export:{convertHexColorForDialogue:o,convertHexColorForStyle:a,convertTimeByDuration:l,convertTimeByEndTime:c,normalizeContent:s}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/auto-continue.min.js"]=(()=>(e,t)=>{if(typeof isEmbeddedPlayer!=="undefined"&&isEmbeddedPlayer()){return}function i(t){const i=t.text();if(/第(\d+)话/.test(i)){if(e.allowJumpContinue){t.parent().find(".bilibili-player-video-toast-item-jump").click()}return}const o=/((\d)*:)?(\d)*:(\d)*/g;const a=i.match(o);if(!a){return}const r=a[0].split(":");const n=(()=>{if(r.length===3){const[e,t,i]=r.map((e=>parseInt(e)));return e*60*60+t*60+i}else if(r.length===2){const[e,t]=r.map((e=>parseInt(e)));return e*60+t}else{logError(`解析历史时间发生错误: historyTime=${JSON.stringify(r)}`);return NaN}})();const l=t.parent();const c=document.querySelector("video");if(n<c.duration){c.currentTime=n;c.play();l.find(".bilibili-player-video-toast-item-jump").remove();const e=$(`<div class="bilibili-player-video-toast-item-jump">从头开始</div>`);e.appendTo(l).on("click",(()=>{c.currentTime=0;l.find(".bilibili-player-video-toast-item-close").get(0).click()}));t.html(`<span>已跳转到上次历史记录</span><span>${a[0]}</span>`)}else{l.find(".bilibili-player-video-toast-item-close").get(0).click()}}function o(){SpinQuery.condition((()=>$(".bilibili-player-video-toast-item-text")),(e=>e.text().indexOf("上次看到")!==-1),(e=>i(e.filter(((e,t)=>t.innerText.indexOf("上次看到")!==-1)))))}Observer.videoChange(o)})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/auto-draw.min.js"]=(()=>(e,t)=>{(async()=>{if(!/^https:\/\/live\.bilibili\.com\/(blanc\/)?[\d]+/.test(document.URL)){return}const e=await SpinQuery.condition((()=>dq(".chat-popups-section")),(e=>e!==null&&e.querySelector("chat-draw-area")===null));if(!e){console.warn("[自动领奖] 未能找到弹窗容器");return}Observer.childListSubtree(e,(()=>{let e;console.log("draw button =",dq(".chat-popups-section .draw>span:nth-child(3)"));e=dq(".chat-popups-section .draw>span:nth-child(3)");if(e===null){const e=dq(".chat-popups-section .function-bar>span:nth-child(3)");if(e!==null){const t=Observer.attributes(e,(()=>{if(e.style.display!=="none"){t.forEach((e=>e.stop()));e.click()}}))}}if(e!==null){e.click()}}))})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/auto-play.min.js"]=(()=>(e,t)=>{if(typeof isEmbeddedPlayer!=="undefined"&&isEmbeddedPlayer()){return}SpinQuery.condition((()=>document.querySelector(".bilibili-player-video video")),(e=>e&&e.paused===true),(e=>e.play()))})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/auto-play-control.min.js"]=(()=>(e,t)=>{(async()=>{const e=["https://www.bilibili.com/video/","https://www.bilibili.com/watchlater/","https://www.bilibili.com/medialist/play/"];if(!e.some((e=>document.URL.startsWith(e)))){return}const i={enable:[".multi-page .next-button",".player-auxiliary-autoplay-switch input"],disable:[".recommend-list .next-button"]};const o=[()=>Boolean(dq(".multi-page .list-box li.on:last-child"))];const a=e=>Boolean(e.querySelector(".switch-button.on")||e.matches(":checked"));const{playerReady:r}=await t.importAsync("player-ready");await r();const n=async()=>{const e=await SpinQuery.select([...i.disable,...i.enable].join(","));if(!e){return}const t=i.enable.some((t=>e.matches(t)))&&o.every((e=>!Boolean(e())));const r=a(e);console.log(r,t,e);if(t!==r){e.click()}};Observer.videoChange((async()=>{n();const e=await SpinQuery.select(".bilibili-player-video video");e===null||e===void 0?void 0:e.addEventListener("play",n,{once:true})}))})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/bangumi-timeline.vue.min.js"]=(()=>(e,t)=>{const i=`<div class=bangumi-timeline-container><div class=area-header>时间表</div><div class=bangumi-timeline><div class=timeline-day v-for="t of timeline":key=t.date><div class=date-container :class="{today: t.isToday}"@click=moveTimeline><div class=icon :class="['day-of-week-' + t.dayOfWeek]"></div><div class=date>{{t.date}}</div><div class=day-of-week>{{t.dayOfWeekText}}</div></div><div class=empty-day :class="{alt: t.isToday}"v-if="Object.entries(t.bangumis).length === 0"></div><div class=time-container v-for="[time, bangumis] of Object.entries(t.bangumis)":key=time><div class=time :class="{'recent': t.isToday && recentTime.includes(time)}"><icon type=mdi icon=clock-fast></icon>{{time}}</div><a class=bangumi-item v-for="b of bangumis":key=b.url :class="{delay: b.delay}":href=b.url target=_blank><div class=cover-container><dpi-img :size=72 :src=b.squareCoverUrl></dpi-img></div><div class=title>{{b.title}}</div><div class=ep-title><icon type=mdi icon=heart-outline title=已追番 v-if=b.follow></icon>{{b.epTitle}}</div></a></div></div></div></div>`;t.applyStyleFromText(`.simple-home .bangumi-timeline-container{width:100%}.simple-home .bangumi-timeline-container .bangumi-timeline{display:flex;align-items:flex-start;overflow:auto;scrollbar-width:none!important;scroll-behavior:smooth;scroll-snap-type:x mandatory;--column-count:1;--column-width:250px;--column-gap:24px;width:calc(var(--column-count) * (var(--column-width) + var(--column-gap)) - .5 * var(--column-gap))}.simple-home .bangumi-timeline-container .bangumi-timeline::-webkit-scrollbar{height:0!important;width:0!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day{scroll-snap-align:start;width:var(--column-width);max-height:calc(var(--total-height) - 32px);overflow:auto;flex:0 0 auto;padding-bottom:16px;scroll-behavior:smooth;scrollbar-width:none!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day::-webkit-scrollbar{height:0!important;width:0!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container{display:grid;grid-template:"icon date" 1fr "icon dow" 1fr/auto 1fr;grid-column-gap:8px;column-gap:8px;height:60px;padding-bottom:12px;cursor:pointer;position:sticky;top:0;z-index:1;background-color:var(--simplify-home-background)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon{grid-area:icon;justify-self:center;align-self:center;background-image:url(//s1.hdslb.com/bfs/static/bangumi-timeline/asserts/icons.png);background-size:247px 663px;width:38px;height:36px;background-position-x:-146px;filter:brightness(.5)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-1{background-position-y:-36px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-2{background-position-y:-108px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-3{background-position-y:-180px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-4{background-position-y:-252px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-5{background-position-y:-324px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-6{background-position-y:-396px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon.day-of-week-7{background-position-y:-468px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .date{grid-area:date;align-self:end;opacity:.75}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .day-of-week{grid-area:dow;align-self:start;font-weight:700;font-size:15px;opacity:.75}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .icon{width:50px;height:48px;background-position-x:-56px;filter:none}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .date{font-size:14px;opacity:1}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .day-of-week{font-size:18px;opacity:1}body.dark .simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container .icon{filter:brightness(.8)}body.dark .simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .date-container.today .icon{filter:invert(1)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .empty-day{margin-top:26px;width:246px;height:469px;background:url(//s1.hdslb.com/bfs/static/bangumi-timeline/asserts/empty-1.png) no-repeat}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .empty-day.alt{background:url(//s1.hdslb.com/bfs/static/bangumi-timeline/asserts/empty-2.png) no-repeat}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container{margin-top:18px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container>:not(:last-child){margin-bottom:8px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time{display:flex;align-items:center;font-weight:700}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time.recent{color:var(--theme-color)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time.recent~.bangumi-item{box-shadow:0 4px 8px 0 #0001,inset 0 0 0 2px var(--theme-color)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time.recent~.bangumi-item .cover-container{margin:2px;border-radius:6px 0 0 6px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .time .be-icon{margin-right:6px;font-size:18px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item{display:grid;height:72px;grid-template:"cover title" auto "cover ep" auto/72px 1fr;background-color:#fff;color:inherit;box-shadow:0 4px 8px 0 #0001;border-radius:8px;grid-row-gap:8px;row-gap:8px}body.dark .simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item{background-color:#282828}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .cover-container{grid-area:cover;overflow:hidden;border-radius:8px 0 0 8px}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .cover-container img{width:100%;height:100%}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item.delay{opacity:.4}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item.delay:hover{opacity:1}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item:hover{color:var(--theme-color)!important}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item:hover .cover-container img{transform:scale(1.05)}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .title{grid-area:title;align-self:end;font-size:13px;font-weight:700;margin:0 12px;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;max-height:2.6em;word-break:break-all;line-height:1.3;overflow:hidden}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .ep-title{grid-area:ep;align-self:start;margin:0 12px;display:flex;align-items:center;white-space:nowrap;overflow:hidden}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day .time-container .bangumi-item .ep-title .be-icon{color:var(--theme-color);margin-right:4px;font-size:18px;line-height:1}.simple-home .bangumi-timeline-container .bangumi-timeline .timeline-day:not(:last-child){margin-right:var(--column-gap)}@media screen and (min-width:1000px){.simple-home .bangumi-timeline-container .bangumi-timeline{--column-count:2}}@media screen and (min-width:1300px){.simple-home .bangumi-timeline-container .bangumi-timeline{--column-count:3}}@media screen and (min-width:1550px){.simple-home .bangumi-timeline-container .bangumi-timeline{--column-count:4}}`,"bangumi-timeline-style");const o={global:"https://bangumi.bilibili.com/web_api/timeline_global",chinese:"https://bangumi.bilibili.com/web_api/timeline_cn"};return{export:Object.assign({template:i},{components:{Icon:()=>t.importAsync("icon.vue"),DpiImg:()=>t.importAsync("dpi-img.vue")},props:{type:{type:String,default:"global",required:false}},data(){return{timeline:[],recentTime:""}},computed:{apiUrl(){return o[this.type]||o.global}},watch:{type(){this.updateTimeline()}},methods:{calculateRecentTime(){const e=this.timeline.find((e=>e.isToday));const t=Number(new Date);const i=Object.entries(e.bangumis).map((([e,t])=>({time:e,timestamp:t[0].timestamp,bangumis:t})));if(i.length===0){return}const o=i.filter((e=>e.timestamp<t));if(o.length===0){this.recentTime=[i[0].time]}else{this.recentTime=o.map((e=>e.time))}},moveTimeline(e){const t=e.currentTarget;const i=t.parentElement;const o=i.parentElement;const a=getComputedStyle(o);const r=parseInt(a.getPropertyValue("--column-width").match(/(.+)px/)[1])+parseInt(a.getPropertyValue("--column-gap").match(/(.+)px/)[1]);const n=i.offsetLeft-o.scrollLeft;if(n<r){o.scrollLeft-=r}else if(n>=r*2){o.scrollLeft+=r}console.log(e,t,i,o);console.log(r,r*2,i.offsetLeft,o.scrollLeft,n)},async updateTimeline(){try{const e=await Ajax.getJsonWithCredentials(this.apiUrl);if(e.code!==0){throw new Error(e.message)}const t=e.result.map((e=>({date:e.date,dayOfWeek:e.day_of_week,dayOfWeekText:"周"+[,"一","二","三","四","五","六","日"][e.day_of_week],isToday:Boolean(e.is_today),bangumis:_.groupBy(e.seasons.map((e=>({coverUrl:e.cover.replace("http:","https:"),squareCoverUrl:e.square_cover.replace("http:","https:"),time:e.pub_time,timestamp:e.pub_ts*1e3,url:e.url,follow:Boolean(e.follow),epTitle:e.pub_index||e.delay_reason+" "+e.delay_index,title:e.title,delay:Boolean(e.delay),published:Boolean(e.is_published)}))),(e=>e.time))})));this.timeline=t;this.calculateRecentTime();setInterval((()=>{if(document.hasFocus()){this.calculateRecentTime()}}),60*1e3);await this.$nextTick();const i=this.$el;const o=this.$el.querySelector(".bangumi-timeline");const a=getComputedStyle(o);const r=parseInt(a.getPropertyValue("--column-width").match(/(.+)px/)[1]);const n=parseInt(a.getPropertyValue("--column-gap").match(/(.+)px/)[1]);o.scrollLeft=5*(r+n)}catch(e){logError(e);this.$emit("error")}finally{this.$emit("load")}}},async mounted(){await this.updateTimeline()}})}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/batch-download.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{formatTitle:o}=t.import("title");const a=12;const r=[".mp4",".m4a"];class n{constructor(e){this.config=e;i(this,"itemList",[])}static formatTitle(t){const i=e.batchFilenameFormat;const a=o(i,true,t);return escapeFilename(a," ")}async getRawItems(e){const{BannedResponse:i,throwBannedError:o}=await t.importAsync("batch-warning");try{const t=await this.collectData(e);return JSON.parse(t)}catch(e){if(e.message.includes(i.toString())){o()}throw e}}extension(e,t){const i=[".flv",".mp4"].find((t=>e.includes(t)));if(i){return i}else if(e.includes(".m4s")){return r[t]}else{return".flv"}}async collectAria2(i,o){const r=await this.getRawItems(i);const{getNumber:n}=await t.importAsync("get-number");if(o){const i=e.aria2RpcOption;const{sendRpc:o,parseRpcOptions:l}=await t.importAsync("aria2-rpc");for(const e of r){const t=e.fragments.map(((t,o)=>{let r="";if(e.fragments.length>1&&!t.url.includes(".m4s")){r=" - "+n(o+1,e.fragments.length)}const c=[];if(i.secretKey!==""){c.push(`token:${i.secretKey}`)}c.push([t.url]);c.push({referer:document.URL.replace(window.location.search,""),"user-agent":UserAgent,out:`${e.title}${r}${this.extension(t.url,o)}`,split:a,dir:i.dir||undefined,...l(i.other)});const s=encodeURIComponent(`${e.title}${r}`);return{params:c,id:s}}));await o(t,true)}}else{return`\n# Generated by Bilibili Evolved Video Export\n# https://github.com/the1812/Bilibili-Evolved/\n${r.map((e=>e.fragments.map(((t,i)=>{let o="";if(e.fragments.length>1&&!t.url.includes(".m4s")){o=` - ${n(i+1,e.fragments.length)}`}return`\n${t.url}\n  referer=${e.referer}\n  user-agent=${UserAgent}\n  out=${e.title}${o}${this.extension(t.url,i)}\n  split=${a}\n`.trim()})).join("\n"))).join("\n")}\n`.trim()}}}class l extends n{constructor(...e){super(...e);i(this,"aid",unsafeWindow.aid)}static async test(){if(document.URL.startsWith("https://www.bilibili.com/video/")){return await SpinQuery.select("#multi_page")!==null}return false}async getItemList(){if(this.itemList.length>0){return this.itemList}const e=`https://api.bilibili.com/x/web-interface/view?aid=${this.aid}`;const i=await Ajax.getJson(e);if(i.code!==0){Toast.error(`获取视频选集列表失败, message=${i.message}`,"批量下载");return[]}const o=i.data.pages;if(o===undefined){Toast.error(`获取视频选集列表失败, 没有找到选集信息.`,"批量下载");return[]}const{getNumber:a}=await t.importAsync("get-number");this.itemList=o.map((e=>({title:`P${e.page} ${e.part}`,titleParameters:{n:a(e.page,this.itemList.length),ep:e.part},cid:e.cid,aid:this.aid})));return this.itemList}async collectData(e){const i=[];for(const o of(await this.getItemList()).filter(this.config.itemFilter)){const a=this.config.api?this.config.api(o.aid,o.cid,e):`https://api.bilibili.com/x/player/playurl?avid=${o.aid}&cid=${o.cid}&qn=${e}&otype=json`;const r=await Ajax.getJsonWithCredentials(a);const l=r.data||r.result||r;if(l.quality!==e){console.warn(`${o.title} 不支持所选画质, 已回退到较低画质. (quality=${l.quality})`)}let c;if(l.durl){c=l.durl.map((e=>({length:e.length,size:e.size,url:e.url})))}else if(l.dash){const{getDashInfo:i,dashToFragments:o}=await t.importAsync("video-dash");const r=await i(a,typeof e==="string"?parseInt(e):e,true);c=o(r)}else{throw new Error(`获取链接失败: ${r.code} ${r.message}`)}i.push({fragments:c,title:n.formatTitle(o.titleParameters),totalSize:c.map((e=>e.size)).reduce(((e,t)=>e+t)),cid:o.cid,referer:document.URL.replace(window.location.search,"")})}return JSON.stringify(i)}}class c extends n{constructor(e){super(e);i(this,"mainVideo",void 0);i(this,"spVideo",void 0);this.mainVideo=new l(e);this.mainVideo.aid="78976165";this.spVideo=new l(e);this.spVideo.aid="78979124"}static async test(){return document.URL.includes("//www.bilibili.com/blackboard/bnj2020.html")}async getItemList(){return(await this.mainVideo.getItemList()).concat(await this.spVideo.getItemList())}async collectData(e){return(await this.mainVideo.collectData(e)).concat(await this.spVideo.collectData(e))}}class s extends l{constructor(e){super(e);this.config=e;i(this,"videos",_.get(unsafeWindow,"__INITIAL_STATE__.videoSections",[]).map((e=>e.episodes)).flat())}static async test(){return document.URL.includes("//www.bilibili.com/festival/2021bnj")}async getItemList(){const{getNumber:e}=await t.importAsync("get-number");return this.videos.map((({aid:t,cid:i,title:o},a)=>({title:`P${a+1} ${o}`,titleParameters:{n:e(a+1,this.videos.length),ep:o},aid:t,cid:i})))}}class p extends n{static async test(){return document.URL.includes("/www.bilibili.com/bangumi")}async getItemList(){if(this.itemList.length>0){return this.itemList}const e=document.querySelector("meta[property='og:url']");if(e===null){Toast.error("获取番剧数据失败: 无法找到 Season ID","批量下载");return[]}const i=e.getAttribute("content").match(/play\/ss(\d+)/)[1];if(i===undefined){Toast.error("获取番剧数据失败: 无法解析 Season ID","批量下载");return[]}const o=await Ajax.getJson(`https://api.bilibili.com/pgc/web/season/section?season_id=${i}`);if(o.code!==0){Toast.error(`获取番剧数据失败: 无法获取番剧集数列表, message=${o.message}`,"批量下载");return[]}const{getNumber:a}=await t.importAsync("get-number");this.itemList=o.result.main_section.episodes.map(((e,t)=>{const i=e.long_title?e.title:(t+1).toString();const o=e.long_title?e.long_title:e.title;return{aid:e.aid,cid:e.cid,title:`${i} - ${o}`,titleParameters:{n:a(parseFloat(i),this.itemList.length,e.title),ep:o}}}));return this.itemList}async collectData(e){const i=[];for(const o of(await this.getItemList()).filter(this.config.itemFilter)){const a=this.config.api?this.config.api(o.aid,o.cid,e):`https://api.bilibili.com/pgc/player/web/playurl?avid=${o.aid}&cid=${o.cid}&qn=${e}&otype=json`;const r=await Ajax.getJsonWithCredentials(a);const l=r.data||r.result||r;if(l.quality!==e){console.warn(`${o.title} 不支持所选画质, 已回退到较低画质. (quality=${l.quality})`)}let c;if(l.durl){c=l.durl.map((e=>({length:e.length,size:e.size,url:e.url})))}else{const{getDashInfo:i,dashToFragments:o}=await t.importAsync("video-dash");const r=await i(a,typeof e==="string"?parseInt(e):e);c=o(r)}i.push({fragments:c,title:n.formatTitle(o.titleParameters),totalSize:c.map((e=>e.size)).reduce(((e,t)=>e+t)),cid:o.cid,referer:document.URL.replace(window.location.search,"")})}return JSON.stringify(i)}}class d extends l{constructor(...e){super(...e);i(this,"items",[])}async getItemList(){const{VideoInfo:e}=await t.importAsync("video-info");const{getNumber:i}=await t.importAsync("get-number");const o=await Promise.all(this.items.map((async t=>{const o=new e(t);await o.fetchInfo();return o.pages.map(((e,a)=>({aid:t,cid:e.cid,titleParameters:{aid:t,cid:e.cid.toString(),n:i(a+1,o.pages.length),ep:o.pages.length>1?e.title:"",title:o.title},title:`P${a+1} ${e.title}`})))})));console.log("%cClass ManualInputBatch%c, data: ","color:yellow;",_.flatten(_.cloneDeep(o)));return _.flatten(o)}}const m=[p,l,c,s];let b;class u{constructor(e){i(this,"config",void 0);this.config=Object.assign({itemFilter:()=>true},e)}static async test(){for(const e of m){if(await e.test()===true){b=e;return true}}return false}getExtractor(){if(b===null){logError("[批量下载] 未找到合适的解析模块.");throw new Error(`[Batch Download] module not found.`)}const e=new b(this.config);return e}async getItemList(){const e=this.getExtractor();return await e.getItemList()}async getRawItems(e){const t=this.getExtractor();return await t.getRawItems(e.quality)}async collectData(e,t){const i=this.getExtractor();const o=await i.collectData(e.quality);t.dismiss();return o}async collectAria2(e,t,i=false){const o=this.getExtractor();const a=await o.collectAria2(e.quality,i);t.dismiss();return a}formatTitle(e){return n.formatTitle(e)}}return{export:{BatchExtractor:u,ManualInputBatch:d}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/batch-warning.min.js"]=(()=>(e,t)=>{const i=32;const o=412;const a=e=>{Toast.info(`为防止短时间内大量下载导致封禁, 请不要选择超过${i}的集数.`,e,5e3)};const r=()=>{throw new Error(`为防止短时间内大量下载导致封禁, 请不要选择超过${i}的集数.`)};const n=()=>{throw new Error(`短时间内下载量过大, 请过段时间再试.`)};return{export:{MaxBatchSize:i,BannedResponse:o,showBatchWarning:a,throwBatchError:r,throwBannedError:n}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/biliplus-redirect.min.js"]=(()=>(e,t)=>{const i=`www.biliplus.com`;const o=["bilibili.com/video/","bilibili.com/bangumi/play","space.bilibili.com"];return{widget:{condition:()=>o.some((e=>document.URL.includes(e))),content:`\n<a class="gui-settings-flat-button" id="biliplus-redirect">\n<i class="icon-biliplus"></i>\n<span>转到BiliPlus</span>\n</a>`,success:()=>{const e=document.querySelector("#biliplus-redirect");const t=/\/video\/(av[\d]+|BV.+)/i;const o=()=>{e.href="";e.disabled=true};const a=t=>{if(document.URL!==t){e.href=t}else{o()}};if(location.host==="space.bilibili.com"){const e=document.URL.replace("space.bilibili.com/",`${i}/space/`);a(e)}else if(document.URL.includes("/bangumi/play")){a(`https://${i}${window.location.pathname}${window.location.search}`);Observer.videoChange((()=>{const e=document.querySelector(".av-link,.info-sec-av");const t=unsafeWindow.aid||e.innerText.replace(/[aAvV]/g,"");const o=`https://${i}/video/av${t}/`;a(o)}))}else if(t.test(document.URL)){const[,e]=document.URL.match(t);a(`https://${i}/video/${e}/`)}else{Observer.videoChange((()=>{const e=document.URL.replace(window.location.host,i);a(e)}))}}}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blackboard.min.js"]=(()=>(e,t)=>{const i=async()=>{const e=4694;const t=`https://api.bilibili.com/x/web-show/res/locs?pf=0&ids=${e}`;const{code:i,message:o,data:a}=await Ajax.getJson(t);if(i!==0){throw new Error(`获取活动卡片失败: ${o}`)}const r=a[e];return r.map((e=>({url:e.url,title:e.name,isAd:e.is_ad_loc,imageUrl:e.pic})))};return{export:{getBlackboards:i}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blackboard.vue.min.js"]=(()=>(e,t)=>{const i=`<div class=blackboards><div class=header><div class=title>活动</div><a class=more href=https://www.bilibili.com/blackboard/x/act_list/ target=_blank><icon type=mdi icon=dots-horizontal></icon>更多</a></div><input class="hidden-input blackboard-radio"type=radio name=blackboard v-for="(b, i) of blackboards":checked="i === 0":id="'blackboard' + i":data-index=i :key=i><div class=blackboard-cards><a class=blackboard-card target=_blank v-for="(b, i) of blackboards":key=i :href=b.url :title=b.title><dpi-img :src=b.imageUrl :alt=b.title :size="{width: 500, height: 250}":root=cardsContainer></dpi-img><div class=title :title=b.title>{{b.title}}</div></a></div><div class=jump-dots><label v-for="(b, i) of blackboards":for="'blackboard' + i":key=i><div class=jump-dot></div></label></div></div>`;t.applyStyleFromText(`.simple-home .blackboards{position:relative;display:grid;grid-template-areas:"header header" "cards cards";grid-template-columns:8px 1fr;grid-template-rows:1fr 250px;row-gap:16px;column-gap:16px;align-self:start}.simple-home .blackboards .jump-dots{position:absolute;left:50%;bottom:0;transform:translateX(-50%);grid-area:cards;align-self:center;justify-self:center;display:flex;align-items:center}.simple-home .blackboards .jump-dots label{display:block;padding:8px 6px;cursor:pointer}.simple-home .blackboards .jump-dots .jump-dot{background-color:#8884;box-sizing:border-box;width:20px;height:8px;border-radius:8px}.simple-home .blackboards .blackboard-cards{display:flex;grid-area:cards;--blackboard-width:350px;--blackboard-height:250px;--image-height:197px;width:var(--blackboard-width);height:var(--blackboard-height);border-radius:16px;overflow:hidden;background-color:#fff;box-shadow:0 4px 8px 0 #0001}body.dark .simple-home .blackboards .blackboard-cards{background-color:#282828}.simple-home .blackboards .blackboard-cards .blackboard-card{flex:0 0 auto;width:100%;height:100%;position:relative;display:block;transition:.8s cubic-bezier(.44,.29,.13,1)}.simple-home .blackboards .blackboard-cards .blackboard-card img{width:100%;height:var(--image-height);object-fit:fill;display:block;border-radius:12px;transition-duration:inherit}.simple-home .blackboards .blackboard-cards .blackboard-card .title{position:absolute;bottom:24px;left:50%;transform:translateX(-50%);padding:0 16px;font-size:14px;font-weight:700;border-radius:14px;max-width:var(--blackboard-width);box-sizing:border-box;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}`,"blackboard-style");return{export:Object.assign({template:i},{components:{Icon:()=>t.importAsync("icon.vue"),"dpi-img":()=>t.importAsync("dpi-img.vue")},data(){return{blackboards:[],interval:0}},destroyed(){if(this.interval){clearInterval(this.interval)}},computed:{cardsContainer(){return this.$el.querySelector(".blackboard-cards")}},async mounted(){const{getBlackboards:e}=await t.importAsync("blackboard");this.blackboards=(await e()).filter((e=>!e.isAd));const i=dq(".blackboards");this.interval=setInterval((()=>{if(!document.hasFocus()||i.matches(".blackboards:hover")){return}const e=parseInt(dq(`.blackboard-radio:checked`).getAttribute("data-index"));let t;if(e===this.blackboards.length-1){t=0}else{t=e+1}dq(`.blackboard-radio[data-index='${t}']`).checked=true}),5e3)}})}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blur-video-control.min.css"]=`.video-control-blur-layer{width:100%;height:100%;position:absolute;-webkit-backdrop-filter:blur(48px);backdrop-filter:blur(48px);z-index:-1;top:0}.bilibili-player-video-control-mask{background:0 0!important}.bilibili-player-video-control-bottom,.bui-slider .bui-track.bui-track-video-progress .bui-bar-wrap{background-color:transparent!important}.bilibili-player-video-control-bottom{position:relative}.bilibili-player-area .bilibili-player-video-control-bottom,.bilibili-player-area .bilibili-player-video-control-wrap{transition:none!important}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/blur-video-control.min.js"]=(()=>(e,t)=>{const i=async()=>{const e=await SpinQuery.count(".bui-slider .bui-track.bui-track-video-progress,.bilibili-player-video-control-bottom",2);e.forEach((e=>{if(!e.classList.contains("video-control-blur-container")){e.classList.add("video-control-blur-container");e.insertAdjacentHTML("afterbegin",`<div class="video-control-blur-layer"></div>`)}}))};t.applyStyle("blurVideoControlStyle");Observer.videoChange(i);return{reload:()=>{document.querySelectorAll(".video-control-blur-layer").forEach((e=>e.style.display="block"));t.applyStyle("blurVideoControlStyle")},unload:()=>{document.querySelectorAll(".video-control-blur-layer").forEach((e=>e.style.display="none"));t.removeStyle("blurVideoControlStyle")}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/bpx-player-adaptor.min.js"]=(()=>(e,t)=>{const i=async()=>{const e=await SpinQuery.select(".bpx-player-container");if(!e){console.warn("[bpx player polyfill] bpxContainer not found");return}Observer.attributes(e,(()=>{const t=e.getAttribute("data-screen");document.body.classList.toggle("player-mode-webfullscreen",t==="full"||t==="web");t==="wide"?document.body.classList.add("player-mode-widescreen"):""}))};const o=async()=>{const e=await SpinQuery.select((()=>unsafeWindow.$pbp));if(!e){console.warn("[bpx player polyfill] pbp not found");return}const t={aid:e.options.aid.toString(),cid:e.options.cid.toString(),bvid:e.options.bvid};if(Object.values(t).some((e=>e===""||parseInt(e)<=0))){console.warn("[bpx player polyfill] invalid pbp data")}Object.assign(unsafeWindow,t)};const a=async()=>{if(!document.URL.startsWith("https://www.bilibili.com/bangumi/play/")){return}i();o()};return{export:{bpxPlayerPolyfill:a}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/bvid-convert.min.css"]=`.bvid-convert{border:2px solid #8882;border-radius:8px;padding:6px 8px;margin:4px 0;order:-1;width:auto;box-sizing:border-box;user-select:text}.bvid-convert-item{font-size:14px;display:flex;align-items:center}.bvid-convert .mdi{font-size:15px;padding:1px;margin-left:4px;cursor:pointer;line-height:1;display:inline-flex}.bvid-convert .mdi.mdi-link::before{transform:rotate(135deg)}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/bvid-convert.min.js"]=(()=>(e,t)=>{const i=["https://www.bilibili.com/video/","https://www.bilibili.com/bangumi/"].some((e=>document.URL.startsWith(e)));if(e.preferAvUrl&&document.URL.startsWith("https://www.bilibili.com/video/")){SpinQuery.select((()=>unsafeWindow.aid)).then((e=>{if(!e){return}if(document.URL.includes("videocard_series")){console.log("skip video series");return}const t=document.URL.replace(/\/(video|bangumi)\/(BV[\w]+)/i,((t,i)=>`/${i}/av${e}`));if(document.URL!==t){history.replaceState({},document.title,t)}}))}return{widget:{content:`<div class="bvid-convert"></div>`,condition:async()=>{if(i){return Boolean(await SpinQuery.select((()=>unsafeWindow.aid||unsafeWindow.bvid)))}else{return false}},success:()=>{t.applyStyle("bvidConvertStyle");const e=(e,t)=>{if(!e||!t){return""}return`\n<div class="bvid-convert-item">av${e}<i class="mdi mdi-link aid"></i></div>\n<div class="bvid-convert-item">${t}<i class="mdi mdi-link bvid"></i></div>\n`};const i=dq(".bvid-convert");i.addEventListener("click",(e=>{const t=e.target;const i=t.classList;if(i.contains("mdi")){if(i.contains("mdi-check")){return}const e=t.previousSibling;if(e){const t=window.location.search?`?${window.location.search}`:"";GM.setClipboard(`https://www.bilibili.com/video/${e.textContent}${t}`,"text");i.remove("mdi-link");i.add("mdi-check");setTimeout((()=>{i.remove("mdi-check");i.add("mdi-link")}),1e3)}}}));const o=async()=>{const t=dq(".bvid-convert");t.innerHTML=e(unsafeWindow.aid,unsafeWindow.bvid);const i=await SpinQuery.select(".av-link,.bv-link,.bvid-link");if(i){t.innerHTML=e(unsafeWindow.aid,i.innerHTML)}};Observer.videoChange(o)}}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/category-regions.min.js"]=(()=>(e,t)=>{const i={anime:1,bangumi:13,china:167,manga:-1,music:3,dance:129,game:4,knowledge:36,tech:188,life:160,food:211,animal:217,kichiku:119,fashion:155,information:202,entertainment:5,column:-1,movie:181,tv:11,film:23,documentary:177};const o={anime:"v/douga",bangumi:"anime",china:"guochuang",manga:"",music:"v/music",dance:"v/dance",game:"v/game",knowledge:"v/knowledge",tech:"v/tech",life:"v/life",food:"v/food",animal:"v/animal",kichiku:"v/kichiku",fashion:"v/fashion",information:"v/information/",entertainment:"v/ent",column:"",movie:"v/cinephile",tv:"tv",film:"cinema",documentary:"documentary"};return{export:{RegionCodes:i,RegionLinks:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/check-in-center.min.js"]=(()=>(e,t)=>{const i=[{id:"seeds-to-coins",icon:"mdi-seed-outline",name:"瓜子换硬币",action:async()=>{const e="https://api.live.bilibili.com/xlive/revenue/v1/wallet/silver2coin";const t=await Ajax.postTextWithCredentials(e,formData({csrf:getCsrf(),csrf_token:getCsrf()}));const i=JSON.parse(t);if(i.code!==0){Toast.info(i.message,"瓜子换硬币",3e3)}else{Toast.success(`${i.message}\n剩余银瓜子:${i.data.silver}`,"瓜子换硬币",3e3)}}},{id:"live-check-in",icon:"mdi-calendar-check",name:"直播间签到",action:async()=>{const e="https://api.live.bilibili.com/xlive/web-ucenter/v1/sign/DoSign";const t=await Ajax.getJsonWithCredentials(e);if(t.code!==0){Toast.info(t.message,"直播间签到",3e3)}else{const{text:e,specialText:i,allDays:o,hadSignDays:a}=t.data;const r=`签到成功, 获得了${e} ${i}\n本月进度: ${a} / ${o}`;Toast.success(r,"直播间签到",3e3)}}}];return{widget:{content:i.map((e=>`\n<button\n          class="gui-settings-flat-button"\n          id="${e.id}">\n<i class="mdi mdi-24px ${e.icon}"></i>\n<span>${e.name}</span>\n</button>\n`)).join("\n"),condition:()=>Boolean(getUID()),success:()=>{i.forEach((e=>{const t=document.getElementById(e.id);if(!t){return}t.addEventListener("click",(i=>{try{t.disabled=true;e.action(t,i)}finally{t.disabled=false}}))}))}}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/clear-cache.min.js"]=(()=>(e,t)=>({widget:{content:`\n<button\n        class="gui-settings-flat-button"\n        id="clear-cache">\n<i class="icon-clear"></i>\n<span>清除缓存</span>\n</button>`,condition:()=>typeof offlineData==="undefined",success:()=>{var t;(t=dq("#clear-cache"))===null||t===void 0?void 0:t.addEventListener("click",(()=>{e.cache={};Toast.success("已删除全部缓存.","清除缓存",5e3)}))}}}))();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/collapse-live-side-bar.min.css"]=`.side-bar-cntr{transition:.24s ease-out!important;overflow:visible!important;transform:translateZ(0) translateX(100%)!important}.side-bar-cntr:hover{transform:translateZ(0)!important}.side-bar-cntr::after{right:calc(100% + 4px);transform:translateY(-50%) rotate(45deg);width:8px;height:8px;border-radius:2px;box-sizing:border-box;border:4px solid #aaa;border-top-color:transparent;border-right-color:transparent}body.dark .side-bar-cntr::after{border:4px solid #eee;border-top-color:transparent;border-right-color:transparent}.side-bar-cntr::before{right:calc(100% - 8px);transform:translateY(-50%);width:32px;height:48px;border-radius:8px 0 0 8px;background-color:#fff;border:1px solid #e9eaec}body.dark .side-bar-cntr::before{background-color:#222;border-color:transparent}.side-bar-cntr::after,.side-bar-cntr::before{content:"";transition:.24s ease-out;cursor:pointer;position:fixed;top:50%}.side-bar-cntr:hover::after,.side-bar-cntr:hover::before{opacity:0}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/collapse-live-side-bar.min.js"]=(()=>(e,t)=>t.toggleStyle("collapseLiveSideBarStyle"))();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/column-image-exporter.min.js"]=(()=>(e,t)=>({widget:{condition:()=>document.URL.startsWith("https://www.bilibili.com/read/cv"),content:`\n<button class="gui-settings-flat-button column-image-export">\n<i class="mdi mdi-24px mdi-export"></i>\n<span>导出图片</span>\n</button>`,success:()=>{const e=dq(".column-image-export");const i=dq(e,"span");e.addEventListener("click",(async()=>{try{e.disabled=true;i.textContent="下载中...";const o=[];const a=document.title.replace(/ - 哔哩哔哩$/,"");const r=dq(".banner-image .card-image__image");const n=retrieveImageUrl(r);if(n){o.push({...n,name:`${a}-banner${n.extension}`})}const l=dqa('.article-content .img-box img:not([class*="cut-off-"])');l.forEach((e=>{const t=retrieveImageUrl(e);if(t){o.push({...t,name:`${a}-${o.length}${t.extension}`})}}));if(o.length===0){Toast.info("此专栏没有检测到任何图片.","专栏图片导出");return}const{DownloadPackage:c}=await t.importAsync("download-package");const s=await Promise.all(o.map((({url:e})=>Ajax.getBlob(e))));const p=new c;s.forEach(((e,t)=>p.add(o[t].name,e)));await p.emit(`${a}.zip`)}catch(e){logError(e)}finally{i.textContent="导出图片";e.disabled=false}}))}}}))();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/combo-like.min.js"]=(()=>(e,t)=>{(async()=>{const e=await SpinQuery.select((()=>document.querySelector(".ops span.like")));if(!e){return}e.style.userSelect="none";function t(t,i){const o=new CustomEvent(t,i);e.dispatchEvent(o)}const i=200;let o=true;e.addEventListener("touchstart",(e=>{e.preventDefault();o=true;setTimeout((()=>o=false),i);t("mousedown",e)}));e.addEventListener("touchend",(e=>{e.preventDefault();t("mouseup",e);if(o){t("click",e)}}))})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comment.min.css"]=`.bb-comment .comment-send-lite{position:-webkit-sticky!important;position:sticky!important;bottom:0!important;background:linear-gradient(to top,#fff,rgba(255,255,255,0))!important;pointer-events:none;width:calc(100% + 12px)!important;margin:0 0 0 -12px!important;padding-left:97px!important}body.dark .bb-comment .comment-send-lite{background:linear-gradient(to top,#222,rgba(255,255,255,0))!important}.bb-comment .comment-send-lite .comment-emoji-lite{background-color:#fff}.bb-comment .comment-send-lite .comment-submit{height:64px!important;padding:4px 15px!important;position:relative!important;right:0!important;margin-left:10px!important}.bb-comment .comment-send-lite .textarea-container .baffle{line-height:65px!important}.bb-comment .comment-send-lite .textarea-container .baffle,.bb-comment .comment-send-lite .textarea-container .ipt-txt{height:65px!important;width:calc(100% - 80px)!important}.bb-comment .comment-send-lite>*{pointer-events:initial}.bb-comment .loading-state{font-size:14px!important;height:1.4em!important;line-height:1.4!important;margin:12px 0!important}.bb-comment .loading-state+.bottom-page{margin:0!important}.bb-comment .comment-header .tabs-order li.on::after,.bb-comment .medal-level,.bb-comment .nameplate,.bb-comment .reply-notice,.bb-comment .sailing,.bb-comment .true-love{display:none!important}.bb-comment .comment-send .comment-emoji,.bb-comment .comment-send-lite .comment-emoji{box-shadow:none!important}.bb-comment .comment-send .comment-emoji span,.bb-comment .comment-send-lite .comment-emoji span{opacity:.4;color:#000}.bb-comment .comment-send .comment-emoji .face,.bb-comment .comment-send-lite .comment-emoji .face{transition:.2s ease-out;height:16px!important;width:16px!important;opacity:.4;display:inline-flex!important;background:0 0!important;color:#000}body.dark .bb-comment .comment-send .comment-emoji .face,body.dark .bb-comment .comment-send-lite .comment-emoji .face{color:#eee}.bb-comment .comment-send .comment-emoji .face::before,.bb-comment .comment-send-lite .comment-emoji .face::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.bb-comment .comment-send .comment-emoji .text,.bb-comment .comment-send-lite .comment-emoji .text{transition:.2s ease-out}body.dark .bb-comment .comment-send .comment-emoji .text,body.dark .bb-comment .comment-send-lite .comment-emoji .text{filter:brightness(0) invert(1)!important}.bb-comment .comment-send .comment-emoji.open .face,.bb-comment .comment-send .comment-emoji.open span,.bb-comment .comment-send .comment-emoji:hover .face,.bb-comment .comment-send .comment-emoji:hover span,.bb-comment .comment-send-lite .comment-emoji.open .face,.bb-comment .comment-send-lite .comment-emoji.open span,.bb-comment .comment-send-lite .comment-emoji:hover .face,.bb-comment .comment-send-lite .comment-emoji:hover span{opacity:1}.bb-comment .comment-list .list-item{position:relative}.bb-comment .comment-list .list-item .info{margin-top:0!important;display:flex;align-items:center}.bb-comment .comment-list .list-item .info .floor{opacity:.7;order:1}.bb-comment .comment-list .list-item .info .reply{order:2}.bb-comment .comment-list .list-item .info .reply-tags{order:3;display:flex!important;margin:0!important}.bb-comment .comment-list .list-item .info .reply-tags span{margin:0 4px 0 0!important;font-size:12px!important;line-height:normal!important;display:flex!important;height:auto!important;padding:2px 6px!important}.bb-comment .comment-list .list-item .info .operation{order:4;flex-grow:1;display:flex!important;justify-content:flex-end;margin:0!important;padding:0!important}.bb-comment .comment-list .list-item .info .hate i,.bb-comment .comment-list .list-item .info .like i{transition:.2s ease-out;height:16px!important;width:16px!important;opacity:.4;display:inline-flex!important}.bb-comment .comment-list .list-item .info .hate span,.bb-comment .comment-list .list-item .info .like span{opacity:.4;transition:.2s ease-out;color:#000}body.dark .bb-comment .comment-list .list-item .info .hate span,body.dark .bb-comment .comment-list .list-item .info .like span{color:#eee!important}.bb-comment .comment-list .list-item .info .hate.hated>*,.bb-comment .comment-list .list-item .info .hate.liked>*,.bb-comment .comment-list .list-item .info .hate:hover>*,.bb-comment .comment-list .list-item .info .like.hated>*,.bb-comment .comment-list .list-item .info .like.liked>*,.bb-comment .comment-list .list-item .info .like:hover>*{opacity:1}.bb-comment .comment-list .list-item .info .like i{background:0 0!important;color:#000}body.dark .bb-comment .comment-list .list-item .info .like i{color:#eee}.bb-comment .comment-list .list-item .info .like i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.bb-comment .comment-list .list-item .info .like.liked i,.bb-comment .comment-list .list-item .info .like.liked:hover i{background:0 0!important;color:#000}body.dark .bb-comment .comment-list .list-item .info .like.liked i,body.dark .bb-comment .comment-list .list-item .info .like.liked:hover i{color:#eee}.bb-comment .comment-list .list-item .info .like.liked i::before,.bb-comment .comment-list .list-item .info .like.liked:hover i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.bb-comment .comment-list .list-item .info .like.liked i,.bb-comment .comment-list .list-item .info .like.liked i+span,.bb-comment .comment-list .list-item .info .like.liked:hover i,.bb-comment .comment-list .list-item .info .like.liked:hover i+span,body.dark .bb-comment .comment-list .list-item .info .like.liked i,body.dark .bb-comment .comment-list .list-item .info .like.liked:hover i{color:var(--theme-color)!important}.bb-comment .comment-list .list-item .info .hate i{background:0 0!important;color:#000}body.dark .bb-comment .comment-list .list-item .info .hate i{color:#eee}.bb-comment .comment-list .list-item .info .hate i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.bb-comment .comment-list .list-item .info .hate.hated i,.bb-comment .comment-list .list-item .info .hate.hated:hover i{background:0 0!important;color:#000}body.dark .bb-comment .comment-list .list-item .info .hate.hated i,body.dark .bb-comment .comment-list .list-item .info .hate.hated:hover i{color:#eee}.bb-comment .comment-list .list-item .info .hate.hated i::before,.bb-comment .comment-list .list-item .info .hate.hated:hover i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.bb-comment .comment-list .list-item .info .hate.hated i,.bb-comment .comment-list .list-item .info .hate.hated i+span,.bb-comment .comment-list .list-item .info .hate.hated:hover i,.bb-comment .comment-list .list-item .info .hate.hated:hover i+span,body.dark .bb-comment .comment-list .list-item .info .hate.hated i,body.dark .bb-comment .comment-list .list-item .info .hate.hated:hover i{color:var(--theme-color)!important}.bb-comment .comment-list .list-item .info .btn-hover{padding:3px 5px!important}.bb-comment .comment-list .list-item .info .operation:hover{background:0 0!important}.bb-comment .comment-list .list-item .info .operation .spot{transition:.2s ease-out;height:16px!important;width:16px!important;opacity:.4;display:inline-flex!important;background:0 0!important;color:#000}body.dark .bb-comment .comment-list .list-item .info .operation .spot{color:#eee;filter:brightness(0) invert(1)!important}.bb-comment .comment-list .list-item .info .operation .spot::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.bb-comment .comment-list .list-item .info .operation .spot:hover{opacity:1}.bb-comment .comment-list .list-item .text{white-space:pre-wrap}.bb-comment .comment-list .list-item .user{margin-right:120px}.bb-comment .comment-list .list-item .user .level{visibility:hidden;width:0;margin:0}.bb-comment .comment-list .list-item .user .text-con{white-space:pre-wrap;display:block;margin:0!important}.bb-comment .comment-list .list-item .con .vote-container,.bb-comment .comment-list .list-item .user-face .hot-follow,.bb-comment .comment-list .list-item>.con .level-link{display:none!important}.bb-comment .comment-list .list-item>.con>.reply-box{transform:translateX(0)}.bb-comment .comment-list .list-item>.con>.info{margin-top:4px}.bb-comment .comment-list .list-item>.con>.info>.time{opacity:.7;position:absolute;right:8px;top:24px;margin:0!important;line-height:normal;color:#000}body.dark .bb-comment .comment-list .list-item>.con>.info>.floor,body.dark .bb-comment .comment-list .list-item>.con>.info>.time{filter:brightness(0) invert(1)!important}.bb-comment .comment-list .list-item>.con>.info>.plad{display:none!important}.bb-comment .comment-list .reply-con{position:relative}.bb-comment .comment-list .reply-con>.info>.time{position:absolute;right:8px;top:0;margin:0;opacity:.5;line-height:normal;color:#000}body.dark .bb-comment .comment-list .reply-con>.info>.time{filter:brightness(0) invert(1)!important}.bb-comment .reply-item{position:relative}.bb-comment .reply-item>.info>.time{opacity:.7}body.dark .bb-comment .reply-item>.info>.time{filter:brightness(0) invert(1)!important}.bb-comment .reply-notice .notice-item{background-color:#0001!important;border:none!important;display:flex!important;align-items:center;padding:10px 14px!important}body.dark .bb-comment .reply-notice .notice-item{background-color:#333!important}.bb-comment .reply-notice .notice-item .icon-notice{order:0;position:static!important;margin-right:12px;background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="18" height="18" viewBox="0 0 24 24"><path fill="black" d="M20,11H4V8H20M20,15H13V13H20M20,19H13V17H20M11,19H4V13H11M20.33,4.67L18.67,3L17,4.67L15.33,3L13.67,4.67L12,3L10.33,4.67L8.67,3L7,4.67L5.33,3L3.67,4.67L2,3V19A2,2 0 0,0 4,21H20A2,2 0 0,0 22,19V3L20.33,4.67Z" /></svg>')!important}.bb-comment .reply-notice .notice-item a{order:1;flex-grow:1;color:#000!important}body.dark .bb-comment .reply-notice .notice-item a{color:#eee!important}.bb-comment .reply-notice .notice-item .icon-close-notice{order:2;position:static!important;background:url('data:image/svg+xml;utf-8,<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="18" height="18" viewBox="0 0 24 24"><path fill="black" d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z" /></svg>')!important}.bb-comment .reply-notice .notice-item .icon-close-notice,.bb-comment .reply-notice .notice-item .icon-notice{height:18px;width:18px;background-position:center!important;opacity:.4}.bb-comment .comment-send:not(.no-login){position:relative!important}.bb-comment .comment-send-lite:not(.no-login),.bb-comment .comment-send:not(.no-login){padding-top:15px!important}.bb-comment .comment-send-lite:not(.no-login) .dynamic-repost,.bb-comment .comment-send:not(.no-login) .dynamic-repost{margin-left:85px!important;margin-top:4px}.bb-comment .comment-send-lite:not(.no-login) .comment-emoji,.bb-comment .comment-send:not(.no-login) .comment-emoji{position:absolute!important;right:0;top:51px;width:68px!important;background:#fff}.bb-comment .comment-send-lite:not(.no-login) .comment-submit,.bb-comment .comment-send:not(.no-login) .comment-submit{height:34px!important;font-size:0}.bb-comment .comment-send-lite:not(.no-login) .comment-submit body.dark,.bb-comment .comment-send:not(.no-login) .comment-submit body.dark{color:var(--theme-color)!important}.bb-comment .comment-send-lite:not(.no-login) .comment-submit::after,.bb-comment .comment-send:not(.no-login) .comment-submit::after{content:"发表";color:#fff;position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);font-size:14px}body.dark .bb-comment .comment-send-lite:not(.no-login) .comment-submit::after,body.dark .bb-comment .comment-send:not(.no-login) .comment-submit::after{color:var(--foreground-color)}body.dark .panel-area .bb-comment .comment-send-lite{background:linear-gradient(to top,#444 30%,transparent)!important}.dynamic-list-item-wrap .info .plat{display:none!important}.dynamic-list-item-wrap .reply-box .time{position:absolute;right:8px;margin:0;opacity:.5;line-height:normal;color:#000;top:10px;opacity:.7}.dynamic-list-item-wrap .reply-item>.info{display:flex;align-items:center}.dynamic-list-item-wrap .reply-item>.info .floor{opacity:.7;order:1}.dynamic-list-item-wrap .reply-item>.info .reply{order:2}.dynamic-list-item-wrap .reply-item>.info .reply-tags{order:3;display:flex!important;margin:0!important}.dynamic-list-item-wrap .reply-item>.info .reply-tags span{margin:0 4px 0 0!important;font-size:12px!important;line-height:normal!important;display:flex!important;height:auto!important;padding:2px 6px!important}.dynamic-list-item-wrap .reply-item>.info .operation{order:4;flex-grow:1;display:flex!important;justify-content:flex-end;margin:0!important;padding:0!important}.reply-item>.info>.time{position:absolute;right:8px;margin:0!important;line-height:normal;color:#000;top:12px;opacity:1}.reply-box .item-user>a{margin-right:8px}.reply-box .item-user .text{display:block}.comment-area .dynamic-level{display:none!important}.dynamic-hate i,.dynamic-like i{transition:.2s ease-out}.dynamic-like i{background:0 0!important;color:#000}body.dark .dynamic-like i{color:#eee}.dynamic-like i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.dynamic-like:hover i{background:0 0!important;color:#000}body.dark .dynamic-like:hover i{color:#eee}.dynamic-like:hover i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.dynamic-like:hover i,.dynamic-like:hover i+span,body.dark .dynamic-like:hover i{color:var(--theme-color)!important}.dynamic-liked i,.dynamic-liked:hover i{background:0 0!important;color:#000}body.dark .dynamic-liked i,body.dark .dynamic-liked:hover i{color:#eee}.dynamic-liked i::before,.dynamic-liked:hover i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.dynamic-liked i,.dynamic-liked i+span,.dynamic-liked:hover i,.dynamic-liked:hover i+span,body.dark .dynamic-liked i,body.dark .dynamic-liked:hover i{color:var(--theme-color)!important}.dynamic-hate i{background:0 0!important;color:#000}body.dark .dynamic-hate i{color:#eee}.dynamic-hate i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.dynamic-hate:hover i{background:0 0!important;color:#000}body.dark .dynamic-hate:hover i{color:#eee}.dynamic-hate:hover i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.dynamic-hate:hover i,.dynamic-hate:hover i+span,body.dark .dynamic-hate:hover i{color:var(--theme-color)!important}.dynamic-hated i,.dynamic-hated:hover i{background:0 0!important;color:#000}body.dark .dynamic-hated i,body.dark .dynamic-hated:hover i{color:#eee}.dynamic-hated i::before,.dynamic-hated:hover i::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.dynamic-hated i,.dynamic-hated i+span,.dynamic-hated:hover i,.dynamic-hated:hover i+span,body.dark .dynamic-hated i,body.dark .dynamic-hated:hover i{color:var(--theme-color)!important}.dynamic-spot{background:0 0!important;color:#000}body.dark .dynamic-spot{color:#eee;filter:brightness(0) invert(1)!important}.dynamic-spot::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.textarea-container .comm-tool .comm-emoji .icon-face{background:0 0!important;color:#000}body.dark .textarea-container .comm-tool .comm-emoji .icon-face{color:#eee;filter:brightness(0) invert(1)!important}.textarea-container .comm-tool .comm-emoji .icon-face::before{content:"";display:inline-block;font:16px/1 "Material Design Icons";width:16px;height:16px}.dynamic-spot,.textarea-container .comm-tool .comm-emoji .icon-face{height:16px!important;width:16px!important;background-position:center!important;opacity:.4;display:inline-flex!important}.comment-list .opera-list{right:20px!important;top:-72px!important}.v-wrap #comment{z-index:21!important}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comment.min.js"]=(()=>(e,t)=>{addSettingsListener("useCommentStyle",(e=>{document.body.classList.toggle("simplify-comment",e)}),true);return t.toggleStyle("useCommentStyleStyle")})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comment-apis.min.js"]=(()=>(e,t)=>{const i="bb-comment";const o=[];const a=[];const r=[];const n=[];const l=e=>{const t=e.querySelector(".con .user .name");const i=e=>{const t=e.querySelector(".reply-face");const i=e.querySelector(".reply-con .user .name");return{id:e.getAttribute("data-id"),element:e,userID:t.getAttribute("data-usercard-mid"),userName:i.textContent,content:e.querySelector(".text-con").textContent,timeText:e.querySelector(".info .time").textContent,likes:parseInt(e.querySelector(".info .like span").textContent)}};const o={id:e.getAttribute("data-id"),element:e,userID:t.getAttribute("data-usercard-mid"),userName:t.textContent,content:e.querySelector(".con .text").textContent,timeText:e.querySelector(".con .info .time").textContent,likes:parseInt(e.querySelector(".con .like span").textContent),replies:[]};if(dq(e,".reply-box .view-more")){const t=dq(e,".reply-box");Observer.childList(t,(t=>{o.replies=dqa(e,".reply-box .reply-item").map(i);if(t.length!==0){o.onRepliesUpdate&&o.onRepliesUpdate(o.replies)}}))}else{o.replies=dqa(e,".reply-box .reply-item").map(i)}return o};const c=e=>{if(e.observer){return}e.items=dqa(e.element,".list-item.reply-wrap").map(l);e.items.forEach((e=>{a.forEach((t=>t(e)))}));e.observer=Observer.childListSubtree(e.element,(t=>{t.forEach((t=>{const i=e=>e instanceof HTMLElement&&e.classList.contains("list-item")&&e.classList.contains("reply-wrap");t.addedNodes.forEach((t=>{if(i(t)){const i=l(t);e.items.push(i);a.forEach((e=>e(i)))}}));t.removedNodes.forEach((t=>{if(i(t)){const i=t.getAttribute("data-id");const o=e.items.findIndex((e=>e.id===i));if(o!==-1){const[t]=e.items.splice(o,1);r.forEach((e=>e(t)))}}}))}))}))};const s=e=>{if(e instanceof HTMLElement&&e.classList.contains(i)){const t={element:e,items:[]};o.push(t);c(t);n.forEach((e=>e(t)))}};const p=e=>{o.forEach((t=>e(t)));n.push(e)};const d=e=>{const{added:t,removed:i}=e;p((e=>{if(t){e.items.forEach((e=>t(e)));a.push(t)}if(i){r.push(i)}}))};Observer.childListSubtree(document.body,(e=>{e.forEach((e=>{e.addedNodes.forEach((e=>s(e)))}))}));dqa("."+i).forEach(s);return{export:{commentAreas:o,forEachCommentArea:p,forEachCommentItem:d}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comment-dark.min.css"]=`.bb-comment .comment-list .list-item .info .hate.hated>i,.bb-comment .comment-list .list-item .info .hate>i,.bb-comment .comment-list .list-item .info .like.liked>i,.bb-comment .comment-list .list-item .info .like>i,.bb-comment .comment-list .list-item .info .operation .spot,.bb-comment .comment-list .list-item>.con>.info>.floor,.bb-comment .comment-list .list-item>.con>.info>.time,.bb-comment .comment-list .reply-con>.info>.time,.bb-comment .comment-send .comment-emoji .text,.dynamic-hate i,.dynamic-hate:hover i,.dynamic-hated i,.dynamic-hated:hover i,.dynamic-like i,.dynamic-like:hover i,.dynamic-liked i,.dynamic-liked:hover i,.dynamic-spot,.textarea-container .comm-tool .comm-emoji .icon-face{filter:brightness(0) invert(1)!important}.bb-comment .comment-list .list-item .info .hate span,.bb-comment .comment-list .list-item .info .hate.hated span,.bb-comment .comment-list .list-item .info .hate:hover span,.bb-comment .comment-list .list-item .info .like span,.bb-comment .comment-list .list-item .info .like.liked span,.bb-comment .comment-list .list-item .info .like:hover span{color:#eee!important}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/comments-translate.min.js"]=(()=>(e,t)=>{const i=async()=>{const{getTranslator:i}=await t.importAsync("feeds-translate-providers");const o=Vue.extend({template:`\n<div class="translate-container">\n<div class="translate" v-if="!working && !translated" @click="translate()">\n<i class="mdi mdi-earth"></i>翻译\n</div>\n<i v-if="working" class="translating mdi mdi-18px mdi-loading mdi-spin"></i>\n<div class="translated" v-if="translated">翻译自<a :href="activeTranslator.link" target="_blank">{{ activeTranslator.name }}</a>:</div>\n<div v-if="translated" class="translate-result">{{ result }}</div>\n</div>\n`,props:{text:{type:String,required:true}},data(){return{result:"",working:false,activeTranslator:{}}},computed:{translated(){return this.result!==""}},methods:{async translate(){try{this.working=true;const t=this.text;const o=this.activeTranslator=i();this.result=await o.translate(t,{targetLanguage:(()=>{if(e.i18n){return languageNameToCode[e.i18nLanguage]}if(e.feedsTranslateLanguage!==""){return e.feedsTranslateLanguage}return})()});console.log(t,o,this.result)}catch(e){logError(e)}finally{this.working=false}}}});const a=e=>{const t=dqa(e,".text, .text-con");if(t.length===0){return}t.forEach((e=>{if(e.nextElementSibling&&e.nextElementSibling.classList.contains("translate-container")){return}const t=new o({propsData:{text:e.innerText}}).$mount();e.insertAdjacentElement("afterend",t.$el)}))};const{forEachCommentItem:r}=await t.importAsync("comment-apis");r({added:e=>{const{element:t}=e;e.onRepliesUpdate=e=>e.forEach((e=>a(e.element)));a(t)}})};if(e.feedsTranslate){t.applyStyle("feedsTranslateStyle");i()}return{export:{commentsTranslate:i}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/compact-layout.min.css"]=`.groom-module{margin:0!important;width:192px!important;height:120px!important}.primary-menu .nav-menu .side-nav .side-link i,.primary-menu .nav-menu>li.home>a{opacity:.4}body.dark .primary-menu .nav-menu .side-nav .side-link i,body.dark .primary-menu .nav-menu>li.home>a{opacity:1}.bangumi-timing-module .card-timing,.groom-module{-webkit-tap-highlight-color:transparent}.chief-recommend-module .recommend-module,.groom-box-m,.nominate-m .video-card-box{height:240px!important}.groom-module .lazy-img,.groom-module .pic{width:100%!important;height:100%!important}.groom-module:hover .lazy-img,.groom-module:hover .pic{filter:blur(8px)}.groom-module .card-mark{width:calc(100% - 20px)!important;top:88px;padding:10px!important}.groom-module:hover .card-mark{top:0!important}.chief-recommend-module .carousel-box,.chief-recommend-module .carousel-box img{height:240px!important;width:480px!important}.nominate-m .carousel-box,.nominate-m .carousel-box img{height:240px!important;width:672px!important}.live-module .storey-box .card-live-module,.special-module,.storey-box .spread-module,.video-item-biref{margin:0!important;width:192px!important;height:168px!important;-webkit-tap-highlight-color:transparent}.special-module{height:192px!important}.special-module .pic .title{line-height:unset!important;height:auto!important}.special-recommend-module .storey-box{height:180px!important}.special-module .user{transform:translatey(24px)}.live-module .storey-box .card-live-module .pic,.mod-1 .l .spread-module,.mod-2 .spread-module,.mod-2 li .l,.mod-3 .l .spread-module,.mod-3 .l-item .l,.special-module .pic-box,.spread-module .pic,.video-item-biref .biref-img{width:192px!important;height:120px!important}.mod-2 li .l-item{height:auto}.mod-3 .l-item,.mod-3 li{width:192px!important}.mod-3 .l .spread-module{margin:0!important}.mod-1 .r,.mod-1 li,.mod-2 li .l-item,.mod-3 li{padding:0!important}.mod-3 .r .title,.mod-3 .r .up-info,.mod-3 .r .v-info{padding-top:4px!important;margin-top:0!important}.mod-2 li .r .v-desc{padding:0!important;margin:10px 0!important}.live-module .storey-box .card-live-module .num,.spread-module .num{padding-left:8px;padding-right:8px;bottom:6px}.live-module .storey-box .card-live-module .t,.special-module .pic .title,.spread-module .t,.video-item-biref .biref-info .biref-title{padding-left:4px;padding-right:4px;padding-top:4px}.sec-rank .rank-list-wrap .rank-list{min-height:288px}.hot-recom-module{height:auto!important}.game-groom-box-m,.game-groom-box-m .game-groom-m{height:100%!important}.article-card .article-cover,.article-card .article-cover img,.card-live-module .pic .mask,.carousel-box .carousel-module .panel,.carousel-wrapper,.game-groom-box-m .game-groom-m,.groom-module,.live-module .storey-box .card-live-module .pic,.mod-3 .l-item,.rank-item .content .img .cover img,.special-module .pic-box,.spread-module .pic,.video-item-biref .biref-img{border-radius:8px!important}.article-rank-list .rank-item .ri-num,.card-timing-module .pic,.rank-list .rank-item .ri-num,.timeline-box .timeline-item .preview,.timeline-box .timeline-item .preview img{border-radius:50%!important}.cover-preview-module .cover{width:160px;transform-origin:left top 0;transform:scale(1.3)}.bangumi-timing-module .card-timing{width:205px}.card-timing-module .r-text{width:120px}.recommend-module .rec-btn.prev{left:0!important}.primary-menu{display:flex;align-items:center;margin:0;width:100%}.primary-menu .nav-menu{flex:1 0 auto;display:flex;justify-content:space-between;align-items:center;margin-right:28px}.primary-menu .nav-menu>li .num-wrap span{padding:2.5px;line-height:unset;height:auto;min-width:30px}.primary-menu .nav-menu .side-nav .side-link i.blackroom,.primary-menu .nav-menu .side-nav .side-link i.live,.primary-menu .nav-menu .side-nav .side-link i.square,.primary-menu .nav-menu .side-nav .side-link i.zhuanlan,.primary-menu .nav-menu>li.home>a{background-size:contain;background-repeat:no-repeat;background-position:initial}.primary-menu .nav-menu>li .num-wrap{top:0;position:static;height:auto}.primary-menu .nav-menu li .nav-name{line-height:unset;height:auto}.primary-menu .nav-menu>li:not(.home) .nav-name{height:auto;padding:0}.nav-gif{position:static;flex:0 0 auto}.primary-menu .nav-menu li.home>a .nav-name{visibility:hidden;display:block;position:static}.primary-menu .nav-menu .sub-nav{top:36px;padding-top:4px}.main-inner{width:1160px}.rank-item .content .img .cover{width:180px;height:110px}.rank-item .content{padding:0 0 0 70px;height:110px}.rank-item .content .info{padding-top:8px;margin-left:192px}.rank-item .content .info .pts{bottom:50px}@media screen and (min-width:1300px){.bili-wrapper,.cinema-home-wrapper{width:1248px!important}.block-area .block-left{width:960px!important}.timeline-box .timeline-item{padding-right:32px!important}.elevator-module{margin-left:630px!important}.bili-wrapper .l-con{width:988px!important}.bangumi-timing-module .card-timing{padding:36px 30px 0 0}.bangumi-timing-module .card-timing:nth-child(4):nth-child(4){padding-top:0}.mod-1 li .r{width:750px!important}.mod-2 li .r{width:245px!important}.mod-2 li .r .up-info .v-author,.mod-2 li .r .v-info .v-info-i{width:70px!important}.bangumi-timing-module .headline .bili-tab{width:700px;display:flex;justify-content:space-evenly}}@media screen and (max-width:1300px){.bili-wrapper,.cinema-home-wrapper{width:1056px!important}.block-area .block-left{width:768px!important}.elevator-module{margin-left:540px!important}.bili-wrapper .l-con{width:768px!important}.bangumi-timing-module .card-timing{padding:36px 36px 0 0}#ranking_guochuang{width:260px!important;transform:translatex(28px)}.mod-1 li .r{width:530px!important}.mod-2 li .r{width:160px!important}.mod-2 li .r .up-info .v-author,.mod-2 li .r .v-info .v-info-i{width:50px!important}}.article-card .article-info{width:304px!important}.article-card .article-cover,.article-card .article-cover img{width:116px!important;height:87px!important}.article-card{margin-bottom:0!important}.article-card .article-info .data>.comment,.article-card .article-info .data>.view{display:inline-flex!important;align-items:center!important}.article-card .article-info .data{display:flex!important;align-items:center!important}@media screen and (max-width:1300px){.article-card .article-info{width:220px!important}}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/compact-layout.min.js"]=(()=>(e,t)=>{const i=["https://www.bilibili.com/","https://www.bilibili.com/watchlater/#/list","https://www.bilibili.com/ranking"];if(i.includes(location.href.replace(location.search,""))){document.body.classList.add("compact");t.applyImportantStyle("compactLayoutStyle")}return{reload:()=>{if(i.includes(location.href.replace(location.search,""))){document.body.classList.add("compact");t.applyImportantStyle("compactLayoutStyle")}},unload:()=>{document.body.classList.remove("compact");t.removeStyle("compactLayoutStyle")}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/copy-comment-link.min.js"]=(()=>(e,t)=>{(async()=>{const{forEachCommentItem:e}=await t.importAsync("comment-apis");const i=["https://t.bilibili.com","https://space.bilibili.com","https://live.bilibli.com"];const o=e=>{if(document.URL.match(/\/\/t\.bilibili\.com\/(\d+)/)){return""}if(i.every((e=>!document.URL.includes(e)))){return""}let t=e;while(t!==null&&t!==document.body){if(t.hasAttribute("data-did")){return`https://t.bilibili.com/${t.getAttribute("data-did")}`}t=t.parentElement}return""};const a=e=>{const t=e=>{e.forEach((e=>{const t=dq(e.element,".opera-list ul");if(!t||dq(t,".copy-link")){return}const i=document.createElement("li");i.classList.add("copy-link");i.textContent="复制链接";i.addEventListener("click",(()=>{const t=o(e.element)||document.URL.replace(/#.+$/,"");GM.setClipboard(`${t}#reply${e.id}`,"text");console.log("[Copy Comment Link]",`${t}#reply${e.id}`)}));t.appendChild(i)}))};t([e,...e.replies]);e.onRepliesUpdate=e=>t(e)};e({added:a})})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/copy-feeds-link.min.js"]=(()=>(e,t)=>{(async()=>{const{forEachFeedsCard:e,addMenuItem:i}=await t.importAsync("feeds-apis");const o=e=>{i(e,{className:"copy-link",text:"复制链接",action:()=>{GM.setClipboard(`https://t.bilibili.com/${e.id}`,"text")}})};e({added:o})})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-control-background.min.css"]=`.bilibili-player-video-control-mask{background:0 0!important}.bilibili-player-video-control .bilibili-player-video-control-bottom,.bilibili-player-video-control .bui-slider .bui-track.bui-track-video-progress .bui-bar-wrap{background:rgba(0,0,0,var(--custom-control-background-opacity))!important}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-control-background.min.js"]=(()=>(e,t)=>{addSettingsListener("customControlBackgroundOpacity",(e=>{document.documentElement.style.setProperty("--custom-control-background-opacity",e)}),true);const i=()=>{t.applyStyle("customControlBackgroundStyle");if(!e.touchVideoPlayer){t.applyImportantStyleFromText(`\n      .bilibili-player-video-control-bottom\n      {\n        margin: 7px 0 0 0 !important;\n        padding: 8px 0 0 !important;\n      }\n`,"control-background-non-touch")}};i();return{reload:i,unload:()=>{t.removeStyle("customControlBackgroundStyle");const e=document.getElementById("control-background-non-touch");e&&e.remove()}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar.min.css"]=`@font-face{font-family:custom-navbar-font;src:url(//s1.hdslb.com/bfs/seed/jinkela/header/asserts/iconfont.ttf) format("truetype")}@font-face{font-family:custom-navbar-font-extended;src:url(//s1.hdslb.com/bfs/static/jinkela/video/asserts/iconfont.4bab144.ttf) format("truetype")}@font-face{font-family:custom-navbar-font-new-home;src:url(//s1.hdslb.com/bfs/seed/jinkela/header-v2/asserts/iconfont.ttf) format("truetype")}.custom-navbar-iconfont,.custom-navbar-iconfont-extended,.custom-navbar-iconfont-new-home{color:inherit;font-family:custom-navbar-font!important;font-size:24px;font-style:normal}.custom-navbar-iconfont-extended{font-family:custom-navbar-font-extended!important}.custom-navbar-iconfont-new-home{font-family:custom-navbar-font-new-home!important}.custom-navbar-icon-logo::before{content:""}.custom-navbar-icon-lv0::before{content:"";color:#9a9a9a}.custom-navbar-icon-lv1::before{content:"";color:#646464}.custom-navbar.dark .custom-navbar-icon-lv0::before{color:#777}.custom-navbar.dark .custom-navbar-icon-lv1::before{color:#ddd}.custom-navbar-icon-lv2::before{content:"";color:#1bc861}.custom-navbar-icon-lv3::before{content:"";color:#22baea}.custom-navbar-icon-lv4::before{content:"";color:#eaa722}.custom-navbar-icon-lv5::before{content:"";color:#ff7631}.custom-navbar-icon-lv6::before{content:"";color:#ff3131}.custom-navbar-icon-profile::before{content:""}.custom-navbar-icon-posts::before{content:""}.custom-navbar-icon-wallet::before{content:""}.custom-navbar-icon-live-center::before{content:""}.custom-navbar-icon-order-center::before{content:""}.custom-navbar-icon-logout::before{content:""}.custom-navbar-icon-ok::before{content:""}.custom-navbar-icon-cancel::before{content:""}.custom-navbar-icon-bind-phone::before{content:""}.custom-navbar-icon-bind-email::before{content:""}.custom-navbar-icon-coin::before{content:""}.custom-navbar-icon-b-coin::before{content:""}.custom-navbar-icon-activity::before{content:""}.custom-navbar-icon-message::before{content:""}.custom-navbar-icon-favorite::before{content:""}.custom-navbar-icon-history::before{content:""}.custom-navbar-icon-vip::before{content:""}.custom-navbar-icon-course::before{content:""}[class^=custom-navbar-icon-lv]::before{font-size:24px}html{--navbar-height:50px;--navbar-foreground:#555;--navbar-background:white;--navbar-bounds-padding:0 5%;--navbar-blur-opacity:0.7;--navbar-icon-size:24px}body.custom-navbar-loading::after{content:"";height:var(--navbar-height);width:100%;position:absolute;top:0;left:0;background-color:#fff;z-index:10001}body.dark.custom-navbar-loading::after{background-color:#333}#biliMainHeader .base-mini-header,#biliMainHeader .mini-header,.bili-banner .taper-line,.bili-header-m .head-banner .head-content .head-logo,.bili-header-m>#banner_link .search,.bili-header__bar,.home-header .mini-header-container,.i_menu_login,.international-header .b-logo,.international-header .mini-header,.z-top-container>.header .search,body.no-banner #banner_link,body.no-banner .z-top-container.has-banner>.header,li.nav-item[report-id=playpage_dynamic] .i-frame,li.nav-item[report-id=playpage_dynamic] iframe{display:none!important}.van-popover{z-index:10002!important}.international-header{min-height:var(--navbar-height)!important}.bili-header-m .head-banner{margin-top:calc(-1 * var(--navbar-height))!important}.bili-header-m>.nav-menu,.z_top{visibility:hidden!important;height:var(--navbar-height)!important}.link-top-container#tab-container{top:var(--navbar-height)!important}.custom-navbar,.custom-navbar *,.custom-navbar-settings,.custom-navbar-settings *{transition:.2s ease-out;-webkit-tap-highlight-color:transparent;outline:0!important;margin-inline-start:0;margin-inline-end:0;padding-inline-start:0;padding-inline-end:0}.custom-navbar{position:absolute;top:0;left:0;height:var(--navbar-height);width:100%;background-color:var(--navbar-background);color:var(--navbar-foreground);z-index:10001;display:flex;justify-content:center}body.fixed-navbar .custom-navbar{position:fixed}body.player-mode-blackmask .custom-navbar{visibility:hidden}body.player-fullscreen-fix .custom-navbar{z-index:1}.custom-navbar:not(.fill) .custom-navbar-iconfont{color:var(--theme-color)}.custom-navbar path{fill:var(--navbar-foreground)}.custom-navbar svg.stroke,.custom-navbar svg.stroke path{fill:transparent;stroke:var(--navbar-foreground)}.custom-navbar.fill:not(.transparent) path{fill:var(--foreground-color-d)}.custom-navbar.fill:not(.transparent) path svg.stroke,.custom-navbar.fill:not(.transparent) path svg.stroke path{fill:transparent;stroke:var(--navbar-foreground-d)}.custom-navbar.shadow:not(.transparent){box-shadow:#0002 0 1px 10px 1px}.custom-navbar.dark.shadow:not(.transparent){box-shadow:#0004 0 2px 10px 1px}.custom-navbar.dark:not(.fill):not(.transparent){--navbar-background:#222;--navbar-foreground:#eee}.custom-navbar.transparent{--navbar-background:transparent;--navbar-foreground:#eee}.custom-navbar.transparent::before{content:"";position:absolute;top:0;left:0;width:100%;height:calc(2 * var(--navbar-height));background-image:linear-gradient(to bottom,#000a 0,#0004 65%,transparent 100%);pointer-events:none}.custom-navbar .popup{color:#000;background:#fff;transition:.2s ease-out .2s}.custom-navbar.dark .popup{color:#eee;background:#222}.custom-navbar.dark .popup:not(.transparent) iframe{box-shadow:rgba(0,0,0,.2) 0 4px 8px 0}.custom-navbar.fill:not(.transparent){--navbar-background:var(--theme-color);--navbar-foreground:var(--foreground-color-d);height:var(--navbar-height);width:100%}.custom-navbar.fill.shadow:not(.transparent){box-shadow:var(--theme-color-30) 0 2px 10px 1px}.custom-navbar>ul{display:flex;align-items:center;justify-content:space-between;margin:var(--navbar-bounds-padding);height:100%;flex-grow:1}.custom-navbar ul{list-style:none;color:inherit}.custom-navbar li{color:inherit;list-style:none}.custom-navbar>ul>li{position:relative;height:100%;display:flex;align-items:center;color:inherit}.custom-navbar li .active-bar{position:absolute;left:0;bottom:0;background-color:var(--theme-color);width:100%;height:3px;border-radius:1.5px;display:none}.custom-navbar.fill li .active-bar,.custom-navbar.transparent li .active-bar{background-color:rgba(0,0,0,.3)}.custom-navbar li.active .active-bar{display:flex}.custom-navbar>ul>li.view-border::before{content:"";width:94%;height:94%;border:2px dashed var(--navbar-foreground);position:absolute;top:3%;left:3%;box-sizing:border-box}.custom-navbar>ul>li:not(.disabled){cursor:pointer}.custom-navbar>ul>li.disabled a{cursor:default}.custom-navbar>ul>li:not(.disabled):hover{background:rgba(0,0,0,.1)}.custom-navbar .main-content{font-size:10pt;height:100%;display:flex;align-items:center;padding:0 10px;color:var(--navbar-foreground);user-select:none}.custom-navbar .main-content .custom-navbar-season-logo{transform:scale(1.15)}.custom-navbar .active .main-content{font-weight:700;font-size:11pt}.custom-navbar .main-content:hover{color:var(--navbar-foreground)!important}.custom-navbar .popup{position:absolute;top:100%;left:50%;padding:8px;box-shadow:rgba(0,0,0,.2) 0 4px 8px 0;pointer-events:none;opacity:0;transform:translateY(-6px) translateX(-50%);cursor:default}.custom-navbar .popup.no-padding{padding:0}.custom-navbar .popup.transparent{background-color:transparent!important;box-shadow:none}.custom-navbar li.left-side .popup{left:0;transform:translateY(-6px) translateX(10%)}.custom-navbar li.right-side .popup{left:100%;transform:translateY(-6px) translateX(-90%)}.custom-navbar.dark .popup:not(.transparent){box-shadow:rgba(0,0,0,.3) 0 4px 8px 0}.custom-navbar a,.custom-navbar a:hover{color:inherit!important;text-decoration:none}.custom-navbar form{height:100%;display:flex;align-items:center;position:relative;--submit-button-size:30px;opacity:.4;margin:0}.custom-navbar.fill:not(.transparent) form{opacity:.8}.custom-navbar form:focus-within,.custom-navbar form:hover,.custom-navbar.fill form:focus-within,.custom-navbar.fill form:hover{opacity:1}.custom-navbar form input{border:none;height:60%;background:0 0;border-bottom:1.5px solid!important;color:var(--navbar-foreground);box-sizing:border-box;width:250px;padding-right:var(--submit-button-size);padding-left:4px}.custom-navbar form input:focus{border-bottom-color:var(--navbar-foreground)!important;outline:0!important}.custom-navbar form button[type=submit]{background:0 0;border:none;padding:4px;cursor:pointer;height:var(--submit-button-size);width:var(--submit-button-size);position:absolute;right:0;top:50%;transform:translateY(-50%)}.custom-navbar form input[type=text]::placeholder{color:var(--navbar-foreground)!important;opacity:.9}.custom-navbar .user-face-container{position:relative;height:calc(var(--navbar-height) - 16px);width:calc(var(--navbar-height) - 16px)}.custom-navbar .user-face,.custom-navbar .user-pendant{position:absolute;width:100%;height:100%}.custom-navbar .user-face{background-color:transparent;background-size:contain;border-radius:50%}.custom-navbar .user-pendant{background-color:transparent;background-size:cover;width:170%;height:170%;top:-12px;left:-12px;opacity:0;pointer-events:none}.custom-navbar .user-info-panel{width:240px;font-size:12px}.custom-navbar .user-info-panel .circle{position:relative;width:var(--navbar-icon-size);height:var(--navbar-icon-size);opacity:.7}.custom-navbar .user-info-panel .circle .mdi{position:absolute;top:0;left:0}.custom-navbar .user-info-panel .mdi-circle~.mdi{filter:invert(1);font-size:calc(var(--navbar-icon-size) - 10px);line-height:calc(var(--navbar-icon-size) - 10px);transform:translate(5px,5px)}.custom-navbar .user-info-panel i{font-size:var(--navbar-icon-size);font-style:normal;line-height:var(--navbar-icon-size)}.custom-navbar .user-info-panel .logged-in{display:flex;flex-direction:column;align-items:center;justify-content:space-between}.custom-navbar .user-info-panel .items,.custom-navbar .user-info-panel .row{align-self:stretch;display:flex;justify-content:space-between;align-items:center}.custom-navbar .user-info-panel .row{margin:0 10px;width:auto!important}.custom-navbar .user-info-panel .row::after{content:none!important}.custom-navbar .user-info-panel .row.level-info{margin-bottom:-5px}.custom-navbar .user-info-panel .privileges{justify-content:center}.custom-navbar .user-info-panel .privileges>*{font-size:11px;background-color:#8882;padding:2px 4px;margin:0 2px;border-radius:4px;line-height:normal;cursor:pointer}.custom-navbar .user-info-panel .privileges>.received{cursor:default;opacity:.5}.custom-navbar .user-info-panel .privileges>:not(.received):hover{background-color:#8884}.custom-navbar .user-info-panel .operation{height:36px;display:flex;align-items:center;justify-content:center;position:relative;align-self:stretch}.custom-navbar .user-info-panel .operation:hover{background-color:rgba(0,0,0,.1)}.custom-navbar .user-info-panel .operation .icon{position:absolute;left:10px;top:50%;transform:translateY(-50%);background:0 0}.custom-navbar .user-info-panel .item>i{opacity:.7;font-size:14pt}.custom-navbar .user-info-panel .item{display:flex;flex-direction:column;justify-content:space-around;align-items:center;height:48px;flex:1}.custom-navbar .user-info-panel .item span{font-size:14px;font-weight:700;opacity:.7}.custom-navbar .user-info-panel .item>i:nth-child(2){font-size:18px;line-height:18px}.custom-navbar .user-info-panel .name,.custom-navbar .user-info-panel .welcome{font-size:16px;font-weight:700;margin:46px 0 16px;text-align:center;color:inherit}.custom-navbar .user-info-panel .name{margin:62px 0 0}.custom-navbar .user-info-panel .type{font-size:11px;opacity:.5;margin:6px 0}.custom-navbar .user-info-panel .separator{height:1px;align-self:stretch;margin:5px 10px;background:rgba(0,0,0,.1)}.custom-navbar .user-info-panel .logout{margin-top:5px;cursor:pointer}.custom-navbar .user-info-panel .logout:hover{color:inherit!important}.custom-navbar .user-info-panel .level-progress-thumb{width:100%;height:100%;background:var(--theme-color);transform-origin:left}.custom-navbar .user-info-panel .level-progress-label{font-size:11px}.custom-navbar .user-info-panel .stats{display:flex;align-items:center;align-self:stretch;margin:0 10px;line-height:normal}.custom-navbar .user-info-panel .stats-item{padding:6px 0;flex:1;display:flex;flex-direction:column;align-items:center;transition:none}.custom-navbar .user-info-panel .stats-item:hover{color:var(--theme-color)!important}.custom-navbar .user-info-panel .stats-item .stats-number{font-weight:700;margin-bottom:4px;font-size:14px;transition:none}.custom-navbar.dark .user-info-panel .separator{background:rgba(255,255,255,.1)}.custom-navbar .grey-button,.custom-navbar .theme-button{align-self:stretch;height:36px;display:flex;align-items:center;justify-content:center}.custom-navbar .grey-button{background:#ededed;color:inherit!important}.custom-navbar .grey-button:hover{background:#ddd}.custom-navbar.dark .grey-button{background:#383838}.custom-navbar.dark .grey-button:hover{background:#333}.custom-navbar .theme-button{background:var(--theme-color);color:var(--foreground-color)!important}.custom-navbar .theme-button:hover{background:var(--theme-color-90);color:var(--foreground-color)!important}.custom-navbar li:hover .user-face,.custom-navbar li:hover .user-pendant{transform:scale(2) translateY(10px);z-index:100;opacity:1}.custom-navbar .video-list{width:280px;font-size:12px}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::after,.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::before{content:"";transition:.3s cubic-bezier(.22,.61,.36,1) .1s;width:calc(100% - 16px);height:2px;border-radius:1px;background:linear-gradient(to right,var(--theme-color),var(--theme-color-50));opacity:1;position:absolute;bottom:0;left:8px;pointer-events:none}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::after{width:0;background:linear-gradient(to right,var(--theme-color),var(--theme-color-50))}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading):hover::after{width:calc(100% - 16px)}.custom-navbar.dark .video-list li:not(.history-item):not(.more):not(.loading)::after{background:linear-gradient(to right,var(--theme-color-60),var(--theme-color))}.custom-navbar .video-list li:not(.history-item):not(.more):not(.loading)::before{background:#8882}.custom-navbar .video-list li{position:relative}.custom-navbar .video-list li:not(.more) a{padding:12px 16px;margin:0;box-sizing:border-box;transition:.2s ease-out .1s;display:block;width:100%;height:100%;line-height:1.5}.custom-navbar.compact .video-list li:not(.more) a{padding:6px 8px}.custom-navbar .video-list li:not(.loading):hover .title{color:var(--theme-color)}.custom-navbar .video-list li.more a{width:100%;padding:8px 0;display:flex;justify-content:center;font-weight:700}.custom-navbar.compact .video-list li.more a{padding:6px 0}.custom-navbar .video-list li.more:hover{border-color:var(--theme-color);color:var(--theme-color)!important}.custom-navbar .video-list .loading{display:flex;justify-content:center;padding:8px;cursor:default}.custom-navbar .video-list.loaded .loading:not(.empty){display:none}.custom-navbar .video-list.history .history-item{border:none!important}.custom-navbar.compact .video-list li:not(.more) a,.custom-navbar.compact .video-list.history .history-item .title{white-space:nowrap;text-overflow:ellipsis;overflow:hidden}.custom-navbar .video-list li:not(.history-item):not(.more):hover a{color:var(--theme-color)!important}.custom-navbar .video-list.history li:not(.more) a{justify-content:space-between;position:relative;display:flex;padding:13px 16px!important}.custom-navbar.compact .video-list.history li:not(.more) a{padding:7px 8px!important}.custom-navbar .video-list.history a .description{opacity:.6;margin-left:4px;white-space:nowrap}.custom-navbar .video-list.history a .progress.foreground{height:2px;border-radius:1px;background:linear-gradient(to right,var(--theme-color),var(--theme-color-50));width:0;transition:.3s cubic-bezier(.22,.61,.36,1) .1s}.custom-navbar .video-list.history a:hover .progress.foreground{width:var(--progress)}.custom-navbar.dark .video-list.history a .progress.foreground{background:linear-gradient(to right,var(--theme-color-60),var(--theme-color))}.custom-navbar .video-list.history a .progress.background{position:absolute;bottom:0;left:8px;height:2px;width:calc(100% - 16px);transform-origin:left;border-radius:1px;background:#8882}.custom-navbar .notify-count{position:absolute;left:50%;top:0;background-color:var(--theme-color);padding:0 8px;display:flex;justify-content:center;font-size:11px;transform:translateX(-50%);opacity:0;line-height:14px;white-space:nowrap;color:var(--foreground-color);border-radius:0 0 8px 8px}.custom-navbar .notify-count:not(:empty):not(.hidden){opacity:1}.custom-navbar .notify-count.dot{color:transparent;border-radius:50%;width:8px;height:8px;padding:0;top:2px}.custom-navbar.fill .notify-count{background-color:rgba(0,0,0,.3)}.custom-navbar .blur-layer-container{overflow:hidden;display:none;width:100%;height:100%;position:absolute;top:0;left:0}.custom-navbar.blur:not(.transparent) .blur-layer-container{display:flex}.custom-navbar .blur-layer{width:100%;height:100%;background-position:center 0;background-repeat:no-repeat;filter:blur(36px);opacity:var(--navbar-blur-opacity)}.custom-navbar .blur-layer.left-pad{position:absolute;left:0;top:0;transform:translateX(-100%) scaleX(-1);width:100%;height:100%}.custom-navbar .blur-layer.right-pad{position:absolute;left:0;top:0;transform:translateX(100%) scaleX(-1);width:100%;height:100%}.custom-navbar.dark .blur-layer{filter:blur(54px)}.custom-navbar ol{color:#000}.custom-navbar.dark ol{color:#eee}.custom-navbar em.suggest-highlight{color:var(--theme-color);font-style:normal}.custom-navbar .copy-tip{position:absolute;top:calc(100% + 4px);left:50%;pointer-events:none;opacity:0;transform:translateX(-50%) translateY(-8px);border-radius:4px;background-color:#000a;color:#fff;padding:6px 8px}.custom-navbar .copy-tip.show{transform:translateX(-50%) translateY(0);opacity:1}.custom-navbar .search-list-item{white-space:nowrap;text-overflow:ellipsis;overflow:hidden;cursor:pointer;display:flex;align-items:center}.custom-navbar .search-list-item-text{white-space:nowrap;text-overflow:ellipsis;overflow:hidden;flex:1;padding:6px 0 6px 6px}.custom-navbar .search-list-item .delete-history{opacity:.5;padding:6px 6px 6px 0;line-height:1}.custom-navbar .search-list-item .delete-history:hover{opacity:1}.custom-navbar .search-list-item:focus-within,.custom-navbar .search-list-item:hover{background-color:#8883}.custom-navbar .search-list-item.clear-history{text-align:center;font-weight:700;background-color:#8881;margin-top:8px;display:flex;align-items:center;justify-content:center;padding:6px}.custom-navbar .search-list-item.clear-history .mdi{line-height:1;margin-right:6px}.custom-navbar .search-list-item.clear-history:focus-within,.custom-navbar .search-list-item.clear-history:hover{color:var(--theme-color);background-color:#8883}.custom-navbar .search-list{width:250px}.custom-navbar .activity-popup{width:380px;font-size:9pt}.custom-navbar .activity-tabs{display:flex;padding:12px 12px 16px 18px;justify-content:space-between;align-items:center}.custom-navbar .activity-tabs .view-all,.custom-navbar .subscriptions-tabs .view-all{background-color:#8882;padding:4px 6px 4px 10px;height:28px;box-sizing:border-box;border-radius:14px;display:flex;align-items:center}.custom-navbar .activity-tabs .view-all i{font-size:14pt;margin-left:4px}.custom-navbar .subscriptions-tabs .view-all i{font-size:12pt;margin-left:4px}.custom-navbar .activity-tabs .view-all:hover,.custom-navbar .subscriptions-tabs .view-all:hover{background-color:#8884}.custom-navbar .activity-tab{position:relative;cursor:pointer}.custom-navbar .activity-tab .tab-name{line-height:normal;opacity:.5}.custom-navbar .activity-tab.selected{opacity:1;transform:scale(1.2)}.custom-navbar .activity-tab.selected .tab-name{opacity:1;font-weight:700}.custom-navbar .activity-tab[data-count]::before{content:attr(data-count);position:absolute;top:0;left:50%;transform:translateX(-50%) translateY(-100%);font-size:10px;font-weight:400;line-height:1;background-color:#8884;padding:2px 4px;border-radius:10px;white-space:nowrap}.custom-navbar .activity-tab::after,.custom-navbar .subscriptions .tab::after{content:"";width:calc(80%);height:2px;border-radius:1px;position:absolute;background-color:var(--theme-color);left:10%;bottom:-4px;transform:scaleX(0);transition:.2s ease-out}.custom-navbar .activity-tab.selected::after,.custom-navbar .subscriptions .tab.selected::after{transform:scaleX(1)}.custom-navbar .activity-popup-content::-webkit-scrollbar,.custom-navbar .subscriptions .content::-webkit-scrollbar{width:0!important}.custom-navbar .activity-popup-content{overflow:auto;overscroll-behavior:contain;height:500px;position:relative;display:flex;flex-direction:column;align-items:center;justify-content:space-between;scrollbar-width:none!important}.custom-navbar .activity-popup-content .view-more{display:flex;align-items:center;flex-shrink:0;position:-webkit-sticky;position:sticky;bottom:0;left:0;justify-content:center;padding:6px 12px;background-color:#fffe;transform:translateY(-6px);box-shadow:rgba(0,0,0,.12) 0 4px 8px 0;cursor:pointer;height:28px;border-radius:14px;box-sizing:border-box;z-index:2}.custom-navbar .activity-popup-content .view-more:hover{background-color:#fff}.custom-navbar .activity-popup-content .view-more .mdi{line-height:1;margin-left:8px;font-size:12pt}body.dark .custom-navbar .activity-popup-content .view-more{background-color:#333e}body.dark .custom-navbar .activity-popup-content .view-more:hover{background-color:#333}.custom-navbar .activity-popup-content .loading,.custom-navbar .bangumi-subscriptions .empty,.custom-navbar .bangumi-subscriptions .loading{height:100%;align-self:center;display:flex;align-items:center;justify-content:center}.custom-navbar .activity-popup-content .loading .mdi,.custom-navbar .bangumi-subscriptions .loading .mdi{line-height:1;margin-right:6px}.custom-navbar .video-activity{padding:0 12px;align-self:stretch;display:grid;grid-template:"left right" auto "trigger trigger" auto/1fr 1fr}.custom-navbar .video-activity.center{display:flex;height:100%;flex-direction:column;justify-content:center;align-items:center}.custom-navbar .video-activity-column.left{grid-area:left;justify-self:start}.custom-navbar .video-activity-column.right{grid-area:right;justify-self:end}.custom-navbar .video-activity-card{--card-width:172px;width:var(--card-width);display:flex;flex-direction:column;box-shadow:rgba(0,0,0,.12) 0 4px 8px 0;margin-bottom:12px;break-inside:avoid;flex-shrink:0}.custom-navbar .video-activity-card .cover{width:var(--card-width);background-color:#8884;height:calc(var(--card-width)/ 16 * 10);object-fit:cover;display:block;min-height:100px}.custom-navbar .video-activity-card .title{font-size:10pt;font-weight:700;margin:8px 8px 2px;color:inherit;overflow:hidden;text-overflow:ellipsis;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;line-height:1.5;max-height:3em;word-break:break-all}.custom-navbar .video-activity-card .up{display:flex;justify-content:space-between;align-items:center;margin:6px 8px;border-radius:13px;padding:2px}.custom-navbar .video-activity-card .up:hover{background-color:#8882}.custom-navbar .video-activity-card .up .face{width:24px;border-radius:50%;background-color:#8884}.custom-navbar .video-activity-card .up .name{padding:0 8px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.custom-navbar .video-activity-card .title:hover,.custom-navbar .video-activity-card .up:hover .name{color:var(--theme-color)}.custom-navbar .video-activity-card .cover-container{position:relative}.custom-navbar .video-activity-card .pub-time,.custom-navbar .video-activity-card .pub-time-text,.custom-navbar .video-activity-card .time,.custom-navbar .video-activity-card .watchlater{position:absolute;bottom:4px;display:flex;align-items:center;background-color:#000a;color:#fff;padding:0 8px;height:20px;border-radius:10px;box-sizing:border-box;opacity:0;white-space:nowrap;overflow:hidden;max-width:calc(100% - 8px)}.custom-navbar .video-activity-card .time{left:4px}.custom-navbar .video-activity-card .pub-time,.custom-navbar .video-activity-card .pub-time-text{right:4px;top:4px;bottom:unset}.custom-navbar .video-activity-card .watchlater{padding:0 8px 0 3px;right:4px;font-size:11px}.custom-navbar .video-activity-card .watchlater .mdi{line-height:1;margin-right:4px;font-size:16px}.custom-navbar .video-activity-card:hover .pub-time-text:not(:hover),.custom-navbar .video-activity-card:hover .time,.custom-navbar .video-activity-card:hover .watchlater,body.always-show-duration .custom-navbar .video-activity-card .time{opacity:1}.custom-navbar .video-activity-card .pub-time-text{z-index:1}.custom-navbar .video-activity-card .pub-time-text:hover{opacity:0}.custom-navbar .video-activity-card .pub-time-text:hover~.pub-time{opacity:1}.custom-navbar.dark .activity-popup-content .view-more,.custom-navbar.dark .column-card,.custom-navbar.dark .video-activity-card{box-shadow:rgba(0,0,0,.3) 0 4px 8px 0;background-color:#2d2d2d}.custom-navbar .bangumi-activity{display:flex;flex-direction:column;padding-top:4px;width:100%}.custom-navbar .bangumi-activity.center{height:100%;justify-content:center;align-items:center}.custom-navbar .bangumi-card{--cover-width:100px;margin:0 12px 12px;box-shadow:rgba(0,0,0,.12) 0 2px 8px 0;display:grid;grid-template-areas:"cover epTitle" "cover title";grid-template-columns:var(--cover-width) 1fr;grid-template-rows:6fr 5fr;position:relative;flex-shrink:0}.custom-navbar .bangumi-card .up{grid-area:title;display:flex;align-items:center;padding:0 12px;align-self:start;overflow:hidden}.custom-navbar .bangumi-card .up .cover{height:18px;border-radius:50%}.custom-navbar .bangumi-card .up .title{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;margin:0 6px;line-height:normal}.custom-navbar .bangumi-card .ep-title{grid-area:epTitle;font-size:11pt;font-weight:700;padding:0 12px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;align-self:center;color:inherit;line-height:normal}.custom-navbar .bangumi-card:hover .ep-title{color:var(--theme-color)}.custom-navbar .bangumi-card .ep-cover{width:var(--cover-width);min-height:62.5px;background-color:#8884;grid-area:cover}.custom-navbar.dark .bangumi-card,.custom-navbar.dark .live-card{box-shadow:rgba(0,0,0,.3) 0 2px 8px 0;background-color:#2d2d2d}.custom-navbar .column-activity{display:flex;flex-direction:column;align-items:stretch;padding:0 12px}.custom-navbar .column-activity.center{height:100%;align-items:center;justify-content:center}.custom-navbar .column-card{width:356px;display:flex;flex-direction:column;margin-bottom:12px;box-shadow:rgba(0,0,0,.12) 0 4px 8px 0;position:relative;flex-shrink:0}.custom-navbar .column-card .up{position:absolute;left:8px;bottom:6px;padding:2px;display:flex;align-items:center;background-color:#000a;border-radius:14px;height:28px;box-sizing:border-box}.custom-navbar .column-card .up .name{margin:0 6px;color:#fff}.custom-navbar .column-card .face{border-radius:50%;height:24px}.custom-navbar .column-card .title{padding:10px 10px 0;margin:0;font-size:11pt;font-weight:700;color:inherit;line-height:normal}.custom-navbar .column-card:hover .title{color:var(--theme-color)}.custom-navbar .column-card .description{margin:8px 10px;max-height:3em;overflow:hidden;text-overflow:ellipsis;word-break:break-all;line-height:1.5;-webkit-line-clamp:2;-webkit-box-orient:vertical;display:-webkit-box}.custom-navbar .column-card .covers{position:relative;display:flex}.custom-navbar .column-card .cover{flex:1;object-fit:cover}.custom-navbar .live-activity{display:flex;flex-direction:column;align-items:stretch;width:100%;padding-top:4px}.custom-navbar .live-activity.center{height:100%;align-items:center;justify-content:center}.custom-navbar .live-card{margin:0 12px 12px;box-shadow:rgba(0,0,0,.12) 0 2px 8px 0;display:grid;grid-template-areas:"face title" "face name";grid-template-columns:48px 1fr;grid-template-rows:6fr 5fr;height:52px;border-radius:26px;box-sizing:border-box;padding:2px;width:auto;flex-shrink:0}.custom-navbar .live-card .face{grid-area:face;border-radius:50%;height:48px}.custom-navbar .live-card .live-title{grid-area:title;font-size:11pt;font-weight:700;align-self:center;padding:0 12px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;color:inherit;line-height:normal}.custom-navbar .live-card:hover .live-title{color:var(--theme-color)}.custom-navbar .live-card .name{grid-area:name;align-self:start;padding:0 12px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;line-height:normal}.custom-navbar .bangumi-activity .trigger,.custom-navbar .column-activity .trigger,.custom-navbar .live-activity .trigger,.custom-navbar .video-activity .trigger{text-align:center;grid-area:trigger;align-self:stretch;margin-bottom:12px}.custom-navbar .activity-content-enter-active,.custom-navbar .activity-content-leave-active,.custom-navbar .subscriptions-content-enter-active,.custom-navbar .subscriptions-content-leave-active{transition:.2s ease-out}.custom-navbar .activity-content-enter,.custom-navbar .activity-content-leave-to,.custom-navbar .subscriptions-content-enter,.custom-navbar .subscriptions-content-leave-to{opacity:0;transform:translateY(12px)}.custom-navbar .bangumi-card.new::before,.custom-navbar .column-card.new::before,.custom-navbar .video-activity-card.new .cover-container::before{content:"NEW";position:absolute;top:4px;left:4px;background-color:var(--theme-color);color:var(--foreground-color);padding:0 6px;height:18px;border-radius:9px;font-weight:700;font-size:11px;line-height:18px;z-index:1}.custom-navbar .column-card.new::before{left:unset;right:8px;top:8px;height:20px;border-radius:10px;line-height:20px;font-size:12px;padding:0 8px}.custom-navbar .subscriptions{width:380px;font-size:9pt}.custom-navbar .subscriptions .tab-placeholder{flex-grow:1}.custom-navbar .subscriptions .tab{opacity:.5;margin-right:24px;position:relative;line-height:1.4;cursor:pointer}.custom-navbar .subscriptions .tab.selected{opacity:1;font-weight:700;transform:scale(1.2)}.custom-navbar .subscriptions .content{padding:8px 12px;height:500px;overflow:auto;overscroll-behavior:contain;scrollbar-width:none!important}.custom-navbar .subscriptions-tabs{margin:12px 12px 8px 18px;display:flex;align-items:center}.custom-navbar .bangumi-subscriptions{display:flex;flex-direction:column}.custom-navbar .bangumi-subscriptions.center{height:100%}.custom-navbar .bangumi-subscriptions-card{position:relative;display:flex;margin-bottom:12px;flex-shrink:0}body.dark .custom-navbar .bangumi-subscriptions-card{background-color:#2d2d2d}.custom-navbar .bangumi-subscriptions-card .cover{height:64px;width:64px}.custom-navbar .bangumi-subscriptions-card .card-info{flex-grow:1;display:flex;flex-direction:column;align-items:flex-start;padding:0 12px;max-width:calc(100% - 24px - 64px);box-sizing:content-box}.custom-navbar .bangumi-subscriptions-card .info{padding:2px;background-color:#8882;font-size:12pt;border-radius:14px;line-height:1}.custom-navbar .bangumi-subscriptions-card .info:hover{background-color:#8884}.custom-navbar .bangumi-subscriptions-card .progress-row{flex-grow:1;display:flex;justify-content:space-between;align-self:stretch;align-items:center}.custom-navbar .bangumi-subscriptions-card .status{padding:0 4px;background-color:#8882;border-radius:4px;opacity:.75}.custom-navbar .bangumi-subscriptions-card .status.status-2{background-color:var(--theme-color-10);opacity:1}.custom-navbar .bangumi-subscriptions-card .progress{white-space:nowrap;width:0;flex-grow:1;margin:0 8px;overflow:hidden;text-overflow:ellipsis}.custom-navbar .bangumi-subscriptions-card .title{font-size:11pt;font-weight:700;padding-top:8px;color:inherit;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:100%;margin:0}.custom-navbar .bangumi-subscriptions-card:hover .title{color:var(--theme-color)}.round-corner .custom-navbar .popup,.round-corner .custom-navbar .popup iframe{border-radius:var(--large-corner-radius)}.round-corner #custom-navbar-home-popup .category-item,.round-corner #custom-navbar-home-popup .category-item .popup{border-radius:var(--corner-radius)}.round-corner .custom-navbar .video-list li.more,.round-corner .user-info-panel .login,.round-corner .user-info-panel .logout{border-radius:0 0 var(--corner-radius) var(--corner-radius)}.round-corner .custom-navbar-settings{border-radius:var(--large-corner-radius)}.round-corner .custom-navbar .search-list-item{border-radius:var(--corner-radius)}.round-corner .custom-navbar .bangumi-subscriptions-card{border-radius:var(--large-corner-radius);box-shadow:rgba(0,0,0,.12) 0 2px 8px 0}.round-corner .custom-navbar .bangumi-subscriptions-card .cover{border-radius:var(--large-corner-radius) 0 0 var(--large-corner-radius)}.round-corner .custom-navbar .column-card .cover:first-child{border-top-left-radius:var(--large-corner-radius)}.round-corner .custom-navbar .column-card .cover:nth-last-child(2){border-top-right-radius:var(--large-corner-radius)}.round-corner .custom-navbar .bangumi-card,.round-corner .custom-navbar .column-card,.round-corner .custom-navbar .video-activity-card{border-radius:var(--large-corner-radius)}.round-corner .custom-navbar .video-activity-card .cover{border-radius:var(--large-corner-radius) var(--large-corner-radius) 0 0}.round-corner .custom-navbar .bangumi-activity .ep-cover{border-radius:var(--large-corner-radius) 0 0 var(--large-corner-radius)}.custom-navbar-settings{display:flex;flex-direction:column;pointer-events:none;opacity:0;width:370px;position:fixed;top:50%;left:50%;transform:translate(-50%,-46%) scale(.95);z-index:10001;background:var(--navbar-background);padding-top:16px;box-shadow:#0002 0 1px 10px 1px;font-size:16px;line-height:1.5}.custom-navbar-settings.dark{--navbar-background:#222;--navbar-foreground:#eee;box-shadow:#0004 0 2px 10px 1px}.custom-navbar-settings h1{color:var(--navbar-foreground);font-size:16pt;font-weight:700}.custom-navbar-settings.show{pointer-events:initial;transform:translate(-50%,-46%) scale(1);opacity:1}.custom-navbar-settings .header,.custom-navbar-settings .orders{display:flex;justify-content:space-between;align-items:center}.custom-navbar-settings .header{padding:0 24px;font-size:9pt}.custom-navbar-settings .header .header-blank,.custom-navbar-settings .orders{flex-grow:1}.custom-navbar-settings .order-list{padding:0 24px;max-height:60vh;overflow:auto;overscroll-behavior:contain;list-style:none;width:100%;margin:16px 0}.custom-navbar-settings button{border:none;background-color:transparent;color:var(--navbar-foreground);padding:8px;cursor:pointer;font-size:14pt}.custom-navbar-settings button:hover{color:var(--theme-color)}.custom-navbar-settings .order-list li .mdi-menu{padding:8px}.custom-navbar-settings .order-list i{font-size:14pt}.custom-navbar-settings .order-list i.mdi-menu{cursor:move}.custom-navbar-settings .order-list li{color:var(--navbar-foreground);font-size:12pt;display:flex!important;justify-content:space-between;align-items:center;user-select:none;transition:opacity .2s ease-out}.custom-navbar-settings .order-list li.hidden{opacity:.5}.custom-navbar-settings .paddings{display:flex;align-items:center;justify-content:space-between;padding:16px 32px;color:var(--navbar-foreground)}.custom-navbar-settings .paddings span{min-width:40px}.custom-navbar-settings .paddings input{flex-grow:1;margin-right:16px;-webkit-appearance:none;background:0 0;width:100%}.custom-navbar-settings .paddings input::-webkit-slider-thumb{-webkit-appearance:none;height:18px;width:18px;background:var(--theme-color);border-radius:50%;box-shadow:0 2px 8px 0 var(--theme-color-50);cursor:pointer;border:none;transform:translateY(-7px)}.custom-navbar-settings .paddings input::-moz-range-thumb{-webkit-appearance:none;height:18px;width:18px;background:var(--theme-color);border-radius:50%;box-shadow:0 2px 8px 0 var(--theme-color-50);cursor:pointer;border:none}.custom-navbar-settings .paddings input::-webkit-slider-runnable-track{width:100%;background:#8884;height:4px}.custom-navbar-settings .paddings input::-moz-range-track{width:100%;background:#8884;height:4px}#custom-navbar-home-popup{max-height:calc(100vh - 100px);display:flex;flex-direction:column;flex-wrap:wrap;width:350px}#custom-navbar-home-popup .category-item{font-size:12pt;padding:8px 16px;cursor:pointer;position:relative;box-sizing:border-box}#custom-navbar-home-popup .category-item.loading{font-size:10pt;cursor:initial;display:flex;align-items:center;justify-content:center}#custom-navbar-home-popup .category-item:not(.loading):hover{background-color:#0001}#custom-navbar-home-popup .category-item a{display:flex;justify-content:space-between;align-items:center}#custom-navbar-home-popup .category-item svg{width:25px;height:25px;fill:currentColor;margin-right:10px}#custom-navbar-home-popup .category-item div{flex:1 0 auto}#custom-navbar-home-popup .category-item.main{min-width:150px}#custom-navbar-home-popup .category-item .popup{z-index:10002;width:max-content;transform:scaleX(0);transform-origin:left;padding:8px;left:100%;top:0;transition-delay:.3s;pointer-events:initial}#custom-navbar-home-popup .category-item span{opacity:.5}@media screen and (min-height:1000px){#custom-navbar-home-popup{flex-wrap:nowrap;width:250px}}.custom-navbar .popup .watchlater-list{min-height:200px;max-height:600px;width:380px;font-size:12px;display:flex;flex-flow:column nowrap;justify-content:space-between}.custom-navbar .popup .watchlater-list .empty-tip,.custom-navbar .popup .watchlater-list .loading-tip{opacity:0;pointer-events:none;position:absolute;top:50%;left:50%;transform:translateX(-50%) translateY(-50%);display:flex;align-items:center}.custom-navbar .popup .watchlater-list .empty-tip .mdi,.custom-navbar .popup .watchlater-list .loading-tip .mdi{margin-right:6px}.custom-navbar .popup .watchlater-list .empty-tip,.custom-navbar .popup .watchlater-list.loading .loading-tip{opacity:1}.custom-navbar .popup .watchlater-list.loading>:not(.loading-tip){opacity:0}.custom-navbar .popup .watchlater-list .mdi{line-height:1;font-size:18px}.custom-navbar .popup .watchlater-list .round-button{box-sizing:border-box;height:28px;border-radius:14px;display:flex;align-items:center;background-color:#8882;justify-content:center;cursor:pointer;width:28px}.custom-navbar .popup .watchlater-list .round-button:hover{background-color:#8884}.custom-navbar .popup .watchlater-list .floating{box-sizing:border-box;height:20px;border-radius:10px;display:flex;align-items:center;background-color:#000C;color:#fff;justify-content:center;cursor:pointer}.custom-navbar .popup .watchlater-list .header{display:flex;align-items:center;justify-content:space-between;margin:16px 12px}.custom-navbar .popup .watchlater-list .header .search{position:relative;flex-grow:1;margin-right:16px}.custom-navbar .popup .watchlater-list .header .search input{width:100%;padding:4px;border:none;outline:0!important;color:inherit;background-color:transparent;border-radius:4px}.custom-navbar .popup .watchlater-list .header .search input::-webkit-input-placeholder{color:inherit!important;opacity:.3}.custom-navbar .popup .watchlater-list .header .search::after{content:"";position:absolute;top:calc(100%);left:0;width:100%;height:2px;border-radius:2px;transition:.24s ease-out;background-color:#8882}.custom-navbar .popup .watchlater-list .header .search.not-empty::after,.custom-navbar .popup .watchlater-list .header .search:focus-within::after{background-color:var(--theme-color)}.custom-navbar .popup .watchlater-list .header .operations{display:flex;align-items:center}.custom-navbar .popup .watchlater-list .header .operations .round-button:not(:last-child),.custom-navbar .popup .watchlater-list .header .round-button:not(:last-child){margin-right:4px}.custom-navbar .popup .watchlater-list .header .more-info{display:flex;align-items:center;box-sizing:border-box;height:28px;border-radius:14px;padding:4px 6px 4px 10px;background-color:#8882}.custom-navbar .popup .watchlater-list .header .more-info:hover{background-color:#8884}.custom-navbar .popup .watchlater-list .header .more-info .mdi{margin-left:8px}.custom-navbar .popup .watchlater-list .cards{flex:1;overflow:auto;overscroll-behavior:contain;scroll-behavior:smooth;position:relative;scrollbar-width:none!important;padding:0 12px 12px}.custom-navbar .popup .watchlater-list .cards::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .popup .watchlater-list .cards-enter,.custom-navbar .popup .watchlater-list .cards-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .popup .watchlater-list .cards-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .popup .watchlater-list .cards .watchlater-card{cursor:pointer;flex-shrink:0;border-radius:8px;box-shadow:0 4px 8px 0 #0001;color:#000;background-color:#fff;display:grid;grid-template:"cover title" 2fr "cover info" 1fr/130px 1fr;height:85px}body.dark .custom-navbar .popup .watchlater-list .cards .watchlater-card{background-color:#282828;color:#eee}.custom-navbar .popup .watchlater-list .cards .watchlater-card:not(:last-child){margin-bottom:12px}.custom-navbar .popup .watchlater-list .cards .watchlater-card:hover .cover{transform:scale(1.05)}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container{grid-area:cover;overflow:hidden;border-radius:8px 0 0 8px;position:relative}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .floating{position:absolute;opacity:0;font-size:11px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .remove{top:6px;left:6px;width:20px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .remove .mdi{font-size:16px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .duration{left:6px;bottom:6px;padding:0 6px}body.always-show-duration .custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .duration{opacity:1}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .viewed{white-space:nowrap;right:6px;top:6px;padding:0 6px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .cover-container .cover{object-fit:cover}.custom-navbar .popup .watchlater-list .cards .watchlater-card:hover .floating{opacity:1}.custom-navbar .popup .watchlater-list .cards .watchlater-card .title{grid-area:title;font-size:13px;font-weight:700;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;max-height:3em;word-break:break-all;line-height:1.5;overflow:hidden;margin:8px 0 0;padding:0 10px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .title:hover{color:var(--theme-color)!important}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up{flex:0 1 auto;padding:2px 10px 2px 2px;margin:0 8px 6px;justify-self:start;align-self:center;max-width:calc(100% - 16px);display:flex;align-items:center;background-color:#8882;box-sizing:border-box;height:24px;border-radius:12px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up:hover{background-color:#8884}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up .face{border-radius:50%;margin-right:6px;height:20px;width:20px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up .name{overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-size:11px}.custom-navbar .popup .watchlater-list .cards .watchlater-card .up:hover .name{color:var(--theme-color)}.custom-navbar .popup .watchlater-list .undo{position:absolute;bottom:16px;left:50%;opacity:0;transform:translateX(-50%) translateY(8px)}.custom-navbar .popup .watchlater-list .undo.show{opacity:1;transform:translateX(-50%) translateY(0)}.custom-navbar .favorites-list{width:380px;height:600px;font-size:12px;display:flex;align-items:stretch;flex-direction:column;justify-content:center}.custom-navbar .favorites-list .dropdown-menu{max-height:500px;overflow:auto}.custom-navbar .favorites-list .empty-tip,.custom-navbar .favorites-list .loading-tip{display:flex;justify-content:center;width:100%}.custom-navbar .favorites-list>.loading-tip{display:none}.custom-navbar .favorites-list .mdi{line-height:1;font-size:18px}.custom-navbar .favorites-list.loading>.loading-tip{display:flex}.custom-navbar .favorites-list.loading>:not(.loading-tip){display:none}.custom-navbar .favorites-list .content{display:flex;align-items:stretch;flex-direction:column;scrollbar-width:none!important;justify-content:space-between;flex-grow:1;overflow:auto}.custom-navbar .favorites-list .content::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .favorites-list .content .floating{box-sizing:border-box;height:20px;border-radius:10px;display:flex;align-items:center;background-color:#000c;color:#fff;justify-content:center;cursor:pointer}.custom-navbar .favorites-list .content .header{display:flex;align-items:center;justify-content:space-between;margin:16px 12px}.custom-navbar .favorites-list .content .header .search{position:relative;flex-grow:1;margin-right:16px}.custom-navbar .favorites-list .content .header .search input{width:100%;padding:4px;border:none;outline:0!important;color:inherit;background-color:transparent;border-radius:4px}.custom-navbar .favorites-list .content .header .search input::-webkit-input-placeholder{color:inherit!important;opacity:.3}.custom-navbar .favorites-list .content .header .search::after{content:"";position:absolute;top:calc(100%);left:0;width:100%;height:2px;border-radius:2px;transition:.24s ease-out;background-color:#8882}.custom-navbar .favorites-list .content .header .search.not-empty::after,.custom-navbar .favorites-list .content .header .search:focus-within::after{background-color:var(--theme-color)}.custom-navbar .favorites-list .content .header .list-select{flex-shrink:0;height:26px}.custom-navbar .favorites-list .content .header .more-info{display:flex;align-items:center;box-sizing:border-box;height:26px;border-radius:13px;flex-shrink:0;padding:4px;background-color:#8882}.custom-navbar .favorites-list .content .header .more-info:hover{background-color:#8884}.custom-navbar .favorites-list .content .header .play-all-container{flex-shrink:0;padding:0 6px;display:flex;align-items:center;justify-content:flex-start}.custom-navbar .favorites-list .content .header .play-all-container .play-all{display:flex;align-items:center;box-sizing:border-box;height:26px;border-radius:13px;padding:4px;background-color:#8882}.custom-navbar .favorites-list .content .header .play-all-container .play-all:hover{background-color:#8884}.custom-navbar .favorites-list .content .cards{flex:1;overflow:auto;overscroll-behavior:contain;scroll-behavior:smooth;position:relative;scrollbar-width:none!important;padding:0 12px 12px}.custom-navbar .favorites-list .content .cards::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .favorites-list .content .cards-enter,.custom-navbar .favorites-list .content .cards-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .favorites-list .content .cards-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .favorites-list .content .cards .favorite-card{cursor:pointer;flex-shrink:0;border-radius:8px;box-shadow:0 4px 8px 0 #0001;color:#000;background-color:#fff;display:grid;grid-template:"cover title" 2fr "cover info" 1fr/130px 1fr;height:85px}body.dark .custom-navbar .favorites-list .content .cards .favorite-card{background-color:#282828;color:#eee}.custom-navbar .favorites-list .content .cards .favorite-card:not(:last-child){margin-bottom:12px}.custom-navbar .favorites-list .content .cards .favorite-card:hover .cover{transform:scale(1.05)}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container{grid-area:cover;overflow:hidden;border-radius:8px 0 0 8px;position:relative}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .floating{position:absolute;opacity:0;font-size:11px}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .favorite-time{top:6px;left:6px;padding:0 6px}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .duration{left:6px;bottom:6px;padding:0 6px}body.always-show-duration .custom-navbar .favorites-list .content .cards .favorite-card .cover-container .duration{opacity:1}.custom-navbar .favorites-list .content .cards .favorite-card .cover-container .cover{object-fit:cover}.custom-navbar .favorites-list .content .cards .favorite-card:hover .floating{opacity:1}.custom-navbar .favorites-list .content .cards .favorite-card .title{grid-area:title;font-size:13px;font-weight:700;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;-webkit-box-align:start;max-height:3em;word-break:break-all;line-height:1.5;overflow:hidden;margin:8px 0 0;padding:0 10px}.custom-navbar .favorites-list .content .cards .favorite-card .title:hover{color:var(--theme-color)!important}.custom-navbar .favorites-list .content .cards .favorite-card .up{flex:0 1 auto;padding:2px 10px 2px 2px;margin:0 8px 6px;justify-self:start;align-self:center;max-width:calc(100% - 16px);display:flex;align-items:center;box-sizing:border-box;height:24px;border-radius:12px;background-color:#8882}.custom-navbar .favorites-list .content .cards .favorite-card .up:hover{background-color:#8884}.custom-navbar .favorites-list .content .cards .favorite-card .up .face{border-radius:50%;margin-right:6px;height:20px;width:20px;object-fit:cover}body.dark .custom-navbar .favorites-list .content .cards .favorite-card .up .face.placeholder{filter:invert(.9)}.custom-navbar .favorites-list .content .cards .favorite-card .up .name{overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-size:11px}.custom-navbar .favorites-list .content .cards .favorite-card .up:hover .name{color:var(--theme-color)}.custom-navbar .history-list{width:350px;height:600px;font-size:12px;padding:0;margin:0;display:flex;align-items:stretch;flex-direction:column;justify-content:center}.custom-navbar .history-list .loading-tip{display:flex;justify-content:center;width:100%}.custom-navbar .history-list>.loading-tip{display:none}.custom-navbar .history-list .mdi{line-height:1;font-size:18px}.custom-navbar .history-list.loading>.loading-tip{display:flex}.custom-navbar .history-list.loading>:not(.loading-tip){display:none}.custom-navbar .history-list .content{display:flex;align-items:stretch;flex-direction:column;scrollbar-width:none!important;justify-content:space-between;flex-grow:1;overflow:auto}.custom-navbar .history-list .content::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .history-list .content .header{display:flex;align-items:center;justify-content:space-between;margin:16px 12px}.custom-navbar .history-list .content .header .search{position:relative;flex-grow:1;margin-right:16px}.custom-navbar .history-list .content .header .search input{width:100%;padding:4px;border:none;outline:0!important;color:inherit;background-color:transparent;border-radius:4px}.custom-navbar .history-list .content .header .search input::-webkit-input-placeholder{color:inherit!important;opacity:.3}.custom-navbar .history-list .content .header .search::after{content:"";position:absolute;top:calc(100%);left:0;width:100%;height:2px;border-radius:2px;transition:.24s ease-out;background-color:#8882}.custom-navbar .history-list .content .header .search.not-empty::after,.custom-navbar .history-list .content .header .search:focus-within::after{background-color:var(--theme-color)}.custom-navbar .history-list .content .header .tabs{flex:0;margin:0 16px 0 0;padding:0 6px;display:flex;align-items:center;justify-content:flex-start}.custom-navbar .history-list .content .header .tabs .tab{cursor:pointer;position:relative;white-space:nowrap}.custom-navbar .history-list .content .header .tabs .tab:not(:last-child){margin-right:24px}.custom-navbar .history-list .content .header .tabs .tab::after{content:"";width:calc(80%);height:2px;border-radius:1px;position:absolute;background-color:var(--theme-color);left:10%;bottom:-4px;transform:scaleX(0);transition:.2s ease-out}.custom-navbar .history-list .content .header .tabs .tab.active::after{transform:scaleX(1)}.custom-navbar .history-list .content .header .tabs .tab .tab-name{opacity:.5;line-height:normal}.custom-navbar .history-list .content .header .tabs .tab.active{transform:scale(1.2)}.custom-navbar .history-list .content .header .tabs .tab.active .tab-name{font-weight:700;opacity:1}.custom-navbar .history-list .content .header .more-info{display:flex;align-items:center;box-sizing:border-box;height:26px;border-radius:13px;flex-shrink:0;padding:4px;background-color:#8882;border:none;cursor:pointer;color:inherit;font-size:inherit}.custom-navbar .history-list .content .header .more-info:disabled{opacity:.3;cursor:not-allowed}.custom-navbar .history-list .content .header .more-info:hover:not(:disabled){background-color:#8884}.custom-navbar .history-list .content .history-content{flex:1;overflow:auto;overscroll-behavior:contain;scroll-behavior:smooth;position:relative;scrollbar-width:none!important;padding:0 12px 12px}.custom-navbar .history-list .content .history-content-enter,.custom-navbar .history-list .content .history-content-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .history-list .content .history-content-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .history-list .content .history-content::-webkit-scrollbar{height:0!important;width:0!important}.custom-navbar .history-list .content .history-content .empty-tip{text-align:center}.custom-navbar .history-list .content .history-content .time-group{padding-bottom:16px}.custom-navbar .history-list .content .history-content .time-group-enter,.custom-navbar .history-list .content .history-content .time-group-leave-to{opacity:0;transform:translateY(-16px) scale(.9)}.custom-navbar .history-list .content .history-content .time-group-leave-active{transition:.24s cubic-bezier(.22,.61,.36,1);position:absolute}.custom-navbar .history-list .content .history-content .time-group-name{padding-bottom:4px;margin-bottom:4px}.custom-navbar .history-list .content .history-content .time-group-items .floating{box-sizing:border-box;height:20px;border-radius:10px;display:flex;align-items:center;background-color:#000c;color:#fff;justify-content:center;position:absolute;opacity:0;font-size:11px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item{display:grid;grid-template:"cover title title" 3fr "cover up time" 2fr/80px 1fr auto;border-radius:4px 8px 8px 4px;color:#000;background-color:#fff;box-shadow:0 4px 8px 0 #0001}body.dark .custom-navbar .history-list .content .history-content .time-group-items .time-group-item{background-color:#282828;color:#eee}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item:not(:last-child){margin-bottom:8px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item:hover .cover{transform:scale(1.05)}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item:hover .floating{opacity:1}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container{grid-area:cover;position:relative;height:55px;overflow:hidden;border-radius:4px 0 0 4px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .cover{object-fit:cover;width:80px;height:55px}body.dark .custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .cover.placeholder{filter:invert(.9)}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .duration{left:2px;bottom:2px;padding:0 6px}body.always-show-duration .custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .duration{opacity:1}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .progress-number{left:2px;top:2px;padding:0 6px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .cover-container .progress{position:absolute;bottom:0;left:0;height:2px;border-radius:1px;background-color:var(--theme-color)}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .title{grid-area:title;font-weight:700;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;align-self:center;margin:0;line-height:normal;display:block;padding-left:8px;padding-right:6px;font-size:13px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .title:hover{color:var(--theme-color)!important}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .time,.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up{font-size:11px;opacity:.75;align-self:start}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up{grid-area:up;display:flex;align-items:center;padding-left:8px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up:hover{opacity:1}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up .be-icon{margin-right:4px;font-size:14px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .up-name{white-space:nowrap;max-width:160px;overflow:hidden;text-overflow:ellipsis}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .live-status,.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .time{font-size:11px;grid-area:time;padding-right:6px}.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .live-status.live,.custom-navbar .history-list .content .history-content .time-group-items .time-group-item .time.live{color:var(--theme-color)}.custom-navbar>ul>li:not(.disabled) .popup-container{position:absolute;top:100%;left:50%}#custom-navbar-home-popup .category-item:hover .popup,#custom-navbar-search:focus-within~.search-list:not(.empty),.custom-navbar .search-list:not(.empty):focus-within,.custom-navbar>ul>li:not(.disabled):hover .popup-container>.popup{transform:translateY(0) translateX(-50%);pointer-events:initial;opacity:1}.custom-navbar>ul>li:not(.disabled).right-side:hover .popup-container>.popup{transform:translateY(0) translateX(-90%);left:100%}.custom-navbar>ul>li:not(.disabled).left-side:hover .popup-container>.popup{transform:translateY(0) translateX(10%);left:0}#custom-navbar-home-popup .category-item:hover .popup{transform:scaleX(1)}.custom-navbar.compact #custom-navbar-home-popup .category-item{padding:6px}.custom-navbar.compact #custom-navbar-home-popup .category-item.main{min-width:110px}#custom-navbar-home-popup .category-item .popup a,#message-list a,#ranking-list a,#upload-actions a{position:relative;padding:8px;display:flex;justify-content:start;border-bottom:2px solid transparent;font-size:11pt;line-height:16pt}#custom-navbar-home-popup .category-item .popup a::before,#message-list a::before,#ranking-list a::before,#upload-actions a::before{content:"";position:absolute;top:calc(100% - 4px);left:8px;width:calc(100% - 16px);height:2px;border-radius:2px;background-color:var(--theme-color);transition:.16s ease-out .1s;transform:scaleX(0)}.custom-navbar.compact #custom-navbar-home-popup .category-item .popup a{padding:6px}#custom-navbar-home-popup .category-item .popup a:hover::before,#message-list a:hover::before,#ranking-list a:hover::before,#upload-actions a:hover::before{transform:scaleX(1)}.im-list-box{border-radius:0!important}#upload-button{padding-left:4px;font-size:12pt;font-weight:700}#message-list,#ranking-list,#upload-actions{width:max-content}#message-list a[data-count]::after{content:attr(data-count);position:absolute;left:100%;top:50%;transform:translateY(-50%);background-color:var(--theme-color);color:var(--foreground-color);padding:0 6px;display:flex;justify-content:center;font-size:9pt;border-radius:6px;white-space:nowrap}@media screen and (max-width:1300px){.custom-navbar form input{width:200px}}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar.min.html"]=`<svg aria-hidden=true style="position: absolute; width: 0px; height: 0px; overflow: hidden;"><symbol id=header-icon-animal viewBox="0 0 1024 1024"><path d="M517.376 465.152a144.924444 144.924444 0 0 1 137.528889 99.214222c1.28 3.925333 2.275556 7.850667 2.901333 11.804445a132.266667 132.266667 0 0 1-14.279111 263.765333h-263.054222a132.266667 132.266667 0 0 1-14.250667-263.793778c0.625778-3.982222 1.592889-7.907556 2.872889-11.776a144.924444 144.924444 0 0 1 137.528889-99.214222h10.752zM420.693333 418.104889c50.261333-3.783111 85.617778-59.164444 79.047111-123.733333-6.599111-64.568889-52.650667-113.891556-102.912-110.108445-50.232889 3.754667-85.617778 59.164444-79.018666 123.733333 6.599111 64.568889 52.650667 113.863111 102.912 110.08zM603.306667 418.104889c50.232889 3.754667 96.284444-45.511111 102.883555-110.108445 6.599111-64.568889-28.785778-119.978667-79.018666-123.733333-50.261333-3.783111-96.312889 45.511111-102.912 110.08-6.599111 64.568889 28.785778 119.978667 79.018666 123.733333zM717.425778 551.139556c39.082667 21.816889 96.910222-4.266667 129.137778-58.225778 32.256-53.959111 26.709333-115.370667-12.373334-137.187556-39.111111-21.816889-96.938667 4.266667-129.166222 58.225778-32.256 53.959111-26.709333 115.370667 12.401778 137.187556zM306.574222 551.139556c39.111111-21.816889 44.657778-83.228444 12.401778-137.187556-32.227556-53.959111-90.055111-80.042667-129.137778-58.225778-39.111111 21.816889-44.657778 83.228444-12.430222 137.187556 32.256 53.959111 90.083556 80.042667 129.166222 58.225778z"fill=#FB7299></path><path d="M621.511111 113.777778c76.231111-0.938667 138.467556 74.012444 149.504 173.340444 37.745778-13.312 75.861333-12.913778 107.292445 4.323556 70.712889 38.769778 80.753778 147.968 22.442666 243.911111a272.327111 272.327111 0 0 1-71.111111 78.336c9.159111 22.869333 14.222222 47.843556 14.222222 73.984V711.111111a199.111111 199.111111 0 0 1-199.111111 199.111111h-265.500444a199.111111 199.111111 0 0 1-199.111111-199.111111v-23.438222c0-26.168889 5.063111-51.114667 14.222222-74.012445a272.099556 272.099556 0 0 1-71.111111-78.307555c-58.311111-95.943111-48.270222-205.141333 22.442666-243.911111 31.431111-17.237333 69.546667-17.635556 107.320889-4.352C264.021333 187.790222 326.257778 112.839111 402.488889 113.777778c42.410667 0.540444 81.152 24.462222 109.511111 62.776889 28.359111-38.286222 67.100444-62.236444 109.511111-62.776889z"fill=#FFD7E7></path><path d="M512 465.152a141.198222 141.198222 0 0 1 134.741333 98.958222l0.085334 0.256c1.905778 6.087111 3.015111 12.231111 3.356444 18.289778a132.266667 132.266667 0 0 1-9.728 264.163556h-256.910222a132.266667 132.266667 0 0 1-9.671111-264.192l-0.199111 4.579555c0-7.736889 1.194667-15.445333 3.498666-22.840889l0.085334-0.284444A141.198222 141.198222 0 0 1 512 465.180444zM420.693333 418.104889c50.261333-3.783111 85.617778-59.164444 79.047111-123.733333-6.599111-64.568889-52.650667-113.891556-102.912-110.108445-50.232889 3.754667-85.617778 59.164444-79.018666 123.733333 6.599111 64.568889 52.650667 113.863111 102.912 110.08zM603.306667 418.104889c50.232889 3.754667 96.284444-45.511111 102.883555-110.108445 6.599111-64.568889-28.785778-119.978667-79.018666-123.733333-50.261333-3.783111-96.312889 45.511111-102.912 110.08-6.599111 64.568889 28.785778 119.978667 79.018666 123.733333zM717.425778 551.139556c39.082667 21.816889 96.910222-4.266667 129.137778-58.225778 32.256-53.959111 26.709333-115.370667-12.373334-137.187556-39.111111-21.816889-96.938667 4.266667-129.166222 58.225778-32.256 53.959111-26.709333 115.370667 12.401778 137.187556zM306.574222 551.139556c39.111111-21.816889 44.657778-83.228444 12.401778-137.187556-32.227556-53.959111-90.055111-80.042667-129.137778-58.225778-39.111111 21.816889-44.657778 83.228444-12.430222 137.187556 32.256 53.959111 90.083556 80.042667 129.166222 58.225778z"fill=#FB7299></path></symbol><symbol id=header-icon-musicplus viewBox="0 0 1024 1024"><path d="M128 256m25.6 0l716.8 0q25.6 0 25.6 25.6l0 512q0 25.6-25.6 25.6l-716.8 0q-25.6 0-25.6-25.6l0-512q0-25.6 25.6-25.6Z"fill=#3DA9D3></path><path d="M153.6 256h153.6v563.2H153.6a25.6 25.6 0 0 1-25.6-25.6V281.6a25.6 25.6 0 0 1 25.6-25.6zM870.4 256h-153.6v563.2h153.6a25.6 25.6 0 0 0 25.6-25.6V281.6a25.6 25.6 0 0 0-25.6-25.6z"fill=#7DD3E0></path><path d="M768 320m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path><path d="M768 448m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path><path d="M768 576m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path><path d="M768 704m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path><path d="M576 180.736c8.7808-2.6112 15.8976-1.92 21.3504 2.0736 5.4784 3.9936 11.008 9.8304 16.64 17.4592 5.6064 7.6544 12.544 16.256 20.7616 25.856 8.2432 9.5744 19.456 18.5088 33.6896 26.7776 12.2368 7.68 22.9632 12.9536 32.2048 15.7696l25.9584 7.8592c8.2176 2.432 16.128 5.5296 23.6544 9.2672 0 0 17.7408 9.984 25.5232 20.48 8.1152 10.9056 14.8736 19.6608 16.6144 30.976 1.7152 11.3408 1.6128 21.9136-0.4608 31.6928a72.7296 72.7296 0 0 1-9.5744 24.576c-4.2752 6.5792-7.8592 9.9328-10.752 9.9328-2.8672 0.0256-5.4016-1.6128-7.6032-5.0432-2.2272-3.3792-3.84-9.984-4.864-19.7632-1.6896-15.872-6.656-27.0336-14.976-33.4592-8.32-6.4256-21.3504-9.984-39.1424-10.7264a96.0512 96.0512 0 0 1-48.9216-15.616c-12.3648-8.0384-24.064-16.9984-34.9696-26.8032-8.8832-7.3728-15.7952-9.5488-20.8896-6.2976-4.992 3.2256-7.5776 8.1152-7.7312 14.7456l-0.5632 26.752-6.7072 273.792-0.7936 35.4048c0.1536 9.856-1.664 21.1968-5.4272 33.9968-3.7888 12.8-10.6752 25.2928-20.6592 37.4528-9.9328 12.16-23.0912 23.2192-39.4752 33.2288s-36.5824 17.3568-60.5952 22.0672c-24.448 4.7616-46.4128 3.584-65.8944-3.5072-19.456-7.0912-34.3808-17.4336-44.7744-31.0272-10.24-12.928-15.4368-29.5936-14.7712-47.5136 0.6912-18.048 8.8576-36.0448 24.4736-53.9648 15.616-17.92 32.4352-31.2832 50.432-40.1152a198.8096 198.8096 0 0 1 51.8144-17.7152 178.8416 178.8416 0 0 1 44.3136-3.0208c13.0048 1.0496 22.5792 2.3808 28.7488 3.9424 0 0 6.4512-280.1664 8.2944-341.6064 0.2304-12.1088 3.584-22.3232 9.9328-30.976 6.4-8.5504 14.7712-14.208 25.1392-16.9472z m160.9216 288.1792a12.8 12.8 0 0 1 0.3584 2.9696v40.96l41.728-6.912a12.8 12.8 0 0 1 14.8992 12.5952v15.0016a12.8 12.8 0 0 1-10.7008 12.6464l-45.952 7.6288 0.0256 45.3632a12.8 12.8 0 0 1-9.8304 12.4416l-15.36 3.6608a12.8 12.8 0 0 1-15.7696-12.4416V560.64l-41.1136 6.8608a12.8 12.8 0 0 1-14.8992-12.6208v-15.0016a12.8 12.8 0 0 1 10.7008-12.6464l45.312-7.552v-44.1344a12.8 12.8 0 0 1 9.8304-12.4672l15.36-3.6352a12.8 12.8 0 0 1 15.4112 9.472z"fill=#FFD469></path><path d="M179.2 320m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path><path d="M179.2 448m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path><path d="M179.2 576m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path><path d="M179.2 704m15.36 0l46.08 0q15.36 0 15.36 15.36l0 20.48q0 15.36-15.36 15.36l-46.08 0q-15.36 0-15.36-15.36l0-20.48q0-15.36 15.36-15.36Z"fill=#3DA9D3></path></symbol><symbol id=header-icon-zhishi viewBox="0 0 1024 1024"><path d="M781.3671875 132.3125C842.2859375 132.3125 891.6875 182.684375 891.6875 244.8265625v533.334375c0 62.1-49.359375 112.471875-110.3203125 112.471875H518.75c0-16.115625-25.6921875-29.1515625-57.375-29.1515625-31.6828125 0-57.375 13.078125-57.375 29.1515625H284.8203125C223.9015625 890.6328125 174.5 840.2609375 174.5 778.203125V244.8265625C174.5 182.684375 223.859375 132.3125 284.8203125 132.3125h496.546875z"fill=#FBC92A></path><path d="M781.3671875 132.3125C842.2859375 132.3125 891.6875 182.684375 891.6875 244.8265625v209.671875c-49.4859375 4.89375-86.0625 22.021875-86.0625 42.3984375 0 20.3765625 36.5765625 37.546875 86.0625 42.35625v34.7203125c0 62.1421875-49.359375 112.5140625-110.3203125 112.5140625H284.8203125C223.9015625 686.4875 174.5 636.115625 174.5 573.9734375V244.8265625C174.5 182.684375 223.859375 132.3125 284.8203125 132.3125h496.546875z"fill=#FFEA85></path><path d="M346.625 686.4875a114.75 58.3453125 0 1 0 229.5 0 114.75 58.3453125 0 1 0-229.5 0Z"fill=#FBC92A></path><path d="M260.5625 803.1359375a43.03125 42.1875 0 1 0 86.0625 0 43.03125 42.1875 0 1 0-86.0625 0Z"fill=#F4B828></path><path d="M490.0625 803.1359375a71.71875 42.1875 0 1 0 143.4375 0 71.71875 42.1875 0 1 0-143.4375 0Z"fill=#F4B828></path><path d="M674.50625 477.4484375a27.2109375 27.2109375 0 0 1 39.0234375 1.2234375 28.51875 28.51875 0 0 1-1.18125 39.740625 238.021875 238.021875 0 0 1-330.91875 0 28.51875 28.51875 0 0 1-1.18125-39.740625 27.2109375 27.2109375 0 0 1 38.98125-1.2234375 183.6421875 183.6421875 0 0 0 255.2765625 0z"fill=#FBC92A></path><path d="M734.7921875 272.9234375h5.1890625a41.765625 41.765625 0 0 1 41.34375 42.1875v56.278125c0 23.2875-18.478125 42.1875-41.34375 42.1875h-5.1890625a41.765625 41.765625 0 0 1-41.34375-42.1875V315.1109375c0-23.2875 18.5203125-42.1875 41.34375-42.1875zM353.796875 272.9234375h5.1890625a41.765625 41.765625 0 0 1 41.34375 42.1875v56.278125c0 23.2875-18.5203125 42.1875-41.34375 42.1875H353.796875a41.765625 41.765625 0 0 1-41.34375-42.1875V315.1109375c0-23.2875 18.478125-42.1875 41.34375-42.1875z"fill=#FBC92A></path></symbol><symbol id=header-icon-food viewBox="0 0 1024 1024"><path d="M192.075294 503.883294m-75.294118 0a75.294118 75.294118 0 1 0 150.588236 0 75.294118 75.294118 0 1 0-150.588236 0Z"fill=#FA942D></path><path d="M342.663529 411.211294m-75.294117 0a75.294118 75.294118 0 1 0 150.588235 0 75.294118 75.294118 0 1 0-150.588235 0Z"fill=#FA942D></path><path d="M284.747294 480.722824m-75.294118 0a75.294118 75.294118 0 1 0 150.588236 0 75.294118 75.294118 0 1 0-150.588236 0Z"fill=#FE5D79></path><path d="M765.470118 532.841412m-127.427765 0a127.427765 127.427765 0 1 0 254.855529 0 127.427765 127.427765 0 1 0-254.855529 0Z"fill=#FA942D></path><path d="M632.259765 457.547294m-133.210353 0a133.210353 133.210353 0 1 0 266.420706 0 133.210353 133.210353 0 1 0-266.420706 0Z"fill=#FA942D></path><path d="M672.798118 556.016941m-150.588236 0a150.588235 150.588235 0 1 0 301.176471 0 150.588235 150.588235 0 1 0-301.176471 0Z"fill=#FE5D79></path><path d="M932.291765 474.925176a28.762353 28.762353 0 0 1 28.747294 28.762353l-0.045177 1.355295-0.090353 1.355294c-14.305882 150.919529-130.605176 272.865882-280.741647 299.188706l20.178824 80.745411a23.160471 23.160471 0 0 1-22.467765 28.777412H343.371294a23.160471 23.160471 0 0 1-22.467765-28.777412l20.178824-80.745411C192.813176 779.595294 77.552941 660.329412 60.928 512.015059l-0.557176-5.376a28.958118 28.958118 0 0 1 28.822588-31.713883h843.083294z"fill=#FDDC7A></path><path d="M442.548706 196.924235h136.146823c21.263059 0 39.800471 14.456471 44.950589 35.087059l60.732235 242.913882H336.865882l60.732236-242.898823a46.336 46.336 0 0 1 44.950588-35.102118z"fill=#F6C338></path><path d="M688.037647 192.903529c9.441882-30.177882 28.385882-29.409882 34.680471-47.585882 7.062588-20.449882 9.366588-45.718588 6.927058-75.821176 16.850824 17.935059 25.976471 37.014588 30.945883 62.283294 4.894118 24.937412-9.125647 44.182588-29.06353 74.480941-19.922824 30.313412-8.809412 67.614118 0 94.915765-16.850824-17.92-59.904-55.777882-43.474823-108.272942zM283.361882 154.247529c11.324235-37.707294 34.063059-36.773647 41.60753-59.482353 8.493176-25.554824 11.264-57.133176 8.31247-94.765176 20.239059 22.407529 31.201882 46.260706 37.165177 77.854118 5.872941 31.171765-10.947765 55.220706-34.876235 93.108706-23.943529 37.872941-10.601412 84.48 0 118.633411-20.239059-22.422588-71.936-69.722353-52.208942-135.348706z"fill=#C6D2E1></path><path d="M510.629647 706.605176a92.672 92.672 0 0 1 92.672 92.672v115.832471H417.957647v-115.832471a92.672 92.672 0 0 1 92.672-92.672z"fill=#F5BC20></path></symbol><symbol id=header-icon-music viewBox="0 0 1024 1024"><path d="M881.92 460.8A335.36 335.36 0 0 0 547.584 125.696h-73.216A335.616 335.616 0 0 0 139.776 460.8v313.6a18.688 18.688 0 0 0 18.432 18.688h41.984c13.568 46.336 37.888 80.384 88.576 80.384h98.304a37.376 37.376 0 0 0 37.376-36.864l1.28-284.672a36.864 36.864 0 0 0-37.12-37.12h-99.84a111.616 111.616 0 0 0-51.2 12.8v-73.216a242.432 242.432 0 0 1 241.664-241.664h67.328a242.176 242.176 0 0 1 241.408 241.664v74.496a110.592 110.592 0 0 0-54.272-14.08h-99.84a36.864 36.864 0 0 0-37.12 37.12v284.672a37.376 37.376 0 0 0 37.376 36.864h98.304c51.2 0 75.008-34.048 88.576-80.384h41.984a18.688 18.688 0 0 0 18.432-18.688z"fill=#45C7DD></path><path d="M646.141043 825.220963m0.045396-32.511969l0.273801-196.095809q0.045395-32.511968 32.557364-32.466573l1.023999 0.00143q32.511968 0.045395 32.466573 32.557364l-0.273802 196.095809q-0.045395 32.511968-32.557363 32.466573l-1.023999-0.00143q-32.511968-0.045395-32.466573-32.557364Z"fill=#FF5C7A></path><path d="M307.222608 825.246563m0.045395-32.511969l0.273801-196.095809q0.045395-32.511968 32.557364-32.466573l1.023999 0.00143q32.511968 0.045395 32.466573 32.557364l-0.273801 196.095809q-0.045395 32.511968-32.557364 32.466573l-1.023999-0.00143q-32.511968-0.045395-32.466573-32.557364Z"fill=#FF5C7A></path></symbol><symbol id=header-icon-information viewBox="0 0 1024 1024"><path d="M760.685714 768a21.942857 21.942857 0 0 0 19.836343 21.840457L782.628571 789.942857a21.942857 21.942857 0 0 0 21.840458-19.836343L804.571429 768V321.828571h29.257142a58.514286 58.514286 0 0 1 58.514286 58.514286v438.857143a58.514286 58.514286 0 0 1-58.514286 58.514286H190.171429a58.514286 58.514286 0 0 1-58.514286-58.514286V204.8a58.514286 58.514286 0 0 1 58.514286-58.514286h512a58.514286 58.514286 0 0 1 58.514285 58.514286v563.2z"fill=#7DD3E0></path><path d="M219.428571 234.057143m29.257143 0l394.971429 0q29.257143 0 29.257143 29.257143l0 263.314285q0 29.257143-29.257143 29.257143l-394.971429 0q-29.257143 0-29.257143-29.257143l0-263.314285q0-29.257143 29.257143-29.257143Z"fill=#3DA9D3></path><path d="M404.772571 300.514743l129.462858 80.925257a15.945143 15.945143 0 0 1 0 27.062857l-129.462858 80.925257a15.945143 15.945143 0 0 1-24.429714-13.531428V314.046171a15.945143 15.945143 0 0 1 24.429714-13.531428z"fill=#FFD469></path><path d="M219.428571 614.4m29.257143 0l394.971429 0q29.257143 0 29.257143 29.257143l0 0q0 29.257143-29.257143 29.257143l-394.971429 0q-29.257143 0-29.257143-29.257143l0 0q0-29.257143 29.257143-29.257143Z"fill=#3DA9D3></path><path d="M219.428571 731.428571m29.257143 0l219.428572 0q29.257143 0 29.257143 29.257143l0 0q0 29.257143-29.257143 29.257143l-219.428572 0q-29.257143 0-29.257143-29.257143l0 0q0-29.257143 29.257143-29.257143Z"fill=#3DA9D3></path></symbol><symbol id=header-icon-game viewBox="0 0 1024 1024"><path d="M166.4 166.144m90.112 0l510.976 0q90.112 0 90.112 90.112l0 510.976q0 90.112-90.112 90.112l-510.976 0q-90.112 0-90.112-90.112l0-510.976q0-90.112 90.112-90.112Z"fill=#58D598></path><path d="M307.2 325.632h136.448v136.448H307.2zM580.096 325.632h136.448v136.448h-136.448z"fill=#17AD8A></path><path d="M443.648 462.336v75.776h-64.256v204.544h59.392v-68.096H585.216v68.096h59.136v-204.544h-64.256v-75.776h-136.448z"fill=#17AD8A></path></symbol><symbol id=header-icon-dance viewBox="0 0 1024 1024"><path d="M956.672 513.792a476.416 476.416 0 0 0-890.368 0L512 727.296l-95.232 45.568a117.76 117.76 0 0 0 192.256 0L512 727.04z"fill=#FC6B8A></path><path d="M512 727.296l208.64-99.84a222.976 222.976 0 0 0-416.768 0z"fill=#FFFFFF></path><path d="M405.4528 751.5392l541.184-258.5856 14.0288 29.312-541.184 258.6112z"fill=#FF5C7A></path><path d="M666.624 545.792l-18.688-15.36-112.64 135.424 40.192-173.056-23.552-5.632-40.192 172.544-40.448-172.544-23.808 5.632 40.704 173.056-112.896-135.424-18.688 15.36 111.616 134.144-391.68-186.88-13.824 29.184 541.184 258.56 14.08-29.44-87.552-41.728 136.192-163.84z"fill=#F14767></path></symbol><symbol id=header-icon-zhibo viewBox="0 0 1024 1024"><path d="M392.448 332.8a92.416 92.416 0 1 1-92.416-92.416A92.416 92.416 0 0 1 392.448 332.8"fill=#23ADE5></path><path d="M572.928 426.24A143.872 143.872 0 1 0 429.312 281.6a143.872 143.872 0 0 0 143.616 144.64zM826.624 521.472l-63.744 36.864v-48.64A72.192 72.192 0 0 0 691.2 437.76H190.72a72.192 72.192 0 0 0-71.936 71.936v295.424a71.936 71.936 0 0 0 71.936 71.936H691.2a71.936 71.936 0 0 0 71.936-71.936v-23.808L826.624 819.2a51.2 51.2 0 0 0 76.8-44.544V565.76a51.2 51.2 0 0 0-76.8-44.288z"fill=#48CFE5></path><path d="M425.216 569.856l124.16 71.936a25.6 25.6 0 0 1 0 42.496l-124.16 71.68a25.6 25.6 0 0 1-37.12-21.248v-143.36a25.6 25.6 0 0 1 37.12-21.504"fill=#FDDE80></path></symbol><symbol id=header-icon-ent viewBox="0 0 1024 1024"><path d="M534.442796 378.982175m36.203867 36.203867l30.592268 30.592268q36.203867 36.203867 0 72.407734l-360.590518 360.590518q-36.203867 36.203867-72.407734 0l-30.592268-30.592268q-36.203867-36.203867 0-72.407735l360.590518-360.590517q36.203867-36.203867 72.407734 0Z"fill=#FF8693></path><path d="M369.92 543.744l137.472-137.472a38.912 38.912 0 0 1 54.528 0l48.384 48.64a38.4 38.4 0 0 1 0 54.528l-137.984 137.984z"fill=#FC6376></path><path d="M286.133941 631.021801m12.854616 12.85013l72.601422 72.576083q12.854616 12.850129 0.004486 25.704746l-1.62889 1.629458q-12.850129 12.854616-25.704745 0.004486l-72.601422-72.576083q-12.854616-12.850129-0.004486-25.704745l1.62889-1.629459q12.850129-12.854616 25.704745-0.004486Z"fill=#FFA9B1></path><path d="M737.024 547.584a99.328 99.328 0 0 1 62.72-62.72l51.2-13.568a27.136 27.136 0 0 0 13.056-49.664L826.624 384a98.816 98.816 0 0 1-22.784-85.76l16.896-63.232c7.168-27.136-8.96-43.52-36.096-36.096l-63.232 16.896a98.816 98.816 0 0 1-85.76-23.04l-37.376-36.864a27.136 27.136 0 0 0-49.408 13.312l-13.824 51.2a97.792 97.792 0 0 1-62.464 62.72l-51.2 13.824a27.136 27.136 0 0 0-13.312 49.408L445.44 384a97.536 97.536 0 0 1 23.04 85.504l-16.896 63.232c-7.424 27.392 8.96 43.52 36.096 36.352l63.232-16.896a97.792 97.792 0 0 1 85.76 22.784l37.376 37.376a26.88 26.88 0 0 0 49.408-13.312z"fill=#FDDE80></path><path d="M886.272 417.536l-74.752-75.008 30.464-114.432a41.216 41.216 0 0 0-8.704-41.472A41.728 41.728 0 0 0 791.808 179.2l-114.432 30.72-74.752-76.032A41.728 41.728 0 0 0 563.2 120.576a41.216 41.216 0 0 0-28.416 31.488l-27.392 102.4L404.48 281.6a42.24 42.24 0 0 0-31.744 28.16 42.24 42.24 0 0 0 13.312 40.448L460.8 425.216l-30.72 114.432a41.728 41.728 0 0 0 8.96 41.472 37.888 37.888 0 0 0 27.392 10.752 56.832 56.832 0 0 0 14.08-2.048l114.432-30.72 74.752 75.008a45.824 45.824 0 0 0 31.232 14.336 34.304 34.304 0 0 0 8.96 0 41.216 41.216 0 0 0 28.416-31.488l27.392-102.4 102.4-27.392a41.984 41.984 0 0 0 31.488-28.416 40.96 40.96 0 0 0-13.312-41.216z m-84.736-203.52h5.12a16.896 16.896 0 0 1 0 5.12l-25.6 93.696-72.96-73.728z m-32 139.776l-34.56 128-128 34.56-102.4-102.4 34.56-128 128-34.56z m-199.424-192c0-2.56 1.792-4.096 1.792-4.608a9.984 9.984 0 0 1 4.096 3.072l59.648 59.648-87.296 23.296z m-157.696 162.048L409.6 320a12.8 12.8 0 0 1 4.864-2.048l81.152-21.76-23.552 87.808z m58.368 230.4a18.944 18.944 0 0 1-5.12 0 17.92 17.92 0 0 1 0-5.12l25.6-93.696L563.2 528.64z m230.4 51.2c0 2.816-1.536 4.096-1.536 4.864a20.992 20.992 0 0 1-4.352-3.328l-59.392-59.392 87.296-23.552z m156.16-156.16l-81.152 21.76 23.296-87.04 59.392 59.392a40.96 40.96 0 0 1 3.328 3.84 12.8 12.8 0 0 1-4.096 2.56z"fill=#FCC029></path></symbol><symbol id=header-icon-life viewBox="0 0 1024 1024"><path d="M881.408 664.064V504.32a168.192 168.192 0 0 0-128-162.56l-7.936-1.792v144.896a12.288 12.288 0 0 1-14.592 11.776 170.752 170.752 0 0 0-30.464-2.816h-138.752v-27.648a37.632 37.632 0 0 1 11.776-27.648 175.872 175.872 0 0 0 57.856-135.68A179.2 179.2 0 0 0 460.8 132.352a175.872 175.872 0 0 0-180.992 176.128V409.6h32.256a225.536 225.536 0 0 0 15.872 19.2 36.608 36.608 0 0 1 9.472 25.6v42.496A193.792 193.792 0 0 0 179.2 712.96a197.12 197.12 0 0 0 197.12 166.656h325.12a148.48 148.48 0 0 0 45.568-6.144 217.088 217.088 0 0 0 64.256-31.744 176.896 176.896 0 0 0 18.176-15.616l4.608-4.352a156.16 156.16 0 0 0 47.36-111.872v-35.84c0.512-3.072 0.256-6.656 0-9.984z"fill=#FFD778></path><path d="M468.736 238.592a40.192 40.192 0 1 0 40.192 40.192 40.192 40.192 0 0 0-40.192-40.192zM323.584 362.752H217.6a34.816 34.816 0 1 0 0 69.376h106.24a34.816 34.816 0 1 0 0-69.376z"fill=#FB813A></path></symbol><symbol id=header-icon-kichiku viewBox="0 0 1024 1024"><path d="M918.784 510.208a187.904 187.904 0 0 0-88.832-159.488 156.416 156.416 0 0 0 1.792-22.016 150.784 150.784 0 0 0-210.944-138.496 151.04 151.04 0 0 0-216.32 0 150.784 150.784 0 0 0-210.944 138.496 156.416 156.416 0 0 0 1.792 22.016 187.648 187.648 0 0 0-13.824 309.504v1.536a215.296 215.296 0 0 0 332.8 179.2 215.04 215.04 0 0 0 332.8-179.2v-2.56a187.904 187.904 0 0 0 71.68-148.992z"fill=#FC6B8A></path><path d="M680.704 479.744A150.528 150.528 0 0 1 572.672 435.2a150.016 150.016 0 0 1-120.064 0 150.528 150.528 0 0 1-108.032 45.824h-11.264v167.168a166.4 166.4 0 0 0 165.888 165.888h33.536a166.4 166.4 0 0 0 165.888-165.888v-169.728a137.216 137.216 0 0 1-17.92 1.28z"fill=#FFFFFF></path><path d="M510.464 651.264m-33.536 0a33.536 33.536 0 1 0 67.072 0 33.536 33.536 0 1 0-67.072 0Z"fill=#E2006C></path><path d="M635.904 554.496H614.4v-21.504a12.032 12.032 0 0 0-11.776-11.776h-4.864a12.032 12.032 0 0 0-11.776 11.776v21.504h-21.248a11.776 11.776 0 0 0-11.776 11.52v5.12a11.776 11.776 0 0 0 11.776 11.52h21.248v21.504a12.032 12.032 0 0 0 11.776 11.776h4.864a12.032 12.032 0 0 0 11.776-11.776v-21.504h21.248a11.776 11.776 0 0 0 11.776-11.52v-5.12a11.776 11.776 0 0 0-11.52-11.52zM455.936 554.496H435.2v-21.504a12.032 12.032 0 0 0-11.776-11.776h-4.864a12.032 12.032 0 0 0-11.776 11.776v21.504H384a11.776 11.776 0 0 0-11.776 11.52v5.12a11.776 11.776 0 0 0 11.776 11.52h21.248v21.504a12.032 12.032 0 0 0 11.776 11.776h4.864a12.032 12.032 0 0 0 13.312-11.776v-21.504h21.248a11.52 11.52 0 0 0 11.776-11.52v-5.12a11.52 11.52 0 0 0-12.288-11.52z"fill=#FF5C7A></path><path d="M600.32 651.008a12.288 12.288 0 0 0-12.288 12.544c0 34.048-34.816 61.696-76.8 61.696s-76.8-27.648-76.8-61.696a12.544 12.544 0 1 0-25.6 0c0 47.616 45.824 86.528 102.4 86.528s102.4-38.912 102.4-86.528a12.544 12.544 0 0 0-13.312-12.544z"fill=#EB53A8></path></symbol><symbol id=header-icon-guochuang viewBox="0 0 1024 1024"><path d="M873.472 321.792c-46.08-46.592-102.4-73.472-161.536-40.192a177.152 177.152 0 0 0-51.2-161.536s-83.456 107.52-15.104 219.648c-12.288 13.568-24.32 27.136-36.352 39.424-26.88 27.136 14.592 69.12 41.216 41.984l68.608-69.632c40.704-40.96 76.8-23.808 112.896 12.288 26.624 26.88 68.096-15.104 41.472-41.984z"fill=#58D598></path><path d="M705.024 344.576a189.696 189.696 0 0 0-270.848 0 195.072 195.072 0 0 0-41.216 62.464 249.088 249.088 0 0 0-177.664 74.496 256 256 0 0 0 0 359.68 248.576 248.576 0 0 0 354.816 0 256 256 0 0 0 73.472-179.2 190.976 190.976 0 0 0 61.44-41.728 195.84 195.84 0 0 0 0-275.712z"fill=#FF5C7A></path><path d="M514.304 808.704a187.136 187.136 0 0 1-267.264-5.12 193.536 193.536 0 0 1 5.12-271.104s-45.056 120.832 43.776 214.272a210.176 210.176 0 0 0 218.368 61.952"fill=#F14767></path></symbol><symbol id=header-icon-fashion viewBox="0 0 1024 1024"><path d="M691.2 204.8a44.032 44.032 0 0 1 29.952 34.048 117.76 117.76 0 0 1-13.056 76.8s-19.2 29.952-24.32 39.936a235.008 235.008 0 0 0-25.6 107.008v40.704H365.312v-39.424a235.008 235.008 0 0 0-25.6-107.008c-5.12-9.984-24.32-39.936-24.32-39.936a117.76 117.76 0 0 1-13.056-76.8A44.544 44.544 0 0 1 336.896 204.8V147.712a29.952 29.952 0 0 1 27.136-31.744 29.952 29.952 0 0 1 27.648 31.744v73.728A237.056 237.056 0 0 0 512 253.952a241.408 241.408 0 0 0 125.184-35.072V147.712a27.136 27.136 0 1 1 53.76 0z"fill=#FF6A9B></path><path d="M658.432 487.936H365.312L204.8 780.288a36.352 36.352 0 0 0 10.24 46.592 492.288 492.288 0 0 0 595.456 0 36.608 36.608 0 0 0 8.704-47.36z"fill=#FF9DC6></path><path d="M409.6 537.6a9.984 9.984 0 0 0-13.568 4.608l-124.16 250.624a10.496 10.496 0 0 0 4.608 13.568 14.848 14.848 0 0 0 4.608 0 9.984 9.984 0 0 0 8.96-5.632l124.16-250.88A10.24 10.24 0 0 0 409.6 537.6zM455.936 643.072a9.984 9.984 0 0 0-12.032 7.424l-40.448 170.752a10.24 10.24 0 0 0 7.424 12.288h2.304a9.728 9.728 0 0 0 9.728-7.936l40.448-170.752a9.984 9.984 0 0 0-7.424-11.776zM750.848 791.808l-124.16-250.624A9.984 9.984 0 0 0 614.4 537.6a10.24 10.24 0 0 0-4.608 13.312l124.16 250.88a9.984 9.984 0 0 0 8.96 5.632 14.848 14.848 0 0 0 4.608 0 10.496 10.496 0 0 0 3.328-15.616zM579.84 650.496a9.984 9.984 0 0 0-19.456 4.608l40.448 170.752a9.728 9.728 0 0 0 9.728 7.936h2.304a10.24 10.24 0 0 0 7.424-12.288z"fill=#FF6A9B></path></symbol><symbol id=header-icon-ad viewBox="0 0 1024 1024"><path d="M576.768 153.6c32.768-32.512 132.096 13.824 221.952 103.68s136.448 189.184 103.68 221.952a27.648 27.648 0 0 1-6.144 4.608c-37.632 22.784-640 377.6-640 377.6a110.592 110.592 0 0 1-48.384-30.976 140.288 140.288 0 0 1-34.56-49.152s381.184-588.8 399.36-620.8a34.56 34.56 0 0 1 4.096-6.912z"fill=#9796ED></path><path d="M172.288 780.032c-4.864 3.328-35.328 19.968-51.2 28.928a18.688 18.688 0 0 0-9.728 19.456 104.192 104.192 0 0 0 31.488 58.368 117.504 117.504 0 0 0 59.392 33.024 19.2 19.2 0 0 0 19.968-8.448c10.752-17.152 32-51.2 33.024-51.2a110.592 110.592 0 0 1-48.384-30.976 140.288 140.288 0 0 1-34.56-49.152z"fill=#9289F0></path><path d="M576.768 153.6c32.768-32.512 132.096 13.824 221.952 103.68s136.448 189.184 103.68 221.952a27.648 27.648 0 0 1-6.144 4.608c-37.632 22.784-102.4 60.16-102.4 60.16s-64-4.096-173.312-113.664c-102.4-102.4-112.128-171.008-112.128-171.008s39.936-61.696 62.464-98.816a34.56 34.56 0 0 1 5.888-6.912z"fill=#F7DF88></path><path d="M680.45816 374.49224a230.144 83.712 45 1 0 118.386645-118.386645 230.144 83.712 45 1 0-118.386645 118.386645Z"fill=#8683EA></path></symbol><symbol id=header-icon-anime viewBox="0 0 1024 1024"><path d="M588.8 359.68l-12.032-7.424 150.272-206.592a30.976 30.976 0 0 0-51.2-36.352l-153.6 210.176L281.6 170.24a30.976 30.976 0 1 0-33.024 52.736L486.4 369.92l-22.784 31.488a30.976 30.976 0 1 0 51.2 36.352l25.6-35.072 16.128 9.728A30.976 30.976 0 1 0 588.8 359.68z"fill=#FB813A></path><path d="M763.648 850.688m-53.248 0a53.248 53.248 0 1 0 106.496 0 53.248 53.248 0 1 0-106.496 0Z"fill=#FB813A></path><path d="M261.12 797.44a53.248 53.248 0 1 0 53.504 53.248 53.248 53.248 0 0 0-53.504-53.248z"fill=#FB813A></path><path d="M141.312 314.368m92.928 0l556.288 0q92.928 0 92.928 92.928l0 360.704q0 92.928-92.928 92.928l-556.288 0q-92.928 0-92.928-92.928l0-360.704q0-92.928 92.928-92.928Z"fill=#FDDE80></path><path d="M520.448 575.232m-128.256 0a128.256 128.256 0 1 0 256.512 0 128.256 128.256 0 1 0-256.512 0Z"fill=#FFFFFF></path><path d="M476.928 546.56c0-26.88 19.2-37.632 42.24-25.6l49.664 28.672a25.6 25.6 0 0 1 0 48.64l-49.664 28.672c-23.04 13.568-42.24 2.56-42.24-24.32z"fill=#FB813A></path></symbol><symbol id=header-icon-guochandonghuatuijian viewBox="0 0 1024 1024"><path d="M873.472 321.792c-46.08-46.592-102.4-73.472-161.536-40.192a177.152 177.152 0 0 0-51.2-161.536s-83.456 107.52-15.104 219.648c-12.288 13.568-24.32 27.136-36.352 39.424-26.88 27.136 14.592 69.12 41.216 41.984l68.608-69.632c40.704-40.96 76.8-23.808 112.896 12.288 26.624 26.88 68.096-15.104 41.472-41.984z"fill=#58D598></path><path d="M705.024 344.576a189.696 189.696 0 0 0-270.848 0 195.072 195.072 0 0 0-41.216 62.464 249.088 249.088 0 0 0-177.664 74.496 256 256 0 0 0 0 359.68 248.576 248.576 0 0 0 354.816 0 256 256 0 0 0 73.472-179.2 190.976 190.976 0 0 0 61.44-41.728 195.84 195.84 0 0 0 0-275.712z"fill=#FF5C7A></path><path d="M514.304 808.704a187.136 187.136 0 0 1-267.264-5.12 193.536 193.536 0 0 1 5.12-271.104s-45.056 120.832 43.776 214.272a210.176 210.176 0 0 0 218.368 61.952"fill=#F14767></path></symbol><symbol id=header-icon-tech viewBox="0 0 1024 1024"><path d="M510.208 683.264h-114.176l-50.688 209.408H674.816l-50.688-209.408h-113.92z"fill=#FFD778></path><path d="M535.552 150.528v-28.16a25.6 25.6 0 1 0-51.2 0v28.16a271.872 271.872 0 0 0-244.992 269.568v97.28a25.6 25.6 0 0 0 26.88 26.88h487.936a25.6 25.6 0 0 0 25.6-26.88v-97.28a271.616 271.616 0 0 0-244.224-269.568z"fill=#48CFE5></path><path d="M125.696 464.64m103.168 0l562.432 0q103.168 0 103.168 103.168l0 15.36q0 103.168-103.168 103.168l-562.432 0q-103.168 0-103.168-103.168l0-15.36q0-103.168 103.168-103.168Z"fill=#2CBAE5></path><path d="M742.4 537.6a37.632 37.632 0 1 0 37.632 37.632A37.376 37.376 0 0 0 742.4 537.6zM276.736 537.6a37.632 37.632 0 1 0 37.632 37.632A37.632 37.632 0 0 0 276.736 537.6z"fill=#FFD778></path></symbol><symbol id=header-icon-knowledge viewBox="0 0 1024 1024"><path d="M492.270933 147.729067A255.342933 255.342933 0 0 1 627.2 620.2624v51.2a37.546667 37.546667 0 0 1-25.6 34.133333h-221.866667a44.654933 44.654933 0 0 1-25.6-34.133333v-51.2a256.648533 256.648533 0 0 1 138.1376-472.533333z"fill=#FFA200></path><path d="M550.4 534.929067v-76.8h51.2c46.609067 0 51.2-26.786133 51.2-42.666667v-128c0-23.1168-17.2032-42.666667-51.2-42.666667h-213.333333c-42.103467 0-59.733333 21.111467-59.733334 42.666667v76.8h102.4v-68.266667h119.466667v119.466667h-51.2c-60.501333-0.5632-76.8 24.405333-76.8 42.666667v76.8h128z m-62.6688 24.533333a59.733333 59.733333 0 1 1-59.733333 59.733333 59.733333 59.733333 0 0 1 59.733333-59.733333z"fill=#FFF0D3></path><path d="M354.133333 739.7376h273.066667v8.533333a128 128 0 0 1-128 128h-17.066667a128 128 0 0 1-128-128v-8.533333z"fill=#5FB5EC></path><path d="M746.666667 210.6624h119.466666a17.066667 17.066667 0 0 1 0 34.133333h-119.466666a17.066667 17.066667 0 0 1 0-34.133333z m59.733333-59.733333a17.066667 17.066667 0 0 1 17.066667 17.066666v119.466667a17.066667 17.066667 0 0 1-34.133334 0v-119.466667a17.066667 17.066667 0 0 1 17.066667-17.066666z"fill=#FFE074></path><path d="M157.866667 662.929067h119.466666a17.066667 17.066667 0 0 1 0 34.133333h-119.466666a17.066667 17.066667 0 0 1 0-34.133333z m59.733333-59.733334a17.066667 17.066667 0 0 1 17.066667 17.066667v119.466667a17.066667 17.066667 0 0 1-34.133334 0v-119.466667a17.066667 17.066667 0 0 1 17.066667-17.066667z"fill=#FFE074></path><path d="M200.533333 662.9376h34.133334v34.133333h-34.133334z"fill=#FFE074></path><path d="M789.333333 210.670933h34.133334v34.133334h-34.133334z"fill=#FFE074></path></symbol><symbol id=header-icon-general_pullup_s viewBox="0 0 1024 1024"><path d="M511.936 455.808l214.976 214.976a48 48 0 1 0 67.904-67.904L545.92 353.984a48 48 0 0 0-67.904 0L229.12 602.88a48 48 0 1 0 67.904 67.904l214.912-214.976z"></path></symbol><symbol id=header-icon-Navbar_mobile viewBox="0 0 1024 1024"><path d="M256 64h512a64 64 0 0 1 64 64v768a64 64 0 0 1-64 64H256a64 64 0 0 1-64-64V128a64 64 0 0 1 64-64z m0 128v576h512V192H256z m192 640v64h128v-64H448z"></path></symbol><symbol id=header-icon-Navbar_logo viewBox="0 0 2240 1024"><path d="M2079.810048 913.566175c-10.01309 0-18.554608 0.799768-26.936172-0.159954-16.987063-1.951433-33.974126-1.567544-50.99318-2.079395-10.972811-0.287916-10.652904-0.287916-11.580634-10.90883-2.71921-32.406582-5.694345-64.781173-8.605499-97.155764-2.527266-28.439735-4.926568-56.91146-7.70976-85.319204-2.527266-26.040432-5.566382-52.016883-8.317583-78.025324-2.623238-24.440897-5.054531-48.913784-7.77374-73.322691a12681.114551 12681.114551 0 0 0-10.684895-92.133223c-3.295042-27.128116-6.558094-54.320213-10.205034-81.416339a20559.272961 20559.272961 0 0 0-17.530905-125.979387c-6.398141-44.723002-14.075909-89.22207-22.105576-133.657156-1.439582-7.965685-1.247637-8.253601 6.36615-9.533229 31.670796-5.406429 63.501545-10.01309 95.716183-9.309295 3.486987 0.095972 7.005964 0.159954 10.460959 0.607823 5.662354 0.703795 8.605499 3.454996 8.925406 10.045081 1.119675 22.969325 2.71921 45.938649 4.414717 68.875983 2.71921 37.589076 5.662354 75.178151 8.477537 112.735236 1.791479 24.184971 3.327033 48.305961 5.150503 72.426951 2.911154 38.772732 5.982261 77.513473 8.925406 116.286205 1.791479 23.705111 3.359024 47.474203 5.182494 71.179313 2.783191 34.805885 5.822308 69.579778 8.637489 104.353672 1.791479 22.137566 3.391014 44.307123 5.278466 66.44469 2.783191 32.79047 5.790317 65.580941 8.63749 98.371411 2.143377 25.592562 4.09481 51.249106 6.270178 77.673426zM853.670395 114.918282c4.638652 0 11.644616-0.511851 18.554607 0.127963 8.797443 0.799768 10.49295 3.071107 11.036793 11.900541 2.527266 40.372267 4.894578 80.776524 7.581796 121.180782 2.943145 43.571337 6.174206 87.078693 9.405267 130.586048 2.975135 39.956388 5.950271 79.912775 9.149341 119.869163 3.486987 43.891244 7.357862 87.718507 10.876839 131.609751 2.655228 33.622229 4.926568 67.244457 7.677768 100.898677 2.623238 31.222926 5.694345 62.38187 8.509527 93.572805 2.399303 26.8402 4.830596 53.71239 7.165918 80.58458 0.735786 8.509527 0.127963 9.053369-9.053369 8.829434-24.025018-0.575833-47.922073-3.391014-71.947091-2.71921-5.502401 0.159954-7.101936-2.367312-8.029666-7.581796-1.983424-11.356699-1.663517-22.905343-2.879163-34.390006-3.295042-30.359177-5.182494-60.846317-7.965685-91.269474-2.495275-27.639967-5.502401-55.215953-8.349574-82.82393-2.527266-25.240664-5.02254-50.481329-7.709759-75.753984-2.687219-24.792795-5.534392-49.61758-8.349573-74.442365-2.591247-22.841362-5.118512-45.682723-7.869713-68.524085-4.062819-33.462275-8.093648-66.92455-12.508365-100.322844-4.062819-30.647093-8.66948-61.198214-12.988225-91.813317-5.886289-41.587914-12.508365-83.079855-19.834236-124.411842a1393.96288 1393.96288 0 0 0-5.310457-28.023856c-0.959721-4.702633-0.095972-7.421843 5.278466-8.157629 14.139891-1.887451 28.24779-4.830596 42.451663-6.206196 14.203872-1.311619 28.407744-3.966847 45.106891-2.71921z m1006.075609 403.33878c27.064134 0 27.703949 0.191944 32.054684 24.536869 5.342447 30.03927 9.08536 60.334465 12.636328 90.62966 3.742912 32.278619 7.517815 64.557238 10.972811 96.867848 2.783191 26.008441 5.118512 52.080864 7.74175 78.089305 2.7512 27.256079 5.662354 54.416185 8.509527 81.640274 1.567544 15.387528 3.039117 30.775056 4.798605 46.130593 0.511851 4.446708-0.831758 6.81402-5.214485 7.325871-9.245313 1.055693-18.426645 2.27134-27.639967 3.263052-16.891091 1.82347-33.814173 3.614949-50.737254 5.182493-8.733462 0.799768-9.309294 0.319907-10.940821-8.125638-14.843686-76.617733-29.719363-153.171485-44.435086-229.821208-9.789155-50.961189-19.322384-101.95437-28.919595-152.915559a805.525894 805.525894 0 0 1-3.582959-21.081873c-0.639814-4.030829 0.44787-6.622075 5.022541-7.70976 30.48714-7.133927 61.294186-12.636328 89.733921-14.011927z m-1137.077537 0c28.951586 0 28.823623 0.095972 33.302322 26.360339 6.909992 40.660183 11.804569 81.544301 16.187295 122.556382 4.286754 39.796434 8.957397 79.560878 13.148179 119.357311 2.847173 27.224088 5.086522 54.512157 7.74175 81.704255 1.887451 19.354375 4.126801 38.644769 6.174206 57.967153 0.255926 2.367312 0.383888 4.734624 0.543842 7.133927 0.415879 9.469248 0 10.237025-9.117351 11.164755-18.074747 1.887451-36.181485 3.454996-54.256232 5.246476-6.558094 0.639814-13.084197 1.599535-19.57831 2.239349-8.63749 0.799768-8.925406 0.767777-10.620913-7.965685-6.078234-30.679084-11.964523-61.422149-17.914793-92.101233-14.267853-73.898523-28.69566-147.733065-42.867542-221.631589-5.662354-29.559409-10.524941-59.246781-16.091323-88.838181-1.023702-5.406429-0.255926-7.933694 5.342447-9.245313 30.199223-7.037955 60.590391-12.540355 88.006423-13.947946z m382.128944 309.861946v124.027954c0 1.183656-0.127963 2.399303 0.03199 3.582959 0.607823 6.014252-1.599535 8.66948-7.805731 8.413555-8.157629-0.351898-16.251277-0.127963-24.408906 0.063981-17.019054 0.319907-34.070098-0.351898-51.057162 1.599535-9.405267 1.087684-9.213322 0.511851-10.141052-9.405266-2.783191-31.222926-5.822308-62.413861-8.669481-93.636787-2.623238-28.823623-4.99055-57.711228-7.677768-86.534851-2.71921-29.655381-5.758326-59.214791-8.509527-88.838181-1.887451-19.770254-3.550968-39.508518-5.214485-59.278772-2.175368-25.720525-4.190782-51.409059-6.462122-77.129585-0.959721-10.844848-0.159954-12.380402 10.588923-13.500076a531.877423 531.877423 0 0 1 83.527724-2.591247c6.941982 0.383888 13.851974 1.727498 20.570022 3.359024 8.477536 2.015414 9.405267 3.263052 9.853137 12.124476 0.92773 17.850812 1.855461 35.701624 2.335321 53.584427 0.543842 19.866226 0.095972 39.764443 0.831758 59.63067 1.855461 54.800074 1.567544 109.664129 2.207359 164.528184z m1134.806197 5.630364v117.437869c0 1.983424-0.063981 3.966847 0.03199 5.982262 0.415879 5.150503-1.983424 6.973973-6.878001 6.941982-12.028504-0.095972-24.025018 0-36.021531 0.159954-13.564058 0.127963-27.096125 0.063981-40.628192 1.535553-8.925406 1.023702-8.989387 0.351898-9.789155-8.509527-3.678931-40.660183-7.549806-81.320366-11.260728-122.04453-3.391014-37.525094-6.526103-75.082179-9.981099-112.639265-3.550968-38.740741-7.421843-77.38551-10.90883-116.09426-1.727498-19.386366-3.16708-38.772732-4.606661-58.159097-0.575833-8.445546 0.351898-9.949109 9.885127-10.716886 16.571184-1.311619 33.078387-3.550968 49.777534-3.263051 16.635165 0.319907 33.302322-0.607823 49.841515 2.559256 14.011928 2.687219 14.715723 3.486987 15.547481 18.458635 2.399303 44.051198 1.663517 88.230358 3.231061 132.281556 1.599535 46.89837 0.479861 93.79674 1.759489 146.069549zM1831.498213 305.135c9.789155 0.575833 17.498914 0.095972 25.176683 1.791479 4.894578 1.119675 7.357862 3.327033 7.837723 8.573509 2.303331 25.240664 4.798605 50.51332 7.32587 75.785975 2.015414 20.50604 4.158791 41.012081 6.238188 61.518121l0.191944 1.183656c1.663517 12.924244 1.279628 13.276142-11.292718 13.979937-11.196746 0.607823-22.361501 1.599535-33.558247 2.27134-7.357862 0.44787-9.693183 1.695507-10.90883-9.021378-4.190782-37.813011-9.053369-75.530049-13.692021-113.311069a1185.0316 1185.0316 0 0 0-4.286754-31.798759c-0.92773-5.982261 1.407591-9.277304 7.005964-9.757164 7.357862-0.671805 14.715723-0.863749 19.962198-1.215647z m-1133.398606 0.159954c7.549806 0.415879 15.323547-0.159954 22.937334 1.599535 4.350736 0.991712 6.558094 2.815182 6.973973 7.773741 0.92773 11.83656 2.7512 23.641129 3.870875 35.477689 3.550968 36.309448 6.909992 72.650886 10.237025 108.992324 0.703795 7.901704 0.543842 8.061657-6.84601 8.605499-13.116188 0.959721-26.264367 1.919442-39.412546 2.463284-7.645778 0.351898-8.605499-0.575833-9.56522-8.381564-3.327033-26.744227-6.462122-53.520446-9.661192-80.296664-2.591247-22.073585-4.766615-44.14717-7.901704-66.156773-0.863749-6.078234 1.119675-7.74175 5.982262-8.733462 7.709759-1.567544 15.451509-1.055693 23.385203-1.343609z m399.147998 100.002936c0 23.001315 0.063981 45.97064-0.031991 69.003946 0 10.332997-0.127963 10.396978-10.396978 10.269016a324.289753 324.289753 0 0 1-36.981252-1.919443c-7.933694-0.991712-8.093648-0.735786-8.317583-9.149341-0.799768-28.119828-1.631526-56.239655-2.207359-84.359483-0.415879-19.034468-0.639814-38.004955-1.791479-57.039422-0.607823-9.821146-0.063981-9.917118 9.373276-10.045081 13.915956-0.159954 27.799921 0.479861 41.619904 2.591247 8.317583 1.279628 8.701471 1.279628 8.733462 10.49295 0.063981 23.385204 0.063981 46.770407 0.063981 70.187602h-0.063981z m1135.38203 0.607824c0 23.033306 0.063981 46.034621-0.031991 69.035936 0 9.661192-0.159954 9.725174-9.853137 9.661192a505.32514 505.32514 0 0 1-38.132917-1.791479c-6.302168-0.479861-8.157629-3.135089-7.74175-8.861425 0.063981-0.799768 0-1.599535 0-2.399302-0.959721-44.403095-1.919442-88.7742-2.815182-133.177296-0.031991-2.367312-0.159954-4.734624-0.063982-7.133926 0.127963-8.957397 0.159954-9.181332 9.149341-9.117351 12.380402 0.063981 24.664832 0.703795 37.013243 1.919442 15.067621 1.503563 12.412393 3.359024 12.476375 15.259566 0.063981 22.169557 0.031991 44.403095 0 66.604643z m-1565.593 54.000306c0.287916 12.636328 0.287916 12.604337-11.804569 15.547481-8.221611 2.015414-16.443221 4.222773-24.728813 6.046243-7.069945 1.599535-8.317583 0.703795-9.53323-6.238187-8.445546-47.090314-16.8591-94.212619-25.240664-141.334924-1.695507-9.757164-1.247637-10.364988 8.349573-12.060495 11.804569-2.079396 23.577148-4.126801 35.381717-5.950271 7.517815-1.183656 8.477536-0.767777 9.9811 7.517815 2.975135 16.731138 5.790317 33.526256 7.997675 50.385357 3.423005 26.680246 6.238187 53.456464 9.309295 80.168701 0.255926 1.951433 0.191944 3.966847 0.287916 5.91828z m1064.138735-136.696273c15.451509-2.527266 31.030982-5.086522 46.610454-7.549806 5.598373-0.863749 7.29388 2.655228 8.029666 7.645778 2.655228 18.426645 5.982261 36.725327 8.157629 55.183962 3.19907 26.744227 7.581797 53.360492 8.413555 80.328655 0.063981 2.7512 0.031991 5.566382 0.095972 8.317583 0.159954 4.286754-1.983424 6.494113-5.950271 7.421843-10.556932 2.367312-21.113864 4.734624-31.638805 7.261889-5.054531 1.215647-6.750038-0.92773-7.581796-5.854298-3.16708-18.746552-6.81402-37.397131-10.045081-56.079702-5.47041-30.775056-10.780867-61.582103-16.091323-92.38915-0.127963-1.119675 0-2.303331 0-4.286754z m-710.64147 108.032603c-0.44787 16.37924 0.543842 30.647093-1.695507 44.914947-0.671805 4.510689-1.983424 7.421843-6.846011 7.837722-10.428969 0.863749-20.825947 1.695507-31.190935 2.7512-5.02254 0.543842-6.430131-1.631526-7.261889-6.558094-2.335321-14.55577-1.919442-29.303484-3.327033-43.923234-2.655228-27.607976-3.774903-55.407897-5.566383-83.111846-0.44787-6.750038-1.119675-13.436095-1.663516-20.186134-0.287916-3.774903 1.215647-5.886289 5.246475-6.046242 13.500077-0.543842 26.936172-3.007126 40.50023-2.527266 7.933694 0.287916 8.605499 0.799768 9.181331 8.797443 0.351898 5.534392 0.255926 11.132765 0.383889 16.699147l2.239349 81.352357z m1134.902169-15.867388c0 19.066459 0.223935 38.132918-0.031991 57.199376-0.159954 9.917118-1.279628 10.780867-10.652904 11.644616-9.277304 0.863749-18.490626 1.567544-27.735939 2.559256-5.214485 0.543842-7.645778-0.991712-7.965685-6.973973-1.34361-25.336637-3.16708-50.673273-4.926568-75.977919-1.3756-20.985901-2.943145-41.939811-4.414717-62.893722-0.159954-2.399303-0.031991-4.798605-0.191944-7.165917-0.223935-4.190782 1.055693-6.654066 5.758326-6.81402 13.116188-0.44787 26.136404-2.975135 39.348564-2.495274 8.061657 0.287916 8.18962 0.415879 8.797444 8.797443 1.951433 27.32006 2.143377 54.704102 2.015414 82.120134zM628.295894 756.171918c16.571184 18.234701 17.402942 39.828425 11.932532 62.413861-5.502401 22.585436-18.042756 41.204025-33.23834 57.903171-25.49659 27.895893-56.303637 48.497905-89.062116 65.99682-56.399609 30.135242-116.190232 50.161422-178.572103 61.997982-44.882956 8.477536-90.053828 15.00364-135.704561 17.498914-13.915956 0.767777-27.799921 1.407591-41.715876 1.311619-10.077071 0-20.186133 0.287916-30.231214-0.063981-8.541518-0.319907-9.789155-1.791479-10.49295-10.716886-2.591247-32.022693-4.798605-64.077378-7.645778-96.100071-3.327033-37.109215-7.229899-74.18644-10.812858-111.295654-2.623238-26.8402-4.894578-53.744381-7.773741-80.520599-3.327033-31.542833-7.069945-63.021684-10.716885-94.564517-3.327033-29.111539-6.526103-58.28706-10.045081-87.430591-3.934856-32.278619-7.997676-64.493257-12.31642-96.707894a8228.968456 8228.968456 0 0 0-13.212161-92.996973 5984.500754 5984.500754 0 0 0-24.312934-152.627642 3243.825263 3243.825263 0 0 0-23.67312-123.740038c-1.151665-5.502401 0.511851-7.709759 5.342448-9.725174C52.335283 47.609843 98.465876 28.063524 144.724432 8.77313c8.605499-3.582959 17.434933-6.590085 26.584274-8.285592 6.334159-1.183656 7.965685 0.127963 7.773741 6.494113-0.479861 16.283268 0.191944 32.630517-1.407591 48.849803a161.393095 161.393095 0 0 0-0.639814 13.084197c-0.735786 58.383032-1.439582 116.798056 0.095972 175.213079 1.34361 51.185124 4.030829 102.338258 7.005964 153.491392 2.335321 40.372267 5.694345 80.744534 9.149341 121.052819 3.391014 39.508518 7.517815 78.953054 11.38869 118.461572 0.735786 7.517815 1.407591 8.221611 9.949108 7.069945a381.329176 381.329176 0 0 1 50.833227-4.190782c52.880632-0.127963 104.897514 7.133927 156.338564 19.322384 45.010919 10.684895 88.806191 24.920757 130.777993 44.818975 20.793957 9.853136 40.692174 21.241827 58.830902 35.701624 6.174206 4.862587 11.676606 10.46096 16.891091 16.315259z m1126.840512-9.597211c20.47405 17.946784 27.927883 39.924397 22.105576 67.116494-4.830596 22.425483-15.771416 41.268006-30.359177 58.127107-23.417194 27.096125-51.856929 47.698138-82.631985 64.909136-60.334465 33.782182-124.603787 55.727804-192.168151 68.396122a1151.089465 1151.089465 0 0 1-111.455609 15.547481c-21.177845 1.82347-42.451662 4.09481-66.220754 2.623238h-27.76793c-5.406429 0-8.477536-1.695507-8.925406-8.125638-2.047405-28.087837-4.414717-56.143683-6.941983-84.19953-2.687219-29.623391-5.662354-59.246781-8.477536-88.870172-2.559256-27.224088-4.926568-54.512157-7.709759-81.736245-2.559256-25.656544-5.502401-51.249106-8.285592-76.873659-2.591247-24.057008-5.086522-48.114017-7.933695-72.139035-3.423005-29.111539-7.037955-58.223079-10.652904-87.334618-3.391014-27.160107-6.750038-54.288222-10.364987-81.416338a6133.577429 6133.577429 0 0 0-12.156467-87.142675c-5.694345-37.653057-11.804569-75.178151-17.818822-112.767227a3259.14881 3259.14881 0 0 0-29.111539-158.993792c-0.44787-2.335321-0.671805-4.734624-1.3756-7.005964-1.663517-5.118512-0.063981-7.837722 4.958559-9.821146C1191.012355 47.641834 1238.61452 24.448575 1288.2321 6.149893c6.494113-2.431293 13.052207-5.150503 20.058171-5.854299 6.302168-0.639814 7.901704 0.383888 7.29388 7.101936-3.327033 36.43741-1.407591 73.066765-3.135089 109.536166-1.407591 29.751354-1.247637 59.598679 0.255926 89.382023 0.351898 7.549806 0.639814 15.131602 0.575832 22.649418-0.383888 35.765606 1.503563 71.499221 3.327033 107.200845 2.335321 47.186286 5.758326 94.276601 9.245313 141.398906 2.527266 34.006117 5.822308 67.948253 9.021379 101.922379 1.695507 18.586598 3.518977 37.141206 5.822308 55.631832 1.247637 10.205034 1.759489 10.301006 11.772578 8.957396 17.658868-2.399303 35.349726-4.350736 53.200539-4.09481 62.637796 0.799768 124.027954 10.684895 184.266447 27.863902 40.788146 11.580634 80.488608 26.040432 117.981712 46.290547a253.55831 253.55831 0 0 1 47.218277 32.438573zM308.676783 922.811488c23.161269-11.068783 135.608589-98.947243 144.533995-113.279078-54.576139-23.513166-109.344222-45.362816-168.239105-63.24562l23.70511 176.524698z m1277.196815-107.520752c2.879163-3.103098 2.559256-5.502401-1.343609-7.229899-7.773741-3.550968-15.4835-7.325871-23.353213-10.556932-42.003793-17.179007-84.19953-33.814173-127.482951-47.37823-3.774903-1.151665-7.645778-3.774903-12.476374-1.535554l23.321222 173.45359c3.454996 0.767777 4.798605-0.831758 6.33416-1.919442 39.316574-28.855614 78.889073-57.35933 116.638102-88.390312 6.36615-5.182494 12.668318-10.396978 18.362663-16.443221z"fill=#23ADE5></path></symbol><symbol id=header-icon-bilibili-tv viewBox="0 0 1024 1024"><path d="M800.768 237.216h-51.264l44.832-44.832c19.232-19.232 19.232-57.664 0-76.864s-57.664-19.232-76.864 0l-128.128 121.728h-153.76L307.456 115.52c-19.232-19.232-57.664-19.232-76.864 0s-19.232 57.664 0 76.864l44.832 44.832H224.16C134.464 237.216 64 307.68 64 397.376v345.952c0 96.096 70.464 166.56 160.16 166.56h570.144c89.696 0 160.16-70.464 160.16-160.16V397.376c6.4-89.696-64.064-160.16-153.76-160.16z m44.864 506.112a57.44 57.44 0 0 1-57.664 57.664H230.624a57.44 57.44 0 0 1-57.664-57.664v-339.52c0-32.032 25.632-57.664 57.664-57.664h557.344c32.032 0 57.664 25.632 57.664 57.664v339.52zM345.952 461.44a57.44 57.44 0 0 0-57.664 57.664v57.664c0 32.032 25.632 57.664 57.664 57.664s57.664-25.632 57.664-57.664v-57.664a57.44 57.44 0 0 0-57.664-57.664z m333.12 0a57.44 57.44 0 0 0-57.664 57.664v57.664c0 32.032 25.632 57.664 57.664 57.664s57.664-25.632 57.664-57.664v-57.664a57.44 57.44 0 0 0-57.664-57.664z"></path></symbol><symbol id=header-icon-general_upload viewBox="0 0 1024 1024"><path d="M704 448v192c0 38.4-25.6 64-64 64H384c-38.4 0-64-25.6-64-64V448H153.6c-19.2 0-32-12.8-32-32 0-6.4 6.4-19.2 12.8-25.6l358.4-307.2c12.8-12.8 32-12.8 44.8 0L896 390.4c12.8 12.8 12.8 32 6.4 44.8-12.8 6.4-19.2 12.8-32 12.8H704zM192 832h640c38.4 0 64 25.6 64 64s-25.6 64-64 64H192c-38.4 0-64-25.6-64-64s25.6-64 64-64z"></path></symbol><symbol id=header-icon-general_search viewBox="0 0 1024 1024"><path d="M659.2 736c-140.8 115.2-345.6 108.8-473.6-19.2C44.8 576 44.8 352 179.2 211.2s358.4-134.4 499.2 0c121.6 121.6 134.4 313.6 38.4 448l198.4 198.4c19.2 19.2 19.2 51.2 0 70.4-19.2 19.2-51.2 19.2-70.4 0l-185.6-192z m-44.8-89.6c102.4-102.4 102.4-262.4 0-364.8s-262.4-102.4-364.8 0-102.4 262.4 0 364.8 262.4 96 364.8 0z"></path></symbol><symbol id=header-icon-activit viewBox="0 0 1024 1024"><path d="M518.656 475.904a223.488 223.488 0 0 1-23.296-75.52 366.08 366.08 0 0 1 81.408 14.592 623.104 623.104 0 0 1-58.112 60.928m-69.888-119.04c-11.52-58.112-8.704-55.296-25.6-156.928a265.984 265.984 0 0 0-78.336 46.592c51.2 104.448 60.928 165.376 92.928 290.304 51.2-5.632 211.968-40.704 226.56-130.56 8.704-64-142.336-64-215.04-49.408M486.4 624.128a263.424 263.424 0 0 0-107.52 69.632l43.52 153.6a47.872 47.872 0 0 1-92.928 23.296L216.576 473.088l-72.704-204.8c2.816-5.632 5.888-8.704 8.704-14.336l-14.592-51.2a46.08 46.08 0 0 1 32-57.856A47.616 47.616 0 0 1 228.096 179.2v2.816a334.848 334.848 0 0 1 98.816-43.52c177.152-46.592 203.264 55.04 429.824 23.296L890.368 588.8c-171.52 90.112-232.448-11.52-403.712 35.072"fill=#F39800></path></symbol><symbol id=header-icon-blackroom viewBox="0 0 1024 1024"><path d="M139.264 529.152a27.136 27.136 0 0 1-14.592-2.816A32 32 0 0 1 113.152 486.4l130.816-236.032a28.416 28.416 0 1 1 49.152 28.928l-130.56 235.52a25.6 25.6 0 0 1-23.296 14.336"fill=#F99E4A></path><path d="M380.416 529.152a34.56 34.56 0 0 1-25.6-14.592l-131.328-235.264a30.208 30.208 0 0 1 11.52-37.632 25.6 25.6 0 0 1 37.888 11.52l130.816 235.264a25.6 25.6 0 0 1-11.776 37.888c-2.816 0-8.704 2.816-11.52 2.816m261.376 0a25.6 25.6 0 0 1-14.336-2.816 29.44 29.44 0 0 1-11.776-37.888l130.816-235.264a28.928 28.928 0 0 1 37.632-11.52 29.44 29.44 0 0 1 11.776 37.632L665.6 514.56a25.6 25.6 0 0 1-23.296 14.592"fill=#F99E4A></path><path d="M883.968 529.152a34.56 34.56 0 0 1-25.6-14.336l-130.56-235.52a27.392 27.392 0 0 1 11.52-37.632 25.6 25.6 0 0 1 37.888 11.52l130.56 235.52a25.6 25.6 0 0 1-11.776 37.632c-2.816 0-8.704 2.816-11.776 2.816"fill=#F99E4A></path><path d="M801.536 241.664l-130.56-51.2A129.536 129.536 0 0 0 640 183.552H380.416a153.6 153.6 0 0 0-32 5.632L217.6 241.664A21.248 21.248 0 0 0 226.304 281.6h569.6a21.248 21.248 0 0 0 5.632-40.704M458.752 281.6v520.704a51.2 51.2 0 0 0 104.704 0V281.6z"fill=#FFD043></path><path d="M561.152 183.296A51.2 51.2 0 0 0 512 139.776a52.992 52.992 0 0 0-51.2 46.336h102.4z"fill=#FFD043></path><path d="M755.2 877.824H267.008A41.472 41.472 0 0 1 230.4 816.896l55.04-122.112a44.8 44.8 0 0 1 37.888-25.6h373.76a37.12 37.12 0 0 1 37.632 25.6L790.016 819.2a37.888 37.888 0 0 1-34.816 58.112"fill=#F99E4A></path><path d="M900.352 494.336a9.216 9.216 0 0 1 8.704 8.704 148.48 148.48 0 0 1-296.192 0 7.68 7.68 0 0 1 8.704-8.704z m-502.528 0a9.216 9.216 0 0 1 8.704 8.704 151.808 151.808 0 0 1-148.224 142.336 150.016 150.016 0 0 1-148.224-142.336 7.68 7.68 0 0 1 8.704-8.704z"fill=#FFD043></path></symbol><symbol id=header-icon-read viewBox="0 0 1024 1024"><path d="M778.496 142.08h-537.6a56.832 56.832 0 0 0-60.16 54.016v630.528a56.832 56.832 0 0 0 59.136 54.016h537.6a56.832 56.832 0 0 0 59.136-54.016V196.096a56.832 56.832 0 0 0-59.136-54.016z"fill=#54E2E2></path><path d="M298.496 679.168h421.376a25.6 25.6 0 0 0 0-52.736H298.496a25.6 25.6 0 1 0 0 52.736zM719.872 732.928H298.496a25.6 25.6 0 1 0 0 52.736h421.376a25.6 25.6 0 0 0 0-52.736z"fill=#23ADE5></path><path d="M272.128 237.056m80.128 0l314.112 0q80.128 0 80.128 80.128l0 154.368q0 80.128-80.128 80.128l-314.112 0q-80.128 0-80.128-80.128l0-154.368q0-80.128 80.128-80.128Z"fill=#23ADE5></path><path d="M404.992 361.472m-49.408 0a49.408 49.408 0 1 0 98.816 0 49.408 49.408 0 1 0-98.816 0Z"fill=#2EC3E5></path><path d="M375.552 551.936l120.832-144.384a44.544 44.544 0 0 1 68.352 0l120.832 144.384z"fill=#2EC3E5></path></symbol><symbol id=header-icon-ic_partition_broadca viewBox="0 0 1024 1024"><path d="M665.6 852.48H194.56c-38.4 0-66.56-30.72-66.56-69.12v-281.6c0-38.4 30.72-69.12 66.56-69.12H665.6c38.4 0 66.56 30.72 66.56 69.12v284.16c0 35.84-30.72 66.56-66.56 66.56"fill=#FE6998></path><path d="M688.768 282.1376c0 76.8-61.44 138.24-135.68 138.24S419.968 358.9376 419.968 282.1376 481.408 143.8976 555.648 143.8976s133.12 64 133.12 138.24"fill=#FE6998></path><path d="M384 332.8c0 48.64-38.4 89.6-87.04 89.6S209.92 384 209.92 332.8s38.4-89.6 87.04-89.6S384 284.16 384 332.8"fill=#FF5B61></path><path d="M414.72 558.08l115.2 69.12c15.36 10.24 15.36 30.72 0 40.96l-115.2 69.12c-15.36 10.24-35.84-2.56-35.84-20.48v-138.24c2.56-17.92 20.48-28.16 35.84-20.48"fill=#FDDE80></path><path d="M790.912 511.5904L621.952 611.4304C591.232 629.3504 591.232 677.9904 621.952 695.9104l168.96 99.84c30.72 17.92 71.68-5.12 71.68-43.52V555.1104C862.592 516.7104 824.192 493.6704 790.912 511.5904"fill=#FE6998></path></symbol><symbol id=header-icon-cinephile viewBox="0 0 1024 1024"><path d="M147.2 201.728m79.616 0l571.136 0q79.616 0 79.616 79.616l0 458.24q0 79.616-79.616 79.616l-571.136 0q-79.616 0-79.616-79.616l0-458.24q0-79.616 79.616-79.616Z"fill=#9796ED></path><path d="M222.976 269.312h77.056v57.856H222.976zM390.144 269.312h77.056v57.856h-77.056zM557.312 269.312h77.056v57.856h-77.056zM724.48 269.312h77.056v57.856H724.48zM222.976 693.76h77.056v57.856H222.976zM390.144 693.76h77.056v57.856h-77.056zM557.312 693.76h77.056v57.856h-77.056zM147.2 375.296h730.368v270.08H147.2z"fill=#7B78EA></path><path d="M521.369822 529.707066m23.351494-23.351495l2.534271-2.53427q23.351494-23.351494 46.702989 0l199.664327 199.664327q23.351494 23.351494 0 46.702989l-2.534271 2.534271q-23.351494 23.351494-46.702988 0l-199.664328-199.664328q-23.351494-23.351494 0-46.702989Z"fill=#FFD043></path><path d="M708.352 418.816h-25.6v-24.32a13.568 13.568 0 0 0-13.568-13.568H665.6a13.312 13.312 0 0 0-13.312 13.568v24.32h-25.6a13.568 13.568 0 0 0-13.568 13.568v5.632a13.568 13.568 0 0 0 13.568 13.568h25.6v24.32a13.312 13.312 0 0 0 13.312 13.568h5.632a13.568 13.568 0 0 0 13.568-13.568v-24.32h25.6a13.312 13.312 0 0 0 13.312-13.568v-5.632a13.312 13.312 0 0 0-15.36-13.568zM517.888 418.816h-25.6v-24.32a13.312 13.312 0 0 0-13.312-13.568h-5.632a13.568 13.568 0 0 0-13.568 13.568v24.32H435.2a13.312 13.312 0 0 0-13.312 13.568v5.632a13.312 13.312 0 0 0 13.312 13.568h25.6v24.32a13.568 13.568 0 0 0 13.568 13.568h5.632a13.312 13.312 0 0 0 13.312-13.568v-24.32h25.6a13.312 13.312 0 0 0 13.312-13.568v-5.632a13.312 13.312 0 0 0-14.336-13.568zM493.568 572.16h-18.432v-18.432a10.24 10.24 0 0 0-10.24-10.24H460.8a10.24 10.24 0 0 0-10.24 10.24v18.432h-18.432a10.24 10.24 0 0 0-10.24 10.24v4.352a10.24 10.24 0 0 0 10.24 10.24h18.432V614.4a10.24 10.24 0 0 0 10.24 10.24h4.352a10.24 10.24 0 0 0 10.24-10.24v-18.432h18.432a10.24 10.24 0 0 0 10.24-10.24v-4.352a10.24 10.24 0 0 0-10.496-9.216z"fill=#FFD778></path></symbol><symbol id=header-icon-cinema viewBox="0 0 1024 1024"><path d="M682.24 716.8c34.56 0 71.936-2.56 106.496 0 61.184 0 74.752 39.936 76.8 93.184a32 32 0 0 0 64 0c0-71.936-25.6-143.872-106.752-157.184a807.168 807.168 0 0 0-138.496 0 32 32 0 0 0-2.56 64"fill=#FB813A></path><path d="M860.672 489.472A354.304 354.304 0 1 0 506.368 844.8a358.4 358.4 0 0 0 354.304-355.328"fill=#FB813A></path><path d="M695.552 566.528A79.872 79.872 0 1 1 775.424 486.4a79.872 79.872 0 0 1-79.872 79.872M508.928 384a79.872 79.872 0 0 1-79.872-79.872 80.128 80.128 0 0 1 160 0A80.128 80.128 0 0 1 508.928 384m0 372.992a79.872 79.872 0 0 1-79.872-79.872 81.92 81.92 0 0 1 79.872-79.872A80.128 80.128 0 0 1 588.8 675.84a78.592 78.592 0 0 1-80.128 79.872m-186.112-189.184A79.872 79.872 0 1 1 402.432 486.4a79.872 79.872 0 0 1-79.872 79.872M512 128a372.992 372.992 0 1 0 372.736 371.968A374.016 374.016 0 0 0 512 128"fill=#FFBA7B></path><path d="M567.552 489.472a58.624 58.624 0 1 0-58.624 58.624 59.136 59.136 0 0 0 58.624-58.624"fill=#FB952C></path></symbol><symbol id=header-icon-topic viewBox="0 0 1024 1024"><path d="M880.64 520.448C880.64 642.56 768 742.4 627.712 742.4H409.6l-165.632 74.496-92.928-258.56a146.688 146.688 0 0 1-3.072-37.888v-37.888c0-122.112 110.592-226.56 250.112-226.56h232.704c136.448 0 249.856 104.448 249.856 226.56v37.888zM642.304 209.408h-256a280.064 280.064 0 0 0-279.04 273.152v43.776a250.88 250.88 0 0 0 3.072 46.336L215.04 878.08l183.04-90.112h244.224c153.6 0 279.04-116.48 279.04-261.632v-43.776a279.808 279.808 0 0 0-279.04-273.152z m58.112 351.744a51.2 51.2 0 0 1-51.2-51.2 55.552 55.552 0 0 1 58.112-52.48 54.528 54.528 0 0 1 51.2 55.296 57.088 57.088 0 0 1-58.112 49.408m-179.2 0a51.2 51.2 0 0 1-51.2-51.2 55.552 55.552 0 0 1 58.112-52.48 54.528 54.528 0 0 1 51.2 55.296A59.392 59.392 0 0 1 521.216 563.2m-179.2 0a51.2 51.2 0 0 1-51.2-51.2 55.552 55.552 0 0 1 58.112-52.48 54.528 54.528 0 0 1 51.2 55.296 59.648 59.648 0 0 1-58.112 49.408m279.04-270.336h-208.384c-122.112 0-224 87.296-224 188.928V512a111.36 111.36 0 0 0 3.072 31.744L267.264 768l110.592-58.112H645.12A194.048 194.048 0 0 0 842.752 512v-29.44c-2.816-104.448-102.4-191.744-223.744-191.744"fill=#8FC31F></path></symbol><symbol id=header-icon-douga viewBox="0 0 1024 1024"><path d="M273.408 166.912h477.696c58.368 0 105.984 47.616 105.984 105.984v477.696c0 58.368-47.616 105.984-105.984 105.984H273.408c-58.368 0-105.984-47.616-105.984-105.984V273.408C166.912 215.04 215.04 166.912 273.408 166.912z"fill=#7B78EB></path><path d="M512 525.312v98.816c33.28-14.848 72.704 0.512 87.552 33.792 14.848 33.28-0.512 72.704-33.792 87.552-16.896 7.68-35.84 7.68-53.248 0v111.616H273.408c-58.368 0-105.984-47.616-105.984-105.984V512h137.216c-21.504 19.456-24.064 53.248-4.608 74.752 19.456 21.504 53.248 24.064 74.752 4.608 21.504-18.944 24.064-53.248 4.608-74.752l-4.608-4.608H512v-40.96c-4.096 0.512-9.216 0.512-13.312 0-51.2 0-86.016-47.616-86.016-105.984s20.992-108.032 86.016-108.032h13.312V166.912h238.592c58.368 0 105.984 47.616 105.984 105.984v251.904h-120.832c20.992-23.552 19.456-59.392-3.584-80.896-23.552-20.992-59.392-19.456-80.896 3.584-19.968 21.504-19.968 55.296 0 76.8H512z"fill=#9796ED></path><path d="M512 525.312v98.816l13.312-4.096c35.84-7.68 72.704 15.872 79.872 52.224 7.68 35.84-18.432 72.192-54.272 78.848-4.096 1.024-8.704 1.024-13.312 1.024-9.216 0-16.384-3.072-25.088-6.144v111.616h-14.336v-132.608l18.432 8.192c27.136 11.776 58.368-0.512 70.144-27.648 11.776-27.136-0.512-58.368-27.648-70.144-13.312-5.632-28.672-5.632-42.496 0l-18.432 8.192v-117.76H399.872c14.848 33.28-0.512 72.704-33.792 87.552-33.28 14.848-72.704-0.512-87.552-33.792-7.68-16.896-7.68-35.84 0-53.248H166.912V512h137.216c-21.504 19.456-24.064 53.248-4.608 74.752 19.456 21.504 53.248 24.064 74.752 4.608 21.504-19.456 24.064-53.248 4.608-74.752l-4.608-4.608H512v-39.936h-13.312c-51.2 0-86.016-47.104-86.016-105.984s20.992-109.568 86.016-109.568h13.312V166.912h13.312v105.984h-26.624c-49.664 0-73.216 33.28-73.216 94.208 0 53.248 30.72 92.672 73.216 92.672 3.584 0.512 7.68 0.512 11.264 0l15.36-2.048V512h102.912c-13.824-35.84 4.096-76.8 40.448-90.624 35.84-13.824 76.8 4.096 90.624 40.448 6.144 15.872 6.144 33.792 0 50.176h97.792v13.312h-120.832c20.992-23.552 19.456-59.392-3.584-80.896-23.552-20.992-59.392-19.456-80.896 3.584-19.968 21.504-19.968 55.296 0 76.8H512z"fill=#6A68C6></path><path d="M444.928 693.248c-23.04 13.312-52.224 5.12-65.024-17.408-4.096-7.68-6.144-15.36-6.144-24.064V392.192c0-26.624 20.992-47.616 47.616-47.616 8.704 0 16.896 2.048 24.576 6.656l221.696 132.608c23.04 13.312 30.208 42.496 16.896 65.024-4.096 6.656-10.24 12.8-16.896 16.896"fill=#FDDE80></path></symbol><symbol id=header-icon-digital viewBox="0 0 1024 1024"><path d="M298.496 284.928l17.664-51.2a36.608 36.608 0 0 1 33.28-22.016h325.376a37.12 37.12 0 0 1 34.304 22.016l17.408 51.2h88.576a69.376 69.376 0 0 1 66.56 70.656v377.344a69.12 69.12 0 0 1-67.84 70.144H209.92a69.12 69.12 0 0 1-68.352-70.144V355.584a69.376 69.376 0 0 1 68.352-70.656z"fill=#FFBA7B></path><path d="M141.568 457.728h740.096v271.36a69.632 69.632 0 0 1-73.728 73.984H210.688a69.12 69.12 0 0 1-69.12-69.376z"fill=#FB952C></path><path d="M512 358.4a197.376 197.376 0 1 1-197.376 197.376A197.632 197.632 0 0 1 512 358.4z"fill=#FB952C></path><path d="M512 409.6a148.224 148.224 0 1 1-147.968 147.968A147.968 147.968 0 0 1 512 409.6z"fill=#FFFFFF></path><path d="M512 457.728a98.816 98.816 0 1 1-98.56 98.56A98.56 98.56 0 0 1 512 457.728z"fill=#FB952C></path><path d="M733.696 358.4h73.984a25.6 25.6 0 0 1 25.6 25.6 25.6 25.6 0 0 1-25.6 25.6h-73.984a25.6 25.6 0 0 1-25.6-25.6 25.6 25.6 0 0 1 25.6-25.6z"fill=#FFFFFF></path></symbol></svg><div class=custom-navbar><div class=blur-layer-container><div class="blur-layer left-pad"></div><div class=blur-layer></div><div class="blur-layer right-pad"></div></div><ul><li v-for="c of components":key=c.name :data-name=c.name v-show=!c.hidden :class="{disabled: c.disabled, active: c.active}":style="{flex: c.flex, order: c.order}"@mouseenter=requestPopup(c)><a class=main-content v-if="typeof c.href === 'string'":href="!c.active && !c.touch && c.href"v-html=c.html target=_blank></a><div class=main-content v-else-if="typeof c.href === 'function'"@click="!c.active && !c.touch && c.href($event)"v-html=c.html></div><div class=main-content v-else v-html=c.html></div><div class=notify-count v-show=!c.active></div><div class=popup-container><div class=popup v-if=c.popupHtml :class="{'no-padding': c.noPadding, 'transparent': c.transparent }"><div v-if=c.requestedPopup v-html=c.popupHtml></div></div></div><div class=active-bar></div></li></ul></div><div class=custom-navbar-settings><div class=header><h1>顶栏布局</h1><div class=header-blank></div><button class=close title=关闭 @click=close><i class="mdi mdi-close mdi-24px"></i></button></div><div class="header paddings-desc">边缘间距: 设定两侧边缘处的间距, 单位为百分比, 100%为整个顶栏的宽度. 允许设置的范围为 0% ~ 40%</div><div class=paddings><input type=range min=0 max=40 step=0.5 v-model=boundsPadding><span>{{boundsPadding}}%</span></div><div class="header orders-desc">顺序与显示: 在左侧的条状图标上拖动可以改变它们的顺序, 或者按住名字一会再拖动也可以调顺序. 点击右侧的眼睛图标可以显示/隐藏它们.</div><div class=orders><ul class=order-list><order-item v-for="item of orderList":key=item.name :item=item></order-item></ul></div></div>`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar.min.js"]=(()=>(e,t)=>{const i=["//www.bilibili.com","//t.bilibili.com","//search.bilibili.com","//space.bilibili.com","//account.bilibili.com","//pay.bilibili.com","//member.bilibili.com","//big.bilibili.com","//message.bilibili.com","//app.bilibili.com","//passport.bilibili.com","//live.bilibili.com/blackboard/"];const o=["//t.bilibili.com/vote/h5/index/#/result","//t.bilibili.com/lottery/h5/index/#/result","//member.bilibili.com/video/upload","//space.bilibili.com/ajax/","//www.bilibili.com/h5/comment/","//member.bilibili.com/v2","//game.bilibili.com/"];const a=()=>{document.documentElement.style.setProperty("--navbar-bounds-padding",`0 ${e.customNavbarBoundsPadding}%`);document.documentElement.style.setProperty("--navbar-blur-opacity",(e.customNavbarBlurOpacity||.7).toString());addSettingsListener("customNavbarBlurOpacity",(e=>{document.documentElement.style.setProperty("--navbar-blur-opacity",e)}));const t=["https://space.bilibili.com","https://www.bilibili.com/read"];if(!t.some((e=>document.URL.startsWith(e)))){addSettingsListener("customNavbarGlobalFixed",(e=>{document.body.classList.toggle("fixed-navbar",e)}),true)}};const r=(e,t,i)=>{i.classList.toggle(e,t)};const n=e=>{dq(".custom-navbar").classList.toggle("dark",e);dq(".custom-navbar-settings").classList.toggle("dark",e)};return(()=>{const l=document.URL.replace(location.search,"");const c=l==="https://www.bilibili.com/"||l==="https://www.bilibili.com/index.html";if(isIframe()||e.bilibiliSimpleNewHomeCompatible&&c||document.contentType!=="text/html"){t.removeStyle("customNavbarStyle");return}a();const s=!(!i.some((e=>document.URL.includes(e)))||o.some((e=>document.URL.includes(e))));if(s){document.body.classList.add("custom-navbar-loading");(async()=>{const i=await t.importAsync((()=>"customNavbarHtml")());document.body.insertAdjacentHTML("beforeend",i);addSettingsListener("useDarkStyle",n,true);const o=()=>dq(".custom-navbar");["Fill","Shadow","Compact","Blur"].forEach((e=>{const t="customNavbar"+e;addSettingsListener(t,(t=>r(e.toLowerCase(),t,o())),true)}));SpinQuery.select("#banner_link,.international-header .bili-banner, .bili-header__banner").then((t=>{if(t===null||!(t instanceof HTMLElement)){return}if(t.style.backgroundImage||dq(t,".animated-banner")){addSettingsListener("customNavbarTransparent",(t=>{if(!e.hideBanner){o().classList.toggle("transparent",t)}}),true);addSettingsListener("hideBanner",(t=>{if(e.customNavbarTransparent){o().classList.toggle("transparent",!t)}}))}}));SpinQuery.condition((()=>dq("#banner_link,.international-header .bili-banner")),(e=>e===null?false:Boolean(e.style.backgroundImage)),(e=>{Observer.attributes(e,(()=>{const t=dqa(".custom-navbar .blur-layer");t.forEach((t=>{t.style.backgroundImage=e.style.backgroundImage;t.setAttribute("data-image",e.style.backgroundImage)}))}))}));const{Blank:a}=await t.importAsync("custom-navbar-blank");const{Logo:l}=await t.importAsync("custom-navbar-logo");const{Category:c}=await t.importAsync("custom-navbar-category");const{SimpleLink:s}=await t.importAsync("custom-navbar-simple-link");const{UserInfo:p}=await t.importAsync("custom-navbar-user-info");const{SearchBox:d}=await t.importAsync("custom-navbar-search-box");const{Iframe:m}=await t.importAsync("custom-navbar-iframe");const{Rank:b}=await t.importAsync("custom-navbar-rank");const u=[new a(1),new l,new c,new b,new s("相簿","https://h.bilibili.com","drawing"),new s("番剧","https://www.bilibili.com/anime/","bangumi"),new s("音频","https://www.bilibili.com/audio/home/","music"),new m("游戏中心","https://game.bilibili.com/",{src:`https://www.bilibili.com/page-proxy/game-nav.html`,width:`680px`,height:`260px`,lazy:true,iframeName:"games"}),new m("直播","https://live.bilibili.com",{src:`https://live.bilibili.com/blackboard/dropdown-menu.html`,width:`528px`,height:`266px`,lazy:true,iframeName:"lives"}),new s("赛事","https://www.bilibili.com/v/game/match/","match"),new s("会员购","https://show.bilibili.com","shop"),new m("漫画","https://manga.bilibili.com",{src:"https://manga.bilibili.com/eden/bilibili-nav-panel.html",width:"720px",height:"266px",lazy:true,iframeName:"manga"}),new a(2),new d,new p];if(getUID()){const{WatchlaterList:e}=await t.importAsync("custom-navbar-watchlater-list");const{Messages:i}=await t.importAsync("custom-navbar-messages");const{Activities:o}=await t.importAsync("custom-navbar-activities");const{Subscriptions:a}=await t.importAsync("custom-navbar-subscriptions");const{FavoritesList:r}=await t.importAsync("custom-navbar-favorites-list");const{HistoryList:n}=await t.importAsync("custom-navbar-history-list");u.push(new i,new a,new o,new e,new r,new n)}const{Upload:h}=await t.importAsync("custom-navbar-upload");const{DarkMode:g}=await t.importAsync("custom-navbar-dark-mode");u.push(new h,new a(3),new g);new Vue({el:".custom-navbar",data:{components:u},methods:{async requestPopup(e){if(!e.requestedPopup&&!e.disabled){this.$set(e,`requestedPopup`,true);if(e.initialPopup){e.initialPopup()}return}if(e.onPopup){e.onPopup()}}},mounted(){document.body.classList.remove("custom-navbar-loading");const e=[...u].sort(ascendingSort((e=>e.order)));const t=()=>{const t=()=>{let t=0;let i=true;let o=e.length-1;let a=true;while(t<o){i=e[t].checkPosition(!i);t++;a=e[o].checkPosition(!a);o--}};addSettingsListener("customNavbarOrder",t,true);addSettingsListener("customNavbarHidden",t);addSettingsListener("customNavbarBoundsPadding",t);window.addEventListener("resize",t)};if("requestIdleCallback"in unsafeWindow&&GM.info.scriptHandler!=="Violentmonkey"){unsafeWindow.requestIdleCallback(t)}else{setTimeout(t)}}})})()}else{t.removeStyle("customNavbarStyle")}return{widget:{content:`\n<div class="gui-settings-flat-button" id="custom-navbar-settings">\n<i class="mdi mdi-24px mdi-auto-fix"></i>\n<span>顶栏布局</span>\n</div>`,condition:()=>s,success:async()=>{const{initSettingsPanel:e}=await t.importAsync("custom-navbar-settings");await e()}},unload:()=>{const e=dqa(".custom-navbar,.custom-navbar-settings");e.forEach((e=>e.style.display="none"));t.removeStyle("customNavbarStyle")},reload:()=>{const e=dqa(".custom-navbar,.custom-navbar-settings");e.forEach((e=>e.style.display="flex"));t.applyImportantStyle("customNavbarStyle")}}})()})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-activities.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");let o=async()=>{};let a=async()=>{};let r;const n=({dataObject:e,apiUrl:i,name:a,handleJson:r,nextPage:n,template:l})=>{const c={template:l,components:{"dpi-img":()=>t.importAsync("dpi-img.vue")},methods:{handleJson:r,async fetchData(e=false){try{const e=await Ajax.getJsonWithCredentials(i);if(e.code!==0){throw new Error(e.message)}await this.handleJson(e)}catch(t){if(e===true){return}logError(`加载${a}动态失败, error = ${t}`)}finally{this.loading=false}}},data(){return Object.assign({loading:true,hasMoreContent:true,scrollObserver:null},e)},async mounted(){o=async()=>await this.fetchData(true);await this.fetchData();if(this.$refs.trigger&&typeof this.nextPage==="function"){console.log("infinite scroll");const e=this.$refs.trigger;const t=new IntersectionObserver((async e=>{console.log(e);if(e.some((e=>e.intersectionRatio>0))){const e=await this.nextPage();if(!e){console.log("disconnect");t.disconnect();this.hasMoreContent=false}}}));this.scrollObserver=t;t.observe(e)}},beforeDestroy(){o=async()=>{};if(this.scrollObserver){console.log("destroy");this.scrollObserver.disconnect();this.scrollObserver=null}}};if(n){c.methods.nextPage=n}return c};class l extends i{constructor(){super();this.boundingWidth=380;this.noPadding=true;this.href=e.oldTweets?"https://www.bilibili.com/account/dynamic":"https://t.bilibili.com/";this.html="动态";this.popupHtml=`\n<div class="activity-popup">\n<activity-tabs :tab.sync="selectedTab" :items="tabs"></activity-tabs>\n<div class="activity-popup-content">\n<transition name="activity-content" mode="out-in">\n<component :is="content"></component>\n</transition>\n          \x3c!-- <a class="view-more" target="_blank" :href="viewMoreUrl">查看更多<i class="mdi mdi-dots-horizontal-circle-outline"></i></a> --\x3e\n</div>\n</div>\n`;this.active=document.URL.replace(/\?.*$/,"")===this.href;this.initialPopup=()=>{this.init()};this.onPopup=()=>{this.setNotifyCount(0)};this.getNotifyCount();setInterval((async()=>{if(!navigator.onLine){return}await this.getNotifyCount();await a();await o()}),l.updateInterval)}static get updateInterval(){return 5*60*1e3}static getLatestID(){return document.cookie.replace(new RegExp(`(?:(?:^|.*;\\s*)bp_t_offset_${getUID()}\\s*\\=\\s*([^;]*).*$)|^.*$`),"$1")}static setLatestID(e){if(e===null||e===undefined){return}const t=l.getLatestID();if(l.compareID(e,t)<0){return}document.cookie=`bp_t_offset_${getUID()}=${e};path=/;domain=.bilibili.com;max-age=${60*60*24*30}`}static compareID(e,t){if(e===t){return 0}if(e.length>t.length){return 1}if(t.length>e.length){return-1}return e>t===true?1:-1}static isNewID(e){return l.compareID(e,r)>0}static updateLatestID(e){const[t]=[...e.map((e=>e.id))].sort(l.compareID).reverse();l.setLatestID(t)}async getNotifyCount(){const e=`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${l.getLatestID()}&type_list=8,64,512`;const t=await Ajax.getJsonWithCredentials(e);if(t.code!==0){return}this.setNotifyCount(t.data.update_num)}async init(){const{isVideoCardBlocked:i,isCardBlocked:o,isPreOrderedVideo:r}=await t.importAsync("feeds-apis");Vue.component("activity-loading",{template:`\n<div v-if="loading" class="loading">\n<i class="mdi mdi-18px mdi-loading mdi-spin"></i>加载中...\n</div>`,props:["loading"]});Vue.component("activity-empty",{template:`\n<div class="empty">空空如也哦 =￣ω￣=</div>`});new Vue({el:await SpinQuery.select(".activity-popup"),data:{tabs:[{name:"视频",component:"video-activity",moreUrl:"https://t.bilibili.com/?tab=8",get notifyApi(){return`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${l.getLatestID()}&type_list=8`},notifyCount:null},{name:"番剧",component:"bangumi-activity",moreUrl:"https://t.bilibili.com/?tab=512,4097,4098,4099,4100,4101",get notifyApi(){return`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${l.getLatestID()}&type_list=512`},notifyCount:null},{name:"专栏",component:"column-activity",moreUrl:"https://t.bilibili.com/?tab=64",get notifyApi(){return`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_num?rsp_type=1&uid=${getUID()}&update_num_dy_id=${l.getLatestID()}&type_list=64`},notifyCount:null},{name:"直播",component:"live-activity",moreUrl:"https://link.bilibili.com/p/center/index#/user-center/follow/1",notifyCount:null}],selectedTab:"视频"},components:{"activity-tabs":{props:["items","tab"],template:`\n<ul class="activity-tabs">\n<li v-for="item of items" class="activity-tab" :data-count="item.notifyCount" :class="{selected: item.name === tab}" @click="changeTab(item)">\n<div class="tab-name">{{item.name}}</div>\n</li>\n<a class="view-all" target="_blank" href="${e.oldTweets?"https://www.bilibili.com/account/dynamic":"https://t.bilibili.com/"}">\n                全部动态\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-activity"></i>\n</a>\n</ul>\n`,methods:{changeTab(e){if(this.tab===e.name){window.open(e.moreUrl,"_blank")}this.$emit("update:tab",e.name)}}},"video-activity":Object.assign(n({dataObject:{leftCards:[],rightCards:[]},apiUrl:`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=8`,name:"视频",template:`\n<div class="video-activity" :class="{center: loading || (leftCards.length + rightCards.length) === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && leftCards.length + rightCards.length === 0"></activity-empty>\n<div v-if="!loading" class="video-activity-column left">\n<video-card v-for="card of leftCards" :key="card.id" :card="card" :watchlaterInit="card.watchlater"></video-card>\n</div>\n<div v-if="!loading" class="video-activity-column right">\n<video-card v-for="card of rightCards" :key="card.id" :card="card" :watchlaterInit="card.watchlater"></video-card>\n</div>\n<div v-if="!loading && hasMoreContent" class="trigger" ref="trigger">加载中...</div>\n</div>\n`,async handleJson(e){const t=Number(new Date);const o=t-1e3*3600*24;const a=e=>{const i=new Date(e);const o=[i.getHours(),i.getMinutes(),i.getSeconds()].map((e=>e.toString().padStart(2,"0"))).join(":");let a;if(new Date(t).getFullYear()!==i.getFullYear()){a=[i.getFullYear(),i.getMonth()+1,i.getDate()]}else{a=[i.getMonth()+1,i.getDate()]}return`${a.map((e=>e.toString().padStart(2,"0"))).join("-")} ${o}`};const r=e=>{if(o<e){const i=Math.round((t-e)/1e3/3600);if(i===0){const i=Math.round((t-e)/1e3/60);if(i===0){return"刚刚"}return`${i}分钟前`}return`${i}小时前`}const i=new Date(e);let a;if(new Date(t).getFullYear()!==i.getFullYear()){a=[i.getFullYear(),i.getMonth()+1,i.getDate()]}else{a=[i.getMonth()+1,i.getDate()]}return`${a.map((e=>e.toString().padStart(2,"0"))).join("-")}`};const n=_.get(e,"data.cards",[]).map((e=>{const t=JSON.parse(e.card);return{coverUrl:t.pic,title:t.title,timeNumber:t.duration,time:formatDuration(t.duration),description:t.desc,aid:t.aid,bvid:e.desc.bvid,videoUrl:`https://www.bilibili.com/${e.desc.bvid}`,faceUrl:e.desc.user_profile.info.face,upName:e.desc.user_profile.info.uname,upUrl:`https://space.bilibili.com/${e.desc.user_profile.info.uid}`,id:e.desc.dynamic_id_str,pubTime:a(t.pubdate*1e3),pubTimeText:r(t.pubdate*1e3),watchlater:true,get new(){return l.isNewID(this.id)}}}));const c=_.uniqBy(n.concat(this.leftCards,this.rightCards),(e=>e.aid)).sort(((e,t)=>t.id>e.id?1:-1)).filter((e=>!i(e)));if(c.length===0){this.hasMoreContent=false}this.leftCards=c.filter(((e,t)=>t%2===0));this.rightCards=c.filter(((e,t)=>t%2===1));l.updateLatestID(c)},async nextPage(){const e=[...this.leftCards,...this.rightCards].sort(((e,t)=>t.id>e.id?1:-1));if(e.length===0){return false}let t=e.pop().id;const i=`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_history?uid=${getUID()}&offset_dynamic_id=${t}&type=8`;const o=await Ajax.getJsonWithCredentials(i);console.log("lastCardID",t,o);if(o.code!==0){return false}await this.handleJson(o);return Boolean(_.get(o,"data.has_more",true))}}),{components:{"video-card":{props:["card","watchlaterInit"],store:store,data(){return{}},computed:{...Vuex.mapState(["watchlaterList"]),watchlater(){if(this.watchlaterInit!==null){return this.watchlaterList.includes(this.card.aid)}else{return null}}},components:{"dpi-img":()=>t.importAsync("dpi-img.vue")},methods:{...Vuex.mapActions(["toggleWatchlater"])},async mounted(){},template:`\n<a class="video-activity-card" :class="{new: card.new}" target="_blank" :href="card.videoUrl">\n<div class="cover-container">\n<dpi-img class="cover" :size="{width: 172}" :src="card.coverUrl"></dpi-img>\n<div class="time">{{card.time}}</div>\n<div class="pub-time-text">{{card.pubTimeText}}</div>\n<div class="pub-time">{{card.pubTime}}</div>\n<div @click.stop.prevent="toggleWatchlater(card.aid)" class="watchlater"><i class="mdi" :class="{'mdi-clock-outline': !watchlater, 'mdi-check-circle': watchlater}"></i>{{watchlater ? '已添加' : '稍后再看'}}</div>\n</div>\n<h1 class="title" :title="card.title">{{card.title}}</h1>\n<a class="up" target="_blank" :href="card.upUrl" :title="card.upName">\n<dpi-img class="face" :size="24" :src="card.faceUrl"></dpi-img>\n<span class="name">{{card.upName}}</span>\n</a>\n</a>\n`}}}),"bangumi-activity":n({dataObject:{cards:[]},apiUrl:`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=512`,name:"番剧",template:`\n<div class="bangumi-activity" :class="{center: loading || cards.length === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && cards.length === 0"></activity-empty>\n<a v-if="!loading" class="bangumi-card" :class="{new: card.new}" v-for="card of cards" :key="card.id" target="_blank" :href="card.url">\n<dpi-img class="ep-cover" :size="{width: 100}" :src="card.epCoverUrl"></dpi-img>\n<h1 class="ep-title" :title="card.epTitle">{{card.epTitle}}</h1>\n<div class="up" :title="card.title">\n<dpi-img class="cover" :size="24" :src="card.coverUrl"></dpi-img>\n<div class="title">{{card.title}}</div>\n</div>\n</a>\n<div v-if="!loading && hasMoreContent" class="trigger" ref="trigger">加载中...</div>\n</div>\n`,handleJson:async function(e){const t=_.get(e,"data.cards",[]).filter((e=>!r(e))).map((e=>{const t=JSON.parse(e.card);return{title:t.apiSeasonInfo.title,coverUrl:t.apiSeasonInfo.cover,epCoverUrl:t.cover,epTitle:t.new_desc,url:t.url,id:e.desc.dynamic_id_str,get new(){return l.isNewID(this.id)}}}));this.cards=_.uniqBy(t.concat(this.cards),(e=>e.id)).sort(((e,t)=>t.id>e.id?1:-1)).filter((e=>!o({text:e.epTitle,username:e.title})));if(t.length===0){this.hasMoreContent=false}l.updateLatestID(t)},async nextPage(){const e=[...this.cards];if(e.length===0){return false}let t=e.pop().id;const i=`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_history?uid=${getUID()}&offset_dynamic_id=${t}&type=512`;const o=await Ajax.getJsonWithCredentials(i);console.log("lastCardID",t,o);if(o.code!==0){return false}await this.handleJson(o);return Boolean(_.get(o,"data.has_more",true))}}),"column-activity":n({dataObject:{cards:[]},apiUrl:`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=${getUID()}&type_list=64`,name:"专栏",template:`\n<div class="column-activity" :class="{center: loading || cards.length === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && cards.length === 0"></activity-empty>\n<a v-if="!loading" class="column-card" :class="{new: card.new}" v-for="card of cards" :key="card.id" target="_blank" :href="card.url">\n<div class="covers">\n                  \x3c!--<dpi-img class="cover" v-for="cover of card.covers" :key="cover" :size="{ height: 120, width: 0 }" :src="cover"></dpi-img>--\x3e\n<img class="cover" v-for="cover of card.covers" :key="cover" height="120" width="0" :src="cover"/>\n<a class="up" target="_blank" :href="card.upUrl">\n<img class="face" height="24" width="24" :src="card.faceUrl"/>\n                    \x3c!--<dpi-img class="face" :size="24" :src="card.faceUrl"></dpi-img>--\x3e\n<div class="name">{{card.upName}}</div>\n</a>\n</div>\n<h1 class="title" :title="card.title">{{card.title}}</h1>\n<div class="description" :title="card.description">{{card.description}}</div>\n</a>\n<div v-if="!loading && hasMoreContent" class="trigger" ref="trigger">加载中...</div>\n</div>\n`,handleJson:async function(e){const t=_.get(e,"data.cards",[]).filter((e=>!r(e))).map((e=>{const t=JSON.parse(e.card);return{covers:t.image_urls,originalCovers:t.origin_image_urls,upName:t.author.name,faceUrl:t.author.face,upUrl:`https://space.bilibili.com/${t.author.mid}`,title:t.title,description:t.summary,url:`https://www.bilibili.com/read/cv${t.id}`,id:e.desc.dynamic_id_str,get new(){return l.isNewID(this.id)}}}));this.cards=_.uniqBy(t.concat(this.cards),(e=>e.id)).sort(((e,t)=>t.id>e.id?1:-1)).filter((e=>!i(e)));if(t.length===0){this.hasMoreContent=false}l.updateLatestID(this.cards)},async nextPage(){const e=[...this.cards];if(e.length===0){return false}let t=e.pop().id;const i=`https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_history?uid=${getUID()}&offset_dynamic_id=${t}&type=64`;const o=await Ajax.getJsonWithCredentials(i);console.log("lastCardID",t,o);if(o.code!==0){return false}await this.handleJson(o);return Boolean(_.get(o,"data.has_more",true))}}),"live-activity":n({dataObject:{cards:[]},apiUrl:`https://api.live.bilibili.com/relation/v1/feed/feed_list?page=1&pagesize=24`,name:"直播",template:`\n<div class="live-activity" :class="{center: loading || cards.length === 0}">\n<activity-loading :loading="loading"></activity-loading>\n<activity-empty v-if="!loading && cards.length === 0"></activity-empty>\n<a v-if="!loading" class="live-card" v-for="card of cards" :key="card.id" target="_blank" :href="card.url">\n<dpi-img class="face" :size="{width: 48}" :src="card.faceUrl"></dpi-img>\n<h1 class="live-title" :title="card.title">{{card.title}}</h1>\n<div class="name" :title="card.name">{{card.name}}</div>\n</a>\n</div>\n`,handleJson:async function(e){const t=e=>({faceUrl:e.face,title:e.title,name:e.uname,id:e.roomid,url:e.link});this.cards=_.get(e,"data.list",[]).map(t);const i=await Ajax.getPages({api:e=>Ajax.getJsonWithCredentials(`https://api.live.bilibili.com/relation/v1/feed/feed_list?page=${e}&pagesize=24`),getList:e=>_.get(e,"data.list",[]),getTotal:e=>_.get(e,"data.results",0)});this.cards=i.map(t)}})},computed:{content(){return this.tabs.find((e=>e.name===this.selectedTab)).component},viewMoreUrl(){return this.tabs.find((e=>e.name===this.selectedTab)).moreUrl}},mounted(){a=async()=>{for(const e of this.tabs){if(e.notifyApi){const t=await Ajax.getJsonWithCredentials(e.notifyApi);if(t.code!==0||!t.data.update_num||this.selectedTab===e.name){continue}e.notifyCount=t.data.update_num}}};a()},destroyed(){a=async()=>{}},watch:{selectedTab(e){this.tabs.find((t=>t.name===e)).notifyCount=null}}})}get name(){return"activities"}}r=l.getLatestID();return{export:{Activities:l}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-blank.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(e){super();this.number=e;this.flex="1 0 auto";this.disabled=true}get name(){return"blank"+this.number}}return{export:{Blank:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-category.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(){super();this.boundingWidth=366;this.href=`https://www.bilibili.com`;this.html=`主站`;this.popupHtml=`\n<ul id="custom-navbar-home-popup">\n<li class="category-item loading" v-if="loading">\n          加载中...\n</li>\n<li class="category-item" style="display: none" :style="{display: loading ? 'none' : 'list-item'}" v-for="item of info" :class="{ main: item[1].count }">\n<a :href="item[1].link" target="_blank">\n<svg aria-hidden="true">\n<use :href="'#header-icon-' + item[1].icon" :xlink:href="'#header-icon-' + item[1].icon"></use>\n</svg>\n<div>{{item[0]}}</div>\n<span>{{item[1].count}}</span>\n</a>\n<div class="popup" v-if="item[1].subRegions">\n<a v-for="region of Object.entries(item[1].subRegions)" :href="region[1]" target="_blank">\n              {{region[0]}}\n</a>\n</div>\n</li>\n</ul>\n`;const e=async()=>{const e=await Ajax.getJson("https://api.bilibili.com/x/web-interface/online");if(parseInt(e.code)!==0){throw new Error(`[自定义顶栏] 分区投稿信息获取失败: ${e.message}`)}const t=e.data.region_count;await SpinQuery.select("#custom-navbar-home-popup");return{"动画":{icon:"douga",count:t[1],link:`https://www.bilibili.com/v/douga/`,subRegions:{"MAD·AMV":`https://www.bilibili.com/v/douga/mad/`,"MMD·3D":`https://www.bilibili.com/v/douga/mmd/`,"短片·手书·配音":`https://www.bilibili.com/v/douga/voice/`,"手办·模玩":`https://www.bilibili.com/v/douga/garage_kit/`,"特摄":`https://www.bilibili.com/v/douga/tokusatsu/`,"综合":`https://www.bilibili.com/v/douga/other/`}},"番剧":{icon:"anime",count:t[13],link:`https://www.bilibili.com/anime/`,subRegions:{"连载动画":`https://www.bilibili.com/v/anime/serial/`,"完结动画":`https://www.bilibili.com/v/anime/finish/`,"资讯":`https://www.bilibili.com/v/anime/information/`,"官方延伸":`https://www.bilibili.com/v/anime/offical/`,"新番时间表":`https://www.bilibili.com/anime/timeline/`,"番剧索引":`https://www.bilibili.com/anime/index/`}},"国创":{icon:"guochuang",count:t[167],link:`https://www.bilibili.com/guochuang/`,subRegions:{"国产动画":`https://www.bilibili.com/v/guochuang/chinese/`,"国产原创相关":`https://www.bilibili.com/v/guochuang/original/`,"布袋戏":`https://www.bilibili.com/v/guochuang/puppetry/`,"动态漫·广播剧":`https://www.bilibili.com/v/guochuang/motioncomic/`,"资讯":`https://www.bilibili.com/v/guochuang/information/`,"新番时间表":`https://www.bilibili.com/guochuang/timeline/`,"国产动画索引":`https://www.bilibili.com/guochuang/index/`}},"音乐":{icon:"music",count:t[3],link:`https://www.bilibili.com/v/music/`,subRegions:{"原创音乐":"https://www.bilibili.com/v/music/original/","翻唱":"https://www.bilibili.com/v/music/cover/","VOCALOID·UTAU":"https://www.bilibili.com/v/music/vocaloid/","电音":"https://www.bilibili.com/v/music/electronic/","演奏":"https://www.bilibili.com/v/music/perform/",MV:"https://www.bilibili.com/v/music/mv/","音乐现场":"https://www.bilibili.com/v/music/live/","音乐综合":"https://www.bilibili.com/v/music/other/","音频":"https://www.bilibili.com/audio/home?musicType=music","说唱":"https://www.bilibili.com/v/rap"}},"舞蹈":{icon:"dance",count:t[129],link:`https://www.bilibili.com/v/dance/`,subRegions:{"宅舞":"https://www.bilibili.com/v/dance/otaku/","街舞":"https://www.bilibili.com/v/dance/hiphop/","明星舞蹈":"https://www.bilibili.com/v/dance/star/","中国舞":"https://www.bilibili.com/v/dance/china/","舞蹈综合":"https://www.bilibili.com/v/dance/three_d/","舞蹈教程":"https://www.bilibili.com/v/dance/demo/"}},"游戏":{icon:"game",count:t[4],link:`https://www.bilibili.com/v/game/`,subRegions:{"单机游戏":"https://www.bilibili.com/v/game/stand_alone/","电子竞技":"https://www.bilibili.com/v/game/esports/","手机游戏":"https://www.bilibili.com/v/game/mobile/","网络游戏":"https://www.bilibili.com/v/game/online/","桌游棋牌":"https://www.bilibili.com/v/game/board/",GMV:"https://www.bilibili.com/v/game/gmv/","音游":"https://www.bilibili.com/v/game/music/",Mugen:"https://www.bilibili.com/v/game/mugen/","游戏赛事":"https://www.bilibili.com/v/game/match/"}},"知识":{icon:"knowledge",count:t[36],link:`https://www.bilibili.com/v/knowledge/`,subRegions:{"科学科普":"https://www.bilibili.com/v/knowledge/science/","社科·法律·心理":"https://www.bilibili.com/v/knowledge/social_science/","人文历史":"https://www.bilibili.com/v/knowledge/humanity_history/","财经商业":"https://www.bilibili.com/v/knowledge/business/","校园学习":"https://www.bilibili.com/v/knowledge/campus/","职业职场":"https://www.bilibili.com/v/knowledge/career/","设计·创意":"https://www.bilibili.com/v/knowledge/design/","野生技能协会":"https://www.bilibili.com/v/knowledge/skill/"}},"科技":{icon:"tech",count:t[188],link:`https://www.bilibili.com/v/tech/`,subRegions:{"全部":"https://www.bilibili.com/v/tech/","数码":"https://www.bilibili.com/v/tech/digital/","软件应用":"https://www.bilibili.com/v/tech/application/","计算机技术":"https://www.bilibili.com/v/tech/computer_tech/","工业·工程·机械":"https://www.bilibili.com/v/tech/industry/","极客DIY":"https://www.bilibili.com/v/tech/diy/"}},"生活":{icon:"life",count:t[160],link:`https://www.bilibili.com/v/life/`,subRegions:{"搞笑":"https://www.bilibili.com/v/life/funny/","日常":"https://www.bilibili.com/v/life/daily/","手工":"https://www.bilibili.com/v/life/handmake/","绘画":"https://www.bilibili.com/v/life/painting/","运动":"https://www.bilibili.com/v/life/sports/","汽车":"https://www.bilibili.com/v/life/automobile/","其他":"https://www.bilibili.com/v/life/other/"}},"美食":{icon:"food",count:t[211],link:"https://www.bilibili.com/v/food/",subRegions:{"美食制作":"https://www.bilibili.com/v/food/make/","美食侦探":"https://www.bilibili.com/v/food/detective/","美食测评":"https://www.bilibili.com/v/food/measurement/","田园美食":"https://www.bilibili.com/v/food/rural/","美食记录":"https://www.bilibili.com/v/food/record/"}},"动物圈":{icon:"animal",count:t[217],link:"https://www.bilibili.com/v/animal",subRegions:{"喵星人":"https://www.bilibili.com/v/animal/cat/","汪星人":"https://www.bilibili.com/v/animal/dog/","大熊猫":"https://www.bilibili.com/v/animal/panda/","野生动物":"https://www.bilibili.com/v/animal/wild_animal/","爬宠":"https://www.bilibili.com/v/animal/reptiles/","动物综合":"https://www.bilibili.com/v/animal/animal_composite/"}},"鬼畜":{icon:"kichiku",count:t[119],link:`https://www.bilibili.com/v/kichiku/`,subRegions:{"鬼畜调教":"https://www.bilibili.com/v/kichiku/guide/","音MAD":"https://www.bilibili.com/v/kichiku/mad/","人力VOCALOID":"https://www.bilibili.com/v/kichiku/manual_vocaloid/","教程演示":"https://www.bilibili.com/v/kichiku/course/"}},"时尚":{icon:"fashion",count:t[155],link:`https://www.bilibili.com/v/fashion/`,subRegions:{"美妆":"https://www.bilibili.com/v/fashion/makeup/","服饰":"https://www.bilibili.com/v/fashion/clothing/","健身":"https://www.bilibili.com/v/fashion/aerobics/","T台":"https://www.bilibili.com/v/fashion/catwalk/","风尚标":"https://www.bilibili.com/v/fashion/trends/"}},"资讯":{icon:"information",count:t[202],link:`https://www.bilibili.com/v/information/`,subRegions:{"热点":"https://www.bilibili.com/v/information/hotspot/","环球":"https://www.bilibili.com/v/information/global/","社会":"https://www.bilibili.com/v/information/social/","综合":"https://www.bilibili.com/v/information/multiple/"}},"娱乐":{icon:"ent",count:t[5],link:`https://www.bilibili.com/v/ent/`,subRegions:{"综艺":"https://www.bilibili.com/v/ent/variety/","明星":"https://www.bilibili.com/v/ent/star/"}},"影视":{icon:"cinephile",count:t[181],link:`https://www.bilibili.com/v/cinephile/`,subRegions:{"影视杂谈":"https://www.bilibili.com/v/cinephile/cinecism/","影视剪辑":"https://www.bilibili.com/v/cinephile/montage/","短片":"https://www.bilibili.com/v/cinephile/shortfilm/","预告·资讯":"https://www.bilibili.com/v/cinephile/trailer_info/"}},"放映厅":{icon:"cinema",count:t[177]+t[23]+t[11],link:`https://www.bilibili.com/cinema/`,subRegions:{"纪录片":"https://www.bilibili.com/documentary/","电影":"https://www.bilibili.com/movie/","电视剧":"https://www.bilibili.com/tv/"}},"专栏":{icon:"read",count:``,link:`https://www.bilibili.com/read/home`},"直播":{icon:"zhibo",count:``,link:`https://live.bilibili.com`,subRegions:{"全部直播":"https://live.bilibili.com/all?visit_id=5icxsa0kmts0","游戏直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=2&areaId=0&visit_id=5icxsa0kmts0#/2/0","手游直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=3&areaId=0&visit_id=5icxsa0kmts0#/3/0","娱乐直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=1&areaId=0&visit_id=5icxsa0kmts0#/1/0","电台直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=5&areaId=0&visit_id=5icxsa0kmts0#/5/0","绘画直播":"https://live.bilibili.com/p/eden/area-tags?parentAreaId=4&areaId=0&visit_id=5icxsa0kmts0#/4/0"}},"小黑屋":{icon:"blackroom",count:``,link:`https://www.bilibili.com/blackroom/`},"课堂":{icon:"zhishi",count:``,link:`https://www.bilibili.com/cheese/`},"音乐PLUS":{icon:"musicplus",count:``,link:`https://www.bilibili.com/v/musicplus/`},"专题":{icon:"topic",count:``,link:`https://www.bilibili.com/blackboard/topic_list.html`},"活动":{icon:"activit",count:``,link:`https://www.bilibili.com/blackboard/x/act_list`}}};this.initialPopup=async()=>{new Vue({el:await SpinQuery.select("#custom-navbar-home-popup"),data:{info:[],loading:true},async mounted(){try{this.info=Object.entries(await e())}finally{this.loading=false}}})}}get name(){return"category"}}return{export:{Category:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-component.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const o=380;class a{constructor(t="",o="",a="0 0 auto",r=false,n=false,l=null,c=null,s=null,p=0,d=e.touchNavBar,m=false){this.html=t;this.popupHtml=o;this.flex=a;this.disabled=r;this.requestedPopup=n;this.initialPopup=l;this.onPopup=c;this.href=s;this.notifyCount=p;this.touch=d;this.active=m;i(this,"noPadding",false);i(this,"transparent",false);i(this,"boundingWidth",0)}get name(){return"blank1"}static cleanUpOrders(){const t=_.sortBy(Object.entries(e.customNavbarOrder),(([,e])=>e));console.log(t);e.customNavbarOrder=_.fromPairs(t.map((([e],t)=>[e,t])))}get order(){const t=e.customNavbarOrder[this.name];const i=Object.values(_.groupBy(Object.values(e.customNavbarOrder),(e=>e))).some((e=>e.length>1));if(t===undefined||i){a.cleanUpOrders();return e.customNavbarOrder[this.name]}return t}get hidden(){return e.customNavbarHidden.includes(this.name)}get element(){return dq(`.custom-navbar li[data-name='${this.name}']`)}async setNotifyCount(e){const t=await SpinQuery.select(`.custom-navbar li[data-name='${this.name}'] .notify-count`);if(!t||e<=0){t.innerHTML="";return}t.innerHTML=e.toString()}async setNotifyStyle(e){const t=await SpinQuery.select(`.custom-navbar li[data-name='${this.name}'] .notify-count`);if(!t){return}const i={1:"number",2:"dot",3:"hidden"};t.classList.remove(...Object.values(i));t.classList.add(i[e])}checkPosition(e=false){if(this.boundingWidth===0||this.hidden){return true}const t=this.element;const i=t.querySelector(".main-content ~ .popup-container");if(!i){return true}i.style.transform="";if(e){return true}const a=t.getBoundingClientRect();const r=a.left+a.width/2;const n=document.documentElement.clientWidth;const l=r-this.boundingWidth/2;const c=r+this.boundingWidth/2;if(l<0){i.style.transform=`translateX(${Math.abs(l)+1}px)`}else if(c>n){i.style.transform=`translateX(${-(c-n)-1}px)`}return r<=o/2||n-r<=o/2}}return{export:{NavbarComponent:a}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-dark-mode.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(){super();this.touch=false;this.href=()=>e.useDarkStyle=!e.useDarkStyle;addSettingsListener("useDarkStyle",(e=>{if(e){this.html=`<svg style="width: 18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 47.96 47.96"><path d="M24,12A12,12,0,1,0,36,24,12,12,0,0,0,24,12Zm0,20a8,8,0,1,1,8-8A8,8,0,0,1,24,32Z"/><path d="M24,9a2,2,0,0,0,2-2V4a2,2,0,0,0-4,0V7A2,2,0,0,0,24,9Z"/><path d="M36,14a2,2,0,0,0,1.42-.59l2.12-2.12a2,2,0,1,0-2.83-2.83l-2.12,2.12A2,2,0,0,0,36,14Z"/><path d="M44,22H41a2,2,0,0,0,0,4h3a2,2,0,1,0,0-4Z"/><path d="M37.4,34.61a2,2,0,1,0-2.83,2.82l2.12,2.13a2,2,0,0,0,2.83-2.83Z"/><path d="M24,39a2,2,0,0,0-2,2v3a2,2,0,0,0,4,0V41A2,2,0,0,0,24,39Z"/><path d="M10.53,34.61,8.41,36.73a2,2,0,0,0,0,2.83,2,2,0,0,0,2.82,0l2.13-2.13a2,2,0,1,0-2.83-2.82Z"/><path d="M9,24a2,2,0,0,0-2-2H4a2,2,0,0,0,0,4H7A2,2,0,0,0,9,24Z"/><path d="M10.53,13.39a2,2,0,0,0,1.41.59,2,2,0,0,0,1.42-3.42L11.23,8.44a2,2,0,0,0-2.82,2.83Z"/></svg>`}else{this.html=`<svg style="width: 18px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48"><path d="M24.48,42.18A18.66,18.66,0,0,1,22.11,5,2,2,0,0,1,23.56,8.6,11.32,11.32,0,1,0,39.4,24.44,2,2,0,0,1,43,25.89,18.68,18.68,0,0,1,24.48,42.18ZM16.36,11.32A14.66,14.66,0,1,0,36.68,31.64,15.35,15.35,0,0,1,15,17.68,15.2,15.2,0,0,1,16.36,11.32Z"/></svg>`}}),true)}get name(){return"darkMode"}}return{export:{DarkMode:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-favorites-list.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{NavbarComponent:o}=t.import("custom-navbar-component");const a=e=>{const t=()=>{switch(e.type){default:case 2:return`https://www.bilibili.com/video/${e.bvid}`;case 12:return`https://www.bilibili.com/audio/au${e.id}`}};return{id:e.id,aid:e.id,bvid:e.bvid,playLink:t(),coverUrl:e.cover.replace("http:","https:"),favoriteTimestamp:e.fav_time*1e3,favoriteTime:new Date(e.fav_time*1e3),title:e.title,description:e.intro,duration:e.duration,durationText:formatDuration(e.duration),playCount:e.cnt_info.play,danmakuCount:e.cnt_info.danmaku,upName:e.upper.name,upFaceUrl:e.upper.face.replace("http:","https:"),upID:e.upper.mid}};class r extends o{constructor(){super();i(this,"vm",void 0);this.boundingWidth=380;this.noPadding=true;this.href=`https://space.bilibili.com/${getUID()}/favlist`;this.html=`收藏`;this.active=document.URL.replace(/\?.*$/,"")===this.href;this.popupHtml=`\n<div class="favorites-list loading">\n<div class="loading-tip">\n          加载中...\n</div>\n<div class="content">\n<div class="header">\n<v-dropdown class="list-select" @change="changeList()" :round="true" :items="listNames" :value.sync="selectedListName">\n</v-dropdown>\n<div class="play-all-container">\n<a class="play-all" :href="playLink" title="播放全部" target="_blank">\n<i class="mdi mdi-play"></i>\n</a>\n</div>\n<div class="search">\n<input type="text" placeholder="搜索" v-model="search">\n</div>\n<a class="more-info" :href="moreLink" title="查看更多" target="_blank">\n<i class="mdi mdi-dots-horizontal"></i>\n</a>\n</div>\n<transition-group name="cards" tag="div" class="cards">\n<div class="empty-tip" v-if="!cardsLoading && filteredCards.length === 0" key="empty-tip">\n              空空如也哦 =￣ω￣=\n</div>\n<div class="favorite-card" v-for="card of filteredCards" :key="card.id">\n<a class="cover-container" target="_blank" :href="card.playLink">\n<dpi-img class="cover" :src="card.coverUrl" :size="{width: 130, height: 85}"></dpi-img>\n<div class="floating duration">{{card.durationText}}</div>\n<div class="floating favorite-time">{{card.favoriteTime | formatDate}}</div>\n</a>\n<a class="title" target="_blank" :href="card.playLink" :title="card.title">{{card.title}}</a>\n<a class="up" target="_blank" :href="'https://space.bilibili.com/' + card.upID" :title="card.upName">\n<dpi-img placeholder-image class="face" :src="card.upFaceUrl" :size="20"></dpi-img>\n<div class="name">{{card.upName}}</div>\n</a>\n</div>\n<div class="loading-tip" v-if="cardsLoading" key="loading-tip">\n              加载中...\n</div>\n</transition-group>\n</div>\n</div>\n`;this.initialPopup=()=>this.init()}get name(){return"favoritesList"}async init(){this.vm=new Vue({el:await SpinQuery.select(`.custom-navbar [data-name="${this.name}"] .favorites-list`),store:store,filters:{formatDate(e){return`${e.getFullYear()}-${(e.getMonth()+1).toString().padStart(2,"0")}-${e.getDate().toString().padStart(2,"0")}`}},components:{DpiImg:()=>t.importAsync("dpi-img.vue"),VDropdown:()=>t.importAsync("v-dropdown.vue")},data:{list:[],cards:[],filteredCards:[],selectedListName:"",cardsLoading:true,cardsPage:1,search:""},watch:{search(e){if(e===""){this.filteredCards=this.cards;return}e=e.toLowerCase();this.filteredCards=this.cards.filter((t=>t.title.toLowerCase().includes(e)||t.upName.toLowerCase().includes(e)));this.searchAllList()},selectedListName(t){e.favoritesListCurrentSelect=t}},computed:{listNames(){return this.list.map((e=>e.name))},selectedListId(){const e=this.list.find((e=>e.name===this.selectedListName));return e?e.id:0},moreLink(){const e=this.selectedListId;if(e===0){return`https://space.bilibili.com/${getUID()}/favlist`}return`https://space.bilibili.com/${getUID()}/favlist?fid=${e}`},playLink(){const e=this.selectedListId;if(e===0){return undefined}return`https://www.bilibili.com/medialist/play/ml${e}`}},methods:{async getCards(){const t=`https://api.bilibili.com/medialist/gateway/base/spaceDetail?media_id=${this.selectedListId}&pn=${this.cardsPage}&ps=20`;const i=await Ajax.getJsonWithCredentials(t);if(i.code!==0){throw new Error(`加载收藏夹内容失败: ${i.message}`)}if(!i.data.medias){return[]}return i.data.medias.filter((t=>{if(e.customNavbarShowDeadVideos){return true}return t.attr!==9&&t.attr!==1})).map(a)},async changeList(){try{this.search="";this.cards=[];this.cardsPage=1;this.cardsLoading=true;this.cards=await this.getCards();this.filteredCards=this.cards;this.setInfiniteScroll()}catch(e){logError(e)}finally{this.cardsLoading=false}},async loadNextPage(){try{this.cardsLoading=true;this.cardsPage++;const e=await this.getCards();this.cards.push(...e);if(e.length>0){this.setInfiniteScroll()}}catch(e){logError(e)}finally{this.cardsLoading=false}},setInfiniteScroll(){const e=this.$el.querySelector(".cards");const t=_.debounce((()=>{if(this.search===""&&e.scrollTop+e.clientHeight>=e.scrollHeight-48){e.removeEventListener("scroll",t);this.loadNextPage()}}),200);e.addEventListener("scroll",t)},searchAllList:_.debounce((async function(){if(this.search===""){return}try{const e=await Ajax.getJsonWithCredentials(`https://api.bilibili.com/x/v3/fav/resource/list?media_id=${this.selectedListId}&pn=1&ps=20&keyword=${this.search}&order=mtime&type=0&tid=0`);const t=await Ajax.getJsonWithCredentials(`https://api.bilibili.com/x/v3/fav/resource/list?media_id=${this.selectedListId}&pn=1&ps=20&keyword=${this.search}&order=mtime&type=1&tid=0`);if(e.code!==0&&t.code!==0){return}const i=_.get(e,"data.medias",[])||[];const o=_.get(t,"data.medias",[])||[];const r=_.uniqBy(this.filteredCards.concat(i.map(a),o.map(a)),(e=>e.id));this.filteredCards=r}catch(e){console.error(e);return}}),200)},async mounted(){try{const t=`https://api.bilibili.com/medialist/gateway/base/created?pn=1&ps=100&up_mid=${getUID()}&is_space=0`;const i=await Ajax.getJsonWithCredentials(t);if(i.code!==0){throw new Error(`获取收藏夹列表失败: ${i.message}`)}this.list=i.data.list.map((e=>({id:e.id,name:e.title,count:e.media_count})));if(this.list.length>0){if(e.favoritesListCurrentSelect&&this.list.some((t=>t.name===e.favoritesListCurrentSelect))){this.selectedListName=e.favoritesListCurrentSelect}else{this.selectedListName=this.list[0].name}this.changeList()}}catch(e){logError(e)}finally{this.$el.classList.remove("loading")}}})}}return{export:{FavoritesList:r}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-history-list.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{NavbarComponent:o}=t.import("custom-navbar-component");const a=()=>{const e=new Date;const t=Number(new Date(e.getFullYear(),e.getMonth(),e.getDate()));const i=24*36e5;const o=t-i;const a=t-7*i;return{now:e,today:t,oneDay:i,yesterday:o,lastWeek:a}};const r=e=>{if(e.length===0){return[]}if("timestamp"in e[0]){const{today:t,yesterday:i,lastWeek:o}=a();const r=_.groupBy(e,(e=>{if(e.timestamp>=t){return"今天"}if(e.timestamp>=i){return"昨天"}if(e.timestamp>=o){return"本周"}return"更早"}));return Object.entries(r).map((([e,t])=>({name:e,items:t})))}else{return[{name:"最近观看",items:e}]}};const n=e=>{const{yesterday:t,today:i}=a();const o=Number(e);if(o>=i){return`${e.getHours().toString().padStart(2,"0")}:${e.getMinutes().toString().padStart(2,"0")}`}if(o>=t){return`昨天 ${e.getHours().toString().padStart(2,"0")}:${e.getMinutes().toString().padStart(2,"0")}`}return`${(e.getMonth()+1).toString().padStart(2,"0")}-${e.getDate().toString().padStart(2,"0")} ${e.getHours().toString().padStart(2,"0")}:${e.getMinutes().toString().padStart(2,"0")}`};const l=[{name:"视频",type:"video",api:"https://api.bilibili.com/x/web-interface/history/cursor?type=archive&ps=30",moreLink:"https://www.bilibili.com/account/history",getItems:e=>{const t=e.data.list;const i=t.map((e=>{const t=e.view_at*1e3;const i=Boolean(e.uri);const o=e.progress>0?`t=${e.progress}`:"t=0";const a=e.progress===-1?1:e.progress/e.duration;const r={isBangumi:i,id:e.history.bvid,title:e.title,coverUrl:e.cover,upName:e.author_name||e.show_title,upID:e.author_mid||e.kid,href:i?e.uri+`?${o}`:`https://www.bilibili.com/video/${e.history.bvid}?p=${e.history.page}&${o}`,duration:e.duration,durationText:formatDuration(e.duration),progress:a,progressText:fixed(a*100,1)+"%",timestamp:t,time:new Date(t)};r.timeText=n(r.time);return r}));return i}},{name:"专栏",type:"article",api:"https://api.bilibili.com/x/web-interface/history/cursor?type=article&ps=30",moreLink:"",getItems:e=>{const t=e.data.list;const i=t.map((e=>{const t=e.view_at*1e3;const i=e.history.cid||e.kid;const o={id:i,title:e.title,coverUrl:e.covers[0],upName:e.author_name,upID:e.author_mid,href:`https://www.bilibili.com/read/cv${i}`,timestamp:t,time:new Date(t)};o.timeText=n(o.time);return o}));return i}},{name:"直播",type:"live",api:"https://api.live.bilibili.com/xlive/web-ucenter/v1/history/get_history_by_uid",moreLink:"https://link.bilibili.com/p/center/index#/user-center/view-history/live",getItems:e=>{const t=e.data.list;const i=t.map((e=>({id:e.roomid,href:`https://live.bilibili.com/${e.roomid}`,upID:e.uid,upName:e.uname,coverUrl:e.user_cover,title:e.title,liveStatus:e.live_status,liveStatusText:{0:"未开播",1:"直播中",2:"轮播中"}[e.live_status]})));return i}}];class c extends o{constructor(){super();i(this,"vm",void 0);this.boundingWidth=350;this.noPadding=true;this.href=`https://www.bilibili.com/account/history`;this.html=`历史`;this.active=document.URL.replace(/\?.*$/,"")===this.href;this.popupHtml=`\n<div class="history-list loading">\n<div class="loading-tip">\n          加载中...\n</div>\n<div class="content">\n<div class="header">\n<div class="tabs">\n<div class="tab" v-for="tab of tabs" :class="{active: selectedTab === tab}" @click="selectedTab = tab">\n<div class="tab-name">{{tab.name}}</div>\n</div>\n</div>\n<div class="search">\n<input type="text" placeholder="搜索" v-model="search">\n</div>\n<button class="more-info" :disabled="!selectedTab.moreLink || null" @click="viewMore()" title="查看更多">\n<i class="mdi mdi-dots-horizontal"></i>\n</button>\n</div>\n<transition-group name="history-content" tag="div" class="history-content">\n<div class="empty-tip" v-if="!timelineLoading && filteredTimeline.length === 0" key="empty-tip">\n              空空如也哦 =￣ω￣=\n</div>\n<div class="loading-tip" v-if="timelineLoading" key="loading-tip">\n              加载中...\n</div>\n<div class="time-group" v-for="t of filteredTimeline" :key="t.name">\n<div class="time-group-name">{{t.name}}</div>\n<transition-group name="time-group" tag="div" class="time-group-items">\n<div class="time-group-item" v-for="h of t.items" :key="h.id">\n<a class="cover-container" target="_blank" :href="h.href">\n<dpi-img class="cover" :src="h.coverUrl" :size="{width: 160, height: 110}" placeholder-image></dpi-img>\n<div v-if="h.progress" class="progress" :style="{width: h.progress * 100 + '%'}"></div>\n<div v-if="h.progressText" class="floating progress-number">{{h.progress >= 1 ? '已看完' : h.progressText}}</div>\n<div v-if="h.durationText" class="floating duration">{{h.durationText}}</div>\n</a>\n<a class="title" target="_blank" :href="h.href" :title="h.title">\n                    {{h.title || h.upName + '的直播间'}}\n</a>\n<a class="up" target="_blank" :href="h.isBangumi ? h.href : 'https://space.bilibili.com/' + h.upID" :title="h.upName">\n                    \x3c!--<icon type="extended" icon="up"></icon>--\x3e\n<div class="up-name">{{h.upName}}</div>\n</a>\n<div v-if="h.timeText" class="time" :title="h.time.toLocaleString()">\n                    {{h.timeText}}\n</div>\n<div v-if="h.liveStatus !== undefined" class="live-status" :class="{ live: h.liveStatus === 1 }">\n                    {{h.liveStatusText}}\n</div>\n</div>\n</transition-group>\n</div>\n</transition-group>\n</div>\n</div>\n`;this.initialPopup=()=>this.init();this.onPopup=()=>{var e;return(e=this.vm)===null||e===void 0?void 0:e.updateTimeline(false)}}get name(){return"historyList"}async init(){this.vm=new Vue({el:await SpinQuery.select(`.custom-navbar [data-name="${this.name}"] .history-list`),store:store,components:{DpiImg:()=>t.importAsync("dpi-img.vue"),Icon:()=>t.importAsync("icon.vue")},data:{tabs:l,selectedTab:l[0],items:[],timeline:[],timelineLoading:true,search:""},computed:{filteredTimeline(){if(!this.search){return this.timeline}const e=this.search.toLowerCase();return r(this.items.filter((t=>t.title.toLowerCase().includes(e)||t.upName.toLowerCase().includes(e))))}},methods:{async updateTimeline(e=true){try{if(e){this.timelineLoading=true;this.timeline=[]}const t=this.selectedTab;const i=await Ajax.getJsonWithCredentials(t.api);if(i.code!==0){throw new Error(`加载历史记录失败: ${i.message}`)}this.items=t.getItems(i);this.timeline=r(this.items)}catch(e){logError(e)}finally{this.timelineLoading=false}},viewMore(){const e=this.selectedTab;if(e.moreLink){open(e.moreLink,"_blank")}}},watch:{selectedTab(){this.updateTimeline()}},async created(){this.updateTimeline()},async mounted(){this.$el.classList.remove("loading")}})}}return{export:{HistoryList:c}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-iframe.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{NavbarComponent:o}=t.import("custom-navbar-component");class a extends o{constructor(e,t,o){super();i(this,"iframeName",void 0);const{src:a,width:r,height:n,lazy:l,iframeName:c}=o;this.boundingWidth=parseInt(r);this.iframeName=c;this.html=e;this.href=t;this.popupHtml=`\n<iframe src='${a}' frameborder='0' width='${r}' height='${n}'></iframe>\n`;this.noPadding=true;this.requestedPopup=l?false:true;this.touch=false;this.transparent=true}get name(){return this.iframeName+"Iframe"}}return{export:{Iframe:a}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-logo.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(){super();this.href=`https://www.bilibili.com/`;this.touch=false;addSettingsListener("customNavbarSeasonLogo",(()=>this.getLogo()),true)}async getLogo(){if(e.customNavbarSeasonLogo){const e=await Ajax.getJson("https://api.bilibili.com/x/web-show/res/locs?pf=0&ids=142");if(e.code===0){this.html=`<img height="38" class="custom-navbar-season-logo" src="${e.data[142][0].litpic.replace("http:","https:")}">`;return}}this.html=`<i class="custom-navbar-iconfont custom-navbar-icon-logo"></i>`}get name(){return"logo"}}return{export:{Logo:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-messages.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{NavbarComponent:o}=t.import("custom-navbar-component");class a extends o{constructor(){super();i(this,"totalCount",void 0);i(this,"settings",void 0);this.href="https://message.bilibili.com/";this.html="消息";this.popupHtml=`\n<ul id="message-list">\n<li><a data-name="reply" target="_blank" href="https://message.bilibili.com/#/reply">回复我的</a></li>\n<li><a data-name="at" target="_blank" href="https://message.bilibili.com/#/at">@我的</a></li>\n<li><a data-name="like" target="_blank" href="https://message.bilibili.com/#/love">收到的赞</a></li>\n<li><a data-name="user_msg" target="_blank" href="https://message.bilibili.com/#/whisper">我的消息</a></li>\n<li><a data-name="sys_msg" target="_blank" href="https://message.bilibili.com/#/system">系统通知</a></li>\n</ul>\n`;this.requestedPopup=true;this.active=document.URL.startsWith("https://message.bilibili.com/");this.fetchSettings().then((e=>{if(e){this.updateCount();this.setupEvents();this.onPopup=()=>this.updateCount()}}))}get name(){return"messages"}async fetchSettings(){const e=await Ajax.getJsonWithCredentials(`https://api.vc.bilibili.com/link_setting/v1/link_setting/get?msg_notify=1&show_unfollowed_msg=1`);if(e.code!==0){return}await this.setNotifyStyle(e.data.msg_notify);this.settings={notify:e.data.msg_notify!==3,hideNotFollowedCount:e.data.show_unfollowed_msg===1,json:e.data};console.log(this.settings);return e.data.msg_notify!==3}async setupEvents(){const e=await SpinQuery.select("#message-list");const t=[...e.querySelectorAll("a[data-name]")];t.forEach((e=>{e.addEventListener("click",(()=>{const t=e.getAttribute("data-count");if(!t){return}const i=parseInt(t);e.removeAttribute("data-count");this.totalCount-=i;if(this.totalCount<0){this.totalCount=0}this.setNotifyCount(this.totalCount)}))}))}async updateCount(){const e=await Ajax.getJsonWithCredentials(`https://api.bilibili.com/x/msgfeed/unread`);const t=await Ajax.getJsonWithCredentials(`https://api.vc.bilibili.com/session_svr/v1/session_svr/single_unread`);const i=await SpinQuery.select("#message-list");const o=[...i.querySelectorAll("a[data-name]")];const a=o.map((e=>e.getAttribute("data-name")));if(e.code!==0||t.code!==0){return}e.data["user_msg"]=t.data.follow_unread||0;if(!this.settings.hideNotFollowedCount){e.data["user_msg"]+=t.data.unfollow_unread||0}this.totalCount=a.reduce(((t,i)=>t+(e.data[i]||0)),0);if(!this.totalCount){return}await this.setNotifyCount(this.totalCount);a.forEach(((t,i)=>{const a=e.data[t];if(a>0){o[i].setAttribute("data-count",a.toString())}else{o[i].removeAttribute("data-count")}}))}}return{export:{Messages:a}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-rank.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(){super();this.href="https://www.bilibili.com/v/popular/rank/all";this.html="排行";this.popupHtml=`\n<ul id="ranking-list">\n<li><a target="_blank" href="https://www.bilibili.com/v/popular/all">综合热门</a></li>\n<li><a target="_blank" href="https://www.bilibili.com/v/popular/weekly">每周必看</a></li>\n<li><a target="_blank" href="https://www.bilibili.com/v/popular/history">入站必刷</a></li>\n<li><a target="_blank" href="https://www.bilibili.com/v/popular/rank/all">排行榜</a></li>\n</ul>\n`}get name(){return"rankingLink"}}return{export:{Rank:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-search-box.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");const o="be_search_history";const a="search_history";const r=10;const n=(e=a)=>{const t=localStorage.getItem(e);const i=t?JSON.parse(t):[];return i};const l=(e=a)=>localStorage.setItem(e,"[]");const c=(e,t=a)=>{localStorage.setItem(t,JSON.stringify(_.sortBy(_.uniqBy(n().concat(e),(e=>e.value)),(e=>e.timestamp)).reverse().slice(0,r)))};const s=(e,t=a)=>{const i=n();const o=i.findIndex((t=>t.value===e));if(o!==-1){i.splice(o,1);localStorage.setItem(t,JSON.stringify(i))}};const p=()=>{if(e.searchHistory.length>0){try{const t=n();const i=e.searchHistory.map((e=>({value:e.keyword,isHistory:1,timestamp:Number(new Date(e.date))})));const o=_.sortBy(_.uniqBy(i.concat(t),(e=>e.value)),(e=>e.timestamp)).reverse().slice(0,r);localStorage.setItem(a,JSON.stringify(o));e.searchHistory=[]}catch(e){console.error(e)}}if(n(o).length>0){n(o).forEach((e=>c(e)));l(o)}};const d=e=>{const t=e.match(/^av([\d]+)$/i);if(t){return{success:true,text:e,link:`https://www.bilibili.com/av${t[1]}`,aid:t[1],bvid:""}}const i=e.match(/^bv[\da-zA-Z]+$/i);if(i){return{success:true,text:e,link:`https://www.bilibili.com/${e.replace(/^bv/i,"BV")}`,aid:"",bvid:e.replace(/^bv/i,"BV")}}return{success:false,text:e,link:"",aid:"",bvid:""}};class m extends i{constructor(){super();this.disabled=true;this.html=`\n<form id="custom-navbar-search" autocomplete="off" target="_blank" method="get" action="https://search.bilibili.com/all">\n<input type="text" placeholder="搜索" name="keyword">\n<input type="hidden" name="from_source" value="nav_suggest_new">\n<a style="display: none" target="_blank" class="recommended-target"></a>\n<button type="submit" title="搜索" tabindex="-1">\n<svg style="width:22px;height:22px" viewBox="0 0 24 24">\n<path d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z" />\n</svg>\n</button>\n</form>\n<div class="popup search-list" :class="{empty: items.length === 0}">\n<div\n          class="search-list-item"\n          tabindex="0"\n          v-for="(item, index) of items"\n          :title="isHistory ? item.html : ''"\n          @keydown.enter.stop.prevent="submit(item.value)"\n          @keydown.shift.delete.stop.prevent="deleteItem(item, index)"\n          @keydown.down.stop.prevent="nextItem(index)"\n          @keydown.up.stop.prevent="previousItem(index)">\n<div\n            @click.self="submit(item.value)"\n            class="search-list-item-text"\n            :title="item.value"\n            v-html="item.html"></div>\n<div\n            class="delete-history"\n            v-if="isHistory"\n            title="删除此项"\n            @click="deleteItem(item, index)">\n<i class="mdi mdi-18px mdi-close"></i>\n</div>\n</div>\n<div\n          class="search-list-item clear-history"\n          tabindex="0"\n          v-if="items.length > 0 && isHistory"\n          @click="clearSearchHistory()"\n          @keydown.enter.stop.prevent="clearSearchHistory()"\n          @keydown.down.stop.prevent="nextItem(items.length)"\n          @keydown.up.stop.prevent="previousItem(items.length)">\n<i class="mdi mdi-18px mdi-delete-sweep"></i>\n          清除搜索历史\n</div>\n<div class="copy-tip" :class="{show: showCopyTip}">\n          已复制\n</div>\n</div>\n`;this.init()}async init(){const t=await SpinQuery.select("#custom-navbar-search");const i=t.querySelector("input[name='keyword']");p();if(document.URL.startsWith("https://search.bilibili.com")){var o;const e=((o=window.location.search.match(/keyword=([^&]+)/))===null||o===void 0?void 0:o[1])||"";i.value=decodeURIComponent(e);const t=dq("#search-keyword");if(t){t.addEventListener("change",(()=>i.value=t.value))}}t.addEventListener("submit",(o=>{if(i.value===""){if(!e.hideTopSearch){t.querySelector(".recommended-target").click()}else{window.open("https://search.bilibili.com")}o.preventDefault();return false}const a=d(i.value);if(a.success){window.open(a.link,"_blank");o.preventDefault();return false}const r=n().find((e=>e.value===i.value));if(r){r.timestamp=Number(new Date)}else{const e={value:i.value,isHistory:1,timestamp:Number(new Date)};c(e)}return true}));if(!e.hideTopSearch){const e=await Ajax.getJson("https://api.bilibili.com/x/web-interface/search/default");if(e.code===0){i.setAttribute("placeholder",e.data.show_name);let o;if(e.data.url!==""){o=e.data.url}else if(e.data.name.startsWith("av")){o=`https://www.bilibili.com/${e.data.name}`}else{o=`https://search.bilibili.com/all?keyword=${e.data.name}`}t.querySelector(".recommended-target").setAttribute("href",o)}else{console.error("[自定义顶栏] 获取搜索推荐词失败")}}const a=new Vue({el:dq(".popup.search-list"),data:{items:[],isHistory:true,showCopyTip:false},methods:{closeCopyTip:_.debounce((function(){this.showCopyTip=false}),2e3),copy(e){GM.setClipboard(e,"text");this.showCopyTip=true;this.closeCopyTip()},submit(e){if(d(e).success){this.copy(e)}else{i.value=e;if(t.requestSubmit){t.requestSubmit()}else{t.submit()}}},nextItem(e){const t=dq(`.custom-navbar .search-list-item:nth-child(${e+2})`);if(t){t.focus()}},previousItem(e){const t=dq(`.custom-navbar .search-list-item:nth-child(${e})`);if(t){t.focus()}else{i.focus();return}},deleteItem(e,t){if(i.value!==""){i.value=""}s(e.value);this.items.splice(t,1)},clearSearchHistory(){l();this.items=[]}}});let m="";const b=async()=>{const e=i.value;a.isHistory=e==="";const t=d(e);if(a.isHistory){a.items=n().sort(((e,t)=>t.timestamp-e.timestamp)).map((e=>({value:e.value,html:e.value}))).slice(0,r)}else if(t.success){a.items=[];const e=t.aid?`https://api.bilibili.com/x/web-interface/view?aid=${t.aid}`:`https://api.bilibili.com/x/web-interface/view?bvid=${t.bvid}`;const i=await Ajax.getJson(e);if(t.aid){const e=_.get(i,"data.bvid",null);if(e!==null){a.items=[{value:e,html:`复制BV号: ${e}`}]}}else if(t.bvid){const e=_.get(i,"data.aid",null);if(e!==null){a.items=[{value:"av"+e,html:`复制AV号: av${e}`}]}}}else{const t=`https://s.search.bilibili.com/main/suggest?func=suggest&suggest_type=accurate&sub_type=tag&main_ver=v1&highlight=&userid=${getUID()}&bangumi_acc_num=1&special_acc_num=1&topic_acc_num=1&upuser_acc_num=3&tag_num=10&special_num=10&bangumi_num=10&upuser_num=3&term=${e}`;m=t;const i=await Ajax.getJson(t);if(i.code!==0||m!==t){return}const o=i.result.tag;if(o===undefined){a.items=[];return}a.items=o.map((e=>({value:e.value,html:e.name.replace(/suggest_high_light/g,"suggest-highlight")})))}};b();const u=_.debounce(b,200);let h=false;i.addEventListener("compositionstart",(()=>h=true));i.addEventListener("compositionend",(()=>{h=false;raiseEvent(i,"input")}));i.addEventListener("input",(()=>{if(!h){u()}}));i.addEventListener("keydown",(e=>{if(e.isComposing){return}if(e.key==="ArrowDown"&&a.items.length>0){e.preventDefault();e.stopImmediatePropagation();dq(".custom-navbar .search-list-item:first-child").focus()}}))}get name(){return"search"}}return{export:{SearchBox:m}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-settings.min.js"]=(()=>(e,t)=>{const i=async()=>{await SpinQuery.select(".custom-navbar-settings");const{Slip:i}=await t.importAsync("slip");const o=dq("#custom-navbar-settings");o.addEventListener("click",(async()=>{const e=dq(".custom-navbar-settings");if(e){e.classList.toggle("show");dq(".gui-settings-mask").click()}}));o.addEventListener("mouseover",(()=>{const t={blank1:"弹性空白1",logo:"Logo",category:"主站",rankingLink:"排行",drawingLink:"相簿",bangumiLink:"番剧",musicLink:"音频",gamesIframe:"游戏中心",livesIframe:"直播",matchLink:"赛事",shopLink:"会员购",mangaIframe:"漫画",blank2:"弹性空白2",search:"搜索框",userInfo:"用户信息",messages:"消息",activities:"动态",bangumi:"订阅",watchlaterList:"稍后再看",favoritesList:"收藏",historyList:"历史",upload:"投稿入口",blank3:"弹性空白3",darkMode:"夜间模式开关"};Vue.component("order-item",{props:["item"],template:`\n<li @mouseenter="viewBorder(true)"\n            @mouseleave="viewBorder(false)"\n            :class="{hidden: hidden()}">\n<i class="mdi mdi-menu"></i>\n          {{item.displayName}}\n<button @click="toggleHidden()">\n<i v-if="hidden()" class="mdi mdi-eye-off"></i>\n<i v-else class="mdi mdi-eye"></i>\n</button>\n</li>\n`,methods:{hidden(){return e.customNavbarHidden.includes(this.item.name)},viewBorder(e){const t=dq(`.custom-navbar li[data-name='${this.item.name}']`);if(t!==null){t.classList.toggle("view-border",e)}},toggleHidden(){const t=this.hidden();if(t===false){e.customNavbarHidden.push(this.item.name)}else{const t=e.customNavbarHidden.indexOf(this.item.name);if(t===-1){return}e.customNavbarHidden.splice(t,1)}this.$forceUpdate();const i=dq(`.custom-navbar li[data-name='${this.item.name}']`);if(i!==null){i.style.display=t?"flex":"none"}e.customNavbarHidden=e.customNavbarHidden}}});const o=_.debounce((t=>{document.documentElement.style.setProperty("--navbar-bounds-padding",`0 ${t}%`);e.customNavbarBoundsPadding=t}),200);new Vue({el:".custom-navbar-settings",mounted(){const t=dq(".custom-navbar-settings .order-list");const o=({sourceItem:i,targetItem:o,orderBefore:a,orderAfter:r})=>{if(a===r){return}const n=Object.entries(e.customNavbarOrder).filter((([e])=>e in customNavbarDefaultOrders));const l=n.sort(((e,t)=>e[1]-t[1])).map((e=>e[0]));if(a<r){for(let t=a+1;t<=r;t++){const i=l[t];e.customNavbarOrder[i]=t-1;const o=dq(`.custom-navbar li[data-name='${i}']`);o.style.order=(t-1).toString()}}else{for(let t=a-1;t>=r;t--){const i=l[t];e.customNavbarOrder[i]=t+1;const o=dq(`.custom-navbar li[data-name='${i}']`);o.style.order=(t+1).toString()}}e.customNavbarOrder[l[a]]=r;const c=dq(`.custom-navbar li[data-name='${l[a]}']`);c.style.order=r.toString();t.insertBefore(i,o);e.customNavbarOrder=e.customNavbarOrder};new i(t);t.addEventListener("slip:beforewait",(e=>{if(e.target.classList.contains("mdi-menu")){e.preventDefault()}}),false);t.addEventListener("slip:beforeswipe",(e=>e.preventDefault()),false);t.addEventListener("slip:reorder",(e=>{o({sourceItem:e.target,targetItem:e.detail.insertBefore,orderBefore:e.detail.originalIndex,orderAfter:e.detail.spliceIndex});return false}),false)},computed:{orderList(){const i=Object.entries(e.customNavbarOrder);return i.filter((e=>e[0]in t)).sort(((e,t)=>e[1]-t[1])).map((e=>({displayName:t[e[0]],name:e[0],order:e[1]})))}},data:{boundsPadding:e.customNavbarBoundsPadding},watch:{boundsPadding(e){o(e)}},methods:{close(){dq(".custom-navbar-settings").classList.remove("show")},restoreDefault(){if(typeof customNavbarDefaultOrders==="undefined"){Toast.error("未找到默认值设定, 请更新您的脚本.","自定义顶栏",3e3);return}if(confirm("确定要恢复默认顶栏布局吗? 恢复后页面将刷新.")){this.boundsPadding=5;e.customNavbarOrder=customNavbarDefaultOrders;location.reload()}}}})}),{once:true})};return{export:{initSettingsPanel:i}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-simple-link.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(e,t,i){super();this.linkName=i;this.html=e;this.href=t;this.touch=false;this.active=document.URL.startsWith(t)}get name(){return this.linkName+"Link"}}return{export:{SimpleLink:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-subscriptions.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(){super();this.boundingWidth=380;this.noPadding=true;const e=getUID();this.href=`https://space.bilibili.com/${e}/bangumi`;this.html="订阅";this.active=[`https://space.bilibili.com/${e}/bangumi`,`https://space.bilibili.com/${e}/cinema`,`https://space.bilibili.com/${e}/subs`].includes(document.URL.replace(/\?.*$/,""));this.popupHtml=`\n<div class="subscriptions">\n<ul class="subscriptions-tabs">\n<li class="tab" :class="{selected: bangumi}" @click="bangumi = true">追番</li>\n<li class="tab" :class="{selected: !bangumi}" @click="bangumi = false">追剧</li>\n<div class="tab-placeholder"></div>\n<a class="view-all" target="_blank" :href="'https://space.bilibili.com/${e}/' + (bangumi ? 'bangumi' : 'cinema')">\n          查看更多\n<i class="mdi mdi-dots-horizontal"></i>\n</a>\n</ul>\n<div class="content">\n<transition name="subscriptions-content" mode="out-in">\n<bangumi-subscriptions v-if="bangumi" type="bangumi" :key="'bangumi'"></bangumi-subscriptions>\n<bangumi-subscriptions v-else type="cinema" :key="'cinema'"></bangumi-subscriptions>\n</transition>\n</div>\n</div>`;this.initialPopup=()=>{this.init()}}async init(){new Vue({el:await SpinQuery.select(".custom-navbar .subscriptions"),data:{bangumi:true},components:{"bangumi-subscriptions":{props:["type"],components:{"dpi-img":()=>t.importAsync("dpi-img.vue")},template:`\n<div class="bangumi-subscriptions" :class="{center: loading || !loading && cards.length === 0}">\n<div v-if="loading" class="loading">\n<i class="mdi mdi-18px mdi-loading mdi-spin"></i>\n                加载中...\n</div>\n<div v-if="!loading && cards.length === 0" class="empty">空空如也哦 =￣ω￣=</div>\n<a v-if="!loading" v-for="card of cards" :key="card.id" :href="card.playUrl" target="_blank" class="bangumi-subscriptions-card">\n<dpi-img class="cover" :src="card.coverUrl" :size="{height: 64}"></dpi-img>\n<div class="card-info">\n<h1 class="title" :title="card.title">{{card.title}}</h1>\n<div class="progress-row">\n<div v-if="card.status" class="status" :class="'status-' + card.status">\n                      {{card.statusText}}\n</div>\n<div v-if="card.progress" class="progress" :title="card.progress + ' | ' + card.latest">{{card.progress}} | {{card.latest}}</div>\n<div v-else class="progress" :title="card.latest">{{card.latest}}</div>\n<a class="info" :href="card.mediaUrl" target="_blank" title="详细信息">\n<i class="mdi mdi-information-outline"></i>\n</a>\n</div>\n</div>\n</a>\n</div>\n`,data(){return{loading:true,cards:[]}},async mounted(){try{const e=await Ajax.getJsonWithCredentials(`https://api.bilibili.com/x/space/bangumi/follow/list?type=${this.type!=="bangumi"?"2":"1"}&pn=1&ps=16&vmid=${getUID()}`);if(e.code!==0){logError(`加载订阅信息失败: ${e.message}`);return}const t=e=>{switch(e){case 1:return"想看";case 2:default:return"在看";case 3:return"看过"}};this.cards=e.data.list.map((e=>({title:e.title,coverUrl:e.square_cover.replace("http:","https:"),latest:e.new_ep.index_show,progress:e.progress,id:e.season_id,status:e.follow_status,statusText:t(e.follow_status),playUrl:`https://www.bilibili.com/bangumi/play/ss${e.season_id}`,mediaUrl:`https://www.bilibili.com/bangumi/media/md${e.media_id}`}))).sort(((e,t)=>{let i=e.status;if(i!==3){i=3-i}let o=t.status;if(o!==3){o=3-o}return i-o}))}finally{this.loading=false}}}}})}get name(){return"bangumi"}}return{export:{Subscriptions:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-upload.min.js"]=(()=>(e,t)=>{const{NavbarComponent:i}=t.import("custom-navbar-component");class o extends i{constructor(){super();this.href="https://member.bilibili.com/v2#/upload/video/frame";this.html=`\n<svg style="width:16px;height:16px;padding:3px;box-sizing:content-box;" viewBox="0 0 785 886">\n<path d="M582,374L582,566C582,585.333 576.167,600.833 564.5,612.5C552.833,624.167 537.333,630 518,630L262,630C242.667,630 227.167,624.167 215.5,612.5C203.833,600.833 198,585.333 198,566L198,374L32,374C22,374 14.1667,371.167 8.5,365.5C2.83333,359.833 0,352 0,342C0,338.667 1.16666,334.5 3.5,329.5C5.83333,324.5 8.66666,320 12,316L371,9C377.667,3.00006 385.167,6.10352e-005 393.5,0C401.833,6.10352e-005 409.333,3.00006 416,9L774,316C780,322.667 783.333,330.167 784,338.5C784.667,346.833 783.333,354.333 780,361L764,370C760,372.667 754.667,374 748,374ZM70,758L710,758C729.333,758 744.833,763.833 756.5,775.5C768.167,787.167 774,802.667 774,822C774,841.333 768.167,856.833 756.5,868.5C744.833,880.167 729.333,886 710,886L70,886C50.6667,886 35.1667,880.167 23.5,868.5C11.8333,856.833 6,841.333 6,822C6,802.667 11.8333,787.167 23.5,775.5C35.1667,763.833 50.6667,758 70,758Z" />\n</svg>\n<div id="upload-button">投稿</div>`;this.popupHtml=`\n<ul id="upload-actions">\n<li><a target="_blank" href="https://member.bilibili.com/platform/upload/text/apply">专栏投稿</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/platform/upload/audio/">音频投稿</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/platform/upload/video/frame">视频投稿</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/platform/upload-manager/article">投稿管理</a></li>\n<li><a target="_blank" href="https://member.bilibili.com/platform/home">创作中心</a></li>\n</ul>\n`}get name(){return"upload"}}return{export:{Upload:o}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-user-info.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{NavbarComponent:o}=t.import("custom-navbar-component");class a extends o{constructor(){super();i(this,"userInfo",{mid:getUID(),isLogin:Boolean(getUID())});this.boundingWidth=240;this.noPadding=true;this.href="https://space.bilibili.com";this.html=`\n<div class="user-face-container">\n<img src='${EmptyImageUrl}' class="user-face"></img>\n<img src='${EmptyImageUrl}' class="user-pendant"></img>\n</div>\n`;this.popupHtml=`<div class="user-info-panel"></div>`;this.requestedPopup=true;this.init()}get name(){return"userInfo"}async init(){const e=await SpinQuery.select(".custom-navbar .user-info-panel");const t=await SpinQuery.select(".custom-navbar .user-face-container .user-face");const i=await Ajax.getJsonWithCredentials("https://api.bilibili.com/x/web-interface/nav");const o=await Ajax.getJsonWithCredentials("https://api.bilibili.com/x/web-interface/nav/stat");Object.assign(this.userInfo,i.data);Object.assign(this.userInfo,o.data);const a=new Vue({template:`\n<div class="user-info-panel">\n<div v-if="isLogin" class="logged-in">\n<a class="name" target="_blank" href="https://space.bilibili.com/">{{uname}}</a>\n<a class="type" target="_blank" href="https://account.bilibili.com/account/big">{{userType}}</a>\n<div class="privileges row" v-if="this.vipStatus === 1 && this.vipType === 2">\n<div class="b-coin" :class="{received: privileges.bCoin.received}" @click="privilegeReceive(1)" :title="'有效期限: ' + privileges.bCoin.expire">\n              {{privileges.bCoin.received ? '已领取B币' : '领取B币'}}\n</div>\n<div class="coupons" :class="{received: privileges.coupons.received}" @click="privilegeReceive(2)" :title="'有效期限: ' + privileges.coupons.expire">\n              {{privileges.coupons.received ? '已领取优惠券' : '领取优惠券'}}\n</div>\n</div>\n<div class="level-info row">\n<a target="_blank" title="等级" href="https://account.bilibili.com/account/record"\n              class="level">\n<i class="custom-navbar-iconfont-extended" :class="'custom-navbar-icon-lv' + level_info.current_level"></i>\n</a>\n<span class="level-progress-label">{{level_info.current_exp}} / {{level_info.next_exp}}</span>\n</div>\n<div class="level-progress separator">\n<div class="level-progress-thumb" :style="levelProgressStyle"></div>\n</div>\n<div class="items">\n<a class="item" target="_blank" title="手机验证"\n              href="https://passport.bilibili.com/account/security#/bindphone">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-bind-phone"></i>\n<i v-if="mobile_verified" class="custom-navbar-iconfont-new-home custom-navbar-icon-ok"></i>\n<i v-else class="custom-navbar-iconfont-new-home custom-navbar-icon-cancel"></i>\n</a>\n<a class="item" target="_blank" title="邮箱验证"\n              href="https://passport.bilibili.com/account/security#/bindmail">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-bind-email"></i>\n<i v-if="email_verified" class="custom-navbar-iconfont-new-home custom-navbar-icon-ok"></i>\n<i v-else class="custom-navbar-iconfont-new-home custom-navbar-icon-cancel"></i>\n</a>\n<a class="item" target="_blank" href="https://account.bilibili.com/site/coin" title="硬币">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-coin"></i>\n<span>{{money}}</span>\n</a>\n<a class="item" target="_blank" href="https://pay.bilibili.com/bb_balance.html" title="B币">\n<i class="custom-navbar-iconfont-new-home custom-navbar-icon-b-coin"></i>\n<span>{{wallet.bcoin_balance}}</span>\n</a>\n</div>\n<div class="separator"></div>\n<div class="stats">\n<a class="stats-item" :href="'https://space.bilibili.com/' + mid + '/fans/follow'" target="_blank">\n<div class="stats-number">{{following | count}}</div>\n              关注\n</a>\n<a class="stats-item" :href="'https://space.bilibili.com/' + mid + '/fans/fans'" target="_blank">\n<div class="stats-number">{{follower | count}}</div>\n              粉丝\n</a>\n<a class="stats-item" :href="'https://space.bilibili.com/' + mid + '/dynamic'" target="_blank">\n<div class="stats-number">{{dynamic_count | count}}</div>\n              动态\n</a>\n</div>\n<div class="separator"></div>\n<a class="operation" target="_blank" href="https://account.bilibili.com/account/home">\n<i class="icon custom-navbar-icon-profile custom-navbar-iconfont-new-home"></i>\n            个人中心\n</a>\n<a class="operation" target="_blank" href="https://member.bilibili.com/v2#/upload-manager/article">\n<i class="icon custom-navbar-icon-posts custom-navbar-iconfont-new-home"></i>\n            投稿管理\n</a>\n<a class="operation" target="_blank" href="https://pay.bilibili.com/">\n<i class="icon custom-navbar-icon-wallet custom-navbar-iconfont-new-home"></i>\n            B币钱包\n</a>\n<a class="operation" target="_blank" href="https://link.bilibili.com/p/center/index">\n<i class="icon custom-navbar-icon-live-center custom-navbar-iconfont-new-home"></i>\n            直播中心\n</a>\n<a class="operation" target="_blank" href="https://show.bilibili.com/orderlist">\n<i class="icon custom-navbar-icon-order-center custom-navbar-iconfont-new-home"></i>\n            订单中心\n</a>\n<a class="operation" target="_blank" href="https://www.bilibili.com/v/cheese/mine">\n<i class="icon custom-navbar-icon-course custom-navbar-iconfont-new-home"></i>\n            我的课程\n</a>\n<div class="logout grey-button" @click="logout()">\n            退出登录\n</div>\n</div>\n<div v-else class="not-logged-in">\n<h1 class="welcome">欢迎来到 bilibili</h1>\n<a href="https://passport.bilibili.com/register/phone.html" class="signup grey-button">注册</a>\n<a href="https://passport.bilibili.com/login" class="login theme-button">登录</a>\n</div>\n</div>\n`,data:{...this.userInfo,privileges:{bCoin:{received:false,expire:""},coupons:{received:false,expire:""}}},filters:{count(e){return formatCount(e)}},computed:{userType(){if(!this.isLogin){return"未登录"}if(this.level_info.current_level===0){return"注册会员"}if(this.vipStatus===1){if(this.vipType===1){return this.vip_theme_type?"小会员":"大会员"}else if(this.vipType===2){return this.vip_theme_type?"年度小会员":"年度大会员"}}return"正式会员"},levelProgressStyle(){const e=(this.level_info.current_exp-this.level_info.current_min)/(this.level_info.next_exp-this.level_info.current_min);return{transform:`scaleX(${e})`}}},methods:{async privilegeReceive(e){const t={1:"bCoin",2:"coupons"};if(this.privileges[t[e]].received){return}this.privileges[t[e]].received=true;const i=getCsrf();const o=await(await fetch("https://api.bilibili.com/x/vip/privilege/receive",{credentials:"include",headers:{"content-type":"application/x-www-form-urlencoded"},body:`type=${e}&csrf=${i}`,method:"POST"})).json();console.log(o);if(o.code===0){if(t[e]==="bCoin"){this.wallet.bcoin_balance+=5}}else if(o.code===69801){return}else{this.privileges[t[e]].received=false;logError(o.message)}},async logout(){const e=await Ajax.postTextWithCredentials("https://passport.bilibili.com/login/exit/v2",formData({biliCSRF:getCsrf()}));const t=_.get(JSON.parse(e),"data.redirectUrl","");if(t){window.location.assign(t)}}}});a.$mount(e);if(this.userInfo.isLogin){const e=this.userInfo.face.replace("http","https");const i="//static.hdslb.com/images/member/noface.gif";if(!e.includes(i)){const i=68;t.setAttribute("srcset",getDpiSourceSet(e,i))}else{t.setAttribute("src",i)}if(this.userInfo.pendant.image){const e=await SpinQuery.select(".custom-navbar .user-face-container .user-pendant");const t=this.userInfo.pendant.image.replace("http","https");const i=116;e.setAttribute("srcset",getDpiSourceSet(t,i,"png"))}if(this.userInfo.vipType===2){const e=await Ajax.getJsonWithCredentials("https://api.bilibili.com/x/vip/privilege/my");if(e.code===0){const t=e.data.list.find((e=>e.type===1));a.privileges.bCoin.received=t.state===1;a.privileges.bCoin.expire=new Date(t.expire_time*1e3).toLocaleDateString();const i=e.data.list.find((e=>e.type===2));a.privileges.coupons.received=i.state===1;a.privileges.coupons.expire=new Date(i.expire_time*1e3).toLocaleDateString()}}}else{t.setAttribute("src","https://static.hdslb.com/images/akari.jpg")}}}return{export:{UserInfo:a}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-video-list.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{NavbarComponent:o}=t.import("custom-navbar-component");class a extends o{constructor({mainUrl:e,name:t,apiUrl:o,listName:a,listMap:r}){super();i(this,"listName",void 0);this.href=e;this.listName=a;this.html=t;this.noPadding=true;this.requestedPopup=false;this.popupHtml=`\n<ol class="video-list ${a}">\n<li class="loading">加载中...</li>\n</ol>\n`;this.initialPopup=async()=>{if(!r){return}const i=await SpinQuery.select(`.video-list.${a}`);if(i===null){return}const n=await Ajax.getJsonWithCredentials(o);let l="";if(n.code!==0){logError(`加载${t}信息失败. 错误码: ${n.code} ${n.message}`)}else{l=r(n).join("")}i.insertAdjacentHTML("beforeend",l+`\n<li class="more"><a target="_blank" href="${e}">查看更多</a></li>\n`);i.classList.add("loaded")}}get name(){return this.listName+"List"}}class r extends a{constructor(){super({name:"收藏",mainUrl:`https://space.bilibili.com/${getUID()}/favlist`,apiUrl:"https://api.bilibili.com/medialist/gateway/coll/resource/recent",listName:"favorites",listMap:e=>{if(!e.data||e.data.length===0){return[`<li class="loading empty">空空如也哦 =￣ω￣=</li>`]}return e.data.map((e=>`\n<li>\n<a target="_blank" href="https://www.bilibili.com/video/av${e.id}">${e.title}</a>\n</li>`))}});this.active=document.URL.replace(/\?.*$/,"")===`https://space.bilibili.com/${getUID()}/favlist`}}class n extends a{constructor(){super({name:"历史",mainUrl:"https://www.bilibili.com/account/history",apiUrl:"https://api.bilibili.com/x/v2/history?pn=1&ps=6",listName:"history",listMap:e=>{if(!e.data||e.data.length===0){return[`<li class="loading empty">空空如也哦 =￣ω￣=</li>`]}return e.data.map((e=>{let t=[];let i="";const o=e.page?e.page.page:1;let a=e.progress>=0?e.progress/e.duration:1;if(isNaN(a)){a=0}if(o!==1){t.push(`p=${o}`);i+=`看到第${o}话`}if(e.progress>0&&e.progress<e.duration){t.push(`t=${e.progress}`);i+=` ${Math.floor(a*100)}%`}else if(e.progress===0){i+=` 刚开始看`}else{i+=" 100%"}return`\n<li class="history-item">\n<a target="_blank" href="https://www.bilibili.com/video/av${e.aid}?${t.join("&")}">\n<span class="title">${e.title}</span>\n<span class="description">${i}</span>\n<div class="progress background">\n<div class="progress foreground" style="--progress: ${a*100}%"></div>\n</div>\n</a>\n</li>`}))}});this.active=document.URL.replace(/\?.*$/,"")==="https://www.bilibili.com/account/history"}}return{export:{FavoritesList:r,HistoryList:n}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/custom-navbar-watchlater-list.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}const{NavbarComponent:o}=t.import("custom-navbar-component");class a extends o{constructor(){super();i(this,"vm",void 0);this.boundingWidth=380;this.noPadding=true;this.href="https://www.bilibili.com/watchlater/#/list";this.html="稍后再看";this.active=document.URL.startsWith("https://www.bilibili.com/watchlater/");this.popupHtml=`\n<div class="watchlater-list loading">\n<div class="loading-tip">\n          加载中...\n</div>\n<div class="empty-tip" v-if="filteredCards.length === 0">\n          空空如也哦 =￣ω￣=\n</div>\n<div class="header">\n          \x3c!--<div class="operations">\n<div v-if="!redirect" class="round-button" title="播放全部"><i class="mdi mdi-play-circle-outline"></i></div>\n<div class="round-button" title="移除已观看"><i class="mdi mdi-eye-check-outline"></i></div>\n<div class="round-button" title="清空全部"><i class="mdi mdi-trash-can-outline"></i></div>\n</div>--\x3e\n<div class="search">\n<input type="text" placeholder="搜索" v-model="search">\n</div>\n<a class="round-button" target="_blank" href="https://www.bilibili.com/medialist/play/watchlater" title="播放全部">\n<i class="mdi mdi-play"></i>\n</a>\n<a class="round-button" href="https://www.bilibili.com/watchlater/#/list" title="查看更多" target="_blank">\n<i class="mdi mdi-dots-horizontal"></i>\n</a>\n</div>\n<transition-group name="cards" tag="div" class="cards">\n<div class="watchlater-card" v-for="(card, index) of filteredCards" :key="card.aid">\n<a class="cover-container" target="_blank" :href="card.href">\n<dpi-img class="cover" :src="card.coverUrl" :size="{width: 130, height: 85}"></dpi-img>\n<div class="floating remove" title="移除" @click.prevent="remove(card.aid, index)"><i class="mdi mdi-close"></i></div>\n<div class="floating duration">{{card.durationText}}</div>\n<div class="floating viewed" v-if="card.complete">\n                已观看\n</div>\n</a>\n<a class="title" target="_blank" :href="card.href" :title="card.title">{{card.title}}</a>\n<a class="up" target="_blank" :href="'https://space.bilibili.com/' + card.upID" :title="card.upName">\n<dpi-img class="face" :src="card.upFaceUrl" :size="20"></dpi-img>\n<div class="name">{{card.upName}}</div>\n</a>\n</div>\n</transition-group>\n        \x3c!--<div class="undo round-button">\n<i class="mdi mdi-undo-variant"></i>\n          撤销\n</div>--\x3e\n</div>\n`;this.initialPopup=()=>{this.init()};this.onPopup=()=>{var e;(e=this.vm)===null||e===void 0?void 0:e.updateList()}}async init(){this.vm=new Vue({el:await SpinQuery.select(`.custom-navbar [data-name="${this.name}"] .watchlater-list`),store:store,components:{DpiImg:()=>t.importAsync("dpi-img.vue")},data:{cards:[],filteredCards:[],search:"",lastRemovedAid:0,redirect:e.watchLaterRedirect&&e.watchLaterRedirectNavbar},computed:{...Vuex.mapState(["watchlaterList"])},watch:{search(){this.updateFilteredCards()}},methods:{...Vuex.mapActions(["toggleWatchlater"]),async updateList(){const{getWatchlaterList:e}=await t.importAsync("watchlater-api");const i=await e(true);if(!i){this.cards=[];return}const o=e=>{if(this.redirect){return`https://www.bilibili.com/video/${e.bvid}`}return`https://www.bilibili.com/medialist/play/watchlater/${e.bvid}`};const a=i.map((e=>{const t=(()=>{if(e.pages===undefined){return o(e)}const t=e.pages.map((e=>e.cid));const i=e.cid===0?1:t.indexOf(e.cid)+1;return this.redirect?`${o(e)}?p=${i}`:o(e)})();const i=Math.round(1e3*e.progress/e.duration)/1e3;return{aid:e.aid,bvid:e.bvid,href:t,coverUrl:e.pic.replace("http:","https:"),durationText:formatDuration(e.duration),duration:e.duration,complete:e.progress<0||i>.95,title:e.title,upName:e.owner.name,upFaceUrl:e.owner.face.replace("http:","https:"),upID:e.owner.mid}}));this.cards=a;if(this.search){this.updateFilteredCards()}else{this.filteredCards=a}},async remove(e,t){this.cards.splice(t,1);await this.toggleWatchlater(e);this.lastRemovedAid=e},async undo(){const e=this.lastRemovedAid;if(e!==0){await this.toggleWatchlater(e)}},updateFilteredCards:_.debounce((function(){const e=this.search.toLowerCase();const t=this.$el.querySelector(".cards");t.scrollTo(0,0);this.filteredCards=this.cards.filter((t=>t.title.toLowerCase().includes(e)||t.upName.toLowerCase().includes(e)))}),100)},async mounted(){try{await this.updateList()}finally{this.$el.classList.remove("loading")}}})}get name(){return"watchlaterList"}}return{export:{WatchlaterList:a}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/danmaku-converter.min.js"]=(()=>(e,t)=>{function i(e,t,i){if(t in e){Object.defineProperty(e,t,{value:i,enumerable:true,configurable:true,writable:true})}else{e[t]=i}return e}class o{constructor({content:e,time:t,type:o,fontSize:a,color:r}){i(this,"content",void 0);i(this,"time",void 0);i(this,"startTime",void 0);i(this,"type",void 0);i(this,"fontSize",void 0);i(this,"color",void 0);this.content=e;this.time=t;this.startTime=parseFloat(t);this.type=parseInt(o);this.fontSize=parseFloat(a);this.color=parseInt(r)}}class a extends o{constructor({content:e,time:t,type:o,fontSize:a,color:r,timeStamp:n,pool:l,userHash:c,rowId:s}){super({content:e,time:t,type:o,fontSize:a,color:r});i(this,"timeStamp",void 0);i(this,"pool",void 0);i(this,"userHash",void 0);i(this,"rowId",void 0);i(this,"pDataArray",void 0);this.timeStamp=parseInt(n);this.pool=parseInt(l);this.userHash=c;this.rowId=parseInt(s);this.pDataArray=[t,o,a,r,n,l,c,s]}text(){const e=this.pDataArray.join(",");return`<d p="${e}">${this.content}</d>`}static parse(e){const t=e.getAttribute("p");const[i,o,r,n,l,c,s,p]=t.split(",");const d=e.innerHTML;return new a({content:d,time:i,type:o,fontSize:r,color:n,timeStamp:l,pool:c,userHash:s,rowId:p})}}class r{constructor(e){i(this,"xml",void 0);i(this,"danmakus",void 0);this.xml=e;const t=(new DOMParser).parseFromString(e,"application/xml").documentElement;this.danmakus=[...t.querySelectorAll("d[p]")].map((e=>a.parse(e)))}}let n;(function(e){e[e["Normal"]=1]="Normal";e[e["Normal2"]=2]="Normal2";e[e["Normal3"]=3]="Normal3";e[e["Bottom"]=4]="Bottom";e[e["Top"]=5]="Top";e[e["Reversed"]=6]="Reversed";e[e["Special"]=7]="Special";e[e["Special2"]=8]="Special2"})(n||(n={}));class l extends o{constructor({content:e,time:t,type:o,fontSize:a,color:r,typeTag:n,colorTag:l,endTime:c}){super({content:e,time:t,type:o,fontSize:a,color:r});i(this,"typeTag",void 0);i(this,"colorTag",void 0);i(this,"endTime",void 0);this.typeTag=n;this.colorTag=l;this.endTime=c}text(e){let t=e[this.fontSize];if(!t){t=e[25]}const i=t.match(/Style:(.*?),/)[1].trim();return`Dialogue: 0,${this.time},${this.endTime},${i},,0,0,0,,{${this.typeTag}${this.colorTag}}${this.content}`}}class c{constructor(e,t,o,a,r){i(this,"danmakus",void 0);i(this,"title",void 0);i(this,"fontStyles",void 0);i(this,"blockTypes",void 0);i(this,"resolution",void 0);this.danmakus=e;this.title=t;this.fontStyles=o;this.blockTypes=a;this.resolution=r}generateAss(){const e=`\n[Script Info]\n; Script generated by Bilibili Evolved Danmaku Converter\n; https://github.com/the1812/Bilibili-Evolved/\nTitle: ${this.title}\nScriptType: v4.00+\nPlayResX: ${this.resolution.x}\nPlayResY: ${this.resolution.y}\nTimer: 10.0000\nWrapStyle: 2\nScaledBorderAndShadow: no\n\n[V4+ Styles]\nFormat: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding\n${Object.values(this.fontStyles).join("\n")}\n\n[Events]\nFormat: Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text\n`.trim();return e+"\n"+this.danmakus.map((e=>e.text(this.fontStyles))).filter((e=>e!=="")).join("\n")}}class s{constructor(e,t,o,a){i(this,"horizontalStack",void 0);i(this,"horizontalTrack",void 0);i(this,"verticalStack",void 0);i(this,"verticalTrack",void 0);i(this,"resolution",void 0);i(this,"duration",void 0);i(this,"canvas",void 0);i(this,"context",void 0);i(this,"fontSizes",void 0);i(this,"bottomMarginPercent",void 0);i(this,"danmakuHeight",void 0);i(this,"trackHeight",void 0);i(this,"trackCount",void 0);this.horizontalStack=[];this.horizontalTrack=[];this.verticalStack=[];this.verticalTrack=[];this.resolution=t;this.duration=o;this.canvas=document.createElement("canvas");this.context=this.canvas.getContext("2d");this.fontSizes={30:`64px ${e}`,25:`52px ${e}`,18:`36px ${e}`,45:`90px ${e}`};this.bottomMarginPercent=a;this.generateTracks()}generateTracks(){const e=52;this.danmakuHeight=e;this.trackHeight=s.margin*2+e;this.trackCount=parseInt(fixed(this.resolution.y*(1-this.bottomMarginPercent)/this.trackHeight,0))}getTextSize(e){this.context.font=this.fontSizes[e.fontSize];const t=this.context.measureText(e.content);const i=t.width/2;return[i,this.danmakuHeight/2]}getTags(e,{targetTrack:t,initTrackNumber:i,nextTrackNumber:o,willOverlay:a,getTrackItem:r,getTag:n}){const[l,c]=this.getTextSize(e);const p=l*2;const d=this.duration(e)*p/(this.resolution.x+p)+s.nextDanmakuDelay;let m=i;let b=null;do{b=t.find((e=>a(e,m,p)));m+=o}while(b&&m<=this.trackCount&&m>=0);if(m>this.trackCount||m<0){return`\\pos(0,-999)`}m-=o;t.push(r(m,p,d));return n({trackNumber:m,x:l,y:c})}getHorizontalTags(e){return this.getTags(e,{targetTrack:this.horizontalTrack,initTrackNumber:0,nextTrackNumber:1,willOverlay:(t,i,o)=>{if(t.trackNumber!==i){return false}if(t.width<o){return this.duration(e)*this.resolution.x/(this.resolution.x+o)<=t.end-e.startTime}else{return t.visible>e.startTime}},getTrackItem:(t,i,o)=>({width:i,start:e.startTime,visible:e.startTime+o,end:e.startTime+this.duration(e),trackNumber:t}),getTag:({trackNumber:t,x:i,y:o})=>`\\move(${this.resolution.x+i},${t*this.trackHeight+s.margin+o},${-i},${t*this.trackHeight+s.margin+o},0,${this.duration(e)*1e3})`})}getVerticalTags(e){const t=s.danmakuType[e.type]==="top";return this.getTags(e,{targetTrack:this.verticalTrack,initTrackNumber:t?0:this.trackCount-1,nextTrackNumber:t?1:-1,willOverlay:(t,i)=>{if(t.trackNumber!==i){return false}return t.end>e.startTime},getTrackItem:t=>({start:e.startTime,end:e.startTime+this.duration(e),trackNumber:t}),getTag:({trackNumber:e,y:i})=>{if(t){return`\\pos(${this.resolution.x/2},${e*this.trackHeight+s.margin+i})`}else{return`\\pos(${this.resolution.x/2},${this.resolution.y-s.margin-i-(this.trackCount-1-e)*this.trackHeight})`}}})}push(e){let t="";let i=[];switch(s.danmakuType[e.type]){case"normal":case"reversed":{t=this.getHorizontalTags(e);i=this.horizontalStack;break}case"top":case"bottom":{t=this.getVerticalTags(e);i=this.verticalStack;break}case"special":default:{return{tags:`\\pos(0,-999)`}}}const o={tags:t};i.push(o);return o}}i(s,"danmakuType",{[n.Normal]:"normal",[n.Normal2]:"normal",[n.Normal3]:"normal",[n.Bottom]:"bottom",[n.Top]:"top",[n.Reversed]:"reversed",[n.Special]:"special",[n.Special2]:"special"});i(s,"margin",4);i(s,"nextDanmakuDelay",.05);class p{constructor({title:e,font:t,alpha:o,duration:a,blockTypes:r,blockFilter:n,resolution:l,bottomMarginPercent:c,bold:p}){i(this,"title",void 0);i(this,"font",void 0);i(this,"alpha",void 0);i(this,"duration",void 0);i(this,"blockTypes",void 0);i(this,"blockFilter",void 0);i(this,"resolution",void 0);i(this,"bold",void 0);i(this,"danmakuStack",void 0);this.title=e;this.font=t;this.alpha=Math.round(o*255).toString(16).toUpperCase().padStart(2,"0");this.duration=a;this.blockTypes=r;this.blockFilter=n||(()=>true);this.resolution=l;this.bold=p;this.danmakuStack=new s(t,l,a,c)}get fontStyles(){return{36:`Style: Larger,${this.font},72,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`,30:`Style: Large,${this.font},64,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`,25:`Style: Medium,${this.font},52,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`,18:`Style: Small,${this.font},36,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`,45:`Style: ExtraLarge,${this.font},90,&H${this.alpha}FFFFFF,&H${this.alpha}FFFFFF,&H${this.alpha}000000,&H${this.alpha}000000,${this.bold?"1":"0"},0,0,0,100,100,0,0,1,1.2,0,5,0,0,0,0`}}xmlDanmakuToAssDocument(e){const t=[];for(const i of e){if(this.blockTypes.indexOf(i.type)!==-1||this.blockTypes.indexOf("color")!==-1&&i.color!==p.white){continue}if(!this.blockFilter(i)){continue}const[e,o]=this.convertTime(i.startTime,this.duration(i));t.push(new l({content:this.convertText(i.content),time:e,endTime:o,type:i.type.valueOf().toString(),fontSize:i.fontSize.toString(),color:i.color.toString(),typeTag:this.convertType(i),colorTag:this.convertColor(i.color)}))}return new c(t,this.title,this.fontStyles,this.blockTypes,this.resolution)}xmlStringToAssDocument(e){const t=new r(e);return this.xmlDanmakuToAssDocument(t.danmakus.sort(((e,t)=>e.startTime-t.startTime)))}convertText(e){const t={"{":"｛","}":"｝","&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&apos;":"'"};for(const[i,o]of Object.entries(t)){e=e.replace(new RegExp(i,"g"),o)}return e}convertType(e){return this.danmakuStack.push(e).tags}convertColor(e){if(e===p.white){return""}const t=e.toString(16);const i=t.substring(0,2);const o=t.substring(2,4);const a=t.substring(4,6);return`\\c&H${a}${o}${i}&`}convertTime(e,t){function i(e){const[t,i="00"]=String(e).split(".");return`${t.padStart(2,"0")}.${i.substr(0,2).padEnd(2,"0")}`}function o(e){let t=0;let o=0;while(e>=60){e-=60;o++}while(o>=60){o-=60;t++}return`${t}:${String(o).padStart(2,"0")}:${i(e)}`}return[o(e),o(e+t)]}}i(p,"white",16777215);return{export:{AssDanmaku:l,AssDanmakuDocument:c,Danmaku:o,DanmakuConverter:p,DanmakuStack:s,DanmakuType:n,XmlDanmaku:a,XmlDanmakuDocument:r}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/danmaku-segment.min.js"]=(()=>(settings,resources)=>{const proto={nested:{DmWebViewReply:{fields:{state:{type:"int32",id:1},text:{type:"string",id:2},textSide:{type:"string",id:3},dmSge:{type:"DmSegConfig",id:4},flag:{type:"DanmakuFlagConfig",id:5},specialDms:{rule:"repeated",type:"string",id:6},checkBox:{type:"bool",id:7},count:{type:"int64",id:8},commandDms:{rule:"repeated",type:"CommandDm",id:9},dmSetting:{type:"DanmuWebPlayerConfig",id:10}}},CommandDm:{fields:{id:{type:"int64",id:1},oid:{type:"int64",id:2},mid:{type:"int64",id:3},command:{type:"string",id:4},content:{type:"string",id:5},progress:{type:"int32",id:6},ctime:{type:"string",id:7},mtime:{type:"string",id:8},extra:{type:"string",id:9},idStr:{type:"string",id:10}}},DmSegConfig:{fields:{pageSize:{type:"int64",id:1},total:{type:"int64",id:2}}},DanmakuFlagConfig:{fields:{recFlag:{type:"int32",id:1},recText:{type:"string",id:2},recSwitch:{type:"int32",id:3}}},DmSegMobileReply:{fields:{elems:{rule:"repeated",type:"DanmakuElem",id:1}}},DanmakuElem:{fields:{id:{type:"int64",id:1},progress:{type:"int32",id:2},mode:{type:"int32",id:3},fontsize:{type:"int32",id:4},color:{type:"uint32",id:5},midHash:{type:"string",id:6},content:{type:"string",id:7},ctime:{type:"int64",id:8},weight:{type:"int32",id:9},action:{type:"string",id:10},pool:{type:"int32",id:11},idStr:{type:"string",id:12},attr:{type:"int32",id:13}}},DanmuWebPlayerConfig:{fields:{dmSwitch:{type:"bool",id:1},aiSwitch:{type:"bool",id:2},aiLevel:{type:"int32",id:3},blocktop:{type:"bool",id:4},blockscroll:{type:"bool",id:5},blockbottom:{type:"bool",id:6},blockcolor:{type:"bool",id:7},blockspecial:{type:"bool",id:8},preventshade:{type:"bool",id:9},dmask:{type:"bool",id:10},opacity:{type:"float",id:11},dmarea:{type:"int32",id:12},speedplus:{type:"float",id:13},fontsize:{type:"float",id:14},screensync:{type:"bool",id:15},speedsync:{type:"bool",id:16},fontfamily:{type:"string",id:17},bold:{type:"bool",id:18},fontborder:{type:"int32",id:19},drawType:{type:"string",id:20}}}}};const decode=_.curry((async(type,blob,toastTitle="")=>{const buffer=new Uint8Array("arrayBuffer"in Blob.prototype?await blob.arrayBuffer():await new Response(blob).arrayBuffer());if(!window.protobufPromise){window.protobufPromise=new Promise((async(resolve,reject)=>{const library=await Ajax.monkey({url:"https://cdn.jsdelivr.net/npm/protobufjs@6.10.1/dist/light/protobuf.min.js",method:"GET"}).catch((e=>logError(e)));if(!library){const e="加载依赖库失败, 请稍后重试.";Toast.error(e,toastTitle||"错误");reject(e)}eval(library);resolve(window.protobuf)}))}const protobuf=await window.protobufPromise;const root=protobuf.Root.fromJSON(proto);const reply=root.lookupType(type);const message=reply.decode(buffer);return reply.toObject(message)}));const decodeDanmakuSegment=decode("DmSegMobileReply");const decodeDanmakuView=decode("DmWebViewReply");return{export:{proto:proto,decodeDanmakuSegment:decodeDanmakuSegment,decodeDanmakuView:decodeDanmakuView,test:async e=>{const t=`https://api.bilibili.com/x/v2/dm/web/seg.so?type=1&oid=157340456&pid=92150659&segment_index=${e}`;const i=await Ajax.getBlob(t);const o=await decodeDanmakuSegment(i);console.log(o);unsafeWindow.testResult=o},testView:async()=>{const e=`https://api.bilibili.com/x/v2/dm/web/view?type=1&oid=157340456`;const t=await Ajax.getBlob(e);const i=await decodeDanmakuView(t);console.log(i);unsafeWindow.testResult=i}}}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/danmaku-send-bar.min.css"]=`.live-web-player-controller .danmaku-send-bar{display:none}.live-web-player-controller{background-image:linear-gradient(to bottom,transparent 20%,rgba(0,0,0,.9))}@media screen and (min-width:1038px){.player-full-win:not(.danmaku-send-bar-unloaded) .live-web-player-controller .control-area .danmaku-send-bar{display:flex;margin:0 24px;flex:1 1 0;height:24px;justify-content:center;align-items:center}.player-full-win:not(.danmaku-send-bar-unloaded) .live-web-player-controller .control-area .danmaku-send-bar input{outline:0!important;border:none;border-bottom:2px solid #fff8;background-color:transparent;color:#fff;padding:4px;line-height:normal;flex:1;width:0;max-width:400px;min-width:70px}.player-full-win:not(.danmaku-send-bar-unloaded) .live-web-player-controller .control-area .danmaku-send-bar input:focus-within{border-color:var(--theme-color)}.player-full-win:not(.danmaku-send-bar-unloaded) .live-web-player-controller .control-area .danmaku-send-bar input::-webkit-input-placeholder{color:#fff8!important}.player-full-win:not(.danmaku-send-bar-unloaded) .live-web-player-controller .control-area .right-area{flex:0 0 auto!important}}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/danmaku-send-bar.min.js"]=(()=>(e,t)=>{(async()=>{const{waitForControlBar:e}=await t.importAsync("live-control-bar");let i=false;let o;const a="danmaku-send-bar";e({init:()=>{t.applyStyle("danmakuSendBarStyle")},callback:async e=>{const t=dq(e,".left-area");const r=await SpinQuery.select(".control-panel-ctnr .chat-input-ctnr .chat-input");const n=await SpinQuery.select(".control-panel-ctnr .chat-input-ctnr ~ .bottom-actions .bl-button--primary");if([t,r,n].some((e=>e===null))){console.warn("[danmakuSendBar] ref elements not found",t===null,r===null,n===null);return}if(dq(e,`.${a}`)){return}if(!o){const e=Vue.extend({template:`\n<div class="${a}">\n<input\n              type="text"\n              placeholder="发个弹幕呗~"\n              :value="value"\n              @keydown.enter="send()"\n              @input="updateValue($event.target.value)"\n              maxlength="30"\n            />\n</div>\n`,data(){return{value:r.value}},mounted(){r.addEventListener("input",this.listenChange);r.addEventListener("change",this.listenChange);if(!i){const e=Object.getOwnPropertyDescriptors(HTMLTextAreaElement.prototype).value;Object.defineProperty(r,"value",{...e,set(t){e.set.call(this,t);raiseEvent(r,"input")}});i=true}},beforeDestroy(){r.removeEventListener("input",this.listenChange);r.removeEventListener("change",this.listenChange)},methods:{updateValue(e){r.value=e;raiseEvent(r,"input")},send(){if(!n.disabled){this.value="";n.click()}},listenChange(e){this.value=e.target.value}}});o=(new e).$mount().$el}t.insertAdjacentElement("afterend",o)}})})();return{reload:()=>document.body.classList.remove("danmaku-send-bar-unloaded"),unload:()=>document.body.classList.add("danmaku-send-bar-unloaded")}})();offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dark.min.css"]=`#app .header,#app .submit,#id-card,#page-fav .fav-sidenav .fav-item:hover,#page-fav .fav-sidenav .icon-cursor,#page-setting #setting-new-tag,#page-setting .setting-tag-list a,#page-video #submit-video-type-filter,#pin-wrapper #pin-layer,#sections-vm .section-block,.action-menu .menu-list,.action-menu .menu-list:before,.activity-item-ctnr .user-avatar,.activity-item-loading-ctnr .info-ctnr .first-line,.activity-item-loading-ctnr .info-ctnr .second-line,.activity-item-loading-ctnr .user-avatar,.advanced-danmaku-group .adv-danmaku-btn-span,.advanced-danmaku-group .adv-danmaku-btn-span.bpui-button-type-small,.app-watch,.appeal-box,.article-container,.attention-btn-ctnr .right-part,.audio-info-module,.audio-list .song-list .song-li .content .text,.audiolist-list .song-list .song-li .content .text,.awarding-panel,.b-line>p>span,.backdrop .title-box,.backdrop iframe,.ban-app,.bangumi-container,.bangumi-info-module,.base-bubble,.base-bubble .content-ctnr:before,.bb-comment .nameplate .nameplate-card,.be-dropdown-menu,.be-pager-item,.be-pager-next,.be-pager-options-elevator input[type=text],.be-pager-prev,.bili-footer,.bilibili-live-player-loading-panel,.bilibili-player-block-line,.bilibili-player-block-string-short,.bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.bilibili-player-border,.bilibili-player-color-picker-color-code,.bilibili-player-color-picker-container,.bilibili-player-danmaku-date-picker-container,.bilibili-player-modal-container,.bilibili-player-mode-selection-container,.bilibili-player-video-btn-setting-panel,.bilibili-player-video-danmaku-setting-box,.bilibili-player-video-danmaku-setting-left,.bilibili-player-video-danmaku-setting-right,.bilibili-player-video-inputbar,.bilibili-player-video-panel,.bilibili-player-video-progress-detail-time,.bilibili-player-video-volumebar-wrp,.bl-button--ghost,.bottom .content,.bpm-btn,.bpui-selectmenu-list,.bpui-selectmenu-list-row[data-selected],.bui-input-input,.bui-input-wrap-disabled,.bui-select .bui-select-border,.bui-select-list,.calendar-checkin .checkin-btn:active,.card .focus-btn .focus,.card .focus-btn .unfocus,.card .more-panel,.card .more-panel:after,.chat-history-panel .chat-history-list .chat-item.system-msg,.choice-item,.choice-item.active,.choice-item:hover,.coin-operated-m,.collection-m,.comment-bilibili-con,.comment-wrap,.common-popup-wrap,.contribution-sidenav .contribution-item:hover,.count-choice,.deleted,.download-panel-ctnr .download-item:hover,.dynamic-btn.pink.disabled,.dynamic-link-hover-bg:hover,.dynamic-m,.emoji,.emoji-box,.emoji-box:after,.emoji-tabs,.emotion-box,.emotion-box:after,.error-wrap,.fans-action-btn,.fans-action-follow,.fans-medal-item:not(.medal-guard) .fans-medal-level,.fixed-top,.fixed-top .search-block .input-wrap,.follow-dialog-window,.follow-sidenav .follow-list-container .follow-item:hover,.footer-wrp,.g-search input,.gift-item.buy.hover,.gift-presets .gift-panel-switch,.gift-sender-panel,.guard-rank-cntr .rank-cntr .btn-box .buy:hover,.gui-settings-box,.h5share-container .text-area,.history-list .r-info,.history-tag,.home-wrap .home-input .list li:hover,.home-wrap .home-suggest .hotlist .num,.hover-panel,.imagesbox .boost-control,.imagesbox .boost-img,.img-content,.info-model,.link-footer,.link-input,.list-create,.live-container,.live-player-ctnr.minimal,.modal-wrapper,.mode .selection-span,.multi-page .cur-list li.on,.multi-page .cur-list li.on:hover,.multi-page .more-box,.music-container .image-area .share-img,.music-container .text-area,.my-album .tab-list,.not-support,.page-jump>input,.page-wrap .pager,.pagination,.predefined-colors,.radio-icon.selected,.rank.rank-10,.rank.rank-4,.rank.rank-5,.rank.rank-6,.rank.rank-7,.rank.rank-8,.rank.rank-9,.repost,.result,.result .row,.right-side-bar .to-comment .comment-num,.select-wrap .select-option,.select-wrap .select-txt,.small-item .cover,.space-right,.sticky-bar,.sub-nav,.suggest-wrap .horizontal .hz-text,.suggest-wrap .vt-text.focus,.suggest-wrap .vt-text:hover,.tab-contain,.tag-info-pane,.textarea-container .comm-tool .comm-emoji,.user-card,.user-card-m,.user-item-loading .avatar,.user-item-loading .username,.user-level-detail .detail-link:active,.user-level-detail .detail-link:hover,.user-panel .level-progress,.user-panel .logout-btn:active,.userinfo-content,.video-container,.video-info-module,.video-model,.video-toolbar .share .share-pos .share-address ul li input,.vote-container .image-area .share-img,.vote-container.pointer,.vote-user-face,.voted-result,.watch-later-list header .d-btn,.wrapper .content,.wrapper .modal-body .choice-wrp .battery,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,div.bilibili-player-auxiliary-area,div.box,div.bubble-traditional,div.con,div.danmaku-wrap,div.dd-bubble,div.desc-tips,div.dyn_list_wrapper,div.i-frame,div.im-list-box,div.live-box,div.member-bottom,div.stardust-player,div.ver span.tips,form.ipt,p.num,span.date,textarea,ul.bilibili-suggest,ul.dyn_list,ul.up-nav,ul.up-nav li{background-color:#222!important}#app .submit .cancel,#page-channel-index .channel-option.no-channel,#page-dynamic .col-2 .section,#page-fav .fav-main .search-input input,#page-follows .follow-main .follow-action-bottom .follow-action-fixtop,#page-index .album .content .album-wrapper .album-item .album-top,#page-index .col-1,#page-index .col-2 .section,#page-setting .setting-index-module,#pin-wrapper #pin-layer-search,.activity-pushing-out,.add-btn,.app-look,.area-list-panel,.article-list-holder-block .article-list-plane,.back-top.icon,.ban-detail .content-box .info-wrap,.ban-detail .content-box .major-content,.ban-detail .content-box .vote-cnt,.ban-modal,.ban-modal-h5,.bb-comment .comment-list .quote,.be-dropdown-item:hover,.be-input_inner,.bg-white,.bili-dropdown,.bili-header-m .mini-wnd-nav .list li:hover,.bili-header-m .profile-m .grade .bar,.bilibili-live-player-ending-panel-recommend-card-pic,.bilibili-player-adv-danmaku,.bilibili-player-block-line:hover,.bilibili-player-context-menu-container,.bilibili-player-danmaku-btn-danmaku,.bilibili-player-danmaku-btn-date,.bilibili-player-danmaku-btn-history,.bilibili-player-danmaku-btn-time,.bilibili-player-danmaku-function,.bilibili-player-danmaku-wrap,.bilibili-player-filter-wrap.bilibili-player-block,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-setting-menu-list,.bilibili-player-setting-menu-wrap,.bilibili-player-video-progress-buffer,.bl-switch,.bp-popup-panel,.bpui-button.bpui-button-type-small,.bpui-selectmenu-list-row:hover,.bpui-slider-tracker,.btn-box .like,.btn-box .liked,.btn-box .message,.btn-cancel,.btn.default,.btn.followed .b-gz,.btn.ghost,.bui-button.bui-button-transparent,.bui-radio .bui-radio-button .bui-radio-label,.c-clink,.calendar-checkin,.calendar-checkin .calendar-wrapper,.calendar-checkin .checkin-btn,.calendar-checkin .checkin-rewards,.calendar-checkin .checkin-rewards .query,.calendar-checkin .content-ctnr.ie-fix,.calendar-checkin .title,.calendar-checkin:hover,.card,.card .box,.checkbox,.col-full,.collection-m .bottom .btn.disable,.comment-area,.comment-area .comm-main .comm-list .hot-line>span,.comment-area .comm-more a.more:hover,.content-box .watermark-wrap .watermark,.download-panel-ctnr,.dropdown-list,.dyn_list li .preview,.elec .elec-status,.ema-wishing,.emoji-box .emoji-item:hover,.emoji-cover.selected,.emoji-text:hover,.emoji:hover,.emotion-item:hover .img,.fans-info .fans-progress,.feed-card .empty-content,.feed-tag .publish-panel-container,.fjw-point,.float-nav .nav-menu .item,.follow-btn,.fontsize .selection-span,.forw-area,.gift-presets .gift-panel-box,.go-top .tag-panel .more-button .more:hover,.go-top-m .go-top,.history-btn>.btn,.home-wrap .home-input .content,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-input .type.selected,.home-wrap .home-input .type:hover,.home-wrap .home-suggest .history,.home-wrap .home-suggest .hot-search,.left-container .gift-control-section,.left-container .head-info-section,.link-more,.link-panel-ctnr,.live-panel,.load-error-panel,.load-more-btn,.mCSB_draggerRail,.message-list,.more-link,.more-ops-list,.multi-page,.n .n-inner,.nav-list,.notice-item,.notice-panel,.num-tip,.opera-list,.page-controller .next:hover,.page-controller .prev:hover,.pager .pages .page-item button,.paginator .paging-box .result,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.percentage-bar,.photo-list .photo,.player-and-aside-area .aside-area,.player-and-aside-area .aside-area .rank-list-section,.process-bar,.ps.ps--in-scrolling.ps--x>.ps__scrollbar-x-rail,.ps.ps--in-scrolling.ps--y>.ps__scrollbar-y-rail,.ps:hover.ps--in-scrolling.ps--x>.ps__scrollbar-x-rail,.ps:hover.ps--in-scrolling.ps--y>.ps__scrollbar-y-rail,.ps:hover>.ps__scrollbar-x-rail:hover,.ps:hover>.ps__scrollbar-y-rail:hover,.publish-panel,.radio-icon,.rank-cntr .item.own,.rank-item>.ri-num,.rank-list-ctnr .own,.rank-list-ctnr .tabs,.read-push,.recommend-list .rec-footer,.right-side-bar .to-comment,.right-side-bar .to-top,.room-info-ctnr .content-wrapper,.s-space .wrapper .content,.score-progress-bar,.search-wrap .search-block .input-wrap,.search-wrap .search-block .input-wrap input,.section-block,.select-wrap .select-option p:hover,.selector,.selector .data-list,.selector .data-list>li:hover,.send-box,.slim-video-card .video-info,.sortable,.space-left,.space-right .space-right-top .title,.sub-nav li:hover,.suggest-wrap,.suggest-wrap .title span,.synthetical .play-btn,.tab-bar,.tab-link.on,.tag-info-pane .tag-header .btn-subscribe,.tag-info-pane .tag-header .btn-unsubscribe,.tag-panel,.totally-empty-hint,.up-article-list-block .more-article,.up-info .btn .b-cd,.up-info-holder .fixed-box .rightside-article-list-btn,.user-level-detail,.user-list .up-item .attention-btn.followed,.user-list .up-item .attention-btn.followed:hover,.user-panel,.user-panel .logout-btn,.user-panel-ctnr .user-panel .lens-ctnr,.video-page-card .card-box .info .pre-mask,.video-page-card .card-box .pic-box,.video-page-operator-card .card-box .pic-box,.video-toolbar .share .share-pos,.video.list .type,.video.matrix,.what-ban .text-con,.wrapper .elec-btn.disabled,.wrapper .modal-header .u-info,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,a.im-list:hover,a.more,a.more.tc-slate:hover,a.read-more,a.s-btn,button.submit-button.disabled,div.drag-bar,li.d-data:hover,li.suggest-item.focus,li.suggest-item:hover,li.tag,p.update>span>a,ul.up-nav li:hover{background-color:#444!important}.article-list-holder-block .article-list-plane .button:hover,.be-switch,.bilibili-player-filter,.bpui-selecting,.bpui-unselecting,.brief a:hover,.btn-box .message:hover,.btn-cancel:hover,.btn.default:hover,.bui-collapse-header,.bui-select .bui-select-item:hover,.bui-switch .bui-body,.context-menu-a:hover,.danmaku-info-block-btn,.danmaku-info-report-btn,.live-lr .banner a:hover,.multi-page .cur-list li:hover,div.all>a:hover,div.brief>a:hover,li.context-menu-descipline a{background-color:#555!important}.bui-step-dot,.ps>.ps__scrollbar-x-rail>.ps__scrollbar-x,.ps>.ps__scrollbar-y-rail>.ps__scrollbar-y{background-color:#aaa!important}.bpui-slider-handle{background-color:#eee!important}#app,.bilibili-player-video-inputbar,.large-item .cover,.wrapper .modal-header,body{background-image:none!important}.bilibili-player-advanced-danmaku-control-container.mask:after,.bilibili-player-color-picker-mask,.elevator-module .nav-bg{background-color:#222e!important}#app,.article-holder .cover-default,.article-holder img,.back-top,.bb-comment,.bb-comment .comment-list .list-item .info .operation,.divider,.fans-medal-item .level,.fjw-point .line,.list-item .close .close-icon,.my-info .info-modal .integral li .num,.right-part .user-panel,.shortcut-item .list-item:hover,.side-bar-cntr,.wrapper.clearfix .content,font>span{background-color:transparent!important}.bilibili-player-video-sendbar .bilibili-player-video-inputbar{background:#fff1!important}.gui-settings-content-top-mask{background:linear-gradient(to bottom,#222,transparent)}.gui-settings-content-bottom-mask{background:linear-gradient(to top,#222,transparent)}.room-bg::after,.user-panel .level-progress .progress-bar{background:0 0!important}#id-card .idc-auth-description,#page-fav .fav-main .fav-meta,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item i,#page-fav .fav-sidenav .nav-title .text,#page-index .channel .empty-state p,#page-index .col-2 .section .user-auth.no-auth .no-auth-title span,#page-index .section.empty:after,.anonymous,.area-link,.article-action .coin-btn .info-block span,.article-action .fav-btn .info-block span,.article-action .like-btn .info-block span,.article-action .share-btn .info-block span,.article-con,.article-list-holder-block .article-list-plane .button .title,.article-list-holder-block .article-list-plane .button.off .label,.article-wrap .article .desc,.attention-btn-ctnr .right-part,.ban-detail .content-box .bk-user-info .time,.ban-detail .content-box .link-box,.bangumi-rank-list .rank-item .ri-total,.bb-comment .comment-list .list-item .info .plad a,.bb-comment .nameplate .nameplate-card .nameplate-text .n-type,.be-pager-item a,.be-pager-item-jump-next,.be-pager-item-jump-prev,.be-pager-next,.be-pager-next a,.be-pager-options-elevator,.be-pager-prev,.be-pager-prev a,.be-pager-total,.bili-footer,.bili-footer a,.bilibili-player-block-empty,.bilibili-player-block-filter-image,.bilibili-player-block-filter-label,.bilibili-player-block-line-delete,.bilibili-player-block-line.block-state-disabled,.bilibili-player-block-list-function>div,.bilibili-player-danmaku-btn-danmaku,.bilibili-player-danmaku-btn-date,.bilibili-player-danmaku-btn-time,.bilibili-player-danmaku-date-picker-btn,.bilibili-player-danmaku-date-picker-header,.bilibili-player-video-info,.block-setting-ctnr .sub-title,.boost-control li,.boost-control li i,.bottom .text,.btn-box .liked,.btn.followed .b-gz,.card-live-module .num,.case-list .info .type .bk-title,.case-list .info dl dt,.chat-item.danmaku-item .user-name,.cm-model .report-detail .detail .name,.collection-m .bottom .btn.disable,.comment-area .comm-main .comm-list .hot-line>span,.comment-bilibili-con .reason-box dl dt,.comment-list .list-item .reply-box .view-more,.comment-m .b-head .del-log,.content-box .origin-text,.content-box .punish-title .rule-content,.danmaku-info-row,.day-span,.dynamic-list-item-wrap .info>span,.dynamic-list-item-wrap .item-user a.user-name,.dynamic-list-item-wrap .item-user a.user-name.vip,.dynamic-list-item-wrap .view-more,.elec .elec-status,.emoji-box .emoji-title,.fans-action-follow,.filter-wrap .fold,.fjw-point .point-wrap .user-point .info .usr-zan-cai span,.float-nav .nav-menu .item,.follow-main .follow-action-bottom .select-counter,.follow-sidenav .num,.forw-area .forw-more a,.gift-info-desc,.gift-info-expScore,.history-list .l-info .lastplay-time .lastplay-t,.history-list .r-info .w-info .name,.history-list .r-info .w-info .pro-txt,.i-live .i-live-fo-count,.i-live .i-live-unfo-btn,.i-pin-desc,.i-pin-meta,.info .sign,.is-max .option-vote,.jury-graph-wrap .canvas-txt h4,.jury-graph-wrap .graph-status .illegal b,.jury-graph-wrap .graph-status .legal b,.lightgray,.list .list-title,.list-content-candidate,.list-item .auth-description,.list-item .desc,.live-module .zone-title .headline .fire,.live-module .zone-title .headline .online,.live-player-ctnr.minimal::before,.live-status-label.preparing,.live-wrap .headline .user-more,.looked,.medal-box,.mode .selection-span,.more-button,.msg-more,.multi-page .head-con .range-box .paging li,.multi-page .head-con .range-box i,.multi-page .more-box li,.n .n-data .n-data-k,.n .n-num,.nav-wrap .wrap>.sub>span,.no-more,.page-controller .next.disabled,.page-controller .prev.disabled,.pgc-list .synthetical .score .user-count,.pophover>p:last-child,.private-hint,.pub-list .info .comment,.pub-list .info .type .bk-title,.pub-list .info dl dt,.rank-cntr .tip,.rank-list-ctnr .tabs .item,.recommend-list .rec-footer,.report-con dl dt,.right-action-ctnr,.right-side-bar .to-comment .comment-num,.room-feed .tabs .item,.room-info-down-row .icon-label,.room-owner-username,.sec-empty-hint,.section .operation,.section-title h2,.share-to-dynamic,.side-bar .list .item,.slim-video-card .video-info .col,.slim-video-card .video-info .col-2,.so-icon,.spread-module .num,.submit-button.disabled,.suggest-wrap .title span,.synthetical .des,.tab-candidate,.tab-list .tb-item,.tabs a,.tag-info-pane .tag-footer .btn-left-box>a,.tag-info-pane .tag-header .btn-unsubscribe,.tc-slate,.textarea-container .comm-tool .comm-transpond,.top .time,.total-wrap .total-text,.up-info-block .up-info-right-block .fans-num,.up-info-block .up-info-right-block .row-2,.up-info-block .up-info-right-block .view-num,.up-info-holder .fixed-box .rightside-article-list-btn .title,.user-list .up-item .attention-btn.followed,.user-list .up-item .attention-btn.followed:hover,.user-list .up-item .up-videos .ptime,.user-panel .ctrl-btn,.video-desc .btn span,.video-toolbar,.video-toolbar .ops .share-btn i,.video-toolbar .ops .share-pos,.video-toolbar .ops>span,.video-toolbar .share .share-btn,.video.list .des,.vote-introduction,.vote-user-name,.watch-later-list header .d-btn,.what-ban .text-con .txt,.wrapper .edit-video-modal .edit-video-subtitle,.wrapper .edit-video-modal .target-favlist .target-fav-count,.wrapper .edit-video-modal .target-favlist .target-favitem.disabled span,.wrapper .modal-body .elec-bcoin,.wrapper .modal-body .elec-protocol,.wrapper .modal-body .elec-protocol a,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,.wrapper .pay-qrcode-wrp .refresh-btn,a.message,a.pic>p.title,body,div.desc,div.desc-tips,div.drag-bar,div.play-up-copyright,div.r.p>div.info,span.copyright,span.disabled,span.hate span,span.like span{color:#aaa!important}#app .container,#app .header,#app .submit .cancel,#id-card .idc-meta-item,#id-card .idc-uname,#page-article .row .breadcrumb .item,#page-channel-index .channel-item .channel-name,#page-channel-index .channel-option.no-channel p,#page-fav .fav-main .filter-item,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item span,#page-fav .fav-main .search-input input,#page-fav .fav-main .search-types,#page-fav .fav-sidenav .text,#page-index .album .content .album-wrapper .album-item .album-title,#page-index .channel.guest .channel-item .channel-title .channel-name,#page-index .col-2 .section .user-auth .auth-description,#page-setting #setting-new-tag,#page-setting .setting-privacy-item .setting-privacy-name,#page-video #submit-video-type-filter a,#pin-wrapper #pin-layer-search,#pin-wrapper .pin-layer-header,#pin-wrapper .pin-layer-order-tip,.action-menu .menu-list a,.activity-rank-cntr .rank-cntr .item,.add-btn,.advanced-danmaku-group .adv-danmaku-btn-span,.advanced-danmaku-group .adv-danmaku-pos-row .axias-span,.advanced-danmaku-group .adv-danmaku-pos-row .pos-span,.advanced-danmaku-group .content-span,.app-look,.app-watch .title,.article-action .coin-btn .info-block label,.article-action .fav-btn .info-block label,.article-action .like-btn .info-block label,.article-action .share-btn .info-block label,.article-container .text-area .title,.article-holder,.article-holder .color-default,.article-holder .video-holder .title,.article-holder h1,.article-info-container .desc,.article-info-container .title,.article-list-holder-block .article-list-plane .button .label,.article-title,.article-wrap .article .title,.audio-list .song-list .song-li .content .text,.audio-list .song-list .song-li .content .text a,.audiolist-list .song-list .song-li .content .text a,.awarding-panel,.ban-detail .content-box .bk-text-con,.ban-detail .content-box .bk-user-info .name,.ban-detail .content-box .punish-title,.bangumi-container .text-area .title,.bangumi-info-module .v-preview .title,.bangumi-list .synthetical .des .type-s,.base-bubble,.bb-comment .comment-header .tabs-order li,.bb-comment .hot-line span,.bb-comment .reply-notice .notice-item a,.be-dropdown-item,.be-input_inner,.be-pager-options-elevator input[type=text],.be-tab-item,.bili-dropdown,.bili-header-m .mini-wnd-nav a,.bilibili-player-block-label,.bilibili-player-block-line,.bilibili-player-block-string-short,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-user,.bilibili-player-color-picker-color-code,.bilibili-player-danmaku-btn-history,.bilibili-player-filter-menu,.bilibili-player-filter-title,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-modal-info,.bilibili-player-modal-title,.bilibili-player-setting-menu-list,.bilibili-player-video-btn-setting-panel-playtype-title,.bilibili-player-video-btn:hover,.bilibili-player-video-btn:hover .bilibili-player-iconfont,.bilibili-player-video-danmaku-input,.bilibili-player-video-danmaku-setting-left-area-title,.bilibili-player-video-danmaku-setting-left-block-title,.bilibili-player-video-danmaku-setting-left-fontsize-title,.bilibili-player-video-danmaku-setting-left-more-text,.bilibili-player-video-danmaku-setting-left-opacity-title,.bilibili-player-video-danmaku-setting-left-speedplus-title,.bilibili-player-video-danmaku-setting-right,.bilibili-player-video-danmaku-setting-right-more,.bilibili-player-video-progress-detail-time,.bilibili-player-video-time-seek,.bl-button--ghost,.block-content,.block-setting-row .setting-label,.block-setting-row .setting-value,.bpui-button.bpui-button-type-small,.bpui-selectmenu-list-row,.breadcrumb .batch,.breadcrumb .item.cur,.btn-box .like,.btn-cancel,.btn.default,.btn.ghost,.btns-profile span,.bui-button.bui-button-transparent,.bui-checkbox-name,.bui-collapse-arrow,.bui-input-input,.bui-input-wrap-disabled,.bui-radio-label .bui-radio-text,.bui-select .bui-select-border,.c-clink,.calendar-checkin .calendar-wrapper,.calendar-checkin .checkin-btn,.card .focus-btn .unfocus .unfocus-text,.card .more-panel,.card.config,.case-list .info .type .jc-black,.case-list .voted-user-info .name,.chat-history-list .chat-item.danmaku-item,.chat-history-panel .gift-item,.chat-history-panel .penury-gift-msg,.choice-item,.cm-model .report-detail .detail .report-cnt,.coin-operated-m .coin-title,.collection-m .title,.comment-area .comm-main .comm-tabs>ul>li,.comment-bilibili-con .other p,.comment-bilibili-con .reason-box dl dd,.comment-bilibili-con .t,.comment-content .link,.comment-emoji,.config-row,.content,.content .group-list li,.content .group-list li label .count,.content-box .origin-text a,.content-box .watermark-wrap .bk-text-con,.context-menu-a,.contribution-sidenav,.crumbs,.crumbs a,.customize,.danmaku-adjust-label,.danmaku-adjust-value,.danmaku-info-block-btn,.danmaku-info-danmaku,.danmaku-info-report-btn,.danmaku-position-item .danmaku-position-text,.danmaku-position-item .icon-font,.darkgray,.day-span.day-enable,.desc-title,.dialog .title,.download-panel-ctnr a,.dropdown-list,.dynamic-list-item-wrap .item-detail .text,.dynamic-m a,.elec .elec-count,.elec .elec-monthly-c,.ema-wishing .title,.emoji,.emoji-box .emoji-item,.emoji-box .title,.emoji-cover,.emoji-cover.selected,.emoji-text,.error-wrap,.fans-action-btn,.feed-tag .separater-line,.filter-wrap .filter-item a,.follow-btn,.follow-dialog-window .title,.follow-main .follow-action-bottom li,.follow-main .follow-action-top .back-to-info,.follow-sidenav .follow-list-container .follow-item,.follow-sidenav .follow-list-container .follow-item.cur .num,.follow-sidenav .nav-title .text,.fontsize .selection-span,.g-search input,.gift-info-title,.gift-item .label,.guard-rank-cntr .rank-cntr .page-box,.guard-rank-cntr .rank-cntr .rank-list-box a,.gui-settings,.gui-settings-box,.gui-settings-textbox-container input,.history-btn>.btn,.history-list .r-info .title,.history-list .r-info .w-info .username,.history-wrap .b-head .b-head-t,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-suggest .history,.home-wrap .home-suggest .history .list .item a,.home-wrap .home-suggest .hot-search,.hover-description,.hover-panel,.i-live .i-live-text,.i-m-btn,.i-m-title,.i-pin-v .be-tab-item,.icon-bls2018-rank.side-bar-icon+.size-bar-text,.im-popup .bp-popup-panel .title-ctnr .popup-title,.info .social a,.is-max .option-text,.jury-graph-wrap .canvas-txt p,.jury-graph-wrap .graph-status .illegal,.jury-graph-wrap .graph-status .legal,.large-item .title,.level-hint-text,.lf-item p,.link-input,.link-more,.link-panel-ctnr,.link-radio-button-label,.list-content-candidate.active,.list-create .text,.list-item .name,.live-room-list .room-item .item-title,.live-user .user-item .item-right .uname,.live-wrap .live-room .headline .filter a,.live-wrap .live-tabs a,.load-more-btn,.member-menu a,.message .message-content.not-img,.modal-container li,.modal-wrapper .modal-header-close,.modal-wrapper .modal-title,.more-link,.more-ops-list,.multi-page .cur-list li a,.multi-page .cur-list li:hover,.my-album .tab-list .tab .name,.my-album .title,.n .n-btn,.n .n-data .n-data-v,.nav-name,.nav-tab-bar .tab-item span,.nav-wrap .wrap,.nav-wrap .wrap>.sub,.next,.no-glory,.opera-list,.page-controller .next,.page-controller .prev,.page-jump>input,.pager .pages .page-item button,.paging-box .dian,.paging-box .next,.paging-box .prev,.paging-box .tcd-number,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.pgc-list .synthetical .des .type-s,.photo-list .photo .title,.pop-live .pl__head,.pop-live .pl__title,.pophover>p:first-child,.pub-list .info .name,.rank-list-ctnr .normal-list .item,.rank-list-ctnr .tabs .item.active,.rank-text-ctnr,.read-push,.report-con dl dd,.report-other,.report-popup .content-text,.result,.room-introduction-scroll-wrapper,.room-introduction-tags .room-introduction-tag,.room-title,.row-title,.search-wrap .search-block .input-wrap input,.section-right-options .operation,.seeds-wrap,.select-wrap .select-option,.select-wrap .select-option p:hover,.select-wrap .select-txt,.selector .current,.selector .data-list>li,.selector .data-list>li:hover,.selector-box,.setting.item a,.side-bar .title,.slide-item-wrp .slide-item-info .slide-item-title,.slim-video-card .video-info .title,.small-item.disabled .title,.sortable,.space-right .space-right-top .title,.special-module .user a,.sponsor-rank .sponsor-rank-header .show-sponsor-rank,.sticky-bar .bar-content .title,.sub-nav span,.suggest-item a,.suggest-wrap .horizontal .hz-text,.suggest-wrap .vt-text,.synthetical .play-btn,.synthetical .title,.t-over-hidden,.tag-info-pane .btn-right-box a,.tag-info-pane .tag-header .btn-subscribe,.tag-info-pane .text,.tag-list a,.tag-title>a,.tc-black,.tc-dark-slate,.tcd-number,.text-con,.title-container .title,.top .title,.up-article-list-block .more-article,.up-info .btn .b-cd,.up-info-holder .fixed-box .more .help .title,.up-info-holder .fixed-box .more .link .title,.up-info-holder .fixed-box .more .top-bar,.up-info-holder .fixed-box .rightside-article-list-btn .label,.up-info-holder .fixed-box .up-article-list-block .block-title,.up-level-icon,.user .info .meta .item,.user-auth.no-auth .no-auth-title .goto-auth,.user-level-detail .detail-link,.user-level-icon,.user-list .up-item .title,.user-list .up-item .up-videos .video-item .video-desc,.user-name:not(.big-vip) a,.user-panel .logout-btn,.user-type-hint,.user-wrap .dropdown-wrap .select-wrap .bili-dropdown .selected,.userinfo-content,.v-title,.video-container .text-area .title,.video-page-card .card-box .info .title,.video-title,.video-toolbar .share .share-pos .share-address ul li input,.video.list .title,.video.list .type,.video.matrix .title,.vote-title,.voted-result,.watch-later-list .list-box .av-item .av-about .t,.watch-later-list header .t,.welcome-msg .action,.welcome-msg .username,.welcome-msg .vip-icon,.what-ban .text-con .title,.wrapper .edit-video-modal .edit-video-title,.wrapper .edit-video-modal .target-favlist .target-fav-name,.wrapper .elec-main-title,.wrapper .elec-sub-title,.wrapper .modal-body .choice-wrp .battery-desp,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .modal-body .pay-info,.wrapper .modal-header .title,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,.yan-item,a.im-list,a.logout,a.more,a.name,a.read-more,a.recommand-link,a.router-link-active,a.router-link-exact-active,a.s-btn,a.side-link>span,a.up-name,a.username,div.all>a>span,div.b-head,div.bar>div.num>div,div.bili-tab-item,div.brief>a>span,div.con header,div.con>div.txt,div.grade span,div.info,div.lv-row>strong,div.r-text>.t,div.rec-title,div.title a,font,form.ipt>input,h3,li.tag,li.tag>a,p.ri-title,p.t,p.text,span.key,textarea{color:#eee!important}.bilibili-player.mode-fullscreen .bilibili-player-area .bilibili-player-video-btn-widescreen,.bilibili-player.mode-fullscreen .bilibili-player-area .bilibili-player-video-btn-widescreen .bilibili-player-iconfont{color:#99a2aa!important}.nav-tab-bar .tab-item.on span{color:#00a1d6!important}.calendar .day-item,.calendar .day-item.cur-day,.content-box .watermark-wrap .watermark,.fans-medal-item .label,.fans-medal-item:not(.medal-guard) .fans-medal-label{color:#222!important}.ban-detail .content-box .bk-text-con,.ban-detail .content-box .link-box,.bilibili-player-color-picker-color-code,.case-list .info dl,.history-list .l-info,.history-list .l-info .lastplay-time .history-red-round,.home-wrap .home-suggest .history .list .item,.home-wrap .home-suggest .hotlist .item,.live-status-label.preparing,.pub-list .info dl,.radio-icon,.report-con label:before,.suggest-wrap .title,.up-info-holder .fixed-box .rightside-article-list-btn .label,form.ipt,li.tag{border-color:#aaa!important}#id-card .idc-avatar,#page-setting #setting-new-tag,#page-setting #setting-new-tag-btn,#page-setting .setting-tag-list a,.action-menu .menu-list,.action-menu .menu-list:before,.article-container,.audio-info-module,.bangumi-info-module,.be-pager-options-elevator input[type=text],.bilibili-player-block-string-short,.bilibili-player-color-picker-container,.bilibili-player-danmaku-date-picker-container,.bilibili-player-modal-container,.bilibili-player-mode-selection-container,.bilibili-player-video-btn-setting-panel,.bilibili-player-video-control,.bilibili-player-video-danmaku-setting-box,.bilibili-player-video-inputbar,.bilibili-player-video-volumebar-wrp,.bl-button--ghost,.bpui-selectmenu-list,.card .focus-btn .focus,.card .focus-btn .unfocus,.card .more-panel,.card .more-panel:after,.common-popup-wrap .arrow,.emoji-box,.face,.h5share-container,.live-container,.multi-page .more-box,.music-container,.select-wrap .select-option,.slim-border:after,.textarea-container .comm-tool .comm-emoji,.user-card,.user-card-m,.video-container,.video-info-module,.video-toolbar .share .share-pos .share-address ul li input,.watch-later-list header .d-btn,div.dd-bubble,ul.bilibili-suggest{border-color:#222!important}#app .header,#app .submit,#app .submit .cancel,#article-list-btn .label,#article-list-btn .title,#page-fav .fav-main .fav-header.fav-header-info,#page-fav .fav-main .search-types,#page-fav .fav-main .small-item,#page-fav .fav-sidenav .nav-container,#page-index .channel .channel-item,#page-index .col-2 .section-title,#page-index .fav-covers,#page-setting .setting-index-container,#page-setting .setting-index-module,#page-subs .mini-item,#pin-wrapper .pin-layer-header,#primary_menu,.add-btn,.advanced-danmaku-group,.app-watch,.app-watch .title,.article-action,.article-content,.article-holder .slim-video-card,.attention-btn-ctnr .right-part,.awarding-panel,.bb-comment .nameplate .nameplate-card,.bb-comment .nameplate .nameplate-card .nameplate-text,.be-dropdown-item.be-dropdown-item-delimiter,.be-dropdown-menu,.be-pager-item,.be-pager-next,.be-pager-prev,.bili-dropdown,.bili-tab,.bili-tab-item,.bilibili-player-video-inputbar .bilibili-player-video-inputbar-wrap,.bilibili-player-video-time-seek,.border-b,.btn-box .message:hover,.btn-cancel,.btn-send,.btn.default,.btn.ghost,.calendar-checkin .divider,.chat-history-panel .chat-history-list .chat-item.system-msg,.checkbox,.choice-item,.comment-area .comm-main .comm-tabs,.comment-area .comm-more,.comment-bilibili-con .t,.comment-header,.common-popup-wrap,.common-popup-wrap::after,.common-popup-wrap::before,.count-choice,.customize,.danmaku-info-block-btn,.danmaku-info-report-btn,.day-span,.dialog .title,.divided-line,.dropdown-list,.dynamic-list-item-wrap,.dynamic-m,.ema-wishing,.error-wrap,.fans-action-btn,.filter-wrap,.fjw-case-detail .ban-detail .content-box .jury-status,.fjw-point header,.follow-main,.follow-main .follow-action-top,.follow-main .follow-action-top .back-to-info,.follow-main .follow-header.follow-header-info,.follow-sidenav,.follow-sidenav .nav-container.follow-container,.forw-area .forw-more,.g-search input,.gift-presets .gift-panel-switch,.gift-sender-panel::before,.guard-rank-cntr .rank-cntr .btn-box,.history-wrap .time-label:before,.home-wrap .home-input .content,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-suggest .history,.home-wrap .home-suggest .hot-search,.hover-panel,.hover-panel:before,.i-live .i-live-fo-count,.i-live .i-live-unfo-btn,.i-m-r2,.i-m-upload,.iScrollIndicator,.image-box,.info-item-ctnr,.left-container .gift-control-section,.left-container .head-info-section,.link-footer,.list .list-title,.list-item,.looked,.member-menu,.modal-container .modal-body .target-followlist,.modal-wrapper .modal-title,.multi-page .head-con .range-box .paging li,.multi-page .more-box li,.nav-list,.nav-wrap,.pager .pages .page-item button,.photo-list .photo,.pl__card,.player-and-aside-area .aside-area,.prize-item .prize-img,.rank-list-ctnr,.rank-list-ctnr .tabs .item,.report-con,.room-info-ctnr .content-wrapper,.room-introduction-tags,.s-content,.search-wrap .search-block .input-wrap input,.section .operation,.selector,.selector .data-list,.send-box,.side-bar-cntr,.song-list .song-li .content .num,.suggest-wrap,.suggest-wrap .horizontal .hz-text,.synthetical .play-btn,.user .info .meta .row,.user .tags,.user-level-detail,.user-level-detail hr,.user-level-detail::after,.user-level-detail::before,.userinfo-wrapper,.video.list .type,.video.matrix,.vote-container,.whisper .list,.wrapper .pay-qrcode-wrp,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,div.bar>div.num,li.tag{border-color:transparent!important}#arc_toolbar_report,#page-index .col-1,#page-index .col-2 .section,#page-index .col-2 .section:last-child,#page-myalbum .album-content,#pin-wrapper #pin-layer-search,#v_desc,.all-class,.app-look,.article-list-holder-block .article-list-plane,.article-wrap .article,.back-top.icon,.backdrop .title-box,.bb-comment .comment-list .quote,.be-input_inner,.bilibili-player-adv-danmaku,.bilibili-player-block-string-short-btn,.bilibili-player-context-menu-container,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-modal-header,.bilibili-player-setting-menu-wrap,.bilibili-player-video-danmaku-setting-right-separator,.bpui-button.bpui-button-type-small,.btn-box .like,.btn-box .liked,.btn-box .message,.btn.followed .b-gz,.bui-button.bui-button-transparent,.bui-input .bui-input-stepper-up,.bui-input-input,.bui-input-stepper,.bui-input-wrap-disabled,.bui-select .bui-select-border,.c-clink,.collection-m .bottom,.collection-m .title,.comment-emoji,.contribution-sidenav,.contribution-sidenav~.main-content,.danmaku-wrap .bilibili-player-block-wrap,.elec .elec-avatar,.fixed-top .search-block .input-wrap input,.float-nav .nav-menu .item,.follow-dialog-window .bottom,.follow-dialog-window .title,.go-top,.history-btn>.btn,.history-list .r-info .r-txt,.history-list .r-info .w-info .username,.i-pin-v .be-tab,.lf-list,.link-more,.list-create,.live-field.fl,.modal-wrapper .modal-title,.more-link,.more-ops-list,.notice-item,.opera-list,.option-li,.page-jump>input,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.read-push,.result .row.top-border:before,.result .row:after,.result .row:first-child:before,.right-side-bar .to-comment,.right-side-bar .to-comment .comment-num,.right-side-bar .to-top,.section,.square-field,.synthetical,.up-info .btn .b-cd,.up-info-holder .fixed-box .rightside-article-list-btn,.up-info:before,.user-list .up-item,.user-wrap .dropdown-wrap .select-wrap,.v-data,.v-preview,.v-wrap .s_tag,.video-toolbar .share .share-pos,.video.list,.vote-number,.watch-later-list .list-box .av-item .av-about,.wrapper .edit-video-modal .modal-body,.wrapper .modal-body .choice-wrp .battery,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .modal-body .elec-protocol .checkbox,.wrapper .modal-header .u-info,a.more,a.read-more,a.s-btn,div.con,div.con header,textarea,ul.boston-postcards>li{border-color:#444!important}.b-line,.b-line:hover,.bilibili-player-danmaku-date-picker-header,.btn-right-box,.video-toolbar .share .share-pos .box-b,li.history,li.history:hover,li.timeline,li.timeline:hover{border-color:#99a2aa!important}.bili-header-m .mini-wnd-nav a,.dropdown-item,.elevator-module .nav-list .item,.history-btn>.btn,.link-more,.member-menu a,.more-link,.read-push,.video-desc .btn span,a.im-list,a.logout,li.tag,p.ri-title{transition:.2s!important}.bili-dropdown>.icon,.c-clink>.icon,.filter-wrap .fold .arrow-down,.filter-wrap .fold .arrow-up,.fixed-top .search-block .search-loupe .icon-loupe,.gift-presets .gift-panel-switch>.arrow,.home-wrap .home-input .type .arrow-down,.i-live-arrow,.i-live-icon,.i-m-ra,.i-m-u-icon,.i-m-v-icon,.icon-arrow,.icon-close-notice,.icon-notice,.link-footer .footer-linker .footer-linker-bili .logo,.link-more>.icon,.list-create:hover .icon,.member-menu i,.more-link>.icon,.primary-menu .nav-menu li.home>a,.read-push>.icon,.select-wrap .select-txt i,.setting:before,.side-bar .icon,.tag-info-pane .btn-right-box a i,.up-info-holder .fixed-box .rightside-article-list-btn .icon-list,a.more>.b-icon,a.read-more>.b-icon,form.ipt>a,i.btn-del,i.face,img[src^='//static.hdslb.com/images/base']{filter:brightness(0) invert(1)!important}ul.up-nav li{filter:grayscale(1) brightness(1.3)!important}#app .container .options .option img,.bb-comment .comment-list .list-item .info .operation .spot,.bp-svg-icon.lottery-btn,.bp-svg-icon.radio-Selected,.bp-svg-icon.radio-default,.bp-svg-icon.vote-btn,.calendar .day-item.checked,.carousel-box .carousel-module .panel .trig span.on,.carousel-box .carousel-module .panel .trig span:hover,.check-icon,.comment-wrap .header .title-h2 .head-icon,.dynamic-comm-icon,.dynamic-hate:hover i,.dynamic-hated i,.dynamic-hated:hover i,.dynamic-like:hover i,.dynamic-liked i,.dynamic-liked:hover i,.emoji-btn-box.opened,.emoji-btn-box:hover,.emoji-tab-slider .next.on:hover,.emoji-tab-slider .prev.on:hover,.emotion-btn-box.opened,.emotion-btn-box:hover,.fjw-point header h2 .head-icon,.follow-main .follow-action-bottom .icon-copy,.follow-select .icon-follow-selected,.group-list li input[type=checkbox]:checked+i,.group-list li input[type=checkbox]:checked:hover+i,.group-list li input[type=checkbox]:hover+i,.home-wrap .home-logo,.home-wrap .home-tips .tips-link .tip-item>a,.is-web .checked,.link-range-ctnr,.live-wrap .live-room .headline .filter .cover-btn.active .icon-live-face,.live-wrap .live-room .headline .filter .cover-btn:hover .icon-live-face,.live-wrap .live-room .headline .filter .frame-btn.active .icon-live-frame,.live-wrap .live-room .headline .filter .frame-btn:hover .icon-live-frame,.nav-tab-bar .logo,.nav-tab-bar .tab-item.on,.primary-menu .nav-menu .sub-nav li>a,.primary-menu .nav-menu .sub-nav li>a span::after,.search-wrap .search-logo,.single-button .text-bar.selected,.user-type-icon .svg-icon.not-member-1,.user-type-icon .svg-icon.phone-1,.video-container .image-area .see-later.done,.vote-container .image-area .share-img,.watch-later-trigger.added{filter:var(--blue-image-filter)!important}.calendar .day-item.gift-checked,.home-wrap .home-tips .tips-link .tip-item>a:hover{filter:var(--pink-image-filter)!important}.elevator-module .nav-list .customize .icon,.fjw-point .point-wrap .user-point .info .usr-zan-cai .cai,.fjw-point .point-wrap .user-point .info .usr-zan-cai .zan,.spread-module .num .danmu .icon,.spread-module .num .play .icon,ul.filter-disable .icon-copy{filter:grayscale(1)!important}.room-bg{filter:brightness(.16) blur(10px)!important}.box-slide-item.expired .box-img,.box-slide-item:not(.in-countdown) .box-img,.user-type-icon .svg-icon.not-member-2,.user-type-icon .svg-icon.phone-2{filter:brightness(.3)!important}#page-follows .follow-main .follow-action-top .back-to-info,#page-index .col-1 .section .more,.article-holder .slim-video-card-error,.elec .elec-status,.elec .elec-status-bg,.small-item .cover{background-image:none!important}.bilibili-player-block-tabpanel-row.bilibili-player-border,.dropdown-item,.g-search input{border-radius:4px!important}.back-top.icon:hover,.go-top:hover{background-position:-713px -72px!important}.list-create:hover .icon{background-position:-716px -332px!important}.action-menu .menu-list,.article-container:hover .text-area,.ban-detail .content-box .info-wrap,.bpui-selectmenu-list,.bpui-slider-handle,.card,.col-full,.comment-wrap,.dynamic-m,.elec .elec-trigger,.h5share-container:hover .text-area,.i-pin-c,.large-item .cover img,.list-item .cover img,.mini-item .cover img,.music-container:hover .text-area,.n .n-inner,.side-bar-cntr,.space-right .space-right-top .title,.sticky-bar .bar-content .send-button,.vote-container:hover .text-area,div.box,div.im-list-box,div.live-box{box-shadow:none!important}#gift-package-item-box .panel-wrapper,.audio-info-module,.bangumi-info-module,.bb-comment .nameplate .nameplate-card,.bilibili-player-context-menu-container,.blpui-slider-container .slider-handle,.common-popup-wrap,.emoji-box,.emotion-box,.gift-sender-panel,.link-navbar .panel-shadow,.live-player-ctnr.minimal,.tag-info-pane,.user-card,.user-card-m,.user-level-detail,.user-panel-ctnr .user-avatar.active,.userinfo-wrapper,.video-info-module,div.dd-bubble,div.desc-tips,div.drag-bar,div.i-frame,ul.bilibili-suggest,ul.up-nav{box-shadow:rgba(0,0,0,.3) 0 4px 8px 0!important}.sticky-bar{box-shadow:0 1px 10px 0 #0003!important}#bilibili-player.mini-player::before,.bilibili-player.mini-player::before{box-shadow:0 4px 8px 0 #0004!important}.bilibili-player-context-menu-container{text-shadow:none!important}.bb-comment .comment-header .tabs-order li.on:after,.bb-comment .nameplate .nameplate-card .nameplate-arrow,.emoji-box:before,.g-search .search-btn,.load-more .icon,.loading .icon,.up-info-holder .fixed-box .more .help .icon,.up-info-holder .fixed-box .more .link .icon,.wrapper .elec-message-wrp .elec-triangle,canvas.cliper.is-img,div.desc-tips>span.arrow-left,img.source-img{display:none!important}.article-action i.animation{opacity:0!important}.vote-user-face.opacity{opacity:1!important}.advanced-danmaku-group .content-span,.bilibili-player-block-label{font-weight:400!important}.bilibili-player-video-progress-detail-sign-down{border-top-color:var(--theme-color)!important}.bilibili-player-video-progress-detail-sign-up{border-bottom-color:var(--theme-color)!important}.bilibili-player-video-control{border-bottom-color:#333!important}.coin-operated-m .mc-box{border:2px dashed #444!important;background-color:#fff!important}.coin-operated-m .mc-box.on{border-style:solid!important}.go-top-m .go-top,.page-box .num{border:none!important}.music-container .image-area .icon{filter:brightness(0)!important}.g-search input{padding:0 8px!important}.up-info-holder .fixed-box .more .help,.up-info-holder .fixed-box .more .link{padding:0!important}#page-fav .fav-main .filter-item .filter-type .be-dropdown-item{padding:0 16px!important}.cliper{filter:brightness(16%)!important}#page-setting #setting-new-tag-btn{background:var(--theme-color)!important}.bilibili-player-video-panel-image-detail{filter:invert(70%)!important}.home-wrap .home-input .content:focus,.search-wrap .search-block .input-wrap input,textarea:focus{outline:0!important;outline-offset:0!important}.bangumi-list .synthetical .cardBangumibox .modal-box .lazy-img,.pgc-list .synthetical .cardPgcbox .modal-box .lazy-img{z-index:inherit!important}.base-bubble,.base-bubble .content-ctnr:before,.bb-comment .comment-header .tabs-order li.on,.bb-comment .stick,.bb-comment .stick.assist,.be-pager-item-active,.be-tab-cursor,.be-tab-cursor:after,.bi-btn,.bili-tab-item.on,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row.active-3 .bilibili-player-block-type-user,.bilibili-player-video-btn-send,.bl-button--primary,.bpui-button.bpui-button-type-small:hover,.btn-box .like:hover,.btn-submit,.btn.primary,.bui-button.bui-button-transparent:hover,.c-clink:hover,.calendar-checkin .checkin-rewards .query:hover,.calendar-checkin .title .month:hover.cur-month:after,.calendar-checkin .title .month:hover.cur-month:before,.calendar-checkin .title .month:hover.last-month:after,.calendar-checkin .title .month:hover.last-month:before,.card .focus-btn .unfocus:hover,.choice-item.active,.choice-item:hover,.coin-operated-m .mc-box.on,.coin-operated-m .mc-box.on .coin-operated-m .mc-box:hover,.comment-area .comm-main .comm-tabs>ul>li.active,.comment-submit,.count-choice .count-input:focus,.day-span.day-enable.active,.elevator-module .back-top:hover,.elevator-module .nav-list .item.on,.elevator-module .nav-list .item:hover,.filter-wrap .filter-item.active a,.float-nav .nav-menu .item:hover,.go-top,.history-btn>.btn:hover,.history-wrap .active:before,.history-wrap .time-label,.history-wrap .time-label:after,.home-wrap .home-input .searchBtn,.link-more:hover,.list-create:hover,.live-panel .more-button .more:hover::after,.live-status-label,.live-wrap .live-tabs a.active,.more-link:hover,.multi-page .more-box li.on,.page-jump>input:focus,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.radio-icon.selected,.read-push:hover,.report-con input[type=radio]:checked+label:before,.right-side-bar .to-comment:hover,.right-side-bar .to-top:hover,.send-btn,.suggest-wrap .horizontal .hz-text:hover,.tab-list .tb-item.active,.tag-panel .more-button .more:hover::after,.top-title .concern,.up-info .btn .b-cd:hover,.up-info .up-focus-btn,.up-info-holder .fixed-box .follow-btn-holder .follow-btn:not(.followed),.up-info-holder .fixed-box .follow-btn-holder .follow-btn:not(.followed):hover,.wrapper .modal-back:hover,.wrapper .modal-body .choice-wrp.selected .battery,.wrapper .modal-body .choice-wrp.selected .elec-input,a.more:hover,a.read-more:hover,a.s-btn:hover,input[type=text]:focus,textarea:focus{border-color:var(--theme-color)!important}#app .submit .confirm,#page-channel-index .channel-option.no-channel .create-channel,#page-fav .fav-sidenav .fav-item.cur,#page-setting #setting-new-tag-btn,.advanced-danmaku-group .adv-danmaku-btn-span:hover,.area-link:active,.attention-btn-ctnr .left-part,.bb-comment .hot-line a:hover,.be-pager-item-active,.be-switch-container.is-checked .be-switch,.bi-btn,.bilibili-player-block-string-short-btn,.bilibili-player-setting-menu-list:hover,.bilibili-player-video-btn-send,.bilibili-player-video-progress-buffer-range,.bl-button--primary,.bl-switch-checked,.blpui-slider-container .slider-handle,.blpui-slider-container .slider-process,.blpui-slider-span.slider-span-active:after,.blpui-slider-span>span,.bpui-button.bpui-button-type-small:hover,.bpui-slider-progress,.btn-box .like:hover,.btn-send,.btn-submit,.btn.primary,.bui-bar-normal,.bui-button.bui-button-transparent:hover,.bui-radio-input:checked+.bui-radio-label,.bui-switch .bui-checkbox:checked+.bui-body,.bui-thumb-dot,.c-clink:hover,.card .focus-btn .unfocus:hover,.cases-wrap .fjw-user .b-right button,.close-icon,.collection-m .bottom .btn,.comment-submit,.contribution-sidenav .contribution-item.cur,.count-choice .send-button,.danmaku-info-block-btn:hover,.danmaku-info-report-btn:hover,.dropdown-item:hover,.dyn_list span.sp,.dynamic-btn.pink,.dynamic-m .dyn_menu .line,.elec .elec-trigger,.elevator-module .back-top:hover,.elevator-module .nav-list .item.on,.elevator-module .nav-list .item:hover,.filter-wrap .filter-item.active,.filter-wrap .fold:hover,.fjw-point .focus-btn,.float-nav .nav-menu .item:hover,.follow-btn,.follow-sidenav .follow-list-container .follow-item.cur,.fontsize .selection-span.active,.gift-item .corner-mark,.gift-package,.go-top:hover,.history-btn>.btn:hover,.history-list .cover-contain .progress,.history-wrap .time-label.active,.home-wrap .home-input .searchBtn,.home-wrap .home-suggest .hot-search .item .num.special,.hour-rank,.link-more:hover,.live-container .status,.more-link:hover,.more-ops-list li:hover,.multi-page .more-box li.on,.n .n-cursor,.nav-wrap .hover-bar,.new-notice-bar,.notify,.num-wrap>span,.opera-list li:hover,.pager .pages .page-item button:hover,.pager .pages .page-item.active button,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.process-bar .process-receive,.radio-icon:after,.rank-item.highlight>.ri-num,.rank.rank-1,.rank.rank-2,.rank.rank-3,.read-push:hover,.report-con label:after,.right-side-bar .to-comment:hover,.right-side-bar .to-top:hover,.s_tag .btn-add:hover span,.search-wrap .search-block .search-button,.send-btn,.sortable:hover,.sticky-bar .bar-content .send-button,.submit-button,.synthetical .play-btn:hover,.tab-bar .line,.tab-candidate>span:after,.tag-info-pane .tag-footer .btn-left-box>a:hover,.tag-info-pane .tag-header .btn-subscribe:hover,.text-con .title i,.textarea-container .comm-tool .comm-submit,.top-title .concern,.type-label,.up-info .btn .b-cd:hover,.user-list .up-item .attention-btn,.user-panel .level-progress .progress-bar,.user-panel-ctnr .user-avatar.active::before,.video-container .types,.video-info .video-title .activity,.video-toolbar .share .share-pos .share-address ul li .btn,.vote-btn-box .vote-btn,.wrapper .edit-video-modal .target-favlist .target-favitem.selected,.wrapper .elec-btn,.yan-item:active,a.btn-more:hover,a.more:hover,a.read-more:hover,a.s-btn:hover,li.tag:hover,p.on>span>a,span.reply:hover{background-color:var(--theme-color)!important}#app .header .close:hover,#id-card .idc-uname:hover,#page-channel-index .no-channel-container em,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item:hover i,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item:hover span,#page-fav .fav-main .filter-item .text:hover,#page-fav .fav-main .search-types:hover,#page-follows .follow-main .follow-action-bottom .select-cancel,#page-index .album .content .album-wrapper .album-item .album-title:hover,#page-index .channel.guest .channel-item .channel-title .channel-name:hover,#page-subs .action .sub-action,#page-subs .detail a:hover,#page-video #submit-video-type-filter a.active,.action-menu .menu-list a:hover,.album-card .title:hover,.app-watch .app-look .foot-txt a,.area-link:hover,.article-holder a,.article-title a:hover,.awarding-panel .countdown-text .with-color,.awarding-panel .info-section .slide-btn:hover,.awarding-panel .title,.ban-detail .content-box .link-box .box-right a,.bangumi-container .text-area .title:hover,.bb-comment .comment-header .tabs-order li.on,.bb-comment .comment-header .tabs-order li:hover,.bb-comment .comment-list .list-item .info .plad a:hover,.bb-comment .stick,.bb-comment .stick.assist,.bb-comment a,.be-dropdown-item a:hover,.be-pager-item:hover a,.be-pager-next:hover a,.be-pager-prev:hover a,.be-tab-item.is-active,.bili-footer a:hover,.bili-header-m .bubble-traditional .recommand .title,.bili-header-m .mini-wnd-nav a:hover,.bili-link,.bili-tab-item.on,.bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-label,.bilibili-player-block-filter-type.disabled .bp-icon,.bilibili-player-block-filter-type:hover .bilibili-player-block-filter-label,.bilibili-player-block-filter-type:hover .bp-icon,.bilibili-player-block-line-delete:hover,.bilibili-player-block-line-state,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row.active-3 .bilibili-player-block-type-user,.bilibili-player-block-tabpanel-row>div:hover,.bilibili-player-danmaku-btn-history.bpui-state-hover,.bilibili-player-video-danmaku-setting-left-block .bilibili-player-video-danmaku-setting-left-block-content .bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-label,.bilibili-player-video-danmaku-setting-left-more:hover,.bilibili-player-video-danmaku-setting-left-more:hover .bilibili-player-video-danmaku-setting-left-more-text,.bilibili-player-video-danmaku-setting-left-more:hover i,.bilibili-player-video-danmaku-setting-right-more:hover,.bilibili-player-video-danmaku-setting-right-more:hover i,.bilibili-player-video-danmaku-setting:hover,.bilibili-player-video-toast-item-close:hover i,.bilibili-player-video-toast-item-jump,.block-setting-ctnr .title,.block-user-type.active .user-type-hint,.blpui-btn.icon-btn:hover>i,.blpui-btn.text-btn.active,.blpui-btn.text-btn:hover,.boost-control li:hover,.boost-control li:hover i,.bottom .link,.box-slide-item.box-open,.box-slide-item.in-countdown,.box-toggle.active,.box-toggle:focus,.box-toggle:hover,.bpui-selectmenu-list-row[data-selected],.breadcrumb .item:hover,.bui-checkbox:hover .bui-checkbox-name,.bui-select.bui-select-quality-menu .bui-select-item.bui-select-item-active,.bui-switch .bui-checkbox:checked+.bui-body .bui-dot,.calendar-checkin .checkin-btn:hover,.calendar-checkin .checkin-rewards .query:hover,.calendar-checkin .title .month:hover,.captcha-widget .refresh-captcha:hover,.card-live-module .num,.chat-history-panel .penury-gift-msg .penury-gift-item .username,.chat-item.danmaku-item .danmaku-content:hover,.choice-item.active,.choice-item:hover,.clearall a,.clock-time,.coin-operated-m .coin-title span,.collection-m .content .group-list li:hover,.comment-area .comm-main .comm-tabs>ul>li.active,.comment-area .comm-more a.more:hover,.content-ctnr .activity-item-ctnr:hover .username.f-left,.contribution-sidenav .contribution-item a:hover,.control-panel-icon-row .icon-item.active,.control-panel-icon-row .icon-item:hover,.day-span.day-enable.active,.day-span.day-enable:hover,.download-panel-ctnr .download-item:hover,.dynamic-link-hover-bg,.dynamic-m .dyn_menu li.on,.expand-btn,.filter-wrap .filter-item a:hover,.follow-dialog-window .content .info .uname,.follow-sidenav .text:hover,.guard-rank-cntr .rank-cntr .btn-box .buy,.guard-rank-cntr .rank-cntr .rank-list-box a:hover,.history-list .r-info .title:hover,.history-list .r-info .w-info .username:hover,.history-wrap .time-label,.i-live .i-live-link:hover,.i-live .i-live-off-guest a,.i-m-title:hover,.info-ctnr .time .blue,.joined-number,.keyword,.large-item .title:hover,.list .item.active a,.list .item.active:before,.list .item:hover a,.list .item:hover:before,.list-item a.title:hover,.live-box .title,.live-module .zone-title .headline .fire:hover,.live-panel .more-button .more:hover,.live-status-label,.live-wrap .live-room .headline .filter a.active,.live-wrap .live-room .headline .filter a:hover,.live-wrap .live-tabs a.active,.live-wrap .live-tabs a:hover,.load-error-panel .request-link,.load-more-btn:hover,.member-menu a:hover,.minimal-control-panel .control-btn .btn-icon:hover,.modal-wrapper .modal-header-close:hover,.mode .selection-span.active,.mode .selection-span:hover,.more-button:hover,.multi-page .cur-list li a:hover,.multi-page .cur-list li.on i,.multi-page .head-con .range-box .paging li.on,.multi-page .head-con .range-box i:hover,.multi-page .more-box li:hover,.my-album .tab-list .tab.active .name,.n .n-btn:hover,.n .n-fs:hover p,.n .n-gz:hover p,.nav-wrap .wrap>.sub.active,.nav-wrap .wrap>.sub:hover,.paging-box .current,.player-setting-ctnr .title,.right-action-ctnr:hover,.room-introduction-tags .room-introduction-tag a:hover,.room-introduction-tags .room-introduction-tag:hover,.room-introduction-tags .room-introduction-tag:hover .icon-label,.room-owner-username:hover,.sec-empty-hint a,.section .operation:hover,.section-title,.section-title .t:hover,.seeds-wrap>.item.btn,.small-item .title:hover,.small-item.disabled .title:hover,.song-list .song-li:hover .content .text a,.special-module .user a:hover,.sticky-bar .bar-content .title:hover,.suggest-wrap .horizontal .hz-text:hover,.suggest-wrap .keyword-wrap .keyword .suggest_high_light,.tab-candidate.active,.tab-candidate:hover,.tab-text.selected,.tab-text:hover,.tabs a:hover,.tag-info-pane .tag-header .btn-unsubscribe:hover,.tag-panel .more-button .more:hover,.tag-panel .tag-list a,.tc-blue,.tc-blue-hover,.time .detail-link:hover,.up-info-holder .fixed-box .more .help .title:hover,.up-info-holder .fixed-box .more .link .title:hover,.user-level-detail .detail-link:active,.user-level-detail .detail-link:hover,.user-list .up-item .up-videos .video-item .video-desc:hover,.user-list .up-item .up-videos .video-more,.user-name:hover,.user-panel .ctrl-btn.colored,.user-panel .ctrl-btn:hover,.user-panel .logout-btn:active,.user-panel .logout-btn:hover,.user-panel .user-level,.video-desc .btn span:hover,.video-toolbar .ops .app .app-look .foot-txt a,.video-toolbar .ops>span.on,.video-toolbar .ops>span.on>i,.video-toolbar .ops>span:hover,.video-toolbar .ops>span:hover>i,.video-toolbar .share-btn:hover,.video-toolbar .share-btn:hover i,.watch-later-list .list-box .av-item .av-about .t:hover,.welcome-msg .close-vip-hint,.wish-box-cntr .title,.wrapper .elec-sub-title .up-name,.wrapper .modal-back,.wrapper .modal-body .choice-wrp.selected .battery-desp,.wrapper .modal-body .elec-pay .elec-coin,.wrapper .modal-body .elec-pay .elec-count,.wrapper .modal-body .elec-pay .elec-exp,.wrapper .modal-body .elec-protocol a:hover,.wrapper .modal-body .pay-info .balance,.wrapper .modal-body .pay-info .pay-tip .em-text,.wrapper .modal-header .u-name,.yan-item:hover,a.bbs,a.btn-more,a.help-link,a.im-list:hover,a.logout:hover,a.more-hot,a.name:hover,a.pic>p.title:hover,a.tcd-number:hover,a.up-name:hover,div.all>a>span:hover,div.bili-tab-item:hover,div.brief>a>span:hover,div.info>a,div.r-text>.t:hover,div.spread-module:hover,div.title a:hover,p.ri-title:hover,p.t:hover,span.current,ul.nav-menu>li:hover{color:var(--theme-color)!important}#app .submit .confirm,#page-setting #setting-new-tag-btn,.advanced-danmaku-group .adv-danmaku-btn-span:hover,.area-link:active,.attention-btn-ctnr .left-part,.bb-comment .comment-list .quote,.bb-comment .hot-line a:hover,.be-pager-item-active a,.be-pager-item.be-pager-item-active:hover a,.bili-header-m .mini-wnd-nav a:hover,.bilibili-player-block-string-short-btn,.bilibili-player-setting-menu-list:hover,.bilibili-player-video-btn-send,.bl-button--primary,.bpui-button.bpui-button-type-small:hover,.btn-box .like:hover,.btn-send,.btn-submit,.btn.primary,.bui-button.bui-button-transparent:hover,.bui-radio-input:checked+.bui-radio-label .bui-radio-text,.calendar .day-item.checked,.card .focus-btn .unfocus .unfocus-text:hover,.cases-wrap .fjw-user .b-right button,.collection-m .bottom .btn,.comment-submit,.contribution-item.cur a,.contribution-sidenav .contribution-item.cur .text:hover,.count-choice .send-button,.danmaku-info-block-btn:hover,.danmaku-info-report-btn:hover,.dropdown-item:hover,.dyn_list span.sp,.dynamic-btn.pink,.filter-wrap .filter-item.active,.filter-wrap .filter-item.active a,.filter-wrap .fold:hover,.fjw-point .focus-btn,.float-nav .nav-menu .item:hover,.follow-btn,.follow-sidenav .follow-list-container .follow-item.cur,.follow-sidenav .follow-list-container .follow-item.cur .num,.follow-sidenav .follow-list-container .follow-item.cur .text,.fontsize .selection-span.active,.gift-item .corner-mark,.gift-package,.gift-package>span,.history-btn>.btn:hover,.history-wrap .time-label.active,.home-wrap .home-input .searchBtn,.home-wrap .home-suggest .hot-search .item .num.special,.hour-rank .hour-rank-content,.link-more:hover,.live-container .status,.more-link:hover,.more-ops-list li:hover,.multi-page .more-box li.on,.new-notice-bar .message,.num-wrap>span,.opera-list li:hover,.pager .pages .page-item button:hover,.pager .pages .page-item.active button,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.rank.rank-1,.rank.rank-2,.rank.rank-3,.read-push:hover,.search-wrap .search-block .search-button,.section-right-options .operation:hover,.send-btn,.sortable:hover,.sticky-bar .bar-content .send-button,.submit-button,.synthetical .play-btn:hover,.tab-list .tb-item.active,.tag-info-pane .tag-footer .btn-left-box>a:hover,.tag-info-pane .tag-header .btn-subscribe:hover,.textarea-container .comm-tool .comm-submit,.top-title .concern,.type-label,.up-info .btn .b-cd:hover,.user-list .up-item .attention-btn,.video-container .types,.video-info .video-title .activity,.vote-btn-box .vote-btn,.wrapper .elec-btn,.yan-item:active,a.btn-more:hover,a.more:hover,a.s-btn:hover,div.title a.more:hover,li.tag>a:hover,span.reply:hover{color:var(--foreground-color)!important}#page-follows .follow-main .follow-action-top .back-to-info:hover,.bilibili-player-block-filter-type:hover .bilibili-player-block-filter-image,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span.active,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span.active:hover,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span:hover,.bilibili-player-video-danmaku-setting-left-block .bilibili-player-video-danmaku-setting-left-block-content .bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-image,.bilibili-player-video-danmaku-setting:hover,.bilibili-player-video-sendbar .bilibili-player-video-btn:hover,.bui-checkbox .bui-checkbox-input:checked+.bui-checkbox-label .bui-checkbox-icon svg,.bui-checkbox:hover .bui-checkbox-icon svg,.bui-switch .bui-checkbox:checked+.bui-body .bui-dot{fill:var(--theme-color)!important}.gui-settings-close path{fill:#eee}.history-list .l-info .lastplay-time .history-red-round,.history-wrap .active:before,.history-wrap .time-label:after{border-top-color:transparent!important;border-bottom-color:transparent!important}.tag-panel .more-button .more::after .tag-panel .more-button .more:hover::after{border-top-color:transparent!important;border-right-color:transparent!important}.be-tab-cursor:after,.bili-tab-item:before,.dynamic-m .dyn_menu .line:before{border-color:var(--theme-color)!important}.be-tab-cursor:after,.bili-tab-item:before,.common-popup-wrap .arrow,.dynamic-m .dyn_menu .line:before{border-left-color:transparent!important;border-right-color:transparent!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-track,.multi-page .cur-list ul::-webkit-scrollbar-track{background:#444!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-thumb,.multi-page .cur-list ul::-webkit-scrollbar-thumb{background:#222!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-thumb:hover,.multi-page .cur-list ul::-webkit-scrollbar-thumb:hover{background:#333!important}.chat-history-panel .chat-history-list,.multi-page .cur-list ul{scrollbar-color:#444 #222!important}.coverNews-item .coverNews-item-title{color:#eee!important}.coverNews-item .coverNews-item-time{color:#aaa!important}.vote-backdrop .extension-wrapper .title-box{background-color:#222!important;border-color:transparent!important}.vote-backdrop .extension-wrapper iframe{background-color:#222!important}.action-menu .menu-list a,.dialog-ctnr.bottom-left,.pay-note-panel,.suggest-wrap .keyword-wrap .keyword.focus{background-color:#333!important}.pay-note-panel .arrow-left,.pay-note-panel .arrow-right{filter:invert(.7)!important}.chat-history-panel .card-item-middle-top,.vote-result-comment{background-color:transparent!important}.chaos-pk-rank .link-to-history{color:#aaa!important}.bl-button--primary:disabled,.chaos-pk-rank .rank .rank-name,.chasing-frame-cntr .chasing,.chat-history-panel .chat-item.superChat-card-detail .card-item-middle-top-right,.ep-item.v4.cursor .ep-pub,.notice-info-wrapper .notice-info-title{color:#eee!important}.primary-menu-itnl,.vote-pc-container .card,.vote-result-comment .reply-item{border-color:transparent!important}.bi-btn,.channel-menu-itnl .item .name em,.ep-list-wrapper .ep-item .badge,.live-room-app .guard-rank-cntr .rank-cntr .btn-box .buy:hover,.pgc-space-follow-item a.pgc-item-cover .badge,.ss-list-wrapper .ss-item .ss-cover .ss-badge{color:var(--foreground-color)!important}.extension-wrapper .vote-left-time{color:#aaa!important}.extension-wrapper input{color:#eee!important}.extension-wrapper .checked{filter:var(--pink-image-filter)!important}.app-layout .search-bar .search-bar-bg,.app-layout .vertical-block-card{background-color:#444!important}.app-layout .rank-item-wrapper{background-image:none!important}.app-layout .manga-navbar-favourite-manga .drop-list .more-btn-container,.app-layout .manga-navbar-history-list .drop-list .more-btn-container{background-color:transparent!important}.app-layout .manga-navbar .download-app,.app-layout .manga-title,.app-layout .ranking-jump,.app-layout .show-status-text{color:#eee!important}.app-layout .manga-title:hover,.app-layout .ranking-jump:hover,.app-layout .show-status-text:hover{color:var(--theme-color)!important}.app-layout .sidebar-item,.app-layout .time-selector-ctnr{color:#eee!important}.app-layout .sidebar-item.activated,.app-layout .sidebar-item:hover,.app-layout .time-selector-ctnr.activated,.app-layout .time-selector-ctnr:hover{color:var(--theme-color)!important}.app-layout .sidebar-item .arrow,.app-layout .time-selector-ctnr .arrow{filter:var(--blue-image-filter)!important}.app-layout .banner-manga-container .tab-item{color:#eee!important}.app-layout .banner-manga-container .tab-item.activated{color:var(--theme-color)!important}.app-layout .banner-manga-container .tab-item.activated:after{background-color:var(--theme-color)!important}.app-layout .nav-list .nav-item .item-icon{filter:var(--blue-image-filter)!important}.app-layout .nav-list .nav-item .item-underline{background-color:var(--theme-color)!important}.app-layout .list-item,.app-layout .rank-title{color:#eee!important}.app-layout .list-item .title-tooltip,.app-layout .rank-title .title-tooltip{background-color:#555!important}.app-layout .list-item .title-tooltip:before,.app-layout .rank-title .title-tooltip:before{background-color:transparent!important}.app-layout .item-title,.app-layout .list-item .title-tooltip .tooltip-text,.app-layout .rank-title .title-tooltip .tooltip-text{color:#eee!important}.app-layout .item-title:hover{color:var(--theme-color)!important}.app-layout .manga-info-ctnr,.app-layout .meta-ctnr,.app-layout .rank-hint{color:#aaa!important}.app-layout .section-navigator{border-color:transparent!important;background-color:#444!important}.app-layout .section-navigator .divider{border-color:transparent!important}.app-layout .section-navigator .back-to-top:hover .icon{filter:var(--blue-image-filter)!important}.app-layout .container{background-color:transparent!important}.app-layout .container .title{color:#eee!important}.app-layout .container .tab{color:#aaa!important}.app-layout .container .tab.active{color:var(--theme-color)!important}.app-layout .container .tab.active:after{background-color:var(--theme-color)!important}.app-layout .auto-purchase .page-sub-title,.app-layout .auto-purchase-item .list-content .comic-content .bought-ep-count,.app-layout .purchased-comic-item .eq-desc{color:#aaa!important}.card-detail .card-item-middle-top{background-color:#333!important}.card-detail .card-item-middle-top .card-item-middle-top-right .content-bottom .price,.card-detail .card-item-middle-top .card-item-middle-top-right .name{color:#eee!important}.super-chat-bubble-main .super-chat-bubble .content-top{background-color:#333!important}.super-chat-bubble-main .super-chat-bubble .content-top .content-price .sub-price{color:#aaa!important}.super-chat-bubble-main .super-chat-bubble .content-top .content-name,.super-chat-bubble-main .super-chat-bubble .content-top .content-price{color:#eee!important}.wrapper .edit-video-modal .target-favlist .target-favitem.disabled .target-fav-title .fav-meta .fav-name,.wrapper .edit-video-modal .target-favlist .target-favitem.full .target-fav-title .fav-meta .fav-name{color:#aaa!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-meta .fav-name{color:#eee!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-select{border-color:#aaa!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-select.selected{filter:var(--blue-image-filter)!important}.wrapper .edit-video-modal .target-favlist .target-favitem:hover{background-color:transparent!important}.wrapper .edit-video-modal .target-favlist .target-favitem:hover .target-fav-title .fav-meta .fav-name{color:var(--theme-color)!important}.wrapper .edit-video-modal .target-favlist .collection-mask{background-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fake-fav-input{background-color:#444!important;border-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fake-fav-input:hover{border-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fav-add-tip{background-color:var(--theme-color)!important;color:#eee!important}.wrapper .edit-video-modal .addfav-container .fav-add-tip .blue-arrow{filter:var(--blue-image-filter)!important}.wrapper .edit-video-modal .addfav-container .fav-container{border-color:var(--theme-color)!important}.wrapper .edit-video-modal .addfav-container .fav-container .add-fav-input,.wrapper .edit-video-modal .addfav-container .fav-container .fav-add-btn{background-color:transparent!important;color:#eee!important;border-color:transparent!important}.wrapper .edit-video-modal .favlist-body:after{background-color:#aaa!important}#all-list .video-item.list{border-color:#444!important}#all-list .video-item.list .type{background-color:#444!important;color:#eee!important;border-color:transparent!important}#all-list .video-item.list .headline.singleav .avid{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}#all-list .video-item.list .headline.singleav .title{color:var(--theme-color)!important}#all-list .video-item.list .title{color:#eee!important}#all-list .video-item.list .title:hover{color:var(--theme-color)!important}#all-list .video-item.list .des{color:#aaa!important}#all-list .game-item .info .title{color:#eee!important}#all-list .game-item .info .title:hover{color:var(--theme-color)!important}#all-list .game-item .info .type{background-color:#444!important;color:#eee!important;border-color:transparent!important}#all-list .game-item .info .desc{color:#aaa!important}#all-list .pgc-item .v-switcher-header-wrap:before{background-color:transparent!important}#all-list .pgc-item .v-switcher-header-item{color:#eee!important}#all-list .pgc-item .v-switcher-header-item.is-active,#all-list .pgc-item .v-switcher-header-item:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}#all-list .pgc-item .v-switcher-header-item.is-active:after{filter:var(--blue-image-filter)!important}.cc-album-manage .article-card{background-color:#444!important;border-color:transparent!important}.cc-album-manage .article-card .cover-wrp{background-color:#444!important}.cc-album-manage .article-card .meta-footer .view-stat,.cc-album-manage .article-card .meta-status .description,.cc-album-manage .article-card .meta-status .pubdate{color:#aaa!important}.cc-album-manage .article-card .meta-view .delete{background-color:#333!important;color:#aaa!important}.cc-album-manage .article-card .meta-view .delete:hover{background-color:#222!important}.game-content .score-contain .page-btn{background-color:#444!important;color:#aaa!important;border-color:transparent!important}.game-content .score-contain .allmatch{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .score-contain .allmatch .more-match{background:0 0!important}.game-content .card-score .score-wrap{border-color:#444!important}.game-content .card-score .score-wrap .title .title-text{color:#aaa!important}.game-content .card-score .score-wrap .time-wrap{color:#eee!important}.game-content .card-score .score-wrap .time-wrap .text.state.nobegin{color:var(--theme-color)!important}.game-content .card-score .score-wrap .default-btn,.game-content .card-score .score-wrap .primary-btn{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .card-score .score-wrap .default-btn:hover,.game-content .card-score .score-wrap .primary-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .card-video .video-wrap .video-info .title a,.game-content .match-box .main-title,.game-content .match-box .sub-title{color:#eee!important}.game-content .match-box .card-video .video-wrap .video-info .title a:hover{color:var(--theme-color)!important}.game-content .match-box .card-video .video-wrap .video-info .detail{color:#aaa!important}.game-content .match-box .matchlist-contain .match-wrap .matchlist-title a{color:#eee!important}.game-content .match-box .matchlist-contain .match-wrap .matchlist-title a:hover{color:var(--theme-color)!important}.game-content .match-box .matchlist-contain .match-wrap .match-time{color:#aaa!important}.game-content .match-box .matchlist-contain .more-match{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .match-box .matchlist-contain .more-match:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-title a{color:#eee!important}.game-content .match-box .newslist-contain .news-wrap .news-title a:hover{color:var(--theme-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-title .hot-label{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-time{color:#aaa!important}.game-content .match-box .user-contain .page-btn{background-color:#444!important;color:#aaa!important;border-color:transparent!important}.game-content .match-box .user-contain .primary-btn{background-color:#444!important;color:#eee!important}.game-content .match-box .user-contain .primary-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.proxy-box .manga-panel .app-download-link,.proxy-box .manga-panel .manga-list-box .manga-card .manga-tag,.proxy-box .manga-panel .tab-switch{color:#aaa!important}.proxy-box .manga-panel .app-download-link .tab-switch-item.on,.proxy-box .manga-panel .manga-list-box .manga-card .manga-tag .tab-switch-item.on,.proxy-box .manga-panel .tab-switch .tab-switch-item.on,.proxy-box .manga-rank .tab-switch .tab-switch-item.on{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.proxy-box .manga-rank .manga-rank-item .rank-number{background-color:#444!important;color:#eee!important}.proxy-box .manga-rank .manga-rank-item .rank-number.on{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.proxy-box .manga-rank .manga-rank-item a{color:#eee!important}.proxy-box .manga-rank .manga-rank-item a:hover{color:var(--theme-color)!important}.proxy-box .manga-rank .manga-rank-item .style,.proxy-box .manga-rank .manga-rank-item .update{color:#aaa!important}.buyticket .detail-info-wrapper .title{color:#eee!important}.buyticket .selectable-option{background-color:#444!important;border-color:transparent!important}.buyticket .selectable-option.unable{background-color:#111!important;color:#666!important}.buyticket .ticket-count{background-color:#444!important;border-color:transparent!important}.buyticket .product-buy-wrapper .unsale-btn{filter:var(--pink-image-filter)!important}.buyticket .product-buy-wrapper .promo-btn.remind-btn{background-color:#444!important;color:#eee!important;border-color:transparent!important}.buyticket .product-buy-wrapper .promo-btn.remind-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.buyticket .modal-container .remind-title{color:#eee!important}.buyticket .modal-container .remind-tel input{background-color:#333!important;color:#eee!important;border-color:transparent!important;border-radius:4px}.buyticket .modal-container .modal-footer-btn div{background-color:#333!important;color:#eee!important;border-color:transparent!important}.buyticket .modal-container .modal-footer-btn div:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.detail-content .whole-guest-wrapper .guest-list-content .guest-left,.detail-content .whole-guest-wrapper .guest-list-content .guest-right{filter:invert(.8)!important}.detail-content .announcement-wrapper{background-color:#444!important;border-color:transparent!important}.detail-content .announcement-wrapper .announcement-icon,.detail-content .announcement-wrapper .announcement-item.active .circle{filter:var(--pink-image-filter)!important}.detail-content .activity-info-body .info-body p strong,.detail-content .activity-info-body .info-body ul li .title,.detail-content .announcement-wrapper .announcement-item-desc a,.detail-content .announcement-wrapper .announcement-item.active .announcement-item-time,.detail-content .announcement-wrapper .announcement-title{color:#eee!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active:before{filter:var(--blue-image-filter)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active.bilibili-player-blink{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink{color:#eee!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink .bilibili-player-tips{background-color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink:active,.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink:hover{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn .bilibili-player-video-quality-menu .bilibili-player-bigvip,.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list .bilibili-player-tips{color:var(--foreground-color)!important}.publish-panel .core-style{background-color:transparent!important;color:#eee!important;border-color:transparent!important}.publish-panel .core-style:active,.publish-panel .core-style:focus-within,.publish-panel .core-style:hover{border-color:var(--theme-color)!important}.publish-panel .editor .placeholder-shown::before{color:#888!important}.publish-panel .schedule-bar{background-color:#333!important}.publish-panel .schedule-bar .dp-label,.publish-panel .schedule-bar .s-label{color:#eee!important}.publish-panel .schedule-bar .scroll-input .s-input{background-color:#222!important;color:#eee!important;border-color:transparent!important}.publish-panel .schedule-bar .s-panel{background-color:#222!important;border-color:transparent!important}.publish-panel .schedule-bar .s-panel .s-item{color:#eee!important}.publish-panel .schedule-bar .s-panel .s-item:hover{color:var(--theme-color)!important}.publish-panel .schedule-bar .calendar.active{filter:var(--blue-image-filter)!important}.publish-panel .toolbar .static-popup{background-color:#222!important;border-color:transparent!important}.publish-panel .toolbar .static-popup .title{color:#eee!important}.publish-panel .toolbar .static-popup .upload-image .upload-btn:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.publish-panel .toolbar .bp-vote-container .create-vote{background-color:#222!important;color:#eee!important;border-color:transparent!important}.publish-panel .toolbar .bp-vote-container .create-vote .title{color:#eee!important}.publish-panel .toolbar .bp-vote-container .create-vote .bp-button:nth-child(2){background:var(--theme-color)!important;color:var(--foreground-color)!important}.publish-panel .toolbar .publish-launcher .indicator,.publish-panel .toolbar .publish-launcher .indicator::after{color:#aaa!important}.publish-panel .toolbar .publish-launcher .publish-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.publish-panel .toolbar .publish-launcher .publish-btn.disabled{background-color:#222!important;color:#eee!important}.publish-panel .toolbar .hash-popup{background-color:#222!important;border-color:transparent!important}.publish-panel .toolbar .hash-popup .hint{color:#aaa!important}.publish-panel .toolbar .hash-popup .topic-container .item{color:#eee!important}.publish-panel .toolbar .hash-popup .topic-container .item.is-selected{background-color:#333!important}.publish-panel .toolbar .bili-at-popup{background-color:#222!important;border-color:transparent!important}.publish-panel .toolbar .bili-at-popup__hint{color:#aaa!important}.publish-panel .toolbar .bili-at-popup__group-name{color:#eee!important}.publish-panel .toolbar .bili-at-popup__user--selected{background-color:#333!important}.publish-panel .toolbar .bili-at-popup__user-name{color:#eee!important}.publish-panel .toolbar .bili-at-popup__user-fans{color:#aaa!important}.h5share-container:hover .text-area .text{color:var(--theme-color)!important}.up-info .u-info .name .live-status{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.up-info .u-info .name .live-status:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.popover-video-card{background-color:#333!important}.popover-video-card .count{border-color:#444!important}.popover-video-card .content .info .subtitle,.popover-video-card .count ul li{color:#aaa!important}.popover-video-card .content .info .f-title{color:#eee!important}.v-wrap .season-info,.v-wrap .season-tabs .tabs,.v-wrap .video-toolbar{border-color:#444!important}.v-wrap .season-info .stat{color:#aaa!important}.v-wrap .season-info .desc,.v-wrap .season-info .title,.v-wrap .season-owner .info .desc,.v-wrap .season-owner .info h3 a{color:#eee!important}.v-wrap .season-detail .content-img,.v-wrap .season-detail .faq.faq,.v-wrap .season-detail .note.faq{border-color:#444!important}.message .message-content{background-color:#222!important}.message .context-menu{background-color:#444!important;color:#eee!important}.shop-panel .panel-desc{color:#eee!important}.shop-panel .panel-desc .shop-icon{filter:brightness(0) invert(1)!important}.shop-panel .shop-list{background-color:#222!important}.shop-panel .shop-list .shop-desc .desc-box .title{color:#eee!important}.shop-panel .shop-list .shop-desc .desc-box .sub-title{color:#aaa!important}.shop-panel .shop-list .shop-desc .desc-box .price-desc{color:var(--theme-color)!important}.shop-panel .shop-list .shop-desc .btn-box .jump-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.shop-panel .shop-list .shop-desc .btn-box .jump-btn.checked,.shop-panel .shop-list .shop-desc .btn-box .jump-btn.disabled{background-color:#444!important}.link-navbar{background-image:none!important}.danmaku-wrap .danmaku-info-row-code{background:#ffa20011!important}.notice-item .notice-main .notice-title{color:#eee!important}.notice-item .notice-main .notice-title:before{background-color:var(--theme-color)!important}.notice-item .notice-main .notice-time{color:#aaa!important}.notice-item .notice-btn{color:#eee!important;background-color:#222!important}.recent-danmu-wrp .danmu-filter .left{border-color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .plain{color:#eee!important;border-color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .plain.disable{color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .delete .option-wrp .act-btn{background-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu{background-color:#444!important;border-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu .menu-item{color:#eee!important}.recent-danmu-wrp .danmu-filter .left .option-menu .menu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-filter .left .option-menu .option-arrow{border-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu .option-arrow-border{border-color:transparent transparent #444!important}.recent-danmu-wrp .danmu-container .danmu-table{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .box-header{background-color:#444!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .box-header th{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table tr:hover{background-color:#444!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item{background-color:#555!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item:nth-child(2n){background-color:#444!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content,.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-name a{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content a{color:#aaa!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content a:hover{color:var(--theme-color)!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .act-btn{background-color:#333!important;color:#aaa!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .act-btn:hover{color:var(--theme-color)!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .menu-item{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .menu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-container .danmu-table .bili-checkbox:checked+span:before{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}.s-space .v-search-result{color:#aaa!important}.s-space .article-con a:hover,.s-space .v-search-count{color:var(--theme-color)!important}.tag-content .main-panel .hot-topics{background-color:#444!important}.tag-content .main-panel .hot-topics .title{border-color:transparent!important}.tag-content .main-panel .hot-topics .topic-content,.tag-content .main-panel .hot-topics .topic-header .topic-name{color:#eee!important}.tag-content .main-panel .hot-topics .topic-info{color:#aaa!important}.tag-content .main-panel .hot-topics .topic-list hr{background-color:#555!important}.international-header .nav-search #nav_searchform{background-color:#222!important}.international-header .nav-search .nav-search-keyword{color:var(--foreground-color)!important}.international-header .nav-search .nav-search-btn{background-color:#333!important}.international-header .nav-search .nav-search-btn .nav-search-submit{color:#aaa!important}.international-header .nav-search .nav-search-btn:hover .nav-search-submit{color:#eee!important}#app .header .left-block .logo{color:var(--theme-color)!important}#app .header .left-block .main-site,#app .header .right-block{color:#eee!important}#app .cc-nav-wrp,#app .header .right-block .i-frame::before{background-color:transparent!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu a,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu>span{color:#eee!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router-item.active,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router-item.active i{color:var(--theme-color)!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router_wrap i{color:#aaa!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router_wrap.active,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu .router_wrap.active i{color:var(--theme-color)!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu:hover{background:0 0!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu__group .router-item,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu__group a{color:#aaa!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap .router-item.active,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap .router-item.active i{color:var(--theme-color)!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap .router_wrap i{color:#aaa!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-item__wrap:hover{background:0 0!important}#app .cc-body{background-color:transparent!important}#app .cc-body .message-notice_wrap .tips-item_wrap{background-color:#444!important}#app .cc-body .chief-recommend-module .carousel-box,#app .cc-body .data-card{background-color:transparent!important}#app .cc-body .new-calendar-wrap{background-color:#222!important}#app .cc-body .new-calendar-wrap .calendarEntry_box .calendarEntry_content{color:#eee!important}#app .cc-body .new-calendar-wrap .calendarEntry_box .calendarEntry_content .luck_wrap .luck_title{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#app .cc-body .new-calendar-wrap .headerClass{color:#eee!important}#app .cc-body .new-calendar-wrap .calendar-header{border-color:#444!important}#app .cc-body .new-calendar-wrap .calendar-body .date-wrap{color:#aaa!important}#app .cc-body .new-calendar-wrap .calendar-body .date-wrap .wrap-content .today{color:var(--theme-color)!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap{background:0 0!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card{background-color:#333!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_title .item-title{color:#eee!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content{color:#eee!important;border-color:transparent!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content .nothing-wrap{background:0 0!important}#app .cc-body .new-calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content .nothing-wrap .release-link{color:var(--theme-color)!important}#app .cc-body .new-calendar-wrap .calendar-body .calendar-box{border-color:transparent!important}#app .cc-body .notice_wrap{background-color:#444!important}#app .cc-body .notice_wrap .notice_title .notice-txt{color:#eee!important}#app .cc-body .notice_wrap .notice_body .hot-item .item-left p,#app .cc-body .notice_wrap .notice_body .hot-item .item-right{color:#aaa!important}#app .cc-body .academy-wrap{background-color:transparent!important}#app .cc-body .academy-wrap .header .academy-tag{color:#eee!important}#app .cc-body .academy-wrap .content .tabs .tabs__header{border-color:#444!important}#app .cc-body .academy-wrap .content .tabs .tabs__header .tabs__header-item{color:#aaa!important}#app .cc-body .academy-wrap .content .tabs .tabs__header .tabs__header-item.is-active{color:var(--theme-color)!important}#app .cc-body .academy-wrap .content .tabs .tabs__header .tabs__header-item.is-active:after{background-color:var(--theme-color)!important}#app .cc-body .academy-wrap .content .list-item .title{color:#eee!important}#app .cc-body .academy-wrap .content .list-item .view{color:#aaa!important}#app .cc-body .side-utils .feedback-container .item-desc{color:#eee!important}#app .cc-body .side-utils .feedback-container .bcc-popover{background-color:#444!important;color:#eee!important;border-color:transparent!important;box-shadow:0 7px 11px 0 rgba(0,0,0,.18)!important}#app .cc-body .side-utils .feedback-container .bcc-popover .help-wrap li .title,#app .cc-body .side-utils .feedback-container .bcc-popover .help-wrap li .title .bcc-icon-ic_enter{color:#eee!important}#app .cc-body .side-utils .feedback-container .bcc-popover .help-wrap li:hover{background-color:#333!important}#app .cc-body .side-utils .feedback-container .bcc-popover[x-placement^=left] .popper__arrow,#app .cc-body .side-utils .feedback-container .bcc-popover[x-placement^=left] .popper__arrow:after{border-color:transparent!important}#app .cc-body .dc-section1-body{background-color:transparent!important}#app .cc-body .dc-section1-body .dc-section-item1_title_name p{color:#eee!important}#app .cc-body .lab-wrap{background-color:transparent!important}#app .cc-body .lab-wrap .lab-guide img{filter:brightness(.5) contrast(3)!important}#app .cc-body .lab-wrap .lab-title{color:#aaa!important}#app .cc-body .lab-wrap .lab-item{border-color:#444!important}#app .cc-body .lab-wrap .lab-item .lab-item-header .item-info .item-title .title{color:#eee!important}#app .cc-body .lab-wrap .lab-item .lab-item-header .item-info .item-title .desc{color:#aaa!important}#app .cc-body .lab-wrap .lab-item .lab-item-header .item-operate span{color:#eee!important}#app .cc-body .lab-wrap .lab-item .lab-item-content{background-color:transparent!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .divide-line{background-color:#444!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail p{color:#eee!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .detail-desc,#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .feedback{color:#aaa!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .detail-desc a,#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .feedback a{color:var(--theme-color)!important}#app .cc-body .lab-wrap .lab-item .lab-item-content .content-detail .carousel-wrapper .panel .pic .card-img img{filter:brightness(.5) contrast(3)!important}#app .cc-body .cc-article-wrp .article-header .search-wrp{border-color:transparent!important}#app .cc-body .cc-article-wrp .article-card .meta-status .status{color:var(--theme-color)!important}#app .cc-body .cc-article-wrp .article-card .select-box .select-item.is-disabled,#app .detail{background-color:transparent!important}#app .category{background-color:#444!important}.el-popover{background-color:#222!important;border-color:transparent!important}.el-popover.header-popover-download .link div p:first-child{color:#eee!important}.el-popover.header-popover-download .link:hover{background-color:#444!important}.round-corner .international-header .mini-type{background-color:#222!important;box-shadow:rgba(0,0,0,.4) 0 2px 10px 1px!important}.round-corner .international-header .mini-type .nav-link .nav-link-ul .nav-link-item .link .bili-Navbar_logo,.round-corner .international-header .mini-type .nav-link .nav-link-ul.mini .bili-icon_dingdao_xiazaiapp,.round-corner .international-header .mini-type .nav-user-center .user-con .item .name{color:#eee!important}.round-corner .channel-menu-mini{background-color:#222!important;box-shadow:rgba(0,0,0,.3) 0 4px 8px 0!important}.round-corner .channel-menu-mini .r-box{border-color:#444!important}.round-corner .channel-menu-mini .box a:hover{background-color:#0001!important}.round-corner .van-popper-avatar .level-info .grade,.round-corner .van-popper-avatar .nickname:not([style*="rgb(251, 114, 153)"]){color:#eee!important}.round-corner .van-popper-avatar .coins,.round-corner .van-popper-avatar .counts{border-color:#444!important}.round-corner .van-popper-avatar .coins .contact .email-icon--bind,.round-corner .van-popper-avatar .coins .contact .phone-icon--bind{color:var(--theme-color)!important}.round-corner .van-popper-avatar .count-item .item-key,.round-corner .van-popper-avatar .count-item .item-value{color:inherit!important}.round-corner .van-popper-avatar .links{border-color:#444!important}.round-corner .van-popper-avatar .links .link-title{color:#eee!important}.round-corner .van-popper-avatar .links .link-item:hover{background-color:#333!important}.round-corner .van-popper-favorite .tab-item--normal,.round-corner .van-popper-favorite .video-info .line-2{color:#eee!important}.round-corner .van-popper-favorite .tab-item--active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .van-popper-favorite .tabs-panel{border-color:#444!important}.round-corner .van-popper-favorite .tab-item--normal:hover,.round-corner .van-popper-favorite .video-card:hover{background-color:#333!important}.round-corner .van-popper-favorite .play-all{background-color:transparent!important;border-color:#444!important}.round-corner .van-popper-history .tab-header{border-color:#444!important}.round-corner .van-popper-history .tab-header .tab-item{color:#eee!important}.round-corner .van-popper-history .tab-header .tab-item--active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .van-popper-history .panel .video-card:hover{background-color:#333!important}.round-corner .van-popper-history .panel .progress{background-color:var(--theme-color)!important}.round-corner .van-popper-history .panel .video-info span.date{background-color:transparent!important}.round-corner .van-popper-history .panel .video-info .line-2{color:#eee!important}.round-corner .page-container{background-color:transparent!important}.round-corner .page-container .bangumi-spoiler-container{background-color:#444!important;color:#eee!important}.round-corner .page-container .tag-container .tag-item span{color:#eee!important}.round-corner .page-container .tag-container .tag-item .tag-border .tag-border-inner{display:none}.round-corner .page-container .tag-container .tag-item .tag-content{background-color:#444!important;border-color:transparent!important}.round-corner .page-container .tag-container .tag-item:hover .tag-content{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .page-container .publish-panel .core-style{background-color:transparent!important;color:#eee!important;border-color:transparent!important}.round-corner .page-container .publish-panel .core-style:active,.round-corner .page-container .publish-panel .core-style:focus-within,.round-corner .page-container .publish-panel .core-style:hover{border-color:var(--theme-color)!important}.round-corner .page-container .publish-panel .publish-btn{background-color:#222!important;color:#eee!important}.round-corner .page-container .publish-panel .publish-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.round-corner .container-body .b-head.topic{border-color:transparent!important}.round-corner .container-body .art_list li{background-color:transparent!important;border-color:transparent!important}.round-corner .container-body .art_list li h2 a{color:#eee!important}.round-corner .container-body .art_list li .artInfo,.round-corner .container-body .art_list li .info{color:#aaa!important}.canary-container .file-list-v2-container .fans-dynamic-v2-container .fans-dynamic-v2-title-wrp>h1,.canary-container .file-list-v2-container .file-title h1,.canary-container .file-list-v2-container .normal-v2-container .normal-title-wrp>h1{color:#eee!important}.canary-container .file-list-v2-container .upload-v2-sortable-chosen,.canary-container .file-list-v2-container .upload-v2-sortable-ghost{background-color:#444!important}.canary-container .file-list-v2-container .input-box-v2-3-container{background-color:#444!important;border-color:transparent!important}.canary-container .file-list-v2-container .input-box-v2-3-container>input{color:#eee!important}.canary-container .file-list-v2-container .input-box-v2-3-container.input-box-v2-3-active,.canary-container .file-list-v2-container .input-box-v2-3-container:hover{border-color:var(--theme-color)!important}.canary-container .file-content-v2-container .normal-v2-container .normal-title-wrp>h1{color:#eee!important}.canary-container .file-content-v2-container .cover-v2-detail-wrp .cover-v2-selector{border-color:#444!important}.canary-container .file-content-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-deg{background-color:#444!important;border-color:transparent!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content{background-color:#444!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-head{color:#eee!important;border-color:transparent!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-body .cover-preview-modal-body-item-selected{border-color:var(--theme-color)!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-body .cover-preview-modal-body-item-selected-icon{filter:var(--blue-image-filter)!important}.canary-container .file-content-v2-container .cover-preview-modal-container .cover-preview-modal-content .cover-preview-modal-foot div:first-child{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.canary-container .upload-step-3-container-v2{background-color:transparent!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-complete-content,.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-wait-content{color:#aaa!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-active-content{color:#eee!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-complete-icon{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-line-active{background-color:var(--theme-color)!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-active-icon{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-line.step-ctrl-line-wait{background-color:#444!important}.canary-container .upload-step-3-container-v2 .step-controller-v2-container .step-ctrl-wait-icon{color:#444!important;border-color:#444!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-split{background-color:#444!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-go-url a{background-color:#444!important;color:#eee!important;border-color:transparent!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-go-url a:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-success-hint-2{color:#aaa!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-follow{background-color:transparent!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-follow-name,.canary-container .upload-step-3-container-v2 .upload-3-v2-follow-title{color:#aaa!important}.canary-container .upload-step-3-container-v2 .upload-3-v2-follow-btn.follow{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.room-feed .tabs .item>span:after{background-color:var(--theme-color)!important}.customer-service .panel-title,.customer-service .self-panel .scroll-container .item>span{color:#eee!important}.customer-service .customer-card{border-color:#444!important}.customer-service .customer-card .card-header{background-color:#444!important}.customer-service .customer-card .card-header .name{color:#eee!important}.customer-service .customer-card .card-content>a{color:#aaa!important}.customer-service .customer-card .card-content>a:hover{color:var(--theme-color)!important}.customer-service .guess-panel .panel-header .title{color:#eee!important}.customer-service .guess-panel .question-container{border-color:#444!important}.customer-service .guess-panel .question-container .title .circle{background-color:var(--theme-color)!important}.customer-service .guess-panel .question-container .title>p{color:#eee!important}.customer-service .guess-panel .question-container .answer{color:#aaa!important}.customer-service .guess-panel .question-container .answer>a{color:var(--theme-color)!important}.customer-service .other-panel .card .title{color:#eee!important;border-color:transparent!important}.customer-service .other-panel .card .detail p,.customer-service .other-panel .card .detail-text{color:#eee!important}.customer-service .other-panel .card .detail p>a,.customer-service .other-panel .card .detail-text>a{color:var(--theme-color)!important}.customer-service .other-panel .card .detail .ask-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#app-body #player-and-interaction-area #head-info,#app-body #player-and-interaction-area .aside-area,#app-body #player-and-interaction-area .gift-control-panel{background-color:#444!important}#app-body #player-and-interaction-area #gift-control-area{border-color:transparent!important}#app-body #section-ctnr .header{background-color:transparent!important}.imagesbox .boost-slider-wrap .boost-slider-border{border-color:var(--theme-color)!important}.superchat-content{background-color:#444!important}.superchat-content .home-page{background-image:none!important}.superchat-content .home-page .introduction{color:#eee!important}.superchat-content .home-page .close,.superchat-content .home-page .introduction:before{filter:brightness(0) invert(1)!important}.superchat-content .home-page .superchat-textarea .base-info{background-color:transparent!important}.superchat-content .home-page .superchat-textarea .base-info .duration-tip{color:#eee!important}.superchat-content .home-page .superchat-textarea .base-info .duration-tip .time-icon{filter:brightness(0) invert(1)!important}.superchat-content .home-page .superchat-textarea .user-info{color:#eee!important}.superchat-content .home-page .superchat-textarea .text-ctnr,.superchat-content .home-page .superchat-textarea .textarea,.superchat-content .home-page .superchat-textarea .textarea:hover{background-color:transparent!important}.superchat-content .home-page .trans-btn{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.superchat-content .home-page .price-options .price-option{color:#eee!important}.superchat-content .home-page .price-options .price-option.selected{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.superchat-content .home-page .price-options .other{color:#eee!important}.superchat-content .home-page .price-options .other .input{background-color:transparent!important;color:#eee!important}.superchat-content .buy-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.superchat-content .super-rank{background-color:#444!important}.superchat-content .super-rank .top .header-title{color:#eee!important}.superchat-content .super-rank .top .nav{background-color:#222!important}.superchat-content .super-rank .top .nav .nav-item-1,.superchat-content .super-rank .top .nav .nav-item-2{color:#eee!important}.superchat-content .super-rank .top .nav .nav-item-1.active,.superchat-content .super-rank .top .nav .nav-item-2.active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.superchat-content .super-rank .list-box .empty>.box{background-color:transparent!important}.superchat-content .super-rank .list-box .empty>.box .h2>.special{color:var(--theme-color)!important}.superchat-content .super-rank .list-box .message-item-info .rank-icon>.num{background-color:#222!important;color:#eee!important}.superchat-content .super-rank .list-box .message-item-info>.amount,.superchat-content .super-rank .list-box .message-item-info>.user-info .publish-date{color:#aaa!important}.superchat-content .super-rank .list-box .message-item-context{color:#eee!important}.superchat-content .super-rank .list-box .anchor-item-info>.user-info .amount,.superchat-content .super-rank .list-box .anchor-item-info>.user-info .message-info,.superchat-content .super-rank .list-box .anchor-item-info>.user-info .room{color:#aaa!important}.superchat-content .super-rank .list-box .anchor-item-info>.user-info .user-name{color:#eee!important}.superchat-content .super-rank .list-box .anchor-item-info .rank-icon>.num{background-color:#222!important;color:#eee!important}.superchat-content .super-rank .list-box .anchor-item-assists>.sub-tit{color:#eee!important}.superchat-content .super-rank .list-box .keep-text{color:#aaa!important}.superchat-content .super-rank .on-list-anchor>.right{color:var(--theme-color)!important}.superchat-content .super-rank .not-list>.left>.aside,.superchat-content .super-rank .not-list>.left>.rank{color:#aaa!important}.superchat-content .super-rank .not-list>.left>.aside .special,.superchat-content .super-rank .not-list>.left>.rank .special,.superchat-content .super-rank .not-list>.right{color:var(--theme-color)!important}.rank-item,.rank-item .other{border-color:#444!important}.rank-item .other span{color:#aaa!important}.rank-item .other .other-link .title{color:#eee!important}.rank-item .other .other-link:hover .title{color:var(--theme-color)!important}.card-content .tag{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.wide-members .avatar-list i{background-color:#222!important}.wide-members .avatar-list i:hover{color:var(--theme-color)!important}.wide-members .avatar-list .van-icon-general_back_s:after{background:linear-gradient(-270deg,#222,rgba(255,255,255,0))!important}.wide-members .avatar-list .van-icon-general_enter_s:after{background:linear-gradient(270deg,#222,rgba(255,255,255,0))!important}.wide-members .avatar .tag{background-color:#222!important;color:#eee!important;border-color:var(--theme-color)!important}.wide-members .avatar .up-name{color:#eee!important}.router-view .list .top{background-color:#333!important}.router-view .config{background-color:#444!important;color:#eee!important}.router-view .config .css-o1815x{filter:var(--blue-image-filter)!important}.router-view .config .config-item:not(:first-child)::before{background-color:#555!important}.router-view .config .config-item .radio-selector{color:#eee!important}.message-list .share-card .footer{color:#aaa!important;border-color:#444!important}.message-list .msg-push{background-color:#222!important}.message-list .msg-push hr{background-color:#444!important}.live-skin-coloration-area .rank-cntr .daily-text{color:#eee!important}.guard-rank-cntr .rank-cntr .btn-box.btn-hundreds{display:none!important}.guard-rank-cntr .rank-cntr .btn-box .daily-record-title{background-color:#222!important;color:#eee!important}.guard-rank-cntr .rank-cntr .btn-box .l-line,.guard-rank-cntr .rank-cntr .btn-box .r-line{border-color:transparent!important}.guard-rank-cntr .rank-cntr .btn-box .guard-daily-record .daily-text{color:#eee!important}.live-record-list .live-record-list-cntr{background-color:#444!important;border-color:transparent!important}.live-record-list .live-record-list-cntr .record-title{color:#eee!important}.live-record-list .live-record-list-cntr .pagination{background-color:transparent!important}.live-record-list .live-record-list-cntr .pagination .jumping-ctnr .jumping-input{background-color:#222!important}.bp-svg-icon.taobao-link{filter:var(--blue-image-filter)!important}.home-page .fixed-bg,.home-page .fixed-bg-cover{background-image:none!important}.cinema-movie-wrapper .title{color:#eee!important}.cinema-movie-wrapper .preview-item .title:hover{color:var(--theme-color)!important}.cinema-movie-wrapper .preview-item .cover{background:0 0!important}.cinema-movie-wrapper div[name=web_tag] a{color:#eee!important}.cinema-movie-wrapper div[name=web_tag] a:hover{color:var(--theme-color)!important}#icon_操作_前往{fill:#eee!important}.cinema-movie-wrapper div[name=web_index] .card{z-index:0}.cinema-movie-wrapper .coming-soon-wrapper .mine{color:#eee!important;background-color:#444!important;border-color:transparent!important}.cinema-movie-wrapper .coming-soon-wrapper .mine:hover{background-color:#333!important}.cinema-movie-wrapper .card-wrapper .card-item .time-line-wrapper.empty .date{color:#aaa!important}.cinema-movie-wrapper .card-wrapper .card-item .follow-btn.followed{background-color:#333!important;color:#aaa!important}.cinema-movie-wrapper .banner-wrapper .side-list .side-item.selected:hover .title,.cinema-movie-wrapper .card-wrapper .card-item .title:hover{color:var(--theme-color)!important}.cinema-movie-wrapper .filter-wrapper .filter-block .filter-block-title span{color:#eee!important}.cinema-movie-wrapper .filter-wrapper .filter-block .filter-list a.filter-item{color:#aaa!important}.cinema-movie-wrapper .filter-wrapper .filter-block .filter-list a.filter-item:hover{color:var(--theme-color)!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-title{color:#eee!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-trailer .player-list{background-color:#444!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-trailer .player-list .list-count{color:#aaa!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-trailer .player-list .list-count .num{color:var(--theme-color)!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-trailer .player-list .list-item-wrap .list-item .list-desc{color:#eee!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-trailer .player-list .list-item-wrap .list-item.selected{background-color:#222!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-trailer .player-list .list-item-wrap .list-item.selected .list-cover{border-color:var(--theme-color)!important}.cinema-movie-wrapper .hot-recom-wrapper .hot-trailer .player-list .list-item-wrap .list-item.selected .list-cover:after{filter:var(--pink-image-filter)!important}.cinema-movie-wrapper .activity-wrap .title{color:#eee!important}.cinema-movie-wrapper .pindan-wrap .slider-contro span,.cinema-movie-wrapper .rank-wrap .slider-contro span{background-color:#444!important}.cinema-movie-wrapper .hot-wrapper .right .recent-item a,.cinema-movie-wrapper .hot-wrapper .title,.cinema-movie-wrapper .pindan-wrap .head-section .title,.cinema-movie-wrapper .pindan-wrap .preview-item .text .title,.cinema-movie-wrapper .rank-wrap .head-section .title,.cinema-movie-wrapper .rank-wrap .preview-item .text .title{color:#eee!important}.cinema-movie-wrapper .rank-wrap .head-section .more span{color:var(--foreground-color)!important;border-color:transparent!important}.cinema-movie-wrapper .rank-wrap .head-section .more span:hover{background-color:var(--theme-color)!important}.popup-card{background:0 0!important}.popup-card .info{background-color:#444!important}.popup-card .info .title{color:#eee!important}.popup-card .info .title:hover{color:var(--theme-color)!important}.popup-card .info .style .style-item{background-color:#222!important;color:#aaa!important}.popup-card .info .time{color:#aaa!important}.popup-card .info .time .split-line{background-color:#aaa!important}.popup-card .info .desc{color:#aaa!important}.popup-card .info .action-group .follow-btn{border-color:var(--theme-color)!important}.popup-card .info .action-group .follow-btn .follow-icon g#方案1{fill:#eee!important}.popup-card .info .action-group .follow-btn.followed{background-color:#333!important;border-color:#333!important;color:#aaa!important}.live-up .live-detail .up-name{color:#eee!important}.live-up .live-detail .live-name{color:#aaa!important}.live-up .live-up-img{border-color:transparent!important;box-shadow:0 0 0 1px var(--theme-color)!important}.most-viewed-panel{background-color:#444!important}.most-viewed-panel .list-content .most-viewed-item .name{color:#aaa!important}.most-viewed-panel .list-content .most-viewed-item .name.active,.most-viewed-panel .list-content .most-viewed-item:hover .name{color:var(--theme-color)!important}.most-viewed-panel .list-content .most-viewed-item .section .avatar .red-dot{background-color:var(--theme-color)!important;border-color:#444!important}.new-topic-panel{background-color:#444!important}.new-topic-panel .tag-item .label{background-color:#333!important;color:#eee!important}.new-topic-panel .more-button .more:hover{color:var(--theme-color)!important}.new-topic-panel .more-button .more:hover::after{border-color:var(--theme-color)!important}.bypb-window .online{background-color:#444!important;border-color:transparent!important}.bypb-window .online a{color:#eee!important}.bypb-window .online a:hover{color:var(--theme-color)!important}.bilibili-search-history .history-item:hover{background-color:#222!important}.bilibili-search-history .cancel-icon:hover{color:var(--theme-color)!important}.v-wrap .r-con .notice{background-color:#444!important}.video-container .text-area .subtitle{color:#aaa!important}.image-upload-btn:hover{filter:var(--blue-image-filter)!important}.msg-notify{background-color:#222!important}.msg-notify hr{background-color:#444!important}.msg-notify .context-menu{background-color:#444!important;color:#eee!important}.msg-notify .link i{filter:var(--blue-image-filter)!important}.popup-bg-cntr .popup-cntr{background-color:#444!important}.popup-bg-cntr .popup-cntr .left-part{background-color:#222!important}.popup-bg-cntr .popup-cntr .left-part .round-item .round-name{color:#eee!important}.popup-bg-cntr .popup-cntr .left-part .round-item .round-state{color:#aaa!important}.popup-bg-cntr .popup-cntr .left-part .round-item.active{background-image:none!important;background-color:#444!important}.popup-bg-cntr .popup-cntr .left-part .round-item.active .round-name .progress{color:var(--theme-color)!important}.popup-bg-cntr .popup-cntr .right-part .activity-name,.popup-bg-cntr .popup-cntr .right-part .not-bingo,.popup-bg-cntr .popup-cntr .right-part .not-join{color:#eee!important}.popup-bg-cntr .popup-cntr .right-part .bingo-list{background-color:#555!important}.popup-bg-cntr .popup-cntr .right-part .bingo-list .title{color:#eee!important}.popup-bg-cntr .popup-cntr .right-part .bingo-list .bingo-group-item-cntr .bingo-group-item .title{color:#aaa!important}.popup-bg-cntr .popup-cntr .right-part .award-list-cntr .title{color:#eee!important}.popup-bg-cntr .popup-cntr .right-part .award-list-cntr .award-list .award-item .desc{color:#aaa!important}.popup-bg-cntr .popup-cntr .right-part .award-list-cntr .award-list .award-item img{border-color:var(--theme-color)!important}.popup-bg-cntr .popup-cntr .right-part .right-top-corner .rule{color:var(--theme-color)!important}.popup-bg-cntr .popup-cntr .right-part .help-cntr{background-color:#222!important}.popup-bg-cntr .popup-cntr .right-part .help-cntr .title{color:#eee!important}.draw-fold-cntr .sender-info{background-color:#222!important;color:#eee!important;box-shadow:0 0 0 1px var(--theme-color)!important}.draw-fold-cntr .sender-info .name{color:#eee!important}.draw-fold-cntr .sender-info .words{color:#aaa!important}.article-holder .bangumi-card a .cover{border-color:#444!important}.user-panel .number-part .numbers{color:#eee!important}.user-panel .number-part:hover .numbers{color:var(--theme-color)!important}.main-container .ep-list-wrapper .list-title .ep-list-order,.main-container .ep-list-wrapper .list-title .ep-list-order:hover,.main-container .ep-list-wrapper .list-title .mode-change i,.main-container .ep-list-wrapper .list-title .mode-change i:hover{filter:var(--blue-image-filter)!important}.gift-item.buy.hover,.gift-item.buy:hover{background-color:#222!important}.cntr .user-protocol{border-color:#444!important}.cntr .silver-seed-store{background-color:#444!important}.cntr .silver-seed-store .content,.collection-bg .collection-board{background-color:#222!important}.collection-bg .collection-board .collection-submit{background-color:#444!important;color:#aaa!important}.collection-bg .collection-board .collection-list .collection-li .collection-attr{color:#aaa!important}.collection-bg .collection-board .collection-list .collection-li .collection-name,.collection-bg .collection-board .collection-list .collection-li .collection-song-number{color:#eee!important}.collection-bg .collection-board .collection-submit.active{background-color:var(--theme-color)!important;color:#eee!important}.collection-bg .collection-board .collection-theme{color:#eee!important}.collection-bg .collection-board .collection-list{border-color:#444!important}.collection-bg .collection-board .collection-list .collection-li .collection-checkbox .collection-checked,.collection-bg .collection-board .collection-list .collection-li:hover .collection-checkbox,.collection-bg .collection-board .collection-list .collection-li:hover .collection-name{color:var(--theme-color)!important}.channel-menu-mini .box a:hover{background-color:#444!important}.game-item .info .grade-wrap{color:#aaa!important}.game-item .info .grade-wrap .other-grades{background-color:#444!important;border-color:transparent!important}.game-item .info .grade-wrap .other-grades .grade-li{color:#aaa!important}.classroom-wrapper .content .block-list-item-title,.classroom-wrapper .content .block-page-progress,.classroom-wrapper .content .block-title,.classroom-wrapper .nav-wrapper,.classroom-wrapper .nav-wrapper .rec-title{color:#eee!important}.classroom-wrapper .content .block-list .slider-contro .slider-next,.classroom-wrapper .content .block-list .slider-contro .slider-prev{filter:brightness(0) invert(1)!important}.classroom-wrapper .content .block-list .slider-contro .slider-next:hover,.classroom-wrapper .content .block-list .slider-contro .slider-prev:hover{filter:var(--white-image-filter)!important;background-color:#444!important}.classroom-wrapper .rank-title,.s_tag .tag-area .topic-link{color:#eee!important}.s_tag .tag-area .channel-icon,.s_tag .tag-area .topic-link .tag-icon{filter:brightness(0) invert(1)!important}.s_tag .tag-area .channel-name{color:#eee!important}.s_tag .tag-area .tag-channel-pane{background-color:#333!important}.s_tag .tag-area .tag-channel-pane .channel-cover{border-color:#333!important}.s_tag .tag-area .tag-channel-pane .channel-title{color:#eee!important}.s_tag .tag-area .tag-channel-pane .channel-desc{color:#aaa!important}.s_tag .tag-area .tag-channel-pane .channel-btns__link{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.s_tag .tag-area .tag-channel-pane .channel-btns__link:hover{color:var(--foreground-color)!important;background-color:var(--theme-color)!important}.s_tag .tag-area .tag-channel-pane .channel-btns .is-subs{background-color:#222!important;color:#eee!important;border-color:transparent!important}.s_tag .tag-area .tag-channel-pane .channel-btns .no-subs{color:var(--foreground-color)!important;border-color:var(--theme-color)!important;background-color:var(--theme-color)!important}.s_tag .tag-area .tag-channel-pane .channel-btns .tag-channel-cancel-popup{background-color:#444!important}.s_tag .tag-area .tag-channel-pane .channel-btns .tag-channel-cancel-popup p{color:#eee!important}.s_tag .tag-area .tag-channel-pane .channel-btns .tag-channel-cancel-popup a.btn-ok{color:var(--foreground-color)!important;background-color:var(--theme-color)!important}.s_tag .tag-area .tag-channel-pane .channel-btns .tag-channel-cancel-popup a.btn-no{color:#eee!important;background-color:#222!important}.share-board .song-share .font-blue{color:var(--theme-color)!important}.guard-store-box .buy-detail{color:#eee!important}.guard-store-box .buy-detail .master{color:var(--theme-color)!important}.guard-store-box .select-month{color:#eee!important}.guard-store-box .select-month .month-selector .month-info{color:#eee!important;border-color:var(--theme-color)!important}.guard-store-box .select-month .month-selector .month-info .month-list{background-color:#444!important}.guard-store-box .select-month .month-selector .month-info .month-list .month-item{color:#eee!important}.guard-store-box .select-month .month-selector .month-info .month-list .month-item:hover .days{color:var(--theme-color)!important}.guard-store-box .select-month .month-selector .month-info .triangle:before{border-color:#444 transparent transparent!important}.guard-store-box .expired-date{color:#aaa!important}.crowdfunding-container .current-num-wrap .current-num,.guard-store-box .btn-box .total-price{color:#eee!important}.crowdfunding-container .current-num-wrap .join-status{color:#aaa!important}.crowdfunding-container .tips-container .status{color:var(--theme-color)!important}.crowdfunding-container .tips-container .status.fail{color:#aaa!important}.crowdfunding-container .tips-container .status.nostart{color:#eee!important}.crowdfunding-container .progress-container{background-color:#222!important}.crowdfunding-container .progress-container .progress-fill.highlight{background-color:var(--theme-color)!important}.crowdfunding-container .current-pro-num.highlight{color:var(--theme-color)!important}.crowdfunding-container .goal-container{color:#aaa!important}.crowdfunding-container .goal-container .goal-num,.crowdfunding-container .goal-container .goal-time{color:#eee!important}.crowdfunding-container .risk-tip-container .risk-content{background-color:#222!important}.ticket-tips-wrapper .merchant-section{background-color:#444!important}.ticket-tips-wrapper .merchant-section .merchant-header{color:#eee!important}.ticket-tips-wrapper .merchant-section .merchant-header span{filter:var(--pink-image-filter)!important}.ticket-tips-wrapper .merchant-section .baseinfo-wrapper .content-item .title{background-color:#333!important}.ticket-tips-wrapper .merchant-section .baseinfo-wrapper .content-item .title .fold-btn:hover .close,.ticket-tips-wrapper .merchant-section .baseinfo-wrapper .content-item .title .fold-btn:hover .open{filter:var(--pink-image-filter)!important}.searchresult-total-number .left-line{background-image:linear-gradient(90deg,#444,#aaa)!important}.searchresult-total-number .right-line{background-image:linear-gradient(90deg,#aaa,#444)!important}.searchresult-total-number .total-num{color:#aaa!important}.h #h-sign:focus{background-color:#444!important;color:#eee!important;box-shadow:inset 0 2px 4px #0008!important}.action-button:hover .border,.action-button>.action-icon.active .border{fill:var(--theme-color)!important}.history-list .r-info .w-info .device{color:#aaa!important}.history-list .r-info .w-info .name{border-color:#444!important}.loading-card .cover,.loading-card .desc,.loading-card .title,.loading-card .up{background-color:#444!important}.bili-im{background-color:#444!important;color:#eee!important;box-shadow:none!important}.bili-im .left,.bili-im .left .title{border-color:#555!important}.fans-medal-item .label .content{color:#222!important}.fans-medal-item .fans-medal-level{background-color:#222!important;color:var(--foreground-color)!important}.chat-control-panel .bottom .content{background-color:transparent!important;color:#222!important}.chat-control-panel .bottom .medal-ctnr .title~.qs-icon{color:#aaa!important}.chat-control-panel .bottom .medal-wear-body .medal-item .progress-level-div .progress-div{background-color:#444!important}.chat-control-panel .bottom .medal-wear-body .medal-item .progress-level-div .progress-div .progress-num-span{color:var(--theme-color)!important}.chat-control-panel .bottom .medal-wear-body .medal-item .progress-level-div .progress-div-cover{background-color:var(--theme-color)!important}.chat-control-panel .bottom .medal-wear-body .medal-item .limit-progress-div,.chat-control-panel .bottom .medal-wear-body .medal-item .progress-level-div .level-span{color:#aaa!important}.chat-control-panel .bottom .footer-line{border-color:#444!important}.chat-control-panel .bottom .medal-wear-footer,.chat-control-panel .bottom .medal-wear-footer a{color:var(--theme-color)!important}.WordSection1 p,.act-rich-style-init .act-rich-render-content,.chat-history-panel .brush-prompt .brush-prompt-item,.content-main h5,.content-main h6,.content-main p,.join-fans-body .desc-text p,.main p span{color:#eee!important}.act-rich-style-init .act-rich-render-content p span{color:#aaa!important}.act-rich-style-init .act-rich-render-content p span a strong{color:var(--theme-color)!important}.long-page .page-content{background-color:transparent!important;color:#eee!important;border-color:#444!important}.long-page .page-content .strong,.long-page .page-content h1{color:#eee!important}.bb-comment .comment-list .list-item .info .reply-tags span{background-color:#333!important;color:#aaa!important}.bilibili-player-video-sendbar-left,.bilibili-player-video-sendbar-right{background-color:#444!important}.post-content .bangumi-container{border-color:transparent!important}.jumping-ctnr .jumping-input{background-color:#222!important}.qrpay-group .qrpay-content .more-pay .more-text{color:#aaa!important}.qrpay-group .qrpay-content .more-pay .more-btn{background-color:var(--theme-color)!important;color:#eee!important}.b-info .balance-top .button{border-color:transparent!important}.b-info .balance-top:after{background-color:#aaa!important}.b-info .balance-top .balance-row .balance-title{color:#eee!important}.b-info .balance-top .balance-row .balance-right .balance-name,.b-info .balance-top .balance-row .balance-right .balance-price{color:var(--theme-color)!important}.b-info .balance-top .balance-row .balance-right .shell-channel .shell-item{background-color:#333!important;border-color:transparent!important}.b-info .balance-top .balance-row .balance-right .shell-channel .shell-item-active{border-color:var(--theme-color)!important}.b-info .balance-top .balance-row .balance-right .shell-channel .shell-item .channel-name{color:#eee!important}.b-info .balance-top .balance-row .balance-right input{background-color:#444!important;color:#eee!important}.b-info .balance-top .balance-row .balance-right input::placeholder{color:#aaa!important}.b-info .balance-top .balance-row .balance-right .all-btn{color:var(--theme-color)!important}.b-info .balance-top .balance-row .balance-right .withdraw-btn{background-color:var(--theme-color)!important}.b-info .balance-footer .part-balance-name{color:#eee!important}.b-info .balance-footer .part-balance-name .unbb-des{background-color:#333!important;background-image:none!important}.b-info .balance-footer .part-balance-name .check-detail-btn,.b-info .balance-footer .part-balance-name .unbb-des a{color:var(--theme-color)!important}.b-info .warning-group{border-color:transparent!important}.b-info .warning-group .warning-title{color:#eee!important}.b-info .rule-btn{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.spend-recode .title-group .selected-title:after{background-color:var(--theme-color)!important}#newsDetail li.tag:hover,#newsList li.tag:hover{background-color:transparent!important}#newsDetail li.tag:hover span,#newsList li.tag:hover span{color:var(--theme-color)!important}#app-ctnr .label-wrapper .content{background-color:transparent!important}.my-album .link-panigation li.panigation.selected{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.container.similar-songs-content{background-color:transparent!important}.container.similar-songs-content .similar-songs-title,.container.similar-songs-content .similar-title{color:#eee!important}.container.similar-songs-content .play-songs-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.container.similar-songs-content .similar-songs-list{border-color:transparent!important}.container.similar-songs-content .similar-songs-list .list-item.odd{background-color:#333!important}.container.similar-songs-content .similar-songs-list .list-item.even{background-color:#444!important}.container.similar-songs-content .similar-songs-list .list-item .song-sort{color:#eee!important}.container.similar-songs-content .similar-songs-list .list-item .song-title .song-collection.font-blue,.container.similar-songs-content .similar-songs-list .list-item .song-title .song-float:hover,.container.similar-songs-content .similar-songs-list .list-item .song-uname.font-blue,.fansmedal-popover .target-user{color:var(--theme-color)!important}.bp-right .des-content{background-color:#222!important}.bp-right .des-content .text-content .title{color:#eee!important}.bp-right .des-content .button{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.comment-jump-url img{filter:var(--blue-image-filter)!important}.members-info .avatar-name__container .name-text,.s_tag .tag-area>li .tag-link,.wide-members__title{color:#eee!important}.members-info .avatar{background-color:#444!important}.members-info .avatar .info-tag{background-color:#333!important;color:var(--theme-color)!important;border-color:var(--theme-color)!important}.members-info .avatar .attention{background-color:var(--theme-color)!important}#page-video .play-all-btn{color:#eee!important}#page-video .play-all-btn>img{filter:var(--pink-image-filter)!important}.video-card-common a{color:#eee!important}.video-card-common a:hover{color:var(--theme-color)!important}a.bp_box_bot_click{border-color:var(--theme-color)!important}.el-date-table td.available:hover{color:var(--theme-color)!important}.el-date-table td.current:not(.disabled) span{background-color:var(--theme-color)!important}.el-date-table td.today span{color:var(--foreground-color)!important}.el-date-table td.disabled div{background-color:#333!important;color:#aaa!important}.list-introText{color:var(--theme-color)!important}.song-list .song-li .song-shadow{background-color:var(--theme-color-30)!important}.recommend-list .rec-title{color:#eee!important}.recommend-list .rec-title .next-buttom{color:#aaa!important}.recommend-list .rec-title .next-buttom .switch-button{background-color:#444!important;border-color:#444!important}.recommend-list .rec-title .next-buttom .switch-button.on{background-color:var(--theme-color)!important;border-color:var(--theme-color)!important}.nav-tabs{border-color:#444!important}.nav-tabs .nav-tabs__item{border-color:transparent!important}.nav-tabs .nav-tabs__item>div>span,.nav-tabs .nav-tabs__item>span{color:#eee!important}.nav-tabs .nav-tabs__item--active span,.nav-tabs .nav-tabs__item:hover span{color:var(--theme-color)!important}.nav-tabs .nav-tabs__item--active{border-color:var(--theme-color)!important}.rank-container .rank-tab-wrap .rank-tab{color:#eee!important}.rank-container .rank-tab-wrap .rank-tab--active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.rank-container .rank-list .rank-item:hover{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.rank-container .back-top-btn{border-color:transparent!important;background-color:#333!important}.rank-container .back-top-btn .arrow-icon{color:#aaa!important}.rank-container .back-top-btn:hover{background-color:var(--theme-color)!important}.rank-container .back-top-btn:hover .arrow-icon{color:var(--foreground-color)!important}.history-list .history-tips,.popular-list .popular-tips,.rank-container .rank-tips{color:#aaa!important}.video-card .video-card__info .video-name{color:#eee!important}.video-card .video-card__info:hover .video-name{color:var(--theme-color)!important}.video-card .video-card__info .rcmd-tag{border-color:#444!important}.video-card .video-card__info .strong-tag{background-color:#444!important;color:var(--theme-color)!important}.video-card .video-card__info .weak-tag{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.video-card .video-card__info .up-name{color:#aaa!important}.weekly-header .current-tiem{color:#eee!important}.weekly-header .panel{background-color:#333!important}.weekly-header .panel .item-active{background-color:var(--theme-color)!important}.weekly-header .panel .item-active .item-info,.weekly-header .panel .item-active .item-title{color:var(--foreground-color)!important}.weekly-header .panel .item-title{color:#eee!important}.weekly-header .panel .item-info{color:#aaa!important}.weekly-header .panel .select-item:not(.item-active):hover{background-color:#444!important}.video-card .weekly-hint{background-color:#444!important;color:#aaa!important}.video-card .history-hint{background-color:#444!important}.rank-list .rank-item .content .img,.rank-list .rank-item .content .img .cover{background-color:#444!important;border-color:transparent!important}.manga-detail .layout,.manga-detail .section .right-side .recommendation{background-color:#444!important}.manga-detail .episode-list-component .episode-list .list-header .header-item{background-color:#555!important}.manga-detail .section .right-side .recommendation .header-content .more:hover{background-color:transparent!important;color:var(--theme-color)!important}.manga-detail .section .right-side .ranking-jump:hover .emmet-right,.manga-detail .section .right-side .recommendation .header-content .more:hover .emmet-right{filter:var(--blue-image-filter)!important}.manga-detail .comic-info-panel .comic-detail .comic-title{color:#eee!important}.manga-detail .comic-info-panel .comic-detail .comic-info{color:#aaa!important}.manga-detail .section .right-side .recommendation .header-content .title{color:var(--theme-color)!important}.container .back-to-content{background-color:#444!important}.container .back-to-content .back-to-top-button:hover .icon-top{filter:var(--blue-image-filter)!important}.classroom-innerWrapper .classroom-rec .title{color:#eee!important}.classroom-innerWrapper .classroom-rec .rank-index{background-color:#444!important}.classroom-innerWrapper .upComming .block-page-progress{color:#eee!important}.classroom-innerWrapper .upComming .block-list .slider-contro .slider-next:hover,.classroom-innerWrapper .upComming .block-list .slider-contro .slider-prev:hover{background-color:#444!important}.classroom-innerWrapper .upComming .tags{background-color:#222!important;color:#aaa!important}.shop-desc .desc-box .price,.up-info .up-info_right .name .message:hover,.up-info .up-info_right .name .message:hover i{color:var(--theme-color)!important}.header-video-card:hover{background-color:#333!important}.video-toolbar .note-btn{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.video-toolbar .note-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.my-notebook .note-header{border-color:transparent!important}.my-notebook .note-header .note-title .note-text{color:#eee!important}.my-notebook .note-header .note-title .note-count{color:#aaa!important}.my-notebook .note-single-item{border-color:#555!important}.my-notebook .note-single-item--selected{background-color:#333!important}.my-notebook .note-single-item .note-item__detail--title{color:#eee!important}.my-notebook .note-single-item .note-item__detail--info .go-video-btn{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.my-notebook .note-single-item .note-item__detail--info .go-video-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.my-notebook .note-single-item .note-item__detail--info .update-mtime{color:#aaa!important}.van-popover.popover-game,.van-popover.popover-live,.van-popover.popover-manga{background-color:transparent!important}.series .bt-top .bt,.series .van-pagination{color:#eee!important}.series .van-pagination-point{background-color:#333!important}.series .van-pagination-point .van-pagination-active,.series .van-pagination-point .van-pagination-item:hover{background-color:var(--theme-color)!important}.series .van-pagination-btn-next,.series .van-pagination-btn-prev{color:#eee!important;background-color:#444!important;border-color:transparent!important}.series .van-pagination-pager li{color:#eee!important}.series .switch-button{background-color:#333!important}.series .switch-button.on{background-color:var(--theme-color)!important}.series .switch-button.on::after,.series .switch-button::after{color:#eee!important}.series .series-box .video-card-common{background-color:transparent!important}.multi-page .cur-list .list-box li .duration{color:#aaa!important}.interact-dialog .dialog-body{background-color:#222!important}.interact-dialog .dialog-body::before{content:"";background:url(https://s1.hdslb.com/bfs/static/jinkela/video/asserts/interact-dialog.png) 0 0/242px 198px no-repeat;filter:invert(1);width:242px;height:198px;display:block;position:absolute;clip-path:inset(60% 35% 0 35%)}#app .channel-sidebar .search-history-panel{background-color:#333!important;border-color:#444!important}#app .channel-sidebar .search-history-panel .history-item.focus,#app .channel-sidebar .search-history-panel .history-item:hover{background-color:#222!important}#app .channel-sidebar .search-history-panel .history-item .item-value{color:#eee!important}#app .channel-sidebar .search-history-panel .clear-btn,#app .channel-sidebar .search-history-panel .history-item .delete-icon:hover{color:var(--theme-color)!important}#app .search-container{background-color:transparent!important}#app .search-container .header-info .title{color:#eee!important}#app .search-container .header-info .count{color:#aaa!important}#app .search-container .card-list .channel-info .title,#app .search-container .card-list .header-info .title{color:#eee!important}#app .search-container .card-list .channel-btn,#app .search-container .card-list .channel-btns{filter:var(--blue-image-filter)!important}#app .search-container .card-list .list .video-card .video-name{color:#eee!important}#app .search-container .card-list .list .video-card .video-name:hover{color:var(--theme-color)!important}#app .search-container .back-top-btn{border-color:transparent!important;background-color:#333!important}#app .search-container .back-top-btn .arrow-icon{color:#aaa!important}#app .search-container .back-top-btn:hover{background-color:var(--theme-color)!important}#app .search-container .back-top-btn:hover .arrow-icon{color:var(--foreground-color)!important}#page-dynamic .bb-comment .no-login .comment-emoji,#page-dynamic .bb-comment .no-login .textarea-container .baffle,#page-dynamic .bb-comment .no-login .textarea-container .comment-submit,.detail-card .bb-comment .no-login .comment-emoji,.detail-card .bb-comment .no-login .textarea-container .baffle,.detail-card .bb-comment .no-login .textarea-container .comment-submit{background-color:#666!important}.back-top-tools .backup{border-color:transparent!important;background-color:#333!important;color:#aaa!important}.back-top-tools .backup:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.s-space .follow-main .follow-header .follow-tabs{color:#eee!important}.s-space .follow-main .follow-header .follow-tabs .active,.s-space .follow-main .follow-header .follow-tabs span:hover{color:var(--theme-color)!important}.s-space .follow-main .follow-header .follow-tabs .active::before{border-bottom-color:var(--theme-color)!important}.s-space .follow-main .follow-header .follow-tabs .active::after{background-color:var(--theme-color)!important}.s-space .follow-main .follow-header .search-component:hover{border-color:var(--theme-color)!important}.s-space .follow-main .follow-header .search-component.search-component-focus{border-color:#aaa!important}.s-space .follow-main .follow-header .search-component .search-component-input input{background-color:transparent!important;color:#eee!important}.s-space .follow-main .follow-header .search-component .icon-follow-search:hover{filter:var(--blue-image-filter)!important}.s-space .follow-main .follow-header .follow-search-result{color:#aaa!important}.s-space .album-content .album-list__title{color:#eee!important}.s-space .album-content .album-list__tabs{background-color:#222!important}.s-space .album-content .album-list__tabs .album-list__tab-name{color:#eee!important}.s-space .album-content .album-list__tabs .album-list__tab--active .album-list__tab-name{color:var(--theme-color)!important}.s-space .album-content .album-list__content .album-card__title{color:#eee!important}.s-space .album-content .album-list__content .album-card__title:hover{color:var(--theme-color)!important}.s-space .search-page{background-color:#444!important}.s-space .search-page .search-nav{color:#eee!important}.s-space .search-page .search-nav-item .num{color:#aaa!important}.s-space .search-page .search-nav-item:hover{background-color:#555!important}.s-space .search-page .search-nav-item:hover .text{color:var(--theme-color)!important}.s-space .search-page .search-nav-item.search-nav-actived{background-color:var(--theme-color)!important}.s-space .search-page .search-nav-item.search-nav-actived .num,.s-space .search-page .search-nav-item.search-nav-actived .text{color:var(--foreground-color)!important}.s-space .search-page .feed-dynamic{border-color:transparent!important}.s-space .search-page .feed-dynamic .feed-dynamic-header-search-kw,.s-space .search-page .feed-dynamic .feed-dynamic-header-title{color:#eee!important}.s-space .search-page .feed-dynamic .feed-dynamic-header-search{color:#aaa!important}.s-space .search-page .feed-dynamic .feed-dynamic-header-search-count{color:var(--theme-color)!important}.s-space .search-page .feed-dynamic .card .main-content .single-icon{filter:grayscale(1)!important}.switch-wrap .type.active i,.switch-wrap .type.active:hover i{filter:var(--blue-image-filter)!important}.switch-wrap .type.imgleft:not(.active):hover i{background-position:-148px -376px!important;opacity:1}.switch-wrap .type.imgleft:not(.active) i{opacity:.7;transition:opacity .2s ease-out}.switch-wrap .type.aver:not(.active):hover i{background-position:-194px -376px!important;opacity:1}.switch-wrap .type.aver:not(.active) i{opacity:.7;transition:opacity .2s ease-out}.sponsor-mini-rank .sponsor-rank-container .sponsor-rank-item:nth-child(n+4) .sp-rank{color:#eee!important}.sponsor-rank-dialog .sponsor-rank-content{background-color:#444!important}.sponsor-rank-dialog .sponsor-rank-content ::-webkit-resizer,.sponsor-rank-dialog .sponsor-rank-content ::-webkit-scrollbar-thumb{background-color:#333!important}.sponsor-rank-dialog .sponsor-rank-content ::-webkit-resizer:hover,.sponsor-rank-dialog .sponsor-rank-content ::-webkit-scrollbar-thumb:hover{background-color:#555!important}.sponsor-rank-dialog .sponsor-rank-content .sp-rank-header .sp-list-nav{border-bottom-color:#555!important}.sponsor-rank-dialog .sponsor-rank-content .sp-rank-body .sp-rank-list .sponsor-rank-item:nth-child(n+4) .sp-rank i{background-color:#333!important;color:#eee!important}.sponsor-rank-dialog .sponsor-rank-content .sp-rank-body .sp-rank-list .sponsor-rank-item .sp-user:not([class~=vip]){color:#eee!important}.sponsor-rank-dialog .sponsor-rank-content .sp-rank-body .sp-rank-list .sponsor-rank-item .sp-msg{background-color:#333!important;border-color:transparent!important}.sponsor-rank-dialog .sponsor-rank-content .sp-rank-body .sp-rank-list .sponsor-rank-item .sp-msg::before{border-top-color:#333!important;border-left-color:#333!important;background-color:#333!important}.sponsor-rank-dialog .sponsor-rank-content .sp-rank-body .sp-rank-list .sponsor-rank-item .sp-msg p{color:#eee!important}.sponsor-pay-content .sponsor-pay-header{border-bottom:#555!important}.sponsor-pay-content .sponsor-pay-body .sponsor-choice .active .sponsor-border{background-color:transparent!important}.sponsor-pay-content .sponsor-pay-body .sponsor-choice .sponsor-border{background-color:#333!important}.sponsor-pay-content .sponsor-pay-body .sponsor-choice .active input[name=custom-amount]{color:#eee!important}.sponsor-pay-content .sponsor-pay-body .sponsor-choice input[name=custom-amount]{background-color:#333!important;color:#666!important}.sponsor-pay-content .sp-pay-qrcode .sponsor-qrcode .step-other{filter:var(--blue-image-filter)!important}#biliMainHeader .base-mini-header,#biliMainHeader .mini-header{background-color:#222!important}#biliMainHeader .base-mini-header .base-mini-header-logo,#biliMainHeader .mini-header .base-mini-header-logo{filter:brightness(0) invert(1)!important}#biliMainHeader .base-mini-header .base-mini-header-pulldown-icon,#biliMainHeader .base-mini-header .base-nav-link-item,#biliMainHeader .base-mini-header .base-nav-link-main,#biliMainHeader .mini-header .base-mini-header-pulldown-icon,#biliMainHeader .mini-header .base-nav-link-item,#biliMainHeader .mini-header .base-nav-link-main{color:#eee!important}#biliMainHeader .base-mini-header .base-mini-upload,#biliMainHeader .mini-header .base-mini-upload{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.v-wrap .vcd .cover{background-color:#444!important}.live-btn-ctnr .icon-arrow-right{color:var(--theme-color)!important}#app-container .share-step .ogv-card{background-color:#333!important}#app-container .share-step .bp-emoji-box,#app-container .share-step .ogv-card .name{color:#eee!important}.link-footer .footer-img-linker li a:hover .footer-img-item{color:#eee!important;border-color:transparent!important}.link-footer .footer-img-linker li .footer-img-item{border-color:#aaa!important}div[role=alertdialog] .link-popup-panel{top:unset!important}div[role=alertdialog] .link-popup-panel .popup-content-ctnr p{color:#aaa!important}.streamer-calendar{background-color:#222!important}.streamer-calendar .subscribe-tips{color:#eee!important}.streamer-calendar .streamer-calendar-nav{background-color:#444!important;border-color:transparent!important}.streamer-calendar .streamer-calendar-nav .tabs-wrapper .tabs .tabs-item:hover{color:#eee!important}.streamer-calendar .streamer-calendar-nav .tabs-wrapper .tabs .tabs-item::after{background-color:var(--theme-color)!important}.streamer-calendar .streamer-calendar-nav .tabs-wrapper .tabs .tabs-item.tabs-item-active{color:#eee!important}.streamer-calendar .streamer-calendar-nav .month-tabs-btn{background-color:transparent!important}.streamer-calendar .streamer-calendar-nav .month-tabs-btn:focus,.streamer-calendar .streamer-calendar-nav .month-tabs-btn:hover{filter:var(--blue-image-filter)!important}.streamer-calendar .streamer-calendar-nav .month-tabs-title{color:#eee!important}.streamer-calendar .streamer-calendar-nav .streamer-calendar-description{color:#aaa!important}.streamer-calendar .streamer-calendar-nav .btn-blue{background-color:var(--theme-color)!important}.streamer-calendar .calendar-watch .calendar-follow{border-color:transparent!important;background-color:#444!important}.streamer-calendar .calendar-watch .calendar-follow .calendar-follow-title{color:#eee!important}.streamer-calendar .calendar-watch .calendar-follow .calendar-follow-title .calendar-follow-description{color:#aaa!important}.streamer-calendar .calendar-watch .calendar-follow .calendar-follow-empty .calendar-follow-empty-tips{margin-left:36px}.streamer-calendar .calendar-watch .calendar-follow .calendar-follow-empty .calendar-follow-empty-tips p{color:#eee!important}.streamer-calendar .calendar-watch .calendar-follow .calendar-follow-cards-container .anchor-card .anchor-card-avatar{border-color:#666!important}.streamer-calendar .calendar-watch .calendar-follow .calendar-follow-cards-container .anchor-card .anchor-card-info .anchor-card-title{color:#eee!important}.streamer-calendar .calendar-watch .calendar-follow .calendar-follow-cards-container .anchor-card .anchor-card-info .anchor-card-action{background-color:var(--theme-color)!important}.streamer-calendar .calendar-watch .calendar-search{border-color:transparent!important;background-color:#444!important}.streamer-calendar .calendar-watch .calendar-search .calendar-search-top .calendar-search-title{color:#eee!important}.streamer-calendar .calendar-watch .calendar-search .calendar-search-top .calendar-search-input-wrapper{background-color:#333!important}.streamer-calendar .calendar-watch .calendar-search .calendar-search-top .calendar-search-input-wrapper .calendar-search-input{color:#eee!important}.streamer-calendar .calendar-watch .calendar-search .calendar-search-top .calendar-search-input-wrapper .calendar-search-action:hover{filter:var(--blue-image-filter)!important}.streamer-calendar .calendar-watch .calendar-search .calendar-search-content .anchor-card-info .anchor-card-avatar{border-color:#666!important}.streamer-calendar .calendar-watch .calendar-search .calendar-search-content .anchor-card-info .anchor-card-title{color:#eee!important}.streamer-calendar .calendar-watch .calendar-search .calendar-search-content .calendar-search-message{color:#aaa!important}.streamer-calendar .calendar-watch .basic-calendar{border-color:transparent!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-thead .basic-calendar-thead-th{color:#aaa!important;border-color:#666!important;background-color:#444!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item{border-color:#666!important;background-color:#333!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-top .calendar-item-date .calendar-item-today{background-color:var(--theme-color)!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-top .calendar-item-date:not(.calendar-item-today){filter:invert(1)}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-top .calendar-item-switch-cards-wrapper{background-color:transparent!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-top .calendar-item-switch-cards-wrapper .calendar-item-switch-cards{background-color:transparent!important;border-color:#666!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-top .calendar-item-switch-cards-wrapper .calendar-item-switch-cards:not([disabled=disabled]):hover{background-color:var(--theme-color)!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card{border-color:transparent!important;background-color:#333!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card .calendar-card-top .calendar-card-time{color:#eee!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card .calendar-card-top .calendar-card-time.calendar-card-time-end{color:#aaa!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card .calendar-card-top .calendar-card-follow{background-color:var(--theme-color)!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card .calendar-card-top .calendar-card-follow.calendar-card-follow-subscribed{background-color:#555!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card .calendar-card-info .calendar-card-anchor{color:#eee!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card .calendar-card-title{color:#aaa!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card.calendar-card-follow-highlight{background-color:var(--theme-color)!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card.calendar-card-follow-highlight .calendar-card-top .calendar-card-time{color:#eee!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-card-wrapper .calendar-card.calendar-card-follow-highlight .calendar-card-title{color:#333!important}.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-cards-wrapper-even .calendar-item-card-wrapper:nth-of-type(odd) .calendar-card,.streamer-calendar .calendar-watch .basic-calendar .basic-calendar-tbody .basic-calendar-item .calendar-item-cards-wrapper-odd .calendar-item-card-wrapper:nth-of-type(2n) .calendar-card{background-color:#444!important}.streamer-calendar .share-panel{border-color:transparent!important;background-color:#444!important}.streamer-calendar .side-bar .side-bar-btn{color:var(--theme-color)!important;border-color:transparent!important;background-color:#444!important}.streamer-calendar .side-bar .side-bar-btn .side-bar-btn-icon{filter:var(--blue-image-filter)!important}html,html body{background-color:transparent!important}html:not(.iframe),html:not(.iframe) body{background-color:#222!important}.bb-comment .comment-list .list-item .text .jump-img,.bb-comment .comment-list .list-item .text-con .jump-img{filter:var(--blue-image-filter)!important}.bilibili-player-view-points[data-type="-1"]>span{background-color:#aaaa!important}.resizable-component .note-drag-bar{background-color:#444!important;color:#aaa!important}.resizable-component .note-drag-bar .status-bar{color:#aaa!important}.resizable-component .note-drag-bar .operation-btns .close-btn,.resizable-component .note-drag-bar .operation-btns .question-btn,.resizable-component .note-drag-bar .operation-btns .space-btn{background-color:#555!important;color:#ddd!important}.resizable-component .note-drag-bar .operation-btns .close-btn:hover,.resizable-component .note-drag-bar .operation-btns .question-btn:hover,.resizable-component .note-drag-bar .operation-btns .space-btn:hover{color:var(--theme-color)!important}.bili-note{background-color:#333!important}.bili-note .ql-toolbar{color:#999!important;background-color:transparent!important}.bili-note .ql-toolbar .readonly-mask{background-color:#000!important;opacity:.4!important}.bili-note .ql-toolbar .ql-stroke{stroke:#999!important}.bili-note .ql-toolbar .ql-picker{color:inherit!important}.bili-note .ql-toolbar .ql-picker-label.ql-active,.bili-note .ql-toolbar .ql-picker-label:hover{color:var(--theme-color)!important}.bili-note .ql-toolbar .ql-picker-label:hover .ql-stroke{stroke:var(--theme-color)!important}.bili-note .ql-toolbar .ql-picker-label:hover .ql-fill{fill:var(--theme-color)!important}.bili-note .ql-toolbar .ql-picker-options{background-color:transparent!important;color:#aaa!important}.bili-note .ql-toolbar .ql-picker-item.ql-selected,.bili-note .ql-toolbar .ql-picker-item:hover,.bili-note .ql-toolbar button.ql-active,.bili-note .ql-toolbar button:hover{color:var(--theme-color)!important}.bili-note .ql-toolbar .ql-tag{background-color:var(--theme-color)!important}.bili-note .ql-toolbar .edit-btn{border-color:var(--theme-color)!important;color:var(--theme-color)!important}.bili-note .ql-toolbar .edit-btn.save-edit{color:#eee!important;background-color:var(--theme-color)!important}.bili-note .ql-toolbar button{color:#999!important}.bili-note .editor-innter{color:#eee!important;border-color:transparent!important;background-color:#222!important}.bili-note .editor-innter .ql-tag-blot .time-tag-item{background-color:#333!important;border-color:transparent!important;color:var(--theme-color)!important}.bili-note .editor-innter .ql-tag-blot .time-tag-item .time-tag-item__text::before{background-color:var(--theme-color)!important}.bili-note .editor-innter .ql-image-preview{box-shadow:0 2px 8px 0 rgba(38,38,38,.5)!important;border-color:transparent!important}.bili-note .editor-innter .ql-image-preview .img-preview{border-color:#333!important}.modalBox{color:#eee!important;background-color:#444!important}.modalBox .cancel{color:#eee!important;border-color:transparent!important;background-color:#666!important}.member-container .up-info .attention,.modalBox .sure,.wide-members .avatar-list .van-icon-general_addto_s{background-color:var(--theme-color)!important}.be-dropdown-item:hover{color:var(--theme-color)!important}.fav-main .album-card .btn{color:#eee!important;border-color:transparent!important;background-color:#222!important}.pugv-item .item-infos .main-title{color:#eee!important}.bilibili-player-popup-area .bilibili-player-video-popup-follow{background-color:#444!important}.bilibili-player-popup-area .bilibili-player-video-popup-follow:not(.bilibili-player-video-popup-followed){background-color:var(--theme-color)!important}.bilibili-player-popup-area .bilibili-player-video-popup-active svg,.bilibili-player-popup-area path[fill]{fill:var(--theme-color)!important}.bilibili-player-popup-area path[stroke]{stroke:var(--theme-color)!important}.is-max .percentage-bar{background-color:var(--theme-color-40)!important}.vote-options .checked{filter:var(--pink-image-filter)!important}.article-tab .article-list .list-item .fold-box:hover{color:var(--theme-color)!important}.header-video-card .video-info .line-1{color:#eee!important}.van-popper .level-content .level-intro{color:#eee!important;background-color:#333!important}.van-popper .level-content .level-intro__link{color:var(--theme-color)!important}.van-popper .level-content .level-intro__link svg{fill:var(--theme-color)!important}.van-popper .logout span{color:#eee!important}.list-item.active,.list-item:hover,.van-popper .logout span:hover{background-color:#333!important}#bili-icon_dingdao_yingbi path{fill:var(--theme-color)!important}.player-auxiliary-playlist-item:hover .player-auxiliary-playlist-item-title{color:var(--theme-color)!important}.gift-panel-box{border-color:transparent!important}.gift-panel-box .gift-tab.active .name{border-bottom-color:var(--theme-color)!important;color:var(--theme-color)!important}.gift-panel-box .gift-tab .name{border-bottom-color:#aaa!important}.gift-panel-box .gift-reveal-header{border-bottom-color:#666!important}#app .container .question{color:#eee!important}.music-home .tabs{border-bottom-color:#666!important}.music-home .tabs a.active{color:var(--theme-color)!important;border-bottom-color:var(--theme-color)!important}.music-home .search-bar{border-color:#666!important}.music-home .search-bar input,.music-home .select-type{color:#eee!important}.music-home .select-type li{background-color:#333!important}.music-home .select-type li.on{background-color:var(--theme-color)!important}.music-home .select-type .toggle{border-color:transparent!important;background-color:#333!important}.music-home .exchange-btn i{color:#eee!important}.music-video .tabs{border-bottom-color:#666!important}.music-video .tabs a.active{color:var(--theme-color)!important;border-bottom-color:var(--theme-color)!important}.music-video .search-bar{border-color:#666!important}.music-video .search-bar input,.music-video .select-type{color:#eee!important}.music-video .select-type li{background-color:#333!important}.music-video .select-type li.on{background-color:var(--theme-color)!important}.music-video .select-type .toggle{border-color:transparent!important;background-color:#333!important}.music-video .music-pagination a,.music-video .music-pagination span{color:#eee!important;border-color:transparent!important;background-color:#333!important}.music-video .music-pagination .current,.music-video .music-pagination a:hover,.music-video .music-pagination span:hover{background-color:var(--theme-color)!important}.music-article .tabs{border-bottom-color:#666!important}.music-article .tabs a.active{color:var(--theme-color)!important;border-bottom-color:var(--theme-color)!important}.music-article .search-bar{border-color:#666!important}.music-article .search-bar input,.music-article .select-type{color:#eee!important}.music-article .select-type li{background-color:#333!important}.music-article .select-type li.on{background-color:var(--theme-color)!important}.music-article .select-type .toggle{border-color:transparent!important;background-color:#333!important}.music-article .music-pagination a,.music-article .music-pagination span{color:#eee!important;border-color:transparent!important;background-color:#333!important}.music-article .music-pagination .current,.music-article .music-pagination a:hover,.music-article .music-pagination span:hover{background-color:var(--theme-color)!important}.music-article .article-card{border-bottom-color:#666!important}.music-article .article-card .l-con:hover h2{color:var(--theme-color)!important}.music-search .tabs{border-bottom-color:#666!important}.music-search .tabs a.active .name{color:var(--theme-color)!important;border-bottom-color:var(--theme-color)!important}.music-search .tabs a:hover .name{color:var(--theme-color)!important}.music-search .search-bar{border-color:#666!important}.music-search .search-bar input,.music-search .select-type{color:#eee!important}.music-search .select-type li{background-color:#333!important}.music-search .select-type li.on{background-color:var(--theme-color)!important}.music-search .select-type .toggle{border-color:transparent!important;background-color:#333!important}.music-search .music-pagination a,.music-search .music-pagination span{color:#eee!important;border-color:transparent!important;background-color:#333!important}.music-search .music-pagination .current,.music-search .music-pagination a:hover,.music-search .music-pagination span:hover{background-color:var(--theme-color)!important}.music-search .exchange-btn i{color:#eee!important}.topic-list .back-top{border-color:transparent!important;background-color:#333!important}.topic-list .back-top:hover{background-color:var(--theme-color)!important}.active-list .back-top{border-color:transparent!important;background-color:#333!important}.active-list .back-top:hover{background-color:var(--theme-color)!important}.vp-container{border-bottom-color:#444!important}.bb-comment .reply-notice .notice-item{background-color:var(--theme-color)!important}.video-page-card .card-box .info .title:hover{color:var(--theme-color)!important}.bilibili-player-video-interactive-list .small.hover circle{fill:var(--theme-color)!important}.control-panel-ctnr{background-color:#444!important}.control-panel-ctnr .chat-input-ctnr{border-color:#333!important;background-color:#222!important}.control-panel-ctnr .chat-input-ctnr.chat-input-focus{border-color:var(--theme-color)!important}.control-panel-ctnr .chat-input-ctnr .medal-section{border-color:#333!important}.control-panel-ctnr .chat-input-ctnr .medal-section.focus-textarea{border-color:var(--theme-color)!important}.control-panel-ctnr .control-panel-icon-row .icon-item.danmu-block-icon{fill:#eee!important}.control-panel-ctnr .control-panel-icon-row .icon-item.active,.control-panel-ctnr .control-panel-icon-row .icon-item:hover{fill:var(--theme-color)!important}#control-panel-ctnr-box{background-image:none!important}.live-web-player-controller .danmaku .handle,.live-web-player-controller .horizontal-slider-wrap .slider-handle,.live-web-player-controller .horizontal-slider-wrap .slider-track,.live-web-player-controller .vertical-slider-wrap .slider-handle,.live-web-player-controller .vertical-slider-wrap .slider-track{background-color:var(--theme-color)!important}.live-web-player-controller .quality-wrap .quality-it.selected{color:var(--theme-color)!important}.live-web-player-controller input[type=radio]:checked+label::before{background-color:var(--theme-color)!important;border-color:var(--theme-color)!important}.bilibili-player-drag-mask-progress .bilibili-player-drag-mask-progress-tempo{background-color:var(--theme-color)!important}#eplist_module .list-wrapper.detail .ep-item{background-color:transparent!important}#eplist_module .list-wrapper.detail .ep-item:hover .ep-title{color:var(--theme-color)!important}.list-wrapper .ep-item.visited:not(.cursor){color:#aaa!important}.bp-popup-panel #editor{background-color:#333!important;color:#eee!important}.bp-popup-panel .publish-btn{background-color:var(--theme-color)!important}.article-action .more .more-ops-list ul li:hover{color:var(--theme-color)!important}.bilibili-player-context-menu-container ul>li a{color:#eee!important}.bilibili-player-context-menu-container ul>li a:hover{background-color:transparent!important}.coin-dialog-mask .like-checkbox{color:#eee!important}.coin-dialog-mask .like-checkbox i{filter:var(--blue-image-filter)!important}.international-home .rcmd-box-wrap .change-btn{border-color:transparent!important;color:#eee!important;background-color:#444!important}.international-home .rcmd-box-wrap .change-btn:hover{background-color:var(--theme-color)!important}.bangumi-options .opt-list li{background-color:#333!important;color:#eee!important}.bangumi-options .opt-list li:hover{color:var(--theme-color)!important;background-color:#444!important}.bangumi-options .opt-list li.disabled{color:#aaa!important;background-color:transparent!important}.emoji-tab-slider .next,.emoji-tab-slider .prev{filter:invert(1)}.van-popper-login .container{border-color:#444!important}.dynamic-link-hover-bg .bp-img-icon{filter:var(--blue-image-filter)!important}.bp-right .confirm-container{background-color:#444!important}.bp-right .confirm-container .content-text{color:#eee!important}.bp-right .confirm-container .msg-group{border-color:#aaa!important}.bp-right .confirm-container .msg-group .msg-input{color:#eee!important}.bp-right .confirm-container .msg-group .msg-input::placeholder{color:#aaa!important}.bp-right .confirm-container .msg-group .msg-btn{color:#eee!important}.bp-right .confirm-container .msg-group .msg-btn::before{background-color:#aaa!important}.bp-right .confirm-container .msg-group .msg-btn.msg-btn-unable{color:#aaa!important}.bp-right .confirm-container .btn-group .btn-common{border-color:var(--theme-color)!important;color:var(--theme-color)!important;background-color:#444!important}.bp-right .confirm-container .btn-group .btn-active{background-color:var(--theme-color)!important}.rcmd-list .rcmd-list-title,.rcmd-list .remd-video-card .title{color:#eee!important}.bilibili-player .bui-button.bui-button-border:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.van-popover.van-followed .follow_dropdown li{color:#eee!important}.van-popover.van-followed .follow_dropdown li:hover{color:var(--theme-color)!important;background-color:#444!important}.filter-wrap .filter-wrap_bottom,.recommend-list .split-line{background-color:#444!important}#app .collection-m .add-group .input-group .submit{background-color:var(--theme-color-20)!important;border-left-color:var(--theme-color)!important}.b-info .balance-name,.shop-desc .desc-box .sub-title.reserve span.highlight{color:var(--theme-color)!important}.bilibili-player-video-state-buff-icon path[fill="rgb(0,161,214)"]{fill:var(--theme-color)!important}.bilibili-player-video-state-buff-icon path[stroke="rgb(0,161,214)"]{stroke:var(--theme-color)!important}.b-head-search{border-color:#444!important}.b-head-search.input-active{border-color:var(--theme-color)!important}.b-head-search .b-head-search_input{background-color:transparent!important;color:#eee!important}.b-head-search .search-icon,.b-head-search .show-icon,.multi-page .cur-list .list-box li .link-content img{filter:var(--blue-image-filter)!important}.next-button .switch-button.on{background-color:var(--theme-color)!important;border-color:var(--theme-color)!important}.video-sections{background-color:#444!important}.video-sections-head_first-line .first-line-left span:not(.cur-page){color:#eee!important}.video-sections-head_second-line .second-line_right{border-color:var(--theme-color)!important;background-color:#444!important;color:var(--theme-color)!important}.video-sections-head_second-line .second-line_right.already-fav{background-color:#666!important;color:#999!important}.video-sections-head_desc{background-color:#666!important;color:#eee!important}.video-sections-head .border-bottom-line{background-color:#666!important}.video-sections-content-list .video-sections-item{border-bottom-color:#666!important}.video-sections-content-list .video-section-title{background-color:#444!important}.video-sections-content-list .video-section-list .video-episode-card__info-title,.video-sections-content-list .video-section-title span{color:#eee!important}.video-sections-content-list .video-section-list .video-episode-card__info-title-playing{color:var(--theme-color)!important}.video-sections-content-list .video-section-list .video-episode-card__info-title-playing .cur-play-icon{filter:var(--blue-image-filter)!important}#page-fav .favList-info .shadow-first{background-color:#222!important}#page-fav .favList-info .shadow-second{background-color:#333!important}#page-fav .favList-info .collection-details .title .iconfont{color:#aaa!important}#page-fav .favList-info .collection-details .collection-btn{background-color:var(--theme-color)!important;color:#eee!important}.international-header .user-con.signin .item .notify-float .float_msg,.international-header .user-con.signin .item .notify-float::before{background-color:#444!important}.international-header .user-con.signin .item .notify-float .float_msg div{color:#eee!important}.international-header .user-con.signin .item .notify-float .float_msg div span{color:var(--theme-color)!important}.container .left-container .play-up-info .play-up-intro .play-up-cover-loading,.container .left-container .play-up-info .play-up-intro .play-up-introduction-loading p{background-color:#444!important}.container .left-container .play-up-info .play-up-self .play-up-self-content a{color:var(--theme-color)!important}.player-auxiliary{background-color:transparent!important}.player-auxiliary-btn-playlist-order:hover path{stroke:var(--theme-color)!important}.player-auxiliary-playlist-item-img{background-image:none!important}.player-auxiliary-playlist-item.player-auxiliary-playlist-item-active .player-auxiliary-playlist-item-title-prefix,.player-auxiliary-viewpointlist-item.active .player-auxiliary-viewpointlist-item-title-prefix{filter:var(--blue-image-filter)!important}.player-auxiliary-area .player-auxiliary-collapse-viewpointlist{background-color:#444!important}.player-auxiliary-viewpointlist{background-color:#333!important}.player-auxiliary-viewpointlist-content{color:#eee!important}.player-auxiliary-viewpointlist-item.active .player-auxiliary-viewpointlist-content,.player-auxiliary-viewpointlist-item:hover .player-auxiliary-viewpointlist-content{color:var(--theme-color)!important}.remd-video-card .card-box .pic-box{background-color:#444!important}.next-button .switch-button{border-color:#666!important;background-color:#666!important}.video-info .video-title .tit{color:#eee!important}a.c-pointer[style*="color: rgb(251, 114, 153)"],a.name[style*="color: #FB7299"],a.name[style*="color: rgb(251, 114, 153)"],a.name[style*="color:#FB7299"],a.username.is_vip[style*="color:#FB7299"]{color:#fb7299!important}.bili-search .video-item.list{border-bottom-color:#444!important}.bili-search .video-item.list .headline .type{border-color:transparent!important;background-color:#444!important;color:#eee!important}.bili-search .video-item.list .headline .title{color:#eee!important}.bili-search .video-item.list .headline .title:hover{color:var(--theme-color)!important}.bili-search .video-item.list .des,.main-container .tool-bar .watch-info>span{color:#aaa!important}.main-container .tool-bar .watch-info #watch-together-icon-1{fill:#aaa!important}.main-container .tool-bar .watch-info:hover>span{color:var(--theme-color)!important}.main-container .tool-bar .watch-info:hover #watch-together-icon-1{fill:var(--theme-color)!important}.main-container .tool-bar .watch-info .watch-more{box-shadow:none!important;background-color:#444!important;border-color:transparent!important}.main-container .tool-bar .watch-info .watch-more .title{color:#eee!important}.error-container .error-404 img{filter:var(--blue-image-filter)!important}.popular-video-container .back-top-btn{border-color:transparent!important;background-color:#333!important}.popular-video-container .back-top-btn .arrow-icon{color:#aaa!important}.popular-video-container .back-top-btn:hover{background-color:var(--theme-color)!important}.popular-video-container .back-top-btn:hover .arrow-icon{color:var(--foreground-color)!important}.m-layer .b-btn-cancel{color:#eee!important}.m-layer .b-btn-cancel:hover{color:var(--theme-color)!important}.follow-btn.followed{border-color:transparent!important;background-color:#444!important;color:#aaa!important}#article-list-index .index-holder .article-item:not(.on) .point{background-color:#666!important}#article-list-index .index-holder .article-item .title{color:#eee!important}#article-list-index .index-holder .article-item .title:hover{color:var(--theme-color)!important}.main-container .bottom-brief-introduction{background-color:#222!important}.fullscreen-loading .tv-bg+.container{background-color:transparent!important}.fullscreen-loading .tv-bg+.container .retry-btn{background-color:var(--theme-color)!important}[style*="color: #00A1D6"]{color:var(--theme-color)!important}.main-show-c .film-change-page .search .append{background-color:var(--theme-color)!important}.main-show-c .film-change-page .list-container .season-item .change-btn{border-color:var(--theme-color)!important;color:var(--theme-color)!important}.main-show-c .film-change-page .list-container .season-item .change-btn:hover{background-color:var(--theme-color)!important;color:#fff!important}.main-show-c .plp-r .tab .title-active{color:var(--theme-color)!important}.main-show-c .plp-r .chat-container .user-guide .top-c .l .switch-c.checked{background-color:var(--theme-color)!important}.main-show-c .plp-r .chat-container .user-guide .top-c .r:hover{color:var(--theme-color)!important}.main-show-c .plp-r .chat-container .user-guide .top-c .r:hover svg g g{fill:var(--theme-color)!important}.main-show-c .plp-r .chat-container .user-guide .user-share,.main-show-c .plp-r .chat-container .user-guide .user-share .share-content{background-color:#222!important}.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .left .share-btn:hover i,.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .left .share-btn:hover span{color:var(--theme-color)!important}.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .left .copy-action .copy-title,.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .left .share-btn i,.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .left .share-btn span{color:#aaa!important}.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .left .copy-action input[type=text]{background-color:transparent!important;color:#eee!important;border-color:#444!important}.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .left .copy-action .copy-btn{background-color:var(--theme-color)!important}.main-show-c .plp-r .chat-container .user-guide .user-share .share-content .right ::after{background-color:#666!important}.main-show-c .plp-r .chat-container .input-area .text-c{caret-color:var(--theme-color)!important}.main-show-c .plp-r .chat-container .input-area .input-c.border{border-color:var(--theme-color)!important}.main-show-c .plp-r .chat-container .static-popup{border-color:transparent!important;background-color:#444!important}.main-show-c .plp-r .chat-container .static-popup .emoji{background-color:#444!important}.main-show-c .plp-r .chat-container .static-popup .emoji:hover{background-color:#222!important}.main-show-c .plp-r .play-list .header .change-film{background-color:var(--theme-color)!important}.main-show-c .plp-r .play-list .other-item .current-play{filter:var(--blue-image-filter)!important}#user-card-container{border-color:var(--theme-color)!important;background-color:#444!important}#user-card-container .face-cc{border-color:#444!important}#user-card-container .info .name.vip-red-name{color:#fb7299!important}.dialog-base-wrapper .popup-content .ogv-dialog-confirm{background-color:#444!important}.dialog-base-wrapper .popup-content .ogv-dialog-confirm .close .icon:hover{color:var(--theme-color)!important}.dialog-base-wrapper .popup-content .ogv-dialog-confirm .close .icon:hover svg path{fill:var(--theme-color)!important}.dialog-base-wrapper .popup-content .ogv-dialog-confirm .title{border-bottom-color:#666!important}.dialog-base-wrapper .popup-content .ogv-dialog-confirm .short-msg .content{color:#aaa!important}.dialog-base-wrapper .popup-content .ogv-dialog-confirm .bottom-oper .btn.cancel{border-color:transparent!important;background-color:#666!important;color:#eee!important}.dialog-base-wrapper .popup-content .ogv-dialog-confirm .bottom-oper .btn.submit{background-color:var(--theme-color)!important}.bb-comment .stick.up{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.bb-comment .comment-emoji{box-shadow:none!important}.bb-comment .comment-send-lite{background-color:#222!important}.bb-comment .loading-state{color:#aaa!important}.emoji-box.top:after{background-image:none!important}.video-desc .desc-info{color:#eee!important}.video-desc .desc-info+.toggle-btn{color:#aaa!important}.video-desc .desc-info a,.video-desc .desc-info+.toggle-btn:hover{color:var(--theme-color)!important}body:not(.simplify-comment) .bb-comment .comment-send-lite{background-color:#222!important}body:not(.simplify-comment) .bb-comment .comment-list .list-item .info .hate.hated i,body:not(.simplify-comment) .bb-comment .comment-list .list-item .info .hate.hated:hover i,body:not(.simplify-comment) .bb-comment .comment-list .list-item .info .hate:hover i,body:not(.simplify-comment) .bb-comment .comment-list .list-item .info .like.liked i,body:not(.simplify-comment) .bb-comment .comment-list .list-item .info .like.liked:hover i,body:not(.simplify-comment) .bb-comment .comment-list .list-item .info .like:hover i{filter:var(--blue-image-filter)!important}body:not(.simplify-comment) .panel-area .bb-comment .comment-send-lite{background-color:#444!important}.toolbar-box .at-icon:hover,.toolbar-box .emoji-btn.active,.toolbar-box .emoji-btn:hover,.toolbar-box .icon-schedule.active,.toolbar-box .icon-schedule:hover,.toolbar-box .icon-topic:hover,.toolbar-box .icon-vote.active,.toolbar-box .icon-vote:hover,.toolbar-box .pic-box.active,.toolbar-box .pic-box:hover{filter:var(--blue-image-filter)!important}.toolbar-box .static-popup .bp-arrow{background:0 0!important}.article-detail .normal-article-holder{color:#eee!important}.article-detail .card-image{background-color:#333!important}.article-detail .fixed-top-header{background-color:#222!important;color:#aaa!important}.article-detail .article-breadcrumb a,.article-detail .article-breadcrumb span,.article-detail .fixed-top-header .inner .inner-right>.up-info,.article-detail .fixed-top-header .inner .inner-title{color:#eee!important}.article-detail .article-breadcrumb a:hover{color:var(--theme-color)!important}.article-detail .article-container{background-color:#282828!important}.article-detail .article-container .article-container__content{border-color:#444!important}.article-detail .article-container .article-read-info a{color:#aaa!important}.article-detail .article-container .article-read-info a:hover{color:var(--theme-color)!important}.article-detail .article-container .article-read-info span{color:#aaa!important}.article-detail .article-container .article-up-info,.article-detail .article-container .article-up-info .nameplate-card{background-color:transparent!important}.article-detail .article-container .article-up-info .nameplate-ctnr{background-color:#333!important;border-color:transparent!important}.article-detail .article-container .article-up-info .nameplate-ctnr .info{border-color:#444!important}.article-detail .article-container .article-up-info .nameplate-ctnr .info .n-type{color:#aaa!important}.article-detail .article-container .article-up-info .nameplate-ctnr .info .info-bottom a,.article-detail .article-container .article-up-info .nameplate-ctnr .info .info-bottom a:hover{color:var(--theme-color)!important}.article-detail .article-container .banner-container>a>.info>.title{color:#eee!important}.article-detail .article-container .title-container>.article-read-panel>.article-read-info>span.spoiler{background-color:#2a2a2a!important}.article-detail .article-container .read-article-holder .color-default,.article-detail .article-container .read-article-holder h1,.article-detail .article-container .read-article-holder h2,.article-detail .article-container .read-article-holder h3,.article-detail .article-container .read-article-holder h4,.article-detail .article-container .read-article-holder h5,.article-detail .article-container .read-article-holder h6,.article-detail .article-container .read-article-holder p{color:#eee!important}.article-detail .article-container .read-article-holder a,.article-detail .article-container .read-article-holder a:active,.article-detail .article-container .read-article-holder a:hover{color:var(--theme-color)!important}.article-detail .article-container .read-article-holder a:active[disabled],.article-detail .article-container .read-article-holder a:hover[disabled],.article-detail .article-container .read-article-holder a[disabled]{color:#999!important}.article-detail .article-container .read-article-holder [class*=color-][class*="-03"]{filter:brightness(1.2)!important}.article-detail .article-container .read-article-holder [class*=color-][class*="-04"]{filter:brightness(1.3333333333)!important}.article-detail .article-container .read-article-holder [class*=color-] [class*=color-]{filter:brightness(1)!important}.article-detail .article-container .read-article-holder caption{color:#aaa!important}.article-detail .article-container .read-article-holder .default-cover{background-color:#333!important;color:#aaa!important}.article-detail .article-container .read-article-holder .card-container .row-video-holder{border-color:transparent!important;background-color:#333!important}.article-detail .article-container .read-article-holder .card-container .row-video-holder .row-video-tit{color:#eee!important}.article-detail .article-container .read-article-holder .card-container .row-video-holder .row-video-infos,.article-detail .article-container .read-article-holder .card-container .row-video-holder .up-icon{color:#aaa!important}.article-detail .article-container .read-article-holder .card-container .row-video-holder .card-text-label{border-color:var(--theme-color)!important;color:var(--theme-color)!important}.article-detail .article-container .read-article-holder .card-container .row-video-holder:hover .row-video-tit{color:var(--theme-color)!important}.article-detail .article-container .article-footer-box .footer-text{color:#eee!important}.article-detail .article-container .article-footer-box .article-tags .iconfont,.article-detail .article-container .article-footer-box .article-tags .tag-item,.article-detail .article-container .interaction-info .share-box,.article-detail .article-container .interaction-info .share-box .share-item i{color:#aaa!important}.article-detail .article-container .interaction-info .share-box .share-item i:hover{color:var(--theme-color)!important}.article-detail .article-container .interaction-info .advice-item{color:#aaa!important}.article-detail .article-container .interaction-info .advice-item:hover{color:var(--theme-color)!important}.article-detail .recommend-list{background-color:#282828!important}.article-detail .recommend-list .recommend-header{border-color:#444!important}.article-detail .recommend-list .recommend-header .title{color:#eee!important}.article-detail .recommend-list .recommend-header .more{background-color:transparent!important;color:#eee!important}.article-detail .recommend-list .recommend-header .more:hover{color:var(--theme-color)!important}.article-detail .recommend-list .article-item{border-color:#444!important}.article-detail .recommend-list .article-item .article-desc,.article-detail .recommend-list .article-item .article-info,.article-detail .recommend-list .article-item .article-info--up,.article-detail .recommend-list .article-item .stats-categroy{color:#aaa!important}.article-detail .recommend-list .article-item .article-info--up:hover,.article-detail .recommend-list .article-item .stats-categroy:hover{color:var(--theme-color)!important}.article-detail .comment-wrapper>.comment-m{background-color:transparent!important}.z-top-container{background-color:#333!important}.coin-dialog-wrapper{background-color:#222!important}.coin-dialog-wrapper .van-icon-guanbi{color:#aaa!important}.coin-dialog-wrapper .coin-title{color:#eee!important}.coin-dialog-wrapper .coin-bottom .tips{color:#aaa!important}.coin-dialog-wrapper .coin-card-box{background-color:#fff!important}.right-side-bar .catalog{background-color:#333!important;color:#eee!important}.right-side-bar .catalog:hover .catalog-text,.right-side-bar .catalog:hover .iconfont{color:var(--theme-color)!important}.right-side-bar .catalog:hover::after{background-color:transparent!important}.right-side-bar .catalog .catalog-panel{background-color:#333!important;box-shadow:none!important}.right-side-bar .catalog .catalog-panel .catalog-panel__info,.right-side-bar .catalog .catalog-panel .catalog-panel__title{color:#eee!important}.right-side-bar .catalog .catalog-panel .catalog-panel__info:hover{color:var(--theme-color)!important}.right-side-bar .catalog .catalog-panel .catalog-item:hover{background-color:#292929!important}.right-side-bar .catalog .catalog-panel .catalog-item .item-ul{background-color:#eee!important}.right-side-bar .catalog .catalog-panel .catalog-item .catalog-item__text{color:#eee!important}.right-side-bar .catalog .catalog-panel .catalog-item .iconfont,.right-side-bar .catalog .catalog-panel .catalog-item.catalog-item--on .catalog-item__text,.right-side-bar .catalog .catalog-panel .catalog-item:hover .catalog-item__text{color:var(--theme-color)!important}.right-side-bar .to-top{background-color:#333!important}.right-side-bar .to-top .iconfont{color:#eee!important}.right-side-bar .to-top:hover{background-color:#333!important}.right-side-bar .to-top:hover .iconfont{color:var(--theme-color)!important}.right-side-bar .side-toolbar{background-color:#333!important}.right-side-bar .side-toolbar .toolbar-item,.right-side-bar .side-toolbar .toolbar-item .iconfont{color:#eee!important}.right-side-bar .side-toolbar .toolbar-item.toolbar-on,.right-side-bar .side-toolbar .toolbar-item.toolbar-on .iconfont,.right-side-bar .side-toolbar .toolbar-item.toolbar-on .iconfont .toolbar-item__num,.right-side-bar .side-toolbar .toolbar-item.toolbar-on .toolbar-item__num,.right-side-bar .side-toolbar .toolbar-item:hover,.right-side-bar .side-toolbar .toolbar-item:hover .iconfont,.right-side-bar .side-toolbar .toolbar-item:hover .iconfont .toolbar-item__num,.right-side-bar .side-toolbar .toolbar-item:hover .toolbar-item__num{color:var(--theme-color)!important}.right-side-bar .side-toolbar .toolbar-item canvas{filter:var(--blue-image-filter)!important}.bui-precision-slider .bui-track .bui-schedule-wrap .bui-schedule-current{background-color:var(--theme-color)!important}.bl-audio-panel-left-show-more:hover,.bl-audio-panel-right-return:hover{color:var(--theme-color)!important}.bl-audio-panel-preset-btn.bl-audio-active{background-color:var(--theme-color)!important}.link-navbar .main-ctnr .nav-items-ctnr.over-width{background-color:#333!important}.content-scorller-inner .living-icon-col{background-color:var(--theme-color)!important}#App .rank-module .tab-bar{background-color:#222!important}#App .rank-module .tab-bar .tab-item{color:#eee!important}#App .rank-module .tab-bar .tab-item:hover{color:var(--theme-color)!important}#App .rank-module .tab-bar .tab-item.on{border-color:var(--theme-color)!important;color:var(--theme-color)!important}#App .rank-module .tips{background-color:#333!important;color:#aaa!important}#App .rank-module .article-list .article-item .item-holder{background-color:#222!important}#App .rank-module .article-list .article-item .item-holder .article-content .article-title:hover,#App .rank-module .article-list .article-item .item-holder .score-module .score{color:var(--theme-color)!important}#App .rank-module .article-list .article-item .item-holder .article-content .article-left-block .article-info-bar .reply:hover{color:var(--theme-color)!important;background-color:transparent!important}#page-channel-detail .paly-all-btn,#page-index .channel .section-right-options .play-all-channel,#page-index .video .section-title .play-all-channel,#page-video .play-all-btn{background-color:#333!important;color:#eee!important;border-color:#333!important}#page-channel-detail .paly-all-btn:hover,#page-index .channel .section-right-options .play-all-channel:hover,#page-index .video .section-title .play-all-channel:hover,#page-video .play-all-btn:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}#page-channel-detail .paly-all-btn:hover .video-commonplayer_play,#page-index .channel .section-right-options .play-all-channel:hover .video-commonplayer_play,#page-index .video .section-title .play-all-channel:hover .video-commonplayer_play,#page-video .play-all-btn:hover .video-commonplayer_play{color:var(--theme-color)!important}.bilibili-player-video-info-tips path{stroke:#aaa!important;fill:#aaa!important}.bilibili-player-video-info-tips circle{stroke:#aaa!important}.shop-desc .desc-box .prize-text{color:var(--theme-color)!important}.shop-desc .desc-box .prize-text::before{border-color:var(--theme-color)!important}.subscribe-list li .subscribe-title{color:#eee!important}.subscribe-list li .subscribe-tips{color:#aaa!important}.subscribe-list li .btn-subscribe{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#page-dynamic .col-2 .section-title{border-color:#555!important}.msg-notify .modules .module .detail{color:#aaa!important}.msg-notify .notifier .name{color:#eee!important}.msg-notify .notifier:hover>{color:var(--theme-color)!important}.auto-reply-push{background-color:#222!important}.auto-reply-push .ar-recommend-item__info--title,.auto-reply-push__desc{color:#eee!important}.auto-reply-push .ar-recommend-item__info--desc .time{color:#aaa!important}.bui-progress-bar,.bui-progress-bar .bui-progress-dot,.bui-progress-bar::before{background-color:var(--theme-color)!important}#page-404{background-color:transparent!important}#page-404 .error{color:#eee!important}#page-404 .back-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.bilibili-player-video-btn-viewpointlist *{color:#eee!important;fill:#eee!important}.hot-not-rank .hot-not-rank-text{background-color:var(--theme-color-80)!important;color:var(--foreground-color)!important}.hot-not-rank .hot-not-rank-text:hover{background-color:var(--theme-color)!important}.lottery-result__content{background-color:#222!important}.lottery-result__content .winners .winner__prize .prize-picture{border-color:#444!important}.lottery-result__content .winners .winner__prize .prize-picture.default{filter:var(--blue-image-filter)!important}.lottery-result__content .winners .winner__prize__title{color:#eee!important}.lottery-result__content .winners .winner__prize__desc{color:#aaa!important}.lottery-result__content .winners .winner__list:before{background-color:#444!important}.resizable-component .publish-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.note-list{background-color:#444!important}.note-list-header{color:#eee!important;border-color:#555!important}.note-list-nickname>a,.note-list-summary{color:#eee!important}.note-list-time{color:#aaa!important}.note-list-detail{color:var(--theme-color-80)!important}.note-list-detail:hover{color:var(--theme-color)!important}.note-list-card:not(:last-of-type){border-color:#555!important}.note-list-btn{background-color:var(--theme-color-80)!important;color:var(--foreground-color)!important}.note-list-btn:hover{background-color:var(--theme-color)!important}.bili-view-note .note-view-drag-bar{background-color:#444!important}.bili-view-note .close-btn{background-color:#333!important;color:#eee!important}.bili-view-note .close-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.bui-button .bui-button-blue,.bui-button .bui-button-blue:hover,.bui-button .bui-button-gray3:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.bpx-docker-minor,.bpx-player-auxiliary .bui-dropdown{background-color:transparent!important}.bpx-player-auxiliary .bui-dropdown .bui-dropdown-wrap{fill:#eee!important;color:#eee!important}.bpx-player-auxiliary .bui-dropdown .bui-dropdown-wrap .bui-dropdown-icon:hover,.bpx-player-auxiliary .bui-dropdown .bui-dropdown-wrap.bui-dropdown-unfold .bui-dropdown-icon{fill:var(--theme-color)!important}.bpx-player-auxiliary .bui-dropdown .bui-dropdown-items{background-color:#444!important;border-color:transparent!important}.bpx-player-auxiliary .bui-dropdown .bui-dropdown-items .bui-dropdown-item{color:#eee!important;background-color:transparent!important}.bpx-player-auxiliary .bui-dropdown .bui-dropdown-items .bui-dropdown-item:hover{color:var(--theme-color)!important;background-color:#222!important}.bpx-player-auxiliary .bpx-player-dm-load-status{background-color:transparent!important;color:#aaa!important}.bpx-player-auxiliary .bpx-player-collapse .bui-collapse-body{background-color:#333!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-function{background-color:transparent!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-function>*{color:#eee!important;background-color:transparent!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap{background-color:transparent!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap .dm-info-row{color:#aaa!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap .dm-info-row .dm-info-dm{color:#eee!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap .dm-info-row .dm-info-block-btn,.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap .dm-info-row .dm-info-report-btn{background-color:#555!important;border-color:transparent!important;color:#eee!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap .dm-info-row .dm-info-block-btn:hover,.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap .dm-info-row .dm-info-report-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-wrap .bui-long-list-item-selected .dm-info-row{background-color:#444!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-btn-footer{background-color:transparent!important}.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-btn-footer .bpx-player-dm-btn-history,.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-btn-footer .bpx-player-dm-btn-history.bpx-player-disable,.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-btn-footer .bpx-player-dm-btn-history.bpx-player-disable:hover{background-color:#444!important;color:#aaa!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-label,.bpx-player-auxiliary .bpx-player-collapse .bpx-player-dm-btn-footer .bpx-player-dm-btn-history:hover{color:#eee!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-sync-btn{color:var(--theme-color)!important;fill:var(--theme-color)!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-add-input{border-color:#666!important;color:#eee!important;background-color:#444!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-add-input:focus-within{border-color:var(--theme-color)!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-add-btn,.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-add-btn .bui-area{border-color:transparent!important;background-color:#444!important;color:#eee!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-add-btn .bui-area:hover,.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-add-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-list{background-color:#222!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-list .bpx-player-block-list-function{color:#aaa!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-list .bpx-player-state-list-wrap>*{color:#aaa!important;fill:#aaa!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-list .bpx-player-state-list-wrap>.bpx-player-block-list-delete:hover{color:var(--theme-color)!important;fill:var(--theme-color)!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-list .bpx-player-state-list-wrap>.bpx-player-block-list-state{color:var(--theme-color)!important}.bpx-player-auxiliary .bpx-player-block-area .bpx-player-block-list .bpx-player-block-list-line{color:#eee!important;background-color:transparent!important}.bpx-player-auxiliary .bpx-player-contextmenu{background-color:#333!important;border-color:transparent!important;box-shadow:0 0 5px #222!important}.bpx-player-auxiliary .bpx-player-contextmenu>li{color:#eee!important}.bpx-player-auxiliary .bpx-player-contextmenu>li:hover{background-color:#444!important}.bpx-player-auxiliary .bpx-player-adv-danmaku,.bpx-player-auxiliary .bpx-player-setting{background-color:transparent!important}.bpx-player-auxiliary .bpx-player-adv-danmaku-panel{border-color:transparent!important}.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-group{border-color:#444!important}.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-group .bpx-player-adv-danmaku-title{color:#eee!important}.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-btn,.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-btn .bui-area{background-color:#444!important;color:#eee!important}.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-btn .bui-area.active,.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-btn .bui-area:hover,.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-btn.active,.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.bpx-player-auxiliary .bpx-player-adv-danmaku-panel .bpx-player-adv-danmaku-pos-title,.ep-list-wrapper .ep-item a,.section-ep-wrapper .ep-item a{color:#eee!important}.bpx-player-container{box-shadow:0 4px 8px 0 #0004!important}.bpx-player-container .squirtle-controller .squirtle-high-energy{filter:var(--blue-image-filter)!important}.bpx-player-container .squirtle-controller .squirtle-progress-timeline{background-color:var(--theme-color)!important}.bpx-player-container .bpx-player-sending-area::before,.bpx-player-container .bpx-player-sending-bar{background-color:transparent!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-dm-setting:hover,.bpx-player-container .bpx-player-sending-bar .bpx-player-video-btn-dm:hover{fill:var(--theme-color)!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-dm-input{color:#eee!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-block-filter-type.bpx-player-active>*{color:var(--theme-color)!important;fill:var(--theme-color)!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-mode-selection-container .selection-span.active,.bpx-player-container .bpx-player-sending-bar .bpx-player-mode-selection-container .selection-span.active:hover{fill:var(--theme-color)!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-video-inputbar{background-color:rgba(255,255,255,.06667)!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-video-inputbar .bpx-player-video-inputbar-wrap{border-color:transparent!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-video-inputbar .bpx-player-video-inputbar-wrap .bpx-player-dm-wrap a,.bpx-player-container .bpx-player-sending-bar .bpx-player-video-inputbar .bpx-player-video-inputbar-wrap .bpx-player-dm-wrap a:hover{color:var(--theme-color)!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-video-inputbar .bpx-player-video-inputbar-wrap .bpx-player-dm-hint a{color:#aaa!important;fill:#aaa!important}.bpx-player-container .bpx-player-sending-bar .bpx-player-video-inputbar .bpx-player-video-inputbar-wrap .bpx-player-dm-hint a:hover{color:var(--theme-color)!important;fill:var(--theme-color)!important}.bpx-player-container .bpx-player-video-info{color:#aaa!important}.twp-container .new-twp-btn.confirm,.twp-container .new-twp-btn.ticket,.twp-container .new-twp-btn.vip{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.twp-container .new-twp-btn.confirm .current,.twp-container .new-twp-btn.ticket .current,.twp-container .new-twp-btn.vip .current{color:var(--foreground-color)!important}.msg-push-new{background-color:#222!important}.msg-push-new .ar-recommend-item__info--title{color:#eee!important}.msg-push-new .ar-recommend-item__info--desc .time,.msg-push-new .ar-recommend-item__info--view{color:#aaa!important}.send-box .core-style{color:#eee!important}.section.user-info .user-info-title{border-color:#555!important}.section.user-info .info-title,.section.user-info .info-value,.section.user-info .tag-content{color:#eee!important}.section.user-info .iconfont,.section.user-info .info-command{color:#aaa!important}.h-notice{background-color:#333!important}.h-notice a{color:#eee!important}.h-notice svg path{fill:#eee!important}.video-info .video-data .argue{background:#312d21!important}.video-info .video-data .argue,.video-info .video-data .argue i{color:#e1a411!important}.short-review-content .review-edit-header .media-info h4{color:#eee!important}.short-review-content .review-edit-header .media-info .rate-tip{color:#aaa!important}.short-review-content .review-body-wrap{border-color:#555!important;background-color:#222!important}.short-review-content .review-body-wrap:focus-within{border-color:var(--theme-color)!important}.short-review-content .review-body-wrap textarea,.short-review-content .review-body-wrap textarea:focus-within{background-color:transparent!important;border-color:transparent!important}.short-review-content .review-body-wrap .tip{color:#aaa!important}.short-review-content .review-body-wrap .mr-btn,.short-review-content .review-body-wrap .mr-btn:active,.short-review-content .review-body-wrap .mr-btn:hover{color:var(--foreground-color)!important;background-color:var(--theme-color)!important;border-color:transparent!important}.fans-medal-dialog{background-color:#222!important}.fans-medal-dialog .van-dialog__title{color:#eee!important}.fans-medal-dialog .van-dialog__close{color:#aaa!important}#app>#main>.container .header .name{color:#eee!important}#app>#main>.container .header .count{color:#aaa!important}#app>#main>.container .header .count span{color:var(--theme-color)!important}#app>#main>.container .list .content{border-color:#444!important;background-color:#333!important}#app>#main>.container .list .content .btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#app>#main>.container .list .content.border{border-color:var(--theme-color)!important;opacity:1!important}#app>#main>.container .list .content .info{background-image:none!important;background-color:transparent!important}#app>#main>.container .list .content .info .name,#app>#main>.container .list .content .info .num{color:#eee!important}#app>#main>.container .list .content .info .image,#app>#main>.container .list .content .info .img{filter:var(--pink-image-filter)!important}#app>#main>.container .list .content .info .limit,#app>#main>.container .list .content .info .limit .before{color:#aaa!important}#app>#main>.container .list .content .info .progress{background-color:#555!important}#app>#main>.container .list .content .info .progress .blue{background-color:var(--theme-color)!important}.container.medalList{background-color:transparent!important}.container.medalList .title .name{color:#eee!important}.container.medalList .title img{filter:var(--blue-image-filter)!important}.container.medalList .title .mount{color:#aaa!important}.container.medalList .title .button{color:var(--theme-color)!important}.container.medalList .list .content{border-color:#444!important;background-color:#333!important}.container.medalList .list .content .btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.container.medalList .list .content.border{border-color:var(--theme-color)!important;opacity:1!important}.container.medalList .list .content .info{background-image:none!important;background-color:transparent!important}.container.medalList .list .content .info .name,.container.medalList .list .content .info .num{color:#eee!important}.container.medalList .list .content .info .image,.container.medalList .list .content .info .img{filter:var(--pink-image-filter)!important}.container.medalList .list .content .info .limit,.container.medalList .list .content .info .limit .before{color:#aaa!important}.container.medalList .list .content .info .progress{background-color:#555!important}.container.medalList .list .content .info .progress .blue{background-color:var(--theme-color)!important}.ztolayer-dialog{background-color:#222!important}.ztolayer-dialog .dialog-title .title{color:var(--theme-color)!important}.ztolayer-dialog .dialog-body{color:#eee!important}.ztolayer-dialog .dialog-body .info{color:#aaa!important}.ztolayer-dialog .dialog-body .configItem .switch{filter:var(--pink-image-filter)!important}.bilibili-player-video-info-hover{background-color:#222!important}.bilibili-player-video-info-hover-num{color:#eee!important}.bilibili-player-video-info-hover-tips{color:#aaa!important}#i_cecream{background-color:transparent!important}#i_cecream .mini-header .header-entry-avatar{border-color:#333!important}#i_cecream .mini-header .default-entry,#i_cecream .mini-header .mini-header__title>span,#i_cecream .mini-header .right-entry-icon{color:#eee!important}#i_cecream .mini-header .right-entry-text{color:#aaa!important}#i_cecream .mini-header .header-upload-entry{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#i_cecream .mini-header .header-upload-entry .header-upload-entry__icon{color:var(--foreground-color)!important}#i_cecream .mini-header .header-upload-entry:hover{background-color:var(--theme-color-90)!important}#i_cecream .bili-header,#i_cecream .home-header{background-color:transparent!important}#i_cecream .bili-header__banner,#i_cecream .home-header__banner{background-color:#333!important}#i_cecream .bili-header.fixed-top .home-header__bar,#i_cecream .home-header.fixed-top .home-header__bar{background-color:#222!important}#i_cecream .bili-header__channel,#i_cecream .home-header__channel{background-color:transparent!important}#i_cecream .bili-header__channel .channel-entry-more__link,#i_cecream .bili-header__channel .channel-link,#i_cecream .home-header__channel .channel-entry-more__link,#i_cecream .home-header__channel .channel-link{color:#eee!important;background-color:#333!important;border-color:transparent!important}#i_cecream .bili-header__channel .channel-entry-more__link:hover,#i_cecream .bili-header__channel .channel-link:hover,#i_cecream .home-header__channel .channel-entry-more__link:hover,#i_cecream .home-header__channel .channel-link:hover{color:#eee!important;background-color:#555!important}#i_cecream .bili-header .channel-icons__item,#i_cecream .home-header .channel-icons__item{color:#eee!important}#i_cecream .bili-header .channel-icons .channel-notify,#i_cecream .home-header .channel-icons .channel-notify{border-color:#222!important}#i_cecream .primary-btn{color:#eee!important;background-color:#333!important;border-color:transparent!important}#i_cecream .primary-btn:hover{background-color:#555!important}#i_cecream .area-header .roll-btn,#i_cecream .area-header .title{color:#eee!important}#i_cecream .area-header .title:hover{color:var(--theme-color)!important}#i_cecream .area-header .track-switch{background-color:#333!important;color:#aaa!important}#i_cecream .area-header .track-switch .switch-bar{background-color:var(--theme-color)!important}#i_cecream .area-header .track-switch button:hover{background-color:#555!important}#i_cecream .area-header .track-switch button.is-active{color:var(--foreground-color)!important}#i_cecream :not(.aside-head)>.area-header .mouse-switch>*{color:#aaa!important;background-color:#333!important}#i_cecream :not(.aside-head)>.area-header .mouse-switch>:hover{color:#aaa!important;background-color:#555!important}#i_cecream :not(.aside-head)>.area-header .mouse-switch>.is-active{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}#i_cecream .aside-head .mouse-switch>*{color:#aaa!important}#i_cecream .aside-head .mouse-switch>.is-active{color:var(--theme-color)!important}#i_cecream .aside-head .mouse-switch>.is-active::after{background-color:var(--theme-color)!important}#i_cecream .aside-body .list-state-error,#i_cecream .aside-body .list-state-loading,#i_cecream .aside-body .list-state-nothing{background-color:#444!important}#i_cecream .aside-body .list-state-error span,#i_cecream .aside-body .list-state-loading span,#i_cecream .aside-body .list-state-nothing span{color:#aaa!important}.v-popover-content{border-color:transparent!important;background-color:#333!important}.bili-rank-list-video__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-video__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-video__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-video .rank-video-card__popover{background-color:transparent!important}.bili-rank-list-video .rank-video-card__popover--author,.bili-rank-list-video .rank-video-card__popover--icon,.bili-rank-list-video .rank-video-card__popover--stats,.bili-rank-list-video .rank-video-card__popover--subtitle{color:#aaa!important}.bili-rank-list-video .rank-video-card__popover--stats{border-color:#444!important}.bili-rank-list-video .rank-video-card__cover{background-color:#333!important}.bili-rank-list-video .rank-video-card__info--pts,.bili-rank-list-video .rank-video-card__info--schedule,.bili-rank-list-video .rank-video-card__info--styles{color:#aaa!important}.bili-video-card__info--tit:hover{color:var(--theme-color)!important}.bili-video-card__info--living{filter:var(--pink-image-filter)!important}.bili-video-card__info--owner,.bili-video-card__info--pub,.bili-video-card__info--styles,.bili-video-card__info--subtitle,.bili-video-card__info--uname{color:#aaa!important}.bili-video-card__info--owner:hover{color:var(--theme-color)!important}.bili-video-card .v-img,.bili-video-card__cover,.bili-video-card__image,.bili-video-card__image--wrap{background-color:#333!important}.bili-video-card__skeleton--cover,.bili-video-card__skeleton--face,.bili-video-card__skeleton--light,.bili-video-card__skeleton--text{background-color:#444!important}.bili-video-card__wrap{background-color:transparent!important}.bili-rank-list-bangumi__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-bangumi__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-bangumi__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-bangumi .rank-bangumi-card__popover{background-color:transparent!important}.bili-rank-list-bangumi .rank-bangumi-card__popover--author,.bili-rank-list-bangumi .rank-bangumi-card__popover--icon,.bili-rank-list-bangumi .rank-bangumi-card__popover--stats,.bili-rank-list-bangumi .rank-bangumi-card__popover--subtitle{color:#aaa!important}.bili-rank-list-bangumi .rank-bangumi-card__popover--stats{border-color:#444!important}.bili-rank-list-bangumi .rank-bangumi-card__cover{background-color:#333!important}.bili-rank-list-bangumi .rank-bangumi-card__info--pts,.bili-rank-list-bangumi .rank-bangumi-card__info--schedule,.bili-rank-list-bangumi .rank-bangumi-card__info--styles{color:#aaa!important}.bili-bangumi-card__info--tit:hover{color:var(--theme-color)!important}.bili-bangumi-card__info--living{filter:var(--pink-image-filter)!important}.bili-bangumi-card__info--owner,.bili-bangumi-card__info--pub,.bili-bangumi-card__info--styles,.bili-bangumi-card__info--subtitle,.bili-bangumi-card__info--uname{color:#aaa!important}.bili-bangumi-card__info--owner:hover{color:var(--theme-color)!important}.bili-bangumi-card .v-img,.bili-bangumi-card__cover,.bili-bangumi-card__image,.bili-bangumi-card__image--wrap{background-color:#333!important}.bili-bangumi-card__skeleton--cover,.bili-bangumi-card__skeleton--face,.bili-bangumi-card__skeleton--light,.bili-bangumi-card__skeleton--text{background-color:#444!important}.bili-bangumi-card__wrap{background-color:transparent!important}.bili-rank-list-cheese__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-cheese__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-cheese__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-cheese .rank-cheese-card__popover{background-color:transparent!important}.bili-rank-list-cheese .rank-cheese-card__popover--author,.bili-rank-list-cheese .rank-cheese-card__popover--icon,.bili-rank-list-cheese .rank-cheese-card__popover--stats,.bili-rank-list-cheese .rank-cheese-card__popover--subtitle{color:#aaa!important}.bili-rank-list-cheese .rank-cheese-card__popover--stats{border-color:#444!important}.bili-rank-list-cheese .rank-cheese-card__cover{background-color:#333!important}.bili-rank-list-cheese .rank-cheese-card__info--pts,.bili-rank-list-cheese .rank-cheese-card__info--schedule,.bili-rank-list-cheese .rank-cheese-card__info--styles{color:#aaa!important}.bili-cheese-card__info--tit:hover{color:var(--theme-color)!important}.bili-cheese-card__info--living{filter:var(--pink-image-filter)!important}.bili-cheese-card__info--owner,.bili-cheese-card__info--pub,.bili-cheese-card__info--styles,.bili-cheese-card__info--subtitle,.bili-cheese-card__info--uname{color:#aaa!important}.bili-cheese-card__info--owner:hover{color:var(--theme-color)!important}.bili-cheese-card .v-img,.bili-cheese-card__cover,.bili-cheese-card__image,.bili-cheese-card__image--wrap{background-color:#333!important}.bili-cheese-card__skeleton--cover,.bili-cheese-card__skeleton--face,.bili-cheese-card__skeleton--light,.bili-cheese-card__skeleton--text{background-color:#444!important}.bili-cheese-card__wrap{background-color:transparent!important}.bili-rank-list-live__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-live__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-live__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-live .rank-live-card__popover{background-color:transparent!important}.bili-rank-list-live .rank-live-card__popover--author,.bili-rank-list-live .rank-live-card__popover--icon,.bili-rank-list-live .rank-live-card__popover--stats,.bili-rank-list-live .rank-live-card__popover--subtitle{color:#aaa!important}.bili-rank-list-live .rank-live-card__popover--stats{border-color:#444!important}.bili-rank-list-live .rank-live-card__cover{background-color:#333!important}.bili-rank-list-live .rank-live-card__info--pts,.bili-rank-list-live .rank-live-card__info--schedule,.bili-rank-list-live .rank-live-card__info--styles{color:#aaa!important}.bili-live-card__info--tit:hover{color:var(--theme-color)!important}.bili-live-card__info--living{filter:var(--pink-image-filter)!important}.bili-live-card__info--owner,.bili-live-card__info--pub,.bili-live-card__info--styles,.bili-live-card__info--subtitle,.bili-live-card__info--uname{color:#aaa!important}.bili-live-card__info--owner:hover{color:var(--theme-color)!important}.bili-live-card .v-img,.bili-live-card__cover,.bili-live-card__image,.bili-live-card__image--wrap{background-color:#333!important}.bili-live-card__skeleton--cover,.bili-live-card__skeleton--face,.bili-live-card__skeleton--light,.bili-live-card__skeleton--text{background-color:#444!important}.bili-live-card__wrap{background-color:transparent!important}.bili-rank-list-manga__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-manga__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-manga__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-manga .rank-manga-card__popover{background-color:transparent!important}.bili-rank-list-manga .rank-manga-card__popover--author,.bili-rank-list-manga .rank-manga-card__popover--icon,.bili-rank-list-manga .rank-manga-card__popover--stats,.bili-rank-list-manga .rank-manga-card__popover--subtitle{color:#aaa!important}.bili-rank-list-manga .rank-manga-card__popover--stats{border-color:#444!important}.bili-rank-list-manga .rank-manga-card__cover{background-color:#333!important}.bili-rank-list-manga .rank-manga-card__info--pts,.bili-rank-list-manga .rank-manga-card__info--schedule,.bili-rank-list-manga .rank-manga-card__info--styles{color:#aaa!important}.bili-manga-card__info--tit:hover{color:var(--theme-color)!important}.bili-manga-card__info--living{filter:var(--pink-image-filter)!important}.bili-manga-card__info--owner,.bili-manga-card__info--pub,.bili-manga-card__info--styles,.bili-manga-card__info--subtitle,.bili-manga-card__info--uname{color:#aaa!important}.bili-manga-card__info--owner:hover{color:var(--theme-color)!important}.bili-manga-card .v-img,.bili-manga-card__cover,.bili-manga-card__image,.bili-manga-card__image--wrap{background-color:#333!important}.bili-manga-card__skeleton--cover,.bili-manga-card__skeleton--face,.bili-manga-card__skeleton--light,.bili-manga-card__skeleton--text{background-color:#444!important}.bili-manga-card__wrap{background-color:transparent!important}.bili-rank-list-movie__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-movie__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-movie__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-movie .rank-movie-card__popover{background-color:transparent!important}.bili-rank-list-movie .rank-movie-card__popover--author,.bili-rank-list-movie .rank-movie-card__popover--icon,.bili-rank-list-movie .rank-movie-card__popover--stats,.bili-rank-list-movie .rank-movie-card__popover--subtitle{color:#aaa!important}.bili-rank-list-movie .rank-movie-card__popover--stats{border-color:#444!important}.bili-rank-list-movie .rank-movie-card__cover{background-color:#333!important}.bili-rank-list-movie .rank-movie-card__info--pts,.bili-rank-list-movie .rank-movie-card__info--schedule,.bili-rank-list-movie .rank-movie-card__info--styles{color:#aaa!important}.bili-movie-card__info--tit:hover{color:var(--theme-color)!important}.bili-movie-card__info--living{filter:var(--pink-image-filter)!important}.bili-movie-card__info--owner,.bili-movie-card__info--pub,.bili-movie-card__info--styles,.bili-movie-card__info--subtitle,.bili-movie-card__info--uname{color:#aaa!important}.bili-movie-card__info--owner:hover{color:var(--theme-color)!important}.bili-movie-card .v-img,.bili-movie-card__cover,.bili-movie-card__image,.bili-movie-card__image--wrap{background-color:#333!important}.bili-movie-card__skeleton--cover,.bili-movie-card__skeleton--face,.bili-movie-card__skeleton--light,.bili-movie-card__skeleton--text{background-color:#444!important}.bili-movie-card__wrap{background-color:transparent!important}.bili-rank-list-ogv__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-ogv__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-ogv__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-ogv .rank-ogv-card__popover{background-color:transparent!important}.bili-rank-list-ogv .rank-ogv-card__popover--author,.bili-rank-list-ogv .rank-ogv-card__popover--icon,.bili-rank-list-ogv .rank-ogv-card__popover--stats,.bili-rank-list-ogv .rank-ogv-card__popover--subtitle{color:#aaa!important}.bili-rank-list-ogv .rank-ogv-card__popover--stats{border-color:#444!important}.bili-rank-list-ogv .rank-ogv-card__cover{background-color:#333!important}.bili-rank-list-ogv .rank-ogv-card__info--pts,.bili-rank-list-ogv .rank-ogv-card__info--schedule,.bili-rank-list-ogv .rank-ogv-card__info--styles{color:#aaa!important}.bili-ogv-card__info--tit:hover{color:var(--theme-color)!important}.bili-ogv-card__info--living{filter:var(--pink-image-filter)!important}.bili-ogv-card__info--owner,.bili-ogv-card__info--pub,.bili-ogv-card__info--styles,.bili-ogv-card__info--subtitle,.bili-ogv-card__info--uname{color:#aaa!important}.bili-ogv-card__info--owner:hover{color:var(--theme-color)!important}.bili-ogv-card .v-img,.bili-ogv-card__cover,.bili-ogv-card__image,.bili-ogv-card__image--wrap{background-color:#333!important}.bili-ogv-card__skeleton--cover,.bili-ogv-card__skeleton--face,.bili-ogv-card__skeleton--light,.bili-ogv-card__skeleton--text{background-color:#444!important}.bili-ogv-card__wrap{background-color:transparent!important}.bili-rank-list-article__list{border-color:transparent!important;background-color:transparent!important}.bili-rank-list-article__item:nth-of-type(2n+1){background-color:#333!important}.bili-rank-list-article__item:nth-of-type(2n){background-color:#444!important}.bili-rank-list-article .rank-article-card__popover{background-color:transparent!important}.bili-rank-list-article .rank-article-card__popover--author,.bili-rank-list-article .rank-article-card__popover--icon,.bili-rank-list-article .rank-article-card__popover--stats,.bili-rank-list-article .rank-article-card__popover--subtitle{color:#aaa!important}.bili-rank-list-article .rank-article-card__popover--stats{border-color:#444!important}.bili-rank-list-article .rank-article-card__cover{background-color:#333!important}.bili-rank-list-article .rank-article-card__info--pts,.bili-rank-list-article .rank-article-card__info--schedule,.bili-rank-list-article .rank-article-card__info--styles{color:#aaa!important}.bili-article-card__info--tit:hover{color:var(--theme-color)!important}.bili-article-card__info--living{filter:var(--pink-image-filter)!important}.bili-article-card__info--owner,.bili-article-card__info--pub,.bili-article-card__info--styles,.bili-article-card__info--subtitle,.bili-article-card__info--uname{color:#aaa!important}.bili-article-card__info--owner:hover{color:var(--theme-color)!important}.bili-article-card .v-img,.bili-article-card__cover,.bili-article-card__image,.bili-article-card__image--wrap{background-color:#333!important}.bili-article-card__skeleton--cover,.bili-article-card__skeleton--face,.bili-article-card__skeleton--light,.bili-article-card__skeleton--text{background-color:#444!important}.bili-article-card__wrap{background-color:transparent!important}.n-drawer-container .elevator{background-color:#222!important}.n-drawer-container .elevator .elevator-head{color:#eee!important}.n-drawer-container .elevator .elevator-core.is-active{background-color:#333!important}.n-drawer-container .elevator .elevator-core:hover{background-color:#444!important}.n-drawer-container .elevator .elevator-core .name{color:#eee!important}.n-drawer-container .elevator .elevator-core .icon{color:#aaa!important}#bili-footer{background-color:transparent!important}#bili-footer .split-line{background-color:#444!important}#bili-footer a,#bili-footer p{color:#eee!important}#bili-footer a:hover{color:var(--theme-color)!important}#bili-footer .link-item .bt,#bili-footer .text-con__line--link{color:#aaa!important}.footer-qrcode-popover .qrcode-text,.footer-wechat-popover .qrcode-text{color:#eee!important}.gm-skeleton .chat-input-ctnr{border-color:#333!important;background-color:#222!important}.gm-skeleton .chat-input-ctnr .medal-section{border-color:#333!important}.suggest-wrap .suggest-item{color:#eee!important}#all-list .sub-filter,.suggest-wrap .suggest-item:hover{background:#6e6e6e!important}#all-list .icon-tid2-arr{color:#6e6e6e!important}#all-list .mixin-list .user-list .all-user-item>.user-row .title,#all-list .mixin-list .user-list .u-videos .video-item .video-desc{color:#eee!important}.dyn-topic-panel .topic-panel{background:#444!important}.dyn-topic-panel .topic-panel__nav-title{color:#eee!important}.dyn-topic-panel .topic-panel .relevant-topic::before{filter:brightness(0) invert(.8)!important}.dyn-topic-panel .topic-panel .relevant-topic:hover .relevant-topic__title{color:var(--theme-color)!important}.dyn-topic-panel .topic-panel .relevant-topic__title{color:#eee!important}.bili-topic-selector__search .bili-topic-search__input__prefix,.bili-topic-selector__search .bili-topic-search__input__text,.dyn-topic-panel .topic-panel .relevant-topic__exposed{color:#aaa!important}.bili-topic-selector__search .bili-topic-search__popover{background-color:#333!important;border-color:transparent!important}.bili-topic-selector__search .bili-topic-search__popover.active{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bili-topic-selector__search .bili-topic-search__popover.active .bili-topic-search__input{background-color:#444!important}.bili-topic-selector__search .bili-topic-search__popover.active .bili-topic-search__input__inner{color:#eee!important}.bili-topic-selector__search .bili-topic-search__popover.active .bili-topic-search__input__inner::placeholder{color:#aaa!important}.bili-topic-selector__search .bili-topic-search__popover.active .bili-topic-search__input__text{color:#999!important}.bili-topic-selector .bili-topic-item__cloud:hover{background:#222!important}.bili-topic-selector .bili-topic-item__cloud__prefix{filter:brightness(0) invert(.8)!important}.bili-topic-selector .bili-topic-item__cloud__name{color:#eee!important}.bili-topic-selector .bili-topic-item__cloud__desc{color:#aaa!important}.bili-topic-selector__rcmd__default .bili-topic-item__stela{background:#333!important}.bili-topic-selector__rcmd__default .bili-topic-item__stela__name,.bili-topic-selector__rcmd__default .bili-topic-item__stela__prefix{filter:var(--blue-image-filter)!important}.bili-topic-selector__rcmd .bili-topic-rcmd-more__action{background:#333!important;color:var(--theme-color)!important}.bili-topic-selector__rcmd .bili-topic-rcmd-more__items .bili-topic-item__cloud__prefix{color:var(--theme-color)!important}.bili-topic-selector__rcmd .bili-topic-rcmd-more__items .bili-topic-item__cloud__name{color:#eee!important}.bili-topic-selector__rcmd .bili-topic-rcmd-more__popover{background:#333!important;border-color:transparent!important}.bili-topic-selector__rcmd .bili-topic-rcmd-more__popover.hover{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bili-topic-selector__bulletin{background:#444!important}.bili-topic-selector__bulletin .bili-topic-item__normal:hover{background:var(--theme-color-10)!important}.bili-topic-selector__bulletin .bili-topic-item__normal__name,.bili-topic-selector__bulletin .bili-topic-item__normal__prefix,.bili-topic-selector__bulletin__clear{filter:var(--blue-image-filter)!important}.comment-setting .settings-panel{background:#333!important;border-color:transparent!important;box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.comment-setting .settings-panel__option{color:#eee!important}.comment-setting .settings-panel__option:hover{color:#eee!important;background-color:#222!important}.comment-setting .settings-panel__option--active,.comment-setting .settings-panel__option--active:hover{color:var(--theme-color)!important}.toolbar-box .icon-reserve.live:hover{filter:var(--blue-image-filter)!important}.bili-popup-layer{background-color:#222!important;border-color:transparent!important}.bili-popup-layer__content .dynamic-reserve__type{color:#eee!important}.bili-popup-layer__content .dynamic-reserve__form__item.title .bili-input::before{border-color:transparent!important}.bili-popup-layer__content .dynamic-reserve__form__item.title .bili-input:hover::before{border-color:var(--theme-color)!important}.bili-popup-layer__content .dynamic-reserve__form__item.title .bili-input__inner{color:#eee!important;background-color:#444!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .date-input input{background-color:#444!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .date-input::before{border-color:transparent!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .date-input:hover::before{border-color:var(--theme-color)!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .date-input .calendar.active{filter:var(--blue-image-filter)!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .scroll-input .s-input-wrap::before{border-color:transparent!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .scroll-input .s-input-wrap:hover::before{border-color:var(--theme-color)!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .scroll-input .s-input-wrap .s-input{background-color:#444!important;color:#eee!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .scroll-input .s-label{color:#aaa!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .scroll-input .s-panel{border-color:var(--theme-color)!important;background-color:#444!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .scroll-input .s-panel .s-item{color:#eee!important}.bili-popup-layer__content .dynamic-reserve__form__item.datetime .scroll-input .s-panel .s-item:hover{color:var(--theme-color)!important}.bili-popup-layer__content .dynamic-reserve__about img{filter:var(--blue-image-filter)!important}.bili-popup-layer__content .dynamic-reserve__about .link{color:var(--theme-color)!important}.bili-popup-layer__footer::after{border-color:transparent!important}.bili-popup-layer__button{color:#eee!important}.bili-popup-layer__button.confirm{background-color:var(--theme-color)!important}.bili-popup-layer__button.cancel{background:#444!important}.bili-popup-layer__button::before{border-color:transparent!important}.dyn-topic__card:hover{background:var(--theme-color-10)!important}.dyn-topic__icon{filter:var(--blue-image-filter)!important}.dyn-topic__text{color:var(--theme-color)!important}#canvas-detail-comment-ctnr,.audioplayer,.audios-wrap #audios-box,.bangumi-collection-card .bangumi-funcs .btn-unfollow,.bangumi-collection-card .bangumi-funcs .btn-unfollow li,.bangumi-review-item,.big-gift-btn-home,.big-more-item-item,.big-more-item-list,.bili-header-m .i_menu_login,.bili-header-m .nav-menu .nav-con .nav-item .bml-box,.bilibili-player-context-menu-container.black,.bilibili-player-contextmenu-subwrapp>span.hover,.bilibili-player-danmaku-setting-lite-panel .bilibili-player-danmaku-setting-lite,.bpui-selectmenu.selectmenu-mode-absolute .bpui-selectmenu-list-row,.btn-confirm.disabled,.buy-info-box,.cc-nav-wrp,.coin-record .table-normal tbody tr:nth-child(odd),.comment-ctnr,.comment-wrap,.danmaku-menu,.el-input__inner,.el-picker-panel,.el-picker-panel [slot=sidebar],.el-picker-panel__sidebar,.el-select-dropdown,.emoji-box,.emoji-box .emoji-tabs,.face-g-action,.face-g-item-inner,.face-g-list .mp-block .right ul li .strip,.face-g-list[id=face-g-log] td,.face-g-list[id=face-g-log] th,.first-change-lb,.first-change-lb:hover,.follow-container .follow-right .follow-intro .follow-fold,.get-coin-more,.go-movie,.guard-desc-box,.gui-settings-box li.category,.h-safe-nobtn,.has-prize,.hold-list,.home-top-level-mask-warp,.home-top-level-up,.identmagBot,.identmagTop,.link-popup-panel,.link-top-container,.live-module .tab-box,.log-empty,.main-container .player-wrapper,.media-tab-nav,.media-tab-wrp,.misl-ep-item,.nav-upload-container,.news-list .news-item:hover,.pagelistbox .p,.player-auxiliary-block-list .player-auxiliary-block-line,.player-auxiliary-block-tabpanel-row.player-auxiliary-border,.player-auxiliary-context-menu-container,.player-auxiliary-danmaku-date-picker-container,.player-auxiliary-modal-container,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list:hover,.progress-bar-ctnr .bar-body,.publish-panel .publish-list .publish-item:hover,.re-exp-getexp,.recom-wrap .no-result,.result.is-web,.season-timer .current-timer:before,.section .count,.selector-wrapper .more-type-wrapper,.side-bar-popup-cntr,.slide-item-wrp .slide-item-img,.slot-ctnr .panel,.sort-type-wrp ul,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-btn-primary.disabled,.sponsor-rank-item.simple .sp-msg,.sponsor-rank-item.special .sp-right .sp-msg,.tab-box .item.active::after,.tab-box .item.active::before,.table-normal tbody tr:nth-child(odd),.timeline-header,.timeline-wrapper,.timer-wrap .quit,.tl-head .tl-day,.ui-btn.grey-radius,.user-info>.tag-flag,.user-my-sex .el-radio-button__inner,.viptable tr th,.viptable tr:nth-child(2n) td,.viptable tr:nth-child(odd) td,.wear-list li,.word-limit-h5 textarea,a.bp_box_bot_click,li.season-item .season-body .season-title span.follow{background-color:#222!important}#announcement-area .news-ctnr,#announcement-area .popular-section-ctnr,#announcement-area .rank-ctnr,#article-list-index,#bp_user_box,#page-fav .fav-main .fav-video-list.is-batch .small-item.selected,#page-fav .fav-main .fav-video-list.is-batch .small-item:hover,.announcement-cntr,.article-content-ctnr,.author-info,.b-info,.ban-app .case-tip,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow.followed,.bangumi-list-wrapper .bottom-block .slider-contro span,.bangumi-nav-right .nav-goto-top,.bangumi-nav-right .nav-mini-switch,.bangumi-player.mini-player .mini-player-move,.bangumi-player.mini-player .mini-player-move i,.bangumi-player.mini-player .mini-player-move span,.bb-intro-top,.bb_box,.bgray-btn,.big-more-item-item:hover .big-more-item-txt,.bili-btn.ok,.bili-btn.plain,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-recommend,.bilibili-player .bilibili-player-panel,.bilibili-player .bilibili-player-panel-title,.bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player-ending-panel-box-functions .bui-button.bui-button-disabled,.block-area .timeline-title .headline .timeline-more,.bp_box,.btn-disabled,.btn-pay-wrapper.is-vip a,.bui-button.bui-button-gray,.cc-nav-wrp .down-link:hover,.charge-participate,.cm-model,.coin-inner,.confirm-content,.container,.contri-condition .contri-search,.contri-condition .contri-sort .contri-sort-type,.danmaku-wrap .player-auxiliary-auxiliary-area .player-auxiliary-danmaku-wrap,.danmu-container,.danmu-container .empty-danmu:hover,.dashboard,.dialog .content-outer,.fav-main .fav-action-bottom .fav-action-fixtop,.favourite-card,.fjw-random,.follow-container .follow-right .unfollow-btn,.footer-content .qrcode-wrp,.groom-module,.info-model,.info-model .border-b,.info-model header,.intimacy-bar,.invtable tr th,.live-module .tab-item .r-item .number,.medal-progress,.media-info-card,.media-tab-detail-wrp .media-tab-detail,.media-tab-detail-wrp .media-tab-detail-l,.media-tab-module-content .spread-module .num,.more-btn-cntr,.new-stat-module .zone-title .headline .new-stat-more,.news-list .news-item,.news-notice-panel,.pager .jump-pager input[type=text],.paging-box-big .next,.paging-box-big .prev,.pgc-rank-dropdown,.player-auxiliary-auxiliary-area .player-auxiliary-adv-danmaku,.player-auxiliary-auxiliary-area .player-auxiliary-setting,.player-auxiliary-block-list .player-auxiliary-block-line.block-state-selected,.player-auxiliary-block-list .player-auxiliary-block-line:hover,.player-auxiliary-block-string,.player-auxiliary-block-string-short,.player-auxiliary-modal-btns .bpm-btn,.player-auxiliary-setting-menu-wrap,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list,.progress-bar-body,.project-list .project-list-item,.review-feed-wrapper,.season-slider-wrapper .slider-wrapper .season-slider-list li:after,.section-item,.security-list-jump:hover,.security-list:hover,.security-right,.security_content,.selector-wrapper,.selector-wrapper .wrapper,.share-module .share-list .weixin-share-modal,.side-bar,.side-utils .utils-box,.sidebar-canvas,.slot-ctnr .panel li:hover,.sort-type-wrp ul li:hover,.sponsor-pay-dialog-v2 .sp-pay-index,.tab-box,.table-normal thead tr td,.tabnav,.tag-list li.tag-item,.timeline-box .timeline-item .item-right p.num a,.timeline-box .timeline-item .item-right p.num span,.timer-wrap,.timer-wrap .vote-dialog-new .footer .b-disable,.toolbar-wrapper,.ui-calendar .calendar-wrap .flatpickr-calendar.static,.ui-calendar .main-wrap,.ui-calendar .main-wrap .shortmenus,.ui-checkbox input[type=checkbox]:disabled+.ui-checkbox-icon,.ui-input,.user-panel-ctnr .exit-btn,.video-model .border-b,.video-model header,.works-ctnr{background-color:#444!important}.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar,.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{background-color:#555!important}.border-line,.count-wrapper div.danmu-count:after,.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar:hover,.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar:hover,.season-timeline .season-group .group-time:before,.tl-head .tl-day .indicator{background-color:#aaa!important}.coin-nav .on,.sponsor-rank-item.normal .sp-left .face-wrap{background-image:none!important}.disabled-cover{background-color:#2229!important}.mask::after{background-color:hsla(0,0%,0%,.7)!important}.article-content-ctnr>hr,.author-info .communicate-btn,.bilibili-player-area .bilibili-player-video-control .bilibili-player-video-btn.bilibili-player-video-btn-fullscreen .bilibili-player-video-web-fullscreen,.bilibili-player-area .bilibili-player-video-control .bilibili-player-video-btn:hover,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-btn:hover,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-menu:hover,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-user,.bilibili-player-video-control,.bilibili-player-video-sendbar .bilibili-player-video-btn:hover,.bilibili-player-video-sendbar .bilibili-player-video-btn>i,.bui-select.bui-select-quality-menu .bui-select-border,.chief-recommend-module .carousel-box .carousel-module .panel .trig span.on,.container .host-list-layout .hot-list-wrap .bg-wrap .hot-list-mask,.contri-condition .contri-sort .contri-sort-type li:hover,.empty-hint,.f-list-hover:hover,.line-circle,.live-sidebar-ctnr,.nav-upload-container .nav-upload-item:hover,.news-list .news-item .date,.player-auxiliary-adv-danmaku,.player-auxiliary-auxiliary-area,.player-auxiliary-auxiliary-area .player-auxiliary-filter,.prize-winner-block,.security-list .child-list li a:hover,.share-module,.sponsor-rank-item.simple .sp-rank i{background-color:transparent!important}.block-area .timeline-toggle-block .timeline-toggle-btn,.cc-nav-wrp .nav-cut-off-line,.fav-main .fav-action-top .back-to-info,.no-data,.section .count:before,.tag-more .b-toggle-btn{background:0 0!important}#page-index .fav-item .state,.act-info,.announce h3.title span,.announce h3.title span .fontvt,.announce li span,.audioplayer .ap-playlist .ap-playlist-header .ap-playlist-amount,.b-head-string,.b-info .balance-footer,.b-info .info-tip,.backdrop .title-box .close-button,.bangumi-collection-card .bangumi-info .bangumi-state,.bangumi-collection-card .bangumi-info .type-and-area,.bangumi-collection-card .bangumi-info .watch-state,.bangumi-collection-wrapper .bangumi-collection-count,.bangumi-home-crumb .fcname ul.n_num li,.bangumi-home-crumb .fcname ul.n_num li a,.bangumi-media .bangumi-media-header .btn-more-review,.bangumi-media .bangumi-media-header .rate-wrapper .rate-info .info-wrapper,.bangumi-nav-right .nav-mini-switch,.bangumi-review-item .item-header .author-name,.bangumi-review-item .item-header .media-name,.bangumi-review-item .item-header .pub-time,.bangumi-review-item .review-content.long,.bb-comment .no-more-reply,.bb-intro-top .b-question .b-question-title,.be-input-word-counter,.bgray-btn,.big-game-gift-money,.big-more-tool-item,.big-nane-bottom p,.bili-header-m .i_menu_login .reg,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-watching .bilibili-player-watching-number,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-btn:hover,.bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-menu:hover,.bilibili-player-block-filter-function .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player-block-filter-type .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player-ending-panel-box-functions .bui-button.bui-button-disabled,.bilibili-player-filter .bilibili-player-filter-btn>span,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row .row-selection .selection-span .selection-icon,.bilibili-player-panel .bilibili-player-panel-content .bilibili-player-panel-label,.bilibili-player-recommend-right .bilibili-player-recommend-click,.bilibili-player-recommend-right .bilibili-player-recommend-danmaku,.bilibili-player-recommend-right .bilibili-player-recommend-scores,.bilibili-player-recommend-right .bilibili-player-recommend-stow,.bilibili-player-video-control .bilibili-player-video-btn,.bilibili-player-video-sendbar .bilibili-player-video-btn,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a,.bp-user-box .bp-user-box-bb,.bp-user-box .bp-user-box-bk,.bp-user-box-bottom p,.bread-crumb ul li a,.bread-crumbs,.bread-crumbs a,.btn-delete,.bui-button.bui-button-gray2,.cc-nav-wrp .down-link .version,.cc-nav-wrp .nav-item i:first-child,.cc-nav-wrp .nav-item i:last-child,.charge-participate .benefit-item .long-desc,.cm-model .report-detail .child-comment .child-list .detail .report-cnt .rep-name,.cm-model .report-detail .detail .date,.cm-model .report-detail .more-list,.coin-left-nodata,.coin-operated-m .coin-bottom .tips,.coin-text-p,.compila-not-find .compila-not-find-tips,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-num,.container .host-list-layout .hot-list-wrap .show-more-song,.container .musician-recommend .recommend-item .recommend-info .recommend-text,.container .song-list .song-li .content .num,.contri-condition .contri-right i,.contri-condition .contri-sort,.contri-not-find .contri-not-find-tips,.count-wrapper div,.data-card .data-box .tab .fan-tab,.data-card .data-box .tip p,.data-card .data-box .total,.data-card .fans-box .tab .fan-tab,.data-card .fans-box .tip p,.data-card .fans-box .total,.dc-section .section-tip,.dc-section-item_title_name small,.descript,.dynamic-m .title span:not(.sp),.el-date-table th,.el-input__icon,.el-picker-panel__icon-btn,.el-select-dropdown__item,.empty-wrp .text,.episode-item .ep-title,.face-g-expire-at,.face-g-list .mp-block .left .mp-info label,.face-g-list .mp-block .right ul li p.reach-tips,.face-g-list .mp-block .right ul li.base .tips,.fans-number,.fav-main .fav-action-bottom .select-counter,.first-change-lb span,.fjw-case-detail .ban-detail .content-box .jury-status .status-left .voted .graph .txt,.follow-container .follow-right .follow-intro .follow-content,.follow-container .follow-right .follow-num,.font24,.footer a,.footer-content .menu-item,.gotoSpace,.growup-participate .status_box .limited,.h-list-desc,.h-safe-desc,.history-list .r-info .history-mark,.history-list .r-info .subtitle,.history-tag,.hotsong-li .font24,.hotsong-li .hotsong-upname,.i-live .i-live-off-guest,.icon-star:not(.icon-star-light)::before,.identmagBot span,.income-card .income-box .empty-data p,.income-card .income-box .empty-data span,.info-second .info-sec-av,.info-second span,.introduction-text,.inv-record-right,.invitation-normal,.live-ctn .live-attch .host,.live-module .tab-item .r-item .r-i-st,.live-module .tab-item .r-item .r-i-t .u-online,.log-empty p,.m-tips,.main-content-title span.i,.medal .medal-form .page-tip,.medal .medal-form .section .mini,.medal header p,.media-info-card .mic-expand,.media-sponsor-wrapper .sponsor-rank-header .show-sponsor-rank,.media-sponsor-wrapper .sponsor-right-area .sponsor-count-info,.media-tab-module-wrp .media-tab-module-more,.media-tab-module-wrp .media-tab-module-write.type-btn,.member-list-item-subtext,.misl-ep-item .misl-ep-text .misl-ep-title,.mod-1 .r .up-info .v-author,.mod-1 .r .up-info .v-date,.mod-1 .r .v-desc,.mod-1 .r .v-info .v-info-i,.mod-2 li .r .up-info .v-author,.mod-2 li .r .v-info .v-info-i,.mod-3 .r .up-info .v-author,.mod-3 .r .v-info .v-info-i,.modal-head a,.modal-wrapper .modal-body,.nav-list li .list-description p,.no-data,.no-data-txt,.normal-empty,.notice-card .notice-list .notice-item .notice-time,.notice-card .notice-list .notice-item .notice-title,.pagelistbox .p,.pagelistbox strong,.pagination-wrapper .pagination .pageNum,.paging-box-big .page-jump,.pgc-rank-list .rank-item .ri-detail .ri-point,.player-auxiliary-auxiliary-area .player-auxiliary-filter-menu,.player-auxiliary-block-line.block-state-disabled,.player-auxiliary-block-list .player-auxiliary-block-line-delete,.player-auxiliary-block-list .player-auxiliary-block-line-sync,.player-auxiliary-block-list-function>div,.player-auxiliary-block-list-wrap .player-auxiliary-block-empty,.player-auxiliary-danmaku-date-picker-header,.player-auxiliary-danmaku-date-picker-header .player-auxiliary-danmaku-date-picker-btn,.player-auxiliary-danmaku-function [class*=player-auxiliary-danmaku-btn-],.player-auxiliary-danmaku-load-status.disabled,.points-faq-line body,.points-text,.pre-info,.rank-list .rank-item .ri-detail .ri-point,.rank-list-container .title,.re-exp-none,.recom-item a .recom-info .info-count>div span,.recom-item a .recom-info .info-title,.record-exp-title .i,.record-group,.record-login-descript,.results,.review-feed-item .feed-left .review-about,.review-feed-item .feed-left .review-about .author-info,.review-feed-item .feed-left .review-about .media-title,.review-feed-item .feed-right .likes,.review-feed-wrapper .feed-header span,.review-feed-wrapper .feed-header span .icon-refresh::before,.review-list-wrp li .review-author-info div.review-author-name,.review-list-wrp li .review-author-info div.review-author-time,.review-list-wrp li .review-contro div,.review-list-wrp li .review-data div,.review-list-wrp li .review-data div .icon-zan::before,.season-item,.season-timeline .season-group .group-time,.season-timeline .season-group.is-published .group-time,.section .count,.security-title,.select-month .tip,.selector-wrapper .city-list,.selector-wrapper .more-type-list .more-type-item,.selector-wrapper .more-type-wrapper,.selector-wrapper .order-list,.selector-wrapper .type-list,.share-board .song-share div,.share-module .share-list li.share-btn.btn-app,.song-content,.song-info .song-info-content .song-info-theme,.song-li .song-right .song-playnum,.song-lrc,.song-play-num,.song-time,.song-type,.sort-type-wrp div,.sort-type-wrp div i,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-hint .sponsor-point,.sponsor-rank-item.normal .sp-left .sp-rank,.sponsor-rank-item.simple .sp-msg,.sub-nav-m ul li a,.tab-btn-link,.table-normal thead tr td,.tabnav-item,.tag-list-wrp .title .small,.timer-wrap .canvas-wrap .canvas-title,.timer-wrap .vote-dialog-new .header h2,.timer-wrap .vote-dialog-new .main .main-txt-2,.timer-wrap .vote-dialog-new .main h4,.title-container .info span,.ui-checkbox input[type=checkbox]:disabled+.ui-checkbox-icon,.ui-serch .run-serch,.up-info .up-info-tip,.user-box,.user-box .grade-dec,.user-info>.user-uid,.user-name,.vote-percentage,.wrapper .modal-body .pay-info-wrp{color:#aaa!important}#announcement-area .news-ctnr .news-item,#announcement-area .news-ctnr .title-row,#announcement-area .popular-section-ctnr .area-name,#announcement-area .popular-section-ctnr .title-row,#announcement-area .rank-ctnr .title-row,#app>.main .title,#audience-page .version-switch-section .bili-tab,.academy-card .academy-box .academy-item .academy-title,.all-hot-list-warp .all-hot-list .hot-list-content .list-name,.announce li>div a,.assist-wrap .assist-log header .tools .search-wrp input[type=text],.assist-wrap .assist-log header .tools .ui-calendar input[type=text],.audioplayer .ap-controller .ap-controller-center .ap-artist,.audioplayer .ap-controller .ap-controller-center .ap-current-time,.audioplayer .ap-controller .ap-controller-center .ap-name,.audioplayer .ap-controller .ap-controller-center .ap-playlist-button-amount,.audioplayer .ap-controller .ap-controller-center .ap-time,.b-head,.b-head-t,.b-info .balance-footer .balance-part .part-balance-price,.b-info .bb-quan,.b-info .button,.ban-detail .content-box .jury-status .status-left .voted .voted-tips p span,.ban-detail .content-box .jury-status .status-right .vote-success .success-txt p,.bangumi-collection-card .bangumi-funcs .btn-unfollow,.bangumi-collection-card .bangumi-info .bangumi-title,.bangumi-collection-wrapper .bangumi-collection-title,.bangumi-header .header-info h1,.bangumi-info .info-right .info-title h2,.bangumi-media .bangumi-media-header .rate-wrapper .btn-go-write,.bangumi-media .bangumi-media-header h4,.bangumi-recom .recom-title,.bangumi-review-item .long-title,.bangumi-review-item .review-content,.bb-comment .nameplate .nameplate-card .nameplate-text,.bb-intro-top .b-icon-title,.bgray-btn:hover,.big-game-gift-text,.big-gift-btn-home,.big-more-item-item,.big-more-item-list,.big-pendant-test,.big-privilege-title,.big-watch-title,.bili-btn.ok,.bili-header-m .i_menu_login .tip,.bili-tab,.bilibili-player-auxiliary-area .bilibili-player-recommend-title,.bilibili-player-block-tabpanel .bilibili-player-block-string-type,.bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-title,.bilibili-player-danmaku-setting-lite .bilibili-player-danmaku-setting-lite-row .bpui-checkbox-text,.bilibili-player-danmaku-setting-lite-row .bilibili-player-danmaku-setting-lite-title,.bilibili-player-mode-selection-row .selection-span .selection-name:hover,.bilibili-player-mode-selection-row .selection-span.active .selection-name,.bilibili-player-panel-area .bilibili-player-panel-area-title,.bilibili-player-panel-content .bilibili-player-panel-setting .selectmenu-mode-absolute .bpui-selectmenu-txt,.bilibili-player-panel-title,.bilibili-player-video-btn-danmaku .bilibili-player-danmaku-setting-lite-panel .bilibili-player-danmaku-setting-lite,.block-area .timeline-title .headline .name,.block-area .timeline-title .headline .timeline-more,.block-area .timeline-toggle-block .timeline-toggle-btn,.bp-user-box i,.bp-user-box-top p,.bp_box_bot a,.bp_box_top p,.bpui-button-text-only[for],.bpui-tab-list-type-button .bpui-tab-list-row,.bread-crumbs span,.btn-confirm.disabled,.btn-disabled,.btn-pay-wrapper.is-vip a,.btn-sponsor-wrapper .sponsor-count span,.bui-button.bui-button-gray,.bui-button.bui-button-gray2:hover,.bui-tabs .bui-tabs-header .bui-tabs-header-item,.buy-info-box .left-part,.carousel-wrapper .carou-info span a,.cc-album-manage .info-wrp .cc-btn,.cc-btn.is-main,.cc-nav-wrp .down-link .title,.cc-nav-wrp .nav-upload-btn>a,.channel-m,.charge-participate .benefit-item .short-desc,.charge-participate .part-btn,.chat-history-panel .chat-item,.chat-history-panel .gift-item .gift-count,.chat-history-panel .hover-panel>span,.cm-model h4,.coin-index-right-title,.coin-nav-item,.coin-next-day,.coin-record .coin-title,.coin-rest-info,.coin-rest-p,.coin-reward-info,.coin-time,.comment-con,.comment-title,.compila-condition .compila-right .compila-add.single,.compila-condition .compila-type,.compila-not-find .compila-not-find-ime,.confirm-content,.container .all-hot-list-warp .all-hot-list .hot-list-content .hover-mask .iconfont,.container .host-list-layout .hot-list-wrap .bg-wrap .top-info-content .right-info .right-btn .iconfont,.container .host-list-layout .hot-list-wrap .bg-wrap .top-info-content .right-info .right-btn .text,.container .musician-recommend .recommend-item .recommend-info .name,.content-panel .title,.contri-condition .contri-search,.contri-condition .contri-select,.contri-condition .contri-sort .contri-sort-type li,.contri-not-find .contri-not-find-ime,.curren-b-num,.danmu-container .empty-danmu,.dashboard li .text,.dashboard li.collection .text,.dashboard li.share .text,.data-card .data-box .tab .bili-btn,.data-card .data-box .title,.data-card .fans-box .tab .bili-btn,.data-card .fans-box .title,.data-card .tab .data-tab,.dc-section-item_title_name p,.dc-section-title,.el-form-item__label,.el-pager li.active,.el-pagination,.el-pagination button.disabled,.el-picker-panel,.el-picker-panel__shortcut,.el-radio-button__orig-radio:checked+.el-radio-button__inner,.emoji-box,.empty-hint .hint-text,.episode-item .ep-index,.face-g-action,.face-g-list .mp-block .left .mp-info .mp-descr,.face-g-list .mp-block .left .mp-info .mp-title,.face-g-list .mp-block .right ul li p.title,.face-g-list[id=face-g-log] td,.face-g-list[id=face-g-log] th,.face-g-name,.face-g-takedown,.face-g-title,.face-g-use,.face-g-xf,.fav-main .fav-action-bottom li,.fav-main .fav-action-bottom ul.filter-disable li:hover,.fav-main .fav-action-top .back-to-info,.favourite-card .anchor-info .anchor-name,.fjw-case-detail .ban-detail .content-box .jury-status .status-left .voted .graph .people,.fjw-random .point-wrap .cnt .no-data .title,.follow-container .follow-right .follow-up,.follow-container .follow-right .unfollow-btn,.get-coin-more,.go-movie:hover,.go-secuirty,.gui-settings-button:not(.save),.guide-card .title p,.h-list-name,.h-mp-space,.h-reward-info,.h-safe-nobtn,.h-safe-title,.head-wrap,.home-dialy-task-title,.home-level-tips,.home-to-space,.home-to-update,.home-top-level-mask-warp,.home-top-level-number,.home-userstatus,.home-wrap .card .title,.host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .song-title,.hot-box li .txt,.hotsong-li .hotsong-title a,.identmagTop,.inv-record-title,.invitation-btn,.invitation-info-title,.invtable tr th,.is-max .vote-percentage,.level-dia,.link-popup-panel,.link-top-container .link-top-item,.list-filter-bar .sort-box,.live-ctn .live-attch .title,.live-module .tab-item .r-item .r-i-t .u-name,.m-help,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-count-info span,.main-container .title,.main-content-title span.t,.medal .medal-form .page-tip a,.medal .medal-form .section,.medal .medal-form .section .title-tip,.medal-message,.media-info-card,.media-info-card .mic-evaluate,.media-info-count .media-info-count-item *,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-btns .bangumi-btn .btn-follow,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-title .media-info-title-t,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-title .media-tag,.media-sponsor-wrapper .sponsor-right-area .sponsor-btn,.media-sponsor-wrapper .sponsor-right-area .sponsor-count-info span,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .sl-ep-nav-list,.media-tab-module-wrp .media-tab-module-title,.media-tab-nav ul li,.member-list-item-text,.middle-tip,.middle-tip .change-song,.misl-ep-item .misl-ep-text .misl-ep-index,.misl-ep-item .misl-ep-text .misl-ep-title,.mod-1 .r .title,.mod-2 li .r .title,.mod-3 .r .title,.more .icon-font,.more-btn-text,.more:hover .text,.mp-mine-takedown,.my-moral,.nav-bar .nav-wrapper .main-tab.active,.nav-item,.nav-list li .list-title .list-title-text p,.new-stat-module .zone-title .headline .name,.new-stat-module .zone-title .headline .new-stat-more,.now-num,.page-title,.pagelistbox .custom-right .custom-right-inner,.pager .jump-pager input[type=text],.paging-box-big .next,.paging-box-big .prev,.pendant-name,.pie-empty-wrapper,.pk-rank.side-bar-icon+.size-bar-text,.player-auxiliary-auxiliary-area .player-auxiliary-filter-title,.player-auxiliary-block-list .player-auxiliary-block-line,.player-auxiliary-block-string,.player-auxiliary-block-string-short,.player-auxiliary-block-tabpanel-row.special-title .player-auxiliary-block-label,.player-auxiliary-modal-btns .bpm-btn,.player-auxiliary-modal-info,.player-auxiliary-modal-title,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list,.points-btn,.points-exchange-title,.points-faq-info-list,.points-how-title,.points-info p,.points-pendant-title p,.points-record-title,.privilege-text,.project-list .project-list-item .project-list-item-detail .project-list-item-title,.rangeMode .flatpickr-day,.rank-menu li html,.re-exp-getexp,.re-exp-info,.record-exp-title .t,.record-nav-item,.review-feed-item .feed-left .review-info .review-content,.review-feed-item .feed-left .review-info .review-title,.review-feed-wrapper .feed-header h4,.review-list-wrp .review-detail .review-content,.review-list-wrp .review-detail .review-title,.right-more-btn,.room-list .list-item .uname,.safe-tips p,.season-slider-wrapper .slider-wrapper .season-slider-list li.cur,.section-item .data-name,.section-item .diff-wrp,.section-title>a.t,.section>.section-title,.security-list .first-level,.security-list li a span,.security-list-link-jump,.security-nav-name,.selector-wrapper .title,.setting .setting-title,.share-module .share-list .weixin-share-modal .share-name,.share-module .share-list .weixin-share-modal .share-tips,.side-utils .utils-item .item-desc,.slot-ctnr a,.song-info .song-info-content .song-info-detail,.song-li .song-right .song-intro a,.song-list .song-li .content .text a,.song-play-num span,.song-playbtn,.song-title,.sort-type-wrp ul li,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-agree a,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-btn-primary.disabled,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-hint,.sponsor-pay-dialog-v2 .sp-pay-index ul.sponsor-choice li span,.sponsor-pay-dialog-v2 .sponsor-pay-header.border .title,.sponsor-rank-item.normal .sp-right .sp-msg,.sponsor-rank-item.normal .sp-right .sp-user:not(.vip) .sp-name,.sponsor-rank-item.simple .sp-rank i,.sponsor-rank-item.special .sp-right .sp-msg,.sponsor-rank-item.special .sp-right .sp-user:not(.vip) .sp-name,.sponsor-rank-tab li,.sub-pages-item,.tab-box .item,.tab-box .item .desc,.tab-box .item .title,.tab-box .item.active,.tab-mk2,.table-normal tbody tr td,.tabs-nav-item,.tag-list-wrp .title .name,.tag-more .b-toggle-btn,.timeline-box .timeline-item .item-right p.num a,.timeline-box .timeline-item .item-right p.num span,.timer-wrap .quit p,.timer-wrap .vote-dialog-new .footer .b-able,.timer-wrap .vote-dialog-new .footer .b-disable,.timer-wrap .vote-dialog-new .main .main-txt-1 label,.title .s-iconText-text,.tl-head .tl-day.today span,.to-review-btn,.ui-btn.grey-radius,.ui-calendar .flatpickr-day,.ui-calendar .flatpickr-day.inRange,.ui-calendar .flatpickr-month,.ui-calendar .main-wrap .shortmenus a,.user-box .num,.user-info-name,.user-info>.user-name,.user-jump,.user-my-sex .el-radio-button__inner,.user-panel-ctnr .exit-btn,.userinfo-username,.video-floor-m .dynamic-title .title .name,.video-item-biref .biref-info .biref-title,.video-list .vl-hd .tab-list li,.viptable,button.button.more,h2.title,li.season-item .season-body .season-title{color:#eee!important}#bp_user_box,#page-fav .fav-main .fav-video-list.is-batch .small-item.selected,#page-fav .fav-main .fav-video-list.is-batch .small-item:hover,.announce li,.announce li>div span,.announcement-cntr,.app-body .section-block.with-bottom-radius,.app-body .section-block.with-radius,.article-content-ctnr,.assist-wrap .assist-log header .tools .ui-calendar input[type=text],.author-info,.b-info,.backdrop .title-box,.bangumi-collection-card .bangumi-funcs .btn-unfollow,.bangumi-collection-wrapper .bangumi-collection-count,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow.followed,.bangumi-list-wrapper .top-block,.bangumi-media,.bangumi-media .bangumi-media-header .btn-more-review,.bangumi-nav-right .nav-goto-top,.bangumi-nav-right .nav-mini-switch,.bb-intro-top,.bb_box,.bgray-btn,.big-game-gift-warp,.big-gift-btn-home,.big-more-item-list,.big-more-tool-btn,.big-name-warp,.big-pendant-warp,.big-privilege-warp,.big-watch-wrapper,.bili-btn.plain,.bili-header-m .i_menu_login,.bilibili-player .bilibili-player-auxiliary-area,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-filter,.bilibili-player .bilibili-player-block-filter-function .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player .bilibili-player-block-filter-type .bilibili-player-block-filter-image .bilibili-player-block-filter-disabled,.bilibili-player .bilibili-player-panel-title,.bilibili-player-block-tabpanel,.bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.bilibili-player-border,.bilibili-player-color-picker-container .bilibili-player-color-picker-input-group .bilibili-player-color-picker-color-code,.bilibili-player-color-picker-container .bilibili-player-color-picker-input-group .bilibili-player-color-picker-color-current,.bilibili-player-danmaku-setting-lite-panel .bilibili-player-danmaku-setting-lite,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric,.bilibili-player-mode-selection-row .row-selection .selection-span.active .selection-name,.block-area .timeline-title .headline .timeline-more,.bp-user-box-top,.bp_box,.bp_box_top,.btn-confirm.disabled,.btn-disabled,.btn-dufault,.btn-pay-wrapper.is-vip a,.buy-info-box,.cc-nav-wrp,.coin-calendar-wrap,.coin-record .table-wrapper,.comment-ctnr,.container .host-list-layout .hot-list-wrap .hot-song-list,.container .host-list-layout .hot-list-wrap .show-more-song,.container .middle-tip .change-song,.container .musician-recommend .recommend-item,.container .tag,.contri-condition .contri-search,.danmaku-wrap .player-auxiliary-block-wrap,.danmu-container,.dashboard,.dashboard li.like,.data-card .tab .data-tab,.el-pager li.active,.el-pagination .btn-next,.el-pagination .btn-prev,.el-pagination button.disabled,.el-pagination__editor,.el-select-dropdown,.el-textarea__inner,.emoji-box,.episode-item,.face-g-action,.face-g-action[id=face-g-change],.face-g-item,.face-g-item-inner,.face-g-list .face-g-block,.face-g-list .mp-block .left .mp-img,.face-g-list[id=face-g-log] td,.face-g-preview,.fav-main .fav-action-top,.fav-main .fav-action-top .back-to-info,.first-change-lb,.follow-container .follow-right .unfollow-btn,.footer .border,.footer-content,.footer-content .menu-item,.footer-content .qrcode-wrp,.get-coin-more,.gift-item-wrap .num,.h-list-icon,.hold-list,.hold-list-width.details-list-t,.home-daily-task-warp,.home-mp,.home-top-level-mask-warp,.identmagTop,.income-card .income-box .empty-data,.index-info,.info-model .border-b,.integrity-table-wrapper,.invitation-top-warp,.invtable tr th,.link-top-container,.m-help,.main-container .bangumi-info-wrapper,.main-container .player-wrapper,.main-container .sponsor-wrapper,.main-content-title,.medal header,.medal-list .part .content,.medal-up-trueLove,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-title .media-tag,.media-sponsor-wrapper,.media-tab-detail-wrp .media-tab-detail .media-tab-module-wrp,.media-tab-detail-wrp .media-tab-detail-l .media-tab-module-wrp,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .mode-select,.media-tab-module-wrp .media-tab-module-more,.media-tab-module-wrp .media-tab-module-write.type-btn,.misl-ep-item,.mod-1 .r,.mod-1 .r .up-info .v-date,.mod-2 li,.mod-3 .l-item,.modal-head,.mp-mine-avatar,.mp-mine-takedown,.nav-item-ctnr.expanded .nav-item,.nav-item-ctnr.expanded .sub-pages-item-ctnr,.nav-list li,.new-stat-module .zone-title .headline .new-stat-more,.notice-card .title,.pagelistbox .p,.pager .jump-pager input[type=text],.paging-box-big .next,.paging-box-big .prev,.pgc-rank-dropdown,.player-auxiliary-context-menu-container,.player-auxiliary-danmaku-date-picker-container,.player-auxiliary-modal-btns .bpm-btn,.player-auxiliary-modal-container,.player-auxiliary-setting-menu-wrap,.points-box,.points-faq-line,.points-how-warp,.points-pendant-warp,.points-record-warp,.prize-img,.record-exp-table-wrapper,.record-exp-title,.record-item,.record-nav,.review-feed-item,.review-list-wrp li,.section .count,.security-list .child-list,.security-list .first-level,.security-list-jump,.security-right-title,.security-title,.security-ul,.security_content,.selector-wrapper .city-selector-wrapper,.selector-wrapper .more-city-letter-list,.selector-wrapper .more-type-wrapper,.selector-wrapper .type-selector-wrapper,.setting .watermark-setting,.share-module .share-list .weixin-share-modal,.share-module .share-list li.share-btn.btn-app,.side-bar,.side-bar-popup-cntr,.song-comment,.song-title,.sort-type-wrp ul,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-btn-primary.disabled,.sponsor-pay-dialog-v2 .sp-pay-index ul.sponsor-choice li input,.sponsor-pay-dialog-v2 .sponsor-pay-header.border,.sponsor-rank-item.simple .sp-msg,.sponsor-rank-item.simple .sp-rank i,.sponsor-rank-item.special .sp-right .sp-msg,.sr-t,.table-normal tbody tr,.table-normal thead tr td,.table-wrapper,.tabnav,.tabs-mk2,.tabs-nav,.tag-list li.tag-item,.timeline-header .tl-weeks:after,.timer-wrap .vote-dialog-new .header,.ui-calendar .flatpickr-day.inRange,.ui-calendar .main-wrap .shortmenus,.ui-serch input[type=text].ui-input,.user,.user-hd,.user-my-sex .el-radio-button__inner,.user-setting-warp .padding-dom,.video-list .vl-hd,.video-model .border-b,.viptable tr th,.wear-list li,.word-limit-h5 textarea,.works-ctnr,button.button.more,table.invtable td,table.viptable td{border-color:transparent!important}.bp-user-box-bb,.bpui-button-text-only .bpui-button-text .bpui-flex-wrap,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont,.elec .elec-monthly-count,.go-secuirty,.h-list-item,.h-mp-space,.home-to-space,.home-to-update,.home-userstatus,.points-pendant-item,.right-more-btn,.season-timeline .season-group,.season-timeline .season-group .group-time:before,li.history{border-color:#aaa!important}.hot-live .room-list,.player-auxiliary-danmaku-date-picker-header,.player-auxiliary-modal-header,.table-normal tbody tr td,.table-normal thead tr td{border-color:#444!important}.player-auxiliary-block-tabpanel .player-auxiliary-block-string-short:not(:focus),.player-auxiliary-block-tabpanel .player-auxiliary-block-string:not(:focus){border-color:#666!important}.audioplayer svg:not(.ap-svg-exclude) path,.audioplayer svg:not(.ap-svg-exclude) polygon,.player-auxiliary-danmaku-date-picker-btn{fill:#aaa!important}.block-area .timeline-toggle-block .timeline-toggle-btn i,.go-secuirty .m-arrow,.growup-participate .status_box img,.h-mp-space .m-arrow,.home-to-space .m-arrow,.i-m-title .icon-i-title,.new-stat-module .zone-title .headline .new-stat-more .icon,.pgc-rank-dropdown .icon-arrow-down,.right-more-btn .m-arrow,.sec-rank .more-link .icon-arrow-r,.security-list-jump-icon,.svg-icon.top1,.tag-more .b-toggle-btn .b-icon-toggle-down,.tag-more .b-toggle-btn .b-icon-toggle-up,.tl-head .today .day-of-week{filter:brightness(0) invert(1)!important}#page-fav .fav-main .fav-action-bottom .icon,#page-fav .fav-main .small-item.selected .video-check,.bangumi-list-wrapper .top-block .mode-select li.detail-mode.selected,.bangumi-list-wrapper .top-block .mode-select li.detail-mode:hover,.bangumi-list-wrapper .top-block .mode-select li.simple-mode.selected,.bangumi-list-wrapper .top-block .mode-select li.simple-mode:hover,.big-banner-warp .swiper-pagination-bullet-active,.bili-header-m .bilibili-suggest .cancel:hover,.coin-icon,.coin-operated-m .close:hover,.comment-wrap header h2 .head-icon,.fans-question,.fjw-random header h2 .head-icon,.info-model header h2 .head-icon,.season-slider-wrapper .slider-wrapper .season-slider-list li.cur,.sl-ep-nav .mode-select li.detail-mode.selected,.sl-ep-nav .mode-select li.detail-mode:hover,.sl-ep-nav .mode-select li.simple-mode.selected,.sl-ep-nav .mode-select li.simple-mode:hover,.swiper-button-next:hover,.swiper-button-prev:hover,.timer-wrap .timer-top h2 .head-icon,.video-model header h2 .head-icon,.wrapper .modal-close:hover{filter:var(--blue-image-filter)!important}.block-area .timeline-title .headline .timeline-more i,.episode-item .mark-icon.badge-pink-first,.episode-item .mark-icon.badge-pink-vip,.publish-panel .publish-list .publish-item a,.season-timer .current-timer:before,.tag-list li.tag-item .hot,.toolbar-wrapper .scroll-icon,.toolbar-wrapper .service-icon,.user-panel-ctnr .ctrl-btn .svg-icon,li.season-item .season-body .season-title span.follow{filter:var(--pink-image-filter)!important}.coin-operated-m .close,.first-change-lb i,.history-list .r-info .device-i,.history-list .r-info .history-delete,.i-live .i-live-m,.i-live .i-live-off-guest a .i-live-arrow,.review-list-wrp li .review-data div.review-data-comment embed,.review-list-wrp li .review-data div.review-data-comment i,.tag-list .tag-icon,.wrapper .modal-body .elec-protocol .checkbox.checked,.wrapper .modal-close{filter:grayscale(1)!important}.cc-album-manage .info-wrp .no-img,.cc-article-wrp .info-wrp .img,.charge-participate .benefit-item .pic,.compila-not-find .compila-not-find-image,.contri-not-find .contri-not-find-image,.live-module .tab-item .r-item .r-i-t .u-online i,.log-empty img,.text-article-wrp .info-wrp .img{filter:brightness(.72)!important}.primary-menu .nav-menu .sub-nav li>a span:after{filter:none!important}.coin-icon-done,.h-safe-icon[class$=no]{filter:brightness(.5)!important}.i-live .i-live-fo-btn,.i-live .i-live-unfo-btn{border-radius:4px!important}.danmu-container,.timeline-header,.timeline-header .tl-weeks,.timeline-wrapper{box-shadow:none!important}.bili-header-m .i_menu_login,.link-popup-panel,.player-auxiliary-context-menu-container,.side-bar-popup-cntr{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bangumi-coin-wrap .bangumi-coin,.bangumi-coin-wrap .bangumi-coin-d,.bangumi-collection-wrap .bangumi-order,.bangumi-collection-wrap .bangumi-order-d,.bangumi-list-wrapper .bottom-block .slider-contro i.slider-next-mask,.bangumi-list-wrapper .bottom-block .slider-contro i.slider-prev-mask,.bangumi-order-wrap .bangumi-order,.bangumi-order-wrap .bangumi-order-d,.empty-hint .hint-img,.home-level-mask-icon,.side-bar-popup-cntr>.arrow,.sponsor-rank-item.special .sp-right .sp-msg>span,.sponsor-rank-item.special .sp-right .sp-msg>span:before,.top_bg{display:none!important}#audience-page .version-switch-section .bili-tab.current,#page-fav .fav-main .filter-item.search.focus,.bangumi-list-wrapper .top-block .ss-list-wrapper .slider-contro,.bili-tab.current,.bili-tab.current:after,.bilibili-player .bilibili-player-block .bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player .bilibili-player-block .bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-user,.bpui-button-text-only.bpui-state-active .bpui-button-text .bpui-flex-wrap,.bpui-selectmenu,.bpui-tab-list-type-button .bpui-tab-list-row.bpui-state-selected,.btn-confirm,.bui-tabs .bui-tabs-header .bui-tabs-header-item.bui-tabs-header-item-active,.carousel-wrapper .carou-mini .thumb-cursor,.coin-nav .on,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont:hover,.container .musician-recommend .recommend-item .recommend-info .listen-btn,.container .song-list .song-li .song-shadow,.contri-condition .contri-select.active,.contri-condition .contri-select.active:after,.data-card .data-box .tab .fan-tab.current,.data-card .data-box .total .incr-num:before,.data-card .fans-box .tab .fan-tab.current,.data-card .fans-box .total .incr-num:before,.data-card .tab .data-tab.current,.dynamic-list-item-wrap .item-user a.stick,.face-g-item:hover,.face-g-list .mp-block .right ul li.base .round,.face-g-list .mp-block .right ul li.base.reach .round,.go-movie,.link-input:focus,.link-top-container .link-top-item.active,.media-sponsor-wrapper .sponsor-rank-header .show-sponsor-rank:hover,.media-tab-nav ul li.on,.media-tab-nav ul li:hover,.pagelistbox .p.active,.pagelistbox .p:hover,.points-btn,.project-list .project-list-item .promo-item,.record-nav .on,.review-list-wrp li .review-title .review-spoiler,.season-item.on,.season-item.on:after,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on:after,.song-li .song-left .song-shadow,.sponsor-rank-tab .indicator,.sponsor-rank-tab .indicator:after,.tab-mk2.active,.tabnav-item.current .tabnav-content,.user-info>.tag-flag,.video-list .vl-hd .order-tab li.on{border-color:var(--theme-color)!important}.audioplayer .ap-controller .ap-controller-right .ap-volume-thumb-dot,.author-info .favourite-btn,.b-info .button,.ban-detail .content-box .vote-success .success-txt button,.big-member-btn,.big-member-btn .btn-confirm.disabled,.bili-btn.ok,.bili-header-m .i_menu_login .login-btn,.bilibili-player-ending-panel-box-functions .bilibili-player-pgcinfo-follow-binge-watching,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric,.block-area .timeline-title .headline .timeline-more:hover,.bpui-button-text-only.bpui-state-active .bpui-button-text .bpui-flex-button,.btn-confirm,.btn-dufault:not(.btn-disabled),.bui-button.bui-button-blue,.bui-button.bui-button-gray3:hover,.carousel-module .panel .trig span.on,.cc-album-manage .info-wrp .cc-btn,.cc-btn.is-main,.cc-nav-wrp .nav-upload-btn>a,.charge-participate .part-btn,.coin-text-p .coin-i,.compila-condition .compila-right .compila-add.single,.compila-not-find .compila-not-find-ime,.contri-not-find .contri-not-find-ime,.el-pager li.active,.face-g-action[id=face-g-change],.face-g-list .mp-block .right ul li.reach .strip,.face-g-takedown,.face-g-takedown:hover,.face-g-use,.face-g-use:hover,.go-movie:hover,.h .h-follow,.h-safe-btn,.history-list .cover-contain .label,.host-list-layout .hot-list-wrap .bg-wrap .top-info-content .right-info .right-btn,.hot-box li .tag-type,.intimacy-bar>span,.invitation-btn,.live-module .tab-item .r-item:first-child .number,.live-module .tab-item .r-item:nth-child(2) .number,.live-module .tab-item .r-item:nth-child(3) .number,.live-status.on-live,.media-sponsor-wrapper .sponsor-right-area .sponsor-btn,.mp-mine-takedown,.new-stat-module .zone-title .headline .new-stat-more:hover,.news-list .news-item .type,.notice-card .academy-entry,.pagelistbox .p.active,.pagelistbox .p:hover,.paging-box-big .next:hover,.paging-box-big .prev:hover,.points-btn,.primary-menu .nav-menu .channel.on::after,.progress-bar-inner,.season-timeline .season-group.today .group-time:before,.section-item .diff-wrp .no-improve,.security-left .security-ul .security-list.on,.security-right-title-icon,.selector-wrapper .more-city-letter-list .more-city-letter-item .letter-item.active:after,.song-playbtn,.timeline-box .timeline-item.new p.num a,.timer-wrap .vote-dialog-new .footer .b-able,.tit-b,.tl-head .tl-day.today .indicator,.wrapper .elec-message-wrp .elec-msg-btn{background-color:var(--theme-color)!important}#audience-page .version-switch-section .bili-tab.current,.acc-sec,.announce li .fontvt,.announce li>div span,.audioplayer .ap-controller .ap-controller-right .ap-playlist-button:hover .ap-playlist-button-amount,.author-info .communicate-btn,.author-info .link-pink:hover,.bangumi-home-crumb .fcname ul.n_num li.on a,.bangumi-media .bangumi-media-header .btn-more-review:hover,.bangumi-media .bangumi-media-header .rate-wrapper .btn-go-write:hover,.bangumi-review-item>a:hover .long-title,.bb-intro-top .b-question .b-question-title:hover,.big-more-item-item:hover .big-more-item-txt,.bili-tab.current,.bilibili-player-context-menu-container span.bppl-state-selected,.bilibili-player-ending-panel-box-functions div.active,.bilibili-player-ending-panel-box-recommend-add-watchlater .icon-22wait-choice,.bilibili-player-video-sendbar .bilibili-player-video-danmaku-wrap a,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a:hover,.block-area .timeline-toggle-block .timeline-toggle-btn:hover,.bottom-help a,.bp_box_bot a:hover,.bpui-button-text-only.bpui-state-active .bpui-icon-checkbox.icon-12select,.bpui-button-text-only.bpui-state-active .bpui-icon-checkbox.icon-12select-round,.bread-crumb ul li.on a,.bread-crumb ul li:hover a,.btn-delete:hover,.bui-button.bui-button-text,.bui-tabs .bui-tabs-header .bui-tabs-header-item.bui-tabs-header-item-active,.buy-detail .rights,.charge-participate h1,.chat-history-panel .chat-item.welcome-guard .username,.cm-model .report-detail .more-list a,.coin-nav .on,.coin-num,.coin-operated-m .mc-box.on .c-num,.container .host-list-layout .hot-list-wrap .hot-song-list .song-info .song-content .iconfont:hover,.container .host-list-layout .hot-list-wrap .show-more-song:hover,.container .host-list-layout .hot-list-wrap .show-more-song:hover .iconfont,.container .musician-recommend .recommend-item .recommend-info .listen-btn,.container .tag .item-btn,.contri-condition .contri-select.active,.contri-condition .contri-sort .contri-sort-type li:hover,.control-panel-ctnr .title,.danmu-container .empty-danmu a,.data-card .data-box .tab .fan-tab.current,.data-card .fans-box .tab .fan-tab.current,.data-card .tab .data-tab.current,.dynamic-list-item-wrap .item-user a.stick,.episode-item.on .ep-index,.episode-item.on .ep-title,.episode-item.on:hover .ep-index,.episode-item.on:hover .ep-title,.follow-container .follow-right .follow-intro .follow-fold,.go-movie,.h-safe-a,.home-top-level-mask-warp a,.hot-box li:hover .txt,.hotsong-li .font24:hover,.hotsong-li .hotsong-title a:hover,.i-live .i-live-fo-btn,.i-live:hover .i-live-title,.icon-edit,.lh12 a,.link-footer a:hover,.link-popup-panel .title-ctnr .popup-title,.live-ctn .live-attch .host:hover,.live-ctn .live-attch .title:hover,.live-module .tab-item .r-item a:hover .u-name,.live-module .zone-title .headline .online span,.m-help:hover,.main-content-title a,.medal .medal-form .page-tip a:hover,.media-info-card .mic-expand:hover,.media-sponsor-wrapper .sponsor-rank-header .show-sponsor-rank:hover,.media-tab-module-wrp .media-tab-module-more:hover,.media-tab-nav ul li.on,.media-tab-nav ul li:hover,.mini-item .detail a:hover,.misl-ep-item:hover .misl-ep-text .misl-ep-index,.misl-ep-item:hover .misl-ep-text .misl-ep-title,.mod-1 .r .title:hover,.mod-1 .r .up-info .v-author:hover,.mod-2 li .r .title:hover,.mod-2 li .r .up-info .v-author:hover,.mod-3 .r .title:hover,.mod-3 .r .up-info .v-author:hover,.nav-upload-container .nav-upload-item>p,.out-link,.pagination-wrapper .pagination .pageNum.active,.pagination-wrapper .pagination .pageNum:hover,.player-auxiliary-auxiliary-area .player-auxiliary-filter-menu:hover,.player-auxiliary-block-list .player-auxiliary-block-line-state,.player-auxiliary-setting-menu-wrap .player-auxiliary-setting-menu-list:hover,.points-num,.project-list .project-list-item .promo-item,.record-exp-title .s,.review-feed-item .feed-left .review-about .author-info:hover,.review-feed-item .feed-left .review-about .media-title:hover,.review-feed-item .feed-left .review-info:hover .review-title,.review-list-wrp .review-detail:hover .review-title,.review-list-wrp li .review-author-info div.review-author-name:hover,.review-list-wrp li .review-title .review-spoiler,.room-introduction-content a,.season-timeline .season-group.today .group-time,.season-timer .current-timer,.season-timer .season-label,.section-item .text-content,.security-right-title-text,.selector-wrapper .city-list .city-item.active,.selector-wrapper .city-list .city-item:hover,.selector-wrapper .li-more .active,.selector-wrapper .more-city-list .more-city-item:hover,.selector-wrapper .order-list .city-item.active,.selector-wrapper .order-list .city-item:hover,.setting .section-edit,.share-module .share-list .weixin-share-modal .share-tips a,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item:hover,.slot-ctnr .panel li:hover,.song-info .song-info-content a,.song-infoFold,.song-introText,.song-li .song-right .song-intro a:hover,.song-lrcFold,.song-title .font18,.sort-type-wrp ul li:hover,.sponsor-pay-dialog-v2 .sp-pay-index .sponsor-agree a:hover,.sponsor-rank-tab li.active,.sponsor-rank-tab li:hover,.sub-nav-m ul li a:hover,.sub-nav-m ul li.on a,.tab-mk2.active,.tab-mk2.tab-mk2-r,.tab-mk2:hover,.tabnav-item.current,.tag-more .b-toggle-btn:hover,.timeline-box .timeline-item .item-right a:hover,.title-link,.toolbar-wrapper,.toolbar-wrapper .toolbar-title,.ui-calendar .main-wrap .shortmenus a:hover,.union-cntr a,.user-box .btn,.user-box .btn:active,.user-box .vip-btn,.user-info-name.active,.user-info>.tag-flag,.user-panel-ctnr .exit-btn:hover,.video-list .vl-hd .order-tab li.on,.video-list .vl-hd .type-tab li.on,.wrapper .elec-sub-title .exp,.wrapper .elec-sub-title .vip-point,a.bp_box_bot_click,button.button.more:hover,li.season-item .season-body .season-desc.published,li.season-item .season-body .season-title:hover,span.flatpickr-weekday{color:var(--theme-color)!important}.author-info .favourite-btn,.big-member-btn,.bili-header-m .i_menu_login .login-btn,.bili-header-m .i_menu_login .reg a,.btn-confirm,.btn-dufault:not(.btn-disabled),.bui-button.bui-button-blue,.bui-button.bui-button-gray3:hover,.comment-video,.fav-main .fav-action-bottom .select-cancel,.h .h-follow,.h-safe-btn,.history-list .cover-contain .label,.hot-box li .tag-type,.live-module .tab-item .r-item .number,.live-module .tab-item .r-item:first-child .number,.live-module .tab-item .r-item:nth-child(2) .number,.live-module .tab-item .r-item:nth-child(3) .number,.live-status.on-live,.news-list .news-item .type,.pagelistbox .p.active,.pagelistbox .p:hover,.paging-box-big .next:hover,.paging-box-big .prev:hover,.wrapper .elec-message-wrp .elec-msg-btn{color:var(--foreground-color)!important}.bilibili-player-ending-panel-box-functions div.active .bp-svgicon,.bilibili-player-ending-panel-box-functions div.active:hover .bp-svgicon{fill:var(--theme-color)!important}.b-info,.bb-intro-top,.bili-footer .boston-postcards li,.container,.danmu-container,.el-picker-panel [slot=sidebar],.el-radio-button:first-child .el-radio-button__inner,.h-line,.media-info-count .media-info-count-item,.mod-2 li .l-item,.security-right,.sl-ep-nav .sl-ep-nav-list .sl-ep-nav-item.on:after,.sponsor-rank-tab .indicator:after,.video-list .vl-hd .s-line{border-left-color:transparent!important;border-right-color:transparent!important}#community_msg,#page-channel-detail .watch-later-btn,#rankList .list-wrap .list .switch-day .switch-list:hover,.academy-card.card,.app .module-card.comment,.area-item-ctnr .area-item:hover,.article-action .ops .share-container .weixin-holder,.audioplayer .ap-controller,.audioplayer .ap-playlist,.audioplayer .ap-playlist .ap-playlist-body,.banner-wrapper .swiper-pagination-bullet,.bb-comment .comment-emoji,.bili-header-m .head-banner,.bili-radio+span::before,.bili-switcher,.bilibili-evolved-about,.bilibili-player-video-sendbar,.bnj-comment .page-comment,.bui-sns-info a .bd,.cc-content-body .setting,.chatPanelBody .chatPanel,.chatPanelBody .chatPanel .chatPanelList,.coin-wrap,.data-card.card,.date-input .date-panel,.date-input>input,.dc-section-body,.download-video-panel,.el-date-table td,.el-date-table td.in-range:hover,.el-pager li,.el-pagination .btn-next,.el-pagination .btn-prev,.el-pagination button.disabled,.el-pagination__editor,.error-body,.footer .text-layout,.grid .banner,.gui-settings-dropdown>ul,.gui-settings-flat-button .popup,.gui-settings-widgets-box,.guide-card.card,.h5share-container .image-area .share-img,.income-card.card,.input-section .schedule-panel .s-input,.input-section .schedule-panel .s-panel,.js-evaluateArea .evaluateDialog,.leaveMsg .leaveMsgBody .classDropdown-menus li a:hover,.leaveMsg .leaveMsgBody .classDropdown-menus li:hover,.leaveMsg .leaveMsgHeader,.link-navbar-ctnr,.link-popover-ctnr .link-popover,.live-ctn .item-live,.live-status.offline,.main-container .plp-l .player-mask .bar-wrapper .left-bar,.main-container .plp-l .player-mask .bar-wrapper .right-bar,.mainBox .leaveMsg,.mainBox .sureWindow,.medal-get-box,.medal-message-box,.medal-popup,.medal-up-trueLove,.nav-guide-container .nav-guide-tip,.nav-header-wrapper .nav-header .nav-header-search-bar-wrapper .suggestion-list,.notice-card .notice-list .notice-item,.notice-card.card,.notice-panel .img-container .notice-img,.open-dialog-masker .open-dialog-content,.play-options .play-options-more .play-options-content .play-option,.play-options .share-box,.project-list .project-list-item .project-list-item-img,.rank-item .content,.rank-tab-wrap,.sch-pub-tips,.sch-pub-tips::after,.search-module .search-block .search-word-panel,.search-module .search-block .search-word-panel .panel-title p span,.setting .watermark-setting .watermark-wrp .watermark-modal,.toast-card,.twp-mask .twp-wrapper,.uns_box li .i_menu,.uploader-info .info .follow .num,.user-info .user-info-desc,.user-panel-ctnr .user-avatar,.withdraw-wrapper .withdraw-text,div#square.container{background-color:#222!important}.article-holder .error-card .video-holder .video-cover,.article-holder .error-card .video-holder p,.player-auxiliary-danmaku-function .player-auxiliary-danmaku-multiple-control{background-color:#333!important}#activeCenter .s-imgUnit .s-imgUnit-img,#rankList .list-wrap .list .switch-day,.act-card-wrap .act-card .type,.app .module-card,.article-item .item-holder .article-title-holder .list-mark,.audioplayer .ap-controller .ap-controller-center .ap-play-bar-wrap,.audioplayer .ap-controller .ap-controller-left .ap-cover,.audioplayer .ap-controller .ap-controller-right .ap-playlist-button-bg,.audioplayer .ap-controller .ap-controller-right .ap-volume-bar-wrap,.audioplayer .ap-playlist .ap-playlist-body li.ap-playlist-line-active,.audioplayer .ap-playlist .ap-playlist-body li:hover,.bili-share-pc,.bili-share-pc .share-weixin-qr,.bili-share-pc .weixin-hover .qr-before,.bilibili-live-player-ending-panel-recommend-card,.canvas-card dt .img-contain,.card .img-box,.card .user-face,.card-timing-module .r-text .update a,.container .host-list-layout .hot-list-wrap .bg-wrap,.container .song-list .song-li .song-img,.content-panel .title span,.dynamic-list-item-wrap .send-bg,.el-date-table td.in-range,.el-picker-panel__shortcut:hover,.el-select-dropdown.is-multiple .el-select-dropdown__item.selected.hover,.el-select-dropdown__item.hover,.el-select-dropdown__item:hover,.error-container,.evaluate .situation span,.evaluateWether .evaluate-btn,.face-g-list .mp-block .right ul li.base .round,.footer-content .social-item,.form-login .input-box .btn-box .btn,.form-login .input-box .item input,.guide .old-btn a,.guide-card .guide-box a,.index-nav .n-i.gotop .btn_gotop,.leaveMsg .leaveMsgBody .classDropdown-menus,.leaveMsg .leaveMsgBody .questionClassify .classDropdownAreaFixed,.leaveMsg .leaveMsgBody .questionClassify .classDropdownAreaFixed .router,.leaveMsg .leaveMsgBody .questionClassify .classIfyTitleArea,.list-wrap .s-showMore,.list.main_body .list_box .next_button,.magBox .msgDiv,.main-container .plp-l .player-mask .bar-wrapper,.main-container .title>span,.main_body .future .next_button,.nav-guide-container .guide-tip-btn .guide-tip-btn-right,.nav-panel-vc,.notify-v2-container>div,.open-dialog-masker .btn-normal,.page-content .right-side .rank-module .complete-rank,.page-content .right-side .up-list .fresh-btn,.pie-empty-wrapper,.play-options .play-options-more .play-options-content .play-option:hover,.play-up-info .play-up-intro .play-up-follow .play-up-followed,.player-auxiliary-area .player-auxiliary-collapse-playlist .bui-collapse-body,.progress-tv,.progress-tv .progress-img,.rank-module .rank-list .item .rank-index,.result-list .user-face,.s-lineMore-more,.s-rank.gray,.search-module .search-block .search-word-panel .history-item:hover,.search-module .search-block .search-word-panel .suggest-item:hover,.security-list .child-list li a:hover,.share-box .share-popup .share-address ul li input,.slide-controller .slide-btn,.sureWindow .btngroup span,.up-info .u-face .up-face,.upload-v2-step1-container .video-jam .video-jam-comment,.user-hd,.user-info .points-wrp .bar,body>div.to-top.on{background-color:#444!important}.bilibili-player-video-time-seek{background-color:#fff1!important}.blp-ui-slider-container{background-color:rgba(0,0,0,.1)!important}.mainBox .sureWindowlayer,.medal-mask,.qrcode-login .qrcode-con .qrcode-box .status{background-color:rgba(0,0,0,.5)!important}#mp-mine-header,#mp-mine-header.active,.fans-icon,.guide-card .guide-box a,.rank-list .canvas-card:nth-child(-n+3)::after{background-image:none!important}#announcement-area .more-link:hover,#app>div>.container,#app>div>div>div.container,#rankList .list-wrap .list .switch-day .switch-list,#song_detail_click_upper~div .pager .pages .page-item button,#song_detail_click_upper~div .pager .pages .page-item.active button,.area-section .card-ctnr .more,.area-section .card-ctnr .more:hover,.article-list-holder .article-item,.bb-comment .con,.bb-comment .hot-line span,.bb-comment .list-item:hover,.bb-comment .more-link:hover,.bb-comment .result,.bili-header-m.report-wrap-module,.bilibili-player-danmaku-report-panel .bui-radio-input:checked+.bui-radio-label,.bilibili-player-video-bottom-area::before,.chat-history-panel .chat-history-list .chat-item.system-msg .msg-icon,.create-vote .bg-color,.date-input,.filter-wrap .sub-filter,.i-frame,.idol-show .section-title .more,.idol-show .section-title .more:hover,.index-nav .n-i .name:hover,.input-section,.input-section .schedule-panel,.leaveMsg .leaveMsgBody .email,.leaveMsg .leaveMsgBody .telephone,.leaveMsg .submitArea,.link-panigation-ctnr .pagination,.link-progress-tv,.live-sidebar-ctnr,.main-container .review-module .module-title .more-link,.mode-fullscreen .bilibili-player-video-btn-widescreen,.mode-fullscreen .bilibili-player-video-sendbar,.mode-webfullscreen .bilibili-player-video-sendbar,.page-content .right-side .up-list,.pagelistbox .custom-right .custom-right-inner,.play-options .play-options-more .play-options-content,.player-auxiliary-area,.popularize-module .online,.rank-list-ctnr,.rank-module .rank-list .item,.result .card,.search-module .search-block input,.singlePage .mainBox,.title-line .tit{background-color:transparent!important}.coin-wrap .coin-nav .coin-checkbox{background:#fff!important}.bottom-actions .action-item{color:#222!important}.date-input .date-panel .day.disabled{color:#444!important}.announcement-cntr .header p .icon-edit,.announcement-cntr .header p span,.article-action .ops .share-container .weixin-holder p,.article-action .ops i,.article-holder .music-card .container,.article-item .item-holder .article-desc,.article-item .item-holder .article-info-bar .category,.article-item .item-holder .article-info-bar .like,.article-item .item-holder .article-info-bar .reply,.article-item .item-holder .article-info-bar .up-content .nick-name,.article-item .item-holder .article-info-bar .view,.bangumi-rating-container .bangumi-rating-subtitle,.bb-comment .bottom-page.center,.box .content .item,.bui-button.bui-button-gray3,.channel-info .meta,.chatPanel .historyTrigger,.chatPanelList .msgData,.coin-wrap .coin-tips,.container .hot-list .music-menu-list .menu-type,.container .left-container .play-options,.container .left-container .play-up-info .play-up-self-btn,.container a,.danmu-hot .tab-list .tab,.date-input .date-panel .week,.dc-section-item_title_time,.dynamic-m .dyn_list_wrapper .dyn_list li.loading,.elec .elec-monthly-count,.elec-message-wrp .elec-count-wrp,.evaluate .h2,.fans-no-data-wear::after,.fans-no-data::after,.footer-content .social-item,.form-login .input-box .sns .btn,.hot-list .card-ctnr .room-count .icon-font,.leaveMsg .leaveMsgBody .guide,.leaveMsg .leaveMsgBody .infoArea .infoAreaTitle,.leaveMsg .leaveMsgBody .questionClassify .classText,.leaveMsgUpload .btnarea span.btareatxt,.magBox .leftName,.more .help .info,.more .link .info,.nav-guide-container .nav-guide-tip .guide-tip-content-main h3 span,.nav-guide-container .nav-guide-tip .guide-tip-content-main p,.no-data-integrity,.open-dialog-masker .open-body ul li i,.open-dialog-masker .open-footer .open-agree,.page-container .article-action,.play-options .share-box .share-btn ul .bili-share,.play-up-introduction .play-up-sign,.qrcode-login .qrcode-footer .app-link,.qrcode-login .qrcode-footer .suc-txt,.questionClassify .classDropdownAreaFixed .router .routerDeep,.rank-item .content .info .bangumi-info,.rank-module .rank-tabs-bar .rank-tabs-list li,.record-item-line .comment-floor,.record-item-line .comment-location,.record-item-line .comment-time,.record-item-line .good,.room-card-item .info .s-info,.s-imgUnit-text p,.s_tag .nothing,.scroll-loading,.search-module .search-block .search-word-panel .panel-title p span,.setting .section-title span,.setting .watermark-setting .tooltip,.setting .watermark-switcher .switcher-tip,.small-item .meta,.twp-mask .twp-wrapper .twp-container .twp-text .twp-desc,.up-feedback .up-fb-btn,.up-list .up-item .info-holder .dynamic,.uploader-info .info .follow .num,.user-info .user-info-desc,.video-list-wrapper .title .text .num,.video-toolbar .appeal-text{color:#aaa!important}#announcement-area .news-ctnr .icon-arrow-right,#announcement-area .news-ctnr .more-link,#announcement-area .rank-ctnr .icon-arrow-right,#announcement-area .rank-ctnr .more-link,#community_msg .dyn_menu li a,#i_menu_profile .info .coin .outside,#i_menu_profile .info a.linkToCurrency,#mangoTv .mango-rank .text-list a,#page-channel-detail .watch-later-btn,#page-playlist-wrap .breadcrumb .item,#rankList .list-wrap .list .bar .text,#rankList .list-wrap .list .switch-day,#rankList .list-wrap .text-list a,.act-card-wrap .act-card .title,.act-card-wrap .act-card .type,.announcement-cntr .header p,.article-holder .bangumi-card a .container .title,.article-holder .card-container .container .title,.article-holder .music-card .container .title,.article-item .item-holder .article-title-holder .list-mark,.bangumi-rating-container .bangumi-rating-title,.banner-wrapper .swiper-pagination-bullet,.base-info .btn-wrapper,.bili-btn.plain,.bili-share-pc .share-weixin-qr h4,.bili-share-pc .title,.bilibili-player-video-control .bilibili-player-video-volume-num,.blink-qrcode .title,.block-effect-ctnr .item,.card-timing-module .r-text .update a,.channel-detail .content .breadcrumb .item,.coin-wrap .coin-title,.container .hot-list .menu-title,.content-panel .title span em,.danmu-hot .video-list .video-wrapper .video .title,.date-input,.date-input .date-panel .ym,.date-input>input,.details-up-name,.el-pager li.btn-quicknext,.el-pager li.btn-quickprev,.el-pagination .btn-next,.el-pagination .btn-prev,.el-pagination__editor,.error-container .error-text,.evaluate .situation span,.evaluateWether .evaluate-btn,.evaluateWether .evaluateTitle,.footer .boston-postcards li .tips,.form-login .input-box .btn-box .btn,.form-login .input-box .item input,.form-login .input-box .remember,.gift-box>.num,.gridview-sidebar .album-title,.gui-settings-dropdown input,.gui-settings-widgets-box,.gui-settings-widgets-box>.widgets-container>*,.guide .old-btn a,.guide-card .guide-box a,.history-dlg .hsbtn .cancel,.input-section .schedule-panel .dp-label,.input-section .schedule-panel .s-input,.input-section .schedule-panel .s-item,.input-section .schedule-panel .s-label,.jumping-ctnr .jumping-input,.leaveMsg .leaveMsgBody .classDropdown-menus li,.leaveMsg .leaveMsgBody .email,.leaveMsg .leaveMsgBody .questionClassify .classIfyTitleArea .classIfyTitle,.leaveMsg .leaveMsgBody .telephone,.leaveMsg .leaveMsgHeader .title,.link-popover-ctnr .link-popover,.link-progress-tv,.list-wrap .s-showMore,.list.main_body .list_box .next_button,.magBox .msgDiv .msgText,.main-container .title>span,.main-container .tool-bar .share-info i,.main_body .future .next_button,.medal-up-trueLove,.media-info .media-content .media-title a,.media-upper .media-upper-info .media-upper-name,.more .help .title,.more .link .title,.more .top-bar,.nav-guide-container .guide-tip-btn .guide-tip-btn-right,.nav-header-wrapper .nav-header .user-panel,.nav-header-wrapper .nav-header .user-panel a,.notify-v2-container>div .notify-v2-close,.notify-v2-container>div a,.notify-v2-container>div>span,.open-dialog-masker .__dialog-header p,.open-dialog-masker .btn-normal,.open-dialog-masker .open-body p,.open-dialog-masker .open-body ul li span,.page-content .left-side .partitio-name,.pgc-rank-dropdown .selected,.play-options .play-options-more .play-options-content .play-option,.play-title .play-title-location,.play-up-info .play-up-intro .play-up-follow .play-up-followed,.play-up-info .play-up-self .play-up-self-content,.play-up-introduction .play-up-name a,.player-auxiliary-danmaku-function .player-auxiliary-danmaku-multiple-control-title,.popularize-module .online a,.rank-item .content .info .title,.rank-module .complete-rank,.rank-module .rank-list .item .rank-index,.rank-module .rank-list .item a,.rank-module .rank-tabs-bar label,.rec-list .info .title,.s-imgUnit-text a,.s-lineMore-more,.s-rank.gray,.sch-pub-tips,.search-module .search-block input,.setting .watermark-switcher span,.share-box .share-popup .share-address ul li input,.similar-song-menu .similar-right .title,.super-gift-item .gift-info .user-name,.super-gift-item .gift-info .user-name:hover,.sureWindow .btngroup span,.sureWindow .title,.twp-mask .twp-wrapper .twp-container .twp-text .twp-title,.u-info .u-name,.up-list .fresh-btn,.up-list .title,.up-list .up-item .info-holder .dynamic .arc-title,.up-list .up-item .info-holder .head .nick-name,.upload-v2-step1-container .video-jam .video-jam-comment,.user-info .points-wrp .points-schedule .now-points,.user-info .user-info-hd .t,.video-list-wrapper .title .more .text,.video-list-wrapper .title .text{color:#eee!important}.list.main_body .right_box .select_box .select .option_block .option.selected,.toast-card .link,.toast-card span,.toast-card-message,.toast-card-title{color:#fff!important}#page-channel-detail .filter,#page-channel-detail .watch-later-btn,#rankList .list-wrap .list,#rankList .list-wrap .list .switch-day,.act-card-wrap .act-card .type,.announcement-cntr .content,.app .module-card,.article-action .ops .share-container .weixin-holder,.article-holder .bangumi-card a .container,.article-holder .music-card,.article-item .item-holder .article-title-holder .list-mark,.bb-comment .bottom-page.center,.bb-comment .hot-line,.bili-share-pc,.bilibili-live-player .bilibili-live-player-enter-tips,.bp-input .content-box::before,.coin-wrap .coin-sure,.container .left-container .media-comment,.container .left-container .play-up-info,.container .right-container .media-theme,.content-panel .title span,.danmu-hot .tab-list,.date-input .date-panel,.date-input>input,.detail-card .card,.el-autocomplete-suggestion__wrap,.el-pager li,.el-pager li:last-child,.el-picker-panel,.el-time-range-picker__body,.evaluate .situation span,.evaluateWether .evaluate-btn,.evaluateWether .noactive,.evaluateWether .okactive,.filter-wrap .sub-filter,.form-login .input-box .btn-box .btn,.form-login .input-box .btn-box .btn-login,.form-login .input-box .item input,.grid .banner,.guide .feedback-btn a,.guide .old-btn a,.index-nav .n-i.gotop .btn_gotop,.input-section,.input-section .schedule-panel .s-input,.input-section .schedule-panel .s-panel,.leaveMsg .leaveMsgBody .questionClassify .classDropdownAreaFixed .router,.link-popover::after,.link-popover::before,.list-wrap .s-showMore,.list.main_body .list_box .block .cover,.medal-get-box,.medal-message-box,.medal-up-trueLove,.more .top-bar,.nav-guide-container .guide-tip-btn .guide-tip-btn-right,.nav-header-wrapper .nav-header .nav-header-search-bar-wrapper .suggestion-list,.open-dialog-masker .btn-normal,.play-options .play-options-more .play-options-content,.play-options .play-options-more .play-options-content .play-option,.play-options .share-box,.rank-module .rank-tabs-bar,.review-module .review-list .empty-wrapper .btn-go-write,.s-lineMore-more,.search-module .search-block .search-word-panel,.share-box .share-popup .share-address ul li input,.title-line,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.confrim,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.ticket,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.vip,.up-list .fresh-btn,.up-list .title,.upload-v2-step1-container .upload-btn,.upload-v2-step1-container .video-jam .video-jam-comment,.uploader-info .info .follow .num,body>div.to-top.on{border-color:transparent!important}.bili-radio+span::before,.channel-info .c-count,.open-dialog-masker .open-body ul li i,.popularize-module .online em{border-color:#aaa!important}.act-card-wrap .act-card,.article-list-holder .article-item,.bili-switcher,.bui-sns-info a .bd,.chatPanelBody .footer,.date-input .date-panel .ym,.el-date-range-picker__content.is-left,.el-picker-panel [slot=sidebar],.el-picker-panel__sidebar,.leaveMsg .leaveMsgHeader,.leftMsg .msgDiv:before,.login-box .line,.medal-receive-title,.open-dialog-masker .__dialog-header,.pagelistbox .custom-right .custom-right-inner.custompage,.search-module .search-block,.search-module .search-block .search-word-panel .panel-title .split-line,.up-info-holder .fixed-box .more .top-bar,.up-info-holder .fixed-box .up-article-list-block .block-title{border-color:#444!important}.singlePage .mainBox{border:1px solid #444!important}.gui-settings-dropdown::after,i.settings-category-arrow::after{border-color:#fff!important}.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a,.player-auxiliary-btn-playlist-order path{fill:#aaa!important}.audioplayer .ap-play-button svg path,.toast-card-dismiss path{fill:#fff!important}#rankList .list-wrap .list .switch-day .icon-bottom,.breadcrumb .arrow,.change-push .icon,.compact .primary-menu .nav-menu .side-nav .side-link i.blackroom,.compact .primary-menu .nav-menu .side-nav .side-link i.live,.compact .primary-menu .nav-menu .side-nav .side-link i.square,.compact .primary-menu .nav-menu .side-nav .side-link i.zhuanlan,.compact .primary-menu .nav-menu>li.home>a,.error-container .error.split,.leaveMsg .leaveMsgBody .questionClassify .classIfyTitleArea .classIfyTitleIcn,.list-wrap .s-showMore .icon-right,.nav-header-wrapper .nav-header .user-panel .panel-list .icon,.page-content .right-side .up-list .fresh-btn:before,.s-lineMore-more .icon-right,.security-list .first-level .m-arrow,.slide-controller .slide-btn .icon,[class^=icon-]::after{filter:brightness(0) invert(1)!important}.funcPanel .addFace,.funcPanel .capture,.funcPanel .evaluate,.funcPanel .leaveMessage,.funcPanel .zhichiClose,.tool-box-v2-container .icon-download,.tool-box-v2-container .icon-tv{filter:brightness(0) invert(.7)!important}#article-list-index .index-holder .article-item.on .point,#article-list-index .title-holder .icon-close,#page-channel-detail .watch-later-btn:hover,.banner .slides-pagination li.selected,.block-effect-ctnr .item .cb-icon,.bp-svg-icon.link,.bui-radio-icon.bui-radio-icon-selected,.bui-sns-info>a>img,.carousel .indicator .indicator-btn-holder .indicator-btn.on,.cc-nav-wrp .logo,.coin-operated-m .like-checkbox input[type=checkbox]:checked+i,.el-carousel .el-carousel__indicators .el-carousel__indicator.is-active,.error-body .error-msg .error-img,.face-g-list .mp-block .right ul li.reach::after,.i-watchlater.has-select,.leaveMsgUpload .btnarea .btnareaIcon,.mainmenu ul.grid li a.lbzx:hover,.mainmenu ul.grid li a.yxlb:hover,.mainmenu ul.grid li.hover a.lbzx,.mainmenu ul.grid li.hover a.yxlb,.prize-item .prize-img,.slideshow .slides-next:hover,.slideshow .slides-pagination li.selected,.slideshow .slides-prev:hover,.small-item.new .new-icon,.video-list .vl-hd .display-tab li.on,.vote-create-btn.active,.vote-create-btn:hover{filter:var(--blue-image-filter)!important}.article-holder .music-card .container .col-3 .card-label,.svg-icon.good-6-click{filter:var(--pink-image-filter)!important}.article-item .item-holder .article-info-bar .like:before,.article-item .item-holder .article-info-bar .reply:before,.article-item .item-holder .article-info-bar .view:before,.evaluateWether .evaluateno i,.evaluateWether .evaluateok i,.evaluateWether .operateType .unsolveActive span,.leaveMsg .leaveMsgHeader .close,.rank-item .content .info .detail .b-icon.author,.rank-item .content .info .detail .b-icon.view,.rank-module .complete-rank::after,.search-module .search-block .search-icon,.search-module .search-block .search-word-panel .history-item .cancel,.sureWindow .close,.video-list .vl-hd .display-tab li,body>div.to-top.on{filter:grayscale(1)!important}#player-header .bg-image:hover,.player-area-ctnr .bg-image:hover{filter:brightness(.7)!important}#player-header .bg-image,.player-area-ctnr .bg-image{transition:.2s .5s!important;filter:brightness(.2)!important}.up-feedback .icon-beta{filter:brightness(.5)!important}.bangumi-player,.face-g-more,.m-help .m-arrow,.record-nav .on,.tab-mk2.active{background-image:none!important}.bangumi-player,.bui-sns-info a .bd,.canvas-card dd .icon-contain .support,.cc-article-wrp .info-wrp .cc-btn,.demo-app .detail .category,.el-picker-panel,.guide .old-btn a,.link-navbar-ctnr,.live-sidebar-ctnr,.main-container .entry-old .btn-old,.main_body .pick_up .pick_list .pick_block .pic,.media-sponsor-wrapper .sponsor-right-area .sponsor-btn,.nav-header-wrapper .nav-header .user-panel .panel-list,.nav-header-wrapper .nav-header .user-panel .user-uname,.rank-item:hover,.selector-wrapper,.singlePage .mainBox,body>.player #bilibiliPlayer{box-shadow:none!important}#app .toolbar-wrapper,#article-list-index,.article-action .ops .share-container .weixin-holder,.guide .feedback-btn a,.js-evaluateArea .evaluateDialog,.mainBox .leaveMsg,.project-list .project-list-item:hover,.sch-pub-tips{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bui-sns-info a .bd::after,.canvas-card dd .icon-contain .support::after,.date-input>img,.filter-wrap .icon-tid2-arr,.main-container .title span::before,.more .help .icon,.more .link .icon,.nav-bar .sub-nav::after,.nav-guide-container .nav-guide-tip .guide-tip-triangle,.side-bar-popup-cntr:after,.top-banner,.user-info .user-info-desc .arrow-left{display:none!important}@supports (backdrop-filter:blur(24px)) or (-webkit-backdrop-filter:blur(24px)){.gui-settings-box.blur .gui-settings-content,.gui-settings-box.blur .gui-settings-footer,.gui-settings-box.blur .gui-settings-header,.gui-settings-box.blur li.category{background:0 0!important}}.face-g-list .mp-block .right ul li.base .round{z-index:100!important}.more .help,.more .link{padding-left:0!important}body>div.to-top.on{background-repeat:no-repeat!important}.article-action .ops .share-container .weixin-holder p{margin-bottom:10px!important}#jfContent{filter:invert(1)}.input-section:focus-within{outline:0!important}.input-section .textarea{border-radius:4px!important;border:1px solid transparent!important}.input-section .textarea:focus-within{border:1px solid!important}.activity.topic-preview-wrapper .s-bottom{border-radius:0!important}.qrcode-login .qrcode-con .qrcode-box .qrcode-img{border:10px solid #fff!important}.qrcode-login .qrcode-con .qrcode-box .status{border:10px solid transparent!important}.card-list .card{border:none!important;border-radius:4px!important}#index-player-vm .item-border,#rankList .list-wrap .list .switch.active,#rankList .list-wrap .list .switch.active.active:after,#rankList .list-wrap .list .switch:hover,#rankList .list-wrap .list .switch:hover.active:after,.arrow-down.active,.audioplayer .ap-playlist .ap-playlist-body .ap-playlist-column-name-value:hover,.bili-radio:checked+span::before,.bili-switcher.checked,.container .hot-list .music-menu-list .choose-menu,.container .hot-list .music-menu-list .menu-type .type-triangle,.danmu-hot .tab-list .tab.active,.data-card .tab .data-tab.current:after,.date-input .date-panel .day.active,.date-input>input.active .date-input>input:focus,.input-section .s-input:focus,.input-section:focus,.list-filter-bar .sort-box .item.active,.list-filter-bar .sort-box .item:hover,.open-dialog-masker .open-body ul li i.icon-complete,.pagelistbox .custom-right .custom-right-inner.custompage:focus,.rank-module .rank-tabs-bar .rank-tabs-list li.on,.rightMsg .msgDiv::before,.sort-item.on i.active,.up-list .up-item .info-holder .head .follow{border-color:var(--theme-color)!important}.blp-ui-slider-hover-container::before{border-top-color:var(--theme-color)!important}.blp-ui-slider-hover-container::after{border-bottom-color:var(--theme-color)!important}#index-player-vm .aside-item:after{border-right-color:var(--theme-color)!important}.audioplayer .ap-controller,.audioplayer .ap-playlist,.form-login .input-box .item input:focus{border:1px solid!important}.audioplayer .ap-controller .ap-controller-center .ap-progress-bar,.audioplayer .ap-controller .ap-controller-right .ap-volume-bar,.banner-wrapper .swiper-pagination-bullet-active,.be-tags-container .tag.new-tag,.bili-radio:checked+span::after,.bili-switcher.checked,.bilibili-live-player .bilibili-live-player-enter-tips,.bilibili-live-player .blpui-btn.default-btn.btn-blue,.blp-ui-slider-process,.card-timing-module .r-text .update .published,.coin-wrap .coin-sure,.draft-holder-block .draft-holder .panel .btn.on,.el-date-table td.in-range.end-date,.el-date-table td.in-range.end-date:hover,.el-date-table td.in-range.start-date,.el-date-table td.in-range.start-date:hover,.error-container .big-btn,.evaluate .situation span.active,.evaluateSubmitArea .submit,.evaluateWether .noactive,.evaluateWether .okactive,.follow-dialog-wrap .follow-dialog-window .bottom .btn,.follow-dialog-wrap .follow-dialog-window .bottom .btn:hover,.form-login .input-box .btn-box .btn-login,.gift-item-wrap .expiration,.gift>.expires,.guide .feedback-btn a,.index-nav .n-i.gotop .btn_gotop:hover,.leaveMsg .submitArea .submit,.main-container .pay-bar .vip .btn-pay,.medal-progress>i,.nav-guide-container .guide-tip-btn .guide-tip-btn-left,.nav-header-wrapper .nav-header .profile-img.active::before,.open-dialog-masker .btn-normal.confirm,.play-up-intro .play-up-follow .play-up-not-follow,.progress-bar-ctnr .bar-body .progress-bar,.rank-list .canvas-card:nth-child(-n+3)::after,.rank-list .item:nth-child(-n+3) .rank-index,.receive-list-next i,.receive-list-page,.receive-list-prev i,.review-module .review-list .empty-wrapper .btn-go-write,.rightMsg .msgDiv,.s-lineMore-more:hover,.s-rank.pink,.sch-pub-btn,.share-box .share-popup .share-address ul li .btn,.sureWindow .btngroup .leavesure,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.confrim,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.ticket,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.vip,.up-feedback .up-fb-btn:hover,.upload-v2-step1-container .upload-btn,.uploader-info .info .follow .btn,.user-info>.uid,.zcChat .header{background-color:var(--theme-color)!important}.audioplayer .ap-controller .ap-controller-center .ap-buffer-bar,.audioplayer .ap-play-button svg,.blp-ui-slider-buffer-container{background-color:var(--theme-color-60)!important}.audioplayer .ap-play-button:hover svg{background-color:var(--theme-color-90)!important}#activeCenter .s-imgUnit-img .overlay .des,#community_msg .dyn_menu li a:hover,#mangoTv .mango-rank .text-list a:hover,#rankList .list-wrap .list .bar .text:hover,#rankList .list-wrap .list .switch.active,#rankList .list-wrap .list .switch:hover,#rankList .list-wrap .text-list a:hover,#song_detail_click_upper~div .pager .pages .page-item button:hover,#song_detail_click_upper~div .pager .pages .page-item.active button,.app-link a,.article-action .coin-btn.on,.article-action .coin-btn.on i,.article-action .coin-btn:hover,.article-action .coin-btn:hover i,.article-action .fav-btn.on,.article-action .fav-btn.on i,.article-action .fav-btn:hover,.article-action .fav-btn:hover i,.article-action .like-btn.on,.article-action .like-btn.on i,.article-action .like-btn:hover,.article-action .like-btn:hover i,.article-action .ops i:hover,.audioplayer .ap-button:hover,.audioplayer .ap-playlist .ap-playlist-body li.ap-playlist-line-active,.audioplayer .ap-playlist .ap-playlist-body li:hover,.base-info .btn-wrapper .btn:active,.base-info .btn-wrapper .btn:active .icon-font,.base-info .btn-wrapper .btn:hover,.base-info .btn-wrapper .btn:hover .icon-font,.base-info .desc .tag,.bb-comment .more-link:hover,.bilibili-player-context-menu-container.black ul>li a>.active,.bilibili-player-video-subtitle-setting-left-more:hover,.bilibili-player-video-subtitle-setting-left-more:hover .bp-svgicon,.bilibili-player-video-subtitle-setting-right-more:hover,.bilibili-player-video-subtitle-setting-right-more:hover .bp-svgicon,.bilibili-player-video-toast-top-lower-quality,.blp-ui-button:hover>i,.channel-detail .content .breadcrumb .item:hover,.coin-wrap .coin-nav .coin-checkbox.on .lable,.coin-wrap .coin-title i,.comment-list a,.common-popup-wrap header,.container .left-container .play-up-info .play-up-self-btn:hover,.content-panel .title span:hover,.content-panel .title span:hover em,.danmu-hot .tab-list .tab.active,.danmu-hot .video-list .video-wrapper .video:hover .title,.date-input .date-panel .day.active,.el-pager li:hover,.face-g-more,.form-login .remember a,.gift-box:hover>.num,.hot-list .card-ctnr .room-count .amount,.hot-list .card-ctnr .room-count:hover,.hot-list .card-ctnr .room-count:hover .amount,.hot-list .card-ctnr .room-count:hover .icon-font,.i-pin-reason,.input-section .schedule-panel .s-item:hover,.leaveMsgUpload .btnarea .btareatxt1,.list-filter-bar .pic-type-box .item.active,.list-filter-bar .pic-type-box .item:hover,.list-filter-bar .sort-box .item.active,.list-filter-bar .sort-box .item:hover,.list-link a,.list-wrap .s-showMore:hover,.main-container .review-module .module-title .more-link:hover,.medal-up-name>a,.more .help .title:hover,.more .link .title:hover,.my-moral i,.noHover-link,.open-dialog-masker .__dialog-header .mr-close:hover,.open-dialog-masker .open-body ul li i.icon-complete,.open-dialog-masker .open-footer .open-agree a,.open-dialog-masker .open-footer .open-agree i.icon-chk-full,.panel-list .order-center-item:hover a,.play-options .share-box .share-btn ul .bili-share:hover,.popularize-module .online a:hover,.rank-item .content .info .bangumi-num,.rank-item .content .info .title:hover,.rank-module .complete-rank:hover,.rank-module .rank-list .item:hover a,.rank-module .rank-tabs-bar .rank-tabs-list li.on,.record-nav .on,.room-card-item:hover .room-name,.s-imgUnit-text a:hover,.search-module .search-block .search-word-panel .suggest_high_light,.setting .watermark-setting .watermark-wrp .is-selected,.similar-song-menu .similar-right .title:hover,.up-list .up-item .info-holder .head .follow,.up-list .up-item .info-holder .head .nick-name:hover,.upload-agreement a,.video-list-wrapper .video-list .icon-font:hover,.video-toolbar .appeal-text:hover,.viphelp span{color:var(--theme-color)!important}.banner-wrapper .swiper-pagination-bullet-active,.be-tags-container .tag.new-tag,.bilibili-live-player .bilibili-live-player-enter-tips,.bilibili-live-player .blpui-btn.default-btn.btn-blue,.card-timing-module .r-text .update .published,.coin-wrap .coin-sure,.el-date-table td.in-range.end-date,.el-date-table td.in-range.end-date:hover,.el-date-table td.in-range.start-date,.el-date-table td.in-range.start-date:hover,.error-container .big-btn,.evaluate .situation span.active,.evaluateSubmitArea .submit,.evaluateWether .noactive,.evaluateWether .okactive,.form-login .input-box .btn-box .btn-login,.gift-item-wrap .expiration,.gift>.expires,.guide .feedback-btn a,.index-nav .n-i .name:hover,.infoBar .infoBarText,.infoBarName .inputIng,.infoBarName .titleName,.leaveMsg .submitArea .submit,.magBox .msgDiv .msgText,.main-container .pay-bar .vip .btn-pay,.nav-guide-container .guide-tip-btn .guide-tip-btn-left,.open-dialog-masker .btn-normal.confirm,.play-up-intro .play-up-follow .play-up-not-follow,.rank-list .item:nth-child(-n+3) .rank-index,.review-module .review-list .empty-wrapper .btn-go-write,.s-lineMore-more:hover,.s-rank.pink,.sch-pub-btn,.share-box .share-popup .share-address ul li .btn,.sureWindow .btngroup .leavesure,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.confrim,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.ticket,.twp-mask .twp-wrapper .twp-container .twp-btns .twp-btn.vip,.up-feedback .up-fb-btn:hover,.uploader-info .info .follow .btn,.user-info>.uid{color:var(--foreground-color)!important}.audioplayer .ap-progress-thumb svg path:first-child,.audioplayer .ap-progress-thumb svg path:nth-child(2),.bilibili-player-video-danmaku-setting-left-more:hover .bp-svgicon,.bilibili-player-video-danmaku-setting-right-more:hover .bp-svgicon,.bilibili-player-video-sendbar .bilibili-player-video-inputbar .bilibili-player-video-hint a:hover,.bilibili-player-video-subtitle-setting-left-more:hover,.bilibili-player-video-subtitle-setting-left-more:hover .bp-svgicon,.bilibili-player-video-subtitle-setting-right-more:hover,.bilibili-player-video-subtitle-setting-right-more:hover .bp-svgicon,.bilibili-player-video-toast-item-close:hover,.player-auxiliary-btn-playlist-order:hover path,.receive-list-page{fill:var(--theme-color)!important}.leftMsg .msgDiv:before,.rightMsg .msgDiv::before{border-top-color:transparent!important;border-bottom-color:transparent!important}.gui-settings-dropdown::after,i.settings-category-arrow::after{border-top-color:transparent!important;border-left-color:transparent!important}#rankList .list-wrap .list .switch.active.active:after,#rankList .list-wrap .list .switch:hover.active:after,.container .hot-list .music-menu-list .menu-type .type-triangle,.data-card .tab .data-tab.current:after,.sort-item.on i.active{border-left-color:transparent!important;border-right-color:transparent!important}#announcement-area .rank-ctnr .rank-icon,#bp_right .bb_intro_box,#edit-page .btn-group.main-active-btn .ui-btn.loading,#edit-page .btn-group.main-active-btn a.white:hover,#edit-page .btn-group.main-active-btn button.white:hover,#footer,#page .game,#page .game .game-box h4,.active-main .act-list ul li,.add-tag .edit .btn-hide,.add-tag .edit .input-wrapper input,.add-tag .tag-list .tag,.alert-container,.assist-wrap .addModal .modal-wrap,.bangumi-up-info,.bind-info .note-footer .btn-group .back-btn,.bind-info .note-footer .btn-group .unable-btn,.bl-search:hover,.buy-vip-panel .panel-ctnr,.buy-vip-panel .panel-ctnr .panel-aside .aside-item.active,.canvas-card dd .icon-contain .support,.cards-block .cards-list .card-item .card-case .image,.cards-block .cards-list .card-item .card-case .title:empty,.cards-block .cards-list .card-item .card-case.type-head .text .content .block,.cards-block .cards-list .card-item .card-case.type2 .content .block,.cc-content-body .medal,.checkbox.checked .radio-btn,.classify .classify-list .list-item .class-block,.classify .classify-list .list-item .class-block:hover,.classify .sub-list,.comment-manage-wrap .head .search .bili-input,.comment-manage-wrap .search input,.content .user-protocol,.dc-option:hover,.demo-app .detail,.faq-modal .modal-wrap .modal-content .text-content,.func-banner .btn-dislike,.func-banner .btn-like,.game-groom-m .type-name,.game-more,.history-card:hover,.invite-code .copy-btn,.member-list-item .member-list-img,.modal-wrap,.online-list .ebox,.online-list .ebox .ol,.order-header-wrapper,.order-list-wrapper,.orderdetail-container .orderdetail-content,.pay-points-way-btn-disable,.pay-points-way-content,.pay-points-way-next,.qrcode-active .qrcode-active-slider .close-btn,.recharge-store-box .cntr .store-content,.record-ctnr .areas,.review-reply-wrapper,.rhythm-storm .bl-button:disabled,.set-copyright .copyright-icon .icon-none-copyright,.set-copyright .copyright-select-box,.song-info .info-wrap .album-itro,.song-info .info-wrap .album-name,.sub-tab-box .item.active,.text-input input,.ticket-container,.title-factory-card .title-num .num-value,.title-level .title-level-bar-wrap .title-level-bar,.topic-main .act-list ul li,.total-container,.trade-customn input,.ui-btn.sub-btn,.ui-btn.white,.ui-radio .ui-radio-icon,.ui-select .ul-select-list,.ui-select.white .ui-select-show-box,.ui-select.white .ui-select-show-box:hover,.user-info>.tag-gray,li.user-wrapper .avatar .detail,li.user-wrapper .avatar .detail .logout{background-color:#222!important}.player-auxiliary-area .bui-collapse{background-color:#333!important}#edit-page,.achievement-card,.achievement-user,.activity-card,.apply-banner-table tr:nth-child(even),.article-wrapper,.assist-wrap .addModal .control-group.assist-rights .rights,.author-info-card,.avatar .detail .level a.total,.balance_bp_box,.bangumi-list .synthetical .headline .bangumi-label,.banner-text,.bb_intro_box_top,.bili-input,.bili-pay-box-wrapper,.bili-pay-payment-wrapper,.bili-payment-list,.bind-info,.bui-sns-info,.buy-vip-panel .panel-ctnr .panel-aside,.canvas-card,.center-grid,.center-grid tbody tr:nth-child(odd),.classify .sub-list .sub-item.active,.classify .sub-list .sub-item:hover,.cntr .category,.comment-manage-wrap .content .action-bar,.comment-manage-wrap .dropdown .dropdown-btn:hover,.comment-manage-wrap .dropdown.open .dropdown-btn,.comment-manage-wrap .head .dropdown-btn,.comment-manage-wrap .head .dropdown-btn .text,.comment-manage-wrap .no-content,.condition-btn-disable,.container .host-list-layout .hot-list-wrap .hot-song-list,.container .host-list-layout .hot-list-wrap .show-more-song,.cover-upload-box .no-img,.daily-task .task-item,.dc-select .dc-option-group,.demo-app .detail .category,.drawer-card,.dropdown .dropdown-menu,.el-table .el-table__header-wrapper th,.el-table th,.el-table tr,.el-table--enable-row-hover .el-table__body tr:hover>td,.el-upload--picture-card,.fast-amount-list .item.free-amount input.ipt-free-amount,.float-toolbar .toolbar-list li,.game-groom-m,.game-groom-m .title,.gold-seed-store,.history-card,.income-info .item,.infor-body-left ul li,.infor-news .news-body,.infor-news .news-top,.link-panigation .panigation,.nav-container .single-box .ep-item,.nav-notice li a,.official-submit-btn-disable,.official-title-input,.order-list-wrapper .order-list .order-item .order-item-body-wrapper,.pagelist .flip-left span,.pagelist .flip-left strong,.pagelist .flip-right input,.project-info table tr,.project-info table tr:first-child,.promote-m .headline .change-push,.qrcode-active .qrcode-active-slider,.rank-item-first,.rank-item-first .detail,.rank-list-container .rank-list-wrapper,.rank-list-container .rank-list-wrapper .rank-list,.rank-list-head .rank_tips,.read-list-component .creat-read-list-box .input-box button[disabled],.recent-danmu-wrp .head .dropdown-btn,.recharge-store-box dl.recharge-form .ipt-number,.record-ctnr,.record-ctnr .area-selection-cntr,.record-ctnr .areas .btn-cntr .btn,.record-ctnr .areas .btn-cntr .btn.normal,.rel.pl26.mb18 .bggr,.relate-work-wrapper,.sailors-ctnr,.section-block.with-bottom-radius.a-move-in-left .invite,.section-filter,.set-copyright .copyright-select-box .copyright:hover,.shell-intro-top,.spend-recode,.sponsor-pay-dialog-v2 .sponsor-pay-content,.table-ctnr,.tag .delete,.text-ctnr,.trade-list,.trade-wrapper,.u-btn-c,.u-btn-e,.u-btn-m,.ui-radio input[type=radio]:active+.ui-radio-icon,.ui-select .ul-select-list .select-item.active,.ui-select .ul-select-list .select-item:hover,.valid_box .button.ready,.valid_box .button.ready:active,.valid_box .button.ready:hover,body #app .category-wrapper .upload-content,body #app .marquee{background-color:#444!important}.player-auxiliary-area .bui-collapse,.player-auxiliary-area .player-auxiliary-danmaku-btn-footer,.v-wrap #multi_page{border-radius:2px!important}.add-tag .edit .input-wrapper .container.active .btn-add,.infor-news .news-top,.spend-recode .title-group .selected-title,div.cntr a.check-all{background-image:none!important}#text-contribute .fixed-header,.alert-container .alert-header:after,.app-ctnr,.bl-search,.buy-vip-panel .panel-ctnr .panel-aside .aside-item .item-img-ctnr,.container .main-btn.edit-btn:hover,.el-table,.el-table--border:after,.el-table--group:after,.el-table:before,.el-table__expanded-cell,.gui-settings-box.blur,.link-footer .footer-linker .footer-linker-line,.nav-notice li,.nav-notice li.hover,.player-auxiliary-area .player-auxiliary-filter,.player-auxiliary-collapse .player-auxiliary-wraplist{background-color:transparent!important}.preview-avatar-con,.preview-title,.read-list-component .mask,.recent-danmu-wrp .danmu-filter .left .line,.ui-checkbox input[type=checkbox]:checked+.ui-checkbox-icon{background:0 0!important}ul.a-fade-in.content li:nth-child(n+41):after{background-image:linear-gradient(#2221,#222)!important}#announcement-area .news-ctnr .news-date,#announcement-area .rank-ctnr .anchor-name,#dc-section_summary .follow-tool-box .follow-line-legend .legend-item .legend-text,#edit-page .block-wrap h3.block-title span.tips,#edit-page .copyright-hint,#page .game .game-box dl a,.achievement-card-centent>.header>.state-normal,.achievement-card-centent>.text a,.achievement-user-info>.info,.activity-card dd span,.add-tag .default .placeholder,.add-tag .edit .input-wrapper .count,.add-tag .edit .tip,.agreement,.area-section .card-ctnr .tag-ctnr .tags,.article-holder .shop-card a .container .disc,.author-info-card .data-area .data-block h4,.ava-name,.ava-text,.bangumi-index-crumb ul li a,.bangumi-item .pub-info,.banner-p a,.banner-p p,.bili-pay-panel-name,.bili-pay-panel-remark,.bili-pay-text,.bili-pay-vouche-name,.bili-pay-voucher-help-disable,.bili-payment-num i,.bili-payment-txt,.bind-info .note-content p,.block-left .headline .hot-link,.canvas-card dd h4 .user-container a,.canvas-card dd h4 .user-container span,.card-more,.cards-block .cards-list .card-item .card-case .image .empty-icon p,.category li a,.cc-album-create .info-wrp p,.center-grid thead tr,.checkbox .text,.cinema-home-crumb ul li a,.comment-manage-wrap .content .action-bar .dropdown .sort-btn,.comment-manage-wrap .dropdown .dropdown-menu li,.comment-manage-wrap .head .dropdown-menu .article-list .ac-link,.comment-manage-wrap .search .fontvt,.condition-sub-title,.condition-txt,.container .subtitle,.container .tip,.content .user-protocol,.cover-upload-box .no-img,.daily-task .task-item,.daily-task .task-item .desc,.daily-task .task-item .task-status,.danmu-wrp .black-tip,.danmu-wrp .section .label .second,.danmu-wrp .section .title-tip,.danmu-wrp .section .title-tip .sub,.dc-radio-button,.dc-radio-button_inner,.editor-box p.counter,.editor-wrap .article-title .count,.el-checkbox__label,.el-date-table td.next-month,.el-date-table td.prev-month,.el-pagination.is-background .btn-next,.el-pagination.is-background .btn-prev,.el-pagination.is-background .el-pager li,.error-panel.server-error .right-panel,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .mp-descr,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .mp-gettime,.faq-modal .modal-wrap .modal-content .text-content p,.filter-block .filter-item-wrapper,.float-toolbar .back-top .icon-block,.float-toolbar .toolbar-list .icon-block,.footer-text .record,.footer-text p,.form-title-info,.func-banner .right-btns a,.func-banner .right-btns span,.game-groom-m .num,.history-card,.hot-list .card-ctnr .room-count,.info-item-active p,.info-item-charge p,.info-item-medal p,.info-item-total p,.link-footer .footer-img-linker .footer-img-item,.link-footer .footer-img-linker .footer-img-text,.mn-ot-l-u-icon1,.mn-ot-l-u-icon2,.more-data,.music-clue,.music-tips .music-tip,.nav-bar .sub-nav .sub-tab,.news-text .news-date,.num-tip,.official-name-info,.online-list .ebox .dlo .author,.online-list .ebox .dlo span,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-body .order-item-name-wrapper .time,.orderdetail-container .orderdetail-nav .orderdetail-nav-list li.order-center,.orderdetail-container .orderdetail-wrapper p,.pagelist .flip-right span,.pager .jump-pager,.pay-activation-txt,.pay-bottom-link,.pay-other p,.pay-points-way-title,.pay-points-way-txt,.pay-result-sub-title,.preview-avatar-con:after,.preview-title:after,.project-info table .project-content .content-right p,.promote-m .headline .sub-name,.qrcode-active .qrcode-container-item .qrcode .qrstatus .qrstatus-time,.qrcode-active .qrcode-container-item .qrcode .qrstatus .qrstatus-title,.qrcode-active .qrcode-tip,.rank-active-target,.rank-fans-medal,.rank-item .content .info .detail,.rank-item .content .info .detail a,.rank-item .content .info .pts,.rank-list-head .rank_tips,.rank-menu li,.rank-tab-wrap,.rank-vedio-target,.rank-vedio-view,.read-list-component .read-list-box li .count,.read-list-component .tips,.read-list-component .tips.input-tips,.recent-danmu-wrp .danmu-filter .left .delete .option-wrp .act-btn,.recent-danmu-wrp .head .dropdown-menu .article-list li,.recent-danmu-wrp .tips,.recharge-rule,.record-ctnr,.rel.pl122.mb20 .g3,.relate-work-wrapper .work-info .bread-crumb,.relate-work-wrapper .work-info .rate-info .tip,.room-card .sub-area,.set-copyright .copyright-select-box .copyright,.song-info .info-wrap .contact-us,.song-info .info-wrap .form-item-paper-input-wrapper .form-item-paper-total,.sort-item,.spend-recode .part-common .platformType,.sponsor-pay-dialog-v2 .sp-pay-success .sponsor-pay-body .sponsor-pay-result .sponsor-pay-result-body p,.stat-banner .author-name,.stat-banner .pub-time,.stat-banner .review-summary,.sub-tab-box .item,.tag-list-wrap .tag-list .add-item .tip,.text-input .text-length,.title-module,.tool-box-v2-container .tool-title,.tool-box-v2-container .tool-xiaowan a,.tool-box-v2-container .tool-xiaowan-bilibili a,.topic-main .act-list ul li .found-time,.trade-customn .tips,.trade-wrapper>div>div,.tv-m-crumb li a,.tv-m1 .colt,.tv-m1 .com,.tv-m1 .play,.tv-m1 .time,.tv-m1 .tv-m-desc,.tv-m1 .up,.tv-m2 .colt,.tv-m2 .com,.tv-m2 .play,.tv-m2 .time,.tv-m2 .tv-m-desc,.tv-m2 .up,.tv-m3 .colt,.tv-m3 .com,.tv-m3 .play,.tv-m3 .time,.tv-m3 .tv-m-desc,.tv-m3 .up,.ui-input-textarea .count,.upload-cover-wrapper .upload-cover-tips,.upload-image .tip,.upload-txt,.upload-v2-step1-container .upload-agreement .reg-1>div a,.upload-v2-step1-container .upload-agreement .reg-2,.value-length,.video-floor-m .zone-title .headline .tags li a,.video-item-biref .biref-info .biref-title-sec,li.user-wrapper .avatar .detail .level .progress span,ul.navigation li span{color:#aaa!important}#announcement-area .rank-ctnr .cover-ctnr,#announcement-area .rank-ctnr .rank-icon,#area-anchor .area-title-link,#area-anchor .icon-play,#edit-page .btn-group.main-active-btn a.white,#edit-page .btn-group.main-active-btn button.white,#page .game .game-box h4,.achievement-card-centent>.header,.achievement-card-centent>.header>.icon,.active-main .act-list ul li .event_status,.active-main .act-list ul li h2 a,.active-main .active-title .b-active-t,.activity-card .category-tab,.activity-card dd h4,.add-tag .edit .input-wrapper .btn-add,.add-tag .edit .input-wrapper input:focus,.add-tag .edit .input-wrapper input:hover,.agree-rule .text,.alert-container .alert-content .button,.alert-container .alert-header h2,.article-holder .shop-card a .container .title,.article-wrapper .review-content,.article-wrapper .review-title,.assist-wrap .addModal .control-group,.assist-wrap .addModal .control-group>label,.assist-wrap .assist-list header h1,.assist-wrap .assist-log header h1,.author-info-card .author-info .info-right .author-name,.author-info-card .author-info .info-right .btn-attention,.author-info-card .data-area .data-block p,.balance_bp_box,.balance_bp_box .button:active,.balance_bp_box .button:hover,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow,.bangumi-item .bangumi-title,.bangumi-item .cover-wrapper .corner-tag,.bangumi-item .cover-wrapper .shadow,.bangumi-list .synthetical .headline .bangumi-label,.bangumi-up-info .func-btns .b-gz,.bb_intro_box .bb_intro_info,.bb_intro_box_top .b_icon_title,.bbgr.cl.h29 .g1,.bili-pay-price,.bili-pay-uname,.bili-payment-list,.bind-info .bind-sub-title,.bind-info .note-footer .btn-group .back-btn,.bind-info .note-footer .btn-group .unable-btn,.block-area .block-left .block-header .block-title,.block-left .headline h4,.bp_user_box i,.bp_user_box_top p,.btn-sponsor-wrapper a.sponsor-btn,.bui-sns-info a,.buy-vip-panel .panel-ctnr .panel-aside .aside-item .item-label,.canvas-card dd .icon-contain .support,.canvas-card dd h3 a,.card-info,.card-name,.cards-block .cards-list .card-item .card-case .user-info span,.cards-block .radio-list .radio-item .radio-label.active,.cards-block .radio-list .radio-item .radio-label:not([disabled=disabled]),.category-wrapper .tweet-title,.category-wrapper .upload-title-text,.center-grid tbody tr,.check-warp .el-checkbox,.cl.mb20 .g1,.classify .classify-list .list-item .class-block,.comment-manage-wrap .content .action-bar .action-btn span,.comment-manage-wrap .dropdown .dropdown-btn,.comment-manage-wrap .head .search .bili-input,.comment-manage-wrap .search input,.comment-wrap header h2,.condition-btn-disable,.condition-title,.container .main-btn,.create-compilations-btn .album-flex .album-bar-btn .album-bar-btn-text,.danmu-wrp .input-group,.danmu-wrp .section .bili-input,.danmu-wrp .section .title,.dc-option,.dc-section-item_title,.dc-section-item_title_custom .sectionTitle,.drawer-card dd,.el-button--primary,.el-pagination__jump,.el-pagination__total,.el-table .el-table__header-wrapper .el-table__header .cell,.el-table .el-table__row .cell,.ellipsis,.error-manga .change-img-btn,.error-panel .rollback-btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn-white,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .title,.faq-modal .modal-wrap .modal-content .text-content h1,.fast-amount-list .item.free-amount input.ipt-free-amount,.favourite-card .other-info-ctnr>div,.filter-block .filter-name,.filter-wrapper .filter-title,.fjw-point header h2,.fjw-random header h2,.footer-box a,.func-banner .btn-dislike,.func-banner .btn-like,.game-groom-m .type-name,.game-groom-m a .title,.game-more,.header .right li.order span a,.hot-activity a,.hot-content .title,.idol-show .section-title .title,.income-info .item .info-title,.info-model header h2,.infor-label .label-date,.infor-news .news-top,.item .live-status,.link-panigation .panigation,.link-panigation .panigation.selected,.live-btn.default,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-btn,.music-upload-wrapper .upload-music-bar-wrapper .pload-music-bar-btn,.nav-container .single-box .ep-item,.nav-container .single-box .ep-item:hover,.nav-notice li a,.nav-notice li.hover,.news-body .news-1 .news-text p,.news-body .news-1 i,.news_block .text-name,.official-label,.official-submit-btn-disable,.official-title,.online-list .ebox .etitle,.order-header-wrapper,.order-header-wrapper .order-header-status,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-body,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-body .order-item-name-wrapper .name,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.canceldetail,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.checkdetail,.orderdetail-container .orderdetail-status .status-text,.orderdetail-container .orderdetail-wrapper h1,.other a,.other strong,.pagelist .flip-left .active,.pagelist .flip-left span,.pagelist .flip-left span:hover,.pagelist .flip-right input,.panigation .arrow-right i,.pay-activation-btn,.pay-other-way-link,.pay-points-way-btn,.pay-points-way-btn-disable,.pay-points-way-content,.pay-result-btn,.pay-result-title,.player-auxiliary-area .player-auxiliary-filter-menu,.player-auxiliary-area .player-auxiliary-filter-title,.preview-title-line1,.project-info table .project-content .content-right h1,.project-info table th,.project-info table tr,.protocol-block,.qrcode-active .qrcode-container-item .seat-info,.qrcode-active .qrcode-container-item .seat-info span,.qrpay-group .qrpay-content .pay-tips,.rank-item .content .info .pts div,.rank-item .detail .work-name,.rank-item .num,.rank-list .canvas-card:after,.rank-list .canvas-card:nth-child(-n+3):after,.rank-list-container .more .text,.read-list-component .creat-read-list-box .input-box button,.read-list-component .creat-read-list-box .input-box button[disabled],.read-list-component .create-btn,.read-list-component .read-list-box li label .title,.recent-danmu-wrp .danmu-filter .from-wrp .bili-input,.recent-danmu-wrp .dropdown .dropdown-btn,.recharge-store-box dl.recharge-form .ipt-number,.recharge-store-box dl.recharge-form dt,.record-ctnr .area-selection-cntr .tips,.record-ctnr .areas .btn-cntr .btn,.record-ctnr .areas .btn-cntr .btn.normal,.record-ctnr .areas .btn-cntr .btn.normal:hover,.record-ctnr .areas-tip-cntr .areas-tip,.rel.pl122.mb20 .g1,.rel.pl122.mb20 .rank,.rel.pl26.mb18 .g1,.rel.pl26.mb18 .rank,.relate-work-wrapper .work-info .work-title,.relate-work-wrapper .wrapper-title,.review-reply-wrapper .review-reply-title,.rhythm-storm .bl-button:disabled,.rhythm-storm label,.sailors-ctnr,.shell-intro-top .bind-card-title,.song-info .info-wrap .album-itro,.song-info .info-wrap .album-name,.song-info .info-wrap .submit-btn,.song-info .info-wrap .title,.spend-recode .title-group .selected-title,.sponsor-pay-dialog-v2 .sp-pay-success .sponsor-pay-body .sponsor-pay-result .sponsor-pay-result-body p.sponsor-pay-result-title,.sponsor-pay-dialog-v2 .sponsor-pay-header,.submit-btn,.tabnav-tip.plain,.tag .delete,.tag .text,.tag-list-wrap .tag-list .add-item .add-control,.text-input input,.timer-wrap .timer-top h2,.title .text,.title-factory-card .title-num .num-value,.topic-main .act-list ul li h2 a,.topic-main .nav-tab li,.topic-main .topic-title .b-topic-t,.total-container div,.trade-customn input,.trade-wrapper,.tv-m1 .tv-m-tt,.u-btn-c,.u-btn-e,.u-btn-e:hover,.u-btn-m,.ui-btn.blue-radius,.ui-input-text input,.ui-select .ui-select-show-box,.ui-select .ul-select-list .select-item,.upload-v2-step1-container .video-jam .video-jam-pretext,.user-info>.tag-gray,.valid_box .button.ready,.valid_box .button.ready:active,.valid_box .button.ready:hover,.video-model header h2,.w160.h48.ovh .g1,body #app .category-wrapper .upload-content .title,ul.navigation li.activated span{color:#eee!important}#announcement-area .news-ctnr .title-row,#bp_right .bb_intro_box,#bp_right .bb_intro_box_top,#edit-page .btn-group.main-active-btn a.white,#edit-page .btn-group.main-active-btn button.white,.achievement-card,.achievement-card-centent>.header>.state-normal,.achievement-user,.achievement-user-info>.info,.active-main .act-list ul li,.active-main .active-title,.add-tag .edit .input-wrapper input,.add-tag .edit .input-wrapper input:focus,.add-tag .edit .input-wrapper input:hover,.article-holder .shop-card,.author-info-card .data-area .split-line,.b-head.online,.b-info .dividing-line,.balance_bp_box,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow,.bangumi-list .synthetical .headline .bangumi-label,.banner,.bb_intro_box .bb_intro_info,.bb_intro_box_top,.bili-input,.bili-pay-header-wrapper,.bili-pay-payment-wrapper,.bili-payment-list,.bilibili-player .bilibili-player-area-separator,.bind-info,.bind-info .dividing-line,.bind-info .note-footer .btn-group .back-btn,.bind-info .note-footer .btn-group .unable-btn,.bp_user_box_top,.buy-vip-panel .panel-ctnr,.canvas-card dd .icon-contain .support,.checkbox.checked .radio-btn,.cinema-home-crumb ul li,.classify .classify-list .list-item .class-block,.comment-manage-wrap .content .action-bar .action-btn span,.comment-manage-wrap .content .check-box.checked,.comment-manage-wrap .dropdown .dropdown-btn,.comment-manage-wrap .head .dropdown-btn .text,.comment-manage-wrap .no-content,.comment-manage-wrap .search input,.container .host-list-layout .hot-list-wrap .hot-song-list,.container .main-btn,.container .main-btn.edit-btn,.container .main-btn:hover,.daily-task .task-item,.dc-select .dc-option-group,.dc-select-label,.el-button--primary,.el-table td,.el-table th.is-leaf,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn:hover,.favourite-card,.favourite-card .anchor-info,.favourite-card .other-info-ctnr .anchor-live:before,.func-banner .btn-dislike,.func-banner .btn-like,.game-groom-m,.income-info .item,.infor-body-left ul li,.link-footer .footer-img-linker .footer-img-item,.link-panigation .panigation,.mg-l.w880.cl .bbgr,.nav-container .single-box .ep-item,.nav-notice li,.nav-notice li.hover,.news-body .news-1,.official-right-float .el-upload--picture-card,.official-title-input,.online-list .ebox,.order-list-wrapper .order-list .order-item,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.canceldetail,.order-list-wrapper .order-list .order-item .order-item-body-wrapper .order-item-btn-group .btn.checkdetail,.orderdetail-container .orderdetail-status,.orderdetail-container .orderdetail-wrapper .wrapper-content,.other,.pagelist .flip-left .active,.pagelist .flip-left span,.pagelist .flip-left span:hover,.pagelist .flip-right input,.pay-points-way-content,.pay-points-way-select,.payment-active,.project-info table tr,.project-info table tr:last-child,.promote-m .headline .change-push,.rank-active-target,.rank-fans-medal,.rank-item div.num,.rank-vedio-target,.rank-vedio-view,.read-list-component .creat-read-list-box .input-box,.read-list-component .creat-read-list-box .input-box button,.read-list-component hr,.recent-danmu-wrp .danmu-filter .from-wrp .bili-input,.recent-danmu-wrp .dropdown .dropdown-btn,.recharge-store-box dl.recharge-form .ipt-number,.record-ctnr,.record-ctnr .area-selection-cntr,.record-ctnr .areas,.record-ctnr .areas .btn-cntr .btn.normal,.rhythm-storm .bl-button,.sailors-ctnr,.section-filter,.set-copyright .copyright-select-box,.shell-intro-top,.song-info .info-wrap .album-itro,.song-info .info-wrap .album-name,.spend-recode,.spend-recode .part-common .platformType,.sponsor-pay-dialog-v2 .sp-pay-success .sponsor-pay-msg,.text-input input,.title-factory-card .title-num .num-value.num-input,.topic-main .act-list ul li,.topic-main .nav-tab,.trade-list,.tv-m1 .tv-m-con,.u-btn-c,.u-btn-e,.u-btn-m,.ui-btn.sub-btn,.ui-btn.white,.ui-input-textarea,.ui-radio .ui-radio-icon,.ui-radio.active .ui-radio-icon,.ui-select.white .ui-select-show-box,.upload-image,.valid_box .button,.valid_box .button.ready,.valid_box .button.ready:active,.valid_box .button.ready:hover{border-color:transparent!important}.area-section .card-ctnr .tag-ctnr .tags,.banner-p a,.el-date-table th,.face-g-list#my-g-list .face-g-block .my-mp-block,.fjw-random .point-wrap .cnt,.fjw-random .point-wrap .cnt .list,.recharge-store-box ul.select-list .item,.set-copyright .copyright-icon .icon-none-copyright,.trade-wrapper,.ui-input,.user-info>.tag-gray{border-color:#aaa!important}#BilibiliVipDialog{border:none!important}.block-left.block-brand .headline .tab-wrap .pgc-brand-tab,.footer-logo,.icon-arrow-r,.mainmenu ul.grid li a.yxzx,.more-data i,.play-btn .icon-play,.qrcode-active .qrcode-active-slider .close-btn .close-btn-bg,.u-btn-e i,.u-btn-m i{filter:brightness(0) invert(1)!important}.infor-load-more{filter:invert(.75)!important}.bb_intro_box_top .b_question .b_question_icon{filter:brightness(.5) contrast(3)!important}.float-toolbar .back-top .icon-block.icon-back-top,.float-toolbar .toolbar-list .icon-block.icon-feedback,.float-toolbar .toolbar-list .icon-block.icon-help,.icon-slide-h,.icon-sort3-on,.on.u-btn-s3,.recharge-store-box ul.select-list .item.active:after,.timer-wrap .vote-dialog-new .main .checkbox,.timer-wrap .vote-dialog-new .main .main-txt-1 label .selected,.title-factory-card.selected:after,.u-btn-s3:hover{filter:var(--blue-image-filter)!important}.add-tag .default .btn-show,.article-holder .shop-card a .container .bottom-col .card-label,.episode-item .mark-icon,.project-info table .project-content .content-right .ticket-type span{filter:var(--pink-image-filter)!important}#edit-page,.orderdetail-container .orderdetail-content{box-shadow:none!important}div.cntr a.check-all{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.icon-home,.icon-hot,.icon-new{display:none!important}#page .game .game-box h4 span,.act.tv-u-btn-t,.area-section .card-ctnr .tag-ctnr .tags:hover,.author-info-card .author-info .info-right .btn-attention,.balance_bp_box .button,.bangumi-up-info .func-btns .b-gz,.banner-p a:hover,.banner-p h3,.bili-pay-panel-list-active,.blink-border.blue,.classify .classify-list .list-item .class-block:hover,.dc-radio-button.is-active,.dc-radio-button.is-active:after,.func-banner .btn-dislike.active,.func-banner .btn-dislike:hover,.func-banner .btn-like.active,.func-banner .btn-like:hover,.invite-code .copy-btn,.rank-menu li.active,.recharge-store-box ul.select-list .item.active,.recharge-store-box ul.select-list .item:hover,.record-ctnr .areas .all-area.checked,.swiper-pagination-custom,.tabs-nav .active,.title-factory-card.selected,.trade-wrapper.is-selected,.ui-checkbox input[type=checkbox]:checked+.ui-checkbox-icon,.ui-radio input[type=radio]:hover+.ui-radio-icon,.ui-radio.active .ui-radio-icon,.ui-tabs .ui-tabs-head .tab-head-item.current a,.ui-tabs .ui-tabs-head .tab-head-item.current a:after,body #app .marquee{border-color:var(--theme-color)!important}#announcement-area .rank-ctnr .rank-icon.hot,.add-tag .default .btn-show,.alert-container .alert-content .button,.author-info-card .author-info .info-right .btn-attention,.balance_bp_box .button,.balance_bp_box .button:active,.balance_bp_box .button:hover,.bangumi-info .info-right .info-title .func-module .bangumi-btn .btn-follow,.bangumi-up-info .func-btns .b-gz,.bili-header-m .bubble-traditional .renew-btn button,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-setting-menu-wrap .bilibili-player-setting-menu-list .active-point,.btn-sponsor-wrapper a.sponsor-btn,.checkbox.checked .radio-btn:before,.comment-manage-wrap .content .check-box.checked,.error-manga .change-img-btn,.error-panel .rollback-btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn,.face-g-list#my-g-list .face-g-block .my-mp-block .mp-info .btn:hover,.item .live-status.on,.link-panigation .panigation.selected,.live-btn.default,.live-btn.default:active,.live-btn.default:hover,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-btn,.nav-bar .nav-wrapper .slide-block,.nav-container .single-box .ep-item:hover,.news-body .news-1 i,.pagelist .flip-left .active,.pagelist .flip-left span:hover,.pay-activation-btn,.pay-activation-btn:hover,.pay-other-way-link,.pay-other-way-link:hover,.pay-points-way-btn,.pay-result-btn,.promote-m .headline .change-push:hover,.read-list-component .creat-read-list-box .input-box button,.record-ctnr .areas .btn-cntr .btn.normal:hover,.record-ctnr .areas .btn-cntr .btn:hover,.rel.pl122.mb20 .bgre,.rhythm-storm .bl-button,.song-info .info-wrap .submit-btn,.tabnav-tip.plain,.u-btn-e:hover,.ui-btn.blue-radius,.ui-radio input[type=radio]:checked+.ui-radio-icon:after,body #app .category-wrapper .dot,div.cntr a.check-all,ul.navigation li:after{background-color:var(--theme-color)!important}.page-title .count,.pay-result-btn:hover,.valid_box .button{background:var(--theme-color)!important}#area-anchor .area-title-link:hover,#page .game .game-box dl a:hover,#page .game .game-box dl dt,.achievement-card-centent>.header>.state-normal.-success,.achievement-user-info>.a,.act.tv-u-btn-t,.active-main .act-list ul li .event_status .status-ing,.active-main .act-list ul li h2 a:hover,.activity-card dd h4 a:hover,.agree-rule .rule,.agreement a,.area-section .card-ctnr .tag-ctnr .tags:hover,.article-holder .shop-card a .container .bottom-col,.balance,.bangumi-index-crumb ul li.on a,.bangumi-index-crumb ul li:hover a,.bangumi-item .bangumi-title:hover,.banner .slides-pagination li a:hover,.banner-p a:hover,.bb_intro_box_top .b_question .b_question_title:hover,.bbgr.cl.h29 .g1:hover,.bili-pay-panel-list-active .bili-pay-price,.bili-payment-num,.bind-info .bind-sec-title,.bind-info .note-content a,.bind-info .note-footer .agree-group .submit-deal,.blink-border.blue,.blink.blue,.block-left .headline .hot-link:hover,.btn-recharge-bcoin,.canvas-card dd h4 .user-container a:hover,.card-more a,.category li a:hover,.center-grid td a:hover,.center-grid th a:hover,.check-warp a,.cinema-home-crumb ul li.on a,.cinema-home-crumb ul li:hover a,.cl.mb20 .g1:hover,.classify .classify-list .list-item .class-block:hover,.classify .position span,.comment-manage-wrap .content .action-bar .dropdown .sort-btn:hover,.comment-manage-wrap .dropdown .dropdown-menu .selected,.container .main-btn.edit-btn,.container .main-btn:hover,.content .user-protocol a,.dc-option:hover,.dc-radio-button.is-active,.drawer-card li a:hover dd,.faq-modal .modal-wrap .modal-content .text-content a,.faq-modal .modal-wrap .modal-content .text-content a:active,.faq-modal .modal-wrap .modal-content .text-content a:hover,.favourite-card .other-info-ctnr>div .anchor-status.on-live,.filter-block .filter-item-wrapper .filter-item.on,.footer-box .footer-text a:hover,.func-banner .btn-dislike.active,.func-banner .btn-dislike:hover,.func-banner .btn-like.active,.func-banner .btn-like:hover,.func-banner .right-btns a:hover,.func-banner .right-btns span:hover,.game-groom-box-m .game-groom-m:hover .title,.hot-activity a:hover,.idol-show .section-title .title:hover,.income-info .item.left .value,.income-info .item.right .value,.instructions,.invite-code .code,.invite-code .copy-btn,.link-panigation .panigation:hover,.link-panigation .panigation:not(.selected):hover,.music-clue .font-blue,.music-clue .iconfont,.music-tips .music-tip:hover,.nav-bar .nav-wrapper .main-tab:hover,.nav-bar .sub-nav .sub-tab.active,.news-body .news-1 .news-text:hover .n-text,.online-list .ebox .dlo .author:hover,.online-list .ebox a:hover .etitle,.online-list .ebox:hover .ol b,.orderdetail-container .orderdetail-status h1,.panigation .arrow-right:hover i,.pay-points-way-next,.player-auxiliary-area .player-auxiliary-filter-menu:hover,.project-info table .project-content .content-right .ticket-type,.project-info table .project-content .content-right h1:hover,.project-info table td.total,.project-list .project-list-item .project-list-item-detail .project-list-item-price,.protocol-block a,.protocol-block a:hover,.qrpay-group .qrpay-content .price,.rank-item .detail .work-name:hover,.rank-menu li.active,.rank-tab-wrap .rank-tab .active,.recharge-rule a,.recharge-store-box ul.select-list .item.active,.recharge-store-box ul.select-list .item:hover,.record-ctnr .areas .all-area.checked,.rel.pl122.mb20 .g1:hover,.rel.pl26.mb18 .g1:hover,.relate-work-wrapper .work-info .go-play,.selector-wrapper .city-list .li-more span:hover,.selector-wrapper .order-list .li-more span:hover,.selector-wrapper .type-list .current-type span.active,.selector-wrapper .type-list li:hover,.set-copyright .copyright-select-box .copyright.selected .text,.set-copyright .copyright-select-box .copyright:hover .text,.sort-item.on,.spend-recode .title-group .recode-title,.sub-tab-box .item.active,.swiper-pagination-custom,.task-info .task-bar .status-icon.active,.title-factory-card .title-num .ajust-btn,.title-factory-card .title-num .num-value,.tool-box-v2-container .tool-xiaowan a:hover,.tool-box-v2-container .tool-xiaowan-bilibili a:hover,.topic-main .nav-tab .on,.total-container div span.total,.trade-wrapper.is-selected,.tv-m-crumb li a:hover,.tv-m1 .tv-m-tt:hover,.ui-checkbox input[type=checkbox]:checked+.ui-checkbox-icon,.ui-select .ul-select-list .select-item.active,.ui-select .ul-select-list .select-item:hover,.ui-tabs .ui-tabs-head .tab-head-item.current a,.upload-tips,.video-floor-m .zone-title .headline .tags li a:hover,.w160.h48.ovh .g1:hover,body #app .category-wrapper .upload-tip,body #app .marquee a,ul.navigation li:hover{color:var(--theme-color)!important}.bili-header-m .bubble-traditional .renew-btn button,.rhythm-storm .bl-button,.valid_box .button,div.cntr a.check-all{color:var(--foreground-color)!important}#edit-page .block-hr,#page .game .game-box,.comment-manage-wrap .head .dropdown-menu .article-list{border-top-color:transparent!important;border-bottom-color:transparent!important}#page .game .game-box-1,#page .game .game-box-3,.bili-pay-payment-nav,.bili-payment-list-border,.bili-tab.current:after,.dc-radio-button.is-active:after,.footer-logo,.game-box-all,.season-item.on:after,.ui-tabs .ui-tabs-head .tab-head-item.current a:after{border-left-color:transparent!important;border-right-color:transparent!important}#app .player-box,#i_menu_msg_btn #dyn_wnd,.album-content .my-album .link-panigation .panigation,.album-popup .album-pop-bottom ul li.disable,.album-popup .album-pop-bottom ul li.disable:hover,.album-radio::before,.attention-live .switch-btn:active,.attention-live .switch-btn:hover,.bili-wrapper.clearfix .up-info-m,.biliPager .pager-jumper .pager-jumper-input,.biliPager .pager-jumper a,.black-list .black-btn,.bui-container .gift-all,.bui-container .gift-recommend,.cc-article-wrp .article-card .meta-view .appeal,.cc-article-wrp .article-card .meta-view .data,.cc-article-wrp .article-card .meta-view .delete,.cc-article-wrp .article-card .meta-view .option,.cc-body .setting,.channel-menu,.col-4-med.col-4 .song-change,.collapse-subitem--active,.comment-list-item .ci-action a:hover,.comment-manage-wrap .content .action-bar .dropdown .action-menu li:hover,.comment-manage-wrap .content .action-bar .dropdown .sort-menu li:hover,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2),.d-buttons .d-button,.d-buttons .d-state-highlight,.drop-cascader-container .drop-cascader-list-wrp .drop-cascader-list-item:hover,.drop-cascader-container .drop-cascader-pre-wrp .drop-cascader-pre-item:hover,.drop-list-v2-container .drop-list-v2-item:hover,.dropdown__content .dropdown__active,.dropdown__content .dropdown__item:hover,.el-input-group__append,.el-input-group__prepend,.elecrank-wrapper .elecrank-content .rank-item .item-num,.elecrank-wrapper .elecrank-content .rank-item .msg,.face-buy-footer .btn-mk2.primary,.face-g-list .mp-block .right ul li .mp-tips,.fjw-kpi-wrap,.groom-box-m.clearfix .groom-module .type-name,.home-index .even,.home-index .odd,.invtable tr:nth-child(odd) td,.layout .layout-main .main-footer,.live-btn.default,.log-list li.log-item,.main-c .main-b .main-b-l .convert,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span.disabled,.mini-progress,.mini-wnd,.mobile-kpi-head h2,.multi-page .cur-list .module-box li,.nameplate-card,.nav-item2 .nav-item2-title:hover,.nav-item3.active,.nav-item3:hover,.new_list .vd_list li.l1,.p-relative.gold-seed-store.over-hidden .content,.panel-block input,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow:hover,.popup-btn .btn-default,.privilege-box-right-btn,.stm-lst-item .share,.stm-ly .ct .stm-filter li.on,.stm-ly .sd-l a:hover,.tab-selector-wrap .tag-wrap .tag span,.tab-selector-wrap .tag-wrap .tag span.selected,.time-picker-v2-container .time-picker-body-wrp .time-picker-panel-select-wrp .time-picker-panel-select-item:hover,.title-factory-card,.title-list .title-list-item:hover .tips,.video-toolbar-module .share-box .share-popup .share-address ul li input,.widescreen .footer,.widescreen.footer .footer-box,.works-ctnr .header-ctnr .works-count{background-color:#222!important}#dyn_wnd .wnd_bottom a.btn-article-more,#dyn_wnd .wnd_bottom a.btn-ignore-all,#dyn_wnd .wnd_bottom a.btn-live-more,#dyn_wnd .wnd_bottom a.read-more,#newsDetail .news-detail-content,#newsList #list,.album-popup,.alert-v2-container-info,.anime-expo-container,.app-ctnr .live-helper .main-content,.app-ctnr .live-helper .main-content .anchor li,.app-download .qr-code-box .div.box,.article-data-wrp .video-box,.article-header .filter-wrp .article-type,.article-header .filter-wrp .article-type .bili-btn,.article-header .filter-wrp .filter-article-type,.article-header .filter-wrp .filter-article-type .bili-btn,.article-header .filter-wrp .filter-level,.article-header .filter-wrp .filter-level .bili-btn,.article-net-charts .area,.article-net-charts .content-box,.b-page-body .container-body .pagelistbox .p,.bangumi-collection-card .bangumi-funcs .btn-unfollow li:hover,.bangumi-detail .detail-evaluate p i,.bangumi-detail .detail-evaluate p i:before,.bili-wrapper .del-log-content,.bili-wrapper .online-list .ebox,.bili-wrapper .online-list .ebox .ol,.btn-primary,.cc-article-wrp .article-card,.channel-menu .box a:hover,.check-radio-v2-2-container,.clearfix .multi-page .item,.code-content,.col-full.clearfix .album-content .my-album .pagination,.comment-container,.comment-container .main-desc .goods-info,.comment-manage-wrap .content,.common-modal-container .common-modal-content,.content-tag-v2-container .content-tag-v2-edit-mod-wrp,.content-tag-v2-container .content-tag-v2-other-tag-error-wrp,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-items .selector-item,.d-outer.d-state-lock.d-state-visible.d-state-focus .d-outer,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer,.date-picker-v2-container,.dc-button.dc-button-text,.dc-progress-bar,.detail-box-wrap .content-box .video-model,.drawer-pop-ctn.pop-ctn-4 .drawer-pop,.drop-cascader-container,.drop-list-v2-container,.dropdown__content,.elecrank-header .name,.elecrank-wrapper .elecrank-content,.elecrank-wrapper.report-wrap-module.report-scroll-module .elecrank-header,.face-buy-header,.face-buy-step,.file-list-v2-container .file-add-btn,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-upload-progress,.fixed-nav-m .go-top,.fixed-nav-m .mini,.fjw-kpi-wrap .fjw-kpi-foot .fjw-kpi-presents,.fjw-kpi-wrap .fjw-kpi-mid .fjw-grade-wrap,.fjw-kpi-wrap .fjw-kpi-top,.gift-all .gift-box,.gift-recommend .gift-box .info,.goods-container,.guide .trynew-btn a,.h-none-btn,.head .dropdown-btn,.head .dropdown.open .dropdown-btn,.help-box,.help-list,.hot-goods-container,.infor-body .news-contents,.input-box-v2-1-container,.invitation-record-warp .invtable .inputdone,.invtable .codedone,.ivu-form-item-error .ivu-input-group-append,.ivu-form-item-error .ivu-input-group-prepend,.ivu-input-costom-width .ivu-input-wrapper .ivu-input-wrapper-default .ivu-input-type .ivu-input,.label-item-v2-2-container,.list.main_body .right_box .select_box .select .option_block .option:hover,.live-haruna .tab-body .item,.mask .popup-box,.media-tab-content .nav-tools .tool-item,.mini-wnd .play-all,.mini-wnd .read-all,.mycollect-info .mycollect-li.even,.mycollect-info .mycollect-li.odd,.nav-item1 .nav-item1-title,.nav-item2 .nav-item2-title,.nav-warp2 .nav-item3,.normal-v2-container .normal-title-wrp>.template-op,.pagelistbox clearfix .pagelistbox .p,.pager .jump-pager input[type=number],.pagination-container li.pagination-input-wrap .pagination-input,.privacy-panel,.privacy-panel-other,.privilege-box.clearfix .privilege-box-right,.privilege-warp .privilege-content-warp,.r-con .mobile-link-l,.right-action-ctnr.pointer.dp-i-block.primary.btn.p-relative .btn.primary,.s-paging .jump-to-page input[type=text],.s-paging>ul>a,.s-paging>ul>a.disabled,.s-paging>ul>a:not(.disabled):not(.current):not(a):hover,.s-paging>ul>span,.s-paging>ul>span.disabled,.s-paging>ul>span:not(.disabled):not(.current):not(a):hover,.scroll-container .main .article-container,.security-right .sr-b .box-inner,.select-box-v2-container .select-box-v2-controller,.share-addr-item .share-addr-wrapper,.song-complain-bg .song-complain,.stm-ly .stm-lst,.stm-ly .stm-lst li,.stm-ly .usr,.stm-ly .usr .info,.stm-ly .usr .status,.stm-ly>.ct,.stm-ly>.sd>.sec,.sub-nav-m.report-wrap-module .sub-nav-m .tips,.submit-button-group-v2-container .submit-btn-group-tpl,.tab-selector-wrap,.tag-modal,.tags-box .tag,.template-list-small-container,.time-picker-v2-container,.title-item,.video-toolbar-module,.video-toolbar-module .app-download .qr-code-box,.video-toolbar-module .app-download:after,.video-toolbar-module .app-download:hover,.video-toolbar-module .share-box .share-popup,.video-toolbar-module .share-box:after,.video-toolbar-module .share-box:hover,.videoCharts .stat .stat-wrp{background-color:#444!important}.album-radio.active::before,.album-radio::before,.attention-live .switch-btn:active,.attention-live .switch-btn:hover,.bangumi-collection-wrap .bangumi-collection,.bangumi-collection-wrap .bangumi-collection-d,.bangumi-collection-wrap .bangumi-order,.bangumi-collection-wrap .bangumi-order-d,.bangumi-order-wrap .bangumi-collection,.bangumi-order-wrap .bangumi-collection-d,.bangumi-order-wrap .bangumi-order,.bangumi-order-wrap .bangumi-order-d,.elecrank-header .rank-tab .arr-up,.elecrank-wrapper .elecrank-content .rank-item .msg .arrow,.gift-recommend .gift-box .hover-bg,.home-wrap .home-input .type.selected,.home-wrap .home-input .type:hover,.live-haruna .section-stage .stage-wrap,.nameplate-card .nameplate-arrow,.sr-record a.on,.sub-nav-m .tips .t-arrow,.tabs-nav .active{background-image:none!important}#app .player-box .multi-page,#app-news .comment-area,#page-subs .content,.album-report-ctn.ps.ps--active-y .ps__rail-x:focus,.album-report-ctn.ps.ps--active-y .ps__rail-x:hover,.album-report-ctn.ps.ps--active-y .ps__rail-y:focus,.album-report-ctn.ps.ps--active-y .ps__rail-y:hover,.biliPager .page-li,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-split,.help-subcontent p,.my-album .line{background-color:transparent!important}.article-header .filter-wrp .article-type .line,.article-header .filter-wrp .filter-article-type .line,.article-header .filter-wrp .filter-level .line,.border-line,.setting .follow-setting .follow-wrp .follow-modal{background:0 0!important}#dyn_wnd .dyn_list li.loading,#page-fav .fav-main .fav-action-top .clearing-invalid-video,#page-fav .fav-main .fav-video-list .article-item .article-meta .meta-item,#page-fav .fav-main .fav-video-list.topic-list .large-item .desc,#page-fav .fav-main .fav-video-list.topic-list .large-item .pubdate,#page-fav .fav-main .filter-item.search ::-webkit-input-placeholder,#page-fav .search-empty-hint p,#page-follows .modal-container .content-tip,#page-index .col-2 .section .auth-detail,.add-cover,.album-report .tip,.announcement-cntr .tips,.article-data-wrp .menu-wrp .menu-tips,.article-holder .color-gray-03,.article-holder figcaption,.bangumi-detail .detail-evaluate,.bangumi-detail .detail-evaluate p.static,.bangumi-detail .detail-info,.biliPager .pager-jumper,.black-info .black-time,.btn-sponsor-wrapper .sponsor-count,.card-user,.cc-article-wrp .article-card .meta-title .typename,.cc-article-wrp .article-card .meta-view .appeal,.cc-article-wrp .article-card .meta-view .data,.cc-article-wrp .article-card .meta-view .delete,.cc-article-wrp .article-card .meta-view .option,.channel-menu .box .count,.comment-container .main-desc .comment-info .word-container .bottom .personal-info .nickname,.content-tag-v2-container .content-tag-v2-other-wrp .content-tag-v2-mission-tag-wrp .content-tag-v2-mission-tag-tip,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-left .cover-chop-clip-reset-v2>span,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-left .cover-chop-clip-warning-v2>span.chop-warning-normal,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-right>p,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-title,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-title-more,.creation-li .creation-right .creation-publish,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item-disabled,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item-disabled,.date-picker-v2-container .date-picker-v2-nav-wrp .next-btn-day,.date-picker-v2-container .date-picker-v2-nav-wrp .next-btn-month,.date-picker-v2-container .date-picker-v2-nav-wrp .prev-btn-day,.date-picker-v2-container .date-picker-v2-nav-wrp .prev-btn-month,.del-log-content .del-log-header .block,.del-log-content .log-statictic,.edit-button>span,.elecrank-header .rank-tab,.elecrank-wrapper .elecrank-content.no-list .desc,.file-list-v2-container .file-title p,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-upload-info,.fjw-kpi-wrap .fjw-kpi-top .fjw-person-detail label.fjw-person-item,.footer-box .footer-text p,.footer-box a,.footer-text .record,.gift-all .gift-box .info .price-box .price-old,.gift-all .gift-box .info p,.gift-recommend .gift-box .info .price-box .price-old,.h .report-popup-tip,.h-none-msg,.help-footer-warp .foot_title,.help-footer-warp p,.invitation-subtitle,.item .brief-desc,.left-nav-childed-list,.list.main_body .list_box .block .info .text,.list.main_body .right_box .select_box .select .option_block .option,.live-haruna,.main-container .sponsor-wrapper .sponsor-right-area .sponsor-count-info,.main-footer .cp,.main-footer .link-item a,.main_body .future .future_list .future_block .info .loca,.more-selector-v2-container .more-selector-v2-title-wrp .more-selector-v2-drop-tip,.my-album .album-count,.my-album .error .text,.my-room.room-info .room-info-ctnr .san-num,.my-room.room-info .room-info-ctnr .timing-num,.mycollect-info .mycollect-li .song-title .song-float,.mycollect-padding .mycollect-publish,.mycollect-theme span,.new_list .vd_list li .up,.new_list .vd_list li .w_info i,.newlist_info.clearfix .b-head .b-head-s,.no-data-voucher,.notice .blink,.notice-ctnr .blink,.page_body .page_box .block .info .text,.play-num,.pop-live .pl__user,.privacy-panel .tip,.privilege-box-right-title .privilege-subtitle,.qrcode-box .tip,.record-ctnr .summary .s-item .title,.report-reason-pic-row .report-pic-description,.room-introduction-content.empty,.s_tag .btn-view-tag,.s_tag .btn-view-tag a,.sap-use-view,.section-title-v2-container .section-title-v2-content-sub,.security-right .vip-help p,.setting .follow-setting .follow-wrp .follow-modal .follow-show p,.share-qr-hint,.similar-song-menu .similar-right .song-num,.song-li .song-right .song-right-bottom .song-num,.sponsor-pay-dialog-v2 .sp-quick-pay .sponsor-pay-body .sponsor-control-group label,.sponsor-pay-dialog-v2 .sp-quick-pay .sponsor-pay-body .sponsor-control-group span,.stm-ly .sd-l a,.stm-ly .stm-lst .hint,.tab-selector-wrap .tag-wrap .tag span,.text-area-box-v2-container .text-area-box-v2-max-tip,.title-item,.type-rank-item-label,.up-info-m .number,.video-desc-m .reprint,.video-info-m .tm-info,.video-info-m .tm-info .btn-appeal,.video-info-m .tm-info a,.video-info-m .tm-info time,.video-toolbar-module .app-download .qr-code-box .box .txt,.video-toolbar-module .btn-item .num,.video-toolbar-module .share-box .s-text .num,.vippendant-descript,.viptable .history-remark,.voucher-bottom-txt,.voucher-left-money,.voucher-left-money:before,.voucher-left-txt,.voucher-right-condition,.voucher-right-order,.voucher-right-time,.water-mark-set-v2-copy-switch-wrp a,.widescreen .footer,.year-vip-user .vippendant-title,li.log-item .user-time{color:#aaa!important}#dc-section_summary .source-rank-list-item .video-info-title a,#dyn_wnd .dyn_menu,#fixnav_report .fixed-nav-m .mini,#fixnav_report .fixed-nav-m .mini:hover,#gameCenter .hot-list .s-imgUnit .rank.gray,#gameCenter .look-around .s-imgUnit .s-imgUnit-text,#page-follows .modal-container .content-text,#viewbox_report.video-info-m h1,.about-index .about-desc,.academy-left-name,.academy-right-link,.album-popup .album-pop-bottom ul li.disable,.album-popup .album-pop-bottom ul li.disable:hover,.album-popup .album-pop-bottom ul li.normal,.album-popup .album-pop-bottom ul li:hover,.album-report .report-title,.alert-v2-container-info div.alert-v2-btn:nth-child(2),.anime-expo-container .head .title,.app-ctnr .live-helper .main-content .anchor li,.app-ctnr .live-helper .main-content .menu-item .menu-title,.app-ctnr .live-helper .main-content .menu-item .menu-txt,.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a:hover,.article-container .head .title,.article-header .dropdown-btn,.article-header .dropdown-btn .icon-ic_unfold,.article-header .dropdown-btn .icon-text,.article-header .filter-wrp .article-bread .main,.article-header .filter-wrp .article-type .bili-btn,.article-header .filter-wrp .category-wrp,.article-header .filter-wrp .filter-article-type .bili-btn,.article-header .filter-wrp .filter-level .bili-btn,.article-header .filter-wrp .order-wrp,.article-holder .ticket-card a .container .title,.bangumi-collection-card .bangumi-funcs .btn-unfollow li:hover,.bangumi-detail .detail-evaluate p i,.big-history-title,.big-user-name,.biliPager .current span,.biliPager .pager-jumper .pager-jumper-input,.biliPager .pager-jumper a,.biliPager .pager-jumper a:hover,.bind-info .note-footer .btn-group .active-btn,.black-info .black-name,.black-list .black-btn,.black-list .black-btn:hover,.bp_user_box .bp_user_box_bb,.bp_user_box .bp_user_box_bk,.btn-primary,.bui-content .g-title .btn,.bui-content .g-title .btn:hover,.bui-content .g-title h4,.c-top .name-top1,.card-txt,.categories-bar .tag-item,.cc-article-wrp .article-header .search-wrp input,.channel-menu .box a,.check-box-v2-container .check-box-v2-content,.check-radio-v2-container .check-radio-v2-name,.choices .album-radio,.clearfix .multi-page .item,.clearfix .multi-page .item.on,.clearfix .multi-page .item:hover,.code-btn,.coin-operated-m .coin-bottom .coin-btn,.coin-operated-m .like-checkbox,.col-4-med.col-4 .song-change,.collapse-item a,.collapse-subitem--active a,.comment-container .head .title,.common-modal-container .common-modal-content .common-modal-foot>div div:first-child,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2),.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2):hover,.content-tag-v2-container .content-tag-v2-edit-mod-wrp,.content-tag-v2-container .content-tag-v2-other-tag-error-wrp,.creation-title,.d-buttons .d-button,.d-buttons .d-button:hover,.d-buttons .d-state-highlight,.d-buttons .d-state-highlight:active,.d-buttons .d-state-highlight:hover,.d-header .d-titleBar .d-title,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer,.d-time-v2-container .d-time-v2-switch-wrp p.d-time-v2-last,.d-time-v2-container .d-time-v2-switch-wrp p.d-time-v2-pre,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item-selected,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .weekend-item,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item-selected,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .weekend-item,.date-picker-v2-container .date-picker-v2-nav-wrp p.date-picker-nav-title,.dc-button.dc-button-text,.dc-button.dc-button-text a,.dc-button.dc-button-text:hover,.details-list-t div,.details-up-name a,.drop-cascader-container .drop-cascader-list-wrp .drop-cascader-list-item p.item-main,.drop-cascader-container .drop-cascader-pre-wrp .drop-cascader-pre-item .pre-item-content,.drop-list-v2-container .drop-list-v2-item .drop-list-v2-item-cont p.item-cont-main,.drop-menu-item,.dropdown__content .dropdown__item,.el-input-group__append,.el-input-group__prepend,.elecrank-header .title,.elecrank-wrapper .elecrank-content .rank-item .item-num,.elecrank-wrapper .elecrank-content .rank-item .msg,.elecrank-wrapper .elecrank-content.no-list .elec-btn,.elecrank-wrapper.no .elecrank-header.no-list .total-txt,.electron-set-v2-container .electron-set-v2-copy-switch-wrp .electron-set-v2-hint,.face-buy-footer .btn-mk2.primary,.face-buy-name,.face-g-list .mp-block .right ul li .mp-tips,.face-g-list .mp-block .right ul li .mp-tips .btn,.file-list-v2-container .file-add-btn,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-icon,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-status-wrp .item-status-op,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-status-wrp p.item-title,.fjw-kpi-wrap .fjw-kpi-foot .fjw-kpi-presents .kpi-presents-item .present-text,.fjw-kpi-wrap .fjw-kpi-mid .fjw-grade-wrap .fjw-grade .fjw-grade-text,.fjw-kpi-wrap .fjw-kpi-mid .fjw-grade-wrap .fjw-progress-title .description,.fjw-kpi-wrap .fjw-kpi-top .fjw-person-detail label.fjw-person-item .fjw-name,.fjw-kpi-wrap h2.fjw-kpi-h2,.gift-all .gift-box .info h5,.gift-all .gift-box:hover .info .btn,.gift-all .gift-box:hover .info h5,.gift-all .gift-box:hover .info p,.gift-recommend .gift-box .hover-bg .depict,.gift-recommend .gift-box .info h5,.go-back-link,.groom-box-m.clearfix .groom-module .type-name,.guide .trynew-btn a,.h .report-popup-item-text,.h-none-btn,.h-none-btn:hover,.head .dropdown-menu .search .bili-input,.help-subindex,.help-subtitle,.home-top-msg-name,.info-line a,.infor-body-left .news-contents .c-text,.input-box-v2-1-container .input-box-v2-1-instance .input-box-v2-1-val,.invitation-title,.invtable .codedone,.item .title-wrap,.ivu-btn-primary.active,.ivu-btn-primary:active,.ivu-btn-primary:hover,.ivu-form .ivu-form-item-label,.ivu-input-costom-width .ivu-input-wrapper .ivu-input-wrapper-default .ivu-input-type .ivu-input,.ivu-input-group-append,.ivu-input-group-prepend,.label-item-v2-2-container,.label-item-v2-2-container-selected,.left-nav-item,.left-nav-item .icon,.left-nav-item-child,.left-nav-wrapper .advice-btn,.list-wrap.hot-forum-lft-con .s-imgUnit a,.list.main_body .list_box .block .info .title,.list.main_body .right_box .select_box .select .title,.live-btn,.live-btn.default,.live-info .label,.live-setting-ctnr,.log-item li.log-item .txt-block,.main-c .main-b .main-b-l .convert,.main-c .main-b .main-b-l .info-l p,.main-t .main-title,.main_body .future .future_list .future_block .info .title,.main_body .pick_up .pick_list .pick_block .info .title,.mainly-automatic dl,.mainly-automatic h2,.mainly-question h2,.media-tab-content .nav-tools .tool-item:hover,.mini-wnd .play-all,.mini-wnd .read-all,.misl-ep-item .mark-icon,.mobile-kpi-head h2,.more-selector-v2-container .more-selector-v2-title-wrp>h1,.multi-page .cur-list .module-box li,.my-room.room-info .room-info-ctnr .room-id,.mycollect-info .mycollect-li .song-sort,.mycollect-info .mycollect-li .song-title .song-normal,.mycollect-info .mycollect-li .song-uname,.mycollect-padding .mycollect-board .mycollect-playbtn,.mycollect-padding .mycollect-title,.mycollect-padding .mycollect-upname,.mycollect-theme,.nameplate-card .nameplate-text .n-name,.nav-item2 .nav-item2-title,.nav-item3.active,.nav-warp2 .nav-item3,.new_list .vd_list li .title,.new_list .vd_list li .typename,.news-content a,.news-contents h2,.news-detail-content .news-title,.page_body .page_box .block .info .title,.pager .jump-pager input[type=number],.pagination-container li.pagination,.pagination-container li.pagination-input-wrap .pagination-input,.panel-block h4,.panel-block input,.player-limit-wrap .limit_not_start_wrap .not_start_btn span,.popup-btn .btn-default,.popup-content,.privacy-type .album-radio.bp-album-radio,.privilege-box-right-btn,.privilege-box-right-name,.privilege-content-warp .right-crumbs,.privilege-content-warp .right-crumbs a,.privilege-content-warp .right-crumbs i,.privilege-tabs .privilege-item,.privilege-tabs-title,.q-box .q-title a,.q-c-div dl,.reportImage-candidate-item.dp-i-block.bg-cover.bg-center.bg-no-repeat.ts-dot-3.pointer.p-relative .upload-hint,.room-id,.s-paging .jump-to-page input[type=text],.s-paging>ul>a,.s-paging>ul>a:not(.disabled):not(.current):hover,.s-paging>ul>a:not(.disabled):not(.current):not(a):hover,.s-paging>ul>span,.s-paging>ul>span:not(.disabled):not(.current):hover,.s-paging>ul>span:not(.disabled):not(.current):not(a):hover,.s-statusUnit-text .info a,.score-info span,.search-wrp .bili-input,.security-right .main-c .xts,.security-right .main-c .xts i,.security-right .vip-help a,.select-box-v2-container .select-box-v2-controller,.select-box-v2-container .select-box-v2-controller .select-item-cont-inserted,.share-addr-item .share-addr-name,.share-addr-item .share-addr-wrapper,.song-change .font12,.song-complain-bg .song-complain .complain-btn,.song-complain-bg .song-complain .complain-text,.song-complain-bg .song-complain .complain-title,.song-li .song-right .song-right-title,.song-li .song-right .song-theme,.song-right-title a,.spa-sub-title,.spa-use-type,.spa-user-info a,.sponsor-pay-dialog-v2 .sp-quick-pay .sponsor-pay-body .sponsor-control-group,.sr-record a,.start-live,.stm-ly .ct .stm-filter li,.stm-ly .stm-lst .name a,.sub-nav-m.report-wrap-module .sub-nav-m .tips,.submit-button-group-v2-container .submit-btn-group-add,.submit-button-group-v2-container .submit-btn-group-tpl,.t-gray-dark,.tab-selector-wrap .tab-wrap .tab a,.tabs-tab,.tag-default,.tag-default.current,.tag-default:active,.tag-default:hover,.tag-modal,.tag-modal .tag-item,.tag-modal .tag-title,.time-picker-v2-container .time-picker-body-wrp .time-picker-panel-select-wrp .time-picker-panel-select-item,.time-picker-v2-container .time-picker-head-wrp .time-picker-show,.title-name,.total-bt .t-date a,.tv-m2 .tv-m-tt,.tv-m3 .tv-m-tt,.video-toolbar-module .app-download,.video-toolbar-module .btn-item .t,.video-toolbar-module .share-box .s-text .t,.video-toolbar-module .share-box .share-popup .share-address ul li .btn,.video-toolbar-module .share-box .share-popup .share-address ul li .name,.video-toolbar-module .share-box .share-popup .share-address ul li input,.viptable .history-th,.voucher-right-name,.water-mark-set-v2-container .water-mark-set-v2-copy-switch-wrp>span,.works-ctnr .header-ctnr .works-count,table.invtable td,table.viptable td{color:#eee!important}#app .player-box,#dc-section_summary .source-rank-list-item,#dyn_wnd .wnd_bottom a.btn-article-more,#dyn_wnd .wnd_bottom a.btn-ignore-all,#dyn_wnd .wnd_bottom a.btn-live-more,#dyn_wnd .wnd_bottom a.read-more,#gameCenter .hot-list .s-imgUnit,#gameCenter .hot-list .s-imgUnit .rank,#gameCenter .hot-list .s-imgUnit:hover,#i_menu_msg_btn #dyn_wnd,.about-index .about-desc,.album-popup .album-pop-bottom ul li.disable,.album-popup .album-pop-bottom ul li.disable:hover,.album-popup .album-pop-bottom ul li.normal,.album-popup .album-pop-bottom ul li:hover,.apply-form .btn,.apply-form .btn:hover,.areas .area,.article-chart-wrp,.article-header .filter-wrp .article-type,.article-header .filter-wrp .category-wrp,.article-header .filter-wrp .filter-article-type,.article-header .filter-wrp .filter-level,.article-header .filter-wrp .order-wrp,.article-holder .ticket-card a,.biliPager .page-li,.biliPager .pager-jumper .pager-jumper-input,.biliPager .pager-jumper a,.biliPager .pager-jumper a:hover,.black-list .black-btn,.black-list .black-btn:hover,.black-ul.clearfix .black-list,.bp_user_box_bb,.bp_user_box_bottom p,.btn-primary,.btn-section .btn-item,.c-text .c-hd2,.channel-menu .r-box,.clearfix .multi-page .item,.clearfix .multi-page .item.on,.clearfix .multi-page .item:hover,.code-result,.coin-operated-m .coin-bottom .coin-btn,.coin-operated-m .coin-bottom .coin-btn:hover,.comment-list-item,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2),.common-modal-container .common-modal-content .common-modal-head,.container-body .newlist_info,.content-tag-v2-container .content-tag-v2-edit-mod-wrp,.content-tag-v2-container .content-tag-v2-other-tag-error-wrp,.d-buttons .d-button,.d-buttons .d-state-highlight,.d-header .d-titleBar .d-title,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer,.drawer-pop-ctn.pop-ctn-4 .draw-list,.drop-cascader-container,.drop-cascader-container .drop-cascader-list-wrp,.drop-list-v2-container,.dropdown .dropdown-menu,.el-input-group__append,.el-input-group__prepend,.elecrank-wrapper .elecrank-content,.elecrank-wrapper .elecrank-footer,.elecrank-wrapper.report-wrap-module.report-scroll-module .elecrank-header,.face-buy-footer .btn-mk2.primary,.face-g-list .mp-block .right ul li .mp-tips,.feed-card .content .card,.file-list-v2-container .dividing-line,.fixed-nav-m .go-top,.fixed-nav-m .mini,.footer-logo-list .footer-logo,.g-title .btn.btn-red,.g-title .btn.btn-red:hover,.gift-all .gift-box,.h .report-popup-item.checked .report-popup-item-checkbox,.head .dropdown-btn,.help-box,.help-list,.home-wrap .home-input .type.selected,.home-wrap .home-input .type:hover,.input-box-v2-1-container,.ivu-input-costom-width .ivu-input-wrapper .ivu-input-wrapper-default .ivu-input-type .ivu-input,.l-wrapper .y-layout,.label-item-v2-2-container,.left-side .categories-bar,.list.main_body .list_box .block,.list.main_body .right_box .select_box .select .title,.live-haruna .tab-body .item,.main-c .main-b .main-b-l,.main-c .main-b .main-b-l .convert,.main-footer .link-item,.media-tab-content .nav-tools .tool-item,.media-tab-content .nav-tools .tool-item:hover,.mini-wnd,.mini-wnd .play-all,.mini-wnd .read-all,.mobile-kpi-head,.multi-page .cur-list .module-box li,.my-room.room-info .room-info-ctnr .top,.mycollect-info,.nameplate-card,.nameplate-card .nameplate-text,.nav-item2 .nav-item2-title,.nav-warp1 .nav-item2,.nav-warp2 .nav-item3,.new_list .vd_list li .up,.new_list .vd_list li.l1,.news-detail-content .sepatator,.normal-v2-container .dividing-line,.normal-v2-container .normal-title-wrp>.template-op,.page-wrp.is-article.cc-article-wrp .article-card,.pager .jump-pager input[type=number],.pagination-container li.pagination,.pagination-container li.pagination-input-wrap .pagination-input,.panel-block input,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow:hover,.popup-box .popup-title,.popup-btn .btn-default,.popup-btn .btn-default:hover,.popup-close-btn,.privacy-panel,.privacy-panel-other,.privilege-box.clearfix .privilege-box-right,.privilege-content-warp .privilege-box,.privilege-tabs-title,.r-con .mobile-link-l,.record-ctnr .summary,.s-paging .jump-to-page input[type=text],.s-paging>ul>a,.s-paging>ul>a.current,.s-paging>ul>a:not(.disabled):not(.current):hover,.s-paging>ul>a:not(.disabled):not(.current):not(a),.s-paging>ul>a:not(.disabled):not(.current):not(a):hover,.s-paging>ul>span,.s-paging>ul>span.current,.s-paging>ul>span:not(.disabled):not(.current):hover,.s-paging>ul>span:not(.disabled):not(.current):not(a),.s-paging>ul>span:not(.disabled):not(.current):not(a):hover,.security-right .faq-line,.security-right .sr-record,.security-right .vip-help,.security-right .vip-help p,.select-box-v2-container .select-box-v2-controller,.setting.cc-content-body .setting .follow-setting,.share-addr-item .share-addr-wrapper,.song-complain-bg .song-complain .complain-title,.stm-lst-item .share,.stm-ly .ct .stm-filter li.on,.stm-ly .stm-lst li+li,.stm-ly .usr,.stm-ly>.ct,.stm-ly>.sd>.sec,.sub-nav-m.report-wrap-module .sub-nav-m .tips,.submit-button-group-v2-container .submit-btn-group-tpl,.tab-selector-wrap .tab-wrap,.tab-selector-wrap .tag-wrap .tag span.selected,.tag-default,.tag-default.current,.tag-default:active,.tag-input,.template-list-small-container,.title-factory-card,.title-factory-card .title-num,.title-item,.title-list .title-list-item:hover .tips .tips-title,.tv-m2,.tv-m2:nth-child(odd),.tv-m3,.user-avatar,.user-ctnr .top,.video-info-m .number .line,.video-toolbar-module .app-download:hover,.video-toolbar-module .app-download:hover .qr-code-box,.video-toolbar-module .share-box .share-popup .or-code,.video-toolbar-module .share-box .share-popup .share-address ul li input,.video-toolbar-module .share-box:hover,.video-toolbar-module .share-box:hover .share-popup,.videoCharts .stat .stat-wrp .stat-card{border-color:transparent!important}.add-cover,.cc-article-wrp .article-card .meta-title .typename,.check-radio-v2-container .check-radio-v2-box,.text-area-box-v2-container,.voucher-content-outside .voucher-list-wrapper,.voucher-list-wrapper.voucher-ing .voucher-right{border-color:#aaa!important}#page-fav .fav-main .filter-item.search{border-color:#666!important}#arc_toolbar_report .elec-btn .bili-icon,#arc_toolbar_report .elec-btn .icon,#playpage_share .share-btn .clearfix .bili-icon,#playpage_share .share-btn .clearfix .icon,.footer-logo-list .footer-logo,.icon-back,.left-nav-logo,.nav-item1 .nav-item1-title i.item0,.nav-item1 .nav-item1-title i.item1,.nav-item1 .nav-item1-title.arrow:after,.video-toolbar-module .b-icon,.video-toolbar-module .fav-box .btn-item .f-icon-move{filter:brightness(0) invert(1)!important}.main-c .main-head{filter:brightness(.5) contrast(3)!important}.article-data-wrp .video-box,.article-net-charts .content-box,.el-radio-button__orig-radio:checked+.el-radio-button__inner,.face-g-list .mp-block .right ul li .mp-tips,.guide .trynew-btn a,.videoCharts .stat .stat-wrp{box-shadow:none!important}#dyn_wnd .dyn_menu .line:before,.add-cover:hover,.app-ctnr .live-helper .main-content .menu-item .menu-title,.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-filter .bilibili-player-filter-btn.active>span,.bind-info .note-footer .btn-group .active-btn,.creation-li .creation-left .creation-shadow,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-date:hover,.d-time-v2-container .d-time-v2-date-picker-wrp .date-picker-date-wrp .date-picker-timer:hover,.data-card .data-box .tab .fan-tab.current:after,.data-card .fans-box .tab .fan-tab.current:after,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item:hover,.el-checkbox__inner:hover,.el-checkbox__input.is-checked .el-checkbox__inner,.el-checkbox__input.is-indeterminate .el-checkbox__inner,.elecrank-header .rank-tab.active,.input-box-v2-1-container.input-box-v2-1-container-active,.input-box-v2-1-container:hover,.ivu-input:focus,.ivu-input:hover,.left-side .categories-bar .tag-item.on,.multi-page .cur-list .module-box li.on,.multi-page .cur-list .module-box li:hover,.nav-item3.active,.s_tag .btn-add:hover,.section-item .diff-wrp .diff-text:before,.security-right .sr-record a.on,.select-box-v2-container .select-box-v2-controller:hover,.slider-ad-m .carousel-module .panel .trig span.on,.tab-selector-wrap .tab-wrap .tab span.active,.tab-selector-wrap .tag-wrap .tag span.selected,.tabs-tab-active:before,.text-area-box-v2-container.text-area-box-v2-container-active,.text-area-box-v2-container:hover,.voucher-content-outside .voucher-ing,.voucher-content-outside .voucher-no-used{border-color:var(--theme-color)!important}#dyn_wnd .dyn_menu .line,#dyn_wnd .wnd_bottom a.btn-article-more:hover,#dyn_wnd .wnd_bottom a.btn-ignore-all:hover,#dyn_wnd .wnd_bottom a.btn-live-more:hover,#dyn_wnd .wnd_bottom a.read-more:hover,.ac-artilce-tabs .tabs-nav .active,.album-popup .album-pop-bottom ul li.normal,.album-popup .album-pop-bottom ul li:hover,.album-radio.active::before,.alert-v2-container-info div.alert-v2-btn:nth-child(2),.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a:hover,.apply-form .btn,.apply-form .btn:hover,.biliPager .current span,.biliPager .pager-jumper a:hover,.bind-info .note-footer .btn-group .active-btn,.black-list .black-btn:hover,.bui-content .g-title .btn:hover,.cc-article-wrp .article-card .meta-view .appeal:hover,.cc-article-wrp .article-card .meta-view .data:hover,.cc-article-wrp .article-card .meta-view .delete:hover,.cc-article-wrp .article-card .meta-view .option:hover,.check-radio-v2-2-container.check-radio-v2-2-container-active,.check-radio-v2-container .check-radio-v2-box.check-radio-v2-box-checked:after,.clearfix .multi-page .item.on,.clearfix .multi-page .item:hover,.code-btn,.code-btn:hover,.coin-operated-m .coin-bottom .coin-btn,.coin-operated-m .coin-bottom .coin-btn:hover,.col-4-med.col-4 .song-change:hover,.common-modal-container .common-modal-content .common-modal-foot>div div:first-child,.common-modal-container .common-modal-content .common-modal-foot>div div:first-child:hover,.common-modal-container .common-modal-content .common-modal-foot>div div:nth-child(2):hover,.d-buttons .d-button:hover,.d-buttons .d-state-highlight:active,.d-buttons .d-state-highlight:hover,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item-selected,.date-picker-v2-container .date-picker-v2-body-wrp .weekend-wrp .date-item-selected,.dc-button.dc-button-text:hover,.el-checkbox__input.is-checked .el-checkbox__inner,.el-checkbox__input.is-indeterminate .el-checkbox__inner,.elecrank-wrapper .elecrank-content.no-list .elec-btn,.face-buy-footer .btn-mk2.primary:hover,.face-g-list .mp-block .right ul li .mp-tips .btn,.face-g-list .mp-block .right ul li .mp-tips .btn:hover,.file-list-v2-container .file-add-btn:hover,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-upload-progress .item-upload-progress-loading,.fixed-nav-m .mini:hover,.gift-all .g-title:before,.gift-all .gift-box:hover,.gift-recommend .g-title h4:before,.gift-recommend .gift-box .hover-bg,.guide .trynew-btn a:hover,.h .report-popup-item.checked .report-popup-item-checkbox,.h-none-btn:hover,.head .dropdown-btn:hover,.helper-icon-dots,.item .title-wrap .activity,.label-item-v2-2-container-selected,.label-item-v2-2-container:hover,.label-item-v2-container,.live-btn,.live-btn.default:active,.live-btn.default:hover,.live-btn:active,.live-btn:hover,.main-c .main-b .main-b-l .convert:hover,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-btns .bangumi-btn .btn-follow,.media-info-wrp .media-info-content .media-info-inner .media-info-r .media-info-btns .bangumi-btn .btn-follow:hover,.media-tab-content .nav-tools .tool-item:hover,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span.disabled:hover,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav .slider-contro span:hover,.mini-wnd .play-all:hover,.mini-wnd .read-all:hover,.misl-ep-item .mark-icon.badge-pink,.mycollect-padding .mycollect-board .mycollect-playbtn,.mycollect-padding .mycollect-board .mycollect-playbtn:hover,.player-limit-wrap .limit_not_start_wrap .not_start_btn .follow,.pop-live .pl__mask .pl__icon--live,.popup-btn .btn-default:hover,.popup-close-btn,.privilege-box-right-btn:hover,.qa-index .help-list .collapse-item.collapse-item-active .collapse-title-icon,.s-paging>ul>a.current,.s-paging>ul>a:not(.disabled):not(.current):hover,.s-paging>ul>span.current,.s-paging>ul>span:not(.disabled):not(.current):hover,.song-complain-bg .song-complain .complain-btn,.submit-button-group-v2-container .submit-btn-group-add,.submit-button-group-v2-container .submit-btn-group-add-img:hover,.submit-button-group-v2-container .submit-btn-group-add:hover,.submit-button-group-v2-container .submit-btn-group-tpl:hover,.tabs_active-bar,.tag-default.current,.tag-default:active,.tag-default:hover,.video-toolbar-module .share-box .share-popup .share-address ul li .btn{background-color:var(--theme-color)!important}#bp_right .balance_bp_box .button{background:var(--theme-color)!important}#dyn_wnd .dyn_menu li.on,#dyn_wnd .dyn_menu li:hover,#gameCenter .hot-list .s-imgUnit .rank.pink,#page-follows .modal-container .content-text em,#status .s-statusUnit .s-statusUnit-text .info .game-name,.academy-right-link:hover,.add-cover:hover,.album-radio.active,.anime-expo-container .main .price,.app-ctnr .live-helper .main-content .anchor li:hover,.app-ctnr .live-helper .main-content .menu-item .menu-txt .download .down-item a,.app-ctnr .live-helper .main-content .menu-item .menu-txt p a,.article-header .filter-wrp .article-type .bili-btn.current,.article-header .filter-wrp .filter-article-type .bili-btn.current,.article-header .filter-wrp .filter-level .bili-btn.current,.bili-blue,.categories-bar .tag-item.on,.check-box-v2-container .check-box-v2-pre-selected,.collapse-item--active .collapse-title,.comment-card .comment-item .comment-info .reply-block .comment-vedio a,.comment-container .main-desc .goods-info .desc .price,.cover-chop-modal-v2-body .cover-chop-modal-v2-body-left .cover-chop-clip-reset-v2:hover>span,.cover-v2-container .cover-v2-detail-wrp .cover-v2-selector .cover-v2-selector-title-more:hover,.date-picker-v2-container .date-picker-v2-body-wrp .date-wrp .date-item:hover,.date-picker-v2-container .date-picker-v2-footer-wrp .date-picker-v2-select-today,.drop-cascader-container .drop-cascader-list-wrp .drop-cascader-list-item-selected p.item-main,.drop-cascader-container .drop-cascader-pre-wrp .drop-cascader-pre-item-selected .pre-item-content,.drop-list-v2-container .drop-list-v2-item i.drop-list-v2-item-icon,.drop-menu-item:hover,.elecrank-header .rank-tab.active,.file-list-v2-wrp .file-list-v2-item .file-list-v2-item-wrp .item-status-wrp .item-status-op .item-status-click:hover,.fixed-service-word a,.fixed-service-word a:hover,.footer-box .footer-text a:hover,.gift-all .gift-box .info .price-box em,.gift-recommend .gift-box .info .price-box em,.goods-container>.info-container .price,.help-subcontent a,.help-subcontent a:hover,.help-subindex,.help-title-wrap.help-box .help-title,.home-wrap .home-suggest .title .delete-history:hover,.hot-goods-container .bottom .price-tag .price,.i-pin-info a:hover,.icon-label.hover-text-blue:hover .label,.item:hover .title,.left-nav-item-child:hover,.left-nav-item-childed:hover,.left-nav-item:hover,.left-nav-item:hover .icon,.link-no-hover:hover,.list-wrap.hot-forum-lft-con .s-imgUnit a:hover,.list-wrap.lft-con .s-imgUnit a:hover,.main-c .main-b .main-b-l .info-l i,.main-c .main-head .main-h span.sc,.mini-wnd .list li a:hover,.mycollect-info .mycollect-li .song-title .song-collection.font-blue,.mycollect-info .mycollect-li .song-title .song-float:hover,.mycollect-info .mycollect-li .song-title .song-normal:hover,.nameplate-card .nameplate-text .n-type a,.nav-item1 .nav-item1-title.expand,.new_list .vd_list li .title:hover,.notice .blink:hover,.notice-ctnr .blink:hover,.player-limit-wrap .limit_not_start_wrap .not_start_info span,.privilege-tabs .privilege-item-active,.privilege-tabs .privilege-item:hover,.q-c-div dl.active dt,.q-title a.active,.qa-index .help-content .help-title,.qa-index .help-list .collapse-item.collapse-item-active .collapse-title,.qa-index .help-list .collapse-item.collapse-item-title,.s-statusUnit-text .info a:hover,.s_tag .btn-view-tag a:hover,.save-btn.active,.section-item .diff-wrp .diff-text,.security-right .vip-help a:hover,.song-li .song-right .song-right-title a:hover,.sr-record a.on,.sr-record a:hover,.stat-card .num .text,.stm-ly .stm-lst .name a:hover,.stm-ly .stm-lst a,.stm-ly .stm-lst a:hover,.tab-selector-wrap .tab-wrap .tab span.active,.tab-selector-wrap .tab-wrap .tab span:hover,.tab-selector-wrap .tag-wrap .tag span.selected,.tabs-tab-active,.text-blue,.time-picker-v2-container .time-picker-body-wrp .time-picker-panel-select-wrp .time-picker-panel-select-item.time-selected,.total-bt .t-date a:hover,.tv-m2 .tv-m-tt:hover,.tv-m3 .tv-m-tt:hover,.video-info-m .tm-info a:hover,.video-toolbar-module .app-download .qr-code-box .box .txt a,.video-toolbar-module .elec-btn,.voucher-right-ing,.water-mark-set-v2-copy-switch-wrp a:hover,li.log-item .user-action .up-mark{color:var(--theme-color)!important}#dyn_wnd .dyn_menu .line:before,.data-card .data-box .tab .fan-tab.current:after,.data-card .fans-box .tab .fan-tab.current:after,.section-item .diff-wrp .diff-text:before,.tabs-tab-active:before{border-left-color:transparent!important;border-right-color:transparent!important}#app-container .main .share-step,#app-container .main .share-success,#app-ctnr .content,#app-ctnr .content #comment,#area-list ul li:after,#disable-popup-modal .btn,#disable-popup-modal .btn-transparent,#disable-popup-modal .btn-white,#disable-popup-modal .vip-exchange .months #showMonths,#disable-popup-modal .vip-exchange .months button,#disable-popup-modal .vip-exchange .selector li.current,#disable-popup-modal .vip-exchange a.btn.disabled,#page-channel-detail .channel-add-video,#page-channel-detail .channel-detail .channel-action-row .be-dropdown,#page-channel-detail .channel-option .modify-channel,#ssr-app.wrap,#vip-exchange-modal .btn,#vip-exchange-modal .btn-transparent,#vip-exchange-modal .btn-white,#vip-exchange-modal .vip-exchange .months #showMonths,#vip-exchange-modal .vip-exchange .months button,#vip-exchange-modal .vip-exchange .selector li.current,#vip-exchange-modal .vip-exchange a.btn.disabled,.area-selector-ctnr.data-area-selector .area-selector,.backdrop .extension-wrapper #app,.ban-app .case-tip .click-btn,.ban-vote .vote-dialog .dialog-footer .white-btn,.bangumi-pagelistbox .custom-right .custom-right-inner.custompage,.bangumi-pagelistbox .p,.bili-pay-payment-wrapper-gift,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item[data-state-play=true],.bilibili-player-feedback,.bnj-main>.content,.bp-vote-container.vote-box .create-vote,.btn-my-operate,.calendar-table td.disabled,.chat-input-ctnr.p-relative .block-panel,.coin-dialog-mask .coin-operated,.common-dialig-left-btn,.confirm-window .mask .confirm-board,.container .content .comment-area,.container .play-coin-bg .play-coin,.container .qr-code-bg .qr-code-box,.d-state-highlight,.date-picker-input,.datepicker.range_start.hasDatepicker .datepicker-popup,.edit-media-list .edit-mask .default-edit,.edit-media-list .edit-mask .edit-board,.editor.active,.editor:focus,.editor:hover,.emoji-box .static-popup,.ep-list-wrapper .ep-item.cursor,.ep-list-wrapper .ep-item:hover,.favInfo-box .favInfo-details .fav-options .fav-play,.group-helper-msg-list,.history-dlg .hsbtn .cancel,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tip-arrow,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.link-btn-ctnr.dp-i-block.v-middle .my-link-btn:before,.link-tag.custom,.link-tag.default,.link-tag.origin,.live-room-app .app-content .link-footer-ctnr,.lottery-box .title,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.cursor,.media-tab-module-content .mtlr-list-wrp .block-relate-wrp .pagelistbox .custom-right .custom-right-inner.custompage,.media-tab-module-content .sl-ep-list .section-item,.nav-panel-live .area-list-item:hover,.nav-panel-live .static-link:hover,.p-rel.f-clear.publish-panel .textarea,.pika-label,.pika-single.is-bound.left-aligned.bottom-aligned .pika-lendar,.player-auxiliary-playlist-item-p-item:hover,.player-his-info,.range-picker.dp-i-block .range.active,.section-ep-wrapper .ep-item.cursor,.section-ep-wrapper .ep-item:hover,.send-vip-content,.sidebar-wrapper .sidebar .feedlist-wrapper .more,.sidebar-wrapper .sidebar .feedlist-wrapper .title .number,.textarea.active,.textarea:focus,.textarea:hover,.video-list .vl-hd .float_window{background-color:#222!important}.area-panel,.main-container .review-module .review-list .review-item .review-body,.pika-button:hover,.rank-list-ctnr .tab-content{background-color:#333!important}#app .main .content-wrp,#app-ctnr .content .nav-wrapper,#area-list ul li,#disable-popup-modal .modal,#vip-exchange-modal .modal,.bb-comment .no-login .baffle,.bb-comment .no-login .comment-emoji,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-contact-information-input,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit.disable,.bnj-reserve-progress .contact,.bp-input .content-box.textarea-box .textarea,.calendar-month>a:hover,.calendar-table td.inrange,.calendar-table td:hover,.calendar-year>a:hover,.category-divider,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn,.common-dialog-content,.confirm-window .mask .confirm-board .btn-wrap .btn.cancel,.container .play-coin-bg .play-coin .play-coin-btn,.container .right-container .media-upper .media-upper-follow .media-upper-followed,.core-player,.core-player-video-panel,.create-vote .button-bar .bp-button,.d-outer,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap-child,.datepicker.range_start.hasDatepicker .input,.dialog-contnent,.dlg-contain .history-dlg,.draw-popup-warp .rules,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.cancel,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .name-input,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .name-input,.ep-section-module,.feed-topic .publish-panel-container,.feedback-content,.gather-wrap .cardhead .type,.gather-wrap .videos .item,.gift-items.col-2 .gift-item .gift-img,.group-helper-msg-list:after,.history-wrap .warn .btn,.list-info .list-li.even,.list-info .list-li.odd,.main-container .entry-old .btn-old,.main-container .ep-list-wrapper,.main-container .media-info .media-cover,.main-container .media-info .media-right .media-tool-bar .btn-rating,.main-container .nav-tools .tool-item,.main-container .pay-bar .sponsor .btn-pay,.main-container .pre-mask,.main-container .recom-wrapper .expand-more,.main-container .season-list .ss-list-wrapper .expand-more,.main-container .season-list .ss-list-wrapper .ss-item .ss-cover,.main-container .tool-bar .mobile-info .mobile-more,.main-container .tool-bar .share-info .share-more,.main-content .group .bp-input .content-box,.main-content .group .title .slot-right .bp-selector,.main-content .list .all-list .pic-item,.main-content .list .all-list .vc-item,.narrowscreen .ov-box,.notification,.page-list-box .page-input,.page-list-box .page-item,.pgc-list .synthetical .headline .pgc-label,.pika-table thead,.pk-result .mvp-info,.pk-result .winner-info,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window,.play-list .leftside-content .upper-info .followed-btn,.play-list .rightside-content .batch-operation .batch-btn,.play-list .rightside-content .batch-operation .delete-btn,.play-list .rightside-content .source-list .source-item .collect,.player-his-nav-wrp,.player-his-round div,.player-module .player-tool-bar,.player-module .stardust-player.mini-player .drag-bar i,.player-module .stardust-player.mini-player .drag-bar span,.rank-detail .my-info,.rank-detail .top50,.rank-detail .top50 li:nth-child(2n),.rank-main .rank-box .child-nav,.recommend-box .section-title .action-tab,.share-content.plain .music-card,.short-review-masker .short-review-content,.side-box .side-title.f-clear .action-tab,.sidebar-wrapper .sidebar .feedlist-wrapper,.sidebar-wrapper .sidebar .profile-wrapper .info-wrapper,.slot-ctnr.p-relative .nav-panel-live,.sponsor-rank-item.pos-rank-module .sp-right .sp-msg,.sub-nav-m .tips,.teach-last-list,.top3 li div.content-detail,.uns_box li.u-i.b-post .s-menu,.up-info .btn-panel .following,.up-info .btn-panel .following-charge-btn,.user-card-m .loading .mc1,.user-card-m .loading .mc3,.user-card-m .loading .mc4,.video-list .vl-hd .float_window .selet-datebox .sse a:hover,.video-list .vl-hd .vl-hd-sub .selector-block .date-select,.winner-list .list-wrap,.z-top-container.has-stardust,input[type=radio]:checked+.custom-radio{background-color:#444!important}.pgc-space-follow-item .pgc-item-info .pgc-item-state i,.pgc-space-follow-item .pgc-item-info .type-and-area i{background-color:#aaa!important}#gift-control-vm,#head-info-vm,#rank-list-ctnr-box{background-image:none!important}#app-ctnr .article-content .content,#app-ctnr .content .container,.all-hot-list-warp .pager .pages .page-item button,.all-hot-list-warp .pager .pages .page-item button:hover,.all-hot-list-warp .pager .pages .page-item.active button,.area-category-item.dp-i-block.p-relative.t-center.pointer .category-divider,.bangumi-pagelistbox.clearfix .custom-right .result,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item:hover .bilibili-player-playlist-part-list:before,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-part-list:before,.body-contain .user-wrap .dropdown-wrap .select-wrap .bili-dropdown,.change-container .video-list,.chat-history-panel,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=guard-level-]:before,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:after,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:before,.collection-m .content .group-list .add-group .input-group input,.collection-m .content .group-list ul .collection-mask,.info-wrap .bk-text-con p span,.list-row:hover,.list-row:nth-child(odd),.live-item .live-item-link .live-img-box,.live-room-app .app-content .app-body .player-and-aside-area .aside-area .chat-control-panel,.main-content .group .bp-input .indicator,.original-card-content .media-list .content,.original-card-content .media-list .content .cover-box-cliper .cover-box,.page-item.disabled .pager .pages .page-item .next,.page-item.disabled .pager .pages .page-item .next.disabled:hover,.page-item.disabled .pager .pages .page-item button,.pager .pages .page-item .next.disabled,.pk-container.p-absolute.normal-pk .player-area.p-absolute.init-player.normal-pk .player-area.init-player.normal-pk .pk-result,.pk-container.p-absolute.normal-pk .player-area.p-absolute.match-player.normal-pk .player-area.match-player.normal-pk .pk-result,.ps .ps__rail-x.ps--clicking,.ps .ps__rail-x:focus,.ps .ps__rail-x:hover,.ps .ps__rail-y.ps--clicking,.ps .ps__rail-y:focus,.ps .ps__rail-y:hover,.rank-main .rank-box .child-nav .nav-remind,.report-wrap-module.ban-modal.pub-list.init-end .info dl dt p span,.row .col-4-med.col-4 .pager .pages .page-item button,.row .col-4-med.col-4 .pager .pages .page-item button:hover,.row .col-4-med.col-4 .pager .pages .page-item.active button,.section-block .publish-panel .emoji-box,.share-content.plain .music-card .media-list.share-media-list .content,.sidebar-wrapper .sidebar .profile-wrapper .img-wrapper,.tab-list .tab-item.active:before,.upper-right-ctnr.p-absolute.none-select .btn.primary{background-color:transparent!important}.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=guard-level-]:before,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:after,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:before,.d-state-highlight,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group .submit,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group input,.follow-dialog-wrap .follow-dialog-window .content .group-list ul .follow-group-mask,.static-popup.bp-arrow:before{background:0 0!important}.bnj-progress-inner-operation .operation .programme .show-programme .content,.bnj-reserve .content h5,.operation .inner .bnj-button .content{color:#222!important}#article-list-index .article-list-title,#disable-popup-modal .vip-exchange .selector li p.cost,#disable-popup-modal .vip-exchange a.help,#disable-popup-modal .vip-exchange p#errorTips,#disable-popup-modal .vip-exchange p.tips,#disable-popup-modal .vip-exchange p.totail,#disable-popup-modal .vip-exchange p.totail label,#pin-wrapper .pin-layer-header-counter,#vip-exchange-modal .vip-exchange .selector li p.cost,#vip-exchange-modal .vip-exchange a.help,#vip-exchange-modal .vip-exchange p#errorTips,#vip-exchange-modal .vip-exchange p.tips,#vip-exchange-modal .vip-exchange p.totail,#vip-exchange-modal .vip-exchange p.totail label,.area-text.dp-i-block.v-middle .area-link,.area-text.dp-i-block.v-middle .child-area,.article-content-ctnr .article-footer,.article-wrap .article .so-icon a,.ban-app .case-tip .tips,.bb-comment .comment-list .list-item .con .vote-container .text-area .text-desc,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-danmaku-number,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-info .bilibili-player-watching,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-info-other,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-header,.calendar-table td.disabled,.card .focus-btn .focus .focus-text,.chat-input-ctnr.p-relative .block-panel,.coin-dialog-mask .coin-operated .coin-bottom .tips,.col-9-med.col-7 .list-padding,.common-dialig-sub-title,.common-popup-wrap.arrow-top.drop-bubble-ctnr .score-introduction,.container .play-coin-bg .play-coin .play-coin-exp,.container .right-container .media-info .media-content .media-playnum,.container .right-container .media-upper .media-upper-info .media-upper-time,.content-list.clearfix .v .i span,.core-player-info,.count-wrapper div.up-info a,.draw-popup-warp .rules .tips,.edit-media-list .edit-mask .default-edit .default-edit-info .media-list-type,.edit-media-list .edit-mask .edit-board .edit-info .media-list-type,.face-buy-item,.face-buy-price,.favInfo-box .favInfo-details .fav-options .meta,.feedback-dialog-content p,.gift-component-effect-rule,.gift-items.col-3 .gift-item,.is-disabled .pika-button,.item-footer .button-line .button-wrapper a,.list-info .list-li .song-title .song-collection,.list-info .list-li .song-title .song-float,.list-padding .list-intro,.list-padding .list-publish,.lottery-notice-cntr .ignore-notice,.lottery-notice-cntr .thx,.lottery-notice-cntr .win,.lottery-notice-cntr .win .gift-name,.main-container .ep-list-wrapper .list-title .ep-list-progress,.main-container .media-info .media-right .media-count,.main-container .media-info .media-right .media-rating p,.main-container .media-info .media-right .pub-wrapper,.main-container .recom-wrapper .recom-list .recom-item .info-wrapper .video-count,.main-container .recom-wrapper .recom-list .recom-item .info-wrapper .video-uper,.main-container .review-module .review-list .review-item .pub-time,.main-container .season-list .ss-list-wrapper .ss-item .ss-info .pub-info,.main-container .sponsor-module .sponsor-info .sponsor-count,.main-container .tool-bar .coin-info i,.main-container .tool-bar .coin-info span,.main-container .tool-bar .like-info i,.main-container .tool-bar .like-info span,.main-container .tool-bar .mobile-info i,.main-container .tool-bar .mobile-info span,.main-container .tool-bar .share-info i,.main-container .tool-bar .share-info span,.main-content .group .bp-input .indicator,.main-content-page .coin-no-log,.main-content-page .record-login-descript.record-group.clearfix p,.media-list .content .text-box .count-box,.media-list .content .text-box .description,.narrowscreen .ov-box .v-data span,.narrowscreen .ov-box .v-info,.narrowscreen .ov-box .v-preview .txt,.notification .notification-group .notification-content,.page-container.p-rel .tab-nav .tab .tab-text,.page-list-box .jump-input,.page-list-box .pageInfo,.pgc-space-follow-item .pgc-item-info .pgc-item-desc,.pgc-space-follow-item .pgc-item-info .pgc-item-state,.pgc-space-follow-item .pgc-item-info .type-and-area,.pic-item .content-wrapper .main-content .datetime,.play-list .leftside-content .list-info,.play-list .leftside-content .oprate-panel .oprate-item,.play-list .leftside-content .oprate-panel .oprate-item .iconfont,.play-list .rightside-content .source-list .source-item .more-oprate,.player-auxiliary-playlist-count,.player-his-follow,.player-his-follow a,.player-his-notice-content,.player-his-notice-content b,.player-his-tip .player-his-tip-des,.popup-content-ctnr .content .content-text,.profile-wrapper .info-wrapper .relationship,.profile-wrapper .info-wrapper .relationship .followings:after,.progress-outer-ctnr .lv-text,.progress-outer-ctnr .next-text,.rhythm-master-gift-panel .rhythm-danmaku .danmaku-item,.room-info-upper-row.p-relative .upper-right-ctnr.p-absolute.none-select .btn.primary,.row .list-theme span,.share-content.plain .music-card .up-info .tip,.share-step .btn-field .count,.short-review-masker .short-review-content .dialog-close,.side-box .list .item .info a,.t-center.glory-item.dp-i-block.v-middle .glory-activity-name,.t-center.glory-item.dp-i-block.v-middle .glory-create-time,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item,.textarea-container .comm-tool .comm-emoji,.uns_box li.u-i.b-post .s-menu li a,.user-list .up-item .up-info>span,.vc-item .item-top .detail .time,.video-info .video-data .a-crumbs a,.winner-list .gift-name,.wrap .state-null>.txt,.wrapper .fav-guide .sub-title,.you-not-win .tips{color:#aaa!important}#app .main .side-bar li a,#app-container .main .share-step .title,#area-list ul li dl,#article-list-index .title-holder .title,#disable-popup-modal,#disable-popup-modal .btn,#disable-popup-modal .btn-transparent,#disable-popup-modal .btn-white,#disable-popup-modal .vip-exchange .months #showMonths,#disable-popup-modal .vip-exchange .months button,#disable-popup-modal .vip-exchange .months button.disabled,#disable-popup-modal .vip-exchange a.btn.disabled,#disable-popup-modal .vip-exchange p.balance a,#disable-popup-modal .vip-exchange p.totail strong,#page-channel-detail .channel-option .modify-channel,#page-fav .fav-sidenav .favlist-title,#page-fav .fav-sidenav .num,#page-fav .fav-sidenav .watch-later,#pin-wrapper .pin-layer-header-counter .count,#vip-exchange-modal,#vip-exchange-modal .btn,#vip-exchange-modal .btn-transparent,#vip-exchange-modal .btn-white,#vip-exchange-modal .vip-exchange .months #showMonths,#vip-exchange-modal .vip-exchange .months button,#vip-exchange-modal .vip-exchange .months button.disabled,#vip-exchange-modal .vip-exchange a.btn.disabled,#vip-exchange-modal .vip-exchange p.balance a,#vip-exchange-modal .vip-exchange p.totail strong,.area-category-selector .area-category-item,.area-selector-ctnr.data-area-selector .area-selector,.ban-app .case-tip .click-btn,.ban-vote .vote-dialog .dialog-footer .blue-btn,.ban-vote .vote-dialog .dialog-footer .white-btn,.ban-vote .vote-dialog .dialog-main p,.bangumi-pagelistbox .custom-right .custom-right-inner,.bangumi-pagelistbox .p,.bangumi-pagelistbox .p.active,.bangumi-pagelistbox .p:hover,.bb-comment .comment-list .list-item .con .vote-container .text-area .text-content,.bb-comment .no-login .baffle,.bili-pay-header-wrapper .bili-pay-gift-info,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-title,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-contact-information-input,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-hint,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit.disable,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-tabmenu,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-version-wrap a,.bilibili-player-feedback-title,.bilibili-player-pgcinfo-follow .bilibili-player-pgcinfo-follow-binge-watching,.bp-vote-container.vote-box .create-vote .main-content .group .title .title-content,.btn-my-operate,.btn-no-my-operate,.button-box .item>button,.calendar-content .calendar-table .today,.calendar-month>a.current,.calendar-table td.current,.calendar-year>a.current,.cases-wrap.clearfix .column.col2 a,.change-song .container .iconfont,.chat-history-panel .chat-history-list .chat-item.misc-msg.guard-buy .count,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn,.coin-dialog-mask .coin-operated .coin-title,.collection-bg .collection-m .content .group-list .add-group .input-group input,.collection-m .content .group-list .add-group .fav-add-tip,.collection-m .content .group-list .add-group .input-group .submit,.common-dialig-left-btn,.common-dialig-right-btn,.common-dialig-title,.confirm-window .mask .confirm-board .btn-wrap .btn.cancel,.confirm-window .mask .confirm-board .btn-wrap .btn.confrim,.confirm-window .mask .confirm-board .head,.container .play-coin-bg .play-coin .play-coin-btn,.container .play-coin-bg .play-coin .play-coin-title,.container .qr-code-bg .qr-code-box .box .qr-info,.container .qr-code-bg .qr-code-box .qr-code-title,.container .right-container .media-upper .media-upper-follow .media-upper-followed,.container .right-container .media-upper .media-upper-follow .media-upper-not-follow,.content-list.clearfix .v .t,.create-vote .button-bar .bp-button,.danmaku-report-panel,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap-child .player-auxiliary-panel-title,.data-overview,.date-picker-input,.datepicker.range_start.hasDatepicker .input,.draw-popup-warp .rules .title,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.cancel,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.confirm,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .name-input,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .title,.edit-media-list .edit-mask .default-edit .head,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .name-input,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .title,.edit-media-list .edit-mask .edit-board .head,.el-radio,.elecrank-wrapper .elecrank-content .rank-item .item-name,.ep-list-wrapper .ep-item,.favInfo-box .favInfo-details .fav-name,.favInfo-box .favInfo-details .fav-options .fav-play,.feedback-dialog-content .ip-info,.feedback-dialog-content .ip-local,.feedback-dialog-content .time-info,.feedback-dialog-title,.feedback-dialog-txt,.feedlist-wrapper .list-content .list-item .right .username,.float_content .selet-datebox .inpt .datepicker,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group .submit,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group input,.friend-name,.gather-wrap .cardhead .type,.gather-wrap .videos .item,.gather-wrap .videos .item a,.gather-wrap .videos .item a:hover,.gather-wrap .videos .item:hover,.gift-item.active,.gift-items.col-2 .gift-item,.group-helper-msg-list .tab-list,.group-item .name-box .name,.has-event .pika-button,.history-dlg .dlg-txt,.history-dlg .hsbtn .cancel .history-dlg .hsbtn .cancel:hover,.history-dlg .hsbtn .sure,.history-wrap .warn .btn,.is-selected .pika-button,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.judgement .ban-app,.list-gap .list-title,.list-info .list-li .song-sort,.list-info .list-li .song-title .song-normal,.list-info .list-li .song-uname,.list-padding .list-founder,.list-row .list-unit,.list.dp-i-block.v-top .item .title,.lottery-box .title,.main-container .entry-old .btn-old,.main-container .entry-old .btn-old:hover,.main-container .entry-old .feedback .btn,.main-container .ep-list-wrapper .list-title h4,.main-container .media-info .media-right .media-desc,.main-container .media-info .media-right .media-title,.main-container .media-info .media-right .media-tool-bar .btn-follow.active,.main-container .media-info .media-right .media-tool-bar .btn-rating,.main-container .media-info .media-right .media-tool-bar .btn-rating .star-wrapper li i,.main-container .media-info .media-right .pub-wrapper .av-link,.main-container .media-info .media-right .pub-wrapper .home-link,.main-container .nav-tools .tool-item:hover,.main-container .pay-bar .vip .btn-pay.active,.main-container .plp-l .media-wrapper h1,.main-container .recom-wrapper .expand-more,.main-container .recom-wrapper .recom-title,.main-container .review-module .module-title,.main-container .review-module .review-list .review-item .review-content,.main-container .review-module .review-list .review-item .review-header .review-author,.main-container .review-module .review-list .review-item .review-title,.main-container .season-list .series-title,.main-container .season-list .ss-list-wrapper .expand-more,.main-container .season-list .ss-list-wrapper .ss-item .ss-info .ss-title,.main-container .sponsor-module .sponsor-info .btn-show-rank,.main-container .sponsor-module .sponsor-info .btn-sponsor,.main-container .sponsor-module .sponsor-info .sponsor-count span,.main-container .tool-bar .mobile-info .mobile-more p,.main-container .tool-bar .share-info .share-more .share-wrapper .share-btn span,.main-container.clearfix .plp-r .ep-section-module .section-title,.main-content .group .bp-input .input,.main-content .group .title .slot-right .bp-selector .selector,.media-list .content .text-box .title,.media-tab-module-wrp .media-tab-module-content .sl-ep-nav-title,.mng-type-item,.narrowscreen .ov-box .title,.notification .notification-group .notification-title,.notification-content a,.p-rel.f-clear.publish-panel .textarea,.page-list-box .page-input,.page-list-box .page-item a,.pgc-list .synthetical .headline .pgc-label,.pgc-space-follow-item .pgc-item-info .pgc-item-title,.pic-item .content-wrapper .main-content .article,.pika-button,.pika-button:hover,.pika-label,.play-list .leftside-content .list-title,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window .window-item,.play-list .leftside-content .play-btn,.play-list .leftside-content .upper-info .followed-btn,.play-list .leftside-content .upper-info .upper-name,.play-list .rightside-content .batch-operation .batch-btn,.play-list .rightside-content .batch-operation .cancel-batch,.play-list .rightside-content .batch-operation .clear-btn:hover,.play-list .rightside-content .batch-operation .delete-btn,.play-list .rightside-content .batch-operation .delete-btn.delete-check,.play-list .rightside-content .batch-operation .manage-btn,.play-list .rightside-content .batch-operation .manage-btn:hover,.play-list .rightside-content .source-list .source-item .collect .collect-item,.play-list .rightside-content .source-list .source-item .source-index,.play-list .rightside-content .source-list .source-item .source-info .source-name,.player-auxiliary-playlist-item-p-item,.player-auxiliary-playlist-item-title,.player-his-info .player-his-title,.player-his-main .player-his-title,.player-his-notice .player-his-title,.player-his-notice-content a,.player-his-tip .player-his-tip-title,.range-picker.dp-i-block .range,.range-picker.dp-i-block .range.active,.rank-main .rank-box .child-nav li,.rank-main .rank-box .child-nav li.active,.recommend-box .section-title .action-tab,.recommend-box .section-title .action-tab a,.recommend-box .section-title .category-name,.review-edit-header .review-edit-media-info .rate-tip,.review-edit-header .review-edit-media-info h4,.row .list-theme,.s-space .wrapper .col-full .sub-tabs span,.section-ep-wrapper .ep-item,.section-ep-wrapper .ep-item .badge,.section-item .section-text .section-index,.send-tabs-item,.share-board .list-playbtn,.share-content.plain .music-card .up-info .name,.share-step .btn-field .share-btn,.side-box .side-title.f-clear .action-tab,.sidebar-wrapper .sidebar .feedlist-wrapper .more,.sidebar-wrapper .sidebar .feedlist-wrapper .title,.sidebar-wrapper .sidebar .feedlist-wrapper .title .number,.song-title .container a,.sponsor-rank-item.pos-rank-module .sp-right .sp-msg,.sub-nav-m .tips,.t-center.glory-item.dp-i-block.v-middle .glory-name,.table-normal.table-styleW .feedbtn,.textarea-container .comm-tool .comm-emoji:hover .comm-text,.title .slot-right .bp-radio,.up-info .btn-panel .following-charge-btn,.up-info>a .up-name,.vc-item .item-top .detail p a.description,.video-list .tab-wrap .tab-item,.video-list .vl-hd .float_window .selet-datebox .sse a,.video-list .vl-hd .float_window .selet-datebox .sse a.on,.video-list .vl-hd .vl-hd-sub .selector-block .date-select,.vippendant-title,.winner-list,.wrapper .fav-guide .main-title,.you-not-win .title,.you-win .gift-name,li.log-item .txt-block,li.normal-item .uname,th.list-head-text{color:#eee!important}#app .main .content-wrp,#app-container .main .share-step,#app-container .main .share-success,#app-ctnr .content .nav-wrapper,#disable-popup-modal .btn,#disable-popup-modal .btn-transparent,#disable-popup-modal .btn-transparent:hover,#disable-popup-modal .btn-white,#disable-popup-modal .btn-white:hover,#disable-popup-modal .btn:hover,#disable-popup-modal .vip-exchange .months,#disable-popup-modal .vip-exchange .title,#disable-popup-modal .vip-exchange a.btn.disabled,#disable-popup-modal .vip-exchange p.totail,#edit-page .original-editor-wrap,#page-channel-detail .channel-detail .channel-action-row .be-dropdown,#page-fav .fav-main .favList-info,#page-fav .fav-sidenav .watch-later,#vip-exchange-modal .btn,#vip-exchange-modal .btn-transparent,#vip-exchange-modal .btn-transparent:hover,#vip-exchange-modal .btn-white,#vip-exchange-modal .btn-white:hover,#vip-exchange-modal .btn:hover,#vip-exchange-modal .vip-exchange .months,#vip-exchange-modal .vip-exchange .title,#vip-exchange-modal .vip-exchange a.btn.disabled,#vip-exchange-modal .vip-exchange p.totail,.area-category-selector,.area-panel,.area-selector-ctnr.data-area-selector .area-selector,.ban-vote .vote-dialog .dialog-footer .white-btn,.bangumi-pagelistbox .custom-right .custom-right-inner.custompage,.bangumi-pagelistbox .p,.bangumi-pagelistbox .p.active,.bangumi-pagelistbox .p:hover,.bili-pay-payment-wrapper-gift,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-header,.bilibili-player-feedback,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-contact-information-input,.bilibili-player-feedback-title,.bp-upload:before,.bp-vote-container.vote-box .create-vote,.btn-my-operate,.button-bar:before,.change-content .feed-wrap .feed-tag .card,.chat-input-ctnr.p-relative .chat-input,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn:hover,.common-dialig-left-btn,.confirm-window .mask .confirm-board .btn-wrap .btn.cancel,.confirm-window .mask .confirm-board .head,.container .right-container .media-upper .media-upper-follow .media-upper-followed,.date-picker-input,.datepicker.range_start.hasDatepicker .datepicker-popup,.datepicker.range_start.hasDatepicker .input,.dlg-contain .history-dlg,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.cancel,.edit-media-list .edit-mask .default-edit .default-edit-info .info-wrap .name-input,.edit-media-list .edit-mask .default-edit .head,.edit-media-list .edit-mask .edit-board .edit-info .info-wrap .name-input,.edit-media-list .edit-mask .edit-board .head,.emoji-box .static-popup,.feed-topic .hot-content .card.card-offset,.feed-topic .separater-line,.feedback-dialog-title,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group .submit,.gather-wrap .cardhead .type,.gather-wrap .videos .item,.gather-wrap .videos .item:hover,.history-dlg .hsbtn .cancel,.history-dlg .hsbtn .cancel:hover,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tip-arrow,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.link-tag.custom,.link-tag.default,.link-tag.origin,.lottery-box,.main-container .entry-old .btn-old,.main-container .entry-old .btn-old:hover,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item,.main-container .media-info .media-right .media-tool-bar .btn-rating,.main-container .nav-tools .tool-item,.main-container .nav-tools .tool-item:hover,.main-container .pay-bar .vip .btn-pay.active,.main-container .tool-bar .mobile-info .mobile-more,.main-container .tool-bar .share-info .share-more,.main-content .list .all-list .pic-item,.main-content .list .all-list .pic-item .footer-wrapper,.main-content .list .all-list .vc-item,.main-content .list .all-list .vc-item .footer-wrapper,.media-tab-module-content .sl-ep-list .section-item,.narrowscreen .ov-box,.original-card-content .media-list .content,.p-rel.f-clear.publish-panel .textarea,.page-list-box .active,.page-list-box .page-input,.page-list-box .page-item,.page-list-box .page-item:hover,.pgc-list .synthetical .headline .pgc-label,.pika-table thead,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window .window-item,.play-list .rightside-content .batch-operation .batch-btn,.play-list .rightside-content .batch-operation .clear-btn:hover,.play-list .rightside-content .batch-operation .delete-btn.delete-check,.play-list .rightside-content .source-list .source-item .collect,.play-list .rightside-content .source-list .source-item .collect .collect-item:first-child,.player .bilibili-player-video-bottom-area .bilibili-player-video-sendbar,.player-auxiliary-area .player-auxiliary-panel-title,.popup-content-ctnr .content .report-input,.recommend-box .section-title .action-tab,.room-introduction .edit-button,.row .list-comment,.row .list-info,.send-tabs,.send-tabs-item,.send-wrapper,.setting .follow-setting,.share-content.plain .music-card .media-list.share-media-list .content,.side-box .side-title.f-clear .action-tab,.sidebar-wrapper .sidebar .feedlist-wrapper,.sidebar-wrapper .sidebar .profile-wrapper .img-wrapper,.sidebar-wrapper .sidebar .profile-wrapper .info-wrapper,.sponsor-rank-item.pos-rank-module .sp-right .sp-msg,.sub-nav-m .tips,.up-info .btn-panel .charge-btn,.up-info .btn-panel .following,.video-list .vl-hd .float_window,.video-list .vl-hd .float_window .close,.video-list .vl-hd .float_window .close:hover{border-color:transparent!important}.ban-vote .vote-dialog .dialog-header,.core-player-auxiliary-area,.core-player-filter,.core-player-video-control,.face-buy-item,.face-buy-price,.item-footer .button-line .button-wrapper .button-item,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item,.wrap .state-null>.txt{border-color:#aaa!important}#disable-popup-modal .vip-exchange .months #showMonths,#page-channel-detail .channel-add-video,#vip-exchange-modal .vip-exchange .months #showMonths,.coin-dialog-mask .coin-operated .mc .mc-box,.container .qr-code-bg .qr-code-box .qr-code-title,.elecrank-header,.gather-wrap .gather,.jumping-ctnr .jumping-input,.left-container .play-options .play-options-ul .share-box .or-code,.main-container .media-info,.main-container .plp-l .comment-wrapper,.main-container .review-module,.main-container .sponsor-module,.play-list .leftside-content .oprate-panel,.play-list .rightside-content .source-list .source-item .source-right,.player-his-tip .player-his-tip-des,.player-his-tip-date .player-his-round,.video-list .vl-hd .float_window .float_content h3{border-color:#444!important}.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=guard-level-]:before,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:after,.chat-history-panel .chat-history-list .chat-item.danmaku-item[class*=week-all-area-top-]:before{border-image:none!important}.area-list-item.dp-i-block.t-over-hidden.t-nowrap.v-top.border-box.a-move-in-left.ts-dot-2 .live-icon-16,.is-rtl .pika-next,.is-rtl .pika-prev,.link-btn-ctnr.dp-i-block.v-middle .my-link-btn .icon,.link-navbar .main-ctnr .nav-logo,.pika-next,.pika-prev,.video-list .vl-hd .float_window .close{filter:brightness(0) invert(1)!important}#app .header .close:hover,#disable-popup-modal .modal-close,#vip-exchange-modal .modal-close,.aside-area-toggle-btn .btn-ctnr .restore-btn,.bb-comment .comment-list .list-item .text .vote-link img,.bp-input .option-delete,.channel-item.channel-add-video .add-covers-meta #browser-version-tip #close-browser-tip,.channel-item.channel-add-video .add-covers-meta .icon,.collection-m .content .group-list .add-group .fav-add-tip .blue-arrow,.edit-media-list .edit-mask .default-edit .default-edit-info .media-list-type .icon-check,.edit-media-list .edit-mask .edit-board .edit-info .media-list-type .icon-check,.face-buy-close,.face-buy-item.active,.helper-btn.active:before,.home-wrap .home-suggest .title .delete-history .icon-garbage,.icon-vote-create-btn.active,.main-content .group .bp-add-button .add-icon,.pin-layer-body .pin-layer-search #browser-version-tip #close-browser-tip,.pin-layer-body .pin-layer-search .icon,.pin-layer-header #browser-version-tip #close-browser-tip,.pin-layer-header .icon,.popup-content-ctnr .content .selector-box .type-selector .radio-selected,.slidesjs-pagination li a.active,.slidesjs-pagination li a:hover,.v-filter-line.clearfix .item.style .icon{filter:var(--blue-image-filter)!important}.z-top-container .b-icon{filter:var(--pink-image-filter)!important}#app-container .main .share-step,#app-container .main .share-success,.main-container .entry-old .feedback .btn,.section-block .publish-panel .emoji-box,.video-list .vl-hd .float_window .close:hover{box-shadow:none!important}.bp-vote-container.vote-box .create-vote,.button-box .item .group-helper-msg-list,.container .left-container .play-options .play-options-more .play-options-content .play-option:hover,.datepicker.range_start.hasDatepicker .datepicker-popup,.emoji-box .static-popup,.item-footer .button-line .button-wrapper .button-item.support .tooltip-wrapper .tooltip,.left-container .play-options .play-options-ul .share-box,.narrowscreen .ov-box,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window,.play-list .rightside-content .source-list .source-item .collect,.sub-nav-m .tips,.video-list .vl-hd .float_window{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.textarea{transition:.2s}#disable-popup-modal .vip-exchange .selector li:first-child,#page-channel-detail .channel-add-video:hover,#vip-exchange-modal .vip-exchange .selector li:first-child,.area-group-item.checked,.bangumi-pagelistbox .custom-right .custom-right-inner.custompage:hover,.coin-dialog-mask .coin-operated .mc .mc-box.on,.coin-dialog-mask .coin-operated .mc .mc-box:hover,.collection-m .content .group-list .add-group .input-group,.comment-bilibili-con .con input[type=radio]:checked+label:before,.container .live,.container .play-coin-bg .play-coin .play-coin-content .play-one-coin.active,.container .play-coin-bg .play-coin .play-coin-content .play-one-coin:hover,.date-picker-input.active,.editor.active,.editor:focus,.editor:hover,.el-radio__inner:hover,.el-radio__input.is-checked .el-radio__inner,.face-buy-item.active,.face-buy-item:hover,.follow-dialog-wrap .follow-dialog-window .content .group-list .add-group .input-group,.gift-item.active .gift-img,.group-item .name-box .operate-btn,.group-item .operate-btn,.live-item .live-item-link .live-img-box .hover-panel .live-bg-merge .live-item-mark,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.cursor,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item:hover,.p-rel.f-clear.publish-panel .textarea:focus-within,.report-image-candidate-ctnr.t-center .upload-hint,.score-progress-bar.dp-i-block.v-middle.p-relative .progress-bar-core.p-absolute,.send-tabs-item-active,.stick.true-love .medal-level,.sub-area em.active,.sub-area em:hover,.sub-tabs a.active,.sub-tabs a.active:before,.tab-list .tab-item.active:before,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item:hover,.textarea.active,.textarea:focus,.textarea:hover,.video-list .tab-wrap .tab-item.active,.video-list .vl-hd .float_window .selet-datebox .sse,.video-list .vl-hd .float_window .selet-datebox .sse a,.video-list .vl-hd .vl-hd-sub .selector-block .date-select:hover,input[type=radio]:checked+.custom-radio{border-color:var(--theme-color)!important}.tab-wrap .tab-item.active:after{border-bottom-color:var(--theme-color)!important}#disable-popup-modal .btn-transparent:hover,#disable-popup-modal .btn-white:hover,#disable-popup-modal .btn:hover,#disable-popup-modal .vip-exchange .months button:hover,#page-channel-detail .channel-option .modify-channel:hover,#vip-exchange-modal .btn-transparent:hover,#vip-exchange-modal .btn-white:hover,#vip-exchange-modal .btn:hover,#vip-exchange-modal .vip-exchange .months button:hover,.aside-area-toggle-btn .btn-ctnr:hover .btn-slider,.ban-app .case-tip .click-btn:hover,.ban-vote .vote-dialog .dialog-footer .blue-btn,.ban-vote .vote-dialog .dialog-footer .blue-btn:hover,.bangumi-pagelistbox .p.active,.bangumi-pagelistbox .p:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-part-item[data-state-play=true] .bilibili-player-playlist-plist-play,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit.disable:hover,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-submit-wrap .bilibili-player-feedback-submit:hover,.btn-no-my-operate,.calendar-month>a.current,.calendar-table td.current,.calendar-year>a.current,.coin-dialog-mask .coin-operated .coin-bottom .coin-btn:hover,.collection-m .content .group-list .add-group .fav-add-tip,.comment-bilibili-con .con label:after,.common-dialig-right-btn,.confirm-window .mask .confirm-board .btn-wrap .btn.confrim,.container .play-coin-bg .play-coin .play-coin-btn:hover,.container .right-container .media-upper .media-upper-follow .media-upper-not-follow,.container .right-container .media-upper .media-upper-follow .media-upper-not-follow:hover,.danmaku-item.pointer .custom-radio:after,.edit-media-list .edit-mask .default-edit .default-edit-info .default-btn-wrap .default-btn.confirm,.edit-media-list .edit-mask .edit-board .edit-info .submit-btn,.edit-media-list .edit-mask .edit-board .edit-info .submit-btn:hover,.el-radio__input.is-checked .el-radio__inner,.favInfo-box .favInfo-details .fav-options .fav-play:hover,.gather-wrap .videos .item:hover,.has-event .pika-button,.history-dlg .hsbtn .sure,.history-dlg .hsbtn .sure:hover,.history-wrap .warn .btn:hover,.is-selected .pika-button,.live-item .live-item-link .live-img-box .hover-panel .live-bg-merge .live-item-mark .white-dot,.main-container .entry-old .btn-old:hover,.main-container .entry-old .feedback .btn,.main-container .entry-old .feedback .btn:hover,.main-container .media-info .media-right .media-tool-bar .btn-follow,.main-container .media-info .media-right .media-tool-bar .btn-follow:hover,.main-container .media-info .media-right .media-tool-bar .btn-rating:hover,.main-container .nav-tools .tool-item:hover,.main-container .pay-bar .sponsor .btn-pay:hover,.main-container .sponsor-module .sponsor-info .btn-sponsor,.page-container.p-rel .tab-nav .line,.page-list-box .active,.page-list-box .page-item:hover,.pgc-space-follow-item a.pgc-item-cover .badge.type_0,.play-list .leftside-content .play-btn,.play-list .leftside-content .play-btn:hover,.play-list .rightside-content .batch-operation .cancel-batch,.play-list .rightside-content .batch-operation .cancel-batch:hover,.play-list .rightside-content .batch-operation .clear-btn:hover,.play-list .rightside-content .batch-operation .delete-btn.delete-check,.play-list .rightside-content .batch-operation .manage-btn,.play-list .rightside-content .batch-operation .manage-btn:hover,.player-his-nav.active,.player-his-title div,.radio-icon.checked:before,.rank-main .rank-box .child-nav li.active,.share-board .list-playbtn,.share-board .list-playbtn:hover,.share-step .btn-field .clickable,.sidebar-wrapper .sidebar .feedlist-wrapper .more:hover,.tab-list .tab-item.active:after,.up-info .btn-panel .following-charge-btn:hover,.video-list .vl-hd .float_window .selet-datebox .sse a.on,ul.navigation li span:after{background-color:var(--theme-color)!important}#app .main .side-bar li a.router-link-active,#app .main .side-bar li a:hover,#area-list ul li dl:hover,#disable-popup-modal .vip-exchange .selector li.current p.cost,#disable-popup-modal .vip-exchange .selector li:hover,#disable-popup-modal .vip-exchange .selector li:hover p.cost,#disable-popup-modal .vip-exchange p.balance a:hover,#dyn_wnd .dyn_list a:hover,#page-channel-detail .channel-add-video:hover .text,#pin-wrapper .pin-layer-video-empty a,#vip-exchange-modal .vip-exchange .selector li.current p.cost,#vip-exchange-modal .vip-exchange .selector li:hover,#vip-exchange-modal .vip-exchange .selector li:hover p.cost,#vip-exchange-modal .vip-exchange p.balance a:hover,.all-hot-list-warp .pager .pages .page-item button:hover,.all-hot-list-warp .pager .pages .page-item.active button,.area-category-selector .area-category-item.active,.area-group-item.checked,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-item:hover .bilibili-player-playlist-info-title,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-loop.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-loop:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-ownername:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-positive.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-positive:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-random.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-random:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-reverse.bppl-state-selected,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-reverse:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-nav-title:hover,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-order-play,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-playlist-part-item:hover,.bilibili-player-feedback-content .bilibili-player-feedback-default-content .bilibili-player-feedback-version-wrap a:hover,.block-wrap #activity .activity-info a,.block-wrap #activity .activity-info a:hover,.bp-add-button,.btn-my-operate:hover,.button-box .item>button.active,.calendar-header>a:hover,.card .focus-btn .focus .focus-text:hover,.cases-wrap.clearfix .column.col2 a:hover,.coin-dialog-mask .coin-operated .coin-title span,.coin-dialog-mask .coin-operated .mc .mc-box .c-num,.container .left-container .play-options .play-options-ul li .blue,.container .live,.container .play-coin-bg .play-coin .play-coin-content .play-one-coin.active,.container .play-coin-bg .play-coin .play-coin-title .play-coin-number,.content-list.clearfix .v:hover .t,.count-wrapper div.up-info a:hover,.creation-li .creation-right .creation-theme .creation-link:hover,.danmaku-report-panel .danmaku-content,.detail-content p span a,.edit-media-list .edit-mask .default-edit .default-edit-info .media-list-type .blue-icon,.edit-media-list .edit-mask .edit-board .edit-info .media-list-type .blue-icon,.ep-list-wrapper .ep-item i,.ep-list-wrapper .ep-item.cursor,.face-buy-item.active,.face-buy-item:hover,.face-buy-price a,.favInfo-box .favInfo-details .fav-name:hover,.favInfo-box .favInfo-details .fav-options .meta.selected,.feedlist-wrapper .list-content .list-item:hover .right .username,.group-item .name-box .operate-btn,.group-item .operate-btn,.item-footer .button-line .button-wrapper:hover .button-item .label,.item-footer .button-line .button-wrapper:hover .button-item .num,.link-navbar .nav-item:hover .icon-font,.list-info .list-li .song-title .song-collection.font-blue,.list-info .list-li .song-title .song-float:hover,.live-item .live-item-link .live-img-box .hover-panel .live-bg-merge .live-item-mark,.lottery-notice-cntr .win .uname,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.cursor,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item:hover,.main-container .media-info .media-right .media-title:hover,.main-container .media-info .media-right .pub-wrapper .av-link:hover,.main-container .media-info .media-right .pub-wrapper .home-link:hover,.main-container .review-module .review-list .review-item .review-header .review-author:hover,.main-container .review-module .review-list .review-item:hover .review-title,.main-container .season-list .ss-list-wrapper .ss-item .ss-info .ss-title:hover,.main-container .sponsor-module .sponsor-info .btn-show-rank:hover,.main-container .tool-bar .coin-info.active i,.main-container .tool-bar .coin-info.active span,.main-container .tool-bar .coin-info:hover i,.main-container .tool-bar .coin-info:hover span,.main-container .tool-bar .like-info.active i,.main-container .tool-bar .like-info.active span,.main-container .tool-bar .like-info:hover i,.main-container .tool-bar .like-info:hover span,.main-container .tool-bar .mobile-info .mobile-more p a,.main-container .tool-bar .mobile-info:hover i,.main-container .tool-bar .mobile-info:hover span,.main-container .tool-bar .share-info .share-more .share-wrapper .share-btn:hover i,.main-container .tool-bar .share-info .share-more .share-wrapper .share-btn:hover span,.main-container .tool-bar .share-info:hover>i,.main-container .tool-bar .share-info:hover>span,.mng-type-item.active,.mvp-info .user-info .title,.notification-content .address,.notification-content a:hover,.pgc-space-follow-item .pgc-item-info .pgc-item-title:hover,.pic-item .content-wrapper .main-content .article:hover,.play-list .leftside-content .list-title:hover,.play-list .leftside-content .oprate-panel .oprate-item .oprate-window .window-item:hover,.play-list .leftside-content .upper-info .upper-name:hover,.play-list .rightside-content .batch-operation .all-checked,.play-list .rightside-content .source-list .source-item .collect .collect-item:hover,.play-list .rightside-content .source-list .source-item .more-oprate:hover,.play-list .rightside-content .source-list .source-item .source-checked,.play-list .rightside-content .source-list .source-item .source-info .source-name:hover,.play-list .rightside-content .source-list .source-item .source-info .source-upper-name:hover,.player-auxiliary-area .player-auxiliary-panel-title .player-auxiliary-panel-close:hover,.player-auxiliary-playlist-item-p-item.player-auxiliary-playlist-item-p-item-active,.player-auxiliary-playlist-item-p-item:hover,.player-auxiliary-playlist-item.player-auxiliary-playlist-item-active .player-auxiliary-playlist-item-title,.player-his-nav:hover,.player-his-notice-content a:hover,.profile-wrapper .info-wrapper .relationship .followings:hover,.rank-main .rank-box .child-nav .nav-remind,.rank-main .rank-box .child-nav li:hover:not(.active),.recommend-box .section-title .action-tab a:hover,.recommend-box .section-title .action-tab a:hover .icon-font,.recommend-box .section-title .action-tab:hover,.recommend-box .section-title .action-tab:hover .icon-replace,.row .col-4-med.col-4 .pager .pages .page-item button:hover,.row .col-4-med.col-4 .pager .pages .page-item.active button,.s-space .wrapper .col-full .sub-tabs.clearfix a:hover,.section-ep-wrapper .ep-item i,.section-ep-wrapper .ep-item.cursor,.section-item:hover .section-text .section-index,.section-item:hover .section-text .section-title,.seeds-wrap .item.btn,.send-tabs-item-active,.short-review-masker .short-review-content .dialog-close:hover,.short-review-masker .short-review-content .mr-long-review,.side-box .side-title.f-clear .action-tab:hover,.side-box .side-title.f-clear .action-tab:hover .icon-replace,.sub-area em.active,.sub-area em:hover,.table-normal.table-styleW .feedbtn:hover,.tags-inner-ctnr.dp-i-block.v-top.border-box .area-tag-item:hover,.up-info .btn-follow-up,.up-info .u-info .name .message:hover,.up-info .u-info .name .message:hover i,.up-info>a .up-name:hover,.vc-item .item-top .detail p a.description:hover,.vc-item .item-top .detail p a.tag,.video-info .video-data .a-crumbs a:hover,.video-list .tab-wrap .tab-item.active,.winner-list .list-wrap .title,li.normal-item a:hover .uname{color:var(--theme-color)!important}.sub-tabs a.active:before{border-left-color:transparent!important;border-right-color:transparent!important}#bili-data-center .version-switch-section,.advice-dialog-wrapper .input-style,.advice-dialog-wrapper .submit-btn,.article-info-module,.bb-comment .no-login .baffle .b-btn,.bili-dialog-bomb .appeal-box .header,.bili-dialog-bomb .appeal-box .submit,.bili-dialog-bomb .appeal-box .wrap .container,.bp-emoji-box .static-popup,.cc-article-wrp .article-card .meta-title .typename,.cc-content-body .select-box,.cc-content-body .select-box .option-footer,.dc-page .version-switch-section,.enter-failure,.error-body .error-container .song-wrap .change-song,.face-container .pendant-list li,.face-container .pendant-list li>div,.face-container .record-table thead th,.feedback-mask .content .feedback-body .feedback-submit,.float_window,.home-pc .dialog .footer .apply-btn,.info-line .status-attend.status-attend-hover,.info-line .status-no-attend,.link-tag-box .selector-wrap ul>li:hover,.live-user .user-item .item-right .status,.m-layer.m-button,.m_layer.m-button,.main-container .media-info .media-right .media-desc i,.mask .popup-container .btn-primary,.normal-v2-container .normal-title-wrp>.template-op>.template-op-divide,.pendant-mask .pendant-box .pendant-main .price-btn,.protocol-modal .modal-wrap .modal-content .text-content,.read-list-page .read-list-name .info.right.show .col .split-line,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list,.read-list-page.edit-page .read-list-name .cover,.regist .toolbox,.result.is-web .vote-result-comment,.right-container.f-left .active-panel .show-more-button,.section-block .bp-emoji-box .static-popup,.security-right-bottom .face-tool .tool-container .tool-uninstall-pendant,.share-board .song-share .song-share-ul li:hover,.song-info .info-wrap .type-list .item-list .type-item,.song-info .info-wrap .type-list .musicHoverType,.ssr-content .link-tag.activity,.tab-selector-wrap .selector-wrap ul>li:hover,.text-article-wrp .article-card .meta-title .typename,.text-article-wrp .article-card .meta-view .appeal,.text-article-wrp .article-card .meta-view .data,.text-article-wrp .article-card .meta-view .menu,.text-article-wrp .article-card .meta-view .menu-list,.text-article-wrp .article-card .meta-view .meta-item.text-item,.text-article-wrp .article-card .meta-view .option,.ui-popup.popup-cover .bili-btn.cancel,.ui-widget-header,.video-card .labels-ctnr{background-color:#222!important}.content .link-tag-box,.content .tab-selector-wrap,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management,.home-pc .application .application-body .btn-color,.live-user .user-item .item-right .tags>span,.vl-hd-sub .selector-block .b-slt .list li:hover{background-color:#333!important}#app .el-button.is-disabled,#app .el-button.is-disabled:focus,#app .el-button.is-disabled:hover,#pgc-navigate-wrap .ep-box .ep-sub .ep-item,#pgc-navigate-wrap .play-btn,.abnormal-module .abnormal-item .btn-back,.advice-dialog-wrapper,.bangumi-list .bangumi-item .right-info .headline .bangumi-label,.bili-dialog-bomb .appeal-box .submit .cancel,.bilibili-player .bilibili-player-auxiliary-area .bilibili-player-filter .bilibili-player-filter-btn.active,.block-area .follow-wrapper .follow-head .follow-more,.cards-block .modal-wrap .btn-group button,.carousel-wrp .panel .pic li,.cc-container .nav-search .dropdown-btn,.cc-content-body .select-box .option-footer:hover,.cc-content-body .select-box .select-item:hover,.container-left .answer-container,.content .rank-list,.cropper-modal .modal,.customize-wrp .customize-tab,.detail-wrp .detail-empty,.emoji-box .emoji-tabs .tab-link:hover,.enter-failure .bl-button--primary:disabled,.enter-failure .link-input,.error-body .error-container .error-panel .audio-split,.error-body .error-container .song-wrap .image-split,.error-container .video-details p.num,.home-pc .application,.info-wrap .feedback-mask .content,.link-tag-box .selector-wrap,.link-tag-box .selector-wrap ul,.list-container .article-list-block,.list-container .list-info-block,.live-category .category,.live-user .user-item,.main-ctnr .qualify-drawer .drawer-pop,.pendant-mask .pendant-box,.pendant-mask .pendant-box .pendant-header,.pgc-list .pgc-item .right-info .headline .pgc-label,.popup-content-ctnr .report-input,.read-list-modal-component .creat-read-list-box .input-box button,.read-list-modal-component .creat-read-list-box .input-box button[disabled],.read-list-page .module-box,.read-list-page.edit-page .module-box,.report-wrap-module .code-input.el-input .el-input__inner,.report-wrap-module .form-group .el-input-group>.el-input__inner,.report-wrap-module .form-group .el-input__inner,.selet-datebox .inpt a.b-btn,.selet-datebox .inpt input[type=text],.selet-datebox .sse a:hover,.setting .public-setting .public-wrp .button-wrap .btn-text.ok.is-disable,.setting .public-setting .public-wrp .setting-item .circle-wrap,.share-board .share-btn,.share-board .song-share .song-share-ul,.share-wrap .content-wrap .input-wrap input,.song-coin-bg .song-coin,.tab-selector-wrap .selector-wrap,.tab-selector-wrap .selector-wrap ul,.tag.sky-blue,.tag.sky-blue:hover,.text-article-wrp .article-card,.text-article-wrp .head-stat,.ui-popup .popup-wrap,.ui-widget-content,.up-info .btn-panel .charge-btn,.vd-list.l3 li .l-item,.video .video-topic .video-list,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-item:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-item[data-state-play=true],.vl-hd-sub .selector-block .b-slt,.vl-hd-sub .selector-block .b-slt .list{background-color:#444!important}.follow-main .list-item:hover{background-color:#3d3d3d!important}.ssr-content .cntr .check-all-ctn{background-image:linear-gradient(rgba(242,243,245,0),#222 40%,#222)!important}.ui-state-active,.ui-state-default,.ui-state-focus,.ui-state-hover,.ui-widget-content,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-default,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-default,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover{background-image:none!important}.comment-list-item .ci-action span.date,.header-info-ctnr .normal-mode .area-link:active,.list-container .list-info-block .right-side .col .split-line,.main-ctnr .qualify-drawer .draw-list,.p-relative.rank-list-section.z-rank-list .rank-list-ctnr,.rank-list-ctnr a,.rank-list-ctnr a:hover,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list .menu-item:hover,.tab-bg.w-100.bg-white,.text-article-wrp .article-card .meta-view .menu-list .menu-item:hover,.ui-datepicker .ui-datepicker-header,.ui-state-default,.ui-widget-content .ui-state-default,.ui-widget-header .ui-state-default,.vd-list li .l-item,.view-later-module .up-info-module,.view-later-module .video-box-module,.view-later-module .video-info-module .number .fav i{background-color:transparent!important}#member-container:hover::-webkit-scrollbar,#member-container:hover::-webkit-scrollbar-track,.cc-body .home-wrap .card,.gift-rank-cntr .rank-cntr .item.own,.list-container .article-list-block .article-item,.original-editor-wrap .float-toolbar .toolbar-list,.register-container .report-wrap-module .back-fff,.text-article-wrp .head-stat .section .count,.ui-widget-header,.view-later-module .read-list-modal-component .mask,.view-later-module .video-info-module .number .coin i,.view-later-module .video-info-module .number .fav i{background:0 0!important}#dc-section_behavior .follow-tool-box .follow-line-legend .legend-item .legend-text,#dc-section_summary .source-rank-list-item .video-info-pubdate,#navigator .v-switcher-header-item a span,#page-article .article-lists .lists-item .item-right .item-info span,#page-article .article-lists .lists-item .item-right .item-title,#page-setting .setting-privacy-item .setting-privacy-switcher .be-switch-label,.abnormal-module .abnormal-item .txt,.article-card .article-info .data,.article-card .article-info .data a,.article-info-module .v-data span,.article-info-module .v-info,.article-list-holder-block .article-list-name,.article-net-charts .area .empty-tips,.bangumi-info-module .v-data span,.bangumi-info-module .v-preview .desc,.bangumi-list .bangumi-item .right-info .intros .label,.bangumi-list .bangumi-item .right-info .intros .value,.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info,.bili-dialog-bomb .appeal-box .wrap .container .img-text,.bili-dialog-bomb .appeal-box .wrap .container .textarea .textarea-wrap .limit,.block-wrap .classify .position,.cards-block .cards-list .card-item .card-case .other label,.carousel-wrp .panel .pic li a .card-info .detail,.case-list .info .comment,.case-list .info .jury-time,.cc-article-wrp .article-card .meta-footer .view-stat,.cc-article-wrp .article-card .meta-status .pubdate,.cc-container .tips,.comment-list-item .ci-action,.comment-list-item .ci-parent-reply .cipr-footer,.container .form-group .form-message,.coupon-content-con .coupon-time,.coupon-content-con .coupon-type,.data-card .data-wrp .tab .fan-tab,.data-card .data-wrp .tip p,.data-card .fans-wrp .tab .fan-tab,.data-card .fans-wrp .tip p,.detail-wrp .detail-header .article-link,.detail-wrp .detail-header .tips,.el-breadcrumb__item:last-child .el-breadcrumb__inner,.el-breadcrumb__item:last-child .el-breadcrumb__inner a,.el-breadcrumb__item:last-child .el-breadcrumb__inner a:hover,.el-breadcrumb__item:last-child .el-breadcrumb__inner:hover,.error-body .error-container .error-panel .error-clue,.error-body .error-container .msg-text,.error-body .error-container .song-wrap .song-list .song-li .content .num,.follow-item .details .ep-info,.follow-item .details .ep-intro,.game-item-container .game-package-item .game-package-gift,.game-item-container .game-package-item .game-package-price,.home-pc .application .application-body .fjw-tip,.home-pc .application .application-foot p,.home-pc .application .application-header p,.home-wrap .data-card .data-wrp .total,.home-wrap .data-card .fans-wrp .total,.list-container .list-info-block .right-side .col,.list-container .list-info-block .right-side .summary,.live-user .user-item .item-right .info .star,.live-user .user-item .item-right .info .type,.option-content-wrapper .desc .option-vote,.pendant-list li .pendant-expire,.pendant-main .final-price,.pendant-main .point-info,.pendant-main .unit-price li,.pgc-list .pgc-item .right-info .intros .label,.pgc-list .pgc-item .right-info .intros .value,.player-his-main .player-his-tip-date,.r-con .members-info .up-card .info-title,.read-list-component .empty-state .empty-tips,.read-list-modal-component .tips,.read-list-modal-component .tips.input-tips,.read-list-page .add-article-modal .article-list-box li label span.uptime,.read-list-page .add-article-modal .module-tips,.read-list-page .module-box .module-tips,.read-list-page.edit-page .read-list-name .cover .empty-state,.read-list-page.edit-page header.header .link-btn,.rule-description p,.section.album .album-item .meta-col,.section.article .article-content .meta-col,.security-right .my-package-ruls p,.share-board .share-btn .bili-share div,.share-wrap .content-wrap .qr-wrap .qr-title,.song-coin-bg .song-coin .song-coin-exp,.steps .step-operate,.text-article-wrp .article-card .meta-footer .view-stat,.text-article-wrp .article-card .meta-status .pubdate,.text-article-wrp .article-card .meta-view .meta-item .icon-font,.text-article-wrp .article-card .meta-view .meta-item .iconfont,.text-article-wrp .head-stat .section .diff-wrp .diff-text,.text-article-wrp .head-stat .section .diff-wrp .diff-yeaterday,.ui-input-text .count,.ui-popup .popup-wrap .text-box .subtext,.ui-popup .popup-wrap .text-box .text .sub-tips,.upload-cover-wrapper .upload-cover-suggest,.vd-list li .l-r .up-info .v-author,.vd-list li .l-r .up-info .v-date,.vd-list li .v-desc,.vd-list li .v-info .v-info-i,.video-card .icons-label .text,.video-card .labels-ctnr,.video-detail .item-number,.video-detail .item-time,.video-info-module .v-data span,.video-info-module .v-info,.video-info-module .v-preview .txt,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-info-other,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-header,.view-later-module .up-info-module .number,.view-later-module .video-info-module .tm-info,.view-later-module .video-info-module .tm-info .btn-appeal,.view-later-module .video-info-module .tm-info a,.view-later-module .video-info-module .tm-info time,.vote-info-wrapper .user-name .text{color:#aaa!important}#navigator .v-switcher-header-item a,#page-article .article-lists .lists-item .item-right .item-name,#page-fav .fav-main .fav-action-bottom .search-results-num,#pgc-navigate-wrap .ep-box .ep-sub .ep-item,#pgc-navigate-wrap .ep-box .ep-sub .ep-item:hover,#pgc-navigate-wrap .play-btn,#pgc-navigate-wrap .play-btn:hover,.abnormal-module .abnormal-item .btn-back,.advice-dialog-wrapper .advice-dialog-close,.advice-dialog-wrapper .advice-info,.advice-dialog-wrapper .advice-item-title,.advice-dialog-wrapper .advice-title,.advice-dialog-wrapper .input-style,.answer-container .footer-bottom .btn-default,.answer-list .exam-list .exam-number,.article-card .article-info .title,.article-data-wrp .breadcrumb .sign,.article-data-wrp .breadcrumb a,.author-container .attention-animation-holder .attention-btn,.bangumi-list .bangumi-item .right-info .headline .bangumi-label,.bangumi-list .bangumi-item .right-info .headline .title,.bb-comment .no-login .baffle .b-btn:hover,.bili-dialog-bomb .appeal-box .submit .cancel,.bili-dialog-bomb .appeal-box .submit .confirm,.bili-dialog-bomb .appeal-box .wrap .container .question,.bili-header-m .profile-m .grade .bar .num .v0,.block-area .follow-wrapper .follow-head .follow-more,.bp-emoji-box .static-popup.common-font.bp-arrow .title,.card-warpper .card-warpper-outside .card-item .info-text,.cards-block .cards-list .card-item .card-case .title,.carousel-wrp .panel .pic li a .card-info .title .headline,.cc-article-wrp .article-card .meta-title .typename,.cc-container .nav-search .dropdown-btn,.cc-container .nav-search .search,.cc-container .nav-search .search input,.cc-content-body .select-box .option-footer,.cc-content-body .select-box .select-item .text,.comment-list-item .article-wrap .name,.comment-list-item .ci-content,.container .form-group .form-group-title,.container .form-group .mail-text,.container-left .answer-container .header-top h2,.customize-wrp .steps-title,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management i,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>*,.detail-wrp .detail-empty,.enter-failure,.enter-failure .supporting-text,.error-body .error-container .error-panel .audio-split,.error-body .error-container .song-wrap .change-song,.error-body .error-container .song-wrap .iconfont,.error-body .error-container .song-wrap .image-split,.face-container .pendant-list li .pendant-btn,.face-container .pendant-nav li div,.face-container .pendant-nav li div.active,.face-container .record-table,.feedback-mask .content .feedback-body .dl-item .dt-item,.feedback-mask .content .feedback-body .feedback-submit,.feedback-mask .content .feedback-body .feedback-submit.active,.fold-box .fold-hoverable,.follow-item .details .season-title,.game-item-container .game-package-item .game-package-name,.game-package-wrapper .title-package-wrapper .title-package-name,.home-pc .application .application-body .application-item .p1,.home-pc .application .application-body button,.home-pc .application .application-header .title span,.home-pc .dialog .footer .apply-btn,.home-pc .dialog .header h1,.link-tag-box .selector-wrap,.link-tag-box .selector-wrap ul>li:hover,.link-tag-box .tab-wrap>ul li,.list-container .list-info-block .right-side .title,.list-filter-bar .item-text,.live-user .user-item .item-right .status,.live-user .user-item .item-right .tags>span,.m-layer .b-btn,.m-layer.m-button,.m_layer.m-button,.mask .popup-container .title,.normal-v2-container .normal-title-wrp>.template-op>p,.pendant-main .pendant-btn,.pendant-mask .pendant-box .pendant-main .price-btn,.pendant-mask .pendant-main .pendant-info p,.pgc-list .pgc-item .right-info .headline .pgc-label,.pgc-list .pgc-item .right-info .headline .title,.player-his-main .player-his-nav,.popup-content-ctnr .report-input,.popup-content-ctnr .upload-box .upload-btn,.r-con .members-info .up-card .attention,.r-con .members-info .up-card .attention--not,.r-con .members-info .up-card .info-name,.r-con .members-info__header .btn,.r-con .members-info__header .title,.read-list-modal-component .creat-read-list-box .input-box button,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list .menu-item,.read-list-page .read-list-name .info.right.show .title,.regist .reg-main-text,.regist .reg-main-title,.regist .toolbox .reg-tip,.right-content .customize-wrp .title,.right-content .reward-wrp .reward-title,.security-right-bottom .face-nav>div a,.security-right-bottom .tool-uninstall-pendant span,.selet-datebox .inpt a.b-btn,.selet-datebox .inpt input[type=text],.selet-datebox .sse a,.setting .public-setting .public-wrp .button-wrap .btn-text.ok,.setting .public-setting .public-wrp .button-wrap .btn-text.ok.is-disable,.setting .public-setting .public-wrp .setting-item,.share-board .share-btn .share-type,.share-board .song-share .song-share-ul,.share-wrap .content-wrap .input-wrap button,.share-wrap .content-wrap .input-wrap input,.share-wrap .content-wrap .input-wrap span,.song-coin-bg .song-coin .song-coin-btn,.song-coin-bg .song-coin .song-coin-title,.song-info .info-wrap .current-selector .chosen-type,.song-info .info-wrap .type-list .item-list .type-item,.song-info .info-wrap .type-list .item-list .type-item.active:hover,.song-info .info-wrap .type-list span,.sponsor-rank-item.pos-rank-module .sp-right .sp-user:not(.vip) .sp-name,.steps .step-operate .step-bread .step-index,.tab-selector-wrap .selector-wrap,.tab-selector-wrap .selector-wrap ul>li:hover,.tab-selector-wrap .tab-wrap>ul li,.tabs .customize-tab .tab-title,.tag.sky-blue,.tag.sky-blue.activated,.tag.sky-blue:hover,.teach-last-list .teach-tv-text,.text-article-wrp .article-card .meta-title .typename,.text-article-wrp .article-card .meta-view .menu-list .menu-item,.text-article-wrp .article-card .meta-view .meta-item.text-item,.text-article-wrp .head-stat .section .title,.title-library-wrap .title-status button,.ui-popup .popup-wrap .text-box .text,.ui-popup.popup-cover .bili-btn.cancel,.ui-state-active,.ui-state-default,.ui-state-focus,.ui-state-hover,.ui-widget-content,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-default,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-default,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover,.up-info .btn-panel .charge-btn,.up-info .btn-panel .not-follow-charge-btn:hover,.vd-list li .title,.video-detail .item-title,.view-later-module .up-info-module .b-btn,.view-later-module .video-info-module h1,.vl-hd-sub .b-slt .list li,.vl-hd-sub .b-slt .txt,.vote-info-wrapper .user-name .name,.vote-info-wrapper .vote-to{color:#eee!important}#bili-data-center .version-switch-section,#navigator .v-switcher-header-item,#pgc-navigate-wrap .ep-box .ep-sub .ep-item,#pgc-navigate-wrap .play-btn,#pgc-navigate-wrap .play-btn:hover,.answer-container .answer-list,.answer-container .answer-list .exam-list,.answer-container .footer-bottom .btn-default,.article-info-module,.article-net-charts .area,.article-net-charts .charts .person,.article-net-charts .charts .play,.b-slt.on,.b-slt.on:hover,.b-slt:hover,.bangumi-list .bangumi-item,.bangumi-list .bangumi-item .right-info .headline .bangumi-label,.bili-dialog-bomb .appeal-box .submit .cancel,.bili-modal.cropper-modal .modal-footer,.bili-modal.cropper-modal .modal-head .head-wrap,.block-area .follow-wrapper .follow-head .follow-more,.bp-emoji-box .static-popup,.card .fold-box,.cards-block .modal-wrap .btn-group,.carousel-wrp .panel .pic li,.cc-article-wrp .article-card .meta-title .typename,.cc-body .setting .follow-setting,.cc-body .setting .public-setting,.cc-container .nav-search .dropdown-btn,.cc-content-body .select-box,.cc-content-body .select-box .row,.container-left .answer-container,.container-left .header-top,.cover-upload-box .modal-head .head-wrap,.customize-wrp .customize-tab,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>*,.dc-page .version-switch-section,.detail-wrp .detail-empty,.el-picker-panel__body .el-date-table th,.el-popper[x-placement^=bottom] .popper__arrow,.el-popper[x-placement^=bottom] .popper__arrow:after,.error-body .error-container .song-wrap .change-song,.face-container .pendant-list li,.face-container .pendant-list li>div,.face-container .record-table tbody td,.face-g-list#my-g-list .face-g-block .my-mp-block,.feed-topic .card,.feed-topic .hot-content .card,.feed-topic .top-content .card.card-offset,.float_window,.float_window .close,.float_window .close:hover,.float_window .selet-datebox .inpt input[type=text],.home-pc .application .application-foot,.info-wrap .feedback-mask .content .headline,.link-tag-box .selector-wrap div,.link-tag-box .selector-wrap ul,.link-tag-box .tab-wrap,.list-container .list-info-block .right-side .up-info-block .follow-btn.on,.live-category .category,.live-user .user-item .item-right .tags>span,.m-layer .b-btn,.m-layer.m-button,.m_layer.m-button,.main-ctnr .qualify-drawer .draw-list,.main-ctnr .qualify-drawer .drawer-pop:after,.modal-content.clearfix .img-clip-wrap .reset-img,.more-selector-v2-container .dividing-line,.normal-v2-container .normal-title-wrp>.template-op,.pgc-list .pgc-item,.pgc-list .pgc-item .right-info .headline .pgc-label,.popup-content-ctnr .report-input,.protocol-modal .cancel-btn,.r-con .members-info .up-card .attention--not:hover,.read-list-modal-component .creat-read-list-box .input-box,.read-list-modal-component .creat-read-list-box .input-box button,.read-list-modal-component hr,.s-space #page-fav .fav-sidenav,.section-block .bp-emoji-box .static-popup,.section-block.with-radius.p-relative .section-nav,.security-right .game-package-wrapper,.security-right .game-package-wrapper .game-item-container .game-package-item,.security-right .vip-package-wrapper,.security-right-bottom .face-nav,.security-right-bottom .face-tool .tool-container,.security-right-bottom .face-tool .tool-container .tool-change-face,.security-right-bottom .face-tool .tool-container .tool-uninstall-pendant,.selet-datebox .inpt a.b-btn,.selet-datebox .inpt a.b-btn:hover,.share-board .share-btn .share-type.song-border,.share-board .song-share .song-share-ul,.share-board .song-share .song-share-ul li,.share-wrap .content-wrap .input-wrap input,.song-info .info-wrap .type-list .item-list .type-item,.ssr-content .link-tag.activity:active,.tab-selector-wrap .selector-wrap div,.tab-selector-wrap .selector-wrap ul,.tag.sky-blue,.tag.sky-blue.activated,.text-article-wrp .article-card,.text-article-wrp .article-card .meta-title .typename,.ui-popup .popup-wrap.shadow,.ui-popup.popup-cover .bili-btn.cancel,.ui-state-active,.ui-state-default,.ui-state-focus,.ui-state-hover,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-default,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-default,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover,.up-info .btn-panel .charge-btn,.vd-list.l3 li .l-item,.version-switch-section .bottom-border,.videoCharts .stat-wrp,.view-later-module .core-player-auxiliary-area,.view-later-module .core-player-filter,.view-later-module .core-player-video-control,.view-later-module .up-info-module .b-btn,.view-later-module .video-box-module,.view-later-module .video-toolbar-module,.vl-hd-sub .selector-block .b-slt .list{border-color:transparent!important}.article-info-module .v-info .line,.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info .btn-go-write,.list-container .article-list-block .article-item .item-holder .article-content .article-left-block,.modal .img-clip-wrap .container-box,.pendant-main .final-price,.pendant-main .unit-price li,.text-article-wrp .article-card .meta-status .pubdate,.video-info-module .v-info .line{border-color:#aaa!important}#float_window h3,.article-info-module .v-data,.bili-dialog-bomb .appeal-box .header,.bili-dialog-bomb .appeal-box .submit,.read-list-page .add-article-modal hr,.selet-datebox .sse,.selet-datebox .sse a,.ui-widget-content,.vd-list li .l-r .up-info .v-date,.vd-list.l1 li .l-r,.vd-list.l2 li,.vd-list.l2 li .l-item,.view-later-module .video-desc,.view-later-module .video-info-module .number .line,.view-later-module .video-tag,.web-box .expanded .user-li::after{border-color:#444!important}#pgc-navigate-wrap .play-btn .play-btn-svg,.b-slt .b-slt-arrow,.block-area .follow-wrapper .follow-head .follow-more .icon,.error-related .error.details,.float_window .close,.text-article-wrp .head-stat .section .iconarrow,.video-toolbar-module .share-box .share-btn ul li{filter:brightness(0) invert(1)!important}#page-fav .fav-main .search-input .icon-search,.album-card .info .like-num .icon-like,.album-card .info .view-count .icon-view,.album-item .meta-col .icon,.article-card .article-info .data .icon,.article-content .meta-col .icon,.article-info-module .v-data .icon,.bangumi-info-module .v-data .icon,.case-list .info .jury-time i,.col-1 .i-pin-info .icon,.col-1 .meta .icon,.cube .meta .icon,.item-right .info.clearfix .icon-live-col,.item-right .info.clearfix .icon-live-compete,.item-right .info.clearfix .icon-live-life,.item-right .info.clearfix .icon-live-mgame,.l-item .v-info .b-icon,.section-block .col-full .meta .icon,.video-info-module .v-data .icon,.view-later-module .share-box .s-text .icon{filter:brightness(0) invert(.7)!important}#page-fav .fav-main .search-input .icon-search:hover,.answer-list .key-list li.active:before,.bui-radio .bui-radio-normal .bui-radio-item:hover .bui-radio-icon svg,.feedback-mask .content .feedback-body input[type=radio]:checked+.radio-icon,.fold-box .fold-hoverable:hover .fold-arrow,.left-nav-item:hover .icon-customize,.left-nav-ul .icon-customize.active,.nav-upload-container .nav-upload-item>img,.pendant-main .unit-price li.active,.pendant-pay-close,.register-agree .checkbox-bwxr.active,.security-right-bottom .face-nav>.active:after,.self-icon-vote-create-btn.active,.song-info .info-wrap .type-list .fold-div .foldStatus,.song-info .info-wrap .type-list .fold-div .unfoldStatus,.vl-hd #tab_list_mode .tab-i{filter:var(--blue-image-filter)!important}.container-right .rule-title .pink-icon{filter:var(--pink-image-filter)!important}.float_window .close:hover,.view-later-module .video-info-module{box-shadow:none!important}#app-ctnr .demo-app .category,#root .nav-upload-container,.article-info-module,.cc-content-body .select-box,.charge-participate .part-btn,.detail-wrp .detail-empty,.face-g-list#my-g-list .face-g-block .my-mp-block:hover,.float_window,.left-nav-wrapper,.live-user .user-item:hover,.m-layer.m-button,.m_layer.m-button,.read-list-page .module-box,.share-board .share-btn,.share-board .song-share .song-share-ul,.text-article-wrp .head-stat{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info .btn-go-write:hover,.carousel-wrp .page .next.current,.customize-wrp .select,.data-card .data-wrp .tab .fan-tab.current,.data-card .data-wrp .tab .fan-tab.current:after,.data-card .data-wrp .total .incr-num:before,.data-card .fans-wrp .tab .fan-tab.current,.data-card .fans-wrp .tab .fan-tab.current:after,.data-card .fans-wrp .total .incr-num:before,.error-body .error-container .song-wrap .song-list .song-li .song-shadow,.face-container .pendant-list li:hover,.info-line .status-attend,.list-filter-bar .item-text.active,.list-filter-bar .item-text.expand,.list-filter-bar .item-text:hover,.live-category .category:hover,.pendant-main .unit-price li.active,.pendant-main .unit-price li:hover,.security-right-bottom .face-nav>.active,.setting .public-setting .public-wrp .setting-item .circle-wrap.active,.song-coin-bg .song-coin .song-coin-content .song-one-coin.active,.song-coin-bg .song-coin .song-coin-content .song-one-coin:hover,.song-coin-bg .song-coin .song-coin-content .song-two-coin.active,.song-coin-bg .song-coin .song-coin-content .song-two-coin:hover,.song-info .info-wrap .type-list .item-list .type-item:hover,.ssr-content .link-tag.activity,.tag.sky-blue:hover,.title-library-wrap .title-status button,.vl-hd .vl-tab .tab-i.on{border-color:var(--theme-color)!important}#app .el-button--primary,#app .el-button--primary:focus,#app .el-button--primary:hover,#navigator .v-switcher-header-anchor,#pgc-navigate-wrap .ep-box .ep-sub .ep-item:hover,#pgc-navigate-wrap .play-btn:hover,.abnormal-module .abnormal-item .btn-back:hover,.ac-article-wrp .tabs-nav .select,.advice-dialog-wrapper .submit-btn:hover,.answer-container .footer-bottom .btn-default,.author-container .attention-animation-holder .attention-btn,.bb-comment .no-login .baffle .b-btn:hover,.bili-dialog-bomb .appeal-box .submit .confirm,.bili-dialog-bomb .appeal-box .wrap .container .options .option .checkbox.checked:before,.bili-header-m .mini-wnd-nav.history-wnd .top-login .loginbtn,.bilibili-player .bilibili-player-area .bilibili-player-video-control .bilibili-player-video-btn .bilibili-player-video-quality-menu .bilibili-player-bigvip,.block-area .follow-wrapper .follow-head .follow-more:hover,.cards-block .images-list .image-item .selected,.carousel-wrp .page .next.current,.face-container .pendant-list li .pendant-btn,.face-container .pendant-list li .pendant-btn:hover,.face-container .pendant-nav li div.active,.feedback-mask .content .feedback-body .feedback-submit.active,.home-pc .application .application-body .btn-color:hover,.home-pc .dialog .footer .apply-btn:hover,.m-layer .b-btn,.pendant-main .pendant-btn,.popup-content-ctnr .upload-box .upload-btn,.r-con .members-info .up-card .attention--not:hover,.security-right-bottom .face-tool .tool-container .tool-change-face,.selet-datebox .inpt a.b-btn:hover,.selet-datebox .sse a.on,.setting .public-setting .public-wrp .button-wrap .btn-text.ok,.setting .public-setting .public-wrp .setting-item .circle-wrap .circle-inlie,.share-wrap .content-wrap .input-wrap button,.song-coin-bg .song-coin .song-coin-btn,.song-coin-bg .song-coin .song-coin-btn:hover,.ssr-content .link-tag.activity:active,.ssr-content .link-tag.activity:hover,.steps .step-operate .step-bread .step-index,.tab-wrap>ul li.selected a span:after,.tag.sky-blue.activated,.text-article-wrp .article-card .meta-view .meta-item:hover,.ui-state-active,.ui-state-focus,.ui-state-hover,.ui-widget-content .ui-state-active,.ui-widget-content .ui-state-focus,.ui-widget-content .ui-state-hover,.ui-widget-header .ui-state-active,.ui-widget-header .ui-state-focus,.ui-widget-header .ui-state-hover,.up-info .btn-panel .not-follow-charge-btn:hover,.view-later-module .up-info-module .b-btn{background-color:var(--theme-color)!important}#announcement-area .flip-view .action-arrow-ctnr:hover .icon-font,#navigator .v-switcher-header-item a:hover,#page-article .article-lists .lists-item .item-right .item-name a:hover,#page-article .article-lists .lists-item .item-right .item-title a:hover,#page-fav .fav-main .fav-action-bottom .search-results-num i,.answer-container .header-top .header-tip,.article-card .article-info .title:hover,.article-content-ctnr .supporting-info .category:hover,.b-slt-tab .tab-i:hover,.b-slt-tab li:hover,.bangumi-list .bangumi-item .right-info .headline .title:hover,.bangumi-media .bangumi-media-body .review-empty-wrapper .empty-info .btn-go-write:hover,.bili-header-m .profile-m .grade .bar .num .v0:hover,.card-warpper .card-warpper-outside .card-item .learn.unlearn,.cntr .sort-cntr .href-all:hover,.cntr .sort-cntr .href-all:hover i,.col-1 .article-wrap .article-con a:hover,.comment-list-item .article-wrap .show-all,.content-tag-v2-edit-mod-wrp p a,.content-tag-v2-edit-mod-wrp p a:hover,.coupon-money-2:before,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>:hover,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-management>:hover i,.data-card .data-wrp .tab .fan-tab.current,.data-card .fans-wrp .tab .fan-tab.current,.electron-set-v2-hint a,.electron-set-v2-hint a .electron-set-v2-hint a:hover,.electron-set-v2-hint a:hover,.enter-failure .password-input .empty-hint,.fold-box .fold-hoverable:hover,.follow-item .details .highlight,.follow-item .details .season-title:hover,.form-group .register-agree a,.form-group.register-hidden-gruop.text-right a,.game-package-item .game-package-type,.home-pc .application .application-body .fjw-tip li:first-child,.icon-close:hover,.list-filter-bar .item-text.active,.list-filter-bar .item-text.expand,.list-filter-bar .item-text:hover,.main-container .media-info .media-right .media-desc i,.pendant-main .final-price span,.pendant-main .point-info a,.pendant-main .unit-price li.active,.pendant-main .unit-price li:hover,.pgc-list .pgc-item .right-info .headline .title:hover,.pgc-space-follow-item .pgc-item-info .pgc-item-state .publish-state.is-new,.photo-imager-container .image-count-hinter .count-hinter .current-index,.rank-item:hover .item-title,.read-list-page .read-list-name .info.right.show .right-float .ui-btn.grey-radius .menu-list .menu-item:hover,.register-hidden-gruop.text-right a,.rule-time span,.share-board .song-share .song-share-ul li:hover,.share-wrap .content-wrap .title,.small-item .search-keyword-highlight,.song-coin-bg .song-coin .song-coin-content .song-one-coin.active,.song-coin-bg .song-coin .song-coin-content .song-two-coin.active,.song-coin-bg .song-coin .song-coin-title .song-coin-number,.song-info .info-wrap .choose-type .selected,.song-info .info-wrap .current-selector .selector-list .font-blue,.song-info .info-wrap .type-list .fold-div,.song-info .info-wrap .type-list .item-list .type-item:hover,.sponsor-rank-item.pos-rank-module .sp-right .sp-user:not(.vip) .sp-name:hover,.steps .step-operate .dropdown-btn .icon-text,.steps .step-operate .step-bread .step-title.selected,.tab-wrap>ul li a span:hover,.tab-wrap>ul li.selected a span,.text-article-wrp .article-card .meta-status .status,.text-article-wrp .article-card .meta-view .menu-list .menu-item:hover,.ui-checkbox input[type=checkbox]:active+.ui-checkbox-icon,.ui-checkbox input[type=checkbox]:hover+.ui-checkbox-icon,.vd-list li .title:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-item:hover .bilibili-player-watchlater-info-title,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-positive.bppl-state-selected,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-positive:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-random.bppl-state-selected,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-random:hover,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-reverse.bppl-state-selected,.view-later-module .bilibili-player .bilibili-player-auxiliary-area .bilibili-player-watchlater-nav-reverse:hover,.view-later-module .bilibili-player-iconfont.icon-12toview-play:before,.view-later-module .video-info-module .tm-info a:hover,.vl-hd #tab_list_type .tab-i.on,.vl-hd .vl-tab .tab-i.on{color:var(--theme-color)!important}.contri-condition .contri-select.active:after,.data-card .data-wrp .tab .fan-tab.current:after,.data-card .data-wrp .total .incr-num:before,.data-card .fans-wrp .tab .fan-tab.current:after,.data-card .fans-wrp .total .incr-num:before{border-left-color:transparent!important;border-right-color:transparent!important}.ui-datepicker .ui-datepicker-next,.ui-datepicker .ui-datepicker-prev,.ui-state-default,.ui-widget-content,.ui-widget-content .ui-state-default,.ui-widget-header .ui-state-default{border-radius:4px!important}.cc-content-body .select-box .select-item:hover{border-radius:15px!important}.app-layout .dropbox-component,.app-layout .dropbox-component .data-list,.app-layout .page-content .feedback-content-input,.app-layout .page-content .manga-textbox,.box .content-wrap .btn .info,.calendar-wrap .calendar-body .date-desc_wrap,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .line .point-wrapper,.content .share-wrap,.dialog-wrapper .dialog,.fjw-kpi-wrap-bg,.fjw-point .point-wrap .user-point .face .unfocus-btn,.international-home .bilibili-search-history,.item-wrap__task .operate-btn,.main-wrapper .comment-wrapper,.navbar-container,.nomal-task .bottom-box .btn,.reply-bottom-menu-mask .more-ops,.reply-emoji-panel .emoji-cate,.reply-emoji-panel .emoji-cate a,.reply-emoji-panel .emoji-list,.round-corner .app-layout,.round-corner .international-footer,.row1 .calendar-wrap,.security_content .close-btn,.security_content .coupon-wrapper .coupon-content,.security_content .title-right-link,.submit button,.van-popover{background-color:#222!important}.app-layout .sidebar,.at-popup .user-container .item.is-selected,.bangumi-options .opt-list,.bpui-selected,.bpui-selected span,.bui-swiper-wrap .bui-swiper-item .bui-swiper-text,.comic-info-component .page-normal .comic-info-con,.comic-info-component .page-normal .comic-info-con .comic-des,.container .links .link-item:hover,.container .logout a:hover,.container .tab-item--normal:hover,.container .video-card:hover,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-wrap-child .player-auxiliary-panel-title,.danmaku-wrap .player-auxiliary-block-wrap,.dropdown__content .dropdown__active,.dropdown__content .dropdown__item:hover,.guest-home .button-box button,.lang-change .lang-intro-item:hover,.lang-change .lang-item:hover,.manga-button.ghost,.manga-button.primary,.player-auxiliary-danmaku-function,.player-auxiliary-danmaku-function [class*=player-auxiliary-danmaku-btn-],.player-auxiliary-danmaku-wrap .player-auxiliary-danmaku-load-status,.practice-wrap .tab-container,.qa-area-ol-wrp,.video-editor-ol-wrp{background-color:#333!important}.app-layout .page-content .router-view,.app-layout .sidebar .nav-item-indicator,.bangumi-item .right-info .headline .bangumi-label,.bili-search .live-user-item .item-right .tags>span,.bili-search .pgc-item .right-info .headline .pgc-label,.bili-search .user-item .attention-btn,.box .content-wrap,.box .record-wrap,.box-body,.bpui-selected>span,.bpui-selecting>span,.bpui-unselecting,.bui-button.bui-button-gray2,.bui-collapse .bui-collapse-header,.bui-swiper-wrap .bui-swiper-next,.bui-swiper-wrap .bui-swiper-pre,.calendar-wrap .calendar-body .calendar-body__select .ui-dropdown .default:hover,.calendarEntry_wrap,.calendarEntry_wrap .calendarEntry_slide,.carousel-wrap li.scrollx,.comment .comment-hot-item-floor .operate-utils,.container .more-btn,.detail-content .activity-info,.detail-content .guest-wrapper,.detail-content .jump-pagination-input,.detail-content .more-hot-comments,.elevator .list-box,.elevator .list-box .item,.elevator .list-box .item.back-old,.elevator .list-box .item.sort,.episode-list-component .episode-list .list-data .list-item,.exchange-btn .btn,.feed-card .feed-title,.feed-topic .empty-content,.flow-loader .activity-item .info .type,.follow-right-module .follow-head .follow-more,.gg-window .online,.guest-home .login-panel,.hot-recom-module .random-change,.international-home .bilibili-search-history .history-item.focus,.international-home .bilibili-search-history .history-item:hover,.list-header .filter-wrp .article-type,.list-header .filter-wrp .category-wrp,.list-header .filter-wrp .filter-level,.list-header .filter-wrp .order-wrp,.list-header .filter-wrp .video-type,.live-charge-box .tip-popup,.live-rank .live-rank-item .number,.main-panel .hot-topic-panel,.mession-box .content .list-wrap .item-index,.modal-wrapper .modal-container,.news-dialog-Wrapper,.pgc-rank-wrap .number,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel,.r-con .members-info .up-card .attention--not,.r-con .members-info__header,.rank-wrap .number,.recommendation-list .list-item:before,.replies-comment-input-wrapper .replies-upload .comment-input-img,.replies-comment-input-wrapper .replies-upload .replies-uploading-container,.replies-comment-input-wrapper .submit-comment.no-login,.reply-emoji-panel .emoji-cate a.on,.reply-emoji-panel .emoji-list .emoji-pager .pager-dot,.reply-input .input-area .reply-emoji-btn,.reply-input .input-area .reply-submit-btn,.reply-input .input-area input,.reply-report .reason-choose .reason-group .list li input[type=radio],.reply-report .submit-btn button:disabled,.report-pc-dialog .report-dialog-container,.security_content .coupon-content-con .coupon-btn,.tabs .customize-tab,.tabs-nav .tab-item.border-bottom,.tabs-nav .tab-item.full,.tabs-wrapper,.ticket-tips-wrapper .rec-item,.ticket-tips-wrapper .ticket-tips,.time-line .tl-link,.ui-dropdown .default,.ui-dropdown .ui-dropdown-text,.ui-dropdown .ul-dropdown-list,.user-item .attention-btn.followed,.user-item .attention-btn.followed:hover,.vip-m .bubble-traditional .renew-btn button,li.danmaku-info-row.bpui-selected,li.danmaku-info-row.bpui-selecting{background-color:#444!important}.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .line,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .line .point-wrapper .point,.config-item:not(:last-child):after{background-color:#555!important}.guard-rank-cntr .rank-cntr .rank-list-box .url-back,.replies-comment-input-wrapper .submit-comment{background-image:none!important}#app .calendarEntry_content .header,#app .report-dialog-container .submit,#bp-app,.app-layout .list-item:hover,.app-layout .page-content,.app-layout .size-ruler,.app-layout .user-info>.uid,.article-action .more .more-ops-list,.article-action .more .more-ops-list ul li:hover,.buyticket,.buyticket .bread-wrapper,.calendar-wrap .calendar-body .date-desc_wrap .date-desc__content .nothing-wrap,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card,.card .forw-area a.more:hover,.cc-body #app .container,.container .info .date,.danmaku-box .bui-radio-input:checked+.bui-radio-label,.danmaku-wrap .player-auxiliary-area .player-auxiliary-danmaku-btn-footer,.detail-content .activity-info-body .info-header,.detail-content .comment,.edit-article-wrap #edit-article-box,.elevator .bg23,.episode-item,.high-wrapper .body-padding,.iframe-comp-container>div,.list-header .filter-wrp .article-type .bili-btn,.list-header .filter-wrp .article-type .line,.list-header .filter-wrp .filter-level .bili-btn,.list-header .filter-wrp .filter-level .line,.list-header .filter-wrp .video-type .bili-btn,.list-header .filter-wrp .video-type .line,.manga-recommendation .data-list .list-item,.manga-spread-module .label,.mini-header__content .i-frame,.mini-header__content .i-frame::before,.multi-line-text:after,.page-content .-BiliFooter,.player-auxiliary-area .danmaku-info-row-special,.player-auxiliary-area .player-auxiliary-collapse .bui-collapse-body,.rank-list-ctnr .normal-list .item.self,.rank-list-ctnr .own,.reply-emoji-panel .emoji-list .emoji-text:hover,.round-corner .loc-menu-box,.round-corner .out-container,.round-corner .out-container .tab-bar,.whole-detail-info-wrapper{background-color:transparent!important}.reply-item .sub-reply-preview,.security_content .coupon-wrapper{background:0 0!important}.box .title .h1:after{background:#fff!important}.fans-medal-item.special-medal .label .content{color:#222!important}.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item.visited,.main-container .ep-list-wrapper .list-wrapper.simple ul .ep-item:visited{color:#888!important}#all-list .user-item .up-info>span,#page-index .channel .channel-item .small-item .video-desc,.app-layout .page-content .extral-info,.article-card .r-con .count,.article-card .r-con .up,.bangumi-item .right-info .intros .label,.bangumi-item .right-info .intros .value,.bili-search .article-item .content .desc,.bili-search .article-item .content .so-icon a,.bili-search .live-user-item .item-right .info .star,.bili-search .live-user-item .item-right .info .type,.bili-search .pgc-item .right-info .intros .label,.bili-search .pgc-item .right-info .intros .value,.bili-search .topic-item .content .desc,.bottom-box .wrap-list .gift-item .B-paper,.box .content-wrap p,.box .list-box .wrap-list .text,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content,.calendarEntry_wrap .calendarEntry_footer .footer_content span,.carousel-wrap .panel .pic li a .card-info .detail,.center-box .line-1,.coming-soon-wrapper .card-wrapper .card-item .info-wrapper .desc,.comment .comment-hot-item-floor,.comment .reply-comment-list .reply-comment-item .reply-comment-item-floor,.data-list .list-container .data-item .text-section .footer-text .text,.detail-content .activity-info-body .info-content p span,.guest-home .title h2,.h5share-container .text-area .text-desc,.header-info .manga-info .supporting-text,.item-wrap__task .content-desc,.live-card .up .txt .desc,.live-card .up .txt .tag,.live-list .text-info,.live-list .text-info a,.live-rank .live-rank-item .txt p.p2,.manga-card-horizontal .text-section .footer-text,.manga-rank-list .rank-item .ri-detail .ri-first-info,.manga-rank-list .rank-item .ri-detail .ri-update,.manga-spread-module .label,.mession-box .content .list-wrap .item-summary,.my-coupon .subtitle,.past-work .card-view .collect-num,.past-work .card-view .danmu-num,.past-work .card-view .play-num,.pgc-rank-wrap .txt .update,.player-auxiliary-area .danmaku-info-row-block span.danmaku-info-danmaku,.player-auxiliary-area .danmaku-info-row-block span.danmaku-info-time,.player-auxiliary-area .danmaku-info-row-block::after,.player-auxiliary-area .danmaku-info-row-super::after,.practice-wrap .banner-container .title~p,.purchase-history .list-item .text-info .recharge-date,.qa-area-ol-wrp .qa-area-ol-content a,.rank-wrap .preview .txt span,.reply-dialog .subtitle,.security_content .common-subtitle,.ticket-tips-wrapper .rec-item .rec-item-time,.ticket-tips-wrapper .rec-item .rec-item-vuene,.time-line-card .txt .update a,.user-item .up-info>span,.user-item .up-videos .ptime,.video-card-common .up,.video-editor-ol-wrp .video-editor-ol-content a,.video-list .card-view .collect-num,.video-list .card-view .danmu-num,.video-list .card-view .play-num,.videos-wrap .card-view .collect-num,.videos-wrap .card-view .danmu-num,.videos-wrap .card-view .play-num{color:#aaa!important}#all-list .user-item .title,.activity-info .activity-info-header,.activity-item .info .title,.app-ctnr .club-brief,.app-layout .account-info-container,.app-layout .dropbox-component .current,.app-layout .dropbox-component .data-list>li,.app-layout .page-content .feedback-content-input .length-hinter,.app-layout .page-content .manga-textbox,.app-layout .search-list .keyword-hinter,.article-card .r-con .title,.bangumi-item .right-info .headline .bangumi-label,.bangumi-item .right-info .headline .title,.bb-comment a.more-link,.bili-search #live-list .headline-live .user-more,.bili-search #live-list .headline-room .filter a,.bili-search #live-list .live-tabs a,.bili-search .article-item .content .title,.bili-search .live-room-item .item-title,.bili-search .live-user-item .item-right .tags>span,.bili-search .live-user-item .item-right .uname,.bili-search .pgc-item .right-info .headline .pgc-label,.bili-search .pgc-item .right-info .headline .title,.bili-search .photo-item .title,.bili-search .topic-item .content .headline a,.bili-search .user-item .attention-btn,.bili-search .user-item .title,.bottom-box .complete,.box .title .h1,.box .title .progress-num,.bui-swiper-wrap .bui-swiper-item .bui-swiper-text,.buyticket .bread-wrapper span,.buyticket .bread-wrapper span a,.buyticket .map-model .modal-container .modal-header,.buyticket .whole-detail-info-wrapper,.calendar .month,.calendar .weekdays li,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_title .item-title,.calendar-wrap .calendar-body .date-wrap,.calendar-wrap .calendar-body .date-wrap .wrap-content .today,.calendar-wrap .calendar-header,.calendar-wrap .headerClass,.calendarEntry_wrap .calendarEntry_slide,.calendarEntry_wrap .greetings,.carousel-wrap .panel .pic li a .card-info .title .headline,.cc-nav-wrp .activity-nav-wrp .activity-link,.cc-zimu-wrp .zimu-header .zimu-header-title,.center-box .line-2,.comic-episodes .episode-header .episode-operation,.comic-episodes .episode-list .episode-item,.comic-info-component .page-normal .comic-info-con .comic-des .comic-operation .fav-btn .fav-text,.comic-info-component .page-normal .comic-tab .tab-titles .tab-title.active .comments-total,.coming-soon-wrapper .block-title,.coming-soon-wrapper .card-wrapper .card-item .info-wrapper .title,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .date,.coming-soon-wrapper .card-wrapper .card-item .time-line-wrapper .time,.comment .comment-hot-item-floor .operate-utils,.comment .comment-hot-item-user-name,.common-pagination-wrapper,.container .count-item .item-value,.container .date-title,.container .level-info .grade,.container .level-intro,.container .links .link-title,.container .more-btn,.container .split-line,.container .tab-header .tab-item,.container .tab-header .tab-item:hover,.container .tab-item--normal,.container .video-info .line-2,.customize-wrap .item-list .item .info-text,.customize-wrap .steps-title,.customize-wrap .title,.data-list .list-container .data-item .text-section .manga-title,.detail-content .activity-info-body .info-header span,.detail-content .content-detail p,.detail-content .content-detail span,.detail-content .jump-pagination-input,.detail-content .more-hot-comments,.dynamic-btn.pink.with-border-radius.publish-btn.disabled,.dynamic-m .dyn_menu li,.elevator .list-box .item.back-old,.empty-wrap .empty-text,.episode-list-component .episode-list .list-header .header-item,.exchange-btn .btn,.feed-card .feed-title,.fjw-point .point-wrap .user-point .face .unfocus-btn,.flow-loader .activity-item .info .type,.follow-right-module .follow-head .follow-more,.gg-window .online a,.guest-home .button-box .regist,.guest-home .title h1,.guest-wrapper .guest-header,.guest-wrapper .guest-list .name,.h5share-container .text-area .text-content,.handpick-right-module .block-header .block-title,.header-info .manga-info .author-name,.horizontalSelect-wrap .month,.hot-recom-module .random-change .info,.index-entry-wrapper .filter-block-title a,.index-entry-wrapper .filter-block-title span,.index-entry-wrapper .filter-list .filter-item,.interact-dialog .btn,.international-header a,.item-wrap__task .content-title,.item-wrap__task .operate-btn,.lang-change .lang-intro,.lang-change .lang-title,.left-nav-list.no-office .left-nav-item span,.list-header .dropdown-btn .icon-text,.list-header .dropdown-btn:hover,.list-header .filter-wrp .article-type .bili-btn,.list-header .filter-wrp .bread-crumb .main,.list-header .filter-wrp .bread-crumb .second,.list-header .filter-wrp .filter-level .bili-btn,.list-header .filter-wrp .video-type .bili-btn,.live-card .up .txt .name,.live-charge-box .popup-cntr .retry,.live-charge-cntr .popup-cntr .tip-content,.live-rank .live-rank-item .number,.live-rank .live-rank-item .txt p,.main-panel .more,.main-panel .title,.manga-button.ghost,.manga-button.primary,.manga-card .manga-title,.mession-box .btn,.mession-box .content .list-wrap .item-index,.mession-box .content .list-wrap .item-title,.mession-box .title,.my-coupon .coupon-title,.my-coupon .coupon-title .coupon-number,.navbar-container .logo-part,.navbar-container .size-ruler .app-title,.new-comers-module .zone-title .headline .name,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__body,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__btn,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__title,.pgc-rank-wrap .number,.pgc-rank-wrap .txt .title,.pivot-component .pivot-headers .pivot-header-item,.player-auxiliary-danmaku-report-wrap .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel .player-auxiliary-report-panel-title,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel .player-auxiliary-report-content,.popularity-list .list-title,.product-info-time-wrapper .product-info-time,.product-info-time-wrapper .product-info-time-title,.purchase-history .list-item .coin-info .recharge-count,.purchase-history .list-item .text-info .display-text,.qa-area-ol-wrp .qa-area-ol-content p,.rank-header .name,.rank-list-item .expand-mode .text-section .item-title,.rank-wrap .link .title,.rank-wrap .number,.rank-wrap .preview .txt p,.reason-container .reason-category .reason-category-title,.reply-bottom-menu-mask .more-ops .cancel,.reply-bottom-menu-mask .more-ops .ops-list li,.reply-bottom-menu-mask .more-ops .ops-list li a,.reply-dialog .title,.reply-emoji-panel .emoji-list .emoji-text .text-list span,.reply-input .input-area .reply-emoji-btn,.reply-input .input-area .reply-submit-btn,.reply-item .info .name,.reply-report .reason-choose .reason-group .list li,.reply-report .submit-btn button,.reply-report .submit-btn button:disabled,.report-dialog-container .submit .cancel-btn,.report-pc-dialog .report-dialog-container .title,.round-corner .international-footer .link-box .link-item .bt,.round-corner .international-footer .link-box .link-item ul a,.round-corner .international-footer .link-box .link-item.link-c p,.round-corner .international-footer .partner a,.round-corner .out-container .tab-bar,.schedule-list .list-header .date-selector .date-item,.security_content .close-btn,.security_content .common-title,.security_content .coupon-content-con .coupon-btn,.security_content .title-package-name,.security_content .title-right-link,.selectable-option.unable,.special-recommend header,.style-section .tag-block .block-title,.style-section .tag-block .tag-containers .style-tag,.sub-tabs .filter-content,.tabs-nav .tab-item,.tabs-nav .tab-item.border-bottom,.tabs-nav .tab-item.full,.ticket-tips-wrapper .rec-item .rec-item-name,.ticket-tips-wrapper .ticket-tips-content span,.ticket-tips-wrapper .ticket-tips-header,.time-line .tl-link,.time-line-card .txt .ss,.ui-dropdown .default,.ui-dropdown .ul-dropdown-list,.up-info .btn-panel .following,.user-info-component .coin-info,.user-item .attention-btn.followed,.user-item .attention-btn.followed:hover,.user-item .up-videos .video-item .video-desc,.user-item .up-videos .video-more,.van-popover a,.video-card-common .title,.video-editor-ol-wrp .video-editor-ol-content p,.video-item.matrix .title,.vip-m .bubble-traditional .recommand .title,.vip-m .bubble-traditional .renew-btn button,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .check-map,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .title,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .vuene-info-content .address-name,.whole-detail-info-wrapper .product-buy-wrapper .want-wrapper .want-content p{color:#eee!important}.app-layout .dropbox-component,.app-layout .dropbox-component .data-list,.app-layout .page-content .manga-textbox:focus,.ban-vote .vote-dialog .dialog-header,.bangumi-item .right-info .headline .bangumi-label,.bangumi-options .opt-list,.bangumi-timing-module .headline .c-clink,.bili-search .live-user-item .item-right .tags>span,.bili-search .pgc-item .right-info .headline .pgc-label,.bili-search .photo-item,.bilibili-player-ending-panel-box-recommend:hover,.calendarEntry_wrap,.calendarEntry_wrap .calendarEntry_slide,.calendarEntry_wrap .greetings,.carousel-wrap .page .next.current,.coin-nav,.comic-info-component .page-normal .comic-tab .tab-titles,.comment .comment-selecotr,.container .coins,.container .counts,.container .links,.container .tab-header,.detail-content .activity-info,.detail-content .comment,.detail-content .guest-wrapper,.detail-content .jump-pagination-input,.elevator .list-box,.elevator .list-box .item.back-old,.elevator .list-box .item.back-top,.exchange-btn .btn,.flow-loader .activity-item,.flow-loader .activity-item .info .type,.flow-loader .user-item,.flow-loader .video-item.matrix,.follow-right-module .follow-head .follow-more,.gg-window .online,.guest-home .button-box button,.head .dropdown-menu .article-list,.home-container .at-popup,.hot-recom-module .random-change,.interact-dialog .btn,.international-home .bilibili-search-history,.item-wrap__task .operate-btn,.lang-change,.list-header .filter-wrp .article-type,.list-header .filter-wrp .category-wrp,.list-header .filter-wrp .filter-level,.list-header .filter-wrp .order-wrp,.list-header .filter-wrp .video-type,.love-card .header:after,.love-detail .follow-btn.active,.main-wrapper .comment-wrapper,.navbar-container,.nomal-task .card,.page-tab .con li,.practice-wrap .tab-container,.replies-comment-input-wrapper .replies-upload .comment-input-img,.reply-bottom-menu-mask .more-ops .cancel,.reply-input .input-area .reply-emoji-btn,.reply-input .input-area .reply-submit-btn,.reply-report .reason-choose .reason-group .list li input[type=radio],.report-dialog-container .submit .cancel-btn:after,.report-dialog-container .submit .submit-btn:after,.report-dialog-container .textarea-wrapper,.round-corner .out-container .tab-bar,.security_content .bcoin-wrapper,.security_content .title-right-link,.tab-line-itnl,.tabs .customize-tab,.ticket-tips-wrapper .rec-item,.ticket-tips-wrapper .ticket-tips,.time-line .tl-link,.title-container .info .activity,.ui-dropdown .ui-dropdown-text,.van-popover,.van-popper[x-placement^=bottom] .popper__arrow,.van-popper[x-placement^=top] .popper__arrow{border-color:transparent!important}.carousel-wrp .page .next,.item-wrap__task:after,.item-wrap__task:before,.security_content .coupon-wrapper .coupon-content-con{border-color:#aaa!important}#all-list .mixin-list ul:not(:last-child),.bili-search .article-item,.bili-search .bangumi-item,.bili-search .pgc-item,.bili-search .topic-item,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content,.calendar-wrap .calendar-header,.comic-episodes .episode-list .episode-item .item-body,.link-input,.live-category .latest,.mession-box .content,.mession-box .content .list-wrap .border-btm,.practice-wrap .banner-container .current-work,.reply-bottom-menu-mask .more-ops .ops-list li,.reply-list .reply-item,.round-corner .international-footer .link-box .link-item,.tab-content .bilibili-comment,.van-popper[x-placement^=bottom] .popper__arrow:after,.van-popper[x-placement^=top] .popper__arrow:after{border-color:#444!important}.app-layout .pivot-component .pivot-headers,.at-item:not(:last-child):after,.carousel-wrap .page .next,.center-box .orginal-reply,.container .play-all,.container .split-line::before,.container .tabs-panel,.elevator .list-box .item.sort,.liked-user:not(:last-child):after,.love-item:not(:last-child):after,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel .player-auxiliary-report-panel-title,.reply-item:not(:last-child):after{border-color:#555!important}.app-layout .sidebar .nav-item .nav-item-icon,.follow-right-module .follow-head .follow-more .icon,.header-info .manga-info .action-buttons .do-favourite .fav-icon,.header-info .manga-info .supporting-text .label-icon,.hot-recom-module .random-change .icon_read,.index-entry-wrapper .filter-block-title a:after,.my-coupon .subtitle .question-cion,.security_content .m-arrow-package,.security_content .security-list:hover .security-icon,.whole-detail-info-wrapper .detail-info-wrapper .vuene-wrapper .address-icon{filter:brightness(0) invert(1)!important}.bili-search .so-icon i.icon-like,.bili-search .so-icon i.icon-reply,.bili-search .so-icon i.icon-view{filter:brightness(0) invert(.7)!important}.bili-search #live-list .headline-room .icon-live-face,.bili-search #live-list .headline-room .icon-live-frame,.bui-swiper-wrap .bui-swiper-next svg,.bui-swiper-wrap .bui-swiper-pre svg,.fjw-random .agree.active,.fjw-random .agree:hover,.fjw-random .unagree.active,.fjw-random .unagree:hover,.fold-box:hover .fold-arrow,.home-slide .trigger span.on,.ops canvas.ring-progress,.sticky-bar .bar-content .title-icon,.svga-container.svga-center canvas{filter:var(--blue-image-filter)!important}.activity-info .icon-activity,.buyticket .product-buy.enable,.calendar-date-body .wrap-content img,.comment .up-icon.active,.detail-content .comment .hot-icon span,.guest-wrapper .icon-guest,.reason-container .reason-category .other-reason .icon-select.selected,.reason-container .reason-category .reason-item .icon-select.selected,.replies-comment-input-wrapper .replies-upload .comment-input-img span,.replies-comment-input-wrapper .replies-upload .replies-uploading-container .replies-uploading-btn,.replies-comment-input-wrapper .replies-upload .replies-uploading-container p span:hover,.report-pc-dialog .report-dialog-container .title i:hover,.ticket-count .count-plus.active:after,.ticket-count .count-reduce.active:before,.ticket-tips-wrapper .ticket-tips-header span,.whole-detail-info-wrapper .product-buy-wrapper .want-wrapper .want-icon{filter:var(--pink-image-filter)!important}.fans-medal-item.special-medal .union{filter:brightness(.125)!important}.video-info-m .number .coin b,.video-info-m .number .coin i,.video-info-m .number .fav b,.video-info-m .number .fav i{filter:brightness(.135)!important}.bili-share-pc .favourite .icon-fav,.news-dialog__wrapper .trangle-img img{filter:brightness(.27)!important}.box .record-wrap,.buyticket .product-buy.enable,.comment .comment-hot-item-user-content,.comment .comment-selecotr,.replies-comment-input-wrapper .submit-comment{box-shadow:none!important}.bilibili-player-ending-panel-box-recommend:hover,.guest-wrapper .guest-list .guest-item:hover .image,.navbar-container,.pgc-space-follow-item .bangumi-options .opt-list,.player-auxiliary-danmaku-report-wrap.player-auxiliary-danmaku-report-wrap-white .player-auxiliary-danmaku-report-box .player-auxiliary-danmaku-report-panel,.section-block .at-popup,.selectable-option.active{box-shadow:0 1px 10px 0 var(--theme-color-30)!important}.bili-search #live-list .live-tabs a.active,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-head.up-avatar:hover,.comic-info-component .page-normal .comic-tab .tab-titles .tab-title.active .tab-btn,.live-tabs .tab-switch .tab-switch-item.on,.replies-comment-input-wrapper .replies-upload .comment-input-img:hover,.selectable-option.active,.selectable-option.active:after,.tabs-nav .tab-item.border-bottom,.time-line .tab-switch .tab-switch-item.on{border-color:var(--theme-color)!important}.app-layout .dropbox-component .data-list>li:hover,.be-tags-container .tag,.bili-search .user-item .attention-btn:hover,.bottom-box .complete .complete_text:before,.bui-swiper-wrap .bui-swiper-next:hover,.bui-swiper-wrap .bui-swiper-pre:hover,.calendar .days li.selected,.calendar-wrap .calendar-body .date-wrap .wrap-content .select-icon,.carousel-wrap .page .next.current,.channel-menu-itnl .item .name em,.comic-info-component .page-normal .comic-info-con .comic-des .comic-operation .comic-view-btn,.comment .comment-selecotr .all-comments.active:before,.comment .comment-selecotr .sortByHot.active:before,.container .more-btn:hover,.container .tab-item--active,.elevator .list-box .item.on,.elevator .list-box .item:hover,.episode-list-component .episode-list .list-data .list-item:hover,.exchange-btn .btn:hover,.follow-right-module .follow-head .follow-more:hover,.guest-home .button-box button:hover,.h5share-container .tag,.home-slide .trigger span:hover,.interact-dialog .btn,.item-wrap__task .item-index,.live-rank .live-rank-item .number.on,.live-room-app .guard-rank-cntr .rank-cntr .btn-box .buy:hover,.manga-button.primary:hover,.navbar-container .nav-items .nav-item.activated:before,.news-dialog__wrapper .dialog-wrapper__desc .dialog-wrapper__btn,.pgc-rank-wrap .number.on,.practice-wrap .banner-container .current-work .bili-btn,.progress-bar-core.p-absolute,.qa-area-ol-wrp .qa-area-ol-btn,.rank-wrap .number.on,.replies-comment-input-wrapper .submit-comment,.reply-emoji-panel .emoji-list .emoji-pager .pager-dot.on,.reply-input .input-area .reply-emoji-btn:hover,.reply-input .input-area .reply-submit-btn:hover,.reply-report .reason-choose .reason-group .list li input[type=radio]:checked:after,.reply-report .submit-btn button,.round-corner .out-container .tab-item.active,.security_content .close-btn:hover,.security_content .coupon-content-con .coupon-btn:hover,.style-section .tag-block .tag-containers .style-tag:active,.tabs-wrapper .tabs .tabs-item.active:before,.time-line .tl-link:hover,.video-editor-ol-wrp .video-editor-ol-btn,.vip-m .bubble-traditional .renew-btn button:hover{background-color:var(--theme-color)!important}#all-list .user-item .title:hover,.activity-item .info .title:hover,.article-card .r-con .title:hover,.article-container:hover .text-area .title,.bangumi-item .right-info .headline .title:hover,.bili-search #live-list .headline-live .user-more:hover,.bili-search #live-list .headline-room .filter a.active,.bili-search #live-list .headline-room .filter a:hover,.bili-search #live-list .live-tabs a.active,.bili-search .article-item .content .title:hover,.bili-search .live-room-item .item-title:hover,.bili-search .live-user-item .item-right .uname:hover,.bili-search .pgc-item .right-info .headline .title:hover,.bili-search .photo-item .title:hover,.bili-search .topic-item .content .headline a:hover,.bili-search .user-item .title:hover,.bottom-box .complete .uncomplete,.bui-swiper-wrap .bui-swiper-item .bui-swiper-text:hover,.calendar-wrap .calendar-body .date-desc_wrap .date-desc__content .nothing-wrap .release-link,.calendar-wrap .calendar-body .date-desc_wrap .item-desc_card .item-desc_body .item-desc__content .item-desc_share,.calendarEntry_wrap .calendarEntry_footer .footer-link,.calendarEntry_wrap .greetings .greet-num,.card .forw-area a.more:hover,.card .more-panel .child-button:hover,.cc-nav-wrp .activity-nav-wrp .activity-link.active i,.cc-nav-wrp .activity-nav-wrp .activity-link.active span,.cc-nav-wrp .activity-nav-wrp .activity-link:hover i,.cc-nav-wrp .activity-nav-wrp .activity-link:hover span,.cc-nav-wrp .nav-item.active i,.cc-nav-wrp .nav-item.active span,.cc-nav-wrp .nav-item:hover i,.cc-nav-wrp .nav-item:hover span,.center-box .line-1 .like-item:hover,.center-box .line-3 .action-button.active,.center-box .line-3 .action-button:hover,.comic-info-component .page-normal .comic-tab .tab-titles .tab-title.active,.coming-soon-wrapper .card-wrapper .card-item .info-wrapper .title:hover,.comment .comment-selecotr .all-comments.active,.comment .comment-selecotr .sortByHot.active,.comment .more-replys span,.container .count-item:hover .item-key,.container .count-item:hover .item-value,.container .publish-time,.container .video-list .content:hover,.customize-wrap .item-list .item .learn.unlearn,.d-data .fold-box:hover,.gg-window .online a:hover,.gridview-content-container .list-padding .share-board .list-share .font-blue,.guest-wrapper .guest-list .guest-item:hover .name,.index-entry-wrapper .filter-block-title a:hover,.index-entry-wrapper .filter-list .filter-item:hover,.international-header a:hover,.international-home .bilibili-search-history .cancel-icon:hover,.lang-change .lang-intro-item.on,.left-nav-childed .left-nav-childed-list .left-nav-item-childed:hover span,.left-nav-childed .left-nav-childed-list.active .left-nav-item-childed span,.left-nav-item-child:hover i,.left-nav-item-child:hover span,.left-nav-list.active .left-nav-item i,.left-nav-list.active .left-nav-item span,.left-nav-wrapper .left-nav-ul .left-nav-item:hover i,.left-nav-wrapper .left-nav-ul .left-nav-item:hover span,.list-header .filter-wrp .article-type .bili-btn.current,.list-header .filter-wrp .filter-level .bili-btn.current,.list-header .filter-wrp .video-type .bili-btn.current,.live-card .up .txt .name:hover,.live-category .latest a.active,.live-category .latest a:hover,.live-tabs .tab-switch .tab-switch-item.on,.main-panel .more:hover,.mession-box .btn:hover,.n-statistics a:hover,.new-comers-module .zone-title .headline .name:hover,.pgc-rank-wrap .txt .title:hover,.pivot-component .pivot-headers .pivot-header-item.selected,.pivot-component .pivot-headers .pivot-header-item:active,.qa-area-ol-wrp .qa-area-ol-content a:hover,.rank-wrap .link p:hover,.rank-wrap .preview .txt p:hover,.replies-comment-input-wrapper .replies-upload .comment-input-img,.round-corner .international-footer .link-box .link-item ul a:hover,.round-corner .international-footer .link-box .link-item.link-c a:hover p,.round-corner .international-footer .partner a:hover,.round-corner .out-container .tab-item:hover,.schedule-list .list-header .date-selector .date-item.active,.security_content .coupon-content-con .coupon-money,.security_content .coupon-money-1:after,.security_content .coupon-money-2:after,.security_content .security-list-link-jump:hover,.security_content .title-right-link:hover,.selectable-option.active,.sub-reply-preview .show-more,.sub-reply-preview .sub-preview-item a,.tabs-wrapper .tabs .tabs-item.active,.time-line .tab-switch .tab-switch-item.on,.time-line-card .txt .update .published,.time-line-card .txt a:hover,.up-info .up-focus-btn,.user-item .up-videos .video-item .video-desc:hover,.user-item .up-videos .video-more:hover,.van-popover a:hover,.video-card-common .title:hover,.video-card-common .up:hover,.video-editor-ol-wrp .video-editor-ol-content a:hover,.video-item-biref:hover .biref-info .biref-title,.video-item.matrix .title:hover,.video-list .card-txt:hover,.whole-detail-info-wrapper .product-buy-wrapper .want-wrapper .want-content p:hover,.whole-pagination-wrapper .common-pagination-wrapper .pageNum.active,.whole-pagination-wrapper .common-pagination-wrapper .pageNum:hover{color:var(--theme-color)!important}#page-fav .fav-sidenav .fav-item.cur .be-dropdown-trigger .icon-ic_more,#page-fav .fav-sidenav .fav-item.cur .iconfont,#page-fav .fav-sidenav .fav-item.cur .num,#page-fav .fav-sidenav .fav-item.cur .text.router-link-exact-active.router-link-active,.app-layout .dropbox-component .data-list>li:hover,.bangumi-timing-module .headline .c-clink,.bangumi-timing-module .headline .c-clink:hover,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric,.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-electric.little,.block-area .timeline-title .headline .timeline-more:hover,.comic-info-component .page-normal .comic-info-con .comic-des .comic-operation .comic-view-btn,.container .more-btn:hover,.container .tab-item--active,.dynamic-m .wnd_bottom a:hover,.edit-media-list .edit-mask .edit-board .edit-info .submit-btn,.elevator .list-box .item.on,.elevator .list-box .item:hover,.elevator-module .nav-list .customize:hover,.elevator-module .nav-list .item.on,.episode-list-component .episode-list .list-data .list-item:hover,.exchange-btn .btn:hover,.favInfo-box .favInfo-details .fav-options .fav-play:hover,.follow-dialog-wrap .follow-dialog-window .bottom .btn,.follow-right-module .follow-head .follow-more:hover,.guest-home .button-box button:hover,.h5share-container .tag,.item-wrap__task .item-index,.link-navbar .nav-item:hover .nav-link,.live-rank .live-rank-item .number.on,.manga-navbar-manga-logo,.new-stat-module .zone-title .headline .new-stat-more:hover,.pgc-rank-wrap .number.on,.practice-wrap .banner-container .current-work .bili-btn,.qa-area-ol-wrp .qa-area-ol-btn,.rank-wrap .number.on,.reply-input .input-area .reply-emoji-btn:hover,.reply-input .input-area .reply-submit-btn:hover,.round-corner .out-container .tab-item.active,.security-left .on .security-nav-name,.security_content .close-btn:hover,.security_content .coupon-content-con .coupon-btn:hover,.security_content .security-list:hover .security-nav-name,.sticky-bar .bar-content .send-button .send-text,.time-line .tl-link:hover,.timeline-box .timeline-item.new p.num a,.upload-v2-step1-container #homeDrop .upload-btn .upload-btn-title,.video-editor-ol-wrp .video-editor-ol-btn{color:var(--foreground-color)!important}.bilibili-player-ending-panel-box-functions .bilibili-player-upinfo-follow .bp-svgicon{fill:var(--foreground-color)!important}.selectable-option.active:after{border-top-color:transparent!important;border-left-color:transparent!important}.van-popper[x-placement^=bottom] .popper__arrow:after,.van-popper[x-placement^=top] .popper__arrow:after{border-left-color:transparent!important;border-right-color:transparent!important}.feed-topic .empty-content,.report-dialog-container .textarea-wrapper{border-radius:4px!important}.level-1{border-color:#44b0a0!important}.level-1 .label{background-color:#44b0a0!important}.level-1 .level{color:#44b0a0!important}.level-2{border-color:#44b0a0!important}.level-2 .label{background-color:#44b0a0!important}.level-2 .level{color:#44b0a0!important}.level-3{border-color:#44b0a0!important}.level-3 .label{background-color:#44b0a0!important}.level-3 .level{color:#44b0a0!important}.level-4{border-color:#44b0a0!important}.level-4 .label{background-color:#44b0a0!important}.level-4 .level{color:#44b0a0!important}.level-5{border-color:#74b0f6!important}.level-5 .label{background-color:#74b0f6!important}.level-5 .level{color:#74b0f6!important}.level-6{border-color:#74b0f6!important}.level-6 .label{background-color:#74b0f6!important}.level-6 .level{color:#74b0f6!important}.level-7{border-color:#74b0f6!important}.level-7 .label{background-color:#74b0f6!important}.level-7 .level{color:#74b0f6!important}.level-8{border-color:#74b0f6!important}.level-8 .label{background-color:#74b0f6!important}.level-8 .level{color:#74b0f6!important}.level-9{border-color:#ba94f2!important}.level-9 .label{background-color:#ba94f2!important}.level-9 .level{color:#ba94f2!important}.level-10{border-color:#ba94f2!important}.level-10 .label{background-color:#ba94f2!important}.level-10 .level{color:#ba94f2!important}.level-11{border-color:#ba94f2!important}.level-11 .label{background-color:#ba94f2!important}.level-11 .level{color:#ba94f2!important}.level-12{border-color:#ba94f2!important}.level-12 .label{background-color:#ba94f2!important}.level-12 .level{color:#ba94f2!important}.van-popover .level-bar .level-progress{background-color:#ffae00!important}#biliAppHomeSetting>div,#gift-package-item-box .panel-wrapper,.app-layout .manga-navbar,.container .play-all,.container .split-line .history-tip,.hover-panel-wrap,.hover-panel-wrapper,.international-home,.lang-change .lang-intro,.manga-navbar .drop-list,.title-renew-panel .actions,.user-title-using-cntr .panel,.van-popover .container{background-color:#222!important}.container .level-intro,.container .play-all:hover,.international-header .bili-banner,.manga-navbar .drop-list .more-btn-container,.manga-navbar .search-bar .search-bar-bg,.manga-navbar .user-panel .drop-list .logout-btn-container,.message-list-content .notify-wrapper .notify-text,.recommend-area-ctnr .rec-area-item,.skeleton .skeleton-content,.skeleton .skeleton-focusbtn,.skeleton .skeleton-head,.skeleton .skeleton-time,.skeleton .skeleton-user-name,.user-title-using-cntr .user-title-box,.van-popover .btn-box .btn.reg-btn:hover,.van-popover .upload-item:hover,.yzly-content-ctnr .btn{background-color:#333!important}.up-info .u-face .fa{background-color:#444!important}.share-step .core-style{color:#eee!important;border-color:#444!important;background-color:transparent!important}.share-step .core-style:focus-within,.share-step .core-style:hover{background-color:transparent!important;border-color:var(--theme-color)!important}.grid-area-ctnr .hab-ctnr,.grid-area-ctnr .news-ctnr,.grid-area-ctnr .rank-ctnr{background-color:#444!important}.confirmorder-container{background-color:#444!important;box-shadow:none!important}.confirmorder-container h1{color:#eee!important}.confirmorder-container h1 span{color:#aaa!important}.confirmorder-container .card .card-bottom .delete{filter:brightness(0) invert(.7)!important}.confirmorder-container .card .card-bottom .delete:hover{filter:var(--pink-image-filter)!important}.confirmorder-container .card.active{border-color:var(--theme-color)!important}.confirmorder-container .card.active::before{filter:var(--pink-image-filter)!important}.confirmorder-container .discounts{border-color:#555!important}.confirmorder-container .discounts .discounts-list p{border-color:transparent!important;background-color:#111!important;color:#666!important}.confirmorder-container .total-container div span{color:#eee!important}.confirmorder-container .total-container div span.total{color:var(--theme-color)!important}.confirmorder-container .confirm-bottom .confirm-paybtn.active{filter:var(--pink-image-filter)!important}.confirmorder-container .confirm-bottom .service-term{color:#aaa!important}.confirmorder-container .confirm-bottom .service-term .check-icon,.confirmorder-container .confirm-bottom .service-term .check-icon.checked{filter:var(--pink-image-filter)!important}.confirmorder-container .confirm-bottom .service-term .term-content{color:var(--theme-color)!important}.eticket-container .top-box .header{border-color:transparent!important;background-color:#333!important}.eticket-container .top-box .header .header-back{filter:brightness(0) invert(1)!important}.eticket-container .top-box .header h1{color:#eee!important}.eticket-container .top-box .header::after{border-color:transparent!important}.eticket-container .eticket-info-container{background-color:#444!important;box-shadow:none!important}.eticket-container .eticket-info-right div{color:#eee!important}.eticket-container .eticket-info-right p{color:#aaa!important}.eticket-container .qrcode-container{background-color:#444!important}.eticket-container .qrcode-container .qrcode-tip{background-color:transparent!important;color:#eee!important}.eticket-container .qrcode-container .qrcode-container-item .qrcode-hide-tip{color:#eee!important}.eticket-container .qrcode-container .ticket-code,.eticket-container .qrcode-container .ticket-code .color-gray-light,.eticket-container .qrcode-container .ticket-type,.eticket-container .qrcode-container .ticket-type .color-gray-light{color:#aaa!important}.eticket-container .qrcode-container .ticket-code span,.eticket-container .qrcode-container .ticket-type span{color:#eee!important}.eticket-container .qrcode-container .addr-map{background-color:#383838!important}.eticket-container .qrcode-container .addr-map h1{color:#eee!important}.eticket-container .qrcode-container .addr-map p{color:#aaa!important}.eticket-container .qrcode-container .addr-map .map-icon{filter:var(--pink-image-filter)!important}.orderdetail-container .orderdetail-wrapper{color:#aaa!important}.orderdetail-container .orderdetail-wrapper .wrapper-ticket{color:#eee!important}.orderdetail-container .orderdetail-wrapper .wrapper-ticket .tip{color:var(--theme-color)!important}.orderdetail-container .total-container div span{color:#eee!important}.orderdetail-container .total-container div span.total{color:var(--theme-color)!important}#biliAppHomeSetting input,#biliAppHomeSetting select,.highlight-areas-ctnr .highlight-area-item,.s_tag .btn-add,.section-block .flip-view,.share-content .video-card,.van-popover .btn-box .btn.reg-btn,.van-popover .level-bar,.van-popper-history .view-all{background-color:#444!important}.love-card .header::after{background-color:#555!important}.s_tag .btn-add span{background-color:#eee!important}.coin-dialog-mask .coin-operated .mc .mc-box{background-color:#fff!important}.card .risk-tip-content{background-color:#624f27!important}.live-room-app .aside-area .chat-history-panel-top,.manga-navbar .nav-list,.news-content,.news-ctnr .more-link,.news-ctnr .more-link:hover,.page-container,.publish-panel .editor:focus,.publish-panel .editor:focus-within,.publish-panel .editor:hover,.text-info-ctnr,.title-renew-panel .card{background-color:transparent!important}.manga-navbar .search-bar .placeholder-list .placeholder-item{color:#888!important}#biliAppHomeSetting label~span,.bb-comment .comment-list .list-item .blacklist-font-color,.center-box .line-3 .action-button,.comment-bilibili-fold .comment-list .list-item .blacklist-font-color,.container .split-line .history-tip,.follow-dialog-wrap .special-tip,.highlight-areas-ctnr .area-desc,.list-item .publish-time,.live-panel .title .count,.manga-navbar .data-list .list-container .empty-hinter,.manga-navbar .data-list .list-container .failure-hinter,.manga-navbar .data-list .list-container .loading-hinter,.rank-item .room-title,.share-content .video-card .up-info .tip,.video-container .text-area .view-danmaku,.video-desc .reprint{color:#aaa!important}#biliAppHomeSetting a,#biliAppHomeSetting input,#biliAppHomeSetting select,.manga-navbar .drop-list .more-btn-container .more-button,.manga-navbar .search-bar .search-input,.manga-navbar .user-info-panel .info-item,.manga-navbar .user-info-panel .user-name,.manga-navbar .user-panel .drop-list .logout-btn-container .logout-button{color:#eee!important}.medal-ctnr .fans-medal-item.special-medal .label .content{background-color:inherit!important}.reply .divider{border-color:#555!important}.reply .divider-last::after,.reply .divider-last::before{background-color:#555!important}.reply .divider-last span{color:#aaa!important}.share-success .success-text{color:#eee!important}.share-success .success-link{color:var(--theme-color)!important}.share-success .success-btn{border-color:transparent!important;background-color:#444!important;color:#eee!important}.center-box .line-1 .like-item,.center-box .line-1 .name-field,.center-box .line-1 .name-field a{color:#eee!important}.center-box .line-2 .im-dynamic-link{color:var(--theme-color)!important}.bb-comment .comment-send .dynamic-repost,.comment-bilibili-fold .comment-send .dynamic-repost{color:#ccc!important}.area-detail-ctnr .area-title,.banner-ctnr .banner-title,.bilibili-player-video-control .bilibili-player-video-btn-pagelist,.bilibili-player-video-control .bilibili-player-video-btn-speed,.bilibili-player-video-danmaku-setting-left-block-word,.gridview-content-container .song-intro,.item-ctnr .item-title,.love-card .header,.manga-navbar-favourite-manga .action-button,.manga-navbar-history-list .action-button,.more-ctnr,.news-content,.news-ctnr .more-link,.rank-item .room-anchor,.recommend-area-ctnr .area-name,.recommend-area-ctnr .title-text,.share-content .video-card .up-info .name,.song-padding .song-intro,.tab-ctnr .tab-item,.user-title-using-cntr .user-title-box .name,.van-popover .btn-box .btn.reg-btn,.van-popover .coins .info a,.van-popper-history .view-all,.van-popper-login .title,.van-popper-upload .upload-item .bilifont,.yzly-ctnr .yzly-title{color:#eee!important}.international-header .mini-upload:hover,.van-popover .vip:hover{color:#fff!important}.superChat-card-detail .card-item-middle-top .name,.superChat-card-detail .card-item-top-right{color:#eee!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #61c05a"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(97, 192, 90)"]{border-color:#44b0a0!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #61c05a"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(97, 192, 90)"] .label{background-color:#44b0a0!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #61c05a"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(97, 192, 90)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#44b0a0!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #61c05a"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(97, 192, 90)"] .level{color:#44b0a0!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #61c05a"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(97, 192, 90)"] .fans-medal-level{background-color:#222!important;color:#44b0a0!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #5896de"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(88, 150, 222)"]{border-color:#74b0f6!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #5896de"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(88, 150, 222)"] .label{background-color:#74b0f6!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #5896de"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(88, 150, 222)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#74b0f6!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #5896de"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(88, 150, 222)"] .level{color:#74b0f6!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #5896de"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(88, 150, 222)"] .fans-medal-level{background-color:#222!important;color:#74b0f6!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #a068f1"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(160, 104, 241)"]{border-color:#ba94f2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #a068f1"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(160, 104, 241)"] .label{background-color:#ba94f2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #a068f1"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(160, 104, 241)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#ba94f2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #a068f1"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(160, 104, 241)"] .level{color:#ba94f2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #a068f1"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(160, 104, 241)"] .fans-medal-level{background-color:#222!important;color:#ba94f2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff86b2"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 134, 178)"]{border-color:#ff86b2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff86b2"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 134, 178)"] .label{background-color:#ff86b2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff86b2"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 134, 178)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#ff86b2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff86b2"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 134, 178)"] .level{color:#ff86b2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff86b2"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 134, 178)"] .fans-medal-level{background-color:#222!important;color:#ff86b2!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff9f3d"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 159, 61)"]{border-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff9f3d"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 159, 61)"] .label{background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff9f3d"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 159, 61)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff9f3d"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 159, 61)"] .level{color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #ff9f3d"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(255, 159, 61)"] .fans-medal-level{background-color:#222!important;color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #1a544b"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(26, 84, 75)"]{border-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #1a544b"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(26, 84, 75)"] .label{background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #1a544b"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(26, 84, 75)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #1a544b"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(26, 84, 75)"] .level{color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #1a544b"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(26, 84, 75)"] .fans-medal-level{background-color:#222!important;color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #414967"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(65, 73, 103)"]{border-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #414967"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(65, 73, 103)"] .label{background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #414967"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(65, 73, 103)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #414967"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(65, 73, 103)"] .level{color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #414967"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(65, 73, 103)"] .fans-medal-level{background-color:#222!important;color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #2d0855"],.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(45, 8, 85)"]{border-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #2d0855"] .label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(45, 8, 85)"] .label{background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #2d0855"] .fans-medal-label,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(45, 8, 85)"] .fans-medal-label{background-image:none!important;color:#222!important;background-color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #2d0855"] .level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(45, 8, 85)"] .level{color:#f6be18!important}.fans-medal-item:not(.medal-guard)[style*="border-color: #2d0855"] .fans-medal-level,.fans-medal-item:not(.medal-guard)[style*="border-color: rgb(45, 8, 85)"] .fans-medal-level{background-color:#222!important;color:#f6be18!important}.fans-medal-item.medal-guard .fans-medal-level{background-color:#222!important;color:#eee!important}.highlight-areas-ctnr .highlight-area-item:nth-child(1) .area-name{color:#a0a7dc!important}.highlight-areas-ctnr .highlight-area-item:nth-child(2) .area-name{color:#c7aade!important}.highlight-areas-ctnr .highlight-area-item:nth-child(3) .area-name{color:#deb29c!important}.highlight-areas-ctnr .highlight-area-item:nth-child(4) .area-name{color:#afb7e8!important}.highlight-areas-ctnr .highlight-area-item:nth-child(5) .area-name{color:#dcbf94!important}.highlight-areas-ctnr .highlight-area-item:nth-child(6) .area-name{color:#95c5a8!important}.card-content .like-users-panel::before{background-color:#666!important}.card-content .like-users-panel .users-box,.card-content .like-users-panel .users-box .like-users-list,.card-content .like-users-panel .users-box .like-users-list:active,.card-content .like-users-panel .users-box .like-users-list:link,.card-content .like-users-panel .users-box .like-users-list:visited{color:#eee!important}.card-content .like-users-panel .suffix-text{color:#aaa!important}.live-room-app .aside-area .chat-control-panel{background-image:none!important}.charge-container{background-color:transparent!important}.charge-container .charge-header-close{filter:brightness(0) invert(1)!important}.charge-container .charge-header-bg{background-image:none!important}.charge-container .charge-header .user-link{background-color:#333!important;border-color:transparent!important}.charge-container .charge-header .user-link .user-name{color:#eee!important}.charge-container .charge-header .user-link:hover .user-name{color:var(--theme-color)!important}.charge-container .battery-item .battery-bg{background-color:#333!important;border-color:transparent!important}.charge-container .battery-item .battery-tool input{background-color:transparent!important;border-color:#444!important;color:#eee!important}.charge-container .battery-item.active .battery-bg{background-color:#444!important;border-color:var(--theme-color)!important}.charge-container .battery-item.active .battery-text{color:var(--theme-color)!important}.charge-container .battery-item.active .battery-tool input{border-color:var(--theme-color)!important}.charge-container .charge-info{color:#eee!important}.charge-container .charge-info span{color:var(--theme-color)!important}.charge-container .split-line{background-color:#444!important}.charge-container .battery-pay-info{color:#eee!important}.charge-container .battery-pay-info span{color:var(--theme-color)!important}.charge-container .battery-pay-info .battery-pay-tips span,.charge-container .battery-tips{color:#aaa!important}.charge-container .battery-tips a,.charge-container .battery-tips a:hover{color:var(--theme-color)!important}.charge-container .checkbox-bwxr.active{filter:var(--blue-image-filter)!important}.charge-container .btn-default{background-color:var(--theme-color-80)!important;color:var(--foreground-color)!important;border-color:transparent!important}.charge-container .btn-default:hover{background-color:var(--theme-color)!important}.charge-container .charge-success-content>p{color:#eee!important}.charge-container .charge-success-content>p i,.charge-container .charge-success-content>p span{color:var(--theme-color)!important}.charge-container .charge-success-content>.charge-success-message{border-color:var(--theme-color)!important}.charge-container .charge-success-content>.charge-success-message .charge-success-message-tool span{color:#aaa!important}.activity-m .inside-wrp{border-color:#444!important}.activity-m .inside-wrp .right .inside-bg::before{background-image:linear-gradient(90deg,#222,transparent 30%)!important}.activity-m .hinter-msg{color:#eee!important}.activity-m .b-btn-praise{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.activity-m .b-btn-praise.voted{color:#aaa!important;border-color:transparent!important;background-color:#333!important}.bui-switch .bui-switch-input:checked+.bui-switch-label .bui-switch-body,.bui-switch .bui-switch-name .bui-switch-reddot{background-color:var(--theme-color)!important}.bui-switch .bui-switch-input:checked+.bui-switch-label .bui-switch-body .bui-switch-dot{fill:var(--theme-color)!important}.bui-switch:hover .bui-switch-name{color:var(--theme-color)!important}.bilibili-player-video-control .bilibili-player-video-btn-setting-left-more:hover,.bilibili-player-video-control .bilibili-player-video-btn-setting-left-more:hover .bp-svgicon{color:var(--theme-color)!important;fill:var(--theme-color)!important}.june-activity-entry .progress-bar{color:#aaa!important;background-color:transparent!important;border-color:#37a29c!important}.focus-us .text{color:#6d757a!important}.main-wrap .container{box-shadow:none!important}.main-wrap .bg-circle{background-color:#444!important}.main-wrap .text-wrap,.main-wrap .version-date{color:#aaa!important}.main-wrap .info-title{color:#eee!important}.main-wrap .info-select{border-color:#555!important}.main-wrap .info-select li{color:#eee!important}.main-wrap .info-select li.active{color:var(--foreground-color)!important;background-color:var(--theme-color)!important}.channel-sidebar{background-color:#222!important;border-color:#444!important}.channel-sidebar .sidebar-search-bar{border-color:#333!important}.channel-sidebar .sidebar-search-bar .inner-input{color:#eee!important;background-color:transparent!important}.channel-sidebar .discovery-panel{border-color:#444!important}.channel-sidebar .discovery-panel__title{color:#eee!important}.channel-sidebar .discovery-panel__title.discovery-panel__title--active{background-color:#333!important}.channel-sidebar .discovery-panel__title:hover{background-color:#444!important}.channel-sidebar .discovery-panel .content-item__name,.channel-sidebar .discovery-panel__title .iconfont{color:#eee!important}.channel-sidebar .discovery-panel .content-item__count{color:#aaa!important}.channel-sidebar .discovery-panel .content-item.content-item--active{background-color:#333!important}.channel-sidebar .discovery-panel .content-item:hover{background-color:#444!important}.channel-sidebar .discovery-panel__toggle{background-color:transparent!important;color:#aaa!important}.channel-sidebar .subscribe-panel{background-color:transparent!important}.channel-sidebar .subscribe-panel__title .text{color:#eee!important}.channel-sidebar .subscribe-panel__login .hint,.channel-sidebar .subscribe-panel__title .btn,.channel-sidebar .subscribe-panel__title .count{color:#aaa!important}.channel-sidebar .subscribe-panel__login .login-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.channel-sidebar .subscribe-panel .subscribe-item--active{background-color:#333!important}.channel-sidebar .subscribe-panel .subscribe-item .cover,.channel-sidebar .subscribe-panel .subscribe-item:hover{background-color:#444!important}.channel-sidebar .subscribe-panel .subscribe-item .name{color:#eee!important}.channel-sidebar::-webkit-scrollbar{background-color:transparent!important}.discovery-container .type-header .header-info .title{color:#eee!important}.discovery-container .slide-channel-panel .arrow-btn .iconfont,.discovery-container .type-header .header-info .count{color:#aaa!important}.discovery-container .slide-channel-panel .slide .mini-channel-card{background-color:#333!important;color:#eee!important}.discovery-container .slide-channel-panel .slide .mini-channel-card .cover{background-color:#282828!important}.discovery-container .slide-channel-panel .slide .mini-channel-card .label{color:#aaa!important}.discovery-container .hot-channel-panel .change-btn{border-color:transparent!important;color:#eee!important;background-color:#333!important}.discovery-container .hot-channel-panel .change-btn img{filter:brightness(0) invert(1)!important}.discovery-container .hot-channel-panel .list .card{background-color:transparent!important}.discovery-container .hot-channel-panel .list .card .title{color:#eee!important}.detail-page-container .detail-banner:not([style*=background-color]){background-color:#444!important}#app .detail-page-container .detail-banner .relative-panel .header,.detail-page-container .detail-banner .mini-channel-card .cover,.detail-page-container .detail-banner-title .cover::before,.detail-page-container .detail-panels .van-tabs-bar::after{background-color:transparent!important}.detail-page-container .detail-panels .van-tabs-wrap .van-tabs-tab:not(.van-tabs-tab-active){color:#eee!important}.detail-page-container .detail-panels .play-selector__item,.detail-page-container .detail-panels .year-selector__item{background-color:transparent!important}.detail-page-container .detail-panels .play-selector__item:not([style*=border]),.detail-page-container .detail-panels .year-selector__item:not([style*=border]){color:#aaa!important;border-color:#444!important}.detail-page-container .detail-panels .rank-card-panel .header .title{color:#eee!important}.detail-page-container .detail-panels .rank-card-panel .header .desc{color:#aaa!important}.detail-page-container .detail-panels .rank-card-panel .toggle>span{background-color:#222!important;color:#aaa!important}.detail-page-container .detail-panels .rank-card-panel .toggle::before{background-color:#444!important}.category-container .inner-container__header .title{color:#eee!important}.category-container .inner-container__header .count{color:#aaa!important}.category-container,.detail-page-container,.discovery-container{background-color:#222!important}.category-container::-webkit-scrollbar-track,.detail-page-container::-webkit-scrollbar-track,.discovery-container::-webkit-scrollbar-track{border-color:transparent!important}.category-container .video-card__content .cover-picture,.detail-page-container .video-card__content .cover-picture,.discovery-container .video-card__content .cover-picture{background-color:#444!important}.category-container .video-card .video-name,.detail-page-container .video-card .video-name,.discovery-container .video-card .video-name{color:#eee!important}.category-container .video-card .video-name:hover,.detail-page-container .video-card .video-name:hover,.discovery-container .video-card .video-name:hover{color:var(--theme-color)!important}.category-container .video-card .up-name,.detail-page-container .video-card .up-name,.discovery-container .video-card .up-name{color:#aaa!important}.category-container .video-card .up-name:hover,.detail-page-container .video-card .up-name:hover,.discovery-container .video-card .up-name:hover{color:var(--theme-color)!important}.category-container .channel-list-preview .header-info .title,.detail-page-container .channel-list-preview .header-info .title,.discovery-container .channel-list-preview .header-info .title{color:#eee!important}.category-container .channel-list-preview .header-info .header-desc,.detail-page-container .channel-list-preview .header-info .header-desc,.discovery-container .channel-list-preview .header-info .header-desc{color:#aaa!important}.category-container .channel-list-preview .channel-btns>[class*=btn],.detail-page-container .channel-list-preview .channel-btns>[class*=btn],.discovery-container .channel-list-preview .channel-btns>[class*=btn]{border-color:var(--theme-color)!important;color:var(--theme-color)!important}.category-container .back-top-btn,.detail-page-container .back-top-btn,.discovery-container .back-top-btn{border-color:transparent!important;background-color:#333!important}.category-container .back-top-btn .arrow-icon,.detail-page-container .back-top-btn .arrow-icon,.discovery-container .back-top-btn .arrow-icon{color:#aaa!important}.category-container .back-top-btn:hover,.detail-page-container .back-top-btn:hover,.discovery-container .back-top-btn:hover{background-color:var(--theme-color)!important}.category-container .back-top-btn:hover .arrow-icon,.detail-page-container .back-top-btn:hover .arrow-icon,.discovery-container .back-top-btn:hover .arrow-icon{color:var(--foreground-color)!important}.international-home .contact-help{color:#999!important;background-color:#333!important;border-color:transparent!important;box-shadow:0 6px 10px 0 #111!important}.bili-header-m .mini-type .nav-search #nav_searchform,.international-header .mini-type .nav-search #nav_searchform,.van-popover .mini-type .nav-search #nav_searchform{background-color:#333!important;border-color:transparent!important}.bili-header-m .mini-type .nav-search #nav_searchform .nav-search-keyword,.international-header .mini-type .nav-search #nav_searchform .nav-search-keyword,.van-popover .mini-type .nav-search #nav_searchform .nav-search-keyword{color:#aaa!important}.bili-header-m .mini-type .nav-search #nav_searchform .nav-search-keyword:focus,.international-header .mini-type .nav-search #nav_searchform .nav-search-keyword:focus,.van-popover .mini-type .nav-search #nav_searchform .nav-search-keyword:focus{color:#eee!important}.bili-header-m .mini-type .nav-search .nav-search-btn,.international-header .mini-type .nav-search .nav-search-btn,.van-popover .mini-type .nav-search .nav-search-btn{background-color:#444!important}.bili-header-m .mini-type .nav-search .nav-search-btn .nav-search-submit,.international-header .mini-type .nav-search .nav-search-btn .nav-search-submit,.van-popover .mini-type .nav-search .nav-search-btn .nav-search-submit{color:#eee!important}.bili-header-m .mini-type .nav-search .nav-search-btn:hover .nav-search-submit,.international-header .mini-type .nav-search .nav-search-btn:hover .nav-search-submit,.van-popover .mini-type .nav-search .nav-search-btn:hover .nav-search-submit{color:var(--theme-color)!important}.most-viewed-panel>.icon{fill:#666!important}.most-viewed-panel>.icon.active{fill:#aaa!important}.most-viewed-panel>.icon.active:hover{fill:var(--theme-color)!important}.most-viewed-panel .most-viewed-item .section .avatar{border-color:#444!important;box-shadow:0 0 0 1px transparent!important}.most-viewed-panel .most-viewed-item .section .avatar.active{box-shadow:0 0 0 1px var(--theme-color)!important}.most-viewed-panel .most-viewed-item .section .icon-all{background-color:var(--theme-color-30)!important;border-color:#444!important;box-shadow:0 0 0 1px transparent!important}.most-viewed-panel .most-viewed-item .section .icon-all.active{box-shadow:0 0 0 1px var(--theme-color)!important}.most-viewed-panel .most-viewed-item .section .icon-all .icon{fill:var(--theme-color)!important}.most-viewed-panel .most-viewed-item .icon-bg-1 .icon-bg-2{background-color:var(--theme-color-10)!important;border-color:#444!important}.most-viewed-panel .most-viewed-item .icon-bg-1 .icon{fill:var(--theme-color)!important}.most-viewed-panel .most-viewed-item .icon-bg-1 .avatar{background-color:#222!important;border-color:#444!important}.most-viewed-panel .most-viewed-item .icon-bg-1.active{background-color:var(--theme-color)!important}.most-viewed-panel .most-viewed-item .icon-bg-1.active .icon-bg-2{background-color:rgba(64,64,64,.875)!important}.live-up .live-up-img{box-shadow:0 0 0 1px var(--theme-color)!important;border-color:#444!important;background-color:#222!important}.bilibili-search-history,.bilibili-search-suggest{background-color:#333!important;border-color:transparent!important}.module-game .rule .detail .content{color:#000!important}#biliAppHomeSetting input,#biliAppHomeSetting select{border-color:transparent!important;border-radius:4px}#gift-package-item-box .panel-wrapper::before,.at-popup,.chat-popups-section .draw-full-ctnr,.hover-panel-wrap,.hover-panel-wrapper,.recommend-area-ctnr .rec-area-item,.title-renew-panel .actions,.van-popper-history .view-all,.van-popper-login .btn-box .btn{border-color:transparent!important}.wide-members .avatar{border-color:#333!important}#page-fav .fav-sidenav .icon:not(.icon-cursor),.container .level-intro .svg-icon,.manga-navbar .search-bar .confirm-btn .search-icon{filter:brightness(0) invert(1)!important}.side-bar-btn .size-bar-text{filter:brightness(.6) invert(1) hue-rotate(180deg)!important;text-shadow:0 0 0}#link-message-container .config{box-shadow:none!important}.confirmorder-container .confirm-bottom .confirm-paybtn.active,.whole-detail-info-wrapper .product-buy-wrapper .unsale-btn{box-shadow:0 3px 4px 0 #6e4752!important}.app-layout .manga-navbar{box-shadow:rgba(0,0,0,.2) 0 4px 8px 0!important}.highlight-areas-ctnr .highlight-area-item.hover{box-shadow:0 7px 11px 0 rgba(0,0,0,.18)!important}.hover-panel-wrap{box-shadow:0 13px 20px 0 rgba(0,0,0,.22)!important}.van-popper .popper__arrow{display:none!important}.nav-tab-bar .tab-item[data-tab-id="1"]:not(.on)::before{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAQAAAACj/OVAAAD00lEQVRYw+2YbWhVdRzHb2aWsILo4UVC5Pd3drfdIZNW1sRod7eW1gSxLIxo5aWgB1GHbkNaDILoAaJYtKQNRDHQTcp6McQoISusXuSLZTXXICVoa3Nmtu0+nE8vdtzd1T3c7dzzzu/31b2X+//w+//+5/y+54RCVzSLKq+zqD1t9driPB4uCxjm3G+f6ILI2E7bu+ElgcB0u3UJIXcd23mT19jMqnHsiF6vXJjv2iqtX5S5HzDAZHWzFbnCjjq35BFnK21UxBlmKv3ESlfoRKQgf5vZL17F9QBDfMkRkpOQf1ON0Of5qm+/iHu4f2jEQYhDWVWeptwVzmN5wIVXiFL3LwB6qEAYMRou6SXsR1jvhqv919cq3gIgyVpEDT9P2UmXGMKiPnFcpT/FLwC0Ie5hiOn0DsJafAKLbhMrvAUfRbQxvX5A2Dd+O3i3WOcteC/ixxmAZxDq89vBKvGUt+Au6iYujak0jNCg3ztMRDxEbvoNYd1+gTfILXHHcgJ2IazL/2XxnTiSE3AbwqnzD9whanPA9RNxRdFS38BlN2pQfDUrsB5hB/Jz894qyt0/ZsQdQNhoofICbF6gz0SUnmlxnYRdYc/kbR5GCnRcLHP3kboMNkAjQjjNeY5O2itElBa6GfNG1VGaiLhCI1ab/0wTEzYRnpYTyUSpzqKiAEKU7RJvJz5idQZ1VsetySkNJo0utAHxKwCfIuzrisXBJtJqUe0dk+cQeiHgCKw28Z53VIpRym4NFFd+jQbFKQAOIuyLgOuzNWKNt6GbEPZ80MDd4n1vyFrCkuGbA8VFFums6Ju4Z+pwwPUV1ogab0NrEc6mvCPCZc5L1qp2zz1iOTFixHBQWnvVrnZrceJ5mQ6RAmuVO/kZcHrbmL3iO2vbx6KUnYl9dNBBB7tpyHKL9/0etiSUFtbkD7dalLl9Oea0b91CLGGOH+AesYonc/ZdiKU75/2cZMdy691lvTzo2Dwyto2JZTzAxjlU+ASVlCBsoDg8t+qW2DnR9N8Ic9cQ8YSw3sii2UbOtU6FnnXiTtyJO4dEufvycD3zcR02IuzD8bWsquj6qWq6T7/Pr2M5eEgbL+2YY+dFdbqBRuqTm89FU9FkllNV6ap0VTrmXnTm0/gvWf9IRVPRVHVy2/kdifrU+qSQW/hg9kDtFNtnfPjyo1aETk7CVSzWvw6DBKcKRGFJ5risFesJUg0INWZFvpZAgYcRdiwDPCO6AwVeoBilim8a39BScSen6A3Uj4wKZ0MoFAqFiu/Idd759sMXD82LOqGTAft7543mBVfeoAeg/wFlFeKImou+wAAAAABJRU5ErkJggg==)!important}.aside-item.active .item-border,.aside-item:hover .item-border{border-color:var(--theme-color)!important}.aside-item::after{border-right-color:var(--theme-color)!important}#bilibili_pbp,#bilibili_pbp_canvas{filter:var(--blue-image-filter)!important}#biliAppHomeSetting button,.bui-button.bui-button-gray:hover,.interact-dialog .btn,.live-up .live-up-img-box,.rookie-guide .close-button,.shortcuts-ctnr .hinter,.shortcuts-ctnr .num-hinter,.user-panel-ctnr .msg-count,.user-panel-ctnr .msg-hinter,.van-popover .btn-box .btn,.van-popper-history .view-all:hover{background-color:var(--theme-color)!important}#biliAppHomeSetting h2,.bilibili-player-video-btn-speed-menu-list.bilibili-player-active,.bilibili-player-video-toast-item .video-float-hint-btn.hint-red,.bilibili-search-suggest .suggest-item .suggest_high_light,.more-ctnr:hover,.new-topic-panel .tag-item .content:hover,.news-ctnr .more-link:hover,.tab-ctnr .tab-item.activated,.tab-ctnr .tab-item:hover,.van-popover .coins .info a:hover,.van-popper-upload .upload-item:hover .bilifont,.video-desc .subtitle a{color:var(--theme-color)!important}#biliAppHomeSetting button,.bui-button.bui-button-gray:hover,.interact-dialog .btn,.rookie-guide .close-button,.user-panel-ctnr .msg-count,.van-popover .btn-box .btn,.van-popper-history .view-all:hover{color:var(--foreground-color)!important}.festival-main-panel~.video-toolbar{color:#ffd886!important}.festival-main-panel~.video-toolbar .share-box .title{color:#eee!important}.festival-main-panel~.video-toolbar .share-box .box-b-title,.festival-main-panel~.video-toolbar .share-box .name{color:#aaa!important}.festival-main-panel~.video-toolbar .more-list{border-color:transparent!important;background-color:#222!important;color:#eee!important}.festival-main-panel~.video-toolbar .more-list li:hover{color:var(--theme-color)!important;background-color:#444!important}.festival-main-panel~.comment-wrapper .comment-m{background-color:#222!important}.festival-video-player .bilibili-player.bilibili-player-theme-red .bui-slider .bui-track .bui-bar-wrap .bui-bar.bui-bar-normal{background-color:var(--theme-color)!important}#danmukuBox[style*="background:#B22D43"i] .bui-collapse-header{background-color:#b22d43!important}#danmukuBox[style*="background:#B22D43"i] .player-auxiliary-filter-menu,#danmukuBox[style*="background:#B22D43"i] .player-auxiliary-filter-title{color:#ffd886!important}.app-section .game-box~.videos-box .video-title{color:#872339!important}.app-section .game-box~.footer-box .comment-container{background-color:transparent!important}.coin-dialog-wrapper .coin-title span,.coin-dialog-wrapper .van-icon-guanbi:hover{color:var(--theme-color)!important}.coin-dialog-wrapper .coin-card-box.on,.coin-dialog-wrapper .coin-card-box:hover{border-color:var(--theme-color)!important}.coin-dialog-wrapper .like-checkbox i{filter:var(--blue-image-filter)!important}.coin-dialog-wrapper .coin-bottom .confirm-btn{background-color:var(--theme-color)!important;border-color:var(--theme-color)!important}.collection-wrapper{background-color:#222!important}.collection-wrapper .title{color:#eee!important;border-color:#444!important}.collection-wrapper .content{color:#eee!important}.collection-wrapper .content .group-list li:hover{color:var(--theme-color)!important}.collection-wrapper .content .group-list .collection-mask{background-color:rgba(51,51,51,.5)!important}.collection-wrapper .content .add-group .add-btn{border-color:#444!important;background-color:#444!important}.collection-wrapper .content .add-group .input-group{border-color:var(--theme-color)!important}.collection-wrapper .content .add-group .input-group input[type=text]{background-color:#222!important;color:#eee!important}.collection-wrapper .content .add-group .input-group .submit{border-left-color:var(--theme-color)!important;color:#eee!important;background-color:var(--theme-color-20)!important}.collection-wrapper .bottom{border-top-color:#444!important}.collection-wrapper .bottom .btn{color:#eee!important;background-color:var(--theme-color)!important}.collection-wrapper .bottom .btn.disable{color:#aaa!important;background-color:#444!important}`;offlineData["https://raw.githubusercontent.com/the1812/Bilibili-Evolved/master/min/dark.user.css"]=`/* ==UserStyle==\n@name         Bilibili Evolved - 夜间模式\n@namespace    Bilibili-Evolved\n@homepageURL  https://github.com/the1812/Bilibili-Evolved\n@updateURL    https://cdn.jsdelivr.net/gh/the1812/Bilibili-Evolved@preview/min/dark.user.css\n@version      1246.26.0\n@license      MIT\n@author       Grant Howard (https://github.com/the1812), Coulomb-G (https://github.com/Coulomb-G)\n==/UserStyle== */\n@-moz-document domain("bilibili.com") {\n  #app .header,#app .submit,#id-card,#page-fav .fav-sidenav .fav-item:hover,#page-fav .fav-sidenav .icon-cursor,#page-setting #setting-new-tag,#page-setting .setting-tag-list a,#page-video #submit-video-type-filter,#pin-wrapper #pin-layer,#sections-vm .section-block,.action-menu .menu-list,.action-menu .menu-list:before,.activity-item-ctnr .user-avatar,.activity-item-loading-ctnr .info-ctnr .first-line,.activity-item-loading-ctnr .info-ctnr .second-line,.activity-item-loading-ctnr .user-avatar,.advanced-danmaku-group .adv-danmaku-btn-span,.advanced-danmaku-group .adv-danmaku-btn-span.bpui-button-type-small,.app-watch,.appeal-box,.article-container,.attention-btn-ctnr .right-part,.audio-info-module,.audio-list .song-list .song-li .content .text,.audiolist-list .song-list .song-li .content .text,.awarding-panel,.b-line>p>span,.backdrop .title-box,.backdrop iframe,.ban-app,.bangumi-container,.bangumi-info-module,.base-bubble,.base-bubble .content-ctnr:before,.bb-comment .nameplate .nameplate-card,.be-dropdown-menu,.be-pager-item,.be-pager-next,.be-pager-options-elevator input[type=text],.be-pager-prev,.bili-footer,.bilibili-live-player-loading-panel,.bilibili-player-block-line,.bilibili-player-block-string-short,.bilibili-player-block-tabpanel .bilibili-player-block-tabpanel-row.bilibili-player-border,.bilibili-player-color-picker-color-code,.bilibili-player-color-picker-container,.bilibili-player-danmaku-date-picker-container,.bilibili-player-modal-container,.bilibili-player-mode-selection-container,.bilibili-player-video-btn-setting-panel,.bilibili-player-video-danmaku-setting-box,.bilibili-player-video-danmaku-setting-left,.bilibili-player-video-danmaku-setting-right,.bilibili-player-video-inputbar,.bilibili-player-video-panel,.bilibili-player-video-progress-detail-time,.bilibili-player-video-volumebar-wrp,.bl-button--ghost,.bottom .content,.bpm-btn,.bpui-selectmenu-list,.bpui-selectmenu-list-row[data-selected],.bui-input-input,.bui-input-wrap-disabled,.bui-select .bui-select-border,.bui-select-list,.calendar-checkin .checkin-btn:active,.card .focus-btn .focus,.card .focus-btn .unfocus,.card .more-panel,.card .more-panel:after,.chat-history-panel .chat-history-list .chat-item.system-msg,.choice-item,.choice-item.active,.choice-item:hover,.coin-operated-m,.collection-m,.comment-bilibili-con,.comment-wrap,.common-popup-wrap,.contribution-sidenav .contribution-item:hover,.count-choice,.deleted,.download-panel-ctnr .download-item:hover,.dynamic-btn.pink.disabled,.dynamic-link-hover-bg:hover,.dynamic-m,.emoji,.emoji-box,.emoji-box:after,.emoji-tabs,.emotion-box,.emotion-box:after,.error-wrap,.fans-action-btn,.fans-action-follow,.fans-medal-item:not(.medal-guard) .fans-medal-level,.fixed-top,.fixed-top .search-block .input-wrap,.follow-dialog-window,.follow-sidenav .follow-list-container .follow-item:hover,.footer-wrp,.g-search input,.gift-item.buy.hover,.gift-presets .gift-panel-switch,.gift-sender-panel,.guard-rank-cntr .rank-cntr .btn-box .buy:hover,.gui-settings-box,.h5share-container .text-area,.history-list .r-info,.history-tag,.home-wrap .home-input .list li:hover,.home-wrap .home-suggest .hotlist .num,.hover-panel,.imagesbox .boost-control,.imagesbox .boost-img,.img-content,.info-model,.link-footer,.link-input,.list-create,.live-container,.live-player-ctnr.minimal,.modal-wrapper,.mode .selection-span,.multi-page .cur-list li.on,.multi-page .cur-list li.on:hover,.multi-page .more-box,.music-container .image-area .share-img,.music-container .text-area,.my-album .tab-list,.not-support,.page-jump>input,.page-wrap .pager,.pagination,.predefined-colors,.radio-icon.selected,.rank.rank-10,.rank.rank-4,.rank.rank-5,.rank.rank-6,.rank.rank-7,.rank.rank-8,.rank.rank-9,.repost,.result,.result .row,.right-side-bar .to-comment .comment-num,.select-wrap .select-option,.select-wrap .select-txt,.small-item .cover,.space-right,.sticky-bar,.sub-nav,.suggest-wrap .horizontal .hz-text,.suggest-wrap .vt-text.focus,.suggest-wrap .vt-text:hover,.tab-contain,.tag-info-pane,.textarea-container .comm-tool .comm-emoji,.user-card,.user-card-m,.user-item-loading .avatar,.user-item-loading .username,.user-level-detail .detail-link:active,.user-level-detail .detail-link:hover,.user-panel .level-progress,.user-panel .logout-btn:active,.userinfo-content,.video-container,.video-info-module,.video-model,.video-toolbar .share .share-pos .share-address ul li input,.vote-container .image-area .share-img,.vote-container.pointer,.vote-user-face,.voted-result,.watch-later-list header .d-btn,.wrapper .content,.wrapper .modal-body .choice-wrp .battery,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,div.bilibili-player-auxiliary-area,div.box,div.bubble-traditional,div.con,div.danmaku-wrap,div.dd-bubble,div.desc-tips,div.dyn_list_wrapper,div.i-frame,div.im-list-box,div.live-box,div.member-bottom,div.stardust-player,div.ver span.tips,form.ipt,p.num,span.date,textarea,ul.bilibili-suggest,ul.dyn_list,ul.up-nav,ul.up-nav li{background-color:#222!important}#app .submit .cancel,#page-channel-index .channel-option.no-channel,#page-dynamic .col-2 .section,#page-fav .fav-main .search-input input,#page-follows .follow-main .follow-action-bottom .follow-action-fixtop,#page-index .album .content .album-wrapper .album-item .album-top,#page-index .col-1,#page-index .col-2 .section,#page-setting .setting-index-module,#pin-wrapper #pin-layer-search,.activity-pushing-out,.add-btn,.app-look,.area-list-panel,.article-list-holder-block .article-list-plane,.back-top.icon,.ban-detail .content-box .info-wrap,.ban-detail .content-box .major-content,.ban-detail .content-box .vote-cnt,.ban-modal,.ban-modal-h5,.bb-comment .comment-list .quote,.be-dropdown-item:hover,.be-input_inner,.bg-white,.bili-dropdown,.bili-header-m .mini-wnd-nav .list li:hover,.bili-header-m .profile-m .grade .bar,.bilibili-live-player-ending-panel-recommend-card-pic,.bilibili-player-adv-danmaku,.bilibili-player-block-line:hover,.bilibili-player-context-menu-container,.bilibili-player-danmaku-btn-danmaku,.bilibili-player-danmaku-btn-date,.bilibili-player-danmaku-btn-history,.bilibili-player-danmaku-btn-time,.bilibili-player-danmaku-function,.bilibili-player-danmaku-wrap,.bilibili-player-filter-wrap.bilibili-player-block,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-setting-menu-list,.bilibili-player-setting-menu-wrap,.bilibili-player-video-progress-buffer,.bl-switch,.bp-popup-panel,.bpui-button.bpui-button-type-small,.bpui-selectmenu-list-row:hover,.bpui-slider-tracker,.btn-box .like,.btn-box .liked,.btn-box .message,.btn-cancel,.btn.default,.btn.followed .b-gz,.btn.ghost,.bui-button.bui-button-transparent,.bui-radio .bui-radio-button .bui-radio-label,.c-clink,.calendar-checkin,.calendar-checkin .calendar-wrapper,.calendar-checkin .checkin-btn,.calendar-checkin .checkin-rewards,.calendar-checkin .checkin-rewards .query,.calendar-checkin .content-ctnr.ie-fix,.calendar-checkin .title,.calendar-checkin:hover,.card,.card .box,.checkbox,.col-full,.collection-m .bottom .btn.disable,.comment-area,.comment-area .comm-main .comm-list .hot-line>span,.comment-area .comm-more a.more:hover,.content-box .watermark-wrap .watermark,.download-panel-ctnr,.dropdown-list,.dyn_list li .preview,.elec .elec-status,.ema-wishing,.emoji-box .emoji-item:hover,.emoji-cover.selected,.emoji-text:hover,.emoji:hover,.emotion-item:hover .img,.fans-info .fans-progress,.feed-card .empty-content,.feed-tag .publish-panel-container,.fjw-point,.float-nav .nav-menu .item,.follow-btn,.fontsize .selection-span,.forw-area,.gift-presets .gift-panel-box,.go-top .tag-panel .more-button .more:hover,.go-top-m .go-top,.history-btn>.btn,.home-wrap .home-input .content,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-input .type.selected,.home-wrap .home-input .type:hover,.home-wrap .home-suggest .history,.home-wrap .home-suggest .hot-search,.left-container .gift-control-section,.left-container .head-info-section,.link-more,.link-panel-ctnr,.live-panel,.load-error-panel,.load-more-btn,.mCSB_draggerRail,.message-list,.more-link,.more-ops-list,.multi-page,.n .n-inner,.nav-list,.notice-item,.notice-panel,.num-tip,.opera-list,.page-controller .next:hover,.page-controller .prev:hover,.pager .pages .page-item button,.paginator .paging-box .result,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.percentage-bar,.photo-list .photo,.player-and-aside-area .aside-area,.player-and-aside-area .aside-area .rank-list-section,.process-bar,.ps.ps--in-scrolling.ps--x>.ps__scrollbar-x-rail,.ps.ps--in-scrolling.ps--y>.ps__scrollbar-y-rail,.ps:hover.ps--in-scrolling.ps--x>.ps__scrollbar-x-rail,.ps:hover.ps--in-scrolling.ps--y>.ps__scrollbar-y-rail,.ps:hover>.ps__scrollbar-x-rail:hover,.ps:hover>.ps__scrollbar-y-rail:hover,.publish-panel,.radio-icon,.rank-cntr .item.own,.rank-item>.ri-num,.rank-list-ctnr .own,.rank-list-ctnr .tabs,.read-push,.recommend-list .rec-footer,.right-side-bar .to-comment,.right-side-bar .to-top,.room-info-ctnr .content-wrapper,.s-space .wrapper .content,.score-progress-bar,.search-wrap .search-block .input-wrap,.search-wrap .search-block .input-wrap input,.section-block,.select-wrap .select-option p:hover,.selector,.selector .data-list,.selector .data-list>li:hover,.send-box,.slim-video-card .video-info,.sortable,.space-left,.space-right .space-right-top .title,.sub-nav li:hover,.suggest-wrap,.suggest-wrap .title span,.synthetical .play-btn,.tab-bar,.tab-link.on,.tag-info-pane .tag-header .btn-subscribe,.tag-info-pane .tag-header .btn-unsubscribe,.tag-panel,.totally-empty-hint,.up-article-list-block .more-article,.up-info .btn .b-cd,.up-info-holder .fixed-box .rightside-article-list-btn,.user-level-detail,.user-list .up-item .attention-btn.followed,.user-list .up-item .attention-btn.followed:hover,.user-panel,.user-panel .logout-btn,.user-panel-ctnr .user-panel .lens-ctnr,.video-page-card .card-box .info .pre-mask,.video-page-card .card-box .pic-box,.video-page-operator-card .card-box .pic-box,.video-toolbar .share .share-pos,.video.list .type,.video.matrix,.what-ban .text-con,.wrapper .elec-btn.disabled,.wrapper .modal-header .u-info,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,a.im-list:hover,a.more,a.more.tc-slate:hover,a.read-more,a.s-btn,button.submit-button.disabled,div.drag-bar,li.d-data:hover,li.suggest-item.focus,li.suggest-item:hover,li.tag,p.update>span>a,ul.up-nav li:hover{background-color:#444!important}.article-list-holder-block .article-list-plane .button:hover,.be-switch,.bilibili-player-filter,.bpui-selecting,.bpui-unselecting,.brief a:hover,.btn-box .message:hover,.btn-cancel:hover,.btn.default:hover,.bui-collapse-header,.bui-select .bui-select-item:hover,.bui-switch .bui-body,.context-menu-a:hover,.danmaku-info-block-btn,.danmaku-info-report-btn,.live-lr .banner a:hover,.multi-page .cur-list li:hover,div.all>a:hover,div.brief>a:hover,li.context-menu-descipline a{background-color:#555!important}.bui-step-dot,.ps>.ps__scrollbar-x-rail>.ps__scrollbar-x,.ps>.ps__scrollbar-y-rail>.ps__scrollbar-y{background-color:#aaa!important}.bpui-slider-handle{background-color:#eee!important}#app,.bilibili-player-video-inputbar,.large-item .cover,.wrapper .modal-header,body{background-image:none!important}.bilibili-player-advanced-danmaku-control-container.mask:after,.bilibili-player-color-picker-mask,.elevator-module .nav-bg{background-color:#222e!important}#app,.article-holder .cover-default,.article-holder img,.back-top,.bb-comment,.bb-comment .comment-list .list-item .info .operation,.divider,.fans-medal-item .level,.fjw-point .line,.list-item .close .close-icon,.my-info .info-modal .integral li .num,.right-part .user-panel,.shortcut-item .list-item:hover,.side-bar-cntr,.wrapper.clearfix .content,font>span{background-color:transparent!important}.bilibili-player-video-sendbar .bilibili-player-video-inputbar{background:#fff1!important}.gui-settings-content-top-mask{background:linear-gradient(to bottom,#222,transparent)}.gui-settings-content-bottom-mask{background:linear-gradient(to top,#222,transparent)}.room-bg::after,.user-panel .level-progress .progress-bar{background:0 0!important}#id-card .idc-auth-description,#page-fav .fav-main .fav-meta,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item i,#page-fav .fav-sidenav .nav-title .text,#page-index .channel .empty-state p,#page-index .col-2 .section .user-auth.no-auth .no-auth-title span,#page-index .section.empty:after,.anonymous,.area-link,.article-action .coin-btn .info-block span,.article-action .fav-btn .info-block span,.article-action .like-btn .info-block span,.article-action .share-btn .info-block span,.article-con,.article-list-holder-block .article-list-plane .button .title,.article-list-holder-block .article-list-plane .button.off .label,.article-wrap .article .desc,.attention-btn-ctnr .right-part,.ban-detail .content-box .bk-user-info .time,.ban-detail .content-box .link-box,.bangumi-rank-list .rank-item .ri-total,.bb-comment .comment-list .list-item .info .plad a,.bb-comment .nameplate .nameplate-card .nameplate-text .n-type,.be-pager-item a,.be-pager-item-jump-next,.be-pager-item-jump-prev,.be-pager-next,.be-pager-next a,.be-pager-options-elevator,.be-pager-prev,.be-pager-prev a,.be-pager-total,.bili-footer,.bili-footer a,.bilibili-player-block-empty,.bilibili-player-block-filter-image,.bilibili-player-block-filter-label,.bilibili-player-block-line-delete,.bilibili-player-block-line.block-state-disabled,.bilibili-player-block-list-function>div,.bilibili-player-danmaku-btn-danmaku,.bilibili-player-danmaku-btn-date,.bilibili-player-danmaku-btn-time,.bilibili-player-danmaku-date-picker-btn,.bilibili-player-danmaku-date-picker-header,.bilibili-player-video-info,.block-setting-ctnr .sub-title,.boost-control li,.boost-control li i,.bottom .text,.btn-box .liked,.btn.followed .b-gz,.card-live-module .num,.case-list .info .type .bk-title,.case-list .info dl dt,.chat-item.danmaku-item .user-name,.cm-model .report-detail .detail .name,.collection-m .bottom .btn.disable,.comment-area .comm-main .comm-list .hot-line>span,.comment-bilibili-con .reason-box dl dt,.comment-list .list-item .reply-box .view-more,.comment-m .b-head .del-log,.content-box .origin-text,.content-box .punish-title .rule-content,.danmaku-info-row,.day-span,.dynamic-list-item-wrap .info>span,.dynamic-list-item-wrap .item-user a.user-name,.dynamic-list-item-wrap .item-user a.user-name.vip,.dynamic-list-item-wrap .view-more,.elec .elec-status,.emoji-box .emoji-title,.fans-action-follow,.filter-wrap .fold,.fjw-point .point-wrap .user-point .info .usr-zan-cai span,.float-nav .nav-menu .item,.follow-main .follow-action-bottom .select-counter,.follow-sidenav .num,.forw-area .forw-more a,.gift-info-desc,.gift-info-expScore,.history-list .l-info .lastplay-time .lastplay-t,.history-list .r-info .w-info .name,.history-list .r-info .w-info .pro-txt,.i-live .i-live-fo-count,.i-live .i-live-unfo-btn,.i-pin-desc,.i-pin-meta,.info .sign,.is-max .option-vote,.jury-graph-wrap .canvas-txt h4,.jury-graph-wrap .graph-status .illegal b,.jury-graph-wrap .graph-status .legal b,.lightgray,.list .list-title,.list-content-candidate,.list-item .auth-description,.list-item .desc,.live-module .zone-title .headline .fire,.live-module .zone-title .headline .online,.live-player-ctnr.minimal::before,.live-status-label.preparing,.live-wrap .headline .user-more,.looked,.medal-box,.mode .selection-span,.more-button,.msg-more,.multi-page .head-con .range-box .paging li,.multi-page .head-con .range-box i,.multi-page .more-box li,.n .n-data .n-data-k,.n .n-num,.nav-wrap .wrap>.sub>span,.no-more,.page-controller .next.disabled,.page-controller .prev.disabled,.pgc-list .synthetical .score .user-count,.pophover>p:last-child,.private-hint,.pub-list .info .comment,.pub-list .info .type .bk-title,.pub-list .info dl dt,.rank-cntr .tip,.rank-list-ctnr .tabs .item,.recommend-list .rec-footer,.report-con dl dt,.right-action-ctnr,.right-side-bar .to-comment .comment-num,.room-feed .tabs .item,.room-info-down-row .icon-label,.room-owner-username,.sec-empty-hint,.section .operation,.section-title h2,.share-to-dynamic,.side-bar .list .item,.slim-video-card .video-info .col,.slim-video-card .video-info .col-2,.so-icon,.spread-module .num,.submit-button.disabled,.suggest-wrap .title span,.synthetical .des,.tab-candidate,.tab-list .tb-item,.tabs a,.tag-info-pane .tag-footer .btn-left-box>a,.tag-info-pane .tag-header .btn-unsubscribe,.tc-slate,.textarea-container .comm-tool .comm-transpond,.top .time,.total-wrap .total-text,.up-info-block .up-info-right-block .fans-num,.up-info-block .up-info-right-block .row-2,.up-info-block .up-info-right-block .view-num,.up-info-holder .fixed-box .rightside-article-list-btn .title,.user-list .up-item .attention-btn.followed,.user-list .up-item .attention-btn.followed:hover,.user-list .up-item .up-videos .ptime,.user-panel .ctrl-btn,.video-desc .btn span,.video-toolbar,.video-toolbar .ops .share-btn i,.video-toolbar .ops .share-pos,.video-toolbar .ops>span,.video-toolbar .share .share-btn,.video.list .des,.vote-introduction,.vote-user-name,.watch-later-list header .d-btn,.what-ban .text-con .txt,.wrapper .edit-video-modal .edit-video-subtitle,.wrapper .edit-video-modal .target-favlist .target-fav-count,.wrapper .edit-video-modal .target-favlist .target-favitem.disabled span,.wrapper .modal-body .elec-bcoin,.wrapper .modal-body .elec-protocol,.wrapper .modal-body .elec-protocol a,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,.wrapper .pay-qrcode-wrp .refresh-btn,a.message,a.pic>p.title,body,div.desc,div.desc-tips,div.drag-bar,div.play-up-copyright,div.r.p>div.info,span.copyright,span.disabled,span.hate span,span.like span{color:#aaa!important}#app .container,#app .header,#app .submit .cancel,#id-card .idc-meta-item,#id-card .idc-uname,#page-article .row .breadcrumb .item,#page-channel-index .channel-item .channel-name,#page-channel-index .channel-option.no-channel p,#page-fav .fav-main .filter-item,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item span,#page-fav .fav-main .search-input input,#page-fav .fav-main .search-types,#page-fav .fav-sidenav .text,#page-index .album .content .album-wrapper .album-item .album-title,#page-index .channel.guest .channel-item .channel-title .channel-name,#page-index .col-2 .section .user-auth .auth-description,#page-setting #setting-new-tag,#page-setting .setting-privacy-item .setting-privacy-name,#page-video #submit-video-type-filter a,#pin-wrapper #pin-layer-search,#pin-wrapper .pin-layer-header,#pin-wrapper .pin-layer-order-tip,.action-menu .menu-list a,.activity-rank-cntr .rank-cntr .item,.add-btn,.advanced-danmaku-group .adv-danmaku-btn-span,.advanced-danmaku-group .adv-danmaku-pos-row .axias-span,.advanced-danmaku-group .adv-danmaku-pos-row .pos-span,.advanced-danmaku-group .content-span,.app-look,.app-watch .title,.article-action .coin-btn .info-block label,.article-action .fav-btn .info-block label,.article-action .like-btn .info-block label,.article-action .share-btn .info-block label,.article-container .text-area .title,.article-holder,.article-holder .color-default,.article-holder .video-holder .title,.article-holder h1,.article-info-container .desc,.article-info-container .title,.article-list-holder-block .article-list-plane .button .label,.article-title,.article-wrap .article .title,.audio-list .song-list .song-li .content .text,.audio-list .song-list .song-li .content .text a,.audiolist-list .song-list .song-li .content .text a,.awarding-panel,.ban-detail .content-box .bk-text-con,.ban-detail .content-box .bk-user-info .name,.ban-detail .content-box .punish-title,.bangumi-container .text-area .title,.bangumi-info-module .v-preview .title,.bangumi-list .synthetical .des .type-s,.base-bubble,.bb-comment .comment-header .tabs-order li,.bb-comment .hot-line span,.bb-comment .reply-notice .notice-item a,.be-dropdown-item,.be-input_inner,.be-pager-options-elevator input[type=text],.be-tab-item,.bili-dropdown,.bili-header-m .mini-wnd-nav a,.bilibili-player-block-label,.bilibili-player-block-line,.bilibili-player-block-string-short,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row .bilibili-player-block-type-user,.bilibili-player-color-picker-color-code,.bilibili-player-danmaku-btn-history,.bilibili-player-filter-menu,.bilibili-player-filter-title,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-modal-info,.bilibili-player-modal-title,.bilibili-player-setting-menu-list,.bilibili-player-video-btn-setting-panel-playtype-title,.bilibili-player-video-btn:hover,.bilibili-player-video-btn:hover .bilibili-player-iconfont,.bilibili-player-video-danmaku-input,.bilibili-player-video-danmaku-setting-left-area-title,.bilibili-player-video-danmaku-setting-left-block-title,.bilibili-player-video-danmaku-setting-left-fontsize-title,.bilibili-player-video-danmaku-setting-left-more-text,.bilibili-player-video-danmaku-setting-left-opacity-title,.bilibili-player-video-danmaku-setting-left-speedplus-title,.bilibili-player-video-danmaku-setting-right,.bilibili-player-video-danmaku-setting-right-more,.bilibili-player-video-progress-detail-time,.bilibili-player-video-time-seek,.bl-button--ghost,.block-content,.block-setting-row .setting-label,.block-setting-row .setting-value,.bpui-button.bpui-button-type-small,.bpui-selectmenu-list-row,.breadcrumb .batch,.breadcrumb .item.cur,.btn-box .like,.btn-cancel,.btn.default,.btn.ghost,.btns-profile span,.bui-button.bui-button-transparent,.bui-checkbox-name,.bui-collapse-arrow,.bui-input-input,.bui-input-wrap-disabled,.bui-radio-label .bui-radio-text,.bui-select .bui-select-border,.c-clink,.calendar-checkin .calendar-wrapper,.calendar-checkin .checkin-btn,.card .focus-btn .unfocus .unfocus-text,.card .more-panel,.card.config,.case-list .info .type .jc-black,.case-list .voted-user-info .name,.chat-history-list .chat-item.danmaku-item,.chat-history-panel .gift-item,.chat-history-panel .penury-gift-msg,.choice-item,.cm-model .report-detail .detail .report-cnt,.coin-operated-m .coin-title,.collection-m .title,.comment-area .comm-main .comm-tabs>ul>li,.comment-bilibili-con .other p,.comment-bilibili-con .reason-box dl dd,.comment-bilibili-con .t,.comment-content .link,.comment-emoji,.config-row,.content,.content .group-list li,.content .group-list li label .count,.content-box .origin-text a,.content-box .watermark-wrap .bk-text-con,.context-menu-a,.contribution-sidenav,.crumbs,.crumbs a,.customize,.danmaku-adjust-label,.danmaku-adjust-value,.danmaku-info-block-btn,.danmaku-info-danmaku,.danmaku-info-report-btn,.danmaku-position-item .danmaku-position-text,.danmaku-position-item .icon-font,.darkgray,.day-span.day-enable,.desc-title,.dialog .title,.download-panel-ctnr a,.dropdown-list,.dynamic-list-item-wrap .item-detail .text,.dynamic-m a,.elec .elec-count,.elec .elec-monthly-c,.ema-wishing .title,.emoji,.emoji-box .emoji-item,.emoji-box .title,.emoji-cover,.emoji-cover.selected,.emoji-text,.error-wrap,.fans-action-btn,.feed-tag .separater-line,.filter-wrap .filter-item a,.follow-btn,.follow-dialog-window .title,.follow-main .follow-action-bottom li,.follow-main .follow-action-top .back-to-info,.follow-sidenav .follow-list-container .follow-item,.follow-sidenav .follow-list-container .follow-item.cur .num,.follow-sidenav .nav-title .text,.fontsize .selection-span,.g-search input,.gift-info-title,.gift-item .label,.guard-rank-cntr .rank-cntr .page-box,.guard-rank-cntr .rank-cntr .rank-list-box a,.gui-settings,.gui-settings-box,.gui-settings-textbox-container input,.history-btn>.btn,.history-list .r-info .title,.history-list .r-info .w-info .username,.history-wrap .b-head .b-head-t,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-suggest .history,.home-wrap .home-suggest .history .list .item a,.home-wrap .home-suggest .hot-search,.hover-description,.hover-panel,.i-live .i-live-text,.i-m-btn,.i-m-title,.i-pin-v .be-tab-item,.icon-bls2018-rank.side-bar-icon+.size-bar-text,.im-popup .bp-popup-panel .title-ctnr .popup-title,.info .social a,.is-max .option-text,.jury-graph-wrap .canvas-txt p,.jury-graph-wrap .graph-status .illegal,.jury-graph-wrap .graph-status .legal,.large-item .title,.level-hint-text,.lf-item p,.link-input,.link-more,.link-panel-ctnr,.link-radio-button-label,.list-content-candidate.active,.list-create .text,.list-item .name,.live-room-list .room-item .item-title,.live-user .user-item .item-right .uname,.live-wrap .live-room .headline .filter a,.live-wrap .live-tabs a,.load-more-btn,.member-menu a,.message .message-content.not-img,.modal-container li,.modal-wrapper .modal-header-close,.modal-wrapper .modal-title,.more-link,.more-ops-list,.multi-page .cur-list li a,.multi-page .cur-list li:hover,.my-album .tab-list .tab .name,.my-album .title,.n .n-btn,.n .n-data .n-data-v,.nav-name,.nav-tab-bar .tab-item span,.nav-wrap .wrap,.nav-wrap .wrap>.sub,.next,.no-glory,.opera-list,.page-controller .next,.page-controller .prev,.page-jump>input,.pager .pages .page-item button,.paging-box .dian,.paging-box .next,.paging-box .prev,.paging-box .tcd-number,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.pgc-list .synthetical .des .type-s,.photo-list .photo .title,.pop-live .pl__head,.pop-live .pl__title,.pophover>p:first-child,.pub-list .info .name,.rank-list-ctnr .normal-list .item,.rank-list-ctnr .tabs .item.active,.rank-text-ctnr,.read-push,.report-con dl dd,.report-other,.report-popup .content-text,.result,.room-introduction-scroll-wrapper,.room-introduction-tags .room-introduction-tag,.room-title,.row-title,.search-wrap .search-block .input-wrap input,.section-right-options .operation,.seeds-wrap,.select-wrap .select-option,.select-wrap .select-option p:hover,.select-wrap .select-txt,.selector .current,.selector .data-list>li,.selector .data-list>li:hover,.selector-box,.setting.item a,.side-bar .title,.slide-item-wrp .slide-item-info .slide-item-title,.slim-video-card .video-info .title,.small-item.disabled .title,.sortable,.space-right .space-right-top .title,.special-module .user a,.sponsor-rank .sponsor-rank-header .show-sponsor-rank,.sticky-bar .bar-content .title,.sub-nav span,.suggest-item a,.suggest-wrap .horizontal .hz-text,.suggest-wrap .vt-text,.synthetical .play-btn,.synthetical .title,.t-over-hidden,.tag-info-pane .btn-right-box a,.tag-info-pane .tag-header .btn-subscribe,.tag-info-pane .text,.tag-list a,.tag-title>a,.tc-black,.tc-dark-slate,.tcd-number,.text-con,.title-container .title,.top .title,.up-article-list-block .more-article,.up-info .btn .b-cd,.up-info-holder .fixed-box .more .help .title,.up-info-holder .fixed-box .more .link .title,.up-info-holder .fixed-box .more .top-bar,.up-info-holder .fixed-box .rightside-article-list-btn .label,.up-info-holder .fixed-box .up-article-list-block .block-title,.up-level-icon,.user .info .meta .item,.user-auth.no-auth .no-auth-title .goto-auth,.user-level-detail .detail-link,.user-level-icon,.user-list .up-item .title,.user-list .up-item .up-videos .video-item .video-desc,.user-name:not(.big-vip) a,.user-panel .logout-btn,.user-type-hint,.user-wrap .dropdown-wrap .select-wrap .bili-dropdown .selected,.userinfo-content,.v-title,.video-container .text-area .title,.video-page-card .card-box .info .title,.video-title,.video-toolbar .share .share-pos .share-address ul li input,.video.list .title,.video.list .type,.video.matrix .title,.vote-title,.voted-result,.watch-later-list .list-box .av-item .av-about .t,.watch-later-list header .t,.welcome-msg .action,.welcome-msg .username,.welcome-msg .vip-icon,.what-ban .text-con .title,.wrapper .edit-video-modal .edit-video-title,.wrapper .edit-video-modal .target-favlist .target-fav-name,.wrapper .elec-main-title,.wrapper .elec-sub-title,.wrapper .modal-body .choice-wrp .battery-desp,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .modal-body .pay-info,.wrapper .modal-header .title,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,.yan-item,a.im-list,a.logout,a.more,a.name,a.read-more,a.recommand-link,a.router-link-active,a.router-link-exact-active,a.s-btn,a.side-link>span,a.up-name,a.username,div.all>a>span,div.b-head,div.bar>div.num>div,div.bili-tab-item,div.brief>a>span,div.con header,div.con>div.txt,div.grade span,div.info,div.lv-row>strong,div.r-text>.t,div.rec-title,div.title a,font,form.ipt>input,h3,li.tag,li.tag>a,p.ri-title,p.t,p.text,span.key,textarea{color:#eee!important}.bilibili-player.mode-fullscreen .bilibili-player-area .bilibili-player-video-btn-widescreen,.bilibili-player.mode-fullscreen .bilibili-player-area .bilibili-player-video-btn-widescreen .bilibili-player-iconfont{color:#99a2aa!important}.nav-tab-bar .tab-item.on span{color:#00a1d6!important}.calendar .day-item,.calendar .day-item.cur-day,.content-box .watermark-wrap .watermark,.fans-medal-item .label,.fans-medal-item:not(.medal-guard) .fans-medal-label{color:#222!important}.ban-detail .content-box .bk-text-con,.ban-detail .content-box .link-box,.bilibili-player-color-picker-color-code,.case-list .info dl,.history-list .l-info,.history-list .l-info .lastplay-time .history-red-round,.home-wrap .home-suggest .history .list .item,.home-wrap .home-suggest .hotlist .item,.live-status-label.preparing,.pub-list .info dl,.radio-icon,.report-con label:before,.suggest-wrap .title,.up-info-holder .fixed-box .rightside-article-list-btn .label,form.ipt,li.tag{border-color:#aaa!important}#id-card .idc-avatar,#page-setting #setting-new-tag,#page-setting #setting-new-tag-btn,#page-setting .setting-tag-list a,.action-menu .menu-list,.action-menu .menu-list:before,.article-container,.audio-info-module,.bangumi-info-module,.be-pager-options-elevator input[type=text],.bilibili-player-block-string-short,.bilibili-player-color-picker-container,.bilibili-player-danmaku-date-picker-container,.bilibili-player-modal-container,.bilibili-player-mode-selection-container,.bilibili-player-video-btn-setting-panel,.bilibili-player-video-control,.bilibili-player-video-danmaku-setting-box,.bilibili-player-video-inputbar,.bilibili-player-video-volumebar-wrp,.bl-button--ghost,.bpui-selectmenu-list,.card .focus-btn .focus,.card .focus-btn .unfocus,.card .more-panel,.card .more-panel:after,.common-popup-wrap .arrow,.emoji-box,.face,.h5share-container,.live-container,.multi-page .more-box,.music-container,.select-wrap .select-option,.slim-border:after,.textarea-container .comm-tool .comm-emoji,.user-card,.user-card-m,.video-container,.video-info-module,.video-toolbar .share .share-pos .share-address ul li input,.watch-later-list header .d-btn,div.dd-bubble,ul.bilibili-suggest{border-color:#222!important}#app .header,#app .submit,#app .submit .cancel,#article-list-btn .label,#article-list-btn .title,#page-fav .fav-main .fav-header.fav-header-info,#page-fav .fav-main .search-types,#page-fav .fav-main .small-item,#page-fav .fav-sidenav .nav-container,#page-index .channel .channel-item,#page-index .col-2 .section-title,#page-index .fav-covers,#page-setting .setting-index-container,#page-setting .setting-index-module,#page-subs .mini-item,#pin-wrapper .pin-layer-header,#primary_menu,.add-btn,.advanced-danmaku-group,.app-watch,.app-watch .title,.article-action,.article-content,.article-holder .slim-video-card,.attention-btn-ctnr .right-part,.awarding-panel,.bb-comment .nameplate .nameplate-card,.bb-comment .nameplate .nameplate-card .nameplate-text,.be-dropdown-item.be-dropdown-item-delimiter,.be-dropdown-menu,.be-pager-item,.be-pager-next,.be-pager-prev,.bili-dropdown,.bili-tab,.bili-tab-item,.bilibili-player-video-inputbar .bilibili-player-video-inputbar-wrap,.bilibili-player-video-time-seek,.border-b,.btn-box .message:hover,.btn-cancel,.btn-send,.btn.default,.btn.ghost,.calendar-checkin .divider,.chat-history-panel .chat-history-list .chat-item.system-msg,.checkbox,.choice-item,.comment-area .comm-main .comm-tabs,.comment-area .comm-more,.comment-bilibili-con .t,.comment-header,.common-popup-wrap,.common-popup-wrap::after,.common-popup-wrap::before,.count-choice,.customize,.danmaku-info-block-btn,.danmaku-info-report-btn,.day-span,.dialog .title,.divided-line,.dropdown-list,.dynamic-list-item-wrap,.dynamic-m,.ema-wishing,.error-wrap,.fans-action-btn,.filter-wrap,.fjw-case-detail .ban-detail .content-box .jury-status,.fjw-point header,.follow-main,.follow-main .follow-action-top,.follow-main .follow-action-top .back-to-info,.follow-main .follow-header.follow-header-info,.follow-sidenav,.follow-sidenav .nav-container.follow-container,.forw-area .forw-more,.g-search input,.gift-presets .gift-panel-switch,.gift-sender-panel::before,.guard-rank-cntr .rank-cntr .btn-box,.history-wrap .time-label:before,.home-wrap .home-input .content,.home-wrap .home-input .list,.home-wrap .home-input .type,.home-wrap .home-suggest .history,.home-wrap .home-suggest .hot-search,.hover-panel,.hover-panel:before,.i-live .i-live-fo-count,.i-live .i-live-unfo-btn,.i-m-r2,.i-m-upload,.iScrollIndicator,.image-box,.info-item-ctnr,.left-container .gift-control-section,.left-container .head-info-section,.link-footer,.list .list-title,.list-item,.looked,.member-menu,.modal-container .modal-body .target-followlist,.modal-wrapper .modal-title,.multi-page .head-con .range-box .paging li,.multi-page .more-box li,.nav-list,.nav-wrap,.pager .pages .page-item button,.photo-list .photo,.pl__card,.player-and-aside-area .aside-area,.prize-item .prize-img,.rank-list-ctnr,.rank-list-ctnr .tabs .item,.report-con,.room-info-ctnr .content-wrapper,.room-introduction-tags,.s-content,.search-wrap .search-block .input-wrap input,.section .operation,.selector,.selector .data-list,.send-box,.side-bar-cntr,.song-list .song-li .content .num,.suggest-wrap,.suggest-wrap .horizontal .hz-text,.synthetical .play-btn,.user .info .meta .row,.user .tags,.user-level-detail,.user-level-detail hr,.user-level-detail::after,.user-level-detail::before,.userinfo-wrapper,.video.list .type,.video.matrix,.vote-container,.whisper .list,.wrapper .pay-qrcode-wrp,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn,.wrapper .pay-qrcode-wrp .pay-way-wrp .pay-btn.active,div.bar>div.num,li.tag{border-color:transparent!important}#arc_toolbar_report,#page-index .col-1,#page-index .col-2 .section,#page-index .col-2 .section:last-child,#page-myalbum .album-content,#pin-wrapper #pin-layer-search,#v_desc,.all-class,.app-look,.article-list-holder-block .article-list-plane,.article-wrap .article,.back-top.icon,.backdrop .title-box,.bb-comment .comment-list .quote,.be-input_inner,.bilibili-player-adv-danmaku,.bilibili-player-block-string-short-btn,.bilibili-player-context-menu-container,.bilibili-player-modal-btns .bpm-btn,.bilibili-player-modal-header,.bilibili-player-setting-menu-wrap,.bilibili-player-video-danmaku-setting-right-separator,.bpui-button.bpui-button-type-small,.btn-box .like,.btn-box .liked,.btn-box .message,.btn.followed .b-gz,.bui-button.bui-button-transparent,.bui-input .bui-input-stepper-up,.bui-input-input,.bui-input-stepper,.bui-input-wrap-disabled,.bui-select .bui-select-border,.c-clink,.collection-m .bottom,.collection-m .title,.comment-emoji,.contribution-sidenav,.contribution-sidenav~.main-content,.danmaku-wrap .bilibili-player-block-wrap,.elec .elec-avatar,.fixed-top .search-block .input-wrap input,.float-nav .nav-menu .item,.follow-dialog-window .bottom,.follow-dialog-window .title,.go-top,.history-btn>.btn,.history-list .r-info .r-txt,.history-list .r-info .w-info .username,.i-pin-v .be-tab,.lf-list,.link-more,.list-create,.live-field.fl,.modal-wrapper .modal-title,.more-link,.more-ops-list,.notice-item,.opera-list,.option-li,.page-jump>input,.paging-box-big .dian,.paging-box-big .next,.paging-box-big .tcd-number,.read-push,.result .row.top-border:before,.result .row:after,.result .row:first-child:before,.right-side-bar .to-comment,.right-side-bar .to-comment .comment-num,.right-side-bar .to-top,.section,.square-field,.synthetical,.up-info .btn .b-cd,.up-info-holder .fixed-box .rightside-article-list-btn,.up-info:before,.user-list .up-item,.user-wrap .dropdown-wrap .select-wrap,.v-data,.v-preview,.v-wrap .s_tag,.video-toolbar .share .share-pos,.video.list,.vote-number,.watch-later-list .list-box .av-item .av-about,.wrapper .edit-video-modal .modal-body,.wrapper .modal-body .choice-wrp .battery,.wrapper .modal-body .choice-wrp .battery-desp input,.wrapper .modal-body .elec-protocol .checkbox,.wrapper .modal-header .u-info,a.more,a.read-more,a.s-btn,div.con,div.con header,textarea,ul.boston-postcards>li{border-color:#444!important}.b-line,.b-line:hover,.bilibili-player-danmaku-date-picker-header,.btn-right-box,.video-toolbar .share .share-pos .box-b,li.history,li.history:hover,li.timeline,li.timeline:hover{border-color:#99a2aa!important}.bili-header-m .mini-wnd-nav a,.dropdown-item,.elevator-module .nav-list .item,.history-btn>.btn,.link-more,.member-menu a,.more-link,.read-push,.video-desc .btn span,a.im-list,a.logout,li.tag,p.ri-title{transition:.2s!important}.bili-dropdown>.icon,.c-clink>.icon,.filter-wrap .fold .arrow-down,.filter-wrap .fold .arrow-up,.fixed-top .search-block .search-loupe .icon-loupe,.gift-presets .gift-panel-switch>.arrow,.home-wrap .home-input .type .arrow-down,.i-live-arrow,.i-live-icon,.i-m-ra,.i-m-u-icon,.i-m-v-icon,.icon-arrow,.icon-close-notice,.icon-notice,.link-footer .footer-linker .footer-linker-bili .logo,.link-more>.icon,.list-create:hover .icon,.member-menu i,.more-link>.icon,.primary-menu .nav-menu li.home>a,.read-push>.icon,.select-wrap .select-txt i,.setting:before,.side-bar .icon,.tag-info-pane .btn-right-box a i,.up-info-holder .fixed-box .rightside-article-list-btn .icon-list,a.more>.b-icon,a.read-more>.b-icon,form.ipt>a,i.btn-del,i.face,img[src^='//static.hdslb.com/images/base']{filter:brightness(0) invert(1)!important}ul.up-nav li{filter:grayscale(1) brightness(1.3)!important}#app .container .options .option img,.bb-comment .comment-list .list-item .info .operation .spot,.bp-svg-icon.lottery-btn,.bp-svg-icon.radio-Selected,.bp-svg-icon.radio-default,.bp-svg-icon.vote-btn,.calendar .day-item.checked,.carousel-box .carousel-module .panel .trig span.on,.carousel-box .carousel-module .panel .trig span:hover,.check-icon,.comment-wrap .header .title-h2 .head-icon,.dynamic-comm-icon,.dynamic-hate:hover i,.dynamic-hated i,.dynamic-hated:hover i,.dynamic-like:hover i,.dynamic-liked i,.dynamic-liked:hover i,.emoji-btn-box.opened,.emoji-btn-box:hover,.emoji-tab-slider .next.on:hover,.emoji-tab-slider .prev.on:hover,.emotion-btn-box.opened,.emotion-btn-box:hover,.fjw-point header h2 .head-icon,.follow-main .follow-action-bottom .icon-copy,.follow-select .icon-follow-selected,.group-list li input[type=checkbox]:checked+i,.group-list li input[type=checkbox]:checked:hover+i,.group-list li input[type=checkbox]:hover+i,.home-wrap .home-logo,.home-wrap .home-tips .tips-link .tip-item>a,.is-web .checked,.link-range-ctnr,.live-wrap .live-room .headline .filter .cover-btn.active .icon-live-face,.live-wrap .live-room .headline .filter .cover-btn:hover .icon-live-face,.live-wrap .live-room .headline .filter .frame-btn.active .icon-live-frame,.live-wrap .live-room .headline .filter .frame-btn:hover .icon-live-frame,.nav-tab-bar .logo,.nav-tab-bar .tab-item.on,.primary-menu .nav-menu .sub-nav li>a,.primary-menu .nav-menu .sub-nav li>a span::after,.search-wrap .search-logo,.single-button .text-bar.selected,.user-type-icon .svg-icon.not-member-1,.user-type-icon .svg-icon.phone-1,.video-container .image-area .see-later.done,.vote-container .image-area .share-img,.watch-later-trigger.added{filter:var(--blue-image-filter)!important}.calendar .day-item.gift-checked,.home-wrap .home-tips .tips-link .tip-item>a:hover{filter:var(--pink-image-filter)!important}.elevator-module .nav-list .customize .icon,.fjw-point .point-wrap .user-point .info .usr-zan-cai .cai,.fjw-point .point-wrap .user-point .info .usr-zan-cai .zan,.spread-module .num .danmu .icon,.spread-module .num .play .icon,ul.filter-disable .icon-copy{filter:grayscale(1)!important}.room-bg{filter:brightness(.16) blur(10px)!important}.box-slide-item.expired .box-img,.box-slide-item:not(.in-countdown) .box-img,.user-type-icon .svg-icon.not-member-2,.user-type-icon .svg-icon.phone-2{filter:brightness(.3)!important}#page-follows .follow-main .follow-action-top .back-to-info,#page-index .col-1 .section .more,.article-holder .slim-video-card-error,.elec .elec-status,.elec .elec-status-bg,.small-item .cover{background-image:none!important}.bilibili-player-block-tabpanel-row.bilibili-player-border,.dropdown-item,.g-search input{border-radius:4px!important}.back-top.icon:hover,.go-top:hover{background-position:-713px -72px!important}.list-create:hover .icon{background-position:-716px -332px!important}.action-menu .menu-list,.article-container:hover .text-area,.ban-detail .content-box .info-wrap,.bpui-selectmenu-list,.bpui-slider-handle,.card,.col-full,.comment-wrap,.dynamic-m,.elec .elec-trigger,.h5share-container:hover .text-area,.i-pin-c,.large-item .cover img,.list-item .cover img,.mini-item .cover img,.music-container:hover .text-area,.n .n-inner,.side-bar-cntr,.space-right .space-right-top .title,.sticky-bar .bar-content .send-button,.vote-container:hover .text-area,div.box,div.im-list-box,div.live-box{box-shadow:none!important}#gift-package-item-box .panel-wrapper,.audio-info-module,.bangumi-info-module,.bb-comment .nameplate .nameplate-card,.bilibili-player-context-menu-container,.blpui-slider-container .slider-handle,.common-popup-wrap,.emoji-box,.emotion-box,.gift-sender-panel,.link-navbar .panel-shadow,.live-player-ctnr.minimal,.tag-info-pane,.user-card,.user-card-m,.user-level-detail,.user-panel-ctnr .user-avatar.active,.userinfo-wrapper,.video-info-module,div.dd-bubble,div.desc-tips,div.drag-bar,div.i-frame,ul.bilibili-suggest,ul.up-nav{box-shadow:rgba(0,0,0,.3) 0 4px 8px 0!important}.sticky-bar{box-shadow:0 1px 10px 0 #0003!important}#bilibili-player.mini-player::before,.bilibili-player.mini-player::before{box-shadow:0 4px 8px 0 #0004!important}.bilibili-player-context-menu-container{text-shadow:none!important}.bb-comment .comment-header .tabs-order li.on:after,.bb-comment .nameplate .nameplate-card .nameplate-arrow,.emoji-box:before,.g-search .search-btn,.load-more .icon,.loading .icon,.up-info-holder .fixed-box .more .help .icon,.up-info-holder .fixed-box .more .link .icon,.wrapper .elec-message-wrp .elec-triangle,canvas.cliper.is-img,div.desc-tips>span.arrow-left,img.source-img{display:none!important}.article-action i.animation{opacity:0!important}.vote-user-face.opacity{opacity:1!important}.advanced-danmaku-group .content-span,.bilibili-player-block-label{font-weight:400!important}.bilibili-player-video-progress-detail-sign-down{border-top-color:var(--theme-color)!important}.bilibili-player-video-progress-detail-sign-up{border-bottom-color:var(--theme-color)!important}.bilibili-player-video-control{border-bottom-color:#333!important}.coin-operated-m .mc-box{border:2px dashed #444!important;background-color:#fff!important}.coin-operated-m .mc-box.on{border-style:solid!important}.go-top-m .go-top,.page-box .num{border:none!important}.music-container .image-area .icon{filter:brightness(0)!important}.g-search input{padding:0 8px!important}.up-info-holder .fixed-box .more .help,.up-info-holder .fixed-box .more .link{padding:0!important}#page-fav .fav-main .filter-item .filter-type .be-dropdown-item{padding:0 16px!important}.cliper{filter:brightness(16%)!important}#page-setting #setting-new-tag-btn{background:var(--theme-color)!important}.bilibili-player-video-panel-image-detail{filter:invert(70%)!important}.home-wrap .home-input .content:focus,.search-wrap .search-block .input-wrap input,textarea:focus{outline:0!important;outline-offset:0!important}.bangumi-list .synthetical .cardBangumibox .modal-box .lazy-img,.pgc-list .synthetical .cardPgcbox .modal-box .lazy-img{z-index:inherit!important}.base-bubble,.base-bubble .content-ctnr:before,.bb-comment .comment-header .tabs-order li.on,.bb-comment .stick,.bb-comment .stick.assist,.be-pager-item-active,.be-tab-cursor,.be-tab-cursor:after,.bi-btn,.bili-tab-item.on,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row.active-3 .bilibili-player-block-type-user,.bilibili-player-video-btn-send,.bl-button--primary,.bpui-button.bpui-button-type-small:hover,.btn-box .like:hover,.btn-submit,.btn.primary,.bui-button.bui-button-transparent:hover,.c-clink:hover,.calendar-checkin .checkin-rewards .query:hover,.calendar-checkin .title .month:hover.cur-month:after,.calendar-checkin .title .month:hover.cur-month:before,.calendar-checkin .title .month:hover.last-month:after,.calendar-checkin .title .month:hover.last-month:before,.card .focus-btn .unfocus:hover,.choice-item.active,.choice-item:hover,.coin-operated-m .mc-box.on,.coin-operated-m .mc-box.on .coin-operated-m .mc-box:hover,.comment-area .comm-main .comm-tabs>ul>li.active,.comment-submit,.count-choice .count-input:focus,.day-span.day-enable.active,.elevator-module .back-top:hover,.elevator-module .nav-list .item.on,.elevator-module .nav-list .item:hover,.filter-wrap .filter-item.active a,.float-nav .nav-menu .item:hover,.go-top,.history-btn>.btn:hover,.history-wrap .active:before,.history-wrap .time-label,.history-wrap .time-label:after,.home-wrap .home-input .searchBtn,.link-more:hover,.list-create:hover,.live-panel .more-button .more:hover::after,.live-status-label,.live-wrap .live-tabs a.active,.more-link:hover,.multi-page .more-box li.on,.page-jump>input:focus,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.radio-icon.selected,.read-push:hover,.report-con input[type=radio]:checked+label:before,.right-side-bar .to-comment:hover,.right-side-bar .to-top:hover,.send-btn,.suggest-wrap .horizontal .hz-text:hover,.tab-list .tb-item.active,.tag-panel .more-button .more:hover::after,.top-title .concern,.up-info .btn .b-cd:hover,.up-info .up-focus-btn,.up-info-holder .fixed-box .follow-btn-holder .follow-btn:not(.followed),.up-info-holder .fixed-box .follow-btn-holder .follow-btn:not(.followed):hover,.wrapper .modal-back:hover,.wrapper .modal-body .choice-wrp.selected .battery,.wrapper .modal-body .choice-wrp.selected .elec-input,a.more:hover,a.read-more:hover,a.s-btn:hover,input[type=text]:focus,textarea:focus{border-color:var(--theme-color)!important}#app .submit .confirm,#page-channel-index .channel-option.no-channel .create-channel,#page-fav .fav-sidenav .fav-item.cur,#page-setting #setting-new-tag-btn,.advanced-danmaku-group .adv-danmaku-btn-span:hover,.area-link:active,.attention-btn-ctnr .left-part,.bb-comment .hot-line a:hover,.be-pager-item-active,.be-switch-container.is-checked .be-switch,.bi-btn,.bilibili-player-block-string-short-btn,.bilibili-player-setting-menu-list:hover,.bilibili-player-video-btn-send,.bilibili-player-video-progress-buffer-range,.bl-button--primary,.bl-switch-checked,.blpui-slider-container .slider-handle,.blpui-slider-container .slider-process,.blpui-slider-span.slider-span-active:after,.blpui-slider-span>span,.bpui-button.bpui-button-type-small:hover,.bpui-slider-progress,.btn-box .like:hover,.btn-send,.btn-submit,.btn.primary,.bui-bar-normal,.bui-button.bui-button-transparent:hover,.bui-radio-input:checked+.bui-radio-label,.bui-switch .bui-checkbox:checked+.bui-body,.bui-thumb-dot,.c-clink:hover,.card .focus-btn .unfocus:hover,.cases-wrap .fjw-user .b-right button,.close-icon,.collection-m .bottom .btn,.comment-submit,.contribution-sidenav .contribution-item.cur,.count-choice .send-button,.danmaku-info-block-btn:hover,.danmaku-info-report-btn:hover,.dropdown-item:hover,.dyn_list span.sp,.dynamic-btn.pink,.dynamic-m .dyn_menu .line,.elec .elec-trigger,.elevator-module .back-top:hover,.elevator-module .nav-list .item.on,.elevator-module .nav-list .item:hover,.filter-wrap .filter-item.active,.filter-wrap .fold:hover,.fjw-point .focus-btn,.float-nav .nav-menu .item:hover,.follow-btn,.follow-sidenav .follow-list-container .follow-item.cur,.fontsize .selection-span.active,.gift-item .corner-mark,.gift-package,.go-top:hover,.history-btn>.btn:hover,.history-list .cover-contain .progress,.history-wrap .time-label.active,.home-wrap .home-input .searchBtn,.home-wrap .home-suggest .hot-search .item .num.special,.hour-rank,.link-more:hover,.live-container .status,.more-link:hover,.more-ops-list li:hover,.multi-page .more-box li.on,.n .n-cursor,.nav-wrap .hover-bar,.new-notice-bar,.notify,.num-wrap>span,.opera-list li:hover,.pager .pages .page-item button:hover,.pager .pages .page-item.active button,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.process-bar .process-receive,.radio-icon:after,.rank-item.highlight>.ri-num,.rank.rank-1,.rank.rank-2,.rank.rank-3,.read-push:hover,.report-con label:after,.right-side-bar .to-comment:hover,.right-side-bar .to-top:hover,.s_tag .btn-add:hover span,.search-wrap .search-block .search-button,.send-btn,.sortable:hover,.sticky-bar .bar-content .send-button,.submit-button,.synthetical .play-btn:hover,.tab-bar .line,.tab-candidate>span:after,.tag-info-pane .tag-footer .btn-left-box>a:hover,.tag-info-pane .tag-header .btn-subscribe:hover,.text-con .title i,.textarea-container .comm-tool .comm-submit,.top-title .concern,.type-label,.up-info .btn .b-cd:hover,.user-list .up-item .attention-btn,.user-panel .level-progress .progress-bar,.user-panel-ctnr .user-avatar.active::before,.video-container .types,.video-info .video-title .activity,.video-toolbar .share .share-pos .share-address ul li .btn,.vote-btn-box .vote-btn,.wrapper .edit-video-modal .target-favlist .target-favitem.selected,.wrapper .elec-btn,.yan-item:active,a.btn-more:hover,a.more:hover,a.read-more:hover,a.s-btn:hover,li.tag:hover,p.on>span>a,span.reply:hover{background-color:var(--theme-color)!important}#app .header .close:hover,#id-card .idc-uname:hover,#page-channel-index .no-channel-container em,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item:hover i,#page-fav .fav-main .filter-item .filter-type .be-dropdown-item:hover span,#page-fav .fav-main .filter-item .text:hover,#page-fav .fav-main .search-types:hover,#page-follows .follow-main .follow-action-bottom .select-cancel,#page-index .album .content .album-wrapper .album-item .album-title:hover,#page-index .channel.guest .channel-item .channel-title .channel-name:hover,#page-subs .action .sub-action,#page-subs .detail a:hover,#page-video #submit-video-type-filter a.active,.action-menu .menu-list a:hover,.album-card .title:hover,.app-watch .app-look .foot-txt a,.area-link:hover,.article-holder a,.article-title a:hover,.awarding-panel .countdown-text .with-color,.awarding-panel .info-section .slide-btn:hover,.awarding-panel .title,.ban-detail .content-box .link-box .box-right a,.bangumi-container .text-area .title:hover,.bb-comment .comment-header .tabs-order li.on,.bb-comment .comment-header .tabs-order li:hover,.bb-comment .comment-list .list-item .info .plad a:hover,.bb-comment .stick,.bb-comment .stick.assist,.bb-comment a,.be-dropdown-item a:hover,.be-pager-item:hover a,.be-pager-next:hover a,.be-pager-prev:hover a,.be-tab-item.is-active,.bili-footer a:hover,.bili-header-m .bubble-traditional .recommand .title,.bili-header-m .mini-wnd-nav a:hover,.bili-link,.bili-tab-item.on,.bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-label,.bilibili-player-block-filter-type.disabled .bp-icon,.bilibili-player-block-filter-type:hover .bilibili-player-block-filter-label,.bilibili-player-block-filter-type:hover .bp-icon,.bilibili-player-block-line-delete:hover,.bilibili-player-block-line-state,.bilibili-player-block-tabpanel-row.active-1 .bilibili-player-block-type-keyword,.bilibili-player-block-tabpanel-row.active-2 .bilibili-player-block-type-regex,.bilibili-player-block-tabpanel-row.active-3 .bilibili-player-block-type-user,.bilibili-player-block-tabpanel-row>div:hover,.bilibili-player-danmaku-btn-history.bpui-state-hover,.bilibili-player-video-danmaku-setting-left-block .bilibili-player-video-danmaku-setting-left-block-content .bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-label,.bilibili-player-video-danmaku-setting-left-more:hover,.bilibili-player-video-danmaku-setting-left-more:hover .bilibili-player-video-danmaku-setting-left-more-text,.bilibili-player-video-danmaku-setting-left-more:hover i,.bilibili-player-video-danmaku-setting-right-more:hover,.bilibili-player-video-danmaku-setting-right-more:hover i,.bilibili-player-video-danmaku-setting:hover,.bilibili-player-video-toast-item-close:hover i,.bilibili-player-video-toast-item-jump,.block-setting-ctnr .title,.block-user-type.active .user-type-hint,.blpui-btn.icon-btn:hover>i,.blpui-btn.text-btn.active,.blpui-btn.text-btn:hover,.boost-control li:hover,.boost-control li:hover i,.bottom .link,.box-slide-item.box-open,.box-slide-item.in-countdown,.box-toggle.active,.box-toggle:focus,.box-toggle:hover,.bpui-selectmenu-list-row[data-selected],.breadcrumb .item:hover,.bui-checkbox:hover .bui-checkbox-name,.bui-select.bui-select-quality-menu .bui-select-item.bui-select-item-active,.bui-switch .bui-checkbox:checked+.bui-body .bui-dot,.calendar-checkin .checkin-btn:hover,.calendar-checkin .checkin-rewards .query:hover,.calendar-checkin .title .month:hover,.captcha-widget .refresh-captcha:hover,.card-live-module .num,.chat-history-panel .penury-gift-msg .penury-gift-item .username,.chat-item.danmaku-item .danmaku-content:hover,.choice-item.active,.choice-item:hover,.clearall a,.clock-time,.coin-operated-m .coin-title span,.collection-m .content .group-list li:hover,.comment-area .comm-main .comm-tabs>ul>li.active,.comment-area .comm-more a.more:hover,.content-ctnr .activity-item-ctnr:hover .username.f-left,.contribution-sidenav .contribution-item a:hover,.control-panel-icon-row .icon-item.active,.control-panel-icon-row .icon-item:hover,.day-span.day-enable.active,.day-span.day-enable:hover,.download-panel-ctnr .download-item:hover,.dynamic-link-hover-bg,.dynamic-m .dyn_menu li.on,.expand-btn,.filter-wrap .filter-item a:hover,.follow-dialog-window .content .info .uname,.follow-sidenav .text:hover,.guard-rank-cntr .rank-cntr .btn-box .buy,.guard-rank-cntr .rank-cntr .rank-list-box a:hover,.history-list .r-info .title:hover,.history-list .r-info .w-info .username:hover,.history-wrap .time-label,.i-live .i-live-link:hover,.i-live .i-live-off-guest a,.i-m-title:hover,.info-ctnr .time .blue,.joined-number,.keyword,.large-item .title:hover,.list .item.active a,.list .item.active:before,.list .item:hover a,.list .item:hover:before,.list-item a.title:hover,.live-box .title,.live-module .zone-title .headline .fire:hover,.live-panel .more-button .more:hover,.live-status-label,.live-wrap .live-room .headline .filter a.active,.live-wrap .live-room .headline .filter a:hover,.live-wrap .live-tabs a.active,.live-wrap .live-tabs a:hover,.load-error-panel .request-link,.load-more-btn:hover,.member-menu a:hover,.minimal-control-panel .control-btn .btn-icon:hover,.modal-wrapper .modal-header-close:hover,.mode .selection-span.active,.mode .selection-span:hover,.more-button:hover,.multi-page .cur-list li a:hover,.multi-page .cur-list li.on i,.multi-page .head-con .range-box .paging li.on,.multi-page .head-con .range-box i:hover,.multi-page .more-box li:hover,.my-album .tab-list .tab.active .name,.n .n-btn:hover,.n .n-fs:hover p,.n .n-gz:hover p,.nav-wrap .wrap>.sub.active,.nav-wrap .wrap>.sub:hover,.paging-box .current,.player-setting-ctnr .title,.right-action-ctnr:hover,.room-introduction-tags .room-introduction-tag a:hover,.room-introduction-tags .room-introduction-tag:hover,.room-introduction-tags .room-introduction-tag:hover .icon-label,.room-owner-username:hover,.sec-empty-hint a,.section .operation:hover,.section-title,.section-title .t:hover,.seeds-wrap>.item.btn,.small-item .title:hover,.small-item.disabled .title:hover,.song-list .song-li:hover .content .text a,.special-module .user a:hover,.sticky-bar .bar-content .title:hover,.suggest-wrap .horizontal .hz-text:hover,.suggest-wrap .keyword-wrap .keyword .suggest_high_light,.tab-candidate.active,.tab-candidate:hover,.tab-text.selected,.tab-text:hover,.tabs a:hover,.tag-info-pane .tag-header .btn-unsubscribe:hover,.tag-panel .more-button .more:hover,.tag-panel .tag-list a,.tc-blue,.tc-blue-hover,.time .detail-link:hover,.up-info-holder .fixed-box .more .help .title:hover,.up-info-holder .fixed-box .more .link .title:hover,.user-level-detail .detail-link:active,.user-level-detail .detail-link:hover,.user-list .up-item .up-videos .video-item .video-desc:hover,.user-list .up-item .up-videos .video-more,.user-name:hover,.user-panel .ctrl-btn.colored,.user-panel .ctrl-btn:hover,.user-panel .logout-btn:active,.user-panel .logout-btn:hover,.user-panel .user-level,.video-desc .btn span:hover,.video-toolbar .ops .app .app-look .foot-txt a,.video-toolbar .ops>span.on,.video-toolbar .ops>span.on>i,.video-toolbar .ops>span:hover,.video-toolbar .ops>span:hover>i,.video-toolbar .share-btn:hover,.video-toolbar .share-btn:hover i,.watch-later-list .list-box .av-item .av-about .t:hover,.welcome-msg .close-vip-hint,.wish-box-cntr .title,.wrapper .elec-sub-title .up-name,.wrapper .modal-back,.wrapper .modal-body .choice-wrp.selected .battery-desp,.wrapper .modal-body .elec-pay .elec-coin,.wrapper .modal-body .elec-pay .elec-count,.wrapper .modal-body .elec-pay .elec-exp,.wrapper .modal-body .elec-protocol a:hover,.wrapper .modal-body .pay-info .balance,.wrapper .modal-body .pay-info .pay-tip .em-text,.wrapper .modal-header .u-name,.yan-item:hover,a.bbs,a.btn-more,a.help-link,a.im-list:hover,a.logout:hover,a.more-hot,a.name:hover,a.pic>p.title:hover,a.tcd-number:hover,a.up-name:hover,div.all>a>span:hover,div.bili-tab-item:hover,div.brief>a>span:hover,div.info>a,div.r-text>.t:hover,div.spread-module:hover,div.title a:hover,p.ri-title:hover,p.t:hover,span.current,ul.nav-menu>li:hover{color:var(--theme-color)!important}#app .submit .confirm,#page-setting #setting-new-tag-btn,.advanced-danmaku-group .adv-danmaku-btn-span:hover,.area-link:active,.attention-btn-ctnr .left-part,.bb-comment .comment-list .quote,.bb-comment .hot-line a:hover,.be-pager-item-active a,.be-pager-item.be-pager-item-active:hover a,.bili-header-m .mini-wnd-nav a:hover,.bilibili-player-block-string-short-btn,.bilibili-player-setting-menu-list:hover,.bilibili-player-video-btn-send,.bl-button--primary,.bpui-button.bpui-button-type-small:hover,.btn-box .like:hover,.btn-send,.btn-submit,.btn.primary,.bui-button.bui-button-transparent:hover,.bui-radio-input:checked+.bui-radio-label .bui-radio-text,.calendar .day-item.checked,.card .focus-btn .unfocus .unfocus-text:hover,.cases-wrap .fjw-user .b-right button,.collection-m .bottom .btn,.comment-submit,.contribution-item.cur a,.contribution-sidenav .contribution-item.cur .text:hover,.count-choice .send-button,.danmaku-info-block-btn:hover,.danmaku-info-report-btn:hover,.dropdown-item:hover,.dyn_list span.sp,.dynamic-btn.pink,.filter-wrap .filter-item.active,.filter-wrap .filter-item.active a,.filter-wrap .fold:hover,.fjw-point .focus-btn,.float-nav .nav-menu .item:hover,.follow-btn,.follow-sidenav .follow-list-container .follow-item.cur,.follow-sidenav .follow-list-container .follow-item.cur .num,.follow-sidenav .follow-list-container .follow-item.cur .text,.fontsize .selection-span.active,.gift-item .corner-mark,.gift-package,.gift-package>span,.history-btn>.btn:hover,.history-wrap .time-label.active,.home-wrap .home-input .searchBtn,.home-wrap .home-suggest .hot-search .item .num.special,.hour-rank .hour-rank-content,.link-more:hover,.live-container .status,.more-link:hover,.more-ops-list li:hover,.multi-page .more-box li.on,.new-notice-bar .message,.num-wrap>span,.opera-list li:hover,.pager .pages .page-item button:hover,.pager .pages .page-item.active button,.paging-box-big .current,.paging-box-big .next:hover,.paging-box-big .tcd-number:hover,.rank.rank-1,.rank.rank-2,.rank.rank-3,.read-push:hover,.search-wrap .search-block .search-button,.section-right-options .operation:hover,.send-btn,.sortable:hover,.sticky-bar .bar-content .send-button,.submit-button,.synthetical .play-btn:hover,.tab-list .tb-item.active,.tag-info-pane .tag-footer .btn-left-box>a:hover,.tag-info-pane .tag-header .btn-subscribe:hover,.textarea-container .comm-tool .comm-submit,.top-title .concern,.type-label,.up-info .btn .b-cd:hover,.user-list .up-item .attention-btn,.video-container .types,.video-info .video-title .activity,.vote-btn-box .vote-btn,.wrapper .elec-btn,.yan-item:active,a.btn-more:hover,a.more:hover,a.s-btn:hover,div.title a.more:hover,li.tag>a:hover,span.reply:hover{color:var(--foreground-color)!important}#page-follows .follow-main .follow-action-top .back-to-info:hover,.bilibili-player-block-filter-type:hover .bilibili-player-block-filter-image,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span.active,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span.active:hover,.bilibili-player-mode-selection-container .bilibili-player-mode-selection-panel .bilibili-player-mode-selection-row.mode .selection-span:hover,.bilibili-player-video-danmaku-setting-left-block .bilibili-player-video-danmaku-setting-left-block-content .bilibili-player-block-filter-type.disabled .bilibili-player-block-filter-image,.bilibili-player-video-danmaku-setting:hover,.bilibili-player-video-sendbar .bilibili-player-video-btn:hover,.bui-checkbox .bui-checkbox-input:checked+.bui-checkbox-label .bui-checkbox-icon svg,.bui-checkbox:hover .bui-checkbox-icon svg,.bui-switch .bui-checkbox:checked+.bui-body .bui-dot{fill:var(--theme-color)!important}.gui-settings-close path{fill:#eee}.history-list .l-info .lastplay-time .history-red-round,.history-wrap .active:before,.history-wrap .time-label:after{border-top-color:transparent!important;border-bottom-color:transparent!important}.tag-panel .more-button .more::after .tag-panel .more-button .more:hover::after{border-top-color:transparent!important;border-right-color:transparent!important}.be-tab-cursor:after,.bili-tab-item:before,.dynamic-m .dyn_menu .line:before{border-color:var(--theme-color)!important}.be-tab-cursor:after,.bili-tab-item:before,.common-popup-wrap .arrow,.dynamic-m .dyn_menu .line:before{border-left-color:transparent!important;border-right-color:transparent!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-track,.multi-page .cur-list ul::-webkit-scrollbar-track{background:#444!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-thumb,.multi-page .cur-list ul::-webkit-scrollbar-thumb{background:#222!important}.chat-history-panel .chat-history-list::-webkit-scrollbar-thumb:hover,.multi-page .cur-list ul::-webkit-scrollbar-thumb:hover{background:#333!important}.chat-history-panel .chat-history-list,.multi-page .cur-list ul{scrollbar-color:#444 #222!important}.coverNews-item .coverNews-item-title{color:#eee!important}.coverNews-item .coverNews-item-time{color:#aaa!important}.vote-backdrop .extension-wrapper .title-box{background-color:#222!important;border-color:transparent!important}.vote-backdrop .extension-wrapper iframe{background-color:#222!important}.action-menu .menu-list a,.dialog-ctnr.bottom-left,.pay-note-panel,.suggest-wrap .keyword-wrap .keyword.focus{background-color:#333!important}.pay-note-panel .arrow-left,.pay-note-panel .arrow-right{filter:invert(.7)!important}.chat-history-panel .card-item-middle-top,.vote-result-comment{background-color:transparent!important}.chaos-pk-rank .link-to-history{color:#aaa!important}.bl-button--primary:disabled,.chaos-pk-rank .rank .rank-name,.chasing-frame-cntr .chasing,.chat-history-panel .chat-item.superChat-card-detail .card-item-middle-top-right,.ep-item.v4.cursor .ep-pub,.notice-info-wrapper .notice-info-title{color:#eee!important}.primary-menu-itnl,.vote-pc-container .card,.vote-result-comment .reply-item{border-color:transparent!important}.bi-btn,.channel-menu-itnl .item .name em,.ep-list-wrapper .ep-item .badge,.live-room-app .guard-rank-cntr .rank-cntr .btn-box .buy:hover,.pgc-space-follow-item a.pgc-item-cover .badge,.ss-list-wrapper .ss-item .ss-cover .ss-badge{color:var(--foreground-color)!important}.extension-wrapper .vote-left-time{color:#aaa!important}.extension-wrapper input{color:#eee!important}.extension-wrapper .checked{filter:var(--pink-image-filter)!important}.app-layout .search-bar .search-bar-bg,.app-layout .vertical-block-card{background-color:#444!important}.app-layout .rank-item-wrapper{background-image:none!important}.app-layout .manga-navbar-favourite-manga .drop-list .more-btn-container,.app-layout .manga-navbar-history-list .drop-list .more-btn-container{background-color:transparent!important}.app-layout .manga-navbar .download-app,.app-layout .manga-title,.app-layout .ranking-jump,.app-layout .show-status-text{color:#eee!important}.app-layout .manga-title:hover,.app-layout .ranking-jump:hover,.app-layout .show-status-text:hover{color:var(--theme-color)!important}.app-layout .sidebar-item,.app-layout .time-selector-ctnr{color:#eee!important}.app-layout .sidebar-item.activated,.app-layout .sidebar-item:hover,.app-layout .time-selector-ctnr.activated,.app-layout .time-selector-ctnr:hover{color:var(--theme-color)!important}.app-layout .sidebar-item .arrow,.app-layout .time-selector-ctnr .arrow{filter:var(--blue-image-filter)!important}.app-layout .banner-manga-container .tab-item{color:#eee!important}.app-layout .banner-manga-container .tab-item.activated{color:var(--theme-color)!important}.app-layout .banner-manga-container .tab-item.activated:after{background-color:var(--theme-color)!important}.app-layout .nav-list .nav-item .item-icon{filter:var(--blue-image-filter)!important}.app-layout .nav-list .nav-item .item-underline{background-color:var(--theme-color)!important}.app-layout .list-item,.app-layout .rank-title{color:#eee!important}.app-layout .list-item .title-tooltip,.app-layout .rank-title .title-tooltip{background-color:#555!important}.app-layout .list-item .title-tooltip:before,.app-layout .rank-title .title-tooltip:before{background-color:transparent!important}.app-layout .item-title,.app-layout .list-item .title-tooltip .tooltip-text,.app-layout .rank-title .title-tooltip .tooltip-text{color:#eee!important}.app-layout .item-title:hover{color:var(--theme-color)!important}.app-layout .manga-info-ctnr,.app-layout .meta-ctnr,.app-layout .rank-hint{color:#aaa!important}.app-layout .section-navigator{border-color:transparent!important;background-color:#444!important}.app-layout .section-navigator .divider{border-color:transparent!important}.app-layout .section-navigator .back-to-top:hover .icon{filter:var(--blue-image-filter)!important}.app-layout .container{background-color:transparent!important}.app-layout .container .title{color:#eee!important}.app-layout .container .tab{color:#aaa!important}.app-layout .container .tab.active{color:var(--theme-color)!important}.app-layout .container .tab.active:after{background-color:var(--theme-color)!important}.app-layout .auto-purchase .page-sub-title,.app-layout .auto-purchase-item .list-content .comic-content .bought-ep-count,.app-layout .purchased-comic-item .eq-desc{color:#aaa!important}.card-detail .card-item-middle-top{background-color:#333!important}.card-detail .card-item-middle-top .card-item-middle-top-right .content-bottom .price,.card-detail .card-item-middle-top .card-item-middle-top-right .name{color:#eee!important}.super-chat-bubble-main .super-chat-bubble .content-top{background-color:#333!important}.super-chat-bubble-main .super-chat-bubble .content-top .content-price .sub-price{color:#aaa!important}.super-chat-bubble-main .super-chat-bubble .content-top .content-name,.super-chat-bubble-main .super-chat-bubble .content-top .content-price{color:#eee!important}.wrapper .edit-video-modal .target-favlist .target-favitem.disabled .target-fav-title .fav-meta .fav-name,.wrapper .edit-video-modal .target-favlist .target-favitem.full .target-fav-title .fav-meta .fav-name{color:#aaa!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-meta .fav-name{color:#eee!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-select{border-color:#aaa!important}.wrapper .edit-video-modal .target-favlist .target-favitem .target-fav-title .fav-select.selected{filter:var(--blue-image-filter)!important}.wrapper .edit-video-modal .target-favlist .target-favitem:hover{background-color:transparent!important}.wrapper .edit-video-modal .target-favlist .target-favitem:hover .target-fav-title .fav-meta .fav-name{color:var(--theme-color)!important}.wrapper .edit-video-modal .target-favlist .collection-mask{background-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fake-fav-input{background-color:#444!important;border-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fake-fav-input:hover{border-color:transparent!important}.wrapper .edit-video-modal .addfav-container .fav-add-tip{background-color:var(--theme-color)!important;color:#eee!important}.wrapper .edit-video-modal .addfav-container .fav-add-tip .blue-arrow{filter:var(--blue-image-filter)!important}.wrapper .edit-video-modal .addfav-container .fav-container{border-color:var(--theme-color)!important}.wrapper .edit-video-modal .addfav-container .fav-container .add-fav-input,.wrapper .edit-video-modal .addfav-container .fav-container .fav-add-btn{background-color:transparent!important;color:#eee!important;border-color:transparent!important}.wrapper .edit-video-modal .favlist-body:after{background-color:#aaa!important}#all-list .video-item.list{border-color:#444!important}#all-list .video-item.list .type{background-color:#444!important;color:#eee!important;border-color:transparent!important}#all-list .video-item.list .headline.singleav .avid{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}#all-list .video-item.list .headline.singleav .title{color:var(--theme-color)!important}#all-list .video-item.list .title{color:#eee!important}#all-list .video-item.list .title:hover{color:var(--theme-color)!important}#all-list .video-item.list .des{color:#aaa!important}#all-list .game-item .info .title{color:#eee!important}#all-list .game-item .info .title:hover{color:var(--theme-color)!important}#all-list .game-item .info .type{background-color:#444!important;color:#eee!important;border-color:transparent!important}#all-list .game-item .info .desc{color:#aaa!important}#all-list .pgc-item .v-switcher-header-wrap:before{background-color:transparent!important}#all-list .pgc-item .v-switcher-header-item{color:#eee!important}#all-list .pgc-item .v-switcher-header-item.is-active,#all-list .pgc-item .v-switcher-header-item:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}#all-list .pgc-item .v-switcher-header-item.is-active:after{filter:var(--blue-image-filter)!important}.cc-album-manage .article-card{background-color:#444!important;border-color:transparent!important}.cc-album-manage .article-card .cover-wrp{background-color:#444!important}.cc-album-manage .article-card .meta-footer .view-stat,.cc-album-manage .article-card .meta-status .description,.cc-album-manage .article-card .meta-status .pubdate{color:#aaa!important}.cc-album-manage .article-card .meta-view .delete{background-color:#333!important;color:#aaa!important}.cc-album-manage .article-card .meta-view .delete:hover{background-color:#222!important}.game-content .score-contain .page-btn{background-color:#444!important;color:#aaa!important;border-color:transparent!important}.game-content .score-contain .allmatch{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .score-contain .allmatch .more-match{background:0 0!important}.game-content .card-score .score-wrap{border-color:#444!important}.game-content .card-score .score-wrap .title .title-text{color:#aaa!important}.game-content .card-score .score-wrap .time-wrap{color:#eee!important}.game-content .card-score .score-wrap .time-wrap .text.state.nobegin{color:var(--theme-color)!important}.game-content .card-score .score-wrap .default-btn,.game-content .card-score .score-wrap .primary-btn{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .card-score .score-wrap .default-btn:hover,.game-content .card-score .score-wrap .primary-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .card-video .video-wrap .video-info .title a,.game-content .match-box .main-title,.game-content .match-box .sub-title{color:#eee!important}.game-content .match-box .card-video .video-wrap .video-info .title a:hover{color:var(--theme-color)!important}.game-content .match-box .card-video .video-wrap .video-info .detail{color:#aaa!important}.game-content .match-box .matchlist-contain .match-wrap .matchlist-title a{color:#eee!important}.game-content .match-box .matchlist-contain .match-wrap .matchlist-title a:hover{color:var(--theme-color)!important}.game-content .match-box .matchlist-contain .match-wrap .match-time{color:#aaa!important}.game-content .match-box .matchlist-contain .more-match{background-color:#444!important;color:#eee!important;border-color:transparent!important}.game-content .match-box .matchlist-contain .more-match:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-title a{color:#eee!important}.game-content .match-box .newslist-contain .news-wrap .news-title a:hover{color:var(--theme-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-title .hot-label{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.game-content .match-box .newslist-contain .news-wrap .news-time{color:#aaa!important}.game-content .match-box .user-contain .page-btn{background-color:#444!important;color:#aaa!important;border-color:transparent!important}.game-content .match-box .user-contain .primary-btn{background-color:#444!important;color:#eee!important}.game-content .match-box .user-contain .primary-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.proxy-box .manga-panel .app-download-link,.proxy-box .manga-panel .manga-list-box .manga-card .manga-tag,.proxy-box .manga-panel .tab-switch{color:#aaa!important}.proxy-box .manga-panel .app-download-link .tab-switch-item.on,.proxy-box .manga-panel .manga-list-box .manga-card .manga-tag .tab-switch-item.on,.proxy-box .manga-panel .tab-switch .tab-switch-item.on,.proxy-box .manga-rank .tab-switch .tab-switch-item.on{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.proxy-box .manga-rank .manga-rank-item .rank-number{background-color:#444!important;color:#eee!important}.proxy-box .manga-rank .manga-rank-item .rank-number.on{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.proxy-box .manga-rank .manga-rank-item a{color:#eee!important}.proxy-box .manga-rank .manga-rank-item a:hover{color:var(--theme-color)!important}.proxy-box .manga-rank .manga-rank-item .style,.proxy-box .manga-rank .manga-rank-item .update{color:#aaa!important}.buyticket .detail-info-wrapper .title{color:#eee!important}.buyticket .selectable-option{background-color:#444!important;border-color:transparent!important}.buyticket .selectable-option.unable{background-color:#111!important;color:#666!important}.buyticket .ticket-count{background-color:#444!important;border-color:transparent!important}.buyticket .product-buy-wrapper .unsale-btn{filter:var(--pink-image-filter)!important}.buyticket .product-buy-wrapper .promo-btn.remind-btn{background-color:#444!important;color:#eee!important;border-color:transparent!important}.buyticket .product-buy-wrapper .promo-btn.remind-btn:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.buyticket .modal-container .remind-title{color:#eee!important}.buyticket .modal-container .remind-tel input{background-color:#333!important;color:#eee!important;border-color:transparent!important;border-radius:4px}.buyticket .modal-container .modal-footer-btn div{background-color:#333!important;color:#eee!important;border-color:transparent!important}.buyticket .modal-container .modal-footer-btn div:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.detail-content .whole-guest-wrapper .guest-list-content .guest-left,.detail-content .whole-guest-wrapper .guest-list-content .guest-right{filter:invert(.8)!important}.detail-content .announcement-wrapper{background-color:#444!important;border-color:transparent!important}.detail-content .announcement-wrapper .announcement-icon,.detail-content .announcement-wrapper .announcement-item.active .circle{filter:var(--pink-image-filter)!important}.detail-content .activity-info-body .info-body p strong,.detail-content .activity-info-body .info-body ul li .title,.detail-content .announcement-wrapper .announcement-item-desc a,.detail-content .announcement-wrapper .announcement-item.active .announcement-item-time,.detail-content .announcement-wrapper .announcement-title{color:#eee!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active:before{filter:var(--blue-image-filter)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-active.bilibili-player-blink{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink{color:#eee!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink .bilibili-player-tips{background-color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink:active,.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list.bilibili-player-blink:hover{color:var(--theme-color)!important}.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn .bilibili-player-video-quality-menu .bilibili-player-bigvip,.bilibili-player .bilibili-player-video-control .bilibili-player-video-btn-menu-list .bilibili-player-tips{color:var(--foreground-color)!important}.publish-panel .core-style{background-color:transparent!important;color:#eee!important;border-color:transparent!important}.publish-panel .core-style:active,.publish-panel .core-style:focus-within,.publish-panel .core-style:hover{border-color:var(--theme-color)!important}.publish-panel .editor .placeholder-shown::before{color:#888!important}.publish-panel .schedule-bar{background-color:#333!important}.publish-panel .schedule-bar .dp-label,.publish-panel .schedule-bar .s-label{color:#eee!important}.publish-panel .schedule-bar .scroll-input .s-input{background-color:#222!important;color:#eee!important;border-color:transparent!important}.publish-panel .schedule-bar .s-panel{background-color:#222!important;border-color:transparent!important}.publish-panel .schedule-bar .s-panel .s-item{color:#eee!important}.publish-panel .schedule-bar .s-panel .s-item:hover{color:var(--theme-color)!important}.publish-panel .schedule-bar .calendar.active{filter:var(--blue-image-filter)!important}.publish-panel .toolbar .static-popup{background-color:#222!important;border-color:transparent!important}.publish-panel .toolbar .static-popup .title{color:#eee!important}.publish-panel .toolbar .static-popup .upload-image .upload-btn:hover{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.publish-panel .toolbar .bp-vote-container .create-vote{background-color:#222!important;color:#eee!important;border-color:transparent!important}.publish-panel .toolbar .bp-vote-container .create-vote .title{color:#eee!important}.publish-panel .toolbar .bp-vote-container .create-vote .bp-button:nth-child(2){background:var(--theme-color)!important;color:var(--foreground-color)!important}.publish-panel .toolbar .publish-launcher .indicator,.publish-panel .toolbar .publish-launcher .indicator::after{color:#aaa!important}.publish-panel .toolbar .publish-launcher .publish-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.publish-panel .toolbar .publish-launcher .publish-btn.disabled{background-color:#222!important;color:#eee!important}.publish-panel .toolbar .hash-popup{background-color:#222!important;border-color:transparent!important}.publish-panel .toolbar .hash-popup .hint{color:#aaa!important}.publish-panel .toolbar .hash-popup .topic-container .item{color:#eee!important}.publish-panel .toolbar .hash-popup .topic-container .item.is-selected{background-color:#333!important}.publish-panel .toolbar .bili-at-popup{background-color:#222!important;border-color:transparent!important}.publish-panel .toolbar .bili-at-popup__hint{color:#aaa!important}.publish-panel .toolbar .bili-at-popup__group-name{color:#eee!important}.publish-panel .toolbar .bili-at-popup__user--selected{background-color:#333!important}.publish-panel .toolbar .bili-at-popup__user-name{color:#eee!important}.publish-panel .toolbar .bili-at-popup__user-fans{color:#aaa!important}.h5share-container:hover .text-area .text{color:var(--theme-color)!important}.up-info .u-info .name .live-status{color:var(--theme-color)!important;border-color:var(--theme-color)!important}.up-info .u-info .name .live-status:hover{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.popover-video-card{background-color:#333!important}.popover-video-card .count{border-color:#444!important}.popover-video-card .content .info .subtitle,.popover-video-card .count ul li{color:#aaa!important}.popover-video-card .content .info .f-title{color:#eee!important}.v-wrap .season-info,.v-wrap .season-tabs .tabs,.v-wrap .video-toolbar{border-color:#444!important}.v-wrap .season-info .stat{color:#aaa!important}.v-wrap .season-info .desc,.v-wrap .season-info .title,.v-wrap .season-owner .info .desc,.v-wrap .season-owner .info h3 a{color:#eee!important}.v-wrap .season-detail .content-img,.v-wrap .season-detail .faq.faq,.v-wrap .season-detail .note.faq{border-color:#444!important}.message .message-content{background-color:#222!important}.message .context-menu{background-color:#444!important;color:#eee!important}.shop-panel .panel-desc{color:#eee!important}.shop-panel .panel-desc .shop-icon{filter:brightness(0) invert(1)!important}.shop-panel .shop-list{background-color:#222!important}.shop-panel .shop-list .shop-desc .desc-box .title{color:#eee!important}.shop-panel .shop-list .shop-desc .desc-box .sub-title{color:#aaa!important}.shop-panel .shop-list .shop-desc .desc-box .price-desc{color:var(--theme-color)!important}.shop-panel .shop-list .shop-desc .btn-box .jump-btn{background-color:var(--theme-color)!important;color:var(--foreground-color)!important}.shop-panel .shop-list .shop-desc .btn-box .jump-btn.checked,.shop-panel .shop-list .shop-desc .btn-box .jump-btn.disabled{background-color:#444!important}.link-navbar{background-image:none!important}.danmaku-wrap .danmaku-info-row-code{background:#ffa20011!important}.notice-item .notice-main .notice-title{color:#eee!important}.notice-item .notice-main .notice-title:before{background-color:var(--theme-color)!important}.notice-item .notice-main .notice-time{color:#aaa!important}.notice-item .notice-btn{color:#eee!important;background-color:#222!important}.recent-danmu-wrp .danmu-filter .left{border-color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .plain{color:#eee!important;border-color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .plain.disable{color:#aaa!important}.recent-danmu-wrp .danmu-filter .left .delete .option-wrp .act-btn{background-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu{background-color:#444!important;border-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu .menu-item{color:#eee!important}.recent-danmu-wrp .danmu-filter .left .option-menu .menu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-filter .left .option-menu .option-arrow{border-color:transparent!important}.recent-danmu-wrp .danmu-filter .left .option-menu .option-arrow-border{border-color:transparent transparent #444!important}.recent-danmu-wrp .danmu-container .danmu-table{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .box-header{background-color:#444!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .box-header th{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table tr:hover{background-color:#444!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item{background-color:#555!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item:nth-child(2n){background-color:#444!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content,.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-name a{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content a{color:#aaa!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-content a:hover{color:var(--theme-color)!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .act-btn{background-color:#333!important;color:#aaa!important;border-color:transparent!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .act-btn:hover{color:var(--theme-color)!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .menu-item{color:#eee!important}.recent-danmu-wrp .danmu-container .danmu-table .danmu-item .item-act .option-wrp .menu-item:hover{background-color:#333!important}.recent-danmu-wrp .danmu-container .danmu-table .bili-checkbox:checked+span:before{background-color:var(--theme-color)!important;color:var(--foreground-color)!important;border-color:transparent!important}.s-space .v-search-result{color:#aaa!important}.s-space .article-con a:hover,.s-space .v-search-count{color:var(--theme-color)!important}.tag-content .main-panel .hot-topics{background-color:#444!important}.tag-content .main-panel .hot-topics .title{border-color:transparent!important}.tag-content .main-panel .hot-topics .topic-content,.tag-content .main-panel .hot-topics .topic-header .topic-name{color:#eee!important}.tag-content .main-panel .hot-topics .topic-info{color:#aaa!important}.tag-content .main-panel .hot-topics .topic-list hr{background-color:#555!important}.international-header .nav-search #nav_searchform{background-color:#222!important}.international-header .nav-search .nav-search-keyword{color:var(--foreground-color)!important}.international-header .nav-search .nav-search-btn{background-color:#333!important}.international-header .nav-search .nav-search-btn .nav-search-submit{color:#aaa!important}.international-header .nav-search .nav-search-btn:hover .nav-search-submit{color:#eee!important}#app .header .left-block .logo{color:var(--theme-color)!important}#app .header .left-block .main-site,#app .header .right-block{color:#eee!important}#app .cc-nav-wrp,#app .header .right-block .i-frame::before{background-color:transparent!important}#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu a,#app .cc-nav-wrp .slider-bar .bar-item .bcc-nav-slider-sub-menu>span{color:#eee!important}#app .cc-nav-wrp .slide