/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class CreativeModeTab {
    private final Component f_40764_;
    String f_40766_ = "items.png";
    boolean f_40767_ = true;
    boolean f_40768_ = true;
    boolean f_257018_ = false;
    private final Row f_256931_;
    private final int f_256967_;
    private final Type f_256819_;
    @javax.annotation.Nullable
    private ItemStack f_40770_;
    private Collection<ItemStack> f_243839_ = ItemStackLinkedSet.m_261170_();
    private Set<ItemStack> f_243841_ = ItemStackLinkedSet.m_261170_();
    @javax.annotation.Nullable
    private Consumer<List<ItemStack>> f_256965_;
    private final Supplier<ItemStack> f_256912_;
    private final DisplayItemsGenerator f_256824_;
    private ResourceLocation backgroundLocation;
    private final boolean hasSearchBar;
    private final int searchBarWidth;
    private final ResourceLocation tabsImage;
    private final int labelColor;
    private final int slotColor;
    public final List<ResourceLocation> tabsBefore;
    public final List<ResourceLocation> tabsAfter;

    CreativeModeTab(Row p_260217_, int p_259557_, Type p_260176_, Component p_260100_, Supplier<ItemStack> p_259543_, DisplayItemsGenerator p_259085_, ResourceLocation backgroundLocation, boolean hasSearchBar, int searchBarWidth, ResourceLocation tabsImage, int labelColor, int slotColor, List<ResourceLocation> tabsBefore, List<ResourceLocation> tabsAfter) {
        this.f_256931_ = p_260217_;
        this.f_256967_ = p_259557_;
        this.f_40764_ = p_260100_;
        this.f_256912_ = p_259543_;
        this.f_256824_ = p_259085_;
        this.f_256819_ = p_260176_;
        this.backgroundLocation = backgroundLocation;
        this.hasSearchBar = hasSearchBar;
        this.searchBarWidth = searchBarWidth;
        this.tabsImage = tabsImage;
        this.labelColor = labelColor;
        this.slotColor = slotColor;
        this.tabsBefore = List.copyOf(tabsBefore);
        this.tabsAfter = List.copyOf(tabsAfter);
    }

    protected CreativeModeTab(Builder builder) {
        this(builder.f_256796_, builder.f_256977_, builder.f_256847_, builder.f_256856_, builder.f_256981_, builder.f_256953_, builder.backgroundLocation, builder.hasSearchBar, builder.searchBarWidth, builder.tabsImage, builder.labelColor, builder.slotColor, builder.tabsBefore, builder.tabsAfter);
    }

    public static Builder builder() {
        return new Builder(Row.TOP, 0);
    }

    @Deprecated
    public static Builder m_257815_(Row p_259342_, int p_260312_) {
        return new Builder(p_259342_, p_260312_);
    }

    public Component m_40786_() {
        return this.f_40764_;
    }

    public ItemStack m_40787_() {
        if (this.f_40770_ == null) {
            this.f_40770_ = this.f_256912_.get();
        }
        return this.f_40770_;
    }

    @Deprecated
    public String m_40788_() {
        return this.f_40766_;
    }

    public boolean m_40789_() {
        return this.f_40768_;
    }

    public boolean m_40791_() {
        return this.f_40767_;
    }

    public int m_257903_() {
        return this.f_256967_;
    }

    public Row m_258064_() {
        return this.f_256931_;
    }

    public boolean m_257905_() {
        return !this.f_243839_.isEmpty();
    }

    public boolean m_257497_() {
        return this.f_256819_ != Type.CATEGORY || this.m_257905_();
    }

    public boolean m_6563_() {
        return this.f_257018_;
    }

    public Type m_257962_() {
        return this.f_256819_;
    }

    public void m_269498_(ItemDisplayParameters p_270156_) {
        ItemDisplayBuilder creativemodetab$itemdisplaybuilder = new ItemDisplayBuilder(this, p_270156_.f_268709_);
        ResourceKey<CreativeModeTab> resourcekey = BuiltInRegistries.f_279662_.m_7854_(this).orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + this));
        ForgeHooks.onCreativeModeTabBuildContents((CreativeModeTab)this, resourcekey, (DisplayItemsGenerator)this.f_256824_, (ItemDisplayParameters)p_270156_, (Output)creativemodetab$itemdisplaybuilder);
        this.f_243839_ = creativemodetab$itemdisplaybuilder.f_244363_;
        this.f_243841_ = creativemodetab$itemdisplaybuilder.f_244585_;
        this.m_257466_();
    }

    public Collection<ItemStack> m_260957_() {
        return this.f_243839_;
    }

    public Collection<ItemStack> m_261235_() {
        return this.f_243841_;
    }

    public boolean m_257694_(ItemStack p_259317_) {
        return this.f_243841_.contains((Object)p_259317_);
    }

    public void m_257882_(Consumer<List<ItemStack>> p_259669_) {
        this.f_256965_ = p_259669_;
    }

    public void m_257466_() {
        if (this.f_256965_ != null) {
            this.f_256965_.accept(Lists.newArrayList(this.f_243841_));
        }
    }

    public ResourceLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    public boolean hasSearchBar() {
        return this.hasSearchBar;
    }

    public int getSearchBarWidth() {
        return this.searchBarWidth;
    }

    public ResourceLocation getTabsImage() {
        return this.tabsImage;
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public int getSlotColor() {
        return this.slotColor;
    }

    public static final class Row
    extends Enum<Row> {
        public static final /* enum */ Row TOP = new Row();
        public static final /* enum */ Row BOTTOM = new Row();
        private static final /* synthetic */ Row[] $VALUES;

        public static Row[] values() {
            return (Row[])$VALUES.clone();
        }

        public static Row valueOf(String p_259650_) {
            return Enum.valueOf(Row.class, p_259650_);
        }

        private static /* synthetic */ Row[] m_257616_() {
            return new Row[]{TOP, BOTTOM};
        }

        static {
            $VALUES = Row.m_257616_();
        }
    }

    @FunctionalInterface
    public static interface DisplayItemsGenerator {
        public void m_257865_(ItemDisplayParameters var1, Output var2);
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type CATEGORY = new Type();
        public static final /* enum */ Type INVENTORY = new Type();
        public static final /* enum */ Type HOTBAR = new Type();
        public static final /* enum */ Type SEARCH = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_259622_) {
            return Enum.valueOf(Type.class, p_259622_);
        }

        private static /* synthetic */ Type[] m_257818_() {
            return new Type[]{CATEGORY, INVENTORY, HOTBAR, SEARCH};
        }

        static {
            $VALUES = Type.m_257818_();
        }
    }

    public static class Builder {
        private static final DisplayItemsGenerator f_256756_ = (p_270422_, p_259433_) -> {};
        private static final ResourceLocation CREATIVE_INVENTORY_TABS_IMAGE = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
        private final Row f_256796_;
        private final int f_256977_;
        private Component f_256856_ = Component.m_237119_();
        private Supplier<ItemStack> f_256981_ = () -> ItemStack.f_41583_;
        private DisplayItemsGenerator f_256953_ = f_256756_;
        private boolean f_256992_ = true;
        private boolean f_256851_ = true;
        private boolean f_256854_ = false;
        private Type f_256847_ = Type.CATEGORY;
        private String f_257036_ = "items.png";
        @Nullable
        private ResourceLocation backgroundLocation;
        private boolean hasSearchBar = false;
        private int searchBarWidth = 89;
        private ResourceLocation tabsImage = CREATIVE_INVENTORY_TABS_IMAGE;
        private int labelColor = 0x404040;
        private int slotColor = -2130706433;
        private Function<Builder, CreativeModeTab> tabFactory = CreativeModeTab::new;
        private final List<ResourceLocation> tabsBefore = new ArrayList<ResourceLocation>();
        private final List<ResourceLocation> tabsAfter = new ArrayList<ResourceLocation>();

        public Builder(Row p_259171_, int p_259661_) {
            this.f_256796_ = p_259171_;
            this.f_256977_ = p_259661_;
        }

        public Builder m_257941_(Component p_259616_) {
            this.f_256856_ = p_259616_;
            return this;
        }

        public Builder m_257737_(Supplier<ItemStack> p_259333_) {
            this.f_256981_ = p_259333_;
            return this;
        }

        public Builder m_257501_(DisplayItemsGenerator p_259814_) {
            this.f_256953_ = p_259814_;
            return this;
        }

        public Builder m_257826_() {
            this.f_256854_ = true;
            return this;
        }

        public Builder m_257809_() {
            this.f_256851_ = false;
            return this;
        }

        public Builder m_257794_() {
            this.f_256992_ = false;
            return this;
        }

        protected Builder m_257623_(Type p_259283_) {
            this.f_256847_ = p_259283_;
            if (p_259283_ == Type.SEARCH) {
                return this.withSearchBar();
            }
            return this;
        }

        public Builder m_257609_(String p_259981_) {
            return this.withBackgroundLocation(new ResourceLocation("textures/gui/container/creative_inventory/tab_" + p_259981_));
        }

        public Builder withBackgroundLocation(ResourceLocation background) {
            this.backgroundLocation = background;
            return this;
        }

        public Builder withSearchBar() {
            this.hasSearchBar = true;
            if (this.backgroundLocation == null) {
                return this.m_257609_("item_search.png");
            }
            return this;
        }

        public Builder withSearchBar(int searchBarWidth) {
            this.searchBarWidth = searchBarWidth;
            return this.withSearchBar();
        }

        public Builder withTabsImage(ResourceLocation tabsImage) {
            this.tabsImage = tabsImage;
            return this;
        }

        public Builder withLabelColor(int labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder withSlotColor(int slotColor) {
            this.slotColor = slotColor;
            return this;
        }

        public Builder withTabFactory(Function<Builder, CreativeModeTab> tabFactory) {
            this.tabFactory = tabFactory;
            return this;
        }

        public Builder withTabsBefore(ResourceLocation ... tabs) {
            this.tabsBefore.addAll(List.of(tabs));
            return this;
        }

        public Builder withTabsAfter(ResourceLocation ... tabs) {
            this.tabsAfter.addAll(List.of(tabs));
            return this;
        }

        @SafeVarargs
        public final Builder withTabsBefore(ResourceKey<CreativeModeTab> ... tabs) {
            Stream.of(tabs).map(ResourceKey::m_135782_).forEach(this.tabsBefore::add);
            return this;
        }

        @SafeVarargs
        public final Builder withTabsAfter(ResourceKey<CreativeModeTab> ... tabs) {
            Stream.of(tabs).map(ResourceKey::m_135782_).forEach(this.tabsAfter::add);
            return this;
        }

        public CreativeModeTab m_257652_() {
            if ((this.f_256847_ == Type.HOTBAR || this.f_256847_ == Type.INVENTORY) && this.f_256953_ != f_256756_) {
                throw new IllegalStateException("Special tabs can't have display items");
            }
            CreativeModeTab creativemodetab = this.tabFactory.apply(this);
            creativemodetab.f_257018_ = this.f_256854_;
            creativemodetab.f_40768_ = this.f_256851_;
            creativemodetab.f_40767_ = this.f_256992_;
            creativemodetab.f_40766_ = this.f_257036_;
            creativemodetab.backgroundLocation = this.backgroundLocation != null ? this.backgroundLocation : new ResourceLocation("textures/gui/container/creative_inventory/tab_" + this.f_257036_);
            return creativemodetab;
        }
    }

    static class ItemDisplayBuilder
    implements Output {
        public final Collection<ItemStack> f_244363_ = ItemStackLinkedSet.m_261170_();
        public final Set<ItemStack> f_244585_ = ItemStackLinkedSet.m_261170_();
        private final CreativeModeTab f_244054_;
        private final FeatureFlagSet f_243878_;

        public ItemDisplayBuilder(CreativeModeTab p_251040_, FeatureFlagSet p_249331_) {
            this.f_244054_ = p_251040_;
            this.f_243878_ = p_249331_;
        }

        @Override
        public void m_246267_(ItemStack p_250391_, TabVisibility p_251472_) {
            boolean flag;
            if (p_250391_.m_41613_() != 1) {
                throw new IllegalArgumentException("Stack size must be exactly 1");
            }
            boolean bl = flag = this.f_244363_.contains((Object)p_250391_) && p_251472_ != TabVisibility.SEARCH_TAB_ONLY;
            if (flag) {
                throw new IllegalStateException("Accidentally adding the same item stack twice " + p_250391_.m_41611_().getString() + " to a Creative Mode Tab: " + this.f_244054_.m_40786_().getString());
            }
            if (p_250391_.m_41720_().m_245993_(this.f_243878_)) {
                switch (p_251472_) {
                    case PARENT_AND_SEARCH_TABS: {
                        this.f_244363_.add(p_250391_);
                        this.f_244585_.add(p_250391_);
                        break;
                    }
                    case PARENT_TAB_ONLY: {
                        this.f_244363_.add(p_250391_);
                        break;
                    }
                    case SEARCH_TAB_ONLY: {
                        this.f_244585_.add(p_250391_);
                    }
                }
            }
        }
    }

    public record ItemDisplayParameters(FeatureFlagSet f_268709_, boolean f_268429_, HolderLookup.Provider f_268485_) {
        public boolean m_269247_(FeatureFlagSet p_270338_, boolean p_270835_, HolderLookup.Provider p_270575_) {
            return !this.f_268709_.equals(p_270338_) || this.f_268429_ != p_270835_ || this.f_268485_ != p_270575_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemDisplayParameters.class, "enabledFeatures;hasPermissions;holders", "f_268709_", "f_268429_", "f_268485_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemDisplayParameters.class, "enabledFeatures;hasPermissions;holders", "f_268709_", "f_268429_", "f_268485_"}, this);
        }

        @Override
        public final boolean equals(Object p_270097_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemDisplayParameters.class, "enabledFeatures;hasPermissions;holders", "f_268709_", "f_268429_", "f_268485_"}, this, p_270097_);
        }
    }

    public static interface Output {
        public void m_246267_(ItemStack var1, TabVisibility var2);

        default public void m_246342_(ItemStack p_249977_) {
            this.m_246267_(p_249977_, TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        default public void m_245282_(ItemLike p_251528_, TabVisibility p_249821_) {
            this.m_246267_(new ItemStack(p_251528_), p_249821_);
        }

        default public void m_246326_(ItemLike p_248610_) {
            this.m_246267_(new ItemStack(p_248610_), TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        default public void m_246233_(Collection<ItemStack> p_251548_, TabVisibility p_252285_) {
            p_251548_.forEach(p_252337_ -> this.m_246267_((ItemStack)((Object)p_252337_), p_252285_));
        }

        default public void m_246601_(Collection<ItemStack> p_250244_) {
            this.m_246233_(p_250244_, TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static final class TabVisibility
    extends Enum<TabVisibility> {
        public static final /* enum */ TabVisibility PARENT_AND_SEARCH_TABS = new TabVisibility();
        public static final /* enum */ TabVisibility PARENT_TAB_ONLY = new TabVisibility();
        public static final /* enum */ TabVisibility SEARCH_TAB_ONLY = new TabVisibility();
        private static final /* synthetic */ TabVisibility[] $VALUES;

        public static TabVisibility[] values() {
            return (TabVisibility[])$VALUES.clone();
        }

        public static TabVisibility valueOf(String p_249186_) {
            return Enum.valueOf(TabVisibility.class, p_249186_);
        }

        private static /* synthetic */ TabVisibility[] m_246258_() {
            return new TabVisibility[]{PARENT_AND_SEARCH_TABS, PARENT_TAB_ONLY, SEARCH_TAB_ONLY};
        }

        static {
            $VALUES = TabVisibility.m_246258_();
        }
    }
}

