/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class SnowGolem
extends AbstractGolem
implements Shearable,
RangedAttackMob,
IForgeShearable {
    private static final EntityDataAccessor<Byte> f_29899_ = SynchedEntityData.m_135353_(SnowGolem.class, EntityDataSerializers.f_135027_);
    private static final byte f_149047_ = 16;
    private static final float f_149048_ = 1.7f;

    public SnowGolem(EntityType<? extends SnowGolem> p_29902_, Level p_29903_) {
        super((EntityType<? extends AbstractGolem>)p_29902_, p_29903_);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new RangedAttackGoal(this, 1.25, 20, 10.0f));
        this.f_21345_.m_25352_(2, new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.f_21345_.m_25352_(3, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, new RandomLookAroundGoal(this));
        this.f_21346_.m_25352_(1, new NearestAttackableTargetGoal<Mob>(this, Mob.class, 10, true, false, p_29932_ -> p_29932_ instanceof Enemy));
    }

    public static AttributeSupplier.Builder m_29934_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.2f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_29899_, (byte)16);
    }

    @Override
    public void m_7380_(CompoundTag p_29923_) {
        super.m_7380_(p_29923_);
        p_29923_.m_128379_("Pumpkin", this.m_29930_());
    }

    @Override
    public void m_7378_(CompoundTag p_29915_) {
        super.m_7378_(p_29915_);
        if (p_29915_.m_128441_("Pumpkin")) {
            this.m_29936_(p_29915_.m_128471_("Pumpkin"));
        }
    }

    @Override
    public boolean m_6126_() {
        return true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_263828_)) {
                this.m_6469_(this.m_269291_().m_269549_(), 1.0f);
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                return;
            }
            BlockState blockstate = Blocks.f_50125_.m_49966_();
            for (int i = 0; i < 4; ++i) {
                int j = Mth.m_14107_(this.m_20185_() + (double)((float)(i % 2 * 2 - 1) * 0.25f));
                int k = Mth.m_14107_(this.m_20186_());
                int l = Mth.m_14107_(this.m_20189_() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f));
                BlockPos blockpos = new BlockPos(j, k, l);
                if (!this.m_9236_().m_46859_(blockpos) || !blockstate.m_60710_(this.m_9236_(), blockpos)) continue;
                this.m_9236_().m_46597_(blockpos, blockstate);
                this.m_9236_().m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_(this, blockstate));
            }
        }
    }

    @Override
    public void m_6504_(LivingEntity p_29912_, float p_29913_) {
        Snowball snowball = new Snowball(this.m_9236_(), this);
        double d0 = p_29912_.m_20188_() - (double)1.1f;
        double d1 = p_29912_.m_20185_() - this.m_20185_();
        double d2 = d0 - snowball.m_20186_();
        double d3 = p_29912_.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        snowball.m_6686_(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_(snowball);
    }

    @Override
    protected float m_6431_(Pose p_29917_, EntityDimensions p_29918_) {
        return 1.7f;
    }

    @Override
    protected InteractionResult m_6071_(Player p_29920_, InteractionHand p_29921_) {
        ItemStack itemstack = p_29920_.m_21120_(p_29921_);
        return InteractionResult.PASS;
    }

    @Override
    public void m_5851_(SoundSource p_29907_) {
        this.m_9236_().m_6269_(null, this, SoundEvents.f_12480_, p_29907_, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            this.m_29936_(false);
            this.m_5552_(new ItemStack(Items.f_42047_), 1.7f);
        }
    }

    @Override
    public boolean m_6220_() {
        return this.m_6084_() && this.m_29930_();
    }

    public boolean m_29930_() {
        return (this.f_19804_.m_135370_(f_29899_) & 0x10) != 0;
    }

    public void m_29936_(boolean p_29937_) {
        byte b0 = this.f_19804_.m_135370_(f_29899_);
        if (p_29937_) {
            this.f_19804_.m_135381_(f_29899_, (byte)(b0 | 0x10));
        } else {
            this.f_19804_.m_135381_(f_29899_, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12476_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource p_29929_) {
        return SoundEvents.f_12478_;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12477_;
    }

    @Override
    public Vec3 m_7939_() {
        return new Vec3(0.0, 0.75f * this.m_20192_(), this.m_20205_() * 0.4f);
    }

    public boolean isShearable(@NotNull ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, this, SoundEvents.f_12480_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, player);
        if (!world.m_5776_()) {
            this.m_29936_(false);
            return Collections.singletonList(new ItemStack(Items.f_42047_));
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void m_29908_(InteractionHand p_29909_, Player p_29910_) {
        p_29910_.m_21190_(p_29909_);
    }
}

